/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflateChannel
implements ReadableByteChannel {
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer;
    private final Inflater inflater = new Inflater(true);

    public InflateChannel(ReadableByteChannel channel, ByteBuffer buffer) throws IllegalArgumentException {
        this.channel = channel;
        this.buffer = buffer;
        if (!buffer.hasArray()) {
            throw new IllegalArgumentException("ByteBuffer must be array-backed and writable");
        }
    }

    @Override
    public int read(ByteBuffer dest) throws IOException {
        if (this.inflater.finished()) {
            return -1;
        }
        if (this.inflater.needsInput()) {
            if (!this.buffer.hasRemaining()) {
                this.buffer.compact();
                this.channel.read(this.buffer);
                this.buffer.flip();
            }
            this.inflater.setInput(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining());
        }
        try {
            int n = this.inflater.inflate(dest.array(), dest.arrayOffset() + dest.position(), dest.remaining());
            dest.position(dest.position() + n);
            int newBufferPosition = this.buffer.limit() - this.inflater.getRemaining();
            this.buffer.position(newBufferPosition);
            return n;
        }
        catch (DataFormatException e) {
            throw new ZipException(e.getMessage());
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

