/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.jackrabbit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.servlet.AbstractRepositoryServlet;

public class JackrabbitRepositoryServlet
extends AbstractRepositoryServlet {
    private static final long serialVersionUID = 7102770011290708450L;
    private RepositoryContext context;

    @Override
    public void init() throws ServletException {
        try {
            File config;
            File home = new File(this.getInitParameter("repository.home", "jackrabbit-repository"));
            if (!home.exists()) {
                this.log("Creating repository home directory: " + String.valueOf(home));
                home.mkdirs();
            }
            if (!(config = new File(this.getInitParameter("repository.config", new File(home, "repository.xml").getPath()))).exists()) {
                this.log("Creating default repository configuration: " + String.valueOf(config));
                this.createDefaultConfiguration(config);
            }
            this.context = RepositoryContext.create((RepositoryConfig)RepositoryConfig.create((URI)config.toURI(), (String)home.getPath()));
            String name = RepositoryContext.class.getName();
            this.getServletContext().setAttribute(this.getInitParameter(name, name), (Object)this.context);
        }
        catch (RepositoryException e) {
            throw new ServletException("Failed to start Jackrabbit", (Throwable)e);
        }
        super.init();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.context.getRepository().shutdown();
    }

    @Override
    protected Repository getRepository() {
        return this.context.getRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultConfiguration(File config) throws ServletException {
        try (FileOutputStream output = new FileOutputStream(config);
             InputStream input = RepositoryImpl.class.getResourceAsStream("repository.xml");){
            byte[] buffer = new byte[8192];
            int n = input.read(buffer);
            while (n != -1) {
                ((OutputStream)output).write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new ServletException("Failed to copy default configuration: " + String.valueOf(config), (Throwable)e);
        }
    }
}

