/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStateReferenceCache
implements ItemStateCache {
    private static final Logger log = LoggerFactory.getLogger(ItemStateReferenceCache.class);
    private static int NUMBER_OF_SEGMENTS = Runtime.getRuntime().availableProcessors();
    private final ItemStateCache cache;
    private final Map<ItemId, ItemState>[] segments;

    public ItemStateReferenceCache(ItemStateCacheFactory cacheFactory) {
        this(cacheFactory.newItemStateCache());
    }

    public ItemStateReferenceCache(ItemStateCache cache) {
        this.cache = cache;
        this.segments = new Map[NUMBER_OF_SEGMENTS];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
        }
    }

    private Map<ItemId, ItemState> getSegment(ItemId id) {
        return this.segments[(id.hashCode() >>> 1) % this.segments.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCached(ItemId id) {
        Map<ItemId, ItemState> segment;
        Map<ItemId, ItemState> map = segment = this.getSegment(id);
        synchronized (map) {
            return segment.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemState retrieve(ItemId id) {
        Map<ItemId, ItemState> segment;
        ItemState state = this.cache.retrieve(id);
        if (state != null) {
            return state;
        }
        Map<ItemId, ItemState> map = segment = this.getSegment(id);
        synchronized (map) {
            return segment.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemState[] retrieveAll() {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (int i = 0; i < this.segments.length; ++i) {
            Map<ItemId, ItemState> map = this.segments[i];
            synchronized (map) {
                states.addAll(this.segments[i].values());
                continue;
            }
        }
        return states.toArray(new ItemState[states.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(ItemState state) {
        Map<ItemId, ItemState> segment;
        this.cache.cache(state);
        ItemId id = state.getId();
        Map<ItemId, ItemState> map = segment = this.getSegment(id);
        synchronized (map) {
            ItemState s = segment.put(id, state);
            if (s != null && s != state) {
                log.warn("overwriting cached entry " + String.valueOf(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict(ItemId id) {
        Map<ItemId, ItemState> segment;
        this.cache.evict(id);
        Map<ItemId, ItemState> map = segment = this.getSegment(id);
        synchronized (map) {
            segment.remove(id);
        }
    }

    @Override
    public void dispose() {
        this.cache.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictAll() {
        this.cache.evictAll();
        for (int i = 0; i < this.segments.length; ++i) {
            Map<ItemId, ItemState> map = this.segments[i];
            synchronized (map) {
                this.segments[i].clear();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.segments.length; ++i) {
            Map<ItemId, ItemState> map = this.segments[i];
            synchronized (map) {
                if (!this.segments[i].isEmpty()) {
                    return false;
                }
                continue;
            }
        }
        return true;
    }
}

