/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.db.SimpleDbPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DerbyPersistenceManager
extends SimpleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(DerbyPersistenceManager.class);
    protected boolean shutdownOnClose;

    public DerbyPersistenceManager() {
        this.schema = "derby";
        this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.schemaObjectPrefix = "";
        this.shutdownOnClose = true;
    }

    public boolean getShutdownOnClose() {
        return this.shutdownOnClose;
    }

    public void setShutdownOnClose(boolean shutdownOnClose) {
        this.shutdownOnClose = shutdownOnClose;
    }

    @Override
    protected void closeConnection(Connection connection) throws SQLException {
        Object url;
        try {
            url = connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            log.debug("failed to retrieve connection url: embedded db probably already shut down", (Throwable)e);
            return;
        }
        int pos = ((String)url).lastIndexOf(59);
        if (pos != -1) {
            url = ((String)url).substring(0, pos);
        }
        url = (String)url + ";shutdown=true";
        connection.setAutoCommit(true);
        connection.close();
        if (this.shutdownOnClose) {
            try {
                DriverManager.getConnection((String)url);
            }
            catch (SQLException e) {
                log.info(e.getMessage());
            }
        }
    }
}

