/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net;

import java.util.Arrays;
import java.util.List;
import zmq.socket.Sockets;

public enum NetProtocol {
    inproc(true, new Sockets[0]),
    ipc(true, new Sockets[0]),
    tcp(true, new Sockets[0]),
    pgm(false, Sockets.PUB, Sockets.SUB, Sockets.XPUB, Sockets.XPUB),
    epgm(false, Sockets.PUB, Sockets.SUB, Sockets.XPUB, Sockets.XPUB),
    tipc(false, new Sockets[0]),
    norm(false, new Sockets[0]);

    public final boolean valid;
    private List<Sockets> compatibles;

    private NetProtocol(boolean implemented, Sockets ... compatibles) {
        this.valid = implemented;
        this.compatibles = Arrays.asList(compatibles);
    }

    public static NetProtocol getProtocol(String protocol) {
        for (NetProtocol candidate : NetProtocol.values()) {
            if (!candidate.name().equals(protocol)) continue;
            return candidate;
        }
        return null;
    }

    public final boolean compatible(int type) {
        return this.compatibles.isEmpty() || this.compatibles.contains((Object)Sockets.fromType(type));
    }
}

