/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.1
// source: kv.proto

package kv

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// KvServiceClient is the client API for KvService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type KvServiceClient interface {
	Put(ctx context.Context, in *Kv, opts ...grpc.CallOption) (*KvResponse, error)
	Get(ctx context.Context, in *K, opts ...grpc.CallOption) (*KResponse, error)
	Delete(ctx context.Context, in *K, opts ...grpc.CallOption) (*KvResponse, error)
	DeletePrefix(ctx context.Context, in *K, opts ...grpc.CallOption) (*KvResponse, error)
	ScanPrefix(ctx context.Context, in *K, opts ...grpc.CallOption) (*ScanPrefixResponse, error)
	Watch(ctx context.Context, in *WatchRequest, opts ...grpc.CallOption) (KvService_WatchClient, error)
	WatchPrefix(ctx context.Context, in *WatchRequest, opts ...grpc.CallOption) (KvService_WatchPrefixClient, error)
	Lock(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error)
	LockWithoutReentrant(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error)
	Unlock(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error)
	KeepAlive(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error)
	IsLocked(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error)
	PutTTL(ctx context.Context, in *TTLRequest, opts ...grpc.CallOption) (*TTLResponse, error)
	KeepTTLAlive(ctx context.Context, in *TTLRequest, opts ...grpc.CallOption) (*TTLResponse, error)
}

type kvServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewKvServiceClient(cc grpc.ClientConnInterface) KvServiceClient {
	return &kvServiceClient{cc}
}

func (c *kvServiceClient) Put(ctx context.Context, in *Kv, opts ...grpc.CallOption) (*KvResponse, error) {
	out := new(KvResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/put", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) Get(ctx context.Context, in *K, opts ...grpc.CallOption) (*KResponse, error) {
	out := new(KResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/get", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) Delete(ctx context.Context, in *K, opts ...grpc.CallOption) (*KvResponse, error) {
	out := new(KvResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) DeletePrefix(ctx context.Context, in *K, opts ...grpc.CallOption) (*KvResponse, error) {
	out := new(KvResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/deletePrefix", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) ScanPrefix(ctx context.Context, in *K, opts ...grpc.CallOption) (*ScanPrefixResponse, error) {
	out := new(ScanPrefixResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/scanPrefix", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) Watch(ctx context.Context, in *WatchRequest, opts ...grpc.CallOption) (KvService_WatchClient, error) {
	stream, err := c.cc.NewStream(ctx, &KvService_ServiceDesc.Streams[0], "/kv.KvService/watch", opts...)
	if err != nil {
		return nil, err
	}
	x := &kvServiceWatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type KvService_WatchClient interface {
	Recv() (*WatchResponse, error)
	grpc.ClientStream
}

type kvServiceWatchClient struct {
	grpc.ClientStream
}

func (x *kvServiceWatchClient) Recv() (*WatchResponse, error) {
	m := new(WatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *kvServiceClient) WatchPrefix(ctx context.Context, in *WatchRequest, opts ...grpc.CallOption) (KvService_WatchPrefixClient, error) {
	stream, err := c.cc.NewStream(ctx, &KvService_ServiceDesc.Streams[1], "/kv.KvService/watchPrefix", opts...)
	if err != nil {
		return nil, err
	}
	x := &kvServiceWatchPrefixClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type KvService_WatchPrefixClient interface {
	Recv() (*WatchResponse, error)
	grpc.ClientStream
}

type kvServiceWatchPrefixClient struct {
	grpc.ClientStream
}

func (x *kvServiceWatchPrefixClient) Recv() (*WatchResponse, error) {
	m := new(WatchResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *kvServiceClient) Lock(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error) {
	out := new(LockResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/lock", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) LockWithoutReentrant(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error) {
	out := new(LockResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/lockWithoutReentrant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) Unlock(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error) {
	out := new(LockResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/unlock", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) KeepAlive(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error) {
	out := new(LockResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/keepAlive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) IsLocked(ctx context.Context, in *LockRequest, opts ...grpc.CallOption) (*LockResponse, error) {
	out := new(LockResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/isLocked", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) PutTTL(ctx context.Context, in *TTLRequest, opts ...grpc.CallOption) (*TTLResponse, error) {
	out := new(TTLResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/putTTL", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *kvServiceClient) KeepTTLAlive(ctx context.Context, in *TTLRequest, opts ...grpc.CallOption) (*TTLResponse, error) {
	out := new(TTLResponse)
	err := c.cc.Invoke(ctx, "/kv.KvService/keepTTLAlive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KvServiceServer is the server API for KvService service.
// All implementations must embed UnimplementedKvServiceServer
// for forward compatibility
type KvServiceServer interface {
	Put(context.Context, *Kv) (*KvResponse, error)
	Get(context.Context, *K) (*KResponse, error)
	Delete(context.Context, *K) (*KvResponse, error)
	DeletePrefix(context.Context, *K) (*KvResponse, error)
	ScanPrefix(context.Context, *K) (*ScanPrefixResponse, error)
	Watch(*WatchRequest, KvService_WatchServer) error
	WatchPrefix(*WatchRequest, KvService_WatchPrefixServer) error
	Lock(context.Context, *LockRequest) (*LockResponse, error)
	LockWithoutReentrant(context.Context, *LockRequest) (*LockResponse, error)
	Unlock(context.Context, *LockRequest) (*LockResponse, error)
	KeepAlive(context.Context, *LockRequest) (*LockResponse, error)
	IsLocked(context.Context, *LockRequest) (*LockResponse, error)
	PutTTL(context.Context, *TTLRequest) (*TTLResponse, error)
	KeepTTLAlive(context.Context, *TTLRequest) (*TTLResponse, error)
	mustEmbedUnimplementedKvServiceServer()
}

// UnimplementedKvServiceServer must be embedded to have forward compatible implementations.
type UnimplementedKvServiceServer struct {
}

func (UnimplementedKvServiceServer) Put(context.Context, *Kv) (*KvResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Put not implemented")
}
func (UnimplementedKvServiceServer) Get(context.Context, *K) (*KResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedKvServiceServer) Delete(context.Context, *K) (*KvResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedKvServiceServer) DeletePrefix(context.Context, *K) (*KvResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrefix not implemented")
}
func (UnimplementedKvServiceServer) ScanPrefix(context.Context, *K) (*ScanPrefixResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ScanPrefix not implemented")
}
func (UnimplementedKvServiceServer) Watch(*WatchRequest, KvService_WatchServer) error {
	return status.Errorf(codes.Unimplemented, "method Watch not implemented")
}
func (UnimplementedKvServiceServer) WatchPrefix(*WatchRequest, KvService_WatchPrefixServer) error {
	return status.Errorf(codes.Unimplemented, "method WatchPrefix not implemented")
}
func (UnimplementedKvServiceServer) Lock(context.Context, *LockRequest) (*LockResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Lock not implemented")
}
func (UnimplementedKvServiceServer) LockWithoutReentrant(context.Context, *LockRequest) (*LockResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LockWithoutReentrant not implemented")
}
func (UnimplementedKvServiceServer) Unlock(context.Context, *LockRequest) (*LockResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Unlock not implemented")
}
func (UnimplementedKvServiceServer) KeepAlive(context.Context, *LockRequest) (*LockResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method KeepAlive not implemented")
}
func (UnimplementedKvServiceServer) IsLocked(context.Context, *LockRequest) (*LockResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsLocked not implemented")
}
func (UnimplementedKvServiceServer) PutTTL(context.Context, *TTLRequest) (*TTLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PutTTL not implemented")
}
func (UnimplementedKvServiceServer) KeepTTLAlive(context.Context, *TTLRequest) (*TTLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method KeepTTLAlive not implemented")
}
func (UnimplementedKvServiceServer) mustEmbedUnimplementedKvServiceServer() {}

// UnsafeKvServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to KvServiceServer will
// result in compilation errors.
type UnsafeKvServiceServer interface {
	mustEmbedUnimplementedKvServiceServer()
}

func RegisterKvServiceServer(s grpc.ServiceRegistrar, srv KvServiceServer) {
	s.RegisterService(&KvService_ServiceDesc, srv)
}

func _KvService_Put_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Kv)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).Put(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/put",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).Put(ctx, req.(*Kv))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(K)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/get",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).Get(ctx, req.(*K))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(K)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).Delete(ctx, req.(*K))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_DeletePrefix_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(K)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).DeletePrefix(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/deletePrefix",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).DeletePrefix(ctx, req.(*K))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_ScanPrefix_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(K)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).ScanPrefix(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/scanPrefix",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).ScanPrefix(ctx, req.(*K))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_Watch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(KvServiceServer).Watch(m, &kvServiceWatchServer{stream})
}

type KvService_WatchServer interface {
	Send(*WatchResponse) error
	grpc.ServerStream
}

type kvServiceWatchServer struct {
	grpc.ServerStream
}

func (x *kvServiceWatchServer) Send(m *WatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _KvService_WatchPrefix_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(KvServiceServer).WatchPrefix(m, &kvServiceWatchPrefixServer{stream})
}

type KvService_WatchPrefixServer interface {
	Send(*WatchResponse) error
	grpc.ServerStream
}

type kvServiceWatchPrefixServer struct {
	grpc.ServerStream
}

func (x *kvServiceWatchPrefixServer) Send(m *WatchResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _KvService_Lock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).Lock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/lock",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).Lock(ctx, req.(*LockRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_LockWithoutReentrant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).LockWithoutReentrant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/lockWithoutReentrant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).LockWithoutReentrant(ctx, req.(*LockRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_Unlock_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).Unlock(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/unlock",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).Unlock(ctx, req.(*LockRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_KeepAlive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).KeepAlive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/keepAlive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).KeepAlive(ctx, req.(*LockRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_IsLocked_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).IsLocked(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/isLocked",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).IsLocked(ctx, req.(*LockRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_PutTTL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TTLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).PutTTL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/putTTL",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).PutTTL(ctx, req.(*TTLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KvService_KeepTTLAlive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TTLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KvServiceServer).KeepTTLAlive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/kv.KvService/keepTTLAlive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KvServiceServer).KeepTTLAlive(ctx, req.(*TTLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// KvService_ServiceDesc is the grpc.ServiceDesc for KvService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var KvService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "kv.KvService",
	HandlerType: (*KvServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "put",
			Handler:    _KvService_Put_Handler,
		},
		{
			MethodName: "get",
			Handler:    _KvService_Get_Handler,
		},
		{
			MethodName: "delete",
			Handler:    _KvService_Delete_Handler,
		},
		{
			MethodName: "deletePrefix",
			Handler:    _KvService_DeletePrefix_Handler,
		},
		{
			MethodName: "scanPrefix",
			Handler:    _KvService_ScanPrefix_Handler,
		},
		{
			MethodName: "lock",
			Handler:    _KvService_Lock_Handler,
		},
		{
			MethodName: "lockWithoutReentrant",
			Handler:    _KvService_LockWithoutReentrant_Handler,
		},
		{
			MethodName: "unlock",
			Handler:    _KvService_Unlock_Handler,
		},
		{
			MethodName: "keepAlive",
			Handler:    _KvService_KeepAlive_Handler,
		},
		{
			MethodName: "isLocked",
			Handler:    _KvService_IsLocked_Handler,
		},
		{
			MethodName: "putTTL",
			Handler:    _KvService_PutTTL_Handler,
		},
		{
			MethodName: "keepTTLAlive",
			Handler:    _KvService_KeepTTLAlive_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "watch",
			Handler:       _KvService_Watch_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "watchPrefix",
			Handler:       _KvService_WatchPrefix_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "kv.proto",
}
