package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import org.apache.baremaps.ogcapi.model.CrsOneOfOneOf;
import org.apache.baremaps.ogcapi.model.CrsOneOfOneOf1;
import org.apache.baremaps.ogcapi.model.CrsOneOfOneOf2;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("crs_oneOf")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class CrsOneOf   {
  private @Valid URI uri;
  private @Valid Object wkt;
  private @Valid Object referenceSystem;

  /**
   * Reference to one coordinate reference system (CRS)
   **/
  public CrsOneOf uri(URI uri) {
    this.uri = uri;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Reference to one coordinate reference system (CRS)")
  @JsonProperty("uri")
  @NotNull
  public URI getUri() {
    return uri;
  }

  @JsonProperty("uri")
  public void setUri(URI uri) {
    this.uri = uri;
  }

  /**
   **/
  public CrsOneOf wkt(Object wkt) {
    this.wkt = wkt;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("wkt")
  @NotNull
  public Object getWkt() {
    return wkt;
  }

  @JsonProperty("wkt")
  public void setWkt(Object wkt) {
    this.wkt = wkt;
  }

  /**
   * A reference system data structure as defined in the MD_ReferenceSystem of the ISO 19115
   **/
  public CrsOneOf referenceSystem(Object referenceSystem) {
    this.referenceSystem = referenceSystem;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "A reference system data structure as defined in the MD_ReferenceSystem of the ISO 19115")
  @JsonProperty("referenceSystem")
  @NotNull
  public Object getReferenceSystem() {
    return referenceSystem;
  }

  @JsonProperty("referenceSystem")
  public void setReferenceSystem(Object referenceSystem) {
    this.referenceSystem = referenceSystem;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrsOneOf crsOneOf = (CrsOneOf) o;
    return Objects.equals(this.uri, crsOneOf.uri) &&
        Objects.equals(this.wkt, crsOneOf.wkt) &&
        Objects.equals(this.referenceSystem, crsOneOf.referenceSystem);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uri, wkt, referenceSystem);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrsOneOf {\n");
    
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    wkt: ").append(toIndentedString(wkt)).append("\n");
    sb.append("    referenceSystem: ").append(toIndentedString(referenceSystem)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

