package org.apache.baremaps.ogcapi.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.Crs;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Minimum bounding rectangle surrounding a 2D resource in the CRS indicated elsewhere
 **/
@ApiModel(description = "Minimum bounding rectangle surrounding a 2D resource in the CRS indicated elsewhere")
@JsonTypeName("BoundingBox2D")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class BoundingBox2D   {
  private @Valid List<BigDecimal> lowerLeft = new ArrayList<>();
  private @Valid List<BigDecimal> upperRight = new ArrayList<>();
  private @Valid Crs crs;
  private @Valid List<String> orderedAxes = null;

  /**
   * A 2D Point in the CRS indicated elsewhere
   **/
  public BoundingBox2D lowerLeft(List<BigDecimal> lowerLeft) {
    this.lowerLeft = lowerLeft;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "A 2D Point in the CRS indicated elsewhere")
  @JsonProperty("lowerLeft")
  @NotNull
 @Size(min=2,max=2)  public List<BigDecimal> getLowerLeft() {
    return lowerLeft;
  }

  @JsonProperty("lowerLeft")
  public void setLowerLeft(List<BigDecimal> lowerLeft) {
    this.lowerLeft = lowerLeft;
  }

  public BoundingBox2D addLowerLeftItem(BigDecimal lowerLeftItem) {
    if (this.lowerLeft == null) {
      this.lowerLeft = new ArrayList<>();
    }

    this.lowerLeft.add(lowerLeftItem);
    return this;
  }

  public BoundingBox2D removeLowerLeftItem(BigDecimal lowerLeftItem) {
    if (lowerLeftItem != null && this.lowerLeft != null) {
      this.lowerLeft.remove(lowerLeftItem);
    }

    return this;
  }
  /**
   * A 2D Point in the CRS indicated elsewhere
   **/
  public BoundingBox2D upperRight(List<BigDecimal> upperRight) {
    this.upperRight = upperRight;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "A 2D Point in the CRS indicated elsewhere")
  @JsonProperty("upperRight")
  @NotNull
 @Size(min=2,max=2)  public List<BigDecimal> getUpperRight() {
    return upperRight;
  }

  @JsonProperty("upperRight")
  public void setUpperRight(List<BigDecimal> upperRight) {
    this.upperRight = upperRight;
  }

  public BoundingBox2D addUpperRightItem(BigDecimal upperRightItem) {
    if (this.upperRight == null) {
      this.upperRight = new ArrayList<>();
    }

    this.upperRight.add(upperRightItem);
    return this;
  }

  public BoundingBox2D removeUpperRightItem(BigDecimal upperRightItem) {
    if (upperRightItem != null && this.upperRight != null) {
      this.upperRight.remove(upperRightItem);
    }

    return this;
  }
  /**
   **/
  public BoundingBox2D crs(Crs crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("crs")
  public Crs getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(Crs crs) {
    this.crs = crs;
  }

  /**
   **/
  public BoundingBox2D orderedAxes(List<String> orderedAxes) {
    this.orderedAxes = orderedAxes;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("orderedAxes")
 @Size(min=2,max=2)  public List<String> getOrderedAxes() {
    return orderedAxes;
  }

  @JsonProperty("orderedAxes")
  public void setOrderedAxes(List<String> orderedAxes) {
    this.orderedAxes = orderedAxes;
  }

  public BoundingBox2D addOrderedAxesItem(String orderedAxesItem) {
    if (this.orderedAxes == null) {
      this.orderedAxes = new ArrayList<>();
    }

    this.orderedAxes.add(orderedAxesItem);
    return this;
  }

  public BoundingBox2D removeOrderedAxesItem(String orderedAxesItem) {
    if (orderedAxesItem != null && this.orderedAxes != null) {
      this.orderedAxes.remove(orderedAxesItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BoundingBox2D boundingBox2D = (BoundingBox2D) o;
    return Objects.equals(this.lowerLeft, boundingBox2D.lowerLeft) &&
        Objects.equals(this.upperRight, boundingBox2D.upperRight) &&
        Objects.equals(this.crs, boundingBox2D.crs) &&
        Objects.equals(this.orderedAxes, boundingBox2D.orderedAxes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lowerLeft, upperRight, crs, orderedAxes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BoundingBox2D {\n");
    
    sb.append("    lowerLeft: ").append(toIndentedString(lowerLeft)).append("\n");
    sb.append("    upperRight: ").append(toIndentedString(upperRight)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    orderedAxes: ").append(toIndentedString(orderedAxes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

