package org.apache.baremaps.ogcapi.api;

import org.apache.baremaps.ogcapi.model.MbStyle;
import org.apache.baremaps.ogcapi.model.StyleMetadata;
import org.apache.baremaps.ogcapi.model.StyleSet;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;

import io.swagger.annotations.*;

import java.io.InputStream;
import java.util.Map;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/styles")
@Api(description = "the styles API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public interface StylesApi {

    @GET
    @Path("/{styleId}")
    @Produces({ "application/vnd.mapbox.style+json", "application/json" })
    @ApiOperation(value = "fetch a style by id", notes = "Fetches the style with identifier `styleId`. The set of  available styles can be retrieved at `/styles`.  Not all styles are available in all style encodings.", tags={ "Styles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The style", response = MbStyle.class),
        @ApiResponse(code = 404, message = "style not found", response = Void.class),
        @ApiResponse(code = 406, message = "The requested style encoding is not supported  for this style", response = Void.class) })
    Response getStyle(@PathParam("styleId") @ApiParam("Local identifier of a style. \\ A list of all available styles can be found  under the /styles path.") String styleId);

    @GET
    @Path("/{styleId}/metadata")
    @Produces({ "application/json" })
    @ApiOperation(value = "fetch the metadata about a style", notes = "Style metadata is essential information about a style in order to support users to discover and select styles for rendering their data and for visual style editors  to create user interfaces for editing a style.  This operations returns the metadata for the requested style as a single document.  The stylesheet of the style will typically include some the metadata, too.", tags={ "Styles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "The metdata for the style.", response = StyleMetadata.class),
        @ApiResponse(code = 404, message = "style not found", response = Void.class) })
    Response getStyleMetadata(@PathParam("styleId") @ApiParam("Local identifier of a style. \\ A list of all available styles can be found  under the /styles path.") String styleId);

    @GET
    @Produces({ "application/json" })
    @ApiOperation(value = "information about the available styles", notes = "This operation fetches the set of styles available. For each style the id, a title, links to the stylesheet of the style in each supported encoding, and the link to the  metadata is provided.  Testbed-15 only requires support for a small number of the styles. Therefore, the currently simple approach is sufficient, but in general the operation should support paging (using a  parameter `limit` and links to the `next` page in responses).", tags={ "Styles" })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "the set of available styles", response = StyleSet.class),
        @ApiResponse(code = 400, message = "invalid or unknown query parameters", response = Void.class),
        @ApiResponse(code = 406, message = "The media types accepted by the client are not  supported for this resource", response = Void.class) })
    Response getStyleSet();
}
