/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mil.nga.crs.CRSException;
import mil.nga.crs.CRSType;
import mil.nga.crs.CoordinateReferenceSystem;
import mil.nga.crs.SimpleCoordinateReferenceSystem;

public class CompoundCoordinateReferenceSystem
extends CoordinateReferenceSystem {
    private List<SimpleCoordinateReferenceSystem> coordinateReferenceSystems = new ArrayList<SimpleCoordinateReferenceSystem>();

    public CompoundCoordinateReferenceSystem() {
        super(CRSType.COMPOUND);
    }

    public CompoundCoordinateReferenceSystem(String name, CRSType type) {
        super(name, type);
    }

    public List<SimpleCoordinateReferenceSystem> getCoordinateReferenceSystems() {
        return Collections.unmodifiableList(this.coordinateReferenceSystems);
    }

    public int numCoordinateReferenceSystems() {
        return this.coordinateReferenceSystems.size();
    }

    public SimpleCoordinateReferenceSystem getCoordinateReferenceSystem(int index) {
        return this.coordinateReferenceSystems.get(index);
    }

    public void setCoordinateReferenceSystems(List<SimpleCoordinateReferenceSystem> coordinateReferenceSystems) {
        this.coordinateReferenceSystems.clear();
        this.addCoordinateReferenceSystems(coordinateReferenceSystems);
    }

    public void addCoordinateReferenceSystem(SimpleCoordinateReferenceSystem crs) {
        switch (crs.getType()) {
            case GEODETIC: 
            case GEOGRAPHIC: 
            case PROJECTED: 
            case VERTICAL: 
            case ENGINEERING: 
            case PARAMETRIC: 
            case TEMPORAL: 
            case DERIVED: {
                this.coordinateReferenceSystems.add(crs);
                break;
            }
            default: {
                throw new CRSException("Unsupported Compound Coordinate Reference System Type: " + crs.getType());
            }
        }
    }

    public void addCoordinateReferenceSystems(List<SimpleCoordinateReferenceSystem> crss) {
        for (SimpleCoordinateReferenceSystem crs : crss) {
            this.addCoordinateReferenceSystem(crs);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.coordinateReferenceSystems == null ? 0 : this.coordinateReferenceSystems.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundCoordinateReferenceSystem other = (CompoundCoordinateReferenceSystem)obj;
        return !(this.coordinateReferenceSystems == null ? other.coordinateReferenceSystems != null : !this.coordinateReferenceSystems.equals(other.coordinateReferenceSystems));
    }
}

