/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.jackson2;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jdbi.v3.core.config.JdbiConfig;

public class Jackson2Config
implements JdbiConfig<Jackson2Config> {
    private ObjectMapper mapper;
    private Class<?> serializationView;
    private Class<?> deserializationView;

    public Jackson2Config() {
        this.mapper = new ObjectMapper();
    }

    private Jackson2Config(Jackson2Config other) {
        this.mapper = other.mapper;
        this.serializationView = other.serializationView;
        this.deserializationView = other.deserializationView;
    }

    public Jackson2Config setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public Jackson2Config setView(Class<?> view) {
        return this.setSerializationView(view).setDeserializationView(view);
    }

    public Jackson2Config setSerializationView(Class<?> serializationView) {
        this.serializationView = serializationView;
        return this;
    }

    public Class<?> getSerializationView() {
        return this.serializationView;
    }

    public Jackson2Config setDeserializationView(Class<?> deserializationView) {
        this.deserializationView = deserializationView;
        return this;
    }

    public Class<?> getDeserializationView() {
        return this.deserializationView;
    }

    public Jackson2Config createCopy() {
        return new Jackson2Config(this);
    }
}

