/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpDeserializer;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpSetCookie;
import io.servicetalk.http.api.HttpStreamingDeserializer;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.TrailersTransformer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public interface StreamingHttpResponse
extends HttpResponseMetaData {
    public Publisher<Buffer> payloadBody();

    @Deprecated
    default public <T> Publisher<T> payloadBody(HttpDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody());
    }

    public <T> Publisher<T> payloadBody(HttpStreamingDeserializer<T> var1);

    public Publisher<Object> messageBody();

    public StreamingHttpResponse payloadBody(Publisher<Buffer> var1);

    @Deprecated
    default public <T> StreamingHttpResponse payloadBody(Publisher<T> payloadBody, HttpSerializer<T> serializer) {
        throw new UnsupportedOperationException("StreamingHttpResponse#payloadBody(Publisher, HttpSerializer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to StreamingHttpResponse#payloadBody(Publisher, HttpStreamingSerializer) or implement this method if it's required temporarily.");
    }

    public <T> StreamingHttpResponse payloadBody(Publisher<T> var1, HttpStreamingSerializer<T> var2);

    @Deprecated
    default public <T> StreamingHttpResponse transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpSerializer<T> serializer) {
        throw new UnsupportedOperationException("StreamingHttpResponse#transformPayloadBody(Function, HttpSerializer) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to StreamingHttpResponse#transformPayloadBody(Function, HttpStreamingSerializer) or implement this method if it's required temporarily.");
    }

    public <T> StreamingHttpResponse transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> var1, HttpStreamingSerializer<T> var2);

    @Deprecated
    default public <T, R> StreamingHttpResponse transformPayloadBody(Function<Publisher<T>, Publisher<R>> transformer, HttpDeserializer<T> deserializer, HttpSerializer<R> serializer) {
        return this.transformPayloadBody((Publisher<Buffer> bufferPublisher) -> (Publisher)transformer.apply(deserializer.deserialize(this.headers(), (Publisher<Buffer>)bufferPublisher)), serializer);
    }

    public <T, R> StreamingHttpResponse transformPayloadBody(Function<Publisher<T>, Publisher<R>> var1, HttpStreamingDeserializer<T> var2, HttpStreamingSerializer<R> var3);

    public StreamingHttpResponse transformPayloadBody(UnaryOperator<Publisher<Buffer>> var1);

    public StreamingHttpResponse transformMessageBody(UnaryOperator<Publisher<?>> var1);

    public <T> StreamingHttpResponse transform(TrailersTransformer<T, Buffer> var1);

    public <T, S> StreamingHttpResponse transform(TrailersTransformer<T, S> var1, HttpStreamingDeserializer<S> var2);

    public Single<HttpResponse> toResponse();

    public BlockingStreamingHttpResponse toBlockingStreamingResponse();

    @Override
    public StreamingHttpResponse version(HttpProtocolVersion var1);

    @Override
    @Deprecated
    default public StreamingHttpResponse encoding(ContentCodec encoding) {
        throw new UnsupportedOperationException("StreamingHttpResponse#encoding(ContentCodec) is not supported by " + this.getClass() + ". This method is deprecated, consider migrating to provided alternatives or implement this method if it's required temporarily.");
    }

    @Override
    default public StreamingHttpResponse addHeader(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addHeader(name, value);
        return this;
    }

    @Override
    default public StreamingHttpResponse addHeaders(HttpHeaders headers) {
        HttpResponseMetaData.super.addHeaders(headers);
        return this;
    }

    @Override
    default public StreamingHttpResponse setHeader(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.setHeader(name, value);
        return this;
    }

    @Override
    default public StreamingHttpResponse setHeaders(HttpHeaders headers) {
        HttpResponseMetaData.super.setHeaders(headers);
        return this;
    }

    @Override
    default public StreamingHttpResponse addCookie(HttpCookiePair cookie) {
        HttpResponseMetaData.super.addCookie(cookie);
        return this;
    }

    @Override
    default public StreamingHttpResponse addCookie(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addCookie(name, value);
        return this;
    }

    @Override
    default public StreamingHttpResponse addSetCookie(HttpSetCookie cookie) {
        HttpResponseMetaData.super.addSetCookie(cookie);
        return this;
    }

    @Override
    default public StreamingHttpResponse addSetCookie(CharSequence name, CharSequence value) {
        HttpResponseMetaData.super.addSetCookie(name, value);
        return this;
    }

    @Override
    public StreamingHttpResponse context(ContextMap var1);
}

