/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageManager;
import mil.nga.geopackage.io.GeoPackageTextOutput;
import mil.nga.geopackage.io.Progress;
import mil.nga.geopackage.tiles.reproject.TileReprojection;
import mil.nga.geopackage.tiles.reproject.TileReprojectionOptimize;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;

public class TileReproject {
    private static final Logger LOGGER = Logger.getLogger(TileReproject.class.getName());
    private static final int LOG_TILE_FREQUENCY = 100;
    private static final int LOG_TILE_TIME_FREQUENCY = 60;
    public static final String ARGUMENT_PREFIX = "-";
    public static final String ARGUMENT_PROJECTION = "proj";
    public static final String ARGUMENT_OPTIMIZE = "optimize";
    public static final String ARGUMENT_OPTIMIZE_WEB_MERCATOR = "wm";
    public static final String ARGUMENT_OPTIMIZE_PLATTE_CARRE = "pc";
    public static final String ARGUMENT_OPTIMIZE_WEB_MERCATOR_WORLD = "wmw";
    public static final String ARGUMENT_OPTIMIZE_PLATTE_CARRE_WORLD = "pcw";
    public static final String ARGUMENT_TILE_WIDTH = "width";
    public static final String ARGUMENT_TILE_HEIGHT = "height";
    public static final String ARGUMENT_ZOOM_LEVELS = "zoom";
    public static final String ARGUMENT_LOG_COUNT = "logCount";
    public static final String ARGUMENT_LOG_TIME = "logTime";
    private static Progress progress = new Progress("Tile Reprojection", "tiles", 100, 60);
    private static File geoPackageFile = null;
    private static GeoPackage geoPackage = null;
    private static String table = null;
    private static File reprojectGeoPackageFile = null;
    private static GeoPackage reprojectGeoPackage = null;
    private static String reprojectTable = null;
    private static Projection projection = null;
    private static TileReprojectionOptimize optimize = null;
    private static Long tileWidth = null;
    private static Long tileHeight = null;
    private static String zoomLevels = null;
    private static List<Long> zooms = null;

    public static void main(String[] args) {
        final Thread mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                progress.cancel();
                try {
                    mainThread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to wait for the main thread to finish", e);
                }
            }
        });
        boolean valid = true;
        boolean requiredArguments = false;
        block20: for (int i = 0; valid && i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "proj": {
                        if (i + 1 < args.length) {
                            projection = ProjectionFactory.getProjection((String)args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Projection argument '" + arg + "' must be followed by a projection");
                        break;
                    }
                    case "optimize": {
                        if (i + 1 < args.length) {
                            String optimizeArg;
                            if ((optimize = TileReproject.parseOptimize(optimizeArg = args[++i])) != null) continue block20;
                            valid = false;
                            System.out.println("Error: Optimize argument '" + arg + "' must be followed by a valid optimization type. Invalid: " + optimizeArg);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Optimize argument '" + arg + "' must be followed by an optimization type");
                        break;
                    }
                    case "width": {
                        if (i + 1 < args.length) {
                            tileWidth = Long.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Tile Width argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "height": {
                        if (i + 1 < args.length) {
                            tileHeight = Long.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Tile Height argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "zoom": {
                        if (i + 1 < args.length) {
                            if ((zooms = TileReproject.parseZoomLevels(zoomLevels = args[++i])) != null) continue block20;
                            valid = false;
                            System.out.println("Error: Zoom Levels argument '" + arg + "' must be followed by a valid single zoom or zoom range. Invalid: " + zoomLevels);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Zoom Levels argument '" + arg + "' must be followed by a single zoom or zoom range");
                        break;
                    }
                    case "logCount": {
                        if (i + 1 < args.length) {
                            progress.setCountFrequency(Integer.valueOf(args[++i]));
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Log Count argument '" + arg + "' must be followed by a frequency count value");
                        break;
                    }
                    case "logTime": {
                        if (i + 1 < args.length) {
                            progress.setTimeFrequency(Integer.valueOf(args[++i]));
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Log Time argument '" + arg + "' must be followed by a frequency time value in seconds");
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                    }
                }
                continue;
            }
            if (geoPackageFile == null) {
                geoPackageFile = new File(arg);
                continue;
            }
            if (table == null) {
                table = arg;
                requiredArguments = true;
                continue;
            }
            if (reprojectTable == null) {
                reprojectTable = arg;
                continue;
            }
            if (reprojectGeoPackageFile == null) {
                reprojectGeoPackageFile = new File(reprojectTable);
                reprojectTable = arg;
                continue;
            }
            valid = false;
            System.out.println("Error: Unsupported extra argument: " + arg);
        }
        if (optimize != null) {
            if (projection != null && !projection.equals((Object)optimize.getProjection())) {
                System.out.println("Error: Projection is not compatible with optimization. Projection: " + projection + ", Optimization: " + optimize.getClass().getSimpleName());
                valid = false;
            }
        } else if (projection == null) {
            System.out.println("Error: A projection or optimization is required");
            valid = false;
        }
        if (!valid || !requiredArguments) {
            TileReproject.printUsage();
        } else {
            try {
                TileReproject.generate();
            }
            catch (Exception e) {
                TileReproject.printUsage();
                throw e;
            }
        }
    }

    public static void generate() {
        geoPackage = GeoPackageManager.open(geoPackageFile);
        System.out.println();
        System.out.println("GeoPackage: " + geoPackage.getName());
        System.out.println("Tile Table: " + table);
        if (reprojectGeoPackageFile != null) {
            if (!reprojectGeoPackageFile.exists()) {
                GeoPackageManager.create(reprojectGeoPackageFile);
            }
            reprojectGeoPackage = GeoPackageManager.open(reprojectGeoPackageFile);
            System.out.println("Reprojection GeoPackage: " + reprojectGeoPackage.getName());
        } else {
            reprojectGeoPackage = geoPackage;
        }
        if (reprojectTable == null) {
            reprojectTable = table;
        } else {
            System.out.println("Reprojection Tile Table: " + reprojectTable);
        }
        if (projection == null) {
            projection = optimize.getProjection();
        }
        System.out.println("Projection: " + projection);
        TileReprojection tileReprojection = TileReprojection.create(geoPackage, table, reprojectGeoPackage, reprojectTable, projection);
        tileReprojection.setOverwrite(true);
        tileReprojection.setProgress(progress);
        if (optimize != null) {
            tileReprojection.setOptimize(optimize);
            System.out.println("Optimization: " + optimize.getClass().getSimpleName() + (optimize.isWorld() ? ", world bounds" : ""));
        }
        if (tileWidth != null) {
            tileReprojection.setTileWidth(tileWidth);
            System.out.println("Tile Width: " + tileWidth);
        }
        if (tileHeight != null) {
            tileReprojection.setTileHeight(tileHeight);
            System.out.println("Tile Height: " + tileHeight);
        }
        if (zoomLevels != null) {
            System.out.println("Zoom Levels: " + zoomLevels);
        }
        System.out.println("Log Count Frequency: " + progress.getCountFrequency() + " tiles");
        System.out.println("Log Time Frequency: " + progress.getTimeFrequency() + " seconds");
        System.out.println();
        LOGGER.log(Level.INFO, "Reprojecting Tiles...");
        int count = 0;
        count = zooms != null ? tileReprojection.reproject(zooms) : tileReprojection.reproject();
        TileReproject.finish(count);
    }

    public static TileReprojectionOptimize parseOptimize(String optimizeArg) {
        TileReprojectionOptimize optimize = null;
        switch (optimizeArg.toLowerCase()) {
            case "wm": {
                optimize = TileReprojectionOptimize.webMercator();
                break;
            }
            case "pc": {
                optimize = TileReprojectionOptimize.platteCarre();
                break;
            }
            case "wmw": {
                optimize = TileReprojectionOptimize.webMercatorWorld();
                break;
            }
            case "pcw": {
                optimize = TileReprojectionOptimize.platteCarreWorld();
            }
        }
        return optimize;
    }

    public static List<Long> parseZoomLevels(String zoomLevels) {
        ArrayList<Long> zooms = new ArrayList<Long>();
        if (zoomLevels.contains(",")) {
            String[] zoomParts;
            for (String zoom : zoomParts = zoomLevels.split(",")) {
                zooms.add(Long.valueOf(zoom));
            }
        } else if (zoomLevels.contains(ARGUMENT_PREFIX)) {
            String[] zoomParts = zoomLevels.split(ARGUMENT_PREFIX);
            if (zoomParts.length == 2) {
                long minZoom = Long.valueOf(zoomParts[0]);
                long maxZoom = Long.valueOf(zoomParts[1]);
                for (long zoom = minZoom; zoom <= maxZoom; ++zoom) {
                    zooms.add(zoom);
                }
            }
        } else {
            zooms.add(Long.valueOf(zoomLevels));
        }
        return zooms.isEmpty() ? null : zooms;
    }

    private static void finish(int count) {
        StringBuilder output = new StringBuilder();
        output.append("\nTile Reprojection: ").append(progress.getProgress()).append(" tiles");
        if (reprojectGeoPackage != null) {
            try {
                GeoPackageTextOutput textOutput = new GeoPackageTextOutput(reprojectGeoPackage);
                output.append("\n\n");
                output.append(textOutput.header());
                output.append("\n\n");
                output.append(textOutput.tileTable(reprojectTable));
            }
            finally {
                reprojectGeoPackage.close();
            }
        }
        if (geoPackage != null) {
            geoPackage.close();
        }
        output.append("\n");
        System.out.println(output.toString());
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[-proj projection] [-optimize optimization] [-width tile_width] [-height tile_height] [-zoom zoom_levels] [-logCount count] [-logTime time] geopackage_file tile_table [[reprojection_geopackage_file] reprojection_tile_table]");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tReprojects Geopackage tiles to an alternate projection");
        System.out.println();
        System.out.println("ARGUMENTS");
        System.out.println();
        System.out.println("\t* A '-proj' OR '-optimize' argument is required");
        System.out.println();
        System.out.println("\t-proj projection");
        System.out.println("\t\tProjection specified as 'authority:code' or 'epsg_code'");
        System.out.println();
        System.out.println("\t-optimize optimization");
        System.out.println("\t\tReprojection optimization with included projection, specified as one of:");
        System.out.println("\t\t\twm - Web Mercator optimization, minimally tile bounded");
        System.out.println("\t\t\tpc - Platte Carre (WGS84) optimization, minimally tile bounded");
        System.out.println("\t\t\twmw - Web Mercator optimization, world bounded with XYZ tile coordinates");
        System.out.println("\t\t\tpcw - Platte Carre (WGS84) optimization, world bounded with XYZ tile coordinates");
        System.out.println();
        System.out.println("\t-width tile_width");
        System.out.println("\t\tWidth of reprojected tiles (default is existing width)");
        System.out.println();
        System.out.println("\t-height tile_height");
        System.out.println("\t\tHeight of reprojected tiles (default is existing height)");
        System.out.println();
        System.out.println("\t-zoom zoom_levels");
        System.out.println("\t\tTile zoom levels to reproject, specified as 'z', 'zmin-zmax', or 'z1,z2,...', (default is all levels)");
        System.out.println();
        System.out.println("\t-logCount count");
        System.out.println("\t\tLog frequency count of reprojected tiles (default is 100)");
        System.out.println();
        System.out.println("\t-logTime time");
        System.out.println("\t\tLog frequency time in seconds (default is 60)");
        System.out.println();
        System.out.println("\tgeopackage_file");
        System.out.println("\t\tPath to the source GeoPackage file with tiles to reproject and default reprojection GeoPackage destination");
        System.out.println();
        System.out.println("\ttile_table");
        System.out.println("\t\tSource tile table name to reproject within the GeoPackage file and default reprojection tile table destination");
        System.out.println();
        System.out.println("\treprojection_geopackage_file");
        System.out.println("\t\tPath to the destination GeoPackage to save the reprojected tiles");
        System.out.println();
        System.out.println("\treprojection_tile_table");
        System.out.println("\t\tName of the destination tile table to save reprojected tiles");
        System.out.println();
    }
}

