/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.style;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.nga.style.IconRow;

public class IconCache {
    public static final int DEFAULT_CACHE_SIZE = 100;
    private final Map<Long, BufferedImage> iconCache;
    private int cacheSize;

    public IconCache() {
        this(100);
    }

    public IconCache(int size) {
        this.cacheSize = size;
        this.iconCache = new LinkedHashMap<Long, BufferedImage>(size, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, BufferedImage> eldest) {
                return this.size() > IconCache.this.cacheSize;
            }
        };
    }

    public BufferedImage get(IconRow iconRow) {
        return this.get(iconRow.getId());
    }

    public BufferedImage get(long iconRowId) {
        return this.iconCache.get(iconRowId);
    }

    public BufferedImage put(IconRow iconRow, BufferedImage image) {
        return this.put(iconRow.getId(), image);
    }

    public BufferedImage put(long iconRowId, BufferedImage image) {
        return this.iconCache.put(iconRowId, image);
    }

    public BufferedImage remove(IconRow iconRow) {
        return this.remove(iconRow.getId());
    }

    public BufferedImage remove(long iconRowId) {
        return this.iconCache.remove(iconRowId);
    }

    public void clear() {
        this.iconCache.clear();
    }

    public void resize(int maxSize) {
        this.cacheSize = maxSize;
        if (this.iconCache.size() > maxSize) {
            int count = 0;
            Iterator<Long> rowIds = this.iconCache.keySet().iterator();
            while (rowIds.hasNext()) {
                rowIds.next();
                if (++count <= maxSize) continue;
                rowIds.remove();
            }
        }
    }

    public BufferedImage createIcon(IconRow icon) {
        return IconCache.createIcon(icon, this);
    }

    public BufferedImage createIcon(IconRow icon, float scale) {
        return IconCache.createIcon(icon, scale, this);
    }

    public static BufferedImage createIconNoCache(IconRow icon) {
        return IconCache.createIcon(icon, null);
    }

    public static BufferedImage createIconNoCache(IconRow icon, float scale) {
        return IconCache.createIcon(icon, scale, null);
    }

    public static BufferedImage createIcon(IconRow icon, IconCache iconCache) {
        return IconCache.createIcon(icon, 1.0f, iconCache);
    }

    public static BufferedImage createIcon(IconRow icon, float scale, IconCache iconCache) {
        BufferedImage iconImage = null;
        if (icon != null) {
            if (iconCache != null) {
                iconImage = iconCache.get(icon.getId());
            }
            if (iconImage == null) {
                boolean scaleImage;
                try {
                    iconImage = icon.getDataImage();
                }
                catch (IOException e) {
                    throw new GeoPackageException("Failed to get the Icon Row image. Id: " + icon.getId() + ", Name: " + icon.getName(), (Throwable)e);
                }
                int dataWidth = iconImage.getWidth();
                int dataHeight = iconImage.getHeight();
                Double iconWidth = icon.getWidth();
                Double iconHeight = icon.getHeight();
                boolean bl = scaleImage = iconWidth != null || iconHeight != null;
                if (!scaleImage && scale != 1.0f) {
                    iconWidth = dataWidth;
                    iconHeight = dataHeight;
                    scaleImage = true;
                }
                if (scaleImage) {
                    if (iconWidth == null) {
                        iconWidth = (double)dataWidth * (iconHeight / (double)dataHeight);
                    } else if (iconHeight == null) {
                        iconHeight = (double)dataHeight * (iconWidth / (double)dataWidth);
                    }
                    int scaledWidth = Math.round(scale * iconWidth.floatValue());
                    int scaledHeight = Math.round(scale * iconHeight.floatValue());
                    if (scaledWidth != dataWidth || scaledHeight != dataHeight) {
                        Image scaledImage = iconImage.getScaledInstance(scaledWidth, scaledHeight, 4);
                        iconImage = new BufferedImage(scaledWidth, scaledHeight, 2);
                        Graphics2D graphics = iconImage.createGraphics();
                        graphics.drawImage(scaledImage, 0, 0, null);
                        graphics.dispose();
                    }
                }
                if (iconCache != null) {
                    iconCache.put(icon.getId(), iconImage);
                }
            }
        }
        return iconImage;
    }
}

