/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.PayloadTooLargeException;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.utils.MutableInt;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class PayloadSizeLimitingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory {
    private final int maxResponsePayloadSize;

    public PayloadSizeLimitingHttpRequesterFilter(int maxResponsePayloadSize) {
        if (maxResponsePayloadSize < 0) {
            throw new IllegalArgumentException("maxResponsePayloadSize: " + maxResponsePayloadSize + " (expected >=0)");
        }
        this.maxResponsePayloadSize = maxResponsePayloadSize;
    }

    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                return PayloadSizeLimitingHttpRequesterFilter.this.applyLimit(request, arg_0 -> ((StreamingHttpRequester)delegate).request(arg_0));
            }
        };
    }

    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return PayloadSizeLimitingHttpRequesterFilter.this.applyLimit(request, x$0 -> super.request(x$0));
            }
        };
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private Single<StreamingHttpResponse> applyLimit(StreamingHttpRequest request, Function<StreamingHttpRequest, Single<StreamingHttpResponse>> delegator) {
        return delegator.apply(request).map(response -> response.transformMessageBody(PayloadSizeLimitingHttpRequesterFilter.newLimiter(this.maxResponsePayloadSize)));
    }

    static UnaryOperator<Publisher<?>> newLimiter(int maxPayloadSize) {
        return publisher -> Publisher.defer(() -> {
            MutableInt responsePayloadSize = new MutableInt();
            return publisher.beforeOnNext(obj -> {
                if (obj instanceof Buffer) {
                    Buffer buff = (Buffer)obj;
                    if (maxPayloadSize - responsePayloadSize.value < buff.readableBytes()) {
                        throw new PayloadTooLargeException("Maximum payload size=" + maxPayloadSize + " current payload size=" + responsePayloadSize.value + " new buffer size=" + buff.readableBytes());
                    }
                    responsePayloadSize.value += buff.readableBytes();
                }
            }).shareContextOnSubscribe();
        });
    }
}

