/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.ConsumableEvent;
import io.servicetalk.client.api.ReservableRequestConcurrencyController;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractLBHttpConnectionFactory;
import io.servicetalk.http.netty.H2ClientParentChannelInitializer;
import io.servicetalk.http.netty.H2ClientParentConnectionContext;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.http.netty.ReservableRequestConcurrencyControllers;
import io.servicetalk.http.netty.StreamingConnectionFactory;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientChannelInitializer;
import io.servicetalk.tcp.netty.internal.TcpConnector;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import javax.annotation.Nullable;

final class H2LBHttpConnectionFactory<ResolvedAddress>
extends AbstractLBHttpConnectionFactory<ResolvedAddress> {
    H2LBHttpConnectionFactory(ReadOnlyHttpClientConfig config, HttpExecutionContext executionContext, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, StreamingHttpRequestResponseFactory reqRespFactory, ExecutionStrategy connectStrategy, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, AbstractLBHttpConnectionFactory.ProtocolBinding protocolBinding) {
        super(config, executionContext, (HttpProtocolVersion version) -> reqRespFactory, connectStrategy, connectionFactoryFilter, connectionFilterFunction, protocolBinding);
    }

    @Override
    Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress resolvedAddress, TransportObserver observer) {
        assert (this.config.h2Config() != null);
        ReadOnlyTcpClientConfig tcpConfig = StreamingConnectionFactory.withSslConfigPeerHost(resolvedAddress, this.config.tcpConfig());
        return TcpConnector.connect(null, resolvedAddress, (ReadOnlyTcpClientConfig)tcpConfig, (boolean)true, (ExecutionContext)this.executionContext, (channel, connectionObserver) -> H2ClientParentConnectionContext.initChannel(channel, this.executionContext, this.config.h2Config(), (StreamingHttpRequestResponseFactory)this.reqRespFactoryFunc.apply(HttpProtocolVersion.HTTP_2_0), tcpConfig.flushStrategy(), tcpConfig.idleTimeoutMs(), (SslConfig)tcpConfig.sslConfig(), new TcpClientChannelInitializer(tcpConfig, connectionObserver).andThen((ChannelInitializer)new H2ClientParentChannelInitializer(this.config.h2Config())), connectionObserver, this.config.allowDropTrailersReadFromTransport()), (TransportObserver)observer);
    }

    @Override
    ReservableRequestConcurrencyController newConcurrencyController(Publisher<? extends ConsumableEvent<Integer>> maxConcurrency, Completable onClosing) {
        return ReservableRequestConcurrencyControllers.newController(maxConcurrency, onClosing, 100);
    }
}

