/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ScoreSupplier;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerFactory;
import io.servicetalk.transport.api.ExecutionStrategy;
import java.util.Collection;
import java.util.Objects;

public final class DefaultHttpLoadBalancerFactory<ResolvedAddress>
implements HttpLoadBalancerFactory<ResolvedAddress> {
    private final LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory;
    private final HttpExecutionStrategy strategy;

    DefaultHttpLoadBalancerFactory(LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory, HttpExecutionStrategy strategy) {
        this.rawFactory = rawFactory;
        this.strategy = strategy;
    }

    public <T extends FilterableStreamingHttpLoadBalancedConnection> LoadBalancer<T> newLoadBalancer(String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
        return this.rawFactory.newLoadBalancer(targetResource, eventPublisher, connectionFactory);
    }

    public FilterableStreamingHttpLoadBalancedConnection toLoadBalancedConnection(FilterableStreamingHttpConnection connection) {
        return new DefaultFilterableStreamingHttpLoadBalancedConnection(connection);
    }

    public HttpExecutionStrategy requiredOffloads() {
        return this.strategy;
    }

    private static final class DefaultFilterableStreamingHttpLoadBalancedConnection
    implements FilterableStreamingHttpLoadBalancedConnection {
        private final FilterableStreamingHttpConnection delegate;

        DefaultFilterableStreamingHttpLoadBalancedConnection(FilterableStreamingHttpConnection delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public int score() {
            throw new UnsupportedOperationException(DefaultFilterableStreamingHttpLoadBalancedConnection.class.getName() + " doesn't support scoring. " + ScoreSupplier.class.getName() + " is only available through " + HttpLoadBalancerFactory.class.getSimpleName() + " implementations that support scoring.");
        }

        public HttpConnectionContext connectionContext() {
            return this.delegate.connectionContext();
        }

        public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
            return this.delegate.transportEventStream(eventKey);
        }

        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
            return this.delegate.request(request);
        }

        public HttpExecutionContext executionContext() {
            return this.delegate.executionContext();
        }

        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.delegate.httpResponseFactory();
        }

        public Completable onClose() {
            return this.delegate.onClose();
        }

        public Completable closeAsync() {
            return this.delegate.closeAsync();
        }

        public Completable closeAsyncGracefully() {
            return this.delegate.closeAsyncGracefully();
        }

        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.delegate.newRequest(method, requestTarget);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static final class Builder<ResolvedAddress> {
        private final LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory;
        private final HttpExecutionStrategy strategy;

        private Builder(LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory, HttpExecutionStrategy strategy) {
            this.rawFactory = rawFactory;
            this.strategy = strategy;
        }

        public DefaultHttpLoadBalancerFactory<ResolvedAddress> build() {
            return new DefaultHttpLoadBalancerFactory<ResolvedAddress>(this.rawFactory, this.strategy);
        }

        public static <ResolvedAddress> Builder<ResolvedAddress> fromDefaults() {
            return Builder.from(new RoundRobinLoadBalancerFactory.Builder().build());
        }

        public static <ResolvedAddress> Builder<ResolvedAddress> from(LoadBalancerFactory<ResolvedAddress, FilterableStreamingHttpLoadBalancedConnection> rawFactory) {
            HttpExecutionStrategy strategy = HttpExecutionStrategy.from((ExecutionStrategy)rawFactory.requiredOffloads());
            return new Builder<ResolvedAddress>(rawFactory, strategy);
        }
    }
}

