/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.baremaps.openstreetmap.utils.GeometryUtils;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class PostgisPlugin
extends JdbiPlugin.Singleton {
    public void customizeJdbi(Jdbi jdbi) {
        jdbi.registerArgument((ArgumentFactory)new PointArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new LineStringArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new LinearRingArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new PolygonArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new MultiPointArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new MultiLineStringArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new MultiPolygonArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new GeometryCollectionArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new GeometryArgumentFactory());
        jdbi.registerColumnMapper((ColumnMapper)new PointColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new LineStringColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new LinearRingColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new PolygonColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new MultiPointColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new MultiLineStringColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new MultiPolygonColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new GeometryCollectionColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new GeometryColumnMapper());
    }

    static final class PointArgumentFactory
    extends BaseArgumentFactory<Point> {
        PointArgumentFactory() {
        }
    }

    static final class LineStringArgumentFactory
    extends BaseArgumentFactory<LineString> {
        LineStringArgumentFactory() {
        }
    }

    static final class LinearRingArgumentFactory
    extends BaseArgumentFactory<LinearRing> {
        LinearRingArgumentFactory() {
        }
    }

    static final class PolygonArgumentFactory
    extends BaseArgumentFactory<Polygon> {
        PolygonArgumentFactory() {
        }
    }

    static final class MultiPointArgumentFactory
    extends BaseArgumentFactory<MultiPoint> {
        MultiPointArgumentFactory() {
        }
    }

    static final class MultiLineStringArgumentFactory
    extends BaseArgumentFactory<MultiLineString> {
        MultiLineStringArgumentFactory() {
        }
    }

    static final class MultiPolygonArgumentFactory
    extends BaseArgumentFactory<MultiPolygon> {
        MultiPolygonArgumentFactory() {
        }
    }

    static final class GeometryCollectionArgumentFactory
    extends BaseArgumentFactory<GeometryCollection> {
        GeometryCollectionArgumentFactory() {
        }
    }

    static final class GeometryArgumentFactory
    extends BaseArgumentFactory<Geometry> {
        GeometryArgumentFactory() {
        }
    }

    static final class PointColumnMapper
    extends BaseColumnMapper<Point> {
        PointColumnMapper() {
        }
    }

    static final class LineStringColumnMapper
    extends BaseColumnMapper<LineString> {
        LineStringColumnMapper() {
        }
    }

    static final class LinearRingColumnMapper
    extends BaseColumnMapper<LinearRing> {
        LinearRingColumnMapper() {
        }
    }

    static final class PolygonColumnMapper
    extends BaseColumnMapper<Polygon> {
        PolygonColumnMapper() {
        }
    }

    static final class MultiPointColumnMapper
    extends BaseColumnMapper<MultiPoint> {
        MultiPointColumnMapper() {
        }
    }

    static final class MultiLineStringColumnMapper
    extends BaseColumnMapper<MultiLineString> {
        MultiLineStringColumnMapper() {
        }
    }

    static final class MultiPolygonColumnMapper
    extends BaseColumnMapper<MultiPolygon> {
        MultiPolygonColumnMapper() {
        }
    }

    static final class GeometryCollectionColumnMapper
    extends BaseColumnMapper<GeometryCollection> {
        GeometryCollectionColumnMapper() {
        }
    }

    static final class GeometryColumnMapper
    extends BaseColumnMapper<Geometry> {
        GeometryColumnMapper() {
        }
    }

    static abstract class BaseColumnMapper<T extends Geometry>
    implements ColumnMapper<T> {
        BaseColumnMapper() {
        }

        public T map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
            byte[] bytes = BaseColumnMapper.hexStringToByteArray(r.getString(columnNumber));
            return (T)GeometryUtils.deserialize((byte[])bytes);
        }

        private static byte[] hexStringToByteArray(String s) {
            int len = s.length();
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            }
            return data;
        }
    }

    static abstract class BaseArgumentFactory<T extends Geometry>
    extends AbstractArgumentFactory<T> {
        public BaseArgumentFactory() {
            super(1111);
        }

        public Argument build(T value, ConfigRegistry config) {
            return (position, statement, ctx) -> statement.setBytes(position, GeometryUtils.serialize((Geometry)value));
        }
    }
}

