/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.baremaps.api.CollectionsApi;
import org.apache.baremaps.model.Collection;
import org.apache.baremaps.model.Collections;
import org.apache.baremaps.model.Link;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.json.Json;

@Singleton
public class CollectionsResource
implements CollectionsApi {
    @Context
    UriInfo uriInfo;
    private static final QualifiedType<Collection> COLLECTION = QualifiedType.of(Collection.class).with(new Class[]{Json.class});
    private final Jdbi jdbi;

    @Inject
    public CollectionsResource(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    @Override
    public Response addCollection(Collection collection) {
        collection.setId(UUID.randomUUID());
        this.jdbi.useHandle(handle -> ((Update)((Update)handle.createUpdate("insert into collections (id, collection) values (:id, :collection)").bind("id", collection.getId())).bindByType("collection", (Object)collection, COLLECTION)).execute());
        return Response.created((URI)URI.create("collections/" + collection.getId())).build();
    }

    @Override
    public Response deleteCollection(UUID collectionId) {
        this.jdbi.useHandle(handle -> handle.execute(String.format("drop table if exists \"%s\"; delete from collections where id = (?)", collectionId), new Object[]{collectionId}));
        return Response.noContent().build();
    }

    @Override
    public Response getCollection(UUID collectionId) {
        Collection collection = (Collection)this.jdbi.withHandle(handle -> (Collection)((Query)handle.createQuery("select collection from collections where id = :id").bind("id", collectionId)).mapTo(COLLECTION).one());
        collection.getLinks().add(new Link().href(this.uriInfo.getRequestUri().toString()).rel("self"));
        return Response.ok((Object)collection).build();
    }

    @Override
    public Response getCollections() {
        List collectionList = (List)this.jdbi.withHandle(handle -> handle.createQuery("select collection from collections").mapTo(COLLECTION).list());
        collectionList.forEach(collection -> collection.getLinks().add(new Link().href(this.uriInfo.getRequestUri().toString() + "/" + collection.getId()).rel("self")));
        Collections collections = new Collections().collections(collectionList);
        collections.getLinks().add(new Link().href(this.uriInfo.getRequestUri().toString()).rel("self"));
        return Response.ok((Object)collections).build();
    }

    @Override
    public Response updateCollection(UUID collectionId, Collection collection) {
        this.jdbi.useHandle(handle -> ((Update)((Update)handle.createUpdate("update collections set collection = :collection where id = :id").bind("id", collectionId)).bindByType("collection", (Object)collection, COLLECTION)).execute());
        return Response.noContent().build();
    }
}

