/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.apache.baremaps.iploc.IpLoc;
import org.apache.baremaps.iploc.data.IpLocStats;
import org.apache.baremaps.iploc.database.SqliteUtils;
import org.apache.baremaps.iploc.nic.NicObject;
import org.apache.baremaps.iploc.nic.NicParser;
import org.apache.baremaps.stream.StreamException;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CreateIplocIndex(Path geonamesIndexPath, List<Path> nicPaths, Path targetIplocIndexPath) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(CreateIplocIndex.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Generating Iploc from {} {}", (Object)this.geonamesIndexPath, this.nicPaths);
        try (FSDirectory directory = MMapDirectory.open((Path)this.geonamesIndexPath);
             SearcherManager searcherManager = new SearcherManager((Directory)directory, new SearcherFactory());){
            logger.info("Creating the Iploc database");
            String jdbcUrl = String.format("JDBC:sqlite:%s", this.targetIplocIndexPath);
            SqliteUtils.executeResource(jdbcUrl, "iploc_init.sql");
            IpLoc ipLoc = new IpLoc(jdbcUrl, searcherManager);
            logger.info("Generating NIC objects stream");
            ((Stream)this.nicPaths.stream().parallel()).forEach(path -> {
                try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    Stream<NicObject> nicObjects = NicParser.parse(inputStream);
                    logger.info("Inserting the nic objects into the Iploc database");
                    ipLoc.insertNicObjects(nicObjects);
                }
                catch (IOException e) {
                    throw new StreamException(e);
                }
            });
            IpLocStats ipLocStats = ipLoc.getIplocStats();
            logger.info("IpLoc stats\n-----------\ninetnumInsertedByAddress : {}\ninetnumInsertedByDescr : {}\ninetnumInsertedByCountry : {}\ninetnumInsertedByCountryCode : {}\ninetnumInsertedByGeoloc : {}\ninetnumNotInserted : {}", new Object[]{ipLocStats.getInsertedByAddressCount(), ipLocStats.getInsertedByDescrCount(), ipLocStats.getInsertedByCountryCount(), ipLocStats.getInsertedByCountryCodeCount(), ipLocStats.getInsertedByGeolocCount(), ipLocStats.getNotInsertedCount()});
        }
        logger.info("IpLoc database created successfully {}", (Object)this.targetIplocIndexPath);
    }
}

