/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.baremaps.collection.AppendOnlyBuffer;
import org.apache.baremaps.collection.DataMap;
import org.apache.baremaps.collection.MemoryAlignedDataList;
import org.apache.baremaps.collection.MemoryAlignedDataMap;
import org.apache.baremaps.collection.MonotonicDataMap;
import org.apache.baremaps.collection.memory.MemoryMappedFile;
import org.apache.baremaps.collection.type.LonLatDataType;
import org.apache.baremaps.collection.type.LongDataType;
import org.apache.baremaps.collection.type.LongListDataType;
import org.apache.baremaps.collection.type.PairDataType;
import org.locationtech.jts.geom.Coordinate;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static DataMap<Coordinate> denseCoordinateMap() throws IOException {
        Path cacheDir = Files.createTempDirectory(Paths.get(".", new String[0]), "coordinates_", new FileAttribute[0]);
        Path coordinatesFile = Files.createFile(cacheDir.resolve("values"), new FileAttribute[0]);
        MemoryAlignedDataMap<Coordinate> coordinateMap = new MemoryAlignedDataMap<Coordinate>(new LonLatDataType(), new MemoryMappedFile(coordinatesFile));
        return coordinateMap;
    }

    public static DataMap<Coordinate> sparseCoordinateMap() throws IOException {
        Path cacheDir = Files.createTempDirectory(Paths.get(".", new String[0]), "coordinates_", new FileAttribute[0]);
        Path coordinatesKeysFile = Files.createFile(cacheDir.resolve("keys"), new FileAttribute[0]);
        Path coordinatesValsFile = Files.createFile(cacheDir.resolve("values"), new FileAttribute[0]);
        MonotonicDataMap<Coordinate> coordinateMap = new MonotonicDataMap<Coordinate>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedFile(coordinatesKeysFile)), new AppendOnlyBuffer<Coordinate>(new LonLatDataType(), new MemoryMappedFile(coordinatesValsFile)));
        return coordinateMap;
    }

    public static DataMap<List<Long>> sparseReferenceMap() throws IOException {
        Path cacheDir = Files.createTempDirectory(Paths.get(".", new String[0]), "references_", new FileAttribute[0]);
        Path referencesKeysFile = Files.createFile(cacheDir.resolve("keys"), new FileAttribute[0]);
        Path referencesValuesFile = Files.createFile(cacheDir.resolve("values"), new FileAttribute[0]);
        MonotonicDataMap<List<Long>> referenceMap = new MonotonicDataMap<List<Long>>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedFile(referencesKeysFile)), new AppendOnlyBuffer<List<Long>>(new LongListDataType(), new MemoryMappedFile(referencesValuesFile)));
        return referenceMap;
    }
}

