/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc.data;

import net.ripe.ipresource.IpResourceRange;
import org.apache.baremaps.iploc.data.Ipv4;

public class Ipv4Range {
    private final Ipv4 start;
    private final Ipv4 end;

    public Ipv4Range(String range) {
        IpResourceRange ipResourceRange = IpResourceRange.parse((String)range);
        this.start = new Ipv4(ipResourceRange.getStart());
        this.end = new Ipv4(ipResourceRange.getEnd());
    }

    public Ipv4Range(byte[] start, byte[] end) {
        this.start = new Ipv4(start);
        this.end = new Ipv4(end);
    }

    public byte[] getStart() {
        return this.start.getIp();
    }

    public byte[] getEnd() {
        return this.end.getIp();
    }

    public String toString() {
        return "Ipv4Range{start=" + this.start.toString() + ", end=" + this.end.toString() + "}";
    }
}

