/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc.data;

import com.google.common.primitives.Bytes;
import java.math.BigInteger;
import java.util.Arrays;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.UniqueIpResource;

public class Ipv4 {
    private final byte[] ip;

    public Ipv4(String ip) {
        this(UniqueIpResource.parse((String)ip));
    }

    protected Ipv4(UniqueIpResource uniqueIpResource) {
        this.ip = Ipv4.forceIpOn4Bytes(uniqueIpResource.getValue().toByteArray());
    }

    public Ipv4(byte[] ip) {
        this.ip = ip;
    }

    private static byte[] forceIpOn4Bytes(byte[] bytes) {
        if (bytes.length > 4) {
            return Arrays.copyOfRange(bytes, bytes.length - 4, bytes.length);
        }
        if (bytes.length < 4) {
            return Bytes.concat((byte[][])new byte[][]{new byte[4 - bytes.length], bytes});
        }
        return bytes;
    }

    public static String format(byte[] ip) {
        byte[] zero = new byte[]{0};
        return new Ipv4Address(new BigInteger(Bytes.concat((byte[][])new byte[][]{zero, ip})).longValue()).toString();
    }

    public byte[] getIp() {
        return this.ip;
    }

    public String toString() {
        return "Ipv4{value=" + Ipv4.format(this.ip) + "}";
    }
}

