/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.collection.type.FixedSizeDataType;

public class SmallIntegerDataType
extends FixedSizeDataType<Integer> {
    private final int n;

    public SmallIntegerDataType(int n) {
        super(n);
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("The number of bytes used to store small integers must be comprised between 1 and 4");
        }
        this.n = n;
    }

    @Override
    public void write(ByteBuffer buffer, int position, Integer value) {
        for (int i = 0; i < this.n; ++i) {
            buffer.put(position + i, (byte)(value >> (i << 3)));
        }
    }

    @Override
    public Integer read(ByteBuffer buffer, int position) {
        int i;
        byte s = (byte)(buffer.get(position + this.n - 1) >= 0 ? 0 : -1);
        int l = 0;
        for (i = 3; i > this.n - 1; --i) {
            l |= (s & 0xFF) << (i << 3);
        }
        for (i = this.n - 1; i >= 0; --i) {
            l |= (buffer.get(position + i) & 0xFF) << (i << 3);
        }
        return l;
    }
}

