/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.converters;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.config.converters.ConfigurationConverter;
import org.apache.ignite.migrationtools.config.registry.ConfigurationRegistryInterface;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite3.internal.network.configuration.NetworkConfiguration;
import org.apache.ignite3.internal.network.configuration.NetworkExtensionConfiguration;
import org.apache.ignite3.internal.network.configuration.StaticNodeFinderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverySpiConverter
implements ConfigurationConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoverySpiConverter.class);
    private static Pattern PORT_RANGE_PATTERN = Pattern.compile(":(?<fp>\\d+)(..(?<lp>\\d+))?$");

    private static Collection<String> collectAddresses(String rawAddress) {
        String finalRawAddr = rawAddress.trim();
        Matcher m = PORT_RANGE_PATTERN.matcher(finalRawAddr);
        if (m.find()) {
            int fp = Integer.parseInt(m.group("fp"));
            String lpStr = m.group("lp");
            if (lpStr == null) {
                return Collections.singleton(finalRawAddr);
            }
            String hostname = finalRawAddr.substring(0, m.start());
            int lp = Integer.parseInt(lpStr);
            return IntStream.rangeClosed(fp, lp).mapToObj(p -> hostname + ":" + p).collect(Collectors.toList());
        }
        return Collections.singleton(finalRawAddr + ":47500");
    }

    @Override
    public void convert(IgniteConfiguration src, ConfigurationRegistryInterface registry) throws ExecutionException, InterruptedException {
        DiscoverySpi discSpi = src.getDiscoverySpi();
        if (discSpi == null) {
            LOGGER.error("Could not find a CommunicationSpi in the source configuration.");
            return;
        }
        if (!(discSpi instanceof TcpDiscoverySpi)) {
            LOGGER.warn("CommunicationSpi is not a TcpDiscoverySpi: {}", (Object)discSpi.getClass().getName());
            return;
        }
        TcpDiscoverySpi tcpDiscoverySpi = (TcpDiscoverySpi)discSpi;
        NetworkConfiguration target = ((NetworkExtensionConfiguration)registry.getConfiguration(NetworkExtensionConfiguration.KEY)).network();
        try {
            int locPort = (Integer)FieldUtils.readDeclaredField((Object)tcpDiscoverySpi, (String)"locPort", (boolean)true);
            target.port().update((Object)locPort).get();
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Error getting TcpDiscoverySpi local port", (Throwable)e);
        }
        if (tcpDiscoverySpi.getLocalPortRange() > 0) {
            LOGGER.error("Local Port Range in TcpDiscoverySpi will be ignored. There's no similar feature in Apache Ignite 3");
        }
        if (tcpDiscoverySpi.getIpFinder() instanceof TcpDiscoveryVmIpFinder) {
            try {
                Collection rawAddresses = (Collection)FieldUtils.readField((Object)tcpDiscoverySpi.getIpFinder(), (String)"addrs", (boolean)true);
                String[] addrArr = (String[])rawAddresses.stream().flatMap(a -> DiscoverySpiConverter.collectAddresses(a).stream()).toArray(String[]::new);
                ((StaticNodeFinderConfiguration)target.nodeFinder()).netClusterNodes().update((Object)addrArr).get();
            }
            catch (ClassCastException | IllegalAccessException e) {
                LOGGER.error("Error getting addresses from TcpDiscoveryVmIpFinder addrs", (Throwable)e);
            }
        } else {
            LOGGER.warn("Only TcpDiscoveryVmIpFinder configurations are supported, found: {}", (Object)Optional.ofNullable(tcpDiscoverySpi.getIpFinder()).map(c -> c.getClass().getName()).orElse("None"));
        }
    }
}

