/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite3.internal.raft.storage.segstore.ReadModeIndexMemTable;
import org.apache.ignite3.internal.raft.storage.segstore.SegmentInfo;
import org.apache.ignite3.internal.raft.storage.segstore.WriteModeIndexMemTable;

class IndexMemTable
implements WriteModeIndexMemTable,
ReadModeIndexMemTable {
    private final Stripe[] stripes;

    IndexMemTable(int stripes) {
        this.stripes = new Stripe[stripes];
        for (int i = 0; i < stripes; ++i) {
            this.stripes[i] = new Stripe();
        }
    }

    @Override
    public void appendSegmentFileOffset(long groupId, long logIndex, int segmentFileOffset) {
        assert (segmentFileOffset != 0) : String.format("Segment file offset must not be 0 [groupId=%d]", groupId);
        SegmentInfo segmentInfo = this.stripe((long)groupId).memTable.computeIfAbsent(groupId, id -> new SegmentInfo(logIndex));
        segmentInfo.addOffset(logIndex, segmentFileOffset);
    }

    @Override
    public int getSegmentFileOffset(long groupId, long logIndex) {
        SegmentInfo segmentInfo = (SegmentInfo)this.stripe((long)groupId).memTable.get(groupId);
        return segmentInfo == null ? 0 : segmentInfo.getOffset(logIndex);
    }

    @Override
    public ReadModeIndexMemTable transitionToReadMode() {
        return this;
    }

    @Override
    public int numGroups() {
        int result = 0;
        for (Stripe stripe : this.stripes) {
            result += stripe.memTable.size();
        }
        return result;
    }

    @Override
    public Iterator<Map.Entry<Long, SegmentInfo>> iterator() {
        return new SegmentInfoIterator();
    }

    private Stripe stripe(long groupId) {
        int stripeIndex = Long.hashCode(groupId) % this.stripes.length;
        return this.stripes[stripeIndex];
    }

    private static class Stripe {
        private final ConcurrentMap<Long, SegmentInfo> memTable = new ConcurrentHashMap<Long, SegmentInfo>();

        private Stripe() {
        }
    }

    private class SegmentInfoIterator
    implements Iterator<Map.Entry<Long, SegmentInfo>> {
        private int stripeIndex = 0;
        private Iterator<Map.Entry<Long, SegmentInfo>> mapIterator = this.refreshIterator();

        private SegmentInfoIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.mapIterator.hasNext()) {
                return true;
            }
            if (this.stripeIndex < IndexMemTable.this.stripes.length) {
                this.mapIterator = this.refreshIterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public Map.Entry<Long, SegmentInfo> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.mapIterator.next();
        }

        private Iterator<Map.Entry<Long, SegmentInfo>> refreshIterator() {
            Stripe nextStripe = IndexMemTable.this.stripes[this.stripeIndex++];
            return nextStripe.memTable.entrySet().iterator();
        }
    }
}

