/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partitiondistribution;

import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.ignite3.internal.partitiondistribution.Assignments;
import org.apache.ignite3.internal.partitiondistribution.AssignmentsQueueSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class AssignmentsQueue
implements Iterable<Assignments> {
    @IgniteToStringInclude
    private final Deque<Assignments> queue;

    public AssignmentsQueue(Assignments ... assignments) {
        this(Arrays.asList(assignments));
    }

    AssignmentsQueue(Collection<Assignments> assignments) {
        this.queue = new LinkedList<Assignments>(assignments);
    }

    public Assignments poll() {
        assert (!this.queue.isEmpty()) : "Assignments queue must contain at least one element.";
        return this.queue.poll();
    }

    public Assignments peekFirst() {
        assert (!this.queue.isEmpty()) : "Assignments queue must contain at least one element.";
        return this.queue.peekFirst();
    }

    public Assignments peekLast() {
        assert (!this.queue.isEmpty()) : "Assignments queue must contain at least one element.";
        return this.queue.peekLast();
    }

    public byte[] toBytes() {
        return VersionedSerialization.toBytes(this, AssignmentsQueueSerializer.INSTANCE);
    }

    public static byte[] toBytes(Assignments ... assignments) {
        return AssignmentsQueue.toBytes(Arrays.asList(assignments));
    }

    public static byte[] toBytes(Collection<Assignments> assignments) {
        return new AssignmentsQueue(assignments).toBytes();
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static AssignmentsQueue fromBytes(byte @Nullable [] bytes) {
        return bytes == null ? null : VersionedSerialization.fromBytes(bytes, AssignmentsQueueSerializer.INSTANCE);
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterator<Assignments> iterator() {
        return this.queue.iterator();
    }

    public String toString() {
        return S.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentsQueue that = (AssignmentsQueue)o;
        return Objects.equals(this.queue, that.queue);
    }

    public int hashCode() {
        return Objects.hashCode(this.queue);
    }
}

