/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.queue;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.ignite3.internal.compute.queue.QueueOverflowException;

public class BoundedPriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final PriorityQueue<E> queue;
    private final Supplier<Integer> maxCapacity;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();

    public BoundedPriorityBlockingQueue(Supplier<Integer> maxCapacity) {
        this.queue = new PriorityQueue();
        this.maxCapacity = maxCapacity;
    }

    public BoundedPriorityBlockingQueue(Supplier<Integer> maxCapacity, Comparator<E> comparator) {
        this.queue = new PriorityQueue<E>(comparator);
        this.maxCapacity = maxCapacity;
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.lock();
        try {
            Iterator<E> iterator = new PriorityQueue<E>(this.queue).iterator();
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        this.lock.lock();
        try {
            this.checkInsert(1);
            boolean result = this.queue.offer(e);
            if (result) {
                this.notEmpty.signalAll();
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return this.offer(e);
    }

    @Override
    public E take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.queue.isEmpty()) {
                this.notEmpty.await();
            }
            E x = this.poll();
            assert (x != null);
            E e = x;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll() {
        this.lock.lock();
        try {
            E e = this.queue.poll();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        long nanos = timeUnit.toNanos(l);
        this.lock.lockInterruptibly();
        try {
            E result = this.poll();
            while (result == null && nanos > 0L) {
                nanos = this.notEmpty.awaitNanos(nanos);
                result = this.poll();
            }
            E e = result;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.maxCapacity.get() - this.queue.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> objects) {
        Objects.requireNonNull(objects);
        if (objects == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int j = 0;
            while (this.size() > 0) {
                objects.add(this.poll());
                ++j;
            }
            int n = j;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> objects, int i) {
        Objects.requireNonNull(objects);
        if (objects == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int j;
            for (j = 0; this.size() > 0 && j < i; ++j) {
                objects.add(this.poll());
            }
            int n = j;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E peek() {
        this.lock.lock();
        try {
            E e = this.queue.peek();
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.lock.lock();
        try {
            boolean bl = this.queue.contains(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        this.lock.lock();
        try {
            T[] TArray = this.queue.toArray(ts);
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = this.queue.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.queue.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.lock.lock();
        try {
            boolean bl = this.queue.remove(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkInsert(int size) {
        Integer maxSize = this.maxCapacity.get();
        int currentSize = this.size();
        if (currentSize > maxSize - size) {
            throw new QueueOverflowException("Compute queue overflow when tried to insert " + size + " element(s) to queue. Current queue size is " + currentSize + ". Max queue size is " + maxSize + ".");
        }
    }
}

