/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformDefaultJavaObjectFactory;
import org.apache.ignite.internal.processors.platform.PlatformJavaObjectFactoryEx;
import org.apache.ignite.internal.processors.platform.PlatformJavaObjectSingletonFactory;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.platform.PlatformJavaObjectFactory;
import org.jetbrains.annotations.Nullable;

public class PlatformJavaObjectFactoryProxy
implements Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    public static final int TYP_USER = 0;
    public static final int TYP_DEFAULT = 1;
    private int factoryTyp;
    private String clsName;
    @GridToStringExclude
    private Object payload;
    @GridToStringExclude
    private Map<String, Object> props;

    public PlatformJavaObjectFactoryProxy() {
    }

    public PlatformJavaObjectFactoryProxy(int factoryTyp, @Nullable String clsName, @Nullable Object payload, @Nullable Map<String, Object> props) {
        this.factoryTyp = factoryTyp;
        this.clsName = clsName;
        this.payload = payload;
        this.props = props;
    }

    public PlatformJavaObjectFactory factory(GridKernalContext ctx) {
        PlatformJavaObjectFactory<Object> res;
        switch (this.factoryTyp) {
            case 1: {
                res = new PlatformDefaultJavaObjectFactory();
                break;
            }
            case 0: {
                res = PlatformUtils.createJavaObject(this.clsName);
                break;
            }
            default: {
                throw new IgniteException("Unsupported Java object factory type: " + this.factoryTyp);
            }
        }
        if (res instanceof PlatformJavaObjectFactoryEx) {
            ((PlatformJavaObjectFactoryEx)res).initialize(this.payload, this.props);
        } else {
            PlatformUtils.initializeJavaObject(res, this.clsName, this.props, ctx);
            if (!(res instanceof PlatformJavaObjectFactory)) {
                res = new PlatformJavaObjectSingletonFactory(res);
            }
        }
        return res;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriterEx rawWriter = (BinaryRawWriterEx)writer.rawWriter();
        rawWriter.writeInt(this.factoryTyp);
        rawWriter.writeString(this.clsName);
        rawWriter.writeObjectDetached(this.payload);
        if (this.props != null) {
            rawWriter.writeInt(this.props.size());
            for (Map.Entry<String, Object> prop : this.props.entrySet()) {
                rawWriter.writeString(prop.getKey());
                rawWriter.writeObjectDetached(prop.getValue());
            }
        } else {
            rawWriter.writeInt(0);
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReaderEx rawReader = (BinaryRawReaderEx)reader.rawReader();
        this.factoryTyp = rawReader.readInt();
        this.clsName = rawReader.readString();
        this.payload = rawReader.readObjectDetached();
        int propsSize = rawReader.readInt();
        if (propsSize > 0) {
            this.props = new HashMap<String, Object>(propsSize);
            for (int i = 0; i < propsSize; ++i) {
                String key = rawReader.readString();
                Object val = rawReader.readObjectDetached();
                this.props.put(key, val);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.factoryTyp);
        U.writeString(out, this.clsName);
        out.writeObject(this.payload);
        U.writeMap(out, this.props);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factoryTyp = in.readInt();
        this.clsName = U.readString(in);
        this.payload = in.readObject();
        this.props = U.readMap(in);
    }

    public String toString() {
        return S.toString(PlatformJavaObjectFactoryProxy.class, this);
    }
}

