/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.msgpack.value.impl;

import java.io.IOException;
import java.util.Arrays;
import org.apache.ignite.shaded.org.msgpack.core.MessagePacker;
import org.apache.ignite.shaded.org.msgpack.value.ImmutableStringValue;
import org.apache.ignite.shaded.org.msgpack.value.Value;
import org.apache.ignite.shaded.org.msgpack.value.ValueType;
import org.apache.ignite.shaded.org.msgpack.value.impl.AbstractImmutableRawValue;

public class ImmutableStringValueImpl
extends AbstractImmutableRawValue
implements ImmutableStringValue {
    public ImmutableStringValueImpl(byte[] byArray) {
        super(byArray);
    }

    public ImmutableStringValueImpl(String string) {
        super(string);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    public ImmutableStringValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableStringValue asStringValue() {
        return this;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packRawStringHeader(this.data.length);
        messagePacker.writePayload(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isStringValue()) {
            return false;
        }
        if (value instanceof ImmutableStringValueImpl) {
            ImmutableStringValueImpl immutableStringValueImpl = (ImmutableStringValueImpl)value;
            return Arrays.equals(this.data, immutableStringValueImpl.data);
        }
        return Arrays.equals(this.data, value.asStringValue().asByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

