/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.testing.xp;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.gui.TestingGuiPlugin;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;

import java.util.ArrayList;
import java.util.List;

@ExtensionPoint(
    id = "AutoOpenTestExtensionPoint",
    extensionPointId = "PipelineAfterOpen",
    description =
        "Open the pipeline unit test along with the pipeline. Pick the one marked for auto opening.")
public class AutoOpenTestExtensionPoint implements IExtensionPoint<PipelineMeta> {
  @Override
  public void callExtensionPoint(ILogChannel log, IVariables variables, PipelineMeta pipelineMeta)
      throws HopException {

    // Running in HopGui...
    //
    HopGui hopGui = HopGui.getInstance();
    TestingGuiPlugin helper = TestingGuiPlugin.getInstance();
    HopGuiPipelineGraph activePipelineGraph = HopGui.getActivePipelineGraph();
    if (activePipelineGraph == null) {
      return; // sorry, not active
    }

    // Get the list of unit tests for this one...
    //
    List<PipelineUnitTest> tests =
        TestingGuiPlugin.findPipelineUnitTest(
            variables, pipelineMeta, hopGui.getMetadataProvider());

    // See which ones are auto opening...
    //
    List<PipelineUnitTest> openTests = new ArrayList<>();
    tests.forEach(
        test -> {
          if (test.isAutoOpening()) {
            openTests.add(test);
          }
        });

    // Nothing to see here, move along!
    //
    if (openTests.isEmpty()) {
      return;
    }

    // A single test, simply select it.
    //
    if (openTests.size() >= 1) {
      PipelineUnitTest test = openTests.get(0);
      TestingGuiPlugin.selectUnitTest(pipelineMeta, test);
      return;
    }
  }
}
