/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.workflow.actions.sql;

import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.apache.hop.workflow.action.loadsave.WorkflowActionLoadSaveTestSupport;
import org.junit.ClassRule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class WorkflowActionSqlTest extends WorkflowActionLoadSaveTestSupport<ActionSql> {
  @ClassRule public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

  @Override
  protected Class<ActionSql> getActionClass() {
    return ActionSql.class;
  }

  @Override
  protected List<String> listAttributes() {
    return Arrays.asList(
        "sql",
        "useVariableSubstitution",
        "sqlFromFile",
        "sqlFilename",
        "sendOneStatement",
        "connection");
  }

  @Override
  protected Map<String, String> createGettersMap() {
    return toMap(
        "sql", "getSql",
        "useVariableSubstitution", "isUseVariableSubstitution",
        "sqlFromFile", "isSqlFromFile",
        "sqlFilename", "getSqlFilename",
        "sendOneStatement", "isSendOneStatement",
        "connection", "getConnection");
  }

  @Override
  protected Map<String, String> createSettersMap() {
    return toMap(
        "sql", "setSql",
        "useVariableSubstitution", "setUseVariableSubstitution",
        "sqlFromFile", "setSqlFromFile",
        "sqlFilename", "setSqlFilename",
        "sendOneStatement", "setSendOneStatement",
        "connection", "setConnection");
  }
}
