/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Arrays;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;

final class CompositeTestDescriptorVisitor
implements TestDescriptor.Visitor {
    private final TestDescriptor.Visitor[] visitors;

    static TestDescriptor.Visitor from(TestDescriptor.Visitor ... visitors) {
        Preconditions.notNull((Object)visitors, (String)"visitors must not be null");
        Preconditions.notEmpty((Object[])visitors, (String)"visitors must not be empty");
        Preconditions.containsNoNullElements((Object[])visitors, (String)"visitors must not contain any null elements");
        return visitors.length == 1 ? visitors[0] : new CompositeTestDescriptorVisitor(visitors);
    }

    private CompositeTestDescriptorVisitor(TestDescriptor.Visitor[] visitors) {
        this.visitors = Arrays.copyOf(visitors, visitors.length);
    }

    @Override
    public void visit(TestDescriptor descriptor) {
        for (TestDescriptor.Visitor visitor : this.visitors) {
            visitor.visit(descriptor);
        }
    }
}

