/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

import org.grails.plugins.databasemigration.DatabaseMigrationException
import org.grails.plugins.databasemigration.command.DbmChangelogToGroovy

description('Converts a changelog file to a Groovy DSL file') {
    usage 'grails [environment] dbm-changelog-to-groovy [src_file_name] [dest_file_name]'
    flag name: 'src_file_name', description: 'The name and path of the changelog file to convert'
    flag name: 'dest_file_name', description: 'The name and path of the Groovy file'
    flag name: 'dataSource', description: 'if provided will run the script for the specified dataSource creating a file named changelog-dataSource.groovy if a filename is not given. Not needed for the default dataSource'
    flag name: 'force', description: 'Whether to overwrite existing files'
    flag name: 'add', description: 'if provided will run the script for the specified dataSource. Not needed for the default dataSource.'
}

try {
    new DbmChangelogToGroovy().handle(executionContext)
} catch (DatabaseMigrationException e) {
    error e.message, e
}
