/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class ResetOffsetEvent
extends CompletableApplicationEvent<Void> {
    private final Collection<TopicPartition> topicPartitions;
    private final AutoOffsetResetStrategy offsetResetStrategy;

    public ResetOffsetEvent(Collection<TopicPartition> topicPartitions, AutoOffsetResetStrategy offsetResetStrategy, long deadline) {
        super(ApplicationEvent.Type.RESET_OFFSET, deadline);
        this.topicPartitions = Collections.unmodifiableCollection(topicPartitions);
        this.offsetResetStrategy = Objects.requireNonNull(offsetResetStrategy);
    }

    public Collection<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public AutoOffsetResetStrategy offsetResetStrategy() {
        return this.offsetResetStrategy;
    }

    @Override
    public String toStringBase() {
        return super.toStringBase() + ", topicPartitions=" + String.valueOf(this.topicPartitions) + ", offsetStrategy=" + String.valueOf(this.offsetResetStrategy);
    }
}

