/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import org.apache.empire.commons.BeanPropertyUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.data.Column;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.data.RecordData;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.context.DBContextAware;
import org.apache.empire.db.exceptions.FieldIllegalValueException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DBRecordData
extends DBObject
implements DBContextAware,
RecordData {
    private static final Logger log = LoggerFactory.getLogger(DBRecordData.class);

    @Override
    public abstract int getFieldCount();

    @Override
    public abstract int getFieldIndex(ColumnExpr var1);

    @Override
    public abstract int getFieldIndex(String var1);

    public abstract int addXmlMeta(Element var1);

    public abstract int addXmlData(Element var1);

    public abstract Document getXmlDocument();

    @Override
    public abstract Object getValue(int var1);

    @Override
    public <V> V getValue(int index, Class<V> valueType) {
        return ObjectUtils.convertColumnValue(this.getColumn(index), this.getValue(index), valueType);
    }

    @Override
    public final <V> V get(ColumnExpr column, Class<V> valueType) {
        return this.getValue(this.getFieldIndex(column), valueType);
    }

    @Override
    public Object get(ColumnExpr column) {
        int index = this.getFieldIndex(column);
        try {
            return this.getValue(index, ObjectUtils.coalesce(column.getEnumType(), Object.class));
        }
        catch (FieldIllegalValueException e) {
            Object value = this.getValue(index);
            log.error("The value \"{}\" for column {} could not be resolved.", value, (Object)column.getName());
            return value;
        }
    }

    @Override
    public boolean isNull(int index) {
        return ObjectUtils.isEmpty(this.getValue(index));
    }

    @Override
    public final boolean isNull(ColumnExpr column) {
        return this.isNull(this.getFieldIndex(column));
    }

    public boolean isZero(ColumnExpr column) {
        if (column == null || !column.getDataType().isNumeric()) {
            throw new InvalidArgumentException("column", column);
        }
        Object v = this.get(column);
        return v instanceof Number ? ObjectUtils.isZero((Number)v) : true;
    }

    public final String getString(int index) {
        return this.getValue(index, String.class);
    }

    public final String getString(ColumnExpr column) {
        return this.getString(this.getFieldIndex(column));
    }

    public final int getInt(int index) {
        Integer value = this.getValue(index, Integer.class);
        return value != null ? value : 0;
    }

    public final int getInt(ColumnExpr column) {
        return this.getInt(this.getFieldIndex(column));
    }

    public final long getLong(int index) {
        Long value = this.getValue(index, Long.class);
        return value != null ? value : 0L;
    }

    public final long getLong(ColumnExpr column) {
        return this.getLong(this.getFieldIndex(column));
    }

    public double getDouble(int index) {
        Double value = this.getValue(index, Double.class);
        return value != null ? value : 0.0;
    }

    public final double getDouble(ColumnExpr column) {
        return this.getDouble(this.getFieldIndex(column));
    }

    public final BigDecimal getDecimal(int index) {
        return this.getValue(index, BigDecimal.class);
    }

    public final BigDecimal getDecimal(ColumnExpr column) {
        return this.getDecimal(this.getFieldIndex(column));
    }

    public final boolean getBoolean(int index) {
        Boolean value = this.getValue(index, Boolean.class);
        return value != null ? value : false;
    }

    public final boolean getBoolean(ColumnExpr column) {
        return this.getBoolean(this.getFieldIndex(column));
    }

    public final Date getDate(int index) {
        return this.getValue(index, Date.class);
    }

    public final Date getDate(ColumnExpr column) {
        return this.getDate(this.getFieldIndex(column));
    }

    @Deprecated
    public final Date getDateTime(int index) {
        return this.getDate(index);
    }

    @Deprecated
    public final Date getDateTime(ColumnExpr column) {
        return this.getDate(column);
    }

    public final Timestamp getTimestamp(int index) {
        return this.getValue(index, Timestamp.class);
    }

    public final Timestamp getTimestamp(ColumnExpr column) {
        return this.getTimestamp(this.getFieldIndex(column));
    }

    public final LocalDate getLocalDate(int index) {
        return this.getValue(index, LocalDate.class);
    }

    public final LocalDate getLocalDate(ColumnExpr column) {
        return this.getLocalDate(this.getFieldIndex(column));
    }

    public final LocalDateTime getLocalDateTime(int index) {
        return this.getValue(index, LocalDateTime.class);
    }

    public final LocalDateTime getLocalDateTime(ColumnExpr column) {
        return this.getLocalDateTime(this.getFieldIndex(column));
    }

    public final <T extends Enum<?>> T getEnum(int index, Class<T> enumType) {
        return (T)((Enum)this.getValue(index, enumType));
    }

    public final <T extends Enum<?>> T getEnum(ColumnExpr column, Class<T> enumType) {
        return this.getEnum(this.getFieldIndex(column), enumType);
    }

    public final <T extends Enum<?>> T getEnum(Column column) {
        Class<Enum<?>> enumType = column.getEnumType();
        if (enumType == null) {
            throw new InvalidArgumentException("column", column);
        }
        return (T)this.getEnum(this.getFieldIndex(column), enumType);
    }

    public final Object[] getArray(ColumnExpr ... columns) {
        Object[] values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int index = this.getFieldIndex(columns[i]);
            if (index < 0) {
                throw new ItemNotFoundException((Object)columns[i].getName());
            }
            values[i] = this.getValue(index);
        }
        return values;
    }

    public String getText(ColumnExpr column) {
        Object value = this.get(column);
        return this.formatValue(column, value);
    }

    public final String getText(String name) {
        return this.getText(this.getColumn(this.getFieldIndex(name)));
    }

    @Override
    public int setBeanProperties(Object bean, Collection<? extends ColumnExpr> ignoreList) {
        int count = 0;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            ColumnExpr column = this.getColumn(i);
            if (ignoreList != null && ignoreList.contains(column)) continue;
            this.setBeanProperty(column, bean, this.getValue(i));
            ++count;
        }
        return count;
    }

    public final int setBeanProperties(Object bean) {
        return this.setBeanProperties(bean, null);
    }

    protected void setBeanProperty(ColumnExpr column, Object bean, Object value) {
        String property;
        Class<Enum<?>> enumType;
        if (value != null && (enumType = column.getEnumType()) != null) {
            value = ObjectUtils.getEnum(enumType, value);
        }
        if (!BeanPropertyUtils.setProperty(bean, property = column.getBeanPropertyName(), value) && log.isDebugEnabled()) {
            log.debug("The bean property \"{}\" coult not be set on {} and will be ignored!", (Object)property, (Object)bean.getClass().getName());
        }
    }

    protected String formatValue(ColumnExpr column, Object value) {
        return ObjectUtils.formatColumnValue(column, value, null);
    }
}

