/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.component.window;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.render.Renderer;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.jsf.impl.clientwindow.DeltaSpikeClientWindow;
import org.apache.deltaspike.jsf.impl.util.ClientWindowHelper;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindowConfig;

@FacesRenderer(componentFamily="jakarta.faces.Output", rendererType="org.apache.deltaspike.WindowIdHolder")
@ResourceDependencies(value={@ResourceDependency(library="deltaspike", name="windowhandler.js", target="head"), @ResourceDependency(library="jakarta.faces", name="faces.js", target="head")})
public class WindowIdHtmlRenderer
extends Renderer {
    private volatile ClientWindowConfig clientWindowConfig;
    private int maxWindowIdLength = 10;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Object cookie;
        super.encodeBegin(context, component);
        this.lazyInit();
        ClientWindowConfig.ClientWindowRenderMode clientWindowRenderMode = this.clientWindowConfig.getClientWindowRenderMode(context);
        boolean delegatedWindowMode = ClientWindowConfig.ClientWindowRenderMode.DELEGATED.equals((Object)clientWindowRenderMode);
        if (delegatedWindowMode) {
            return;
        }
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow == null && !(clientWindow instanceof DeltaSpikeClientWindow)) {
            return;
        }
        String windowId = clientWindow.getId();
        windowId = this.secureWindowId(windowId);
        ResponseWriter writer = context.getResponseWriter();
        writer.write("<script type=\"text/javascript\">");
        writer.write("(function(){");
        writer.write("dswh.init('");
        writer.writeText((Object)windowId, null);
        writer.write("','" + clientWindowRenderMode.name() + "'," + this.maxWindowIdLength + ",{");
        writer.write("'tokenizedRedirect':" + this.clientWindowConfig.isClientWindowTokenizedRedirectEnabled());
        writer.write(",'storeWindowTreeOnLinkClick':" + this.clientWindowConfig.isClientWindowStoreWindowTreeEnabledOnLinkClick());
        writer.write(",'storeWindowTreeOnButtonClick':" + this.clientWindowConfig.isClientWindowStoreWindowTreeEnabledOnButtonClick());
        if (((DeltaSpikeClientWindow)clientWindow).isInitialRedirectSupported(context) && (cookie = ClientWindowHelper.getRequestWindowIdCookie(context, windowId)) != null && cookie instanceof Cookie) {
            Cookie servletCookie = (Cookie)cookie;
            writer.write(",'initialRedirectWindowId':'" + this.secureWindowId(servletCookie.getValue()) + "'");
            servletCookie.setMaxAge(0);
            ((HttpServletResponse)context.getExternalContext().getResponse()).addCookie(servletCookie);
        }
        writer.write("});");
        writer.write("})();");
        writer.write("</script>");
    }

    protected String secureWindowId(String windowId) {
        if (windowId != null && windowId.length() > this.maxWindowIdLength) {
            windowId = windowId.substring(0, this.maxWindowIdLength);
        }
        return windowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (this.clientWindowConfig == null) {
            WindowIdHtmlRenderer windowIdHtmlRenderer = this;
            synchronized (windowIdHtmlRenderer) {
                if (this.clientWindowConfig == null) {
                    this.clientWindowConfig = (ClientWindowConfig)BeanProvider.getContextualReference(ClientWindowConfig.class, (Annotation[])new Annotation[0]);
                    this.maxWindowIdLength = ClientWindowHelper.getMaxWindowIdLength();
                }
            }
        }
    }
}

