/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.persistence.FlushModeType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.deltaspike.data.api.EntityManagerConfig;
import org.apache.deltaspike.data.impl.meta.EntityMetadata;
import org.apache.deltaspike.data.impl.meta.EntityMetadataInitializer;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadataInitializer;
import org.apache.deltaspike.jpa.api.entitymanager.EntityManagerResolver;
import org.apache.deltaspike.jpa.spi.entitymanager.QualifierBackedEntityManagerResolver;

@ApplicationScoped
public class RepositoryMetadataInitializer {
    private static final Logger log = Logger.getLogger(RepositoryMetadataInitializer.class.getName());
    @Inject
    private RepositoryMethodMetadataInitializer methodMetadataInitializer;
    @Inject
    private EntityMetadataInitializer entityMetadataInitializer;

    public RepositoryMetadata init(Class<?> repositoryClass, BeanManager beanManager) {
        EntityMetadata entityMetadata;
        RepositoryMetadata repositoryMetadata = new RepositoryMetadata(repositoryClass);
        if (!repositoryMetadata.readFrom(repositoryClass, beanManager)) {
            repositoryMetadata.setEntityManagerResolverClass(this.extractEntityManagerResolver(repositoryClass));
            repositoryMetadata.setEntityManagerFlushMode(this.extractEntityManagerFlushMode(repositoryClass));
            if (repositoryMetadata.getEntityManagerResolverClass() != null) {
                Set beans = beanManager.getBeans((Type)repositoryMetadata.getEntityManagerResolverClass(), new Annotation[0]);
                Class scope = beanManager.resolve(beans).getScope();
                repositoryMetadata.setEntityManagerResolverIsNormalScope(beanManager.isNormalScope(scope));
            } else {
                QualifierBackedEntityManagerResolver resolver = repositoryMetadata.getQualifiers() != null ? new QualifierBackedEntityManagerResolver(beanManager, repositoryMetadata.getQualifiers()) : new QualifierBackedEntityManagerResolver(beanManager, new Class[]{Default.class});
                repositoryMetadata.setUnmanagedResolver((EntityManagerResolver)resolver);
                repositoryMetadata.setEntityManagerResolverIsNormalScope(false);
            }
        }
        if ((entityMetadata = this.entityMetadataInitializer.init(repositoryMetadata)) == null) {
            return null;
        }
        repositoryMetadata.setEntityMetadata(entityMetadata);
        this.initializeMethodsMetadata(repositoryMetadata, beanManager);
        return repositoryMetadata;
    }

    private void initializeMethodsMetadata(RepositoryMetadata repositoryMetadata, BeanManager beanManager) {
        repositoryMetadata.setMethodsMetadata(new HashMap<Method, RepositoryMethodMetadata>());
        HashSet allImplemented = new HashSet();
        this.collectClasses(repositoryMetadata.getRepositoryClass(), allImplemented);
        log.log(Level.FINER, "collectClasses(): Found {0} for {1}", new Object[]{allImplemented, repositoryMetadata.getRepositoryClass()});
        for (Class clazz : allImplemented) {
            Method[] repositoryMethods;
            for (Method repositoryMethod : repositoryMethods = clazz.getDeclaredMethods()) {
                RepositoryMethodMetadata methodMetadata = this.methodMetadataInitializer.init(repositoryMetadata, repositoryMethod, beanManager);
                repositoryMetadata.getMethodsMetadata().put(repositoryMethod, methodMetadata);
            }
        }
    }

    private void collectClasses(Class<?> cls, Set<Class<?>> result) {
        if (cls == null || cls == Object.class) {
            return;
        }
        result.add(cls);
        for (Class<?> child : cls.getInterfaces()) {
            this.collectClasses(child, result);
        }
        this.collectClasses(cls.getSuperclass(), result);
    }

    private Class<? extends EntityManagerResolver> extractEntityManagerResolver(Class<?> clazz) {
        EntityManagerConfig config = this.extractEntityManagerConfig(clazz);
        if (config != null && !EntityManagerResolver.class.equals((Object)config.entityManagerResolver())) {
            return config.entityManagerResolver();
        }
        return null;
    }

    private FlushModeType extractEntityManagerFlushMode(Class<?> clazz) {
        EntityManagerConfig config = this.extractEntityManagerConfig(clazz);
        if (config != null) {
            return config.flushMode();
        }
        return null;
    }

    private EntityManagerConfig extractEntityManagerConfig(Class<?> clazz) {
        if (clazz.isAnnotationPresent(EntityManagerConfig.class)) {
            return clazz.getAnnotation(EntityManagerConfig.class);
        }
        return null;
    }
}

