// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import { css } from '@microsoft/fast-element';
import { display, } from '@microsoft/fast-foundation';
import { badgeBackground, badgeForeground, borderWidth, buttonBorder, designUnit, fontFamily, typeRampMinus1FontSize, typeRampMinus1LineHeight, } from '../design-tokens.js';
export const badgeStyles = (context, definition) => css `
	${display('inline-block')} :host {
		box-sizing: border-box;
		font-family: ${fontFamily};
		font-size: ${typeRampMinus1FontSize};
		line-height: ${typeRampMinus1LineHeight};
		text-align: center;
	}
	.control {
		align-items: center;
		background-color: ${badgeBackground};
		border: calc(${borderWidth} * 1px) solid ${buttonBorder};
		border-radius: 11px;
		box-sizing: border-box;
		color: ${badgeForeground};
		display: flex;
		height: calc(${designUnit} * 4px);
		justify-content: center;
		min-width: calc(${designUnit} * 4px + 2px);
		min-height: calc(${designUnit} * 4px + 2px);
		padding: 3px 6px;
	}
`;
