var __defProp = Object.defineProperty;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
(function() {
  "use strict";
  var _commit_callbacks, _discard_callbacks, _pending, _blocking_pending, _deferred, _dirty_effects, _maybe_dirty_effects, _Batch_instances, traverse_effect_tree_fn, defer_effects_fn, resolve_fn, commit_fn, _pending2, _anchor, _hydrate_open, _props, _children, _effect, _main_effect, _pending_effect, _failed_effect, _offscreen_fragment, _pending_anchor, _local_pending_count, _pending_count, _is_creating_fallback, _effect_pending, _effect_pending_subscriber, _Boundary_instances, hydrate_resolved_content_fn, hydrate_pending_content_fn, get_anchor_fn, run_fn, show_pending_snippet_fn, update_pending_count_fn, _batches, _onscreen, _offscreen, _transition, _commit, _discard, _a;
  const DEV = false;
  var is_array = Array.isArray;
  var index_of = Array.prototype.indexOf;
  var array_from = Array.from;
  var define_property = Object.defineProperty;
  var get_descriptor = Object.getOwnPropertyDescriptor;
  var get_descriptors = Object.getOwnPropertyDescriptors;
  var object_prototype = Object.prototype;
  var array_prototype = Array.prototype;
  var get_prototype_of = Object.getPrototypeOf;
  var is_extensible = Object.isExtensible;
  const noop = () => {
  };
  function run(fn) {
    return fn();
  }
  function run_all(arr) {
    for (var i = 0; i < arr.length; i++) {
      arr[i]();
    }
  }
  function deferred() {
    var resolve;
    var reject;
    var promise = new Promise((res, rej) => {
      resolve = res;
      reject = rej;
    });
    return { promise, resolve, reject };
  }
  const DERIVED = 1 << 1;
  const EFFECT = 1 << 2;
  const RENDER_EFFECT = 1 << 3;
  const BLOCK_EFFECT = 1 << 4;
  const BRANCH_EFFECT = 1 << 5;
  const ROOT_EFFECT = 1 << 6;
  const BOUNDARY_EFFECT = 1 << 7;
  const CONNECTED = 1 << 9;
  const CLEAN = 1 << 10;
  const DIRTY = 1 << 11;
  const MAYBE_DIRTY = 1 << 12;
  const INERT = 1 << 13;
  const DESTROYED = 1 << 14;
  const EFFECT_RAN = 1 << 15;
  const EFFECT_TRANSPARENT = 1 << 16;
  const EAGER_EFFECT = 1 << 17;
  const HEAD_EFFECT = 1 << 18;
  const EFFECT_PRESERVED = 1 << 19;
  const USER_EFFECT = 1 << 20;
  const WAS_MARKED = 1 << 15;
  const REACTION_IS_UPDATING = 1 << 21;
  const ASYNC = 1 << 22;
  const ERROR_VALUE = 1 << 23;
  const STATE_SYMBOL = Symbol("$state");
  const LEGACY_PROPS = Symbol("legacy props");
  const LOADING_ATTR_SYMBOL = Symbol("");
  const STALE_REACTION = new class StaleReactionError extends Error {
    constructor() {
      super(...arguments);
      __publicField(this, "name", "StaleReactionError");
      __publicField(this, "message", "The reaction that called `getAbortSignal()` was re-run or destroyed");
    }
  }();
  function lifecycle_outside_component(name) {
    {
      throw new Error(`https://svelte.dev/e/lifecycle_outside_component`);
    }
  }
  function async_derived_orphan() {
    {
      throw new Error(`https://svelte.dev/e/async_derived_orphan`);
    }
  }
  function effect_in_teardown(rune) {
    {
      throw new Error(`https://svelte.dev/e/effect_in_teardown`);
    }
  }
  function effect_in_unowned_derived() {
    {
      throw new Error(`https://svelte.dev/e/effect_in_unowned_derived`);
    }
  }
  function effect_orphan(rune) {
    {
      throw new Error(`https://svelte.dev/e/effect_orphan`);
    }
  }
  function effect_update_depth_exceeded() {
    {
      throw new Error(`https://svelte.dev/e/effect_update_depth_exceeded`);
    }
  }
  function props_invalid_value(key2) {
    {
      throw new Error(`https://svelte.dev/e/props_invalid_value`);
    }
  }
  function state_descriptors_fixed() {
    {
      throw new Error(`https://svelte.dev/e/state_descriptors_fixed`);
    }
  }
  function state_prototype_fixed() {
    {
      throw new Error(`https://svelte.dev/e/state_prototype_fixed`);
    }
  }
  function state_unsafe_mutation() {
    {
      throw new Error(`https://svelte.dev/e/state_unsafe_mutation`);
    }
  }
  function svelte_boundary_reset_onerror() {
    {
      throw new Error(`https://svelte.dev/e/svelte_boundary_reset_onerror`);
    }
  }
  const EACH_ITEM_REACTIVE = 1;
  const EACH_INDEX_REACTIVE = 1 << 1;
  const EACH_IS_CONTROLLED = 1 << 2;
  const EACH_IS_ANIMATED = 1 << 3;
  const EACH_ITEM_IMMUTABLE = 1 << 4;
  const PROPS_IS_IMMUTABLE = 1;
  const PROPS_IS_RUNES = 1 << 1;
  const PROPS_IS_UPDATED = 1 << 2;
  const PROPS_IS_BINDABLE = 1 << 3;
  const PROPS_IS_LAZY_INITIAL = 1 << 4;
  const TEMPLATE_FRAGMENT = 1;
  const TEMPLATE_USE_IMPORT_NODE = 1 << 1;
  const UNINITIALIZED = Symbol();
  const NAMESPACE_HTML = "http://www.w3.org/1999/xhtml";
  function select_multiple_invalid_value() {
    {
      console.warn(`https://svelte.dev/e/select_multiple_invalid_value`);
    }
  }
  function svelte_boundary_reset_noop() {
    {
      console.warn(`https://svelte.dev/e/svelte_boundary_reset_noop`);
    }
  }
  let hydrating = false;
  function equals(value) {
    return value === this.v;
  }
  function safe_not_equal(a, b) {
    return a != a ? b == b : a !== b || a !== null && typeof a === "object" || typeof a === "function";
  }
  function safe_equals(value) {
    return !safe_not_equal(value, this.v);
  }
  let legacy_mode_flag = false;
  let tracing_mode_flag = false;
  function enable_legacy_mode_flag() {
    legacy_mode_flag = true;
  }
  let component_context = null;
  function set_component_context(context) {
    component_context = context;
  }
  function push(props, runes = false, fn) {
    component_context = {
      p: component_context,
      i: false,
      c: null,
      e: null,
      s: props,
      x: null,
      l: legacy_mode_flag && !runes ? { s: null, u: null, $: [] } : null
    };
  }
  function pop(component) {
    var context = (
      /** @type {ComponentContext} */
      component_context
    );
    var effects = context.e;
    if (effects !== null) {
      context.e = null;
      for (var fn of effects) {
        create_user_effect(fn);
      }
    }
    if (component !== void 0) {
      context.x = component;
    }
    context.i = true;
    component_context = context.p;
    return component ?? /** @type {T} */
    {};
  }
  function is_runes() {
    return !legacy_mode_flag || component_context !== null && component_context.l === null;
  }
  let micro_tasks = [];
  function run_micro_tasks() {
    var tasks = micro_tasks;
    micro_tasks = [];
    run_all(tasks);
  }
  function queue_micro_task(fn) {
    if (micro_tasks.length === 0 && !is_flushing_sync) {
      var tasks = micro_tasks;
      queueMicrotask(() => {
        if (tasks === micro_tasks) run_micro_tasks();
      });
    }
    micro_tasks.push(fn);
  }
  function flush_tasks() {
    while (micro_tasks.length > 0) {
      run_micro_tasks();
    }
  }
  function handle_error(error) {
    var effect2 = active_effect;
    if (effect2 === null) {
      active_reaction.f |= ERROR_VALUE;
      return error;
    }
    if ((effect2.f & EFFECT_RAN) === 0) {
      if ((effect2.f & BOUNDARY_EFFECT) === 0) {
        throw error;
      }
      effect2.b.error(error);
    } else {
      invoke_error_boundary(error, effect2);
    }
  }
  function invoke_error_boundary(error, effect2) {
    while (effect2 !== null) {
      if ((effect2.f & BOUNDARY_EFFECT) !== 0) {
        try {
          effect2.b.error(error);
          return;
        } catch (e) {
          error = e;
        }
      }
      effect2 = effect2.parent;
    }
    throw error;
  }
  const batches = /* @__PURE__ */ new Set();
  let current_batch = null;
  let previous_batch = null;
  let batch_values = null;
  let queued_root_effects = [];
  let last_scheduled_effect = null;
  let is_flushing = false;
  let is_flushing_sync = false;
  const _Batch = class _Batch {
    constructor() {
      __privateAdd(this, _Batch_instances);
      __publicField(this, "committed", false);
      /**
       * The current values of any sources that are updated in this batch
       * They keys of this map are identical to `this.#previous`
       * @type {Map<Source, any>}
       */
      __publicField(this, "current", /* @__PURE__ */ new Map());
      /**
       * The values of any sources that are updated in this batch _before_ those updates took place.
       * They keys of this map are identical to `this.#current`
       * @type {Map<Source, any>}
       */
      __publicField(this, "previous", /* @__PURE__ */ new Map());
      /**
       * When the batch is committed (and the DOM is updated), we need to remove old branches
       * and append new ones by calling the functions added inside (if/each/key/etc) blocks
       * @type {Set<() => void>}
       */
      __privateAdd(this, _commit_callbacks, /* @__PURE__ */ new Set());
      /**
       * If a fork is discarded, we need to destroy any effects that are no longer needed
       * @type {Set<(batch: Batch) => void>}
       */
      __privateAdd(this, _discard_callbacks, /* @__PURE__ */ new Set());
      /**
       * The number of async effects that are currently in flight
       */
      __privateAdd(this, _pending, 0);
      /**
       * The number of async effects that are currently in flight, _not_ inside a pending boundary
       */
      __privateAdd(this, _blocking_pending, 0);
      /**
       * A deferred that resolves when the batch is committed, used with `settled()`
       * TODO replace with Promise.withResolvers once supported widely enough
       * @type {{ promise: Promise<void>, resolve: (value?: any) => void, reject: (reason: unknown) => void } | null}
       */
      __privateAdd(this, _deferred, null);
      /**
       * Deferred effects (which run after async work has completed) that are DIRTY
       * @type {Effect[]}
       */
      __privateAdd(this, _dirty_effects, []);
      /**
       * Deferred effects that are MAYBE_DIRTY
       * @type {Effect[]}
       */
      __privateAdd(this, _maybe_dirty_effects, []);
      /**
       * A set of branches that still exist, but will be destroyed when this batch
       * is committed — we skip over these during `process`
       * @type {Set<Effect>}
       */
      __publicField(this, "skipped_effects", /* @__PURE__ */ new Set());
      __publicField(this, "is_fork", false);
    }
    /**
     *
     * @param {Effect[]} root_effects
     */
    process(root_effects) {
      var _a2;
      queued_root_effects = [];
      previous_batch = null;
      this.apply();
      var target = {
        parent: null,
        effect: null,
        effects: [],
        render_effects: [],
        block_effects: []
      };
      for (const root2 of root_effects) {
        __privateMethod(this, _Batch_instances, traverse_effect_tree_fn).call(this, root2, target);
      }
      if (!this.is_fork) {
        __privateMethod(this, _Batch_instances, resolve_fn).call(this);
      }
      if (__privateGet(this, _blocking_pending) > 0 || this.is_fork) {
        __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.effects);
        __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.render_effects);
        __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.block_effects);
      } else {
        previous_batch = this;
        current_batch = null;
        flush_queued_effects(target.render_effects);
        flush_queued_effects(target.effects);
        previous_batch = null;
        (_a2 = __privateGet(this, _deferred)) == null ? void 0 : _a2.resolve();
      }
      batch_values = null;
    }
    /**
     * Associate a change to a given source with the current
     * batch, noting its previous and current values
     * @param {Source} source
     * @param {any} value
     */
    capture(source2, value) {
      if (!this.previous.has(source2)) {
        this.previous.set(source2, value);
      }
      if ((source2.f & ERROR_VALUE) === 0) {
        this.current.set(source2, source2.v);
        batch_values == null ? void 0 : batch_values.set(source2, source2.v);
      }
    }
    activate() {
      current_batch = this;
      this.apply();
    }
    deactivate() {
      current_batch = null;
      batch_values = null;
    }
    flush() {
      this.activate();
      if (queued_root_effects.length > 0) {
        flush_effects();
        if (current_batch !== null && current_batch !== this) {
          return;
        }
      } else if (__privateGet(this, _pending) === 0) {
        this.process([]);
      }
      this.deactivate();
    }
    discard() {
      for (const fn of __privateGet(this, _discard_callbacks)) fn(this);
      __privateGet(this, _discard_callbacks).clear();
    }
    /**
     *
     * @param {boolean} blocking
     */
    increment(blocking) {
      __privateSet(this, _pending, __privateGet(this, _pending) + 1);
      if (blocking) __privateSet(this, _blocking_pending, __privateGet(this, _blocking_pending) + 1);
    }
    /**
     *
     * @param {boolean} blocking
     */
    decrement(blocking) {
      __privateSet(this, _pending, __privateGet(this, _pending) - 1);
      if (blocking) __privateSet(this, _blocking_pending, __privateGet(this, _blocking_pending) - 1);
      this.revive();
    }
    revive() {
      for (const e of __privateGet(this, _dirty_effects)) {
        set_signal_status(e, DIRTY);
        schedule_effect(e);
      }
      for (const e of __privateGet(this, _maybe_dirty_effects)) {
        set_signal_status(e, MAYBE_DIRTY);
        schedule_effect(e);
      }
      __privateSet(this, _dirty_effects, []);
      __privateSet(this, _maybe_dirty_effects, []);
      this.flush();
    }
    /** @param {() => void} fn */
    oncommit(fn) {
      __privateGet(this, _commit_callbacks).add(fn);
    }
    /** @param {(batch: Batch) => void} fn */
    ondiscard(fn) {
      __privateGet(this, _discard_callbacks).add(fn);
    }
    settled() {
      return (__privateGet(this, _deferred) ?? __privateSet(this, _deferred, deferred())).promise;
    }
    static ensure() {
      if (current_batch === null) {
        const batch = current_batch = new _Batch();
        batches.add(current_batch);
        if (!is_flushing_sync) {
          _Batch.enqueue(() => {
            if (current_batch !== batch) {
              return;
            }
            batch.flush();
          });
        }
      }
      return current_batch;
    }
    /** @param {() => void} task */
    static enqueue(task) {
      queue_micro_task(task);
    }
    apply() {
      return;
    }
  };
  _commit_callbacks = new WeakMap();
  _discard_callbacks = new WeakMap();
  _pending = new WeakMap();
  _blocking_pending = new WeakMap();
  _deferred = new WeakMap();
  _dirty_effects = new WeakMap();
  _maybe_dirty_effects = new WeakMap();
  _Batch_instances = new WeakSet();
  /**
   * Traverse the effect tree, executing effects or stashing
   * them for later execution as appropriate
   * @param {Effect} root
   * @param {EffectTarget} target
   */
  traverse_effect_tree_fn = function(root2, target) {
    var _a2;
    root2.f ^= CLEAN;
    var effect2 = root2.first;
    while (effect2 !== null) {
      var flags2 = effect2.f;
      var is_branch = (flags2 & (BRANCH_EFFECT | ROOT_EFFECT)) !== 0;
      var is_skippable_branch = is_branch && (flags2 & CLEAN) !== 0;
      var skip = is_skippable_branch || (flags2 & INERT) !== 0 || this.skipped_effects.has(effect2);
      if ((effect2.f & BOUNDARY_EFFECT) !== 0 && ((_a2 = effect2.b) == null ? void 0 : _a2.is_pending())) {
        target = {
          parent: target,
          effect: effect2,
          effects: [],
          render_effects: [],
          block_effects: []
        };
      }
      if (!skip && effect2.fn !== null) {
        if (is_branch) {
          effect2.f ^= CLEAN;
        } else if ((flags2 & EFFECT) !== 0) {
          target.effects.push(effect2);
        } else if (is_dirty(effect2)) {
          if ((effect2.f & BLOCK_EFFECT) !== 0) target.block_effects.push(effect2);
          update_effect(effect2);
        }
        var child2 = effect2.first;
        if (child2 !== null) {
          effect2 = child2;
          continue;
        }
      }
      var parent = effect2.parent;
      effect2 = effect2.next;
      while (effect2 === null && parent !== null) {
        if (parent === target.effect) {
          __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.effects);
          __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.render_effects);
          __privateMethod(this, _Batch_instances, defer_effects_fn).call(this, target.block_effects);
          target = /** @type {EffectTarget} */
          target.parent;
        }
        effect2 = parent.next;
        parent = parent.parent;
      }
    }
  };
  /**
   * @param {Effect[]} effects
   */
  defer_effects_fn = function(effects) {
    for (const e of effects) {
      const target = (e.f & DIRTY) !== 0 ? __privateGet(this, _dirty_effects) : __privateGet(this, _maybe_dirty_effects);
      target.push(e);
      set_signal_status(e, CLEAN);
    }
  };
  resolve_fn = function() {
    if (__privateGet(this, _blocking_pending) === 0) {
      for (const fn of __privateGet(this, _commit_callbacks)) fn();
      __privateGet(this, _commit_callbacks).clear();
    }
    if (__privateGet(this, _pending) === 0) {
      __privateMethod(this, _Batch_instances, commit_fn).call(this);
    }
  };
  commit_fn = function() {
    var _a2;
    if (batches.size > 1) {
      this.previous.clear();
      var previous_batch_values = batch_values;
      var is_earlier = true;
      var dummy_target = {
        parent: null,
        effect: null,
        effects: [],
        render_effects: [],
        block_effects: []
      };
      for (const batch of batches) {
        if (batch === this) {
          is_earlier = false;
          continue;
        }
        const sources = [];
        for (const [source2, value] of this.current) {
          if (batch.current.has(source2)) {
            if (is_earlier && value !== batch.current.get(source2)) {
              batch.current.set(source2, value);
            } else {
              continue;
            }
          }
          sources.push(source2);
        }
        if (sources.length === 0) {
          continue;
        }
        const others = [...batch.current.keys()].filter((s) => !this.current.has(s));
        if (others.length > 0) {
          const marked = /* @__PURE__ */ new Set();
          const checked = /* @__PURE__ */ new Map();
          for (const source2 of sources) {
            mark_effects(source2, others, marked, checked);
          }
          if (queued_root_effects.length > 0) {
            current_batch = batch;
            batch.apply();
            for (const root2 of queued_root_effects) {
              __privateMethod(_a2 = batch, _Batch_instances, traverse_effect_tree_fn).call(_a2, root2, dummy_target);
            }
            queued_root_effects = [];
            batch.deactivate();
          }
        }
      }
      current_batch = null;
      batch_values = previous_batch_values;
    }
    this.committed = true;
    batches.delete(this);
  };
  let Batch = _Batch;
  function flushSync(fn) {
    var was_flushing_sync = is_flushing_sync;
    is_flushing_sync = true;
    try {
      var result;
      if (fn) ;
      while (true) {
        flush_tasks();
        if (queued_root_effects.length === 0) {
          current_batch == null ? void 0 : current_batch.flush();
          if (queued_root_effects.length === 0) {
            last_scheduled_effect = null;
            return (
              /** @type {T} */
              result
            );
          }
        }
        flush_effects();
      }
    } finally {
      is_flushing_sync = was_flushing_sync;
    }
  }
  function flush_effects() {
    var was_updating_effect = is_updating_effect;
    is_flushing = true;
    try {
      var flush_count = 0;
      set_is_updating_effect(true);
      while (queued_root_effects.length > 0) {
        var batch = Batch.ensure();
        if (flush_count++ > 1e3) {
          var updates, entry;
          if (DEV) ;
          infinite_loop_guard();
        }
        batch.process(queued_root_effects);
        old_values.clear();
      }
    } finally {
      is_flushing = false;
      set_is_updating_effect(was_updating_effect);
      last_scheduled_effect = null;
    }
  }
  function infinite_loop_guard() {
    try {
      effect_update_depth_exceeded();
    } catch (error) {
      invoke_error_boundary(error, last_scheduled_effect);
    }
  }
  let eager_block_effects = null;
  function flush_queued_effects(effects) {
    var length = effects.length;
    if (length === 0) return;
    var i = 0;
    while (i < length) {
      var effect2 = effects[i++];
      if ((effect2.f & (DESTROYED | INERT)) === 0 && is_dirty(effect2)) {
        eager_block_effects = /* @__PURE__ */ new Set();
        update_effect(effect2);
        if (effect2.deps === null && effect2.first === null && effect2.nodes_start === null) {
          if (effect2.teardown === null && effect2.ac === null) {
            unlink_effect(effect2);
          } else {
            effect2.fn = null;
          }
        }
        if ((eager_block_effects == null ? void 0 : eager_block_effects.size) > 0) {
          old_values.clear();
          for (const e of eager_block_effects) {
            if ((e.f & (DESTROYED | INERT)) !== 0) continue;
            const ordered_effects = [e];
            let ancestor = e.parent;
            while (ancestor !== null) {
              if (eager_block_effects.has(ancestor)) {
                eager_block_effects.delete(ancestor);
                ordered_effects.push(ancestor);
              }
              ancestor = ancestor.parent;
            }
            for (let j = ordered_effects.length - 1; j >= 0; j--) {
              const e2 = ordered_effects[j];
              if ((e2.f & (DESTROYED | INERT)) !== 0) continue;
              update_effect(e2);
            }
          }
          eager_block_effects.clear();
        }
      }
    }
    eager_block_effects = null;
  }
  function mark_effects(value, sources, marked, checked) {
    if (marked.has(value)) return;
    marked.add(value);
    if (value.reactions !== null) {
      for (const reaction of value.reactions) {
        const flags2 = reaction.f;
        if ((flags2 & DERIVED) !== 0) {
          mark_effects(
            /** @type {Derived} */
            reaction,
            sources,
            marked,
            checked
          );
        } else if ((flags2 & (ASYNC | BLOCK_EFFECT)) !== 0 && (flags2 & DIRTY) === 0 && // we may have scheduled this one already
        depends_on(reaction, sources, checked)) {
          set_signal_status(reaction, DIRTY);
          schedule_effect(
            /** @type {Effect} */
            reaction
          );
        }
      }
    }
  }
  function depends_on(reaction, sources, checked) {
    const depends = checked.get(reaction);
    if (depends !== void 0) return depends;
    if (reaction.deps !== null) {
      for (const dep of reaction.deps) {
        if (sources.includes(dep)) {
          return true;
        }
        if ((dep.f & DERIVED) !== 0 && depends_on(
          /** @type {Derived} */
          dep,
          sources,
          checked
        )) {
          checked.set(
            /** @type {Derived} */
            dep,
            true
          );
          return true;
        }
      }
    }
    checked.set(reaction, false);
    return false;
  }
  function schedule_effect(signal) {
    var effect2 = last_scheduled_effect = signal;
    while (effect2.parent !== null) {
      effect2 = effect2.parent;
      var flags2 = effect2.f;
      if (is_flushing && effect2 === active_effect && (flags2 & BLOCK_EFFECT) !== 0 && (flags2 & HEAD_EFFECT) === 0) {
        return;
      }
      if ((flags2 & (ROOT_EFFECT | BRANCH_EFFECT)) !== 0) {
        if ((flags2 & CLEAN) === 0) return;
        effect2.f ^= CLEAN;
      }
    }
    queued_root_effects.push(effect2);
  }
  function createSubscriber(start) {
    let subscribers = 0;
    let version = source(0);
    let stop;
    return () => {
      if (effect_tracking()) {
        get$1(version);
        render_effect(() => {
          if (subscribers === 0) {
            stop = untrack(() => start(() => increment(version)));
          }
          subscribers += 1;
          return () => {
            queue_micro_task(() => {
              subscribers -= 1;
              if (subscribers === 0) {
                stop == null ? void 0 : stop();
                stop = void 0;
                increment(version);
              }
            });
          };
        });
      }
    };
  }
  var flags = EFFECT_TRANSPARENT | EFFECT_PRESERVED | BOUNDARY_EFFECT;
  function boundary(node, props, children) {
    new Boundary(node, props, children);
  }
  class Boundary {
    /**
     * @param {TemplateNode} node
     * @param {BoundaryProps} props
     * @param {((anchor: Node) => void)} children
     */
    constructor(node, props, children) {
      __privateAdd(this, _Boundary_instances);
      /** @type {Boundary | null} */
      __publicField(this, "parent");
      __privateAdd(this, _pending2, false);
      /** @type {TemplateNode} */
      __privateAdd(this, _anchor);
      /** @type {TemplateNode | null} */
      __privateAdd(this, _hydrate_open, null);
      /** @type {BoundaryProps} */
      __privateAdd(this, _props);
      /** @type {((anchor: Node) => void)} */
      __privateAdd(this, _children);
      /** @type {Effect} */
      __privateAdd(this, _effect);
      /** @type {Effect | null} */
      __privateAdd(this, _main_effect, null);
      /** @type {Effect | null} */
      __privateAdd(this, _pending_effect, null);
      /** @type {Effect | null} */
      __privateAdd(this, _failed_effect, null);
      /** @type {DocumentFragment | null} */
      __privateAdd(this, _offscreen_fragment, null);
      /** @type {TemplateNode | null} */
      __privateAdd(this, _pending_anchor, null);
      __privateAdd(this, _local_pending_count, 0);
      __privateAdd(this, _pending_count, 0);
      __privateAdd(this, _is_creating_fallback, false);
      /**
       * A source containing the number of pending async deriveds/expressions.
       * Only created if `$effect.pending()` is used inside the boundary,
       * otherwise updating the source results in needless `Batch.ensure()`
       * calls followed by no-op flushes
       * @type {Source<number> | null}
       */
      __privateAdd(this, _effect_pending, null);
      __privateAdd(this, _effect_pending_subscriber, createSubscriber(() => {
        __privateSet(this, _effect_pending, source(__privateGet(this, _local_pending_count)));
        return () => {
          __privateSet(this, _effect_pending, null);
        };
      }));
      __privateSet(this, _anchor, node);
      __privateSet(this, _props, props);
      __privateSet(this, _children, children);
      this.parent = /** @type {Effect} */
      active_effect.b;
      __privateSet(this, _pending2, !!__privateGet(this, _props).pending);
      __privateSet(this, _effect, block(() => {
        active_effect.b = this;
        {
          var anchor = __privateMethod(this, _Boundary_instances, get_anchor_fn).call(this);
          try {
            __privateSet(this, _main_effect, branch(() => children(anchor)));
          } catch (error) {
            this.error(error);
          }
          if (__privateGet(this, _pending_count) > 0) {
            __privateMethod(this, _Boundary_instances, show_pending_snippet_fn).call(this);
          } else {
            __privateSet(this, _pending2, false);
          }
        }
        return () => {
          var _a2;
          (_a2 = __privateGet(this, _pending_anchor)) == null ? void 0 : _a2.remove();
        };
      }, flags));
    }
    /**
     * Returns `true` if the effect exists inside a boundary whose pending snippet is shown
     * @returns {boolean}
     */
    is_pending() {
      return __privateGet(this, _pending2) || !!this.parent && this.parent.is_pending();
    }
    has_pending_snippet() {
      return !!__privateGet(this, _props).pending;
    }
    /**
     * Update the source that powers `$effect.pending()` inside this boundary,
     * and controls when the current `pending` snippet (if any) is removed.
     * Do not call from inside the class
     * @param {1 | -1} d
     */
    update_pending_count(d) {
      __privateMethod(this, _Boundary_instances, update_pending_count_fn).call(this, d);
      __privateSet(this, _local_pending_count, __privateGet(this, _local_pending_count) + d);
      if (__privateGet(this, _effect_pending)) {
        internal_set(__privateGet(this, _effect_pending), __privateGet(this, _local_pending_count));
      }
    }
    get_effect_pending() {
      __privateGet(this, _effect_pending_subscriber).call(this);
      return get$1(
        /** @type {Source<number>} */
        __privateGet(this, _effect_pending)
      );
    }
    /** @param {unknown} error */
    error(error) {
      var onerror = __privateGet(this, _props).onerror;
      let failed = __privateGet(this, _props).failed;
      if (__privateGet(this, _is_creating_fallback) || !onerror && !failed) {
        throw error;
      }
      if (__privateGet(this, _main_effect)) {
        destroy_effect(__privateGet(this, _main_effect));
        __privateSet(this, _main_effect, null);
      }
      if (__privateGet(this, _pending_effect)) {
        destroy_effect(__privateGet(this, _pending_effect));
        __privateSet(this, _pending_effect, null);
      }
      if (__privateGet(this, _failed_effect)) {
        destroy_effect(__privateGet(this, _failed_effect));
        __privateSet(this, _failed_effect, null);
      }
      var did_reset = false;
      var calling_on_error = false;
      const reset = () => {
        if (did_reset) {
          svelte_boundary_reset_noop();
          return;
        }
        did_reset = true;
        if (calling_on_error) {
          svelte_boundary_reset_onerror();
        }
        Batch.ensure();
        __privateSet(this, _local_pending_count, 0);
        if (__privateGet(this, _failed_effect) !== null) {
          pause_effect(__privateGet(this, _failed_effect), () => {
            __privateSet(this, _failed_effect, null);
          });
        }
        __privateSet(this, _pending2, this.has_pending_snippet());
        __privateSet(this, _main_effect, __privateMethod(this, _Boundary_instances, run_fn).call(this, () => {
          __privateSet(this, _is_creating_fallback, false);
          return branch(() => __privateGet(this, _children).call(this, __privateGet(this, _anchor)));
        }));
        if (__privateGet(this, _pending_count) > 0) {
          __privateMethod(this, _Boundary_instances, show_pending_snippet_fn).call(this);
        } else {
          __privateSet(this, _pending2, false);
        }
      };
      var previous_reaction = active_reaction;
      try {
        set_active_reaction(null);
        calling_on_error = true;
        onerror == null ? void 0 : onerror(error, reset);
        calling_on_error = false;
      } catch (error2) {
        invoke_error_boundary(error2, __privateGet(this, _effect) && __privateGet(this, _effect).parent);
      } finally {
        set_active_reaction(previous_reaction);
      }
      if (failed) {
        queue_micro_task(() => {
          __privateSet(this, _failed_effect, __privateMethod(this, _Boundary_instances, run_fn).call(this, () => {
            Batch.ensure();
            __privateSet(this, _is_creating_fallback, true);
            try {
              return branch(() => {
                failed(
                  __privateGet(this, _anchor),
                  () => error,
                  () => reset
                );
              });
            } catch (error2) {
              invoke_error_boundary(
                error2,
                /** @type {Effect} */
                __privateGet(this, _effect).parent
              );
              return null;
            } finally {
              __privateSet(this, _is_creating_fallback, false);
            }
          }));
        });
      }
    }
  }
  _pending2 = new WeakMap();
  _anchor = new WeakMap();
  _hydrate_open = new WeakMap();
  _props = new WeakMap();
  _children = new WeakMap();
  _effect = new WeakMap();
  _main_effect = new WeakMap();
  _pending_effect = new WeakMap();
  _failed_effect = new WeakMap();
  _offscreen_fragment = new WeakMap();
  _pending_anchor = new WeakMap();
  _local_pending_count = new WeakMap();
  _pending_count = new WeakMap();
  _is_creating_fallback = new WeakMap();
  _effect_pending = new WeakMap();
  _effect_pending_subscriber = new WeakMap();
  _Boundary_instances = new WeakSet();
  hydrate_resolved_content_fn = function() {
    try {
      __privateSet(this, _main_effect, branch(() => __privateGet(this, _children).call(this, __privateGet(this, _anchor))));
    } catch (error) {
      this.error(error);
    }
    __privateSet(this, _pending2, false);
  };
  hydrate_pending_content_fn = function() {
    const pending = __privateGet(this, _props).pending;
    if (!pending) {
      return;
    }
    __privateSet(this, _pending_effect, branch(() => pending(__privateGet(this, _anchor))));
    Batch.enqueue(() => {
      var anchor = __privateMethod(this, _Boundary_instances, get_anchor_fn).call(this);
      __privateSet(this, _main_effect, __privateMethod(this, _Boundary_instances, run_fn).call(this, () => {
        Batch.ensure();
        return branch(() => __privateGet(this, _children).call(this, anchor));
      }));
      if (__privateGet(this, _pending_count) > 0) {
        __privateMethod(this, _Boundary_instances, show_pending_snippet_fn).call(this);
      } else {
        pause_effect(
          /** @type {Effect} */
          __privateGet(this, _pending_effect),
          () => {
            __privateSet(this, _pending_effect, null);
          }
        );
        __privateSet(this, _pending2, false);
      }
    });
  };
  get_anchor_fn = function() {
    var anchor = __privateGet(this, _anchor);
    if (__privateGet(this, _pending2)) {
      __privateSet(this, _pending_anchor, create_text());
      __privateGet(this, _anchor).before(__privateGet(this, _pending_anchor));
      anchor = __privateGet(this, _pending_anchor);
    }
    return anchor;
  };
  /**
   * @param {() => Effect | null} fn
   */
  run_fn = function(fn) {
    var previous_effect = active_effect;
    var previous_reaction = active_reaction;
    var previous_ctx = component_context;
    set_active_effect(__privateGet(this, _effect));
    set_active_reaction(__privateGet(this, _effect));
    set_component_context(__privateGet(this, _effect).ctx);
    try {
      return fn();
    } catch (e) {
      handle_error(e);
      return null;
    } finally {
      set_active_effect(previous_effect);
      set_active_reaction(previous_reaction);
      set_component_context(previous_ctx);
    }
  };
  show_pending_snippet_fn = function() {
    const pending = (
      /** @type {(anchor: Node) => void} */
      __privateGet(this, _props).pending
    );
    if (__privateGet(this, _main_effect) !== null) {
      __privateSet(this, _offscreen_fragment, document.createDocumentFragment());
      __privateGet(this, _offscreen_fragment).append(
        /** @type {TemplateNode} */
        __privateGet(this, _pending_anchor)
      );
      move_effect(__privateGet(this, _main_effect), __privateGet(this, _offscreen_fragment));
    }
    if (__privateGet(this, _pending_effect) === null) {
      __privateSet(this, _pending_effect, branch(() => pending(__privateGet(this, _anchor))));
    }
  };
  /**
   * Updates the pending count associated with the currently visible pending snippet,
   * if any, such that we can replace the snippet with content once work is done
   * @param {1 | -1} d
   */
  update_pending_count_fn = function(d) {
    var _a2;
    if (!this.has_pending_snippet()) {
      if (this.parent) {
        __privateMethod(_a2 = this.parent, _Boundary_instances, update_pending_count_fn).call(_a2, d);
      }
      return;
    }
    __privateSet(this, _pending_count, __privateGet(this, _pending_count) + d);
    if (__privateGet(this, _pending_count) === 0) {
      __privateSet(this, _pending2, false);
      if (__privateGet(this, _pending_effect)) {
        pause_effect(__privateGet(this, _pending_effect), () => {
          __privateSet(this, _pending_effect, null);
        });
      }
      if (__privateGet(this, _offscreen_fragment)) {
        __privateGet(this, _anchor).before(__privateGet(this, _offscreen_fragment));
        __privateSet(this, _offscreen_fragment, null);
      }
    }
  };
  function flatten(blockers, sync, async, fn) {
    const d = is_runes() ? derived$1 : derived_safe_equal;
    if (async.length === 0 && blockers.length === 0) {
      fn(sync.map(d));
      return;
    }
    var batch = current_batch;
    var parent = (
      /** @type {Effect} */
      active_effect
    );
    var restore = capture();
    function run2() {
      Promise.all(async.map((expression) => /* @__PURE__ */ async_derived(expression))).then((result) => {
        restore();
        try {
          fn([...sync.map(d), ...result]);
        } catch (error) {
          if ((parent.f & DESTROYED) === 0) {
            invoke_error_boundary(error, parent);
          }
        }
        batch == null ? void 0 : batch.deactivate();
        unset_context();
      }).catch((error) => {
        invoke_error_boundary(error, parent);
      });
    }
    if (blockers.length > 0) {
      Promise.all(blockers).then(() => {
        restore();
        try {
          return run2();
        } finally {
          batch == null ? void 0 : batch.deactivate();
          unset_context();
        }
      });
    } else {
      run2();
    }
  }
  function capture() {
    var previous_effect = active_effect;
    var previous_reaction = active_reaction;
    var previous_component_context = component_context;
    var previous_batch2 = current_batch;
    return function restore(activate_batch = true) {
      set_active_effect(previous_effect);
      set_active_reaction(previous_reaction);
      set_component_context(previous_component_context);
      if (activate_batch) previous_batch2 == null ? void 0 : previous_batch2.activate();
    };
  }
  function unset_context() {
    set_active_effect(null);
    set_active_reaction(null);
    set_component_context(null);
  }
  // @__NO_SIDE_EFFECTS__
  function derived$1(fn) {
    var flags2 = DERIVED | DIRTY;
    var parent_derived = active_reaction !== null && (active_reaction.f & DERIVED) !== 0 ? (
      /** @type {Derived} */
      active_reaction
    ) : null;
    if (active_effect !== null) {
      active_effect.f |= EFFECT_PRESERVED;
    }
    const signal = {
      ctx: component_context,
      deps: null,
      effects: null,
      equals,
      f: flags2,
      fn,
      reactions: null,
      rv: 0,
      v: (
        /** @type {V} */
        UNINITIALIZED
      ),
      wv: 0,
      parent: parent_derived ?? active_effect,
      ac: null
    };
    return signal;
  }
  // @__NO_SIDE_EFFECTS__
  function async_derived(fn, location) {
    let parent = (
      /** @type {Effect | null} */
      active_effect
    );
    if (parent === null) {
      async_derived_orphan();
    }
    var boundary2 = (
      /** @type {Boundary} */
      parent.b
    );
    var promise = (
      /** @type {Promise<V>} */
      /** @type {unknown} */
      void 0
    );
    var signal = source(
      /** @type {V} */
      UNINITIALIZED
    );
    var should_suspend = !active_reaction;
    var deferreds = /* @__PURE__ */ new Map();
    async_effect(() => {
      var _a2;
      var d = deferred();
      promise = d.promise;
      try {
        Promise.resolve(fn()).then(d.resolve, d.reject).then(() => {
          if (batch === current_batch && batch.committed) {
            batch.deactivate();
          }
          unset_context();
        });
      } catch (error) {
        d.reject(error);
        unset_context();
      }
      var batch = (
        /** @type {Batch} */
        current_batch
      );
      if (should_suspend) {
        var blocking = !boundary2.is_pending();
        boundary2.update_pending_count(1);
        batch.increment(blocking);
        (_a2 = deferreds.get(batch)) == null ? void 0 : _a2.reject(STALE_REACTION);
        deferreds.delete(batch);
        deferreds.set(batch, d);
      }
      const handler = (value, error = void 0) => {
        batch.activate();
        if (error) {
          if (error !== STALE_REACTION) {
            signal.f |= ERROR_VALUE;
            internal_set(signal, error);
          }
        } else {
          if ((signal.f & ERROR_VALUE) !== 0) {
            signal.f ^= ERROR_VALUE;
          }
          internal_set(signal, value);
          for (const [b, d2] of deferreds) {
            deferreds.delete(b);
            if (b === batch) break;
            d2.reject(STALE_REACTION);
          }
        }
        if (should_suspend) {
          boundary2.update_pending_count(-1);
          batch.decrement(blocking);
        }
      };
      d.promise.then(handler, (e) => handler(null, e || "unknown"));
    });
    teardown(() => {
      for (const d of deferreds.values()) {
        d.reject(STALE_REACTION);
      }
    });
    return new Promise((fulfil) => {
      function next(p) {
        function go() {
          if (p === promise) {
            fulfil(signal);
          } else {
            next(promise);
          }
        }
        p.then(go, go);
      }
      next(promise);
    });
  }
  // @__NO_SIDE_EFFECTS__
  function derived_safe_equal(fn) {
    const signal = /* @__PURE__ */ derived$1(fn);
    signal.equals = safe_equals;
    return signal;
  }
  function destroy_derived_effects(derived2) {
    var effects = derived2.effects;
    if (effects !== null) {
      derived2.effects = null;
      for (var i = 0; i < effects.length; i += 1) {
        destroy_effect(
          /** @type {Effect} */
          effects[i]
        );
      }
    }
  }
  function get_derived_parent_effect(derived2) {
    var parent = derived2.parent;
    while (parent !== null) {
      if ((parent.f & DERIVED) === 0) {
        return (
          /** @type {Effect} */
          parent
        );
      }
      parent = parent.parent;
    }
    return null;
  }
  function execute_derived(derived2) {
    var value;
    var prev_active_effect = active_effect;
    set_active_effect(get_derived_parent_effect(derived2));
    {
      try {
        derived2.f &= ~WAS_MARKED;
        destroy_derived_effects(derived2);
        value = update_reaction(derived2);
      } finally {
        set_active_effect(prev_active_effect);
      }
    }
    return value;
  }
  function update_derived(derived2) {
    var value = execute_derived(derived2);
    if (!derived2.equals(value)) {
      derived2.v = value;
      derived2.wv = increment_write_version();
    }
    if (is_destroying_effect) {
      return;
    }
    if (batch_values !== null) {
      if (effect_tracking()) {
        batch_values.set(derived2, derived2.v);
      }
    } else {
      var status = (derived2.f & CONNECTED) === 0 ? MAYBE_DIRTY : CLEAN;
      set_signal_status(derived2, status);
    }
  }
  let eager_effects = /* @__PURE__ */ new Set();
  const old_values = /* @__PURE__ */ new Map();
  let eager_effects_deferred = false;
  function source(v, stack) {
    var signal = {
      f: 0,
      // TODO ideally we could skip this altogether, but it causes type errors
      v,
      reactions: null,
      equals,
      rv: 0,
      wv: 0
    };
    return signal;
  }
  // @__NO_SIDE_EFFECTS__
  function state(v, stack) {
    const s = source(v);
    push_reaction_value(s);
    return s;
  }
  // @__NO_SIDE_EFFECTS__
  function mutable_source(initial_value, immutable = false, trackable = true) {
    var _a2;
    const s = source(initial_value);
    if (!immutable) {
      s.equals = safe_equals;
    }
    if (legacy_mode_flag && trackable && component_context !== null && component_context.l !== null) {
      ((_a2 = component_context.l).s ?? (_a2.s = [])).push(s);
    }
    return s;
  }
  function mutate(source2, value) {
    set(
      source2,
      untrack(() => get$1(source2))
    );
    return value;
  }
  function set(source2, value, should_proxy = false) {
    if (active_reaction !== null && // since we are untracking the function inside `$inspect.with` we need to add this check
    // to ensure we error if state is set inside an inspect effect
    (!untracking || (active_reaction.f & EAGER_EFFECT) !== 0) && is_runes() && (active_reaction.f & (DERIVED | BLOCK_EFFECT | ASYNC | EAGER_EFFECT)) !== 0 && !(current_sources == null ? void 0 : current_sources.includes(source2))) {
      state_unsafe_mutation();
    }
    let new_value = should_proxy ? proxy(value) : value;
    return internal_set(source2, new_value);
  }
  function internal_set(source2, value) {
    if (!source2.equals(value)) {
      var old_value = source2.v;
      if (is_destroying_effect) {
        old_values.set(source2, value);
      } else {
        old_values.set(source2, old_value);
      }
      source2.v = value;
      var batch = Batch.ensure();
      batch.capture(source2, old_value);
      if ((source2.f & DERIVED) !== 0) {
        if ((source2.f & DIRTY) !== 0) {
          execute_derived(
            /** @type {Derived} */
            source2
          );
        }
        set_signal_status(source2, (source2.f & CONNECTED) !== 0 ? CLEAN : MAYBE_DIRTY);
      }
      source2.wv = increment_write_version();
      mark_reactions(source2, DIRTY);
      if (is_runes() && active_effect !== null && (active_effect.f & CLEAN) !== 0 && (active_effect.f & (BRANCH_EFFECT | ROOT_EFFECT)) === 0) {
        if (untracked_writes === null) {
          set_untracked_writes([source2]);
        } else {
          untracked_writes.push(source2);
        }
      }
      if (!batch.is_fork && eager_effects.size > 0 && !eager_effects_deferred) {
        flush_eager_effects();
      }
    }
    return value;
  }
  function flush_eager_effects() {
    eager_effects_deferred = false;
    const inspects = Array.from(eager_effects);
    for (const effect2 of inspects) {
      if ((effect2.f & CLEAN) !== 0) {
        set_signal_status(effect2, MAYBE_DIRTY);
      }
      if (is_dirty(effect2)) {
        update_effect(effect2);
      }
    }
    eager_effects.clear();
  }
  function increment(source2) {
    set(source2, source2.v + 1);
  }
  function mark_reactions(signal, status) {
    var reactions = signal.reactions;
    if (reactions === null) return;
    var runes = is_runes();
    var length = reactions.length;
    for (var i = 0; i < length; i++) {
      var reaction = reactions[i];
      var flags2 = reaction.f;
      if (!runes && reaction === active_effect) continue;
      var not_dirty = (flags2 & DIRTY) === 0;
      if (not_dirty) {
        set_signal_status(reaction, status);
      }
      if ((flags2 & DERIVED) !== 0) {
        var derived2 = (
          /** @type {Derived} */
          reaction
        );
        batch_values == null ? void 0 : batch_values.delete(derived2);
        if ((flags2 & WAS_MARKED) === 0) {
          if (flags2 & CONNECTED) {
            reaction.f |= WAS_MARKED;
          }
          mark_reactions(derived2, MAYBE_DIRTY);
        }
      } else if (not_dirty) {
        if ((flags2 & BLOCK_EFFECT) !== 0) {
          if (eager_block_effects !== null) {
            eager_block_effects.add(
              /** @type {Effect} */
              reaction
            );
          }
        }
        schedule_effect(
          /** @type {Effect} */
          reaction
        );
      }
    }
  }
  function proxy(value) {
    if (typeof value !== "object" || value === null || STATE_SYMBOL in value) {
      return value;
    }
    const prototype = get_prototype_of(value);
    if (prototype !== object_prototype && prototype !== array_prototype) {
      return value;
    }
    var sources = /* @__PURE__ */ new Map();
    var is_proxied_array = is_array(value);
    var version = /* @__PURE__ */ state(0);
    var parent_version = update_version;
    var with_parent = (fn) => {
      if (update_version === parent_version) {
        return fn();
      }
      var reaction = active_reaction;
      var version2 = update_version;
      set_active_reaction(null);
      set_update_version(parent_version);
      var result = fn();
      set_active_reaction(reaction);
      set_update_version(version2);
      return result;
    };
    if (is_proxied_array) {
      sources.set("length", /* @__PURE__ */ state(
        /** @type {any[]} */
        value.length
      ));
    }
    return new Proxy(
      /** @type {any} */
      value,
      {
        defineProperty(_, prop2, descriptor) {
          if (!("value" in descriptor) || descriptor.configurable === false || descriptor.enumerable === false || descriptor.writable === false) {
            state_descriptors_fixed();
          }
          var s = sources.get(prop2);
          if (s === void 0) {
            s = with_parent(() => {
              var s2 = /* @__PURE__ */ state(descriptor.value);
              sources.set(prop2, s2);
              return s2;
            });
          } else {
            set(s, descriptor.value, true);
          }
          return true;
        },
        deleteProperty(target, prop2) {
          var s = sources.get(prop2);
          if (s === void 0) {
            if (prop2 in target) {
              const s2 = with_parent(() => /* @__PURE__ */ state(UNINITIALIZED));
              sources.set(prop2, s2);
              increment(version);
            }
          } else {
            set(s, UNINITIALIZED);
            increment(version);
          }
          return true;
        },
        get(target, prop2, receiver) {
          var _a2;
          if (prop2 === STATE_SYMBOL) {
            return value;
          }
          var s = sources.get(prop2);
          var exists = prop2 in target;
          if (s === void 0 && (!exists || ((_a2 = get_descriptor(target, prop2)) == null ? void 0 : _a2.writable))) {
            s = with_parent(() => {
              var p = proxy(exists ? target[prop2] : UNINITIALIZED);
              var s2 = /* @__PURE__ */ state(p);
              return s2;
            });
            sources.set(prop2, s);
          }
          if (s !== void 0) {
            var v = get$1(s);
            return v === UNINITIALIZED ? void 0 : v;
          }
          return Reflect.get(target, prop2, receiver);
        },
        getOwnPropertyDescriptor(target, prop2) {
          var descriptor = Reflect.getOwnPropertyDescriptor(target, prop2);
          if (descriptor && "value" in descriptor) {
            var s = sources.get(prop2);
            if (s) descriptor.value = get$1(s);
          } else if (descriptor === void 0) {
            var source2 = sources.get(prop2);
            var value2 = source2 == null ? void 0 : source2.v;
            if (source2 !== void 0 && value2 !== UNINITIALIZED) {
              return {
                enumerable: true,
                configurable: true,
                value: value2,
                writable: true
              };
            }
          }
          return descriptor;
        },
        has(target, prop2) {
          var _a2;
          if (prop2 === STATE_SYMBOL) {
            return true;
          }
          var s = sources.get(prop2);
          var has = s !== void 0 && s.v !== UNINITIALIZED || Reflect.has(target, prop2);
          if (s !== void 0 || active_effect !== null && (!has || ((_a2 = get_descriptor(target, prop2)) == null ? void 0 : _a2.writable))) {
            if (s === void 0) {
              s = with_parent(() => {
                var p = has ? proxy(target[prop2]) : UNINITIALIZED;
                var s2 = /* @__PURE__ */ state(p);
                return s2;
              });
              sources.set(prop2, s);
            }
            var value2 = get$1(s);
            if (value2 === UNINITIALIZED) {
              return false;
            }
          }
          return has;
        },
        set(target, prop2, value2, receiver) {
          var _a2;
          var s = sources.get(prop2);
          var has = prop2 in target;
          if (is_proxied_array && prop2 === "length") {
            for (var i = value2; i < /** @type {Source<number>} */
            s.v; i += 1) {
              var other_s = sources.get(i + "");
              if (other_s !== void 0) {
                set(other_s, UNINITIALIZED);
              } else if (i in target) {
                other_s = with_parent(() => /* @__PURE__ */ state(UNINITIALIZED));
                sources.set(i + "", other_s);
              }
            }
          }
          if (s === void 0) {
            if (!has || ((_a2 = get_descriptor(target, prop2)) == null ? void 0 : _a2.writable)) {
              s = with_parent(() => /* @__PURE__ */ state(void 0));
              set(s, proxy(value2));
              sources.set(prop2, s);
            }
          } else {
            has = s.v !== UNINITIALIZED;
            var p = with_parent(() => proxy(value2));
            set(s, p);
          }
          var descriptor = Reflect.getOwnPropertyDescriptor(target, prop2);
          if (descriptor == null ? void 0 : descriptor.set) {
            descriptor.set.call(receiver, value2);
          }
          if (!has) {
            if (is_proxied_array && typeof prop2 === "string") {
              var ls = (
                /** @type {Source<number>} */
                sources.get("length")
              );
              var n = Number(prop2);
              if (Number.isInteger(n) && n >= ls.v) {
                set(ls, n + 1);
              }
            }
            increment(version);
          }
          return true;
        },
        ownKeys(target) {
          get$1(version);
          var own_keys = Reflect.ownKeys(target).filter((key3) => {
            var source3 = sources.get(key3);
            return source3 === void 0 || source3.v !== UNINITIALIZED;
          });
          for (var [key2, source2] of sources) {
            if (source2.v !== UNINITIALIZED && !(key2 in target)) {
              own_keys.push(key2);
            }
          }
          return own_keys;
        },
        setPrototypeOf() {
          state_prototype_fixed();
        }
      }
    );
  }
  function get_proxied_value(value) {
    try {
      if (value !== null && typeof value === "object" && STATE_SYMBOL in value) {
        return value[STATE_SYMBOL];
      }
    } catch {
    }
    return value;
  }
  function is(a, b) {
    return Object.is(get_proxied_value(a), get_proxied_value(b));
  }
  var $window;
  var is_firefox;
  var first_child_getter;
  var next_sibling_getter;
  function init_operations() {
    if ($window !== void 0) {
      return;
    }
    $window = window;
    is_firefox = /Firefox/.test(navigator.userAgent);
    var element_prototype = Element.prototype;
    var node_prototype = Node.prototype;
    var text_prototype = Text.prototype;
    first_child_getter = get_descriptor(node_prototype, "firstChild").get;
    next_sibling_getter = get_descriptor(node_prototype, "nextSibling").get;
    if (is_extensible(element_prototype)) {
      element_prototype.__click = void 0;
      element_prototype.__className = void 0;
      element_prototype.__attributes = null;
      element_prototype.__style = void 0;
      element_prototype.__e = void 0;
    }
    if (is_extensible(text_prototype)) {
      text_prototype.__t = void 0;
    }
  }
  function create_text(value = "") {
    return document.createTextNode(value);
  }
  // @__NO_SIDE_EFFECTS__
  function get_first_child(node) {
    return first_child_getter.call(node);
  }
  // @__NO_SIDE_EFFECTS__
  function get_next_sibling(node) {
    return next_sibling_getter.call(node);
  }
  function child(node, is_text) {
    {
      return /* @__PURE__ */ get_first_child(node);
    }
  }
  function first_child(fragment, is_text = false) {
    {
      var first = (
        /** @type {DocumentFragment} */
        /* @__PURE__ */ get_first_child(
          /** @type {Node} */
          fragment
        )
      );
      if (first instanceof Comment && first.data === "") return /* @__PURE__ */ get_next_sibling(first);
      return first;
    }
  }
  function sibling(node, count = 1, is_text = false) {
    let next_sibling = node;
    while (count--) {
      next_sibling = /** @type {TemplateNode} */
      /* @__PURE__ */ get_next_sibling(next_sibling);
    }
    {
      return next_sibling;
    }
  }
  function clear_text_content(node) {
    node.textContent = "";
  }
  function should_defer_append() {
    return false;
  }
  let listening_to_form_reset = false;
  function add_form_reset_listener() {
    if (!listening_to_form_reset) {
      listening_to_form_reset = true;
      document.addEventListener(
        "reset",
        (evt) => {
          Promise.resolve().then(() => {
            var _a2;
            if (!evt.defaultPrevented) {
              for (
                const e of
                /**@type {HTMLFormElement} */
                evt.target.elements
              ) {
                (_a2 = e.__on_r) == null ? void 0 : _a2.call(e);
              }
            }
          });
        },
        // In the capture phase to guarantee we get noticed of it (no possiblity of stopPropagation)
        { capture: true }
      );
    }
  }
  function without_reactive_context(fn) {
    var previous_reaction = active_reaction;
    var previous_effect = active_effect;
    set_active_reaction(null);
    set_active_effect(null);
    try {
      return fn();
    } finally {
      set_active_reaction(previous_reaction);
      set_active_effect(previous_effect);
    }
  }
  function listen_to_event_and_reset_event(element, event2, handler, on_reset = handler) {
    element.addEventListener(event2, () => without_reactive_context(handler));
    const prev = element.__on_r;
    if (prev) {
      element.__on_r = () => {
        prev();
        on_reset(true);
      };
    } else {
      element.__on_r = () => on_reset(true);
    }
    add_form_reset_listener();
  }
  function validate_effect(rune) {
    if (active_effect === null) {
      if (active_reaction === null) {
        effect_orphan();
      }
      effect_in_unowned_derived();
    }
    if (is_destroying_effect) {
      effect_in_teardown();
    }
  }
  function push_effect(effect2, parent_effect) {
    var parent_last = parent_effect.last;
    if (parent_last === null) {
      parent_effect.last = parent_effect.first = effect2;
    } else {
      parent_last.next = effect2;
      effect2.prev = parent_last;
      parent_effect.last = effect2;
    }
  }
  function create_effect(type, fn, sync, push2 = true) {
    var parent = active_effect;
    if (parent !== null && (parent.f & INERT) !== 0) {
      type |= INERT;
    }
    var effect2 = {
      ctx: component_context,
      deps: null,
      nodes_start: null,
      nodes_end: null,
      f: type | DIRTY | CONNECTED,
      first: null,
      fn,
      last: null,
      next: null,
      parent,
      b: parent && parent.b,
      prev: null,
      teardown: null,
      transitions: null,
      wv: 0,
      ac: null
    };
    if (sync) {
      try {
        update_effect(effect2);
        effect2.f |= EFFECT_RAN;
      } catch (e2) {
        destroy_effect(effect2);
        throw e2;
      }
    } else if (fn !== null) {
      schedule_effect(effect2);
    }
    if (push2) {
      var e = effect2;
      if (sync && e.deps === null && e.teardown === null && e.nodes_start === null && e.first === e.last && // either `null`, or a singular child
      (e.f & EFFECT_PRESERVED) === 0) {
        e = e.first;
        if ((type & BLOCK_EFFECT) !== 0 && (type & EFFECT_TRANSPARENT) !== 0 && e !== null) {
          e.f |= EFFECT_TRANSPARENT;
        }
      }
      if (e !== null) {
        e.parent = parent;
        if (parent !== null) {
          push_effect(e, parent);
        }
        if (active_reaction !== null && (active_reaction.f & DERIVED) !== 0 && (type & ROOT_EFFECT) === 0) {
          var derived2 = (
            /** @type {Derived} */
            active_reaction
          );
          (derived2.effects ?? (derived2.effects = [])).push(e);
        }
      }
    }
    return effect2;
  }
  function effect_tracking() {
    return active_reaction !== null && !untracking;
  }
  function teardown(fn) {
    const effect2 = create_effect(RENDER_EFFECT, null, false);
    set_signal_status(effect2, CLEAN);
    effect2.teardown = fn;
    return effect2;
  }
  function user_effect(fn) {
    validate_effect();
    var flags2 = (
      /** @type {Effect} */
      active_effect.f
    );
    var defer = !active_reaction && (flags2 & BRANCH_EFFECT) !== 0 && (flags2 & EFFECT_RAN) === 0;
    if (defer) {
      var context = (
        /** @type {ComponentContext} */
        component_context
      );
      (context.e ?? (context.e = [])).push(fn);
    } else {
      return create_user_effect(fn);
    }
  }
  function create_user_effect(fn) {
    return create_effect(EFFECT | USER_EFFECT, fn, false);
  }
  function user_pre_effect(fn) {
    validate_effect();
    return create_effect(RENDER_EFFECT | USER_EFFECT, fn, true);
  }
  function component_root(fn) {
    Batch.ensure();
    const effect2 = create_effect(ROOT_EFFECT | EFFECT_PRESERVED, fn, true);
    return (options = {}) => {
      return new Promise((fulfil) => {
        if (options.outro) {
          pause_effect(effect2, () => {
            destroy_effect(effect2);
            fulfil(void 0);
          });
        } else {
          destroy_effect(effect2);
          fulfil(void 0);
        }
      });
    };
  }
  function effect(fn) {
    return create_effect(EFFECT, fn, false);
  }
  function legacy_pre_effect(deps, fn) {
    var context = (
      /** @type {ComponentContextLegacy} */
      component_context
    );
    var token = { effect: null, ran: false, deps };
    context.l.$.push(token);
    token.effect = render_effect(() => {
      deps();
      if (token.ran) return;
      token.ran = true;
      untrack(fn);
    });
  }
  function legacy_pre_effect_reset() {
    var context = (
      /** @type {ComponentContextLegacy} */
      component_context
    );
    render_effect(() => {
      for (var token of context.l.$) {
        token.deps();
        var effect2 = token.effect;
        if ((effect2.f & CLEAN) !== 0) {
          set_signal_status(effect2, MAYBE_DIRTY);
        }
        if (is_dirty(effect2)) {
          update_effect(effect2);
        }
        token.ran = false;
      }
    });
  }
  function async_effect(fn) {
    return create_effect(ASYNC | EFFECT_PRESERVED, fn, true);
  }
  function render_effect(fn, flags2 = 0) {
    return create_effect(RENDER_EFFECT | flags2, fn, true);
  }
  function template_effect(fn, sync = [], async = [], blockers = [], defer = false) {
    flatten(blockers, sync, async, (values) => {
      create_effect(defer ? EFFECT : RENDER_EFFECT, () => fn(...values.map(get$1)), true);
    });
  }
  function block(fn, flags2 = 0) {
    var effect2 = create_effect(BLOCK_EFFECT | flags2, fn, true);
    return effect2;
  }
  function branch(fn, push2 = true) {
    return create_effect(BRANCH_EFFECT | EFFECT_PRESERVED, fn, true, push2);
  }
  function execute_effect_teardown(effect2) {
    var teardown2 = effect2.teardown;
    if (teardown2 !== null) {
      const previously_destroying_effect = is_destroying_effect;
      const previous_reaction = active_reaction;
      set_is_destroying_effect(true);
      set_active_reaction(null);
      try {
        teardown2.call(null);
      } finally {
        set_is_destroying_effect(previously_destroying_effect);
        set_active_reaction(previous_reaction);
      }
    }
  }
  function destroy_effect_children(signal, remove_dom = false) {
    var effect2 = signal.first;
    signal.first = signal.last = null;
    while (effect2 !== null) {
      const controller = effect2.ac;
      if (controller !== null) {
        without_reactive_context(() => {
          controller.abort(STALE_REACTION);
        });
      }
      var next = effect2.next;
      if ((effect2.f & ROOT_EFFECT) !== 0) {
        effect2.parent = null;
      } else {
        destroy_effect(effect2, remove_dom);
      }
      effect2 = next;
    }
  }
  function destroy_block_effect_children(signal) {
    var effect2 = signal.first;
    while (effect2 !== null) {
      var next = effect2.next;
      if ((effect2.f & BRANCH_EFFECT) === 0) {
        destroy_effect(effect2);
      }
      effect2 = next;
    }
  }
  function destroy_effect(effect2, remove_dom = true) {
    var removed = false;
    if ((remove_dom || (effect2.f & HEAD_EFFECT) !== 0) && effect2.nodes_start !== null && effect2.nodes_end !== null) {
      remove_effect_dom(
        effect2.nodes_start,
        /** @type {TemplateNode} */
        effect2.nodes_end
      );
      removed = true;
    }
    destroy_effect_children(effect2, remove_dom && !removed);
    remove_reactions(effect2, 0);
    set_signal_status(effect2, DESTROYED);
    var transitions = effect2.transitions;
    if (transitions !== null) {
      for (const transition of transitions) {
        transition.stop();
      }
    }
    execute_effect_teardown(effect2);
    var parent = effect2.parent;
    if (parent !== null && parent.first !== null) {
      unlink_effect(effect2);
    }
    effect2.next = effect2.prev = effect2.teardown = effect2.ctx = effect2.deps = effect2.fn = effect2.nodes_start = effect2.nodes_end = effect2.ac = null;
  }
  function remove_effect_dom(node, end) {
    while (node !== null) {
      var next = node === end ? null : (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_next_sibling(node)
      );
      node.remove();
      node = next;
    }
  }
  function unlink_effect(effect2) {
    var parent = effect2.parent;
    var prev = effect2.prev;
    var next = effect2.next;
    if (prev !== null) prev.next = next;
    if (next !== null) next.prev = prev;
    if (parent !== null) {
      if (parent.first === effect2) parent.first = next;
      if (parent.last === effect2) parent.last = prev;
    }
  }
  function pause_effect(effect2, callback, destroy = true) {
    var transitions = [];
    pause_children(effect2, transitions, true);
    run_out_transitions(transitions, () => {
      if (destroy) destroy_effect(effect2);
      if (callback) callback();
    });
  }
  function run_out_transitions(transitions, fn) {
    var remaining = transitions.length;
    if (remaining > 0) {
      var check = () => --remaining || fn();
      for (var transition of transitions) {
        transition.out(check);
      }
    } else {
      fn();
    }
  }
  function pause_children(effect2, transitions, local) {
    if ((effect2.f & INERT) !== 0) return;
    effect2.f ^= INERT;
    if (effect2.transitions !== null) {
      for (const transition of effect2.transitions) {
        if (transition.is_global || local) {
          transitions.push(transition);
        }
      }
    }
    var child2 = effect2.first;
    while (child2 !== null) {
      var sibling2 = child2.next;
      var transparent = (child2.f & EFFECT_TRANSPARENT) !== 0 || // If this is a branch effect without a block effect parent,
      // it means the parent block effect was pruned. In that case,
      // transparency information was transferred to the branch effect.
      (child2.f & BRANCH_EFFECT) !== 0 && (effect2.f & BLOCK_EFFECT) !== 0;
      pause_children(child2, transitions, transparent ? local : false);
      child2 = sibling2;
    }
  }
  function resume_effect(effect2) {
    resume_children(effect2, true);
  }
  function resume_children(effect2, local) {
    if ((effect2.f & INERT) === 0) return;
    effect2.f ^= INERT;
    if ((effect2.f & CLEAN) === 0) {
      set_signal_status(effect2, DIRTY);
      schedule_effect(effect2);
    }
    var child2 = effect2.first;
    while (child2 !== null) {
      var sibling2 = child2.next;
      var transparent = (child2.f & EFFECT_TRANSPARENT) !== 0 || (child2.f & BRANCH_EFFECT) !== 0;
      resume_children(child2, transparent ? local : false);
      child2 = sibling2;
    }
    if (effect2.transitions !== null) {
      for (const transition of effect2.transitions) {
        if (transition.is_global || local) {
          transition.in();
        }
      }
    }
  }
  function move_effect(effect2, fragment) {
    var node = effect2.nodes_start;
    var end = effect2.nodes_end;
    while (node !== null) {
      var next = node === end ? null : (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_next_sibling(node)
      );
      fragment.append(node);
      node = next;
    }
  }
  let captured_signals = null;
  function capture_signals(fn) {
    var previous_captured_signals = captured_signals;
    try {
      captured_signals = /* @__PURE__ */ new Set();
      untrack(fn);
      if (previous_captured_signals !== null) {
        for (var signal of captured_signals) {
          previous_captured_signals.add(signal);
        }
      }
      return captured_signals;
    } finally {
      captured_signals = previous_captured_signals;
    }
  }
  function invalidate_inner_signals(fn) {
    for (var signal of capture_signals(fn)) {
      internal_set(signal, signal.v);
    }
  }
  let is_updating_effect = false;
  function set_is_updating_effect(value) {
    is_updating_effect = value;
  }
  let is_destroying_effect = false;
  function set_is_destroying_effect(value) {
    is_destroying_effect = value;
  }
  let active_reaction = null;
  let untracking = false;
  function set_active_reaction(reaction) {
    active_reaction = reaction;
  }
  let active_effect = null;
  function set_active_effect(effect2) {
    active_effect = effect2;
  }
  let current_sources = null;
  function push_reaction_value(value) {
    if (active_reaction !== null && true) {
      if (current_sources === null) {
        current_sources = [value];
      } else {
        current_sources.push(value);
      }
    }
  }
  let new_deps = null;
  let skipped_deps = 0;
  let untracked_writes = null;
  function set_untracked_writes(value) {
    untracked_writes = value;
  }
  let write_version = 1;
  let read_version = 0;
  let update_version = read_version;
  function set_update_version(value) {
    update_version = value;
  }
  function increment_write_version() {
    return ++write_version;
  }
  function is_dirty(reaction) {
    var flags2 = reaction.f;
    if ((flags2 & DIRTY) !== 0) {
      return true;
    }
    if (flags2 & DERIVED) {
      reaction.f &= ~WAS_MARKED;
    }
    if ((flags2 & MAYBE_DIRTY) !== 0) {
      var dependencies = reaction.deps;
      if (dependencies !== null) {
        var length = dependencies.length;
        for (var i = 0; i < length; i++) {
          var dependency = dependencies[i];
          if (is_dirty(
            /** @type {Derived} */
            dependency
          )) {
            update_derived(
              /** @type {Derived} */
              dependency
            );
          }
          if (dependency.wv > reaction.wv) {
            return true;
          }
        }
      }
      if ((flags2 & CONNECTED) !== 0 && // During time traveling we don't want to reset the status so that
      // traversal of the graph in the other batches still happens
      batch_values === null) {
        set_signal_status(reaction, CLEAN);
      }
    }
    return false;
  }
  function schedule_possible_effect_self_invalidation(signal, effect2, root2 = true) {
    var reactions = signal.reactions;
    if (reactions === null) return;
    if (current_sources == null ? void 0 : current_sources.includes(signal)) {
      return;
    }
    for (var i = 0; i < reactions.length; i++) {
      var reaction = reactions[i];
      if ((reaction.f & DERIVED) !== 0) {
        schedule_possible_effect_self_invalidation(
          /** @type {Derived} */
          reaction,
          effect2,
          false
        );
      } else if (effect2 === reaction) {
        if (root2) {
          set_signal_status(reaction, DIRTY);
        } else if ((reaction.f & CLEAN) !== 0) {
          set_signal_status(reaction, MAYBE_DIRTY);
        }
        schedule_effect(
          /** @type {Effect} */
          reaction
        );
      }
    }
  }
  function update_reaction(reaction) {
    var _a2;
    var previous_deps = new_deps;
    var previous_skipped_deps = skipped_deps;
    var previous_untracked_writes = untracked_writes;
    var previous_reaction = active_reaction;
    var previous_sources = current_sources;
    var previous_component_context = component_context;
    var previous_untracking = untracking;
    var previous_update_version = update_version;
    var flags2 = reaction.f;
    new_deps = /** @type {null | Value[]} */
    null;
    skipped_deps = 0;
    untracked_writes = null;
    active_reaction = (flags2 & (BRANCH_EFFECT | ROOT_EFFECT)) === 0 ? reaction : null;
    current_sources = null;
    set_component_context(reaction.ctx);
    untracking = false;
    update_version = ++read_version;
    if (reaction.ac !== null) {
      without_reactive_context(() => {
        reaction.ac.abort(STALE_REACTION);
      });
      reaction.ac = null;
    }
    try {
      reaction.f |= REACTION_IS_UPDATING;
      var fn = (
        /** @type {Function} */
        reaction.fn
      );
      var result = fn();
      var deps = reaction.deps;
      if (new_deps !== null) {
        var i;
        remove_reactions(reaction, skipped_deps);
        if (deps !== null && skipped_deps > 0) {
          deps.length = skipped_deps + new_deps.length;
          for (i = 0; i < new_deps.length; i++) {
            deps[skipped_deps + i] = new_deps[i];
          }
        } else {
          reaction.deps = deps = new_deps;
        }
        if (is_updating_effect && effect_tracking() && (reaction.f & CONNECTED) !== 0) {
          for (i = skipped_deps; i < deps.length; i++) {
            ((_a2 = deps[i]).reactions ?? (_a2.reactions = [])).push(reaction);
          }
        }
      } else if (deps !== null && skipped_deps < deps.length) {
        remove_reactions(reaction, skipped_deps);
        deps.length = skipped_deps;
      }
      if (is_runes() && untracked_writes !== null && !untracking && deps !== null && (reaction.f & (DERIVED | MAYBE_DIRTY | DIRTY)) === 0) {
        for (i = 0; i < /** @type {Source[]} */
        untracked_writes.length; i++) {
          schedule_possible_effect_self_invalidation(
            untracked_writes[i],
            /** @type {Effect} */
            reaction
          );
        }
      }
      if (previous_reaction !== null && previous_reaction !== reaction) {
        read_version++;
        if (untracked_writes !== null) {
          if (previous_untracked_writes === null) {
            previous_untracked_writes = untracked_writes;
          } else {
            previous_untracked_writes.push(.../** @type {Source[]} */
            untracked_writes);
          }
        }
      }
      if ((reaction.f & ERROR_VALUE) !== 0) {
        reaction.f ^= ERROR_VALUE;
      }
      return result;
    } catch (error) {
      return handle_error(error);
    } finally {
      reaction.f ^= REACTION_IS_UPDATING;
      new_deps = previous_deps;
      skipped_deps = previous_skipped_deps;
      untracked_writes = previous_untracked_writes;
      active_reaction = previous_reaction;
      current_sources = previous_sources;
      set_component_context(previous_component_context);
      untracking = previous_untracking;
      update_version = previous_update_version;
    }
  }
  function remove_reaction(signal, dependency) {
    let reactions = dependency.reactions;
    if (reactions !== null) {
      var index2 = index_of.call(reactions, signal);
      if (index2 !== -1) {
        var new_length = reactions.length - 1;
        if (new_length === 0) {
          reactions = dependency.reactions = null;
        } else {
          reactions[index2] = reactions[new_length];
          reactions.pop();
        }
      }
    }
    if (reactions === null && (dependency.f & DERIVED) !== 0 && // Destroying a child effect while updating a parent effect can cause a dependency to appear
    // to be unused, when in fact it is used by the currently-updating parent. Checking `new_deps`
    // allows us to skip the expensive work of disconnecting and immediately reconnecting it
    (new_deps === null || !new_deps.includes(dependency))) {
      set_signal_status(dependency, MAYBE_DIRTY);
      if ((dependency.f & CONNECTED) !== 0) {
        dependency.f ^= CONNECTED;
        dependency.f &= ~WAS_MARKED;
      }
      destroy_derived_effects(
        /** @type {Derived} **/
        dependency
      );
      remove_reactions(
        /** @type {Derived} **/
        dependency,
        0
      );
    }
  }
  function remove_reactions(signal, start_index) {
    var dependencies = signal.deps;
    if (dependencies === null) return;
    for (var i = start_index; i < dependencies.length; i++) {
      remove_reaction(signal, dependencies[i]);
    }
  }
  function update_effect(effect2) {
    var flags2 = effect2.f;
    if ((flags2 & DESTROYED) !== 0) {
      return;
    }
    set_signal_status(effect2, CLEAN);
    var previous_effect = active_effect;
    var was_updating_effect = is_updating_effect;
    active_effect = effect2;
    is_updating_effect = true;
    try {
      if ((flags2 & BLOCK_EFFECT) !== 0) {
        destroy_block_effect_children(effect2);
      } else {
        destroy_effect_children(effect2);
      }
      execute_effect_teardown(effect2);
      var teardown2 = update_reaction(effect2);
      effect2.teardown = typeof teardown2 === "function" ? teardown2 : null;
      effect2.wv = write_version;
      var dep;
      if (DEV && tracing_mode_flag && (effect2.f & DIRTY) !== 0 && effect2.deps !== null) ;
    } finally {
      is_updating_effect = was_updating_effect;
      active_effect = previous_effect;
    }
  }
  async function tick() {
    await Promise.resolve();
    flushSync();
  }
  function get$1(signal) {
    var flags2 = signal.f;
    var is_derived = (flags2 & DERIVED) !== 0;
    captured_signals == null ? void 0 : captured_signals.add(signal);
    if (active_reaction !== null && !untracking) {
      var destroyed = active_effect !== null && (active_effect.f & DESTROYED) !== 0;
      if (!destroyed && !(current_sources == null ? void 0 : current_sources.includes(signal))) {
        var deps = active_reaction.deps;
        if ((active_reaction.f & REACTION_IS_UPDATING) !== 0) {
          if (signal.rv < read_version) {
            signal.rv = read_version;
            if (new_deps === null && deps !== null && deps[skipped_deps] === signal) {
              skipped_deps++;
            } else if (new_deps === null) {
              new_deps = [signal];
            } else if (!new_deps.includes(signal)) {
              new_deps.push(signal);
            }
          }
        } else {
          (active_reaction.deps ?? (active_reaction.deps = [])).push(signal);
          var reactions = signal.reactions;
          if (reactions === null) {
            signal.reactions = [active_reaction];
          } else if (!reactions.includes(active_reaction)) {
            reactions.push(active_reaction);
          }
        }
      }
    }
    if (is_destroying_effect) {
      if (old_values.has(signal)) {
        return old_values.get(signal);
      }
      if (is_derived) {
        var derived2 = (
          /** @type {Derived} */
          signal
        );
        var value = derived2.v;
        if ((derived2.f & CLEAN) === 0 && derived2.reactions !== null || depends_on_old_values(derived2)) {
          value = execute_derived(derived2);
        }
        old_values.set(derived2, value);
        return value;
      }
    } else if (is_derived) {
      derived2 = /** @type {Derived} */
      signal;
      if (batch_values == null ? void 0 : batch_values.has(derived2)) {
        return batch_values.get(derived2);
      }
      if (is_dirty(derived2)) {
        update_derived(derived2);
      }
      if (is_updating_effect && effect_tracking() && (derived2.f & CONNECTED) === 0) {
        reconnect(derived2);
      }
    } else if (batch_values == null ? void 0 : batch_values.has(signal)) {
      return batch_values.get(signal);
    }
    if ((signal.f & ERROR_VALUE) !== 0) {
      throw signal.v;
    }
    return signal.v;
  }
  function reconnect(derived2) {
    if (derived2.deps === null) return;
    derived2.f ^= CONNECTED;
    for (const dep of derived2.deps) {
      (dep.reactions ?? (dep.reactions = [])).push(derived2);
      if ((dep.f & DERIVED) !== 0 && (dep.f & CONNECTED) === 0) {
        reconnect(
          /** @type {Derived} */
          dep
        );
      }
    }
  }
  function depends_on_old_values(derived2) {
    if (derived2.v === UNINITIALIZED) return true;
    if (derived2.deps === null) return false;
    for (const dep of derived2.deps) {
      if (old_values.has(dep)) {
        return true;
      }
      if ((dep.f & DERIVED) !== 0 && depends_on_old_values(
        /** @type {Derived} */
        dep
      )) {
        return true;
      }
    }
    return false;
  }
  function untrack(fn) {
    var previous_untracking = untracking;
    try {
      untracking = true;
      return fn();
    } finally {
      untracking = previous_untracking;
    }
  }
  const STATUS_MASK = -7169;
  function set_signal_status(signal, status) {
    signal.f = signal.f & STATUS_MASK | status;
  }
  function deep_read_state(value) {
    if (typeof value !== "object" || !value || value instanceof EventTarget) {
      return;
    }
    if (STATE_SYMBOL in value) {
      deep_read(value);
    } else if (!Array.isArray(value)) {
      for (let key2 in value) {
        const prop2 = value[key2];
        if (typeof prop2 === "object" && prop2 && STATE_SYMBOL in prop2) {
          deep_read(prop2);
        }
      }
    }
  }
  function deep_read(value, visited = /* @__PURE__ */ new Set()) {
    if (typeof value === "object" && value !== null && // We don't want to traverse DOM elements
    !(value instanceof EventTarget) && !visited.has(value)) {
      visited.add(value);
      if (value instanceof Date) {
        value.getTime();
      }
      for (let key2 in value) {
        try {
          deep_read(value[key2], visited);
        } catch (e) {
        }
      }
      const proto = get_prototype_of(value);
      if (proto !== Object.prototype && proto !== Array.prototype && proto !== Map.prototype && proto !== Set.prototype && proto !== Date.prototype) {
        const descriptors = get_descriptors(proto);
        for (let key2 in descriptors) {
          const get2 = descriptors[key2].get;
          if (get2) {
            try {
              get2.call(value);
            } catch (e) {
            }
          }
        }
      }
    }
  }
  const PASSIVE_EVENTS = ["touchstart", "touchmove"];
  function is_passive_event(name) {
    return PASSIVE_EVENTS.includes(name);
  }
  const all_registered_events = /* @__PURE__ */ new Set();
  const root_event_handles = /* @__PURE__ */ new Set();
  function create_event(event_name, dom, handler, options = {}) {
    function target_handler(event2) {
      if (!options.capture) {
        handle_event_propagation.call(dom, event2);
      }
      if (!event2.cancelBubble) {
        return without_reactive_context(() => {
          return handler == null ? void 0 : handler.call(this, event2);
        });
      }
    }
    if (event_name.startsWith("pointer") || event_name.startsWith("touch") || event_name === "wheel") {
      queue_micro_task(() => {
        dom.addEventListener(event_name, target_handler, options);
      });
    } else {
      dom.addEventListener(event_name, target_handler, options);
    }
    return target_handler;
  }
  function event(event_name, dom, handler, capture2, passive) {
    var options = { capture: capture2, passive };
    var target_handler = create_event(event_name, dom, handler, options);
    if (dom === document.body || // @ts-ignore
    dom === window || // @ts-ignore
    dom === document || // Firefox has quirky behavior, it can happen that we still get "canplay" events when the element is already removed
    dom instanceof HTMLMediaElement) {
      teardown(() => {
        dom.removeEventListener(event_name, target_handler, options);
      });
    }
  }
  let last_propagated_event = null;
  function handle_event_propagation(event2) {
    var _a2;
    var handler_element = this;
    var owner_document = (
      /** @type {Node} */
      handler_element.ownerDocument
    );
    var event_name = event2.type;
    var path = ((_a2 = event2.composedPath) == null ? void 0 : _a2.call(event2)) || [];
    var current_target = (
      /** @type {null | Element} */
      path[0] || event2.target
    );
    last_propagated_event = event2;
    var path_idx = 0;
    var handled_at = last_propagated_event === event2 && event2.__root;
    if (handled_at) {
      var at_idx = path.indexOf(handled_at);
      if (at_idx !== -1 && (handler_element === document || handler_element === /** @type {any} */
      window)) {
        event2.__root = handler_element;
        return;
      }
      var handler_idx = path.indexOf(handler_element);
      if (handler_idx === -1) {
        return;
      }
      if (at_idx <= handler_idx) {
        path_idx = at_idx;
      }
    }
    current_target = /** @type {Element} */
    path[path_idx] || event2.target;
    if (current_target === handler_element) return;
    define_property(event2, "currentTarget", {
      configurable: true,
      get() {
        return current_target || owner_document;
      }
    });
    var previous_reaction = active_reaction;
    var previous_effect = active_effect;
    set_active_reaction(null);
    set_active_effect(null);
    try {
      var throw_error;
      var other_errors = [];
      while (current_target !== null) {
        var parent_element = current_target.assignedSlot || current_target.parentNode || /** @type {any} */
        current_target.host || null;
        try {
          var delegated = current_target["__" + event_name];
          if (delegated != null && (!/** @type {any} */
          current_target.disabled || // DOM could've been updated already by the time this is reached, so we check this as well
          // -> the target could not have been disabled because it emits the event in the first place
          event2.target === current_target)) {
            delegated.call(current_target, event2);
          }
        } catch (error) {
          if (throw_error) {
            other_errors.push(error);
          } else {
            throw_error = error;
          }
        }
        if (event2.cancelBubble || parent_element === handler_element || parent_element === null) {
          break;
        }
        current_target = parent_element;
      }
      if (throw_error) {
        for (let error of other_errors) {
          queueMicrotask(() => {
            throw error;
          });
        }
        throw throw_error;
      }
    } finally {
      event2.__root = handler_element;
      delete event2.currentTarget;
      set_active_reaction(previous_reaction);
      set_active_effect(previous_effect);
    }
  }
  function create_fragment_from_html(html2) {
    var elem = document.createElement("template");
    elem.innerHTML = html2.replaceAll("<!>", "<!---->");
    return elem.content;
  }
  function assign_nodes(start, end) {
    var effect2 = (
      /** @type {Effect} */
      active_effect
    );
    if (effect2.nodes_start === null) {
      effect2.nodes_start = start;
      effect2.nodes_end = end;
    }
  }
  // @__NO_SIDE_EFFECTS__
  function from_html(content, flags2) {
    var is_fragment = (flags2 & TEMPLATE_FRAGMENT) !== 0;
    var use_import_node = (flags2 & TEMPLATE_USE_IMPORT_NODE) !== 0;
    var node;
    var has_start = !content.startsWith("<!>");
    return () => {
      if (node === void 0) {
        node = create_fragment_from_html(has_start ? content : "<!>" + content);
        if (!is_fragment) node = /** @type {Node} */
        /* @__PURE__ */ get_first_child(node);
      }
      var clone = (
        /** @type {TemplateNode} */
        use_import_node || is_firefox ? document.importNode(node, true) : node.cloneNode(true)
      );
      if (is_fragment) {
        var start = (
          /** @type {TemplateNode} */
          /* @__PURE__ */ get_first_child(clone)
        );
        var end = (
          /** @type {TemplateNode} */
          clone.lastChild
        );
        assign_nodes(start, end);
      } else {
        assign_nodes(clone, clone);
      }
      return clone;
    };
  }
  // @__NO_SIDE_EFFECTS__
  function from_namespace(content, flags2, ns = "svg") {
    var has_start = !content.startsWith("<!>");
    var wrapped = `<${ns}>${has_start ? content : "<!>" + content}</${ns}>`;
    var node;
    return () => {
      if (!node) {
        var fragment = (
          /** @type {DocumentFragment} */
          create_fragment_from_html(wrapped)
        );
        var root2 = (
          /** @type {Element} */
          /* @__PURE__ */ get_first_child(fragment)
        );
        {
          node = /** @type {Element} */
          /* @__PURE__ */ get_first_child(root2);
        }
      }
      var clone = (
        /** @type {TemplateNode} */
        node.cloneNode(true)
      );
      {
        assign_nodes(clone, clone);
      }
      return clone;
    };
  }
  // @__NO_SIDE_EFFECTS__
  function from_svg(content, flags2) {
    return /* @__PURE__ */ from_namespace(content, flags2, "svg");
  }
  function text(value = "") {
    {
      var t = create_text(value + "");
      assign_nodes(t, t);
      return t;
    }
  }
  function comment() {
    var frag = document.createDocumentFragment();
    var start = document.createComment("");
    var anchor = create_text();
    frag.append(start, anchor);
    assign_nodes(start, anchor);
    return frag;
  }
  function append(anchor, dom) {
    if (anchor === null) {
      return;
    }
    anchor.before(
      /** @type {Node} */
      dom
    );
  }
  function set_text(text2, value) {
    var str = value == null ? "" : typeof value === "object" ? value + "" : value;
    if (str !== (text2.__t ?? (text2.__t = text2.nodeValue))) {
      text2.__t = str;
      text2.nodeValue = str + "";
    }
  }
  function mount(component, options) {
    return _mount(component, options);
  }
  const document_listeners = /* @__PURE__ */ new Map();
  function _mount(Component, { target, anchor, props = {}, events, context, intro = true }) {
    init_operations();
    var registered_events = /* @__PURE__ */ new Set();
    var event_handle = (events2) => {
      for (var i = 0; i < events2.length; i++) {
        var event_name = events2[i];
        if (registered_events.has(event_name)) continue;
        registered_events.add(event_name);
        var passive = is_passive_event(event_name);
        target.addEventListener(event_name, handle_event_propagation, { passive });
        var n = document_listeners.get(event_name);
        if (n === void 0) {
          document.addEventListener(event_name, handle_event_propagation, { passive });
          document_listeners.set(event_name, 1);
        } else {
          document_listeners.set(event_name, n + 1);
        }
      }
    };
    event_handle(array_from(all_registered_events));
    root_event_handles.add(event_handle);
    var component = void 0;
    var unmount = component_root(() => {
      var anchor_node = anchor ?? target.appendChild(create_text());
      boundary(
        /** @type {TemplateNode} */
        anchor_node,
        {
          pending: () => {
          }
        },
        (anchor_node2) => {
          if (context) {
            push({});
            var ctx = (
              /** @type {ComponentContext} */
              component_context
            );
            ctx.c = context;
          }
          if (events) {
            props.$$events = events;
          }
          component = Component(anchor_node2, props) || {};
          if (context) {
            pop();
          }
        }
      );
      return () => {
        var _a2;
        for (var event_name of registered_events) {
          target.removeEventListener(event_name, handle_event_propagation);
          var n = (
            /** @type {number} */
            document_listeners.get(event_name)
          );
          if (--n === 0) {
            document.removeEventListener(event_name, handle_event_propagation);
            document_listeners.delete(event_name);
          } else {
            document_listeners.set(event_name, n);
          }
        }
        root_event_handles.delete(event_handle);
        if (anchor_node !== anchor) {
          (_a2 = anchor_node.parentNode) == null ? void 0 : _a2.removeChild(anchor_node);
        }
      };
    });
    mounted_components.set(component, unmount);
    return component;
  }
  let mounted_components = /* @__PURE__ */ new WeakMap();
  class BranchManager {
    /**
     * @param {TemplateNode} anchor
     * @param {boolean} transition
     */
    constructor(anchor, transition = true) {
      /** @type {TemplateNode} */
      __publicField(this, "anchor");
      /** @type {Map<Batch, Key>} */
      __privateAdd(this, _batches, /* @__PURE__ */ new Map());
      /** @type {Map<Key, Effect>} */
      __privateAdd(this, _onscreen, /* @__PURE__ */ new Map());
      /** @type {Map<Key, Branch>} */
      __privateAdd(this, _offscreen, /* @__PURE__ */ new Map());
      /**
       * Whether to pause (i.e. outro) on change, or destroy immediately.
       * This is necessary for `<svelte:element>`
       */
      __privateAdd(this, _transition, true);
      __privateAdd(this, _commit, () => {
        var batch = (
          /** @type {Batch} */
          current_batch
        );
        if (!__privateGet(this, _batches).has(batch)) return;
        var key2 = (
          /** @type {Key} */
          __privateGet(this, _batches).get(batch)
        );
        var onscreen = __privateGet(this, _onscreen).get(key2);
        if (onscreen) {
          resume_effect(onscreen);
        } else {
          var offscreen = __privateGet(this, _offscreen).get(key2);
          if (offscreen) {
            __privateGet(this, _onscreen).set(key2, offscreen.effect);
            __privateGet(this, _offscreen).delete(key2);
            offscreen.fragment.lastChild.remove();
            this.anchor.before(offscreen.fragment);
            onscreen = offscreen.effect;
          }
        }
        for (const [b, k] of __privateGet(this, _batches)) {
          __privateGet(this, _batches).delete(b);
          if (b === batch) {
            break;
          }
          const offscreen2 = __privateGet(this, _offscreen).get(k);
          if (offscreen2) {
            destroy_effect(offscreen2.effect);
            __privateGet(this, _offscreen).delete(k);
          }
        }
        for (const [k, effect2] of __privateGet(this, _onscreen)) {
          if (k === key2) continue;
          const on_destroy = () => {
            const keys = Array.from(__privateGet(this, _batches).values());
            if (keys.includes(k)) {
              var fragment = document.createDocumentFragment();
              move_effect(effect2, fragment);
              fragment.append(create_text());
              __privateGet(this, _offscreen).set(k, { effect: effect2, fragment });
            } else {
              destroy_effect(effect2);
            }
            __privateGet(this, _onscreen).delete(k);
          };
          if (__privateGet(this, _transition) || !onscreen) {
            pause_effect(effect2, on_destroy, false);
          } else {
            on_destroy();
          }
        }
      });
      /**
       * @param {Batch} batch
       */
      __privateAdd(this, _discard, (batch) => {
        __privateGet(this, _batches).delete(batch);
        const keys = Array.from(__privateGet(this, _batches).values());
        for (const [k, branch2] of __privateGet(this, _offscreen)) {
          if (!keys.includes(k)) {
            destroy_effect(branch2.effect);
            __privateGet(this, _offscreen).delete(k);
          }
        }
      });
      this.anchor = anchor;
      __privateSet(this, _transition, transition);
    }
    /**
     *
     * @param {any} key
     * @param {null | ((target: TemplateNode) => void)} fn
     */
    ensure(key2, fn) {
      var batch = (
        /** @type {Batch} */
        current_batch
      );
      var defer = should_defer_append();
      if (fn && !__privateGet(this, _onscreen).has(key2) && !__privateGet(this, _offscreen).has(key2)) {
        if (defer) {
          var fragment = document.createDocumentFragment();
          var target = create_text();
          fragment.append(target);
          __privateGet(this, _offscreen).set(key2, {
            effect: branch(() => fn(target)),
            fragment
          });
        } else {
          __privateGet(this, _onscreen).set(
            key2,
            branch(() => fn(this.anchor))
          );
        }
      }
      __privateGet(this, _batches).set(batch, key2);
      if (defer) {
        for (const [k, effect2] of __privateGet(this, _onscreen)) {
          if (k === key2) {
            batch.skipped_effects.delete(effect2);
          } else {
            batch.skipped_effects.add(effect2);
          }
        }
        for (const [k, branch2] of __privateGet(this, _offscreen)) {
          if (k === key2) {
            batch.skipped_effects.delete(branch2.effect);
          } else {
            batch.skipped_effects.add(branch2.effect);
          }
        }
        batch.oncommit(__privateGet(this, _commit));
        batch.ondiscard(__privateGet(this, _discard));
      } else {
        __privateGet(this, _commit).call(this);
      }
    }
  }
  _batches = new WeakMap();
  _onscreen = new WeakMap();
  _offscreen = new WeakMap();
  _transition = new WeakMap();
  _commit = new WeakMap();
  _discard = new WeakMap();
  function if_block(node, fn, elseif = false) {
    var branches = new BranchManager(node);
    var flags2 = elseif ? EFFECT_TRANSPARENT : 0;
    function update_branch(condition, fn2) {
      branches.ensure(condition, fn2);
    }
    block(() => {
      var has_branch = false;
      fn((fn2, flag = true) => {
        has_branch = true;
        update_branch(flag, fn2);
      });
      if (!has_branch) {
        update_branch(false, null);
      }
    }, flags2);
  }
  function key(node, get_key, render_fn) {
    var branches = new BranchManager(node);
    var legacy = !is_runes();
    block(() => {
      var key2 = get_key();
      if (legacy && key2 !== null && typeof key2 === "object") {
        key2 = /** @type {V} */
        {};
      }
      branches.ensure(key2, render_fn);
    });
  }
  function css_props(element, get_styles) {
    render_effect(() => {
      var styles = get_styles();
      for (var key2 in styles) {
        var value = styles[key2];
        if (value) {
          element.style.setProperty(key2, value);
        } else {
          element.style.removeProperty(key2);
        }
      }
    });
  }
  function index(_, i) {
    return i;
  }
  function pause_effects(state2, items, controlled_anchor) {
    var items_map = state2.items;
    var transitions = [];
    var length = items.length;
    for (var i = 0; i < length; i++) {
      pause_children(items[i].e, transitions, true);
    }
    var is_controlled = length > 0 && transitions.length === 0 && controlled_anchor !== null;
    if (is_controlled) {
      var parent_node = (
        /** @type {Element} */
        /** @type {Element} */
        controlled_anchor.parentNode
      );
      clear_text_content(parent_node);
      parent_node.append(
        /** @type {Element} */
        controlled_anchor
      );
      items_map.clear();
      link(state2, items[0].prev, items[length - 1].next);
    }
    run_out_transitions(transitions, () => {
      for (var i2 = 0; i2 < length; i2++) {
        var item = items[i2];
        if (!is_controlled) {
          items_map.delete(item.k);
          link(state2, item.prev, item.next);
        }
        destroy_effect(item.e, !is_controlled);
      }
    });
  }
  function each(node, flags2, get_collection, get_key, render_fn, fallback_fn = null) {
    var anchor = node;
    var state2 = { flags: flags2, items: /* @__PURE__ */ new Map(), first: null };
    var is_controlled = (flags2 & EACH_IS_CONTROLLED) !== 0;
    if (is_controlled) {
      var parent_node = (
        /** @type {Element} */
        node
      );
      anchor = parent_node.appendChild(create_text());
    }
    var fallback = null;
    var was_empty = false;
    var offscreen_items = /* @__PURE__ */ new Map();
    var each_array = /* @__PURE__ */ derived_safe_equal(() => {
      var collection = get_collection();
      return is_array(collection) ? collection : collection == null ? [] : array_from(collection);
    });
    var array;
    var each_effect;
    function commit() {
      reconcile(
        each_effect,
        array,
        state2,
        offscreen_items,
        anchor,
        render_fn,
        flags2,
        get_key,
        get_collection
      );
      if (fallback_fn !== null) {
        if (array.length === 0) {
          if (fallback) {
            resume_effect(fallback);
          } else {
            fallback = branch(() => fallback_fn(anchor));
          }
        } else if (fallback !== null) {
          pause_effect(fallback, () => {
            fallback = null;
          });
        }
      }
    }
    block(() => {
      each_effect ?? (each_effect = /** @type {Effect} */
      active_effect);
      array = /** @type {V[]} */
      get$1(each_array);
      var length = array.length;
      if (was_empty && length === 0) {
        return;
      }
      was_empty = length === 0;
      var item, i, value, key2;
      {
        if (should_defer_append()) {
          var keys = /* @__PURE__ */ new Set();
          var batch = (
            /** @type {Batch} */
            current_batch
          );
          for (i = 0; i < length; i += 1) {
            value = array[i];
            key2 = get_key(value, i);
            var existing = state2.items.get(key2) ?? offscreen_items.get(key2);
            if (existing) {
              if ((flags2 & (EACH_ITEM_REACTIVE | EACH_INDEX_REACTIVE)) !== 0) {
                update_item(existing, value, i, flags2);
              }
            } else {
              item = create_item(
                null,
                state2,
                null,
                null,
                value,
                key2,
                i,
                render_fn,
                flags2,
                get_collection,
                true
              );
              offscreen_items.set(key2, item);
            }
            keys.add(key2);
          }
          for (const [key3, item2] of state2.items) {
            if (!keys.has(key3)) {
              batch.skipped_effects.add(item2.e);
            }
          }
          batch.oncommit(commit);
        } else {
          commit();
        }
      }
      get$1(each_array);
    });
  }
  function reconcile(each_effect, array, state2, offscreen_items, anchor, render_fn, flags2, get_key, get_collection) {
    var _a2, _b, _c, _d;
    var is_animated = (flags2 & EACH_IS_ANIMATED) !== 0;
    var should_update = (flags2 & (EACH_ITEM_REACTIVE | EACH_INDEX_REACTIVE)) !== 0;
    var length = array.length;
    var items = state2.items;
    var first = state2.first;
    var current = first;
    var seen;
    var prev = null;
    var to_animate;
    var matched = [];
    var stashed = [];
    var value;
    var key2;
    var item;
    var i;
    if (is_animated) {
      for (i = 0; i < length; i += 1) {
        value = array[i];
        key2 = get_key(value, i);
        item = items.get(key2);
        if (item !== void 0) {
          (_a2 = item.a) == null ? void 0 : _a2.measure();
          (to_animate ?? (to_animate = /* @__PURE__ */ new Set())).add(item);
        }
      }
    }
    for (i = 0; i < length; i += 1) {
      value = array[i];
      key2 = get_key(value, i);
      item = items.get(key2);
      if (item === void 0) {
        var pending = offscreen_items.get(key2);
        if (pending !== void 0) {
          offscreen_items.delete(key2);
          items.set(key2, pending);
          var next = prev ? prev.next : current;
          link(state2, prev, pending);
          link(state2, pending, next);
          move(pending, next, anchor);
          prev = pending;
        } else {
          var child_anchor = current ? (
            /** @type {TemplateNode} */
            current.e.nodes_start
          ) : anchor;
          prev = create_item(
            child_anchor,
            state2,
            prev,
            prev === null ? state2.first : prev.next,
            value,
            key2,
            i,
            render_fn,
            flags2,
            get_collection
          );
        }
        items.set(key2, prev);
        matched = [];
        stashed = [];
        current = prev.next;
        continue;
      }
      if (should_update) {
        update_item(item, value, i, flags2);
      }
      if ((item.e.f & INERT) !== 0) {
        resume_effect(item.e);
        if (is_animated) {
          (_b = item.a) == null ? void 0 : _b.unfix();
          (to_animate ?? (to_animate = /* @__PURE__ */ new Set())).delete(item);
        }
      }
      if (item !== current) {
        if (seen !== void 0 && seen.has(item)) {
          if (matched.length < stashed.length) {
            var start = stashed[0];
            var j;
            prev = start.prev;
            var a = matched[0];
            var b = matched[matched.length - 1];
            for (j = 0; j < matched.length; j += 1) {
              move(matched[j], start, anchor);
            }
            for (j = 0; j < stashed.length; j += 1) {
              seen.delete(stashed[j]);
            }
            link(state2, a.prev, b.next);
            link(state2, prev, a);
            link(state2, b, start);
            current = start;
            prev = b;
            i -= 1;
            matched = [];
            stashed = [];
          } else {
            seen.delete(item);
            move(item, current, anchor);
            link(state2, item.prev, item.next);
            link(state2, item, prev === null ? state2.first : prev.next);
            link(state2, prev, item);
            prev = item;
          }
          continue;
        }
        matched = [];
        stashed = [];
        while (current !== null && current.k !== key2) {
          if ((current.e.f & INERT) === 0) {
            (seen ?? (seen = /* @__PURE__ */ new Set())).add(current);
          }
          stashed.push(current);
          current = current.next;
        }
        if (current === null) {
          continue;
        }
        item = current;
      }
      matched.push(item);
      prev = item;
      current = item.next;
    }
    if (current !== null || seen !== void 0) {
      var to_destroy = seen === void 0 ? [] : array_from(seen);
      while (current !== null) {
        if ((current.e.f & INERT) === 0) {
          to_destroy.push(current);
        }
        current = current.next;
      }
      var destroy_length = to_destroy.length;
      if (destroy_length > 0) {
        var controlled_anchor = (flags2 & EACH_IS_CONTROLLED) !== 0 && length === 0 ? anchor : null;
        if (is_animated) {
          for (i = 0; i < destroy_length; i += 1) {
            (_c = to_destroy[i].a) == null ? void 0 : _c.measure();
          }
          for (i = 0; i < destroy_length; i += 1) {
            (_d = to_destroy[i].a) == null ? void 0 : _d.fix();
          }
        }
        pause_effects(state2, to_destroy, controlled_anchor);
      }
    }
    if (is_animated) {
      queue_micro_task(() => {
        var _a3;
        if (to_animate === void 0) return;
        for (item of to_animate) {
          (_a3 = item.a) == null ? void 0 : _a3.apply();
        }
      });
    }
    each_effect.first = state2.first && state2.first.e;
    each_effect.last = prev && prev.e;
    for (var unused of offscreen_items.values()) {
      destroy_effect(unused.e);
    }
    offscreen_items.clear();
  }
  function update_item(item, value, index2, type) {
    if ((type & EACH_ITEM_REACTIVE) !== 0) {
      internal_set(item.v, value);
    }
    if ((type & EACH_INDEX_REACTIVE) !== 0) {
      internal_set(
        /** @type {Value<number>} */
        item.i,
        index2
      );
    } else {
      item.i = index2;
    }
  }
  function create_item(anchor, state2, prev, next, value, key2, index2, render_fn, flags2, get_collection, deferred2) {
    var reactive = (flags2 & EACH_ITEM_REACTIVE) !== 0;
    var mutable = (flags2 & EACH_ITEM_IMMUTABLE) === 0;
    var v = reactive ? mutable ? /* @__PURE__ */ mutable_source(value, false, false) : source(value) : value;
    var i = (flags2 & EACH_INDEX_REACTIVE) === 0 ? index2 : source(index2);
    var item = {
      i,
      v,
      k: key2,
      a: null,
      // @ts-expect-error
      e: null,
      prev,
      next
    };
    try {
      if (anchor === null) {
        var fragment = document.createDocumentFragment();
        fragment.append(anchor = create_text());
      }
      item.e = branch(() => render_fn(
        /** @type {Node} */
        anchor,
        v,
        i,
        get_collection
      ), hydrating);
      item.e.prev = prev && prev.e;
      item.e.next = next && next.e;
      if (prev === null) {
        if (!deferred2) {
          state2.first = item;
        }
      } else {
        prev.next = item;
        prev.e.next = item.e;
      }
      if (next !== null) {
        next.prev = item;
        next.e.prev = item.e;
      }
      return item;
    } finally {
    }
  }
  function move(item, next, anchor) {
    var end = item.next ? (
      /** @type {TemplateNode} */
      item.next.e.nodes_start
    ) : anchor;
    var dest = next ? (
      /** @type {TemplateNode} */
      next.e.nodes_start
    ) : anchor;
    var node = (
      /** @type {TemplateNode} */
      item.e.nodes_start
    );
    while (node !== null && node !== end) {
      var next_node = (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_next_sibling(node)
      );
      dest.before(node);
      node = next_node;
    }
  }
  function link(state2, prev, next) {
    if (prev === null) {
      state2.first = next;
    } else {
      prev.next = next;
      prev.e.next = next && next.e;
    }
    if (next !== null) {
      next.prev = prev;
      next.e.prev = prev && prev.e;
    }
  }
  function html(node, get_value, svg = false, mathml = false, skip_warning = false) {
    var anchor = node;
    var value = "";
    template_effect(() => {
      var effect2 = (
        /** @type {Effect} */
        active_effect
      );
      if (value === (value = get_value() ?? "")) {
        return;
      }
      if (effect2.nodes_start !== null) {
        remove_effect_dom(
          effect2.nodes_start,
          /** @type {TemplateNode} */
          effect2.nodes_end
        );
        effect2.nodes_start = effect2.nodes_end = null;
      }
      if (value === "") return;
      var html2 = value + "";
      if (svg) html2 = `<svg>${html2}</svg>`;
      else if (mathml) html2 = `<math>${html2}</math>`;
      var node2 = create_fragment_from_html(html2);
      if (svg || mathml) {
        node2 = /** @type {Element} */
        /* @__PURE__ */ get_first_child(node2);
      }
      assign_nodes(
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_first_child(node2),
        /** @type {TemplateNode} */
        node2.lastChild
      );
      if (svg || mathml) {
        while (/* @__PURE__ */ get_first_child(node2)) {
          anchor.before(
            /** @type {Node} */
            /* @__PURE__ */ get_first_child(node2)
          );
        }
      } else {
        anchor.before(node2);
      }
    });
  }
  function slot(anchor, $$props, name, slot_props, fallback_fn) {
    var _a2;
    var slot_fn = (_a2 = $$props.$$slots) == null ? void 0 : _a2[name];
    var is_interop = false;
    if (slot_fn === true) {
      slot_fn = $$props[name === "default" ? "children" : name];
      is_interop = true;
    }
    if (slot_fn === void 0) ;
    else {
      slot_fn(anchor, is_interop ? () => slot_props : slot_props);
    }
  }
  function action(dom, action2, get_value) {
    effect(() => {
      var payload = untrack(() => action2(dom, get_value == null ? void 0 : get_value()) || {});
      if (get_value && (payload == null ? void 0 : payload.update)) {
        var inited = false;
        var prev = (
          /** @type {any} */
          {}
        );
        render_effect(() => {
          var value = get_value();
          deep_read_state(value);
          if (inited && safe_not_equal(prev, value)) {
            prev = value;
            payload.update(value);
          }
        });
        inited = true;
      }
      if (payload == null ? void 0 : payload.destroy) {
        return () => (
          /** @type {Function} */
          payload.destroy()
        );
      }
    });
  }
  function r(e) {
    var t, f, n = "";
    if ("string" == typeof e || "number" == typeof e) n += e;
    else if ("object" == typeof e) if (Array.isArray(e)) {
      var o = e.length;
      for (t = 0; t < o; t++) e[t] && (f = r(e[t])) && (n && (n += " "), n += f);
    } else for (f in e) e[f] && (n && (n += " "), n += f);
    return n;
  }
  function clsx$1() {
    for (var e, t, f = 0, n = "", o = arguments.length; f < o; f++) (e = arguments[f]) && (t = r(e)) && (n && (n += " "), n += t);
    return n;
  }
  function clsx(value) {
    if (typeof value === "object") {
      return clsx$1(value);
    } else {
      return value ?? "";
    }
  }
  const whitespace = [..." 	\n\r\f \v\uFEFF"];
  function to_class(value, hash, directives) {
    var classname = value == null ? "" : "" + value;
    if (hash) {
      classname = classname ? classname + " " + hash : hash;
    }
    if (directives) {
      for (var key2 in directives) {
        if (directives[key2]) {
          classname = classname ? classname + " " + key2 : key2;
        } else if (classname.length) {
          var len = key2.length;
          var a = 0;
          while ((a = classname.indexOf(key2, a)) >= 0) {
            var b = a + len;
            if ((a === 0 || whitespace.includes(classname[a - 1])) && (b === classname.length || whitespace.includes(classname[b]))) {
              classname = (a === 0 ? "" : classname.substring(0, a)) + classname.substring(b + 1);
            } else {
              a = b;
            }
          }
        }
      }
    }
    return classname === "" ? null : classname;
  }
  function append_styles(styles, important = false) {
    var separator = important ? " !important;" : ";";
    var css = "";
    for (var key2 in styles) {
      var value = styles[key2];
      if (value != null && value !== "") {
        css += " " + key2 + ": " + value + separator;
      }
    }
    return css;
  }
  function to_css_name(name) {
    if (name[0] !== "-" || name[1] !== "-") {
      return name.toLowerCase();
    }
    return name;
  }
  function to_style(value, styles) {
    if (styles) {
      var new_style = "";
      var normal_styles;
      var important_styles;
      if (Array.isArray(styles)) {
        normal_styles = styles[0];
        important_styles = styles[1];
      } else {
        normal_styles = styles;
      }
      if (value) {
        value = String(value).replaceAll(/\s*\/\*.*?\*\/\s*/g, "").trim();
        var in_str = false;
        var in_apo = 0;
        var in_comment = false;
        var reserved_names = [];
        if (normal_styles) {
          reserved_names.push(...Object.keys(normal_styles).map(to_css_name));
        }
        if (important_styles) {
          reserved_names.push(...Object.keys(important_styles).map(to_css_name));
        }
        var start_index = 0;
        var name_index = -1;
        const len = value.length;
        for (var i = 0; i < len; i++) {
          var c = value[i];
          if (in_comment) {
            if (c === "/" && value[i - 1] === "*") {
              in_comment = false;
            }
          } else if (in_str) {
            if (in_str === c) {
              in_str = false;
            }
          } else if (c === "/" && value[i + 1] === "*") {
            in_comment = true;
          } else if (c === '"' || c === "'") {
            in_str = c;
          } else if (c === "(") {
            in_apo++;
          } else if (c === ")") {
            in_apo--;
          }
          if (!in_comment && in_str === false && in_apo === 0) {
            if (c === ":" && name_index === -1) {
              name_index = i;
            } else if (c === ";" || i === len - 1) {
              if (name_index !== -1) {
                var name = to_css_name(value.substring(start_index, name_index).trim());
                if (!reserved_names.includes(name)) {
                  if (c !== ";") {
                    i++;
                  }
                  var property = value.substring(start_index, i).trim();
                  new_style += " " + property + ";";
                }
              }
              start_index = i + 1;
              name_index = -1;
            }
          }
        }
      }
      if (normal_styles) {
        new_style += append_styles(normal_styles);
      }
      if (important_styles) {
        new_style += append_styles(important_styles, true);
      }
      new_style = new_style.trim();
      return new_style === "" ? null : new_style;
    }
    return value == null ? null : String(value);
  }
  function set_class(dom, is_html, value, hash, prev_classes, next_classes) {
    var prev = dom.__className;
    if (prev !== value || prev === void 0) {
      var next_class_name = to_class(value, hash, next_classes);
      {
        if (next_class_name == null) {
          dom.removeAttribute("class");
        } else {
          dom.className = next_class_name;
        }
      }
      dom.__className = value;
    } else if (next_classes && prev_classes !== next_classes) {
      for (var key2 in next_classes) {
        var is_present = !!next_classes[key2];
        if (prev_classes == null || is_present !== !!prev_classes[key2]) {
          dom.classList.toggle(key2, is_present);
        }
      }
    }
    return next_classes;
  }
  function update_styles(dom, prev = {}, next, priority) {
    for (var key2 in next) {
      var value = next[key2];
      if (prev[key2] !== value) {
        if (next[key2] == null) {
          dom.style.removeProperty(key2);
        } else {
          dom.style.setProperty(key2, value, priority);
        }
      }
    }
  }
  function set_style(dom, value, prev_styles, next_styles) {
    var prev = dom.__style;
    if (prev !== value) {
      var next_style_attr = to_style(value, next_styles);
      {
        if (next_style_attr == null) {
          dom.removeAttribute("style");
        } else {
          dom.style.cssText = next_style_attr;
        }
      }
      dom.__style = value;
    } else if (next_styles) {
      if (Array.isArray(next_styles)) {
        update_styles(dom, prev_styles == null ? void 0 : prev_styles[0], next_styles[0]);
        update_styles(dom, prev_styles == null ? void 0 : prev_styles[1], next_styles[1], "important");
      } else {
        update_styles(dom, prev_styles, next_styles);
      }
    }
    return next_styles;
  }
  function select_option(select, value, mounting = false) {
    if (select.multiple) {
      if (value == void 0) {
        return;
      }
      if (!is_array(value)) {
        return select_multiple_invalid_value();
      }
      for (var option of select.options) {
        option.selected = value.includes(get_option_value(option));
      }
      return;
    }
    for (option of select.options) {
      var option_value = get_option_value(option);
      if (is(option_value, value)) {
        option.selected = true;
        return;
      }
    }
    if (!mounting || value !== void 0) {
      select.selectedIndex = -1;
    }
  }
  function init_select(select) {
    var observer = new MutationObserver(() => {
      select_option(select, select.__value);
    });
    observer.observe(select, {
      // Listen to option element changes
      childList: true,
      subtree: true,
      // because of <optgroup>
      // Listen to option element value attribute changes
      // (doesn't get notified of select value changes,
      // because that property is not reflected as an attribute)
      attributes: true,
      attributeFilter: ["value"]
    });
    teardown(() => {
      observer.disconnect();
    });
  }
  function bind_select_value(select, get2, set2 = get2) {
    var batches2 = /* @__PURE__ */ new WeakSet();
    var mounting = true;
    listen_to_event_and_reset_event(select, "change", (is_reset) => {
      var query = is_reset ? "[selected]" : ":checked";
      var value;
      if (select.multiple) {
        value = [].map.call(select.querySelectorAll(query), get_option_value);
      } else {
        var selected_option = select.querySelector(query) ?? // will fall back to first non-disabled option if no option is selected
        select.querySelector("option:not([disabled])");
        value = selected_option && get_option_value(selected_option);
      }
      set2(value);
      if (current_batch !== null) {
        batches2.add(current_batch);
      }
    });
    effect(() => {
      var value = get2();
      if (select === document.activeElement) {
        var batch = (
          /** @type {Batch} */
          previous_batch ?? current_batch
        );
        if (batches2.has(batch)) {
          return;
        }
      }
      select_option(select, value, mounting);
      if (mounting && value === void 0) {
        var selected_option = select.querySelector(":checked");
        if (selected_option !== null) {
          value = get_option_value(selected_option);
          set2(value);
        }
      }
      select.__value = value;
      mounting = false;
    });
    init_select(select);
  }
  function get_option_value(option) {
    if ("__value" in option) {
      return option.__value;
    } else {
      return option.value;
    }
  }
  const IS_CUSTOM_ELEMENT = Symbol("is custom element");
  const IS_HTML = Symbol("is html");
  function set_attribute(element, attribute, value, skip_warning) {
    var attributes = get_attributes(element);
    if (attributes[attribute] === (attributes[attribute] = value)) return;
    if (attribute === "loading") {
      element[LOADING_ATTR_SYMBOL] = value;
    }
    if (value == null) {
      element.removeAttribute(attribute);
    } else if (typeof value !== "string" && get_setters(element).includes(attribute)) {
      element[attribute] = value;
    } else {
      element.setAttribute(attribute, value);
    }
  }
  function get_attributes(element) {
    return (
      /** @type {Record<string | symbol, unknown>} **/
      // @ts-expect-error
      element.__attributes ?? (element.__attributes = {
        [IS_CUSTOM_ELEMENT]: element.nodeName.includes("-"),
        [IS_HTML]: element.namespaceURI === NAMESPACE_HTML
      })
    );
  }
  var setters_cache = /* @__PURE__ */ new Map();
  function get_setters(element) {
    var cache_key = element.getAttribute("is") || element.nodeName;
    var setters = setters_cache.get(cache_key);
    if (setters) return setters;
    setters_cache.set(cache_key, setters = []);
    var descriptors;
    var proto = element;
    var element_proto = Element.prototype;
    while (element_proto !== proto) {
      descriptors = get_descriptors(proto);
      for (var key2 in descriptors) {
        if (descriptors[key2].set) {
          setters.push(key2);
        }
      }
      proto = get_prototype_of(proto);
    }
    return setters;
  }
  function bind_value(input, get2, set2 = get2) {
    var batches2 = /* @__PURE__ */ new WeakSet();
    listen_to_event_and_reset_event(input, "input", async (is_reset) => {
      var value = is_reset ? input.defaultValue : input.value;
      value = is_numberlike_input(input) ? to_number(value) : value;
      set2(value);
      if (current_batch !== null) {
        batches2.add(current_batch);
      }
      await tick();
      if (value !== (value = get2())) {
        var start = input.selectionStart;
        var end = input.selectionEnd;
        var length = input.value.length;
        input.value = value ?? "";
        if (end !== null) {
          var new_length = input.value.length;
          if (start === end && end === length && new_length > length) {
            input.selectionStart = new_length;
            input.selectionEnd = new_length;
          } else {
            input.selectionStart = start;
            input.selectionEnd = Math.min(end, new_length);
          }
        }
      }
    });
    if (
      // If we are hydrating and the value has since changed,
      // then use the updated value from the input instead.
      // If defaultValue is set, then value == defaultValue
      // TODO Svelte 6: remove input.value check and set to empty string?
      untrack(get2) == null && input.value
    ) {
      set2(is_numberlike_input(input) ? to_number(input.value) : input.value);
      if (current_batch !== null) {
        batches2.add(current_batch);
      }
    }
    render_effect(() => {
      var value = get2();
      if (input === document.activeElement) {
        var batch = (
          /** @type {Batch} */
          previous_batch ?? current_batch
        );
        if (batches2.has(batch)) {
          return;
        }
      }
      if (is_numberlike_input(input) && value === to_number(input.value)) {
        return;
      }
      if (input.type === "date" && !value && !input.value) {
        return;
      }
      if (value !== input.value) {
        input.value = value ?? "";
      }
    });
  }
  function is_numberlike_input(input) {
    var type = input.type;
    return type === "number" || type === "range";
  }
  function to_number(value) {
    return value === "" ? null : +value;
  }
  function bind_prop(props, prop2, value) {
    var desc = get_descriptor(props, prop2);
    if (desc && desc.set) {
      props[prop2] = value;
      teardown(() => {
        props[prop2] = null;
      });
    }
  }
  function is_bound_this(bound_value, element_or_component) {
    return bound_value === element_or_component || (bound_value == null ? void 0 : bound_value[STATE_SYMBOL]) === element_or_component;
  }
  function bind_this(element_or_component = {}, update, get_value, get_parts) {
    effect(() => {
      var old_parts;
      var parts;
      render_effect(() => {
        old_parts = parts;
        parts = [];
        untrack(() => {
          if (element_or_component !== get_value(...parts)) {
            update(element_or_component, ...parts);
            if (old_parts && is_bound_this(get_value(...old_parts), element_or_component)) {
              update(null, ...old_parts);
            }
          }
        });
      });
      return () => {
        queue_micro_task(() => {
          if (parts && is_bound_this(get_value(...parts), element_or_component)) {
            update(null, ...parts);
          }
        });
      };
    });
    return element_or_component;
  }
  function stopPropagation(fn) {
    return function(...args) {
      var event2 = (
        /** @type {Event} */
        args[0]
      );
      event2.stopPropagation();
      return fn == null ? void 0 : fn.apply(this, args);
    };
  }
  function init(immutable = false) {
    const context = (
      /** @type {ComponentContextLegacy} */
      component_context
    );
    const callbacks = context.l.u;
    if (!callbacks) return;
    let props = () => deep_read_state(context.s);
    if (immutable) {
      let version = 0;
      let prev = (
        /** @type {Record<string, any>} */
        {}
      );
      const d = /* @__PURE__ */ derived$1(() => {
        let changed = false;
        const props2 = context.s;
        for (const key2 in props2) {
          if (props2[key2] !== prev[key2]) {
            prev[key2] = props2[key2];
            changed = true;
          }
        }
        if (changed) version++;
        return version;
      });
      props = () => get$1(d);
    }
    if (callbacks.b.length) {
      user_pre_effect(() => {
        observe_all(context, props);
        run_all(callbacks.b);
      });
    }
    user_effect(() => {
      const fns = untrack(() => callbacks.m.map(run));
      return () => {
        for (const fn of fns) {
          if (typeof fn === "function") {
            fn();
          }
        }
      };
    });
    if (callbacks.a.length) {
      user_effect(() => {
        observe_all(context, props);
        run_all(callbacks.a);
      });
    }
  }
  function observe_all(context, props) {
    if (context.l.s) {
      for (const signal of context.l.s) get$1(signal);
    }
    props();
  }
  function bubble_event($$props, event2) {
    var _a2;
    var events = (
      /** @type {Record<string, Function[] | Function>} */
      (_a2 = $$props.$$events) == null ? void 0 : _a2[event2.type]
    );
    var callbacks = is_array(events) ? events.slice() : events == null ? [] : [events];
    for (var fn of callbacks) {
      fn.call(this, event2);
    }
  }
  function subscribe_to_store(store, run2, invalidate) {
    if (store == null) {
      run2(void 0);
      if (invalidate) invalidate(void 0);
      return noop;
    }
    const unsub = untrack(
      () => store.subscribe(
        run2,
        // @ts-expect-error
        invalidate
      )
    );
    return unsub.unsubscribe ? () => unsub.unsubscribe() : unsub;
  }
  const subscriber_queue = [];
  function readable(value, start) {
    return {
      subscribe: writable(value, start).subscribe
    };
  }
  function writable(value, start = noop) {
    let stop = null;
    const subscribers = /* @__PURE__ */ new Set();
    function set2(new_value) {
      if (safe_not_equal(value, new_value)) {
        value = new_value;
        if (stop) {
          const run_queue = !subscriber_queue.length;
          for (const subscriber of subscribers) {
            subscriber[1]();
            subscriber_queue.push(subscriber, value);
          }
          if (run_queue) {
            for (let i = 0; i < subscriber_queue.length; i += 2) {
              subscriber_queue[i][0](subscriber_queue[i + 1]);
            }
            subscriber_queue.length = 0;
          }
        }
      }
    }
    function update(fn) {
      set2(fn(
        /** @type {T} */
        value
      ));
    }
    function subscribe(run2, invalidate = noop) {
      const subscriber = [run2, invalidate];
      subscribers.add(subscriber);
      if (subscribers.size === 1) {
        stop = start(set2, update) || noop;
      }
      run2(
        /** @type {T} */
        value
      );
      return () => {
        subscribers.delete(subscriber);
        if (subscribers.size === 0 && stop) {
          stop();
          stop = null;
        }
      };
    }
    return { set: set2, update, subscribe };
  }
  function derived(stores, fn, initial_value) {
    const single = !Array.isArray(stores);
    const stores_array = single ? [stores] : stores;
    if (!stores_array.every(Boolean)) {
      throw new Error("derived() expects stores as input, got a falsy value");
    }
    const auto = fn.length < 2;
    return readable(initial_value, (set2, update) => {
      let started = false;
      const values = [];
      let pending = 0;
      let cleanup = noop;
      const sync = () => {
        if (pending) {
          return;
        }
        cleanup();
        const result = fn(single ? values[0] : values, set2, update);
        if (auto) {
          set2(result);
        } else {
          cleanup = typeof result === "function" ? result : noop;
        }
      };
      const unsubscribers = stores_array.map(
        (store, i) => subscribe_to_store(
          store,
          (value) => {
            values[i] = value;
            pending &= ~(1 << i);
            if (started) {
              sync();
            }
          },
          () => {
            pending |= 1 << i;
          }
        )
      );
      started = true;
      sync();
      return function stop() {
        run_all(unsubscribers);
        cleanup();
        started = false;
      };
    });
  }
  function get(store) {
    let value;
    subscribe_to_store(store, (_) => value = _)();
    return value;
  }
  let is_store_binding = false;
  let IS_UNMOUNTED = Symbol();
  function store_get(store, store_name, stores) {
    const entry = stores[store_name] ?? (stores[store_name] = {
      store: null,
      source: /* @__PURE__ */ mutable_source(void 0),
      unsubscribe: noop
    });
    if (entry.store !== store && !(IS_UNMOUNTED in stores)) {
      entry.unsubscribe();
      entry.store = store ?? null;
      if (store == null) {
        entry.source.v = void 0;
        entry.unsubscribe = noop;
      } else {
        var is_synchronous_callback = true;
        entry.unsubscribe = subscribe_to_store(store, (v) => {
          if (is_synchronous_callback) {
            entry.source.v = v;
          } else {
            set(entry.source, v);
          }
        });
        is_synchronous_callback = false;
      }
    }
    if (store && IS_UNMOUNTED in stores) {
      return get(store);
    }
    return get$1(entry.source);
  }
  function store_set(store, value) {
    store.set(value);
    return value;
  }
  function setup_stores() {
    const stores = {};
    function cleanup() {
      teardown(() => {
        for (var store_name in stores) {
          const ref = stores[store_name];
          ref.unsubscribe();
        }
        define_property(stores, IS_UNMOUNTED, {
          enumerable: false,
          value: true
        });
      });
    }
    return [stores, cleanup];
  }
  function store_mutate(store, expression, new_value) {
    store.set(new_value);
    return expression;
  }
  function mark_store_binding() {
    is_store_binding = true;
  }
  function capture_store_binding(fn) {
    var previous_is_store_binding = is_store_binding;
    try {
      is_store_binding = false;
      return [fn(), is_store_binding];
    } finally {
      is_store_binding = previous_is_store_binding;
    }
  }
  function prop(props, key2, flags2, fallback) {
    var _a2;
    var runes = !legacy_mode_flag || (flags2 & PROPS_IS_RUNES) !== 0;
    var bindable = (flags2 & PROPS_IS_BINDABLE) !== 0;
    var lazy = (flags2 & PROPS_IS_LAZY_INITIAL) !== 0;
    var fallback_value = (
      /** @type {V} */
      fallback
    );
    var fallback_dirty = true;
    var get_fallback = () => {
      if (fallback_dirty) {
        fallback_dirty = false;
        fallback_value = lazy ? untrack(
          /** @type {() => V} */
          fallback
        ) : (
          /** @type {V} */
          fallback
        );
      }
      return fallback_value;
    };
    var setter;
    if (bindable) {
      var is_entry_props = STATE_SYMBOL in props || LEGACY_PROPS in props;
      setter = ((_a2 = get_descriptor(props, key2)) == null ? void 0 : _a2.set) ?? (is_entry_props && key2 in props ? (v) => props[key2] = v : void 0);
    }
    var initial_value;
    var is_store_sub = false;
    if (bindable) {
      [initial_value, is_store_sub] = capture_store_binding(() => (
        /** @type {V} */
        props[key2]
      ));
    } else {
      initial_value = /** @type {V} */
      props[key2];
    }
    if (initial_value === void 0 && fallback !== void 0) {
      initial_value = get_fallback();
      if (setter) {
        if (runes) props_invalid_value();
        setter(initial_value);
      }
    }
    var getter;
    if (runes) {
      getter = () => {
        var value = (
          /** @type {V} */
          props[key2]
        );
        if (value === void 0) return get_fallback();
        fallback_dirty = true;
        return value;
      };
    } else {
      getter = () => {
        var value = (
          /** @type {V} */
          props[key2]
        );
        if (value !== void 0) {
          fallback_value = /** @type {V} */
          void 0;
        }
        return value === void 0 ? fallback_value : value;
      };
    }
    if (runes && (flags2 & PROPS_IS_UPDATED) === 0) {
      return getter;
    }
    if (setter) {
      var legacy_parent = props.$$legacy;
      return (
        /** @type {() => V} */
        (function(value, mutation) {
          if (arguments.length > 0) {
            if (!runes || !mutation || legacy_parent || is_store_sub) {
              setter(mutation ? getter() : value);
            }
            return value;
          }
          return getter();
        })
      );
    }
    var overridden = false;
    var d = ((flags2 & PROPS_IS_IMMUTABLE) !== 0 ? derived$1 : derived_safe_equal)(() => {
      overridden = false;
      return getter();
    });
    if (bindable) get$1(d);
    var parent_effect = (
      /** @type {Effect} */
      active_effect
    );
    return (
      /** @type {() => V} */
      (function(value, mutation) {
        if (arguments.length > 0) {
          const new_value = mutation ? get$1(d) : runes && bindable ? proxy(value) : value;
          set(d, new_value);
          overridden = true;
          if (fallback_value !== void 0) {
            fallback_value = new_value;
          }
          return value;
        }
        if (is_destroying_effect && overridden || (parent_effect.f & DESTROYED) !== 0) {
          return d.v;
        }
        return get$1(d);
      })
    );
  }
  function onMount(fn) {
    if (component_context === null) {
      lifecycle_outside_component();
    }
    if (legacy_mode_flag && component_context.l !== null) {
      init_update_callbacks(component_context).m.push(fn);
    } else {
      user_effect(() => {
        const cleanup = untrack(fn);
        if (typeof cleanup === "function") return (
          /** @type {() => void} */
          cleanup
        );
      });
    }
  }
  function create_custom_event(type, detail, { bubbles = false, cancelable = false } = {}) {
    return new CustomEvent(type, { detail, bubbles, cancelable });
  }
  function createEventDispatcher() {
    const active_component_context = component_context;
    if (active_component_context === null) {
      lifecycle_outside_component();
    }
    return (type, detail, options) => {
      var _a2;
      const events = (
        /** @type {Record<string, Function | Function[]>} */
        (_a2 = active_component_context.s.$$events) == null ? void 0 : _a2[
          /** @type {string} */
          type
        ]
      );
      if (events) {
        const callbacks = is_array(events) ? events.slice() : [events];
        const event2 = create_custom_event(
          /** @type {string} */
          type,
          detail,
          options
        );
        for (const fn of callbacks) {
          fn.call(active_component_context.x, event2);
        }
        return !event2.defaultPrevented;
      }
      return true;
    };
  }
  function init_update_callbacks(context) {
    var l = (
      /** @type {ComponentContextLegacy} */
      context.l
    );
    return l.u ?? (l.u = { a: [], b: [], m: [] });
  }
  const PUBLIC_VERSION = "5";
  if (typeof window !== "undefined") {
    ((_a = window.__svelte ?? (window.__svelte = {})).v ?? (_a.v = /* @__PURE__ */ new Set())).add(PUBLIC_VERSION);
  }
  enable_legacy_mode_flag();
  var ThemeType = /* @__PURE__ */ ((ThemeType2) => {
    ThemeType2[ThemeType2["Dark"] = 2] = "Dark";
    ThemeType2[ThemeType2["Light"] = 3] = "Light";
    return ThemeType2;
  })(ThemeType || {});
  var CSSThemeClass = /* @__PURE__ */ ((CSSThemeClass2) => {
    CSSThemeClass2["Dark"] = "dark";
    CSSThemeClass2["Light"] = "light";
    return CSSThemeClass2;
  })(CSSThemeClass || {});
  const darkUITheme = writable(true);
  const UIThemeCSSClass = writable(
    "dark"
    /* Dark */
  );
  class SimpleWritable {
    constructor() {
      __publicField(this, "store", writable());
      this.store.set(this.init());
    }
    set(value) {
      this.store.set(value);
    }
    subscribe(run2) {
      return this.store.subscribe(run2);
    }
    update(updater) {
      this.store.update(updater);
    }
    storeData() {
      return get(this.store);
    }
  }
  class FileMetricsData {
    constructor() {
      __publicField(this, "name", "");
      __publicField(this, "type", "");
      __publicField(this, "language", "");
      __publicField(this, "diskSize", 0);
      __publicField(this, "computedSize", 0);
      __publicField(this, "changeCount", 0);
      __publicField(this, "undoCount", 0);
    }
  }
  let FileMetrics$1 = class FileMetrics extends SimpleWritable {
    init() {
      return new FileMetricsData();
    }
  };
  var ErrorComponentType = /* @__PURE__ */ ((ErrorComponentType2) => {
    ErrorComponentType2[ErrorComponentType2["SYMBOL"] = 0] = "SYMBOL";
    ErrorComponentType2[ErrorComponentType2["STRING"] = 1] = "STRING";
    return ErrorComponentType2;
  })(ErrorComponentType || {});
  class ErrorStore {
    constructor(errCompType) {
      __publicField(this, "_subscribers", []);
      __publicField(this, "_values");
      this._values = {
        errMessage: "",
        errType: errCompType
      };
    }
    /**
     * Svelte Store Contract required subscribe function.
     *
     * @param fn Callback function with typeof ErrorValues::errMessage parameter
     * @returns Unsubscribe function as required by Svelte Store Contract
     */
    subscribe(fn) {
      fn("");
      this._subscribers.push(fn);
      return () => {
        this._subscribers.splice(this._subscribers.indexOf(fn), 1);
      };
    }
    /**
     * Svelte Store Contract required set function.
     *
     * Iterates over object's list of subscribers, invoking the subscriber's
     * function with `msg` as the argument.
     */
    set(msg) {
      this._subscribers.forEach((fn) => {
        fn(msg);
      });
    }
    update(fn) {
      this.set(fn());
    }
    /**
     * Function for getting the appropriate innerHTML content according to the
     * object's ErrorComponentType.
     * @returns `string`: _values.errMessage for STRING | String.fromCharCode(9888)
     * for SYMBOL
     */
    innerHTML() {
      return this._values.errType === 1 ? this._values.errMessage : String.fromCharCode(9888);
    }
  }
  var EditByteModes = /* @__PURE__ */ ((EditByteModes2) => {
    EditByteModes2["Single"] = "single";
    EditByteModes2["Multiple"] = "multiple";
    return EditByteModes2;
  })(EditByteModes || {});
  const RADIX_OPTIONS = {
    Hexadecimal: 16,
    Decimal: 10,
    Octal: 8,
    Binary: 2
  };
  const ENCODING_GROUPS = [
    {
      group: "Binary",
      encodings: [
        { name: "Hexadecimal", value: "hex" },
        { name: "Binary", value: "binary" }
      ]
    },
    {
      group: "Single-byte",
      encodings: [
        { name: "ASCII (7-bit)", value: "ascii" },
        { name: "Latin-1 (8-bit)", value: "latin1" }
      ]
    },
    {
      group: "Multi-byte",
      encodings: [
        { name: "UTF-8", value: "utf-8" },
        { name: "UTF-16LE", value: "utf-16le" }
      ]
    }
  ];
  var EditActionRestrictions = /* @__PURE__ */ ((EditActionRestrictions2) => {
    EditActionRestrictions2[EditActionRestrictions2["None"] = 0] = "None";
    EditActionRestrictions2[EditActionRestrictions2["OverwriteOnly"] = 1] = "OverwriteOnly";
    return EditActionRestrictions2;
  })(EditActionRestrictions || {});
  const EDIT_ACTIONS = [
    {
      name: "Delete, Insert, and Overwrite",
      value: 0
      /* None */
    },
    {
      name: "Overwrite Only",
      value: 1
      /* OverwriteOnly */
    }
  ];
  const ENDIANNESS_OPTIONS = [
    { name: "Big", value: "be" },
    { name: "Little", value: "le" }
  ];
  const ADDRESS_RADIX_OPTIONS = [
    { name: "Hexadecimal", value: 16 },
    { name: "Decimal", value: 10 },
    { name: "Octal", value: 8 }
  ];
  const UNPRINTABLE_CHAR_STAND_IN = String.fromCharCode(9617);
  const VIEWPORT_CAPACITY_MAX = 16 * 64;
  const VIEWPORT_SCROLL_INCREMENT = VIEWPORT_CAPACITY_MAX / 2;
  const BYTES_PER_ROW_MAX_LINE_NUM = {
    16: Math.floor(VIEWPORT_SCROLL_INCREMENT / 16),
    8: Math.floor(VIEWPORT_SCROLL_INCREMENT / 8),
    24: Math.floor(VIEWPORT_SCROLL_INCREMENT / 24)
  };
  const DATA_PROFILE_MAX_LENGTH = 1e7;
  const ByteDivWidths = {
    16: "20px",
    10: "24px",
    8: "24px",
    2: "64px"
  };
  function radixBytePad(radix) {
    switch (radix) {
      case 2:
        return 8;
      case 8:
        return 3;
      case 10:
        return 3;
      case 16:
        return 2;
    }
    return 0;
  }
  function radixToString(radix) {
    switch (radix) {
      case 2:
        return "bin";
      case 8:
        return "oct";
      case 10:
        return "dec";
      case 16:
        return "hex";
    }
  }
  function byteDivWidthFromRadix(radix) {
    return ByteDivWidths[radix];
  }
  function regexEditDataTest(text2, dataType) {
    const binary_regex = /^[0-1]*$/;
    const decimal_regex = /^[0-9]*$/;
    const octal_regex = /^[0-7]*$/;
    const hex_regex = /^[0-9a-fA-F]*$/;
    switch (dataType) {
      case "binary":
      case 2:
        return binary_regex.test(text2);
      case 8:
        return octal_regex.test(text2);
      case 10:
        return decimal_regex.test(text2);
      case "hex":
      case 16:
        return hex_regex.test(text2);
      default:
        return isEncodedTextEditable(text2, dataType);
    }
  }
  function validateEncodingStr(text2, encoding, editMode2) {
    const validRegex = regexEditDataTest(text2, encoding);
    if (!validRegex) return { valid: false, errMsg: `Invalid input` };
    const validLen = validateStrByteLen(text2, encoding, editMode2);
    if (!validLen) return { valid: false, errMsg: `Invalid edit length` };
    return { valid: true, errMsg: "" };
  }
  function validateStrByteLen(text2, dataType, editMode2) {
    switch (dataType) {
      case "binary":
      case 2:
        return editMode2 === EditByteModes.Single ? text2.length === radixBytePad(2) : text2.length % radixBytePad(2) == 0;
      case 8:
        return editMode2 === EditByteModes.Single ? text2.length === radixBytePad(8) : text2.length % radixBytePad(8) == 0;
      case 10:
        return editMode2 === EditByteModes.Single ? text2.length === radixBytePad(10) : text2.length % radixBytePad(10) == 0;
      case "hex":
      case 16:
        return editMode2 === EditByteModes.Single ? text2.length === radixBytePad(16) : text2.length % radixBytePad(16) == 0;
      default:
        return editMode2 === EditByteModes.Single ? text2.length === 1 : true;
    }
  }
  function isEncodedTextEditable(text2, encoding) {
    switch (encoding) {
      case "latin1":
        for (let i = 0; i < text2.length; i++) {
          if (text2.charCodeAt(i) > 255) {
            return false;
          }
        }
        break;
      case "ascii":
        for (let i = 0; i < text2.length; i++) {
          if (text2.charCodeAt(i) > 127) {
            return false;
          }
        }
        break;
      case "utf8":
      case "utf16le":
        for (let i = 0; i < text2.length; i++) {
          if (text2.charCodeAt(i) > 65535) {
            return false;
          }
        }
        break;
    }
    return true;
  }
  function byte_count_divisible_offset(offset, bytesPerRow2, addLineNum = 0) {
    return Math.floor(offset / bytesPerRow2) * bytesPerRow2 + bytesPerRow2 * addLineNum;
  }
  function viewport_offset_to_line_num(offset, vpStartOffset, bytesPerRow2) {
    return Math.max(0, Math.floor((offset - vpStartOffset) / bytesPerRow2));
  }
  function line_num_to_file_offset(lineNum, viewportStartOffset, bytesPerRow2) {
    const offsetInViewport = lineNum * bytesPerRow2;
    const offsetInFile = viewportStartOffset + offsetInViewport;
    return Math.max(0, offsetInFile);
  }
  var BinaryBytePrefixes = /* @__PURE__ */ ((BinaryBytePrefixes2) => {
    BinaryBytePrefixes2[BinaryBytePrefixes2["B"] = 0] = "B";
    BinaryBytePrefixes2[BinaryBytePrefixes2["KB"] = 1] = "KB";
    BinaryBytePrefixes2[BinaryBytePrefixes2["MB"] = 2] = "MB";
    BinaryBytePrefixes2[BinaryBytePrefixes2["GB"] = 3] = "GB";
    BinaryBytePrefixes2[BinaryBytePrefixes2["TB"] = 4] = "TB";
    return BinaryBytePrefixes2;
  })(BinaryBytePrefixes || {});
  function humanReadableByteLength(byteLength) {
    let ret = byteLength.toLocaleString("en");
    let byteStrLen = ret.length;
    if (byteStrLen <= 3) ret += BinaryBytePrefixes[0];
    else {
      const octets = ret.split(",");
      ret = octets[0] + "." + octets[1].substring(0, 1) + BinaryBytePrefixes[octets.length - 1];
    }
    return ret;
  }
  const CLIENT_WIDTH_COLLAPSE_THRESHOLD = 1500;
  function shouldCollapseContent() {
    return document.body.clientWidth <= CLIENT_WIDTH_COLLAPSE_THRESHOLD;
  }
  const BYTE_ACTION_DIV_OFFSET = 24;
  const null_byte = () => {
    return {
      offset: -1,
      text: "",
      value: -1
    };
  };
  const byte_value_string = (value, radix) => {
    if (value > 255)
      throw `Value {${value}} is larger than an unsigned int (255).`;
    let str = value.toString(radix);
    let validLen = radixBytePad(radix);
    return str.length < validLen ? str.padStart(validLen, "0") : str;
  };
  const RADIX_REGEX_MATCH_STR = {
    16: /[0-9a-fA-F]{2}/g,
    10: /[0-9]{3}/g,
    8: /[0-8]{3}/g,
    2: /[0-1]{8}/g
  };
  class ViewportData_t {
    constructor() {
      __publicField(this, "data", new Uint8Array(0));
      __publicField(this, "fileOffset", -1);
      __publicField(this, "length", -1);
      __publicField(this, "bytesLeft", -1);
      __publicField(this, "capacity", this.data.length);
    }
  }
  class ViewportDataStore_t extends SimpleWritable {
    constructor() {
      super(...arguments);
      __publicField(this, "_offsetMax", -1);
    }
    init() {
      return new ViewportData_t();
    }
    get offsetMax() {
      return this._offsetMax;
    }
    set(value) {
      this.store.set(value);
      this._offsetMax = value.fileOffset + value.bytesLeft + value.length;
    }
    lowerFetchBoundary() {
      return this.storeData().fileOffset;
    }
    upperFetchBoundary(bytesPerRow2) {
      const store = this.storeData();
      const displayByteCount = get(dataDislayLineAmount) * bytesPerRow2;
      const boundary2 = store.length >= displayByteCount ? store.fileOffset + store.length - displayByteCount : store.length;
      return boundary2;
    }
    lineTopMax(bytesPerRow2) {
      const vpMaxOffset = Math.max(
        0,
        this.storeData().length - get(dataDislayLineAmount) * bytesPerRow2
      );
      const vpLineTopMax = viewport_offset_to_line_num(
        vpMaxOffset + this.storeData().fileOffset,
        this.storeData().fileOffset,
        bytesPerRow2
      );
      return vpLineTopMax + 1;
    }
    physical_byte_values(radix, bytesPerRow2) {
      const byteValues = this.physical_display(radix, bytesPerRow2).match(
        RADIX_REGEX_MATCH_STR[radix]
      ) || [];
      return byteValues.map((byteStr, index2) => {
        return {
          text: byteStr,
          offset: index2,
          value: parseInt(byteStr, radix)
        };
      });
    }
    subarray(from, to) {
      return this.storeData().data.subarray(from, to);
    }
    slice(from, to) {
      return this.storeData().data.slice(from, to);
    }
    physical_display(radix, bytesPerRow2) {
      let result = "";
      let arr = this.storeData().data;
      if (arr.byteLength > 0) {
        const pad = radixBytePad(radix);
        let i = 0;
        while (true) {
          for (let col = 0; i < arr.byteLength && col < bytesPerRow2; ++col) {
            result += arr[i++].toString(radix).padStart(pad, "0") + " ";
          }
          result = result.slice(0, result.length - 1);
          if (i === arr.byteLength) {
            break;
          }
          result += "\n";
        }
      }
      return result;
    }
  }
  function latin1Undefined$1(charCode) {
    return charCode < 32 || charCode > 126 && charCode < 160;
  }
  class NullIndication {
    equals(categoryArg) {
      return this.selector() === categoryArg.selector();
    }
    selector() {
      return "none";
    }
  }
  class ByteIndication {
    constructor(selector) {
      __publicField(this, "_selector");
      this._selector = selector.toLowerCase();
    }
    equals(categoryArg) {
      return this.selector() === categoryArg.selector();
    }
    selector() {
      return this._selector;
    }
  }
  const NoIndication = new NullIndication();
  class ByteCategory {
    constructor(_name, _bitLength) {
      __publicField(this, "_indicators", [NoIndication]);
      this._name = _name;
      this._bitLength = _bitLength;
      if (_bitLength > 8)
        throw new Error("Byte category indications cannot exceed 8 bits.");
    }
    addIndication(selectorName) {
      this._indicators.push(new ByteIndication(selectorName));
      return this;
    }
    bitLength() {
      return this._bitLength;
    }
    name() {
      return this._name;
    }
    indicators() {
      return this._indicators;
    }
    at(index2) {
      return index2 >= this._indicators.length || index2 < 0 ? this._indicators[0] : this._indicators[index2];
    }
    indexOf(selectorName) {
      const target = selectorName.toLowerCase();
      let ret = -1;
      this._indicators.forEach((categoryObj, i) => {
        if (categoryObj.selector() === target) ret = i;
      });
      if (ret < 0)
        throw new Error(`Indication category "${selectorName}" not found.`);
      else return ret;
    }
    contains(selectorName) {
      for (let i = 0; i < this._indicators.length; i++)
        if (this._indicators[i].selector() == selectorName.toLowerCase())
          return true;
      return false;
    }
  }
  const CategoryOne = new ByteCategory("one", 2);
  CategoryOne.addIndication("selected");
  const CategoryTwo = new ByteCategory("two", 2);
  CategoryTwo.addIndication("searchresult").addIndication("replacement");
  const DebuggerCategory = new ByteCategory("debugger", 2);
  DebuggerCategory.addIndication("bytePos1b");
  class ByteIndicationCategories {
    constructor() {
      __publicField(this, "_categories", {});
      __publicField(this, "_bitsUtilized", 0);
    }
    categoryList() {
      let ret = [];
      for (let key2 in this._categories) ret.push(this._categories[key2]);
      return ret;
    }
    addIndicationCategory(category) {
      if (this._bitsUtilized + category.bitLength() > 8)
        throw new Error("Category addition would exceed bit limit");
      this._categories[category.name()] = category;
      this._bitsUtilized += category.bitLength();
      return this;
    }
    category(name) {
      return this._categories[name];
    }
    categoryOfIndication(indicationName) {
      for (const category in this._categories)
        if (this._categories[category].contains(indicationName))
          return this._categories[category];
      throw new Error(
        `No ByteCategory found with ByteIndication named ${indicationName}`
      );
    }
    categoryValueByIndication(category, indicationName) {
      return category.indexOf(indicationName) << this.categoryBitPos(category);
    }
    clearIndication(data2, indicationName) {
      const category = this.categoryOfIndication(indicationName);
      data2.forEach((byte, i, data22) => {
        const categoryValueOfByte = byte & this.categoryMask(category);
        if (categoryValueOfByte === this.categoryValueByIndication(category, indicationName))
          data22[i] &= this.categoryMask(category) ^ 255;
      });
    }
    clearAndSetIf(data2, indication, predicate) {
      const category = this.categoryOfIndication(indication);
      if (!category) {
        console.error(`No ByteCategory contains the indication: ${indication}`);
        return;
      }
      data2.forEach((byte, i, data22) => {
        data22[i] &= this.categoryMask(category) ^ 255;
        if (predicate(byte, i))
          data22[i] |= this.categoryValueByIndication(category, indication);
      });
    }
    categoryCSSSelector(category, byteIndicationValue) {
      const maskedByteValue = byteIndicationValue & this.categoryMask(category);
      const indicationIndex = maskedByteValue >> this.categoryBitPos(category);
      const indication = category.indicators()[indicationIndex];
      return indication != void 0 ? indication.selector() : category.indexOf("none");
    }
    categoryMask(category) {
      const categoryBitPos = this.categoryBitPos(category);
      const categoryBitLength = category.bitLength();
      return Math.pow(2, categoryBitLength) - 1 << categoryBitPos;
    }
    indexOf(category) {
      let i = 0;
      for (let _category in this._categories) {
        if (category.name() === this._categories[_category].name()) {
          return i;
        }
        i++;
      }
      return -1;
    }
    categoryBitPos(category) {
      return this.indexOf(category) * category.bitLength();
    }
  }
  const ViewportByteCategories = new ByteIndicationCategories();
  ViewportByteCategories.addIndicationCategory(CategoryOne).addIndicationCategory(CategoryTwo).addIndicationCategory(DebuggerCategory);
  class ViewportByteIndications extends SimpleWritable {
    init() {
      return new Uint8Array(VIEWPORT_CAPACITY_MAX).fill(0);
    }
    clearIndication(indicationName) {
      this.store.update((indications) => {
        ViewportByteCategories.clearIndication(indications, indicationName);
        return indications;
      });
    }
    updateSearchIndications(searchQuery2, viewportFileOffset) {
      if (searchQuery2.searchResults.length > 0) {
        const resultsIterable = searchQuery2.iterableDataFromOffset(viewportFileOffset);
        const { data: data2 } = resultsIterable;
        const start = data2[0];
        const byteLength = searchQuery2.byteLength;
        this.store.update((indications) => {
          ViewportByteCategories.clearAndSetIf(
            indications,
            "searchresult",
            (_, i) => {
              const adjustIndex = i + viewportFileOffset;
              return adjustIndex >= start && adjustIndex < start + byteLength;
            }
          );
          searchResultsUpdated.set(true);
          return indications;
        });
      }
    }
    updateReplaceIndications(replaceData, viewportFileOffset) {
      const resultsIterable = replaceData.iterableDataFromOffset(viewportFileOffset);
      if (resultsIterable.data.length > 0) {
        const { offset, byteLength } = resultsIterable.data[0];
        this.store.update((indications) => {
          ViewportByteCategories.clearAndSetIf(
            indications,
            "replacement",
            (_, i) => {
              const adjustIndex = i + viewportFileOffset;
              return adjustIndex >= offset && adjustIndex < offset + byteLength;
            }
          );
          return indications;
        });
      }
    }
    updateSelectionIndications(selectionData) {
      const category1 = ViewportByteCategories.category("one");
      const start = selectionData.startOffset;
      const editedEnd = selectionData.endOffset + 1;
      const originalEnd = selectionData.originalEndOffset;
      if (!selectionData.makingSelection() && !selectionData.active) {
        this.store.update((indications) => {
          ViewportByteCategories.clearIndication(indications, "selected");
          return indications;
        });
      }
      if (selectionData.active || selectionData.makingSelection()) {
        const offsetPartitions = [
          generateSelectionCategoryParition(0, start, (byte) => {
            byte[0] &= ~category1.indexOf("selected");
          }),
          generateSelectionCategoryParition(start, editedEnd, (byte) => {
            byte[0] |= category1.indexOf("selected");
          }),
          generateSelectionCategoryParition(
            Math.max(originalEnd, editedEnd),
            VIEWPORT_CAPACITY_MAX,
            (byte) => {
              byte[0] &= ~category1.indexOf("selected");
            }
          )
        ];
        this.store.update((indications) => {
          for (const partition of offsetPartitions) {
            for (let i = partition.start; i < partition.end; i++)
              partition.assignByte(indications.subarray(i, i + 1));
          }
          return indications;
        });
      }
    }
    updateDebuggerPosIndication(bytePos, fileOffset) {
      this.store.update((indications) => {
        ViewportByteCategories.clearAndSetIf(indications, "bytePos1b", (_, i) => {
          return i + fileOffset === bytePos;
        });
        return indications;
      });
    }
  }
  const viewportByteIndicators = new ViewportByteIndications();
  function generateSelectionCategoryParition(start, end, assignmentFn) {
    return {
      start,
      end,
      assignByte: assignmentFn
    };
  }
  function categoryCSSSelectors(byteIndicationValue) {
    let ret = "";
    ViewportByteCategories.categoryList().forEach((category) => {
      const categorysCSSSelector = ViewportByteCategories.categoryCSSSelector(
        category,
        byteIndicationValue
      );
      if (categorysCSSSelector != "none") ret += categorysCSSSelector + " ";
    });
    return ret;
  }
  var OffsetSearchType = /* @__PURE__ */ ((OffsetSearchType2) => {
    OffsetSearchType2[OffsetSearchType2["ABSOLUTE"] = 0] = "ABSOLUTE";
    OffsetSearchType2[OffsetSearchType2["RELATIVE"] = 1] = "RELATIVE";
    return OffsetSearchType2;
  })(OffsetSearchType || {});
  class SearchData {
    constructor() {
      __publicField(this, "input", "");
      __publicField(this, "processing", false);
      __publicField(this, "initiaited", false);
      __publicField(this, "searchIndex", 0);
      __publicField(this, "searchResults", []);
      __publicField(this, "overflow", false);
      __publicField(this, "byteLength", 0);
    }
    iterableDataFromOffset(offset) {
      const start = this.searchResults.findIndex((x) => x >= offset);
      const end = this.searchResults.findIndex(
        (x) => x >= offset + VIEWPORT_CAPACITY_MAX
      );
      let ret = {
        start,
        end,
        data: this.searchResults.slice(
          start,
          end >= 0 ? end : this.searchResults.length
        )
      };
      return ret;
    }
  }
  class SearchQuery extends SimpleWritable {
    init() {
      return new SearchData();
    }
    clear() {
      this.update((query) => {
        query.processing = false;
        query.initiaited = false;
        query.searchIndex = 0;
        query.searchResults = [];
        viewportByteIndicators.clearIndication("searchresult");
        return query;
      });
    }
    updateSearchResults(msgData) {
      this.update((query) => {
        query.initiaited = true;
        query.searchResults = msgData.searchResults;
        query.byteLength = msgData.searchDataBytesLength;
        query.overflow = msgData.overflow;
        return query;
      });
    }
  }
  class ReplaceData {
    constructor() {
      __publicField(this, "input", "");
      __publicField(this, "processing", false);
      __publicField(this, "initiaited", false);
      __publicField(this, "results", []);
    }
    iterableDataFromOffset(offset) {
      const start = this.results.findIndex((x) => x.offset >= offset);
      const end = this.results.findIndex(
        (x) => x.offset >= offset + VIEWPORT_CAPACITY_MAX
      );
      const withinRange = start >= 0;
      const data2 = withinRange ? this.results.slice(start, end >= 0 ? end : this.results.length) : [];
      let ret = {
        start,
        end,
        data: data2
      };
      return ret;
    }
  }
  class ReplaceQuery extends SimpleWritable {
    init() {
      return new ReplaceData();
    }
    addResult(result) {
      this.update((data2) => {
        data2.initiaited = true;
        data2.results.push(result);
        return data2;
      });
    }
    pop() {
      this.update((data2) => {
        data2.results.pop();
        return data2;
      });
    }
    clear() {
      this.update((data2) => {
        data2.processing = false;
        data2.results = [];
        data2.initiaited = false;
        return data2;
      });
    }
  }
  function clear_queryable_results() {
    searchQuery.clear();
    replaceQuery.clear();
  }
  class SelectionData_t {
    constructor() {
      __publicField(this, "startOffset", -1);
      __publicField(this, "endOffset", -1);
      __publicField(this, "originalEndOffset", -1);
      __publicField(this, "active", false);
    }
    isValid() {
      return this.startOffset >= 0 && this.originalEndOffset >= this.startOffset && this.endOffset >= 0 && this.originalEndOffset >= 0;
    }
    editedLength() {
      return this.endOffset - this.startOffset;
    }
    originalLength() {
      return this.originalEndOffset - this.startOffset;
    }
    selectionIndexIsAnEdit(index2) {
      const editOffsetLength = this.originalLength() - this.editedLength();
      const editStartOffset = this.originalEndOffset - editOffsetLength;
      return index2 <= this.originalEndOffset ? index2 >= editStartOffset : index2 <= editStartOffset;
    }
    isEmpty() {
      return this.editedLength() + 1 == 0;
    }
    editStartOffset() {
      return this.originalEndOffset - (this.originalLength() - this.editedLength());
    }
    editLengthDelta() {
      return this.endOffset - this.originalEndOffset + 1;
    }
    makingSelection() {
      return this.startOffset >= 0 && this.originalEndOffset === -1;
    }
  }
  class SelectionData extends SimpleWritable {
    init() {
      return new SelectionData_t();
    }
    reset() {
      this.store.set(new SelectionData_t());
    }
  }
  writable(ThemeType.Dark);
  const addressRadix = writable(16);
  const applyErrMsg = writable("");
  const dataViewEndianness = writable("le");
  const displayRadix = writable(16);
  const editedDataSegment = writable(new Uint8Array(0));
  const editorEncoding = writable("latin1");
  const editorSelection = writable("");
  const focusedViewportId = writable("");
  const seekOffsetInput = writable("");
  const dataFeedLineTop = writable(0);
  const dataFeedAwaitRefresh = writable(false);
  const rerenderActionElements = writable(false);
  const viewport = new ViewportDataStore_t();
  const bytesPerRow = writable(16);
  const selectedByte = writable({
    text: "",
    offset: -1,
    value: -1
  });
  const fileMetrics = new FileMetrics$1();
  const searchQuery = new SearchQuery();
  const replaceQuery = new ReplaceQuery();
  const searchErr = new ErrorStore(ErrorComponentType.SYMBOL);
  const replaceErr = new ErrorStore(ErrorComponentType.SYMBOL);
  const seekErr = new ErrorStore(ErrorComponentType.SYMBOL);
  const editorActionsAllowed = writable(EditActionRestrictions.None);
  const tooltipsEnabled = writable(false);
  const currentHelpSectionDisplayed = writable("");
  const currentHelpSectionEvent = writable({});
  const selectionDataStore = new SelectionData();
  const dataDislayLineAmount = writable(20);
  const visableViewports = writable("all");
  const searchResultsUpdated = writable(false);
  const dfdlBytePos = writable(-1);
  const regularSizedFile = derived(fileMetrics, ($fileMetrics) => {
    return $fileMetrics.computedSize >= 2;
  });
  const dataFeedLineTopOffset = derived(
    [dataFeedLineTop, viewport, bytesPerRow],
    ([$dataFeedLineTop, $viewport, $bytesPerRow]) => {
      const offset = line_num_to_file_offset(
        $dataFeedLineTop,
        $viewport.fileOffset,
        $bytesPerRow
      );
      return Math.min(Math.max(0, offset), viewport.offsetMax);
    }
  );
  const searchable = derived(
    [searchQuery, editorEncoding],
    ([$searchQuery, $editorEncoding]) => {
      if ($searchQuery.input.length === 0 || $searchQuery.processing) {
        searchErr.update(() => {
          return "";
        });
        return false;
      }
      const ret = validateEncodingStr($searchQuery.input, $editorEncoding, "full");
      searchErr.update(() => {
        return ret.errMsg;
      });
      return ret.valid;
    }
  );
  const replaceable = derived(
    [replaceQuery, editorEncoding, searchable, selectionDataStore],
    ([$replaceData, $editorEncoding, $searchable, $selectionData]) => {
      if ($replaceData.input.length < 0 || !$searchable || $replaceData.processing) {
        replaceErr.update(() => {
          return "";
        });
        return false;
      }
      if ($selectionData.active) {
        replaceErr.update(() => {
          return "Can't replace while selection active";
        });
        return false;
      }
      const ret = validateEncodingStr($replaceData.input, $editorEncoding);
      replaceErr.update(() => {
        return ret.errMsg;
      });
      return ret.valid;
    }
  );
  const editMode = derived(
    [selectionDataStore, regularSizedFile],
    ([$selectionData, $regularSizedFile]) => {
      if (!$regularSizedFile) return EditByteModes.Multiple;
      return $selectionData.originalEndOffset - $selectionData.startOffset === 0 ? EditByteModes.Single : EditByteModes.Multiple;
    },
    EditByteModes.Single
  );
  const selectionSize = derived(
    [selectionDataStore, editorSelection],
    ([$selectionData, $editorSelection]) => {
      return $editorSelection !== "" ? $selectionData.endOffset - $selectionData.startOffset + 1 : 0;
    }
  );
  const seekOffsetSearchType = derived(
    seekOffsetInput,
    ($seekOffsetInput) => {
      const sign = $seekOffsetInput.substring(0, 1);
      return sign === "+" || sign === "-" ? OffsetSearchType.RELATIVE : OffsetSearchType.ABSOLUTE;
    },
    OffsetSearchType.ABSOLUTE
  );
  const seekOffset = derived(
    [seekOffsetInput, seekOffsetSearchType, dataFeedLineTopOffset, addressRadix],
    ([
      $seekOffsetInput,
      $seekOffsetSearchType,
      $dataFeedLineTopOffset,
      $addressRadix
    ]) => {
      if ($seekOffsetSearchType === OffsetSearchType.ABSOLUTE) {
        return $seekOffsetInput.length > 0 ? Math.max(0, parseInt($seekOffsetInput, $addressRadix)) : 0;
      } else
        return Math.max(0, $dataFeedLineTopOffset) + parseInt($seekOffsetInput, $addressRadix);
    },
    0
  );
  const editByte = derived(
    [displayRadix, focusedViewportId, viewport, selectionDataStore],
    ([$displayRadix, $focusedViewportId, $viewport, $selectionData]) => {
      if ($viewport.data[$selectionData.startOffset] !== void 0) {
        return $focusedViewportId === "logical" ? String.fromCharCode($viewport.data[$selectionData.startOffset]) : $viewport.data[$selectionData.startOffset].toString($displayRadix).padStart(radixBytePad($displayRadix), "0");
      }
      return "";
    }
  );
  const editedByteIsOriginalByte = derived(
    [editorSelection, selectedByte, focusedViewportId],
    ([$editorSelection, $selectedByte, $focusedViewportId]) => {
      return $focusedViewportId === "logical" ? $editorSelection === $selectedByte.text : $editorSelection.toLowerCase() === $selectedByte.text.toLowerCase();
    }
  );
  derived(bytesPerRow, (bytesPerRow2) => {
    return bytesPerRow2 * BYTE_ACTION_DIV_OFFSET;
  });
  const allowCaseInsensitiveSearch = derived(
    editorEncoding,
    ($editorEncoding) => {
      return $editorEncoding === "ascii" || $editorEncoding === "latin1";
    }
  );
  const saveable = derived([fileMetrics], ([$fileMetrics]) => {
    return $fileMetrics.changeCount > 0;
  });
  const requestable = derived(
    [editorSelection, focusedViewportId, editorEncoding, editMode, displayRadix],
    ([
      $editorSelection,
      $focusedViewportId,
      $editorEncoding,
      $editMode,
      $displayRadix
    ]) => {
      const ret = validRequestableData(
        $editorSelection,
        $focusedViewportId,
        $editorEncoding,
        $editMode,
        $displayRadix
      );
      applyErrMsg.update(() => {
        return ret.errMsg;
      });
      return ret.valid;
    }
  );
  const originalDataSegment = derived(
    [viewport, selectionDataStore, regularSizedFile],
    ([$viewport, $selectionData, $regularSizedFile]) => {
      if (!$viewport.data) return [];
      if (!$regularSizedFile) return $viewport.data;
      return $viewport.data.slice(
        $selectionData.startOffset,
        $selectionData.originalEndOffset + 1
      );
    }
  );
  const applicable = derived(
    [
      requestable,
      viewport,
      editorSelection,
      displayRadix,
      editedDataSegment,
      selectionDataStore,
      selectionSize,
      editMode,
      editedByteIsOriginalByte,
      editorActionsAllowed,
      regularSizedFile
    ],
    ([
      $requestable,
      $viewport,
      $editorSelection,
      $displayRadix,
      $selectedFileData,
      $selectionData,
      $selectionSize,
      $editMode,
      $editedByteIsOriginalByte,
      $editorActionsAllowed,
      $regularSizedFile
    ]) => {
      if (!$regularSizedFile) {
        if ($viewport.length < 0) return false;
        return $viewport.data.length != $editorSelection.length / radixBytePad($displayRadix) && $editorActionsAllowed === EditActionRestrictions.OverwriteOnly ? false : $requestable;
      }
      if (!$requestable || $editedByteIsOriginalByte && $editMode === EditByteModes.Single)
        return false;
      const originalLength = $selectionData.originalEndOffset - $selectionData.startOffset;
      const editedLength = $selectionData.endOffset - $selectionData.startOffset;
      const editLengthHasDelta = originalLength !== editedLength;
      if ($editorActionsAllowed === EditActionRestrictions.OverwriteOnly && editLengthHasDelta)
        return false;
      if (editLengthHasDelta) return true;
      for (let i = 0; i < $selectionSize; i++) {
        if ($viewport.data[i + $selectionData.startOffset] !== $selectedFileData[i])
          return true;
      }
      return false;
    }
  );
  const seekable = derived(
    [seekOffset, seekOffsetInput, seekOffsetSearchType, viewport, addressRadix],
    ([
      $seekOffset,
      $seekOffsetInput,
      $seekOffsetSearchType,
      $viewport,
      $addressRadix
    ]) => {
      $seekOffsetInput = $seekOffsetSearchType === OffsetSearchType.RELATIVE ? $seekOffsetInput.substring(1) : $seekOffsetInput;
      if ($seekOffsetInput.length <= 0) return { valid: false, seekErrMsg: "" };
      if ($seekOffset > viewport.offsetMax)
        return { valid: false, seekErrMsg: "Exceeds filesize" };
      if ($seekOffset < 0)
        return { valid: false, seekErrMsg: "Target offset < 0" };
      if (!regexEditDataTest($seekOffsetInput, $addressRadix))
        return { valid: false, seekErrMsg: "Invalid characters" };
      return { valid: true, seekErrMsg: "" };
    }
  );
  function typedArrayToBuffer(array, startOffset, length) {
    startOffset += array.byteOffset;
    return array.buffer.slice(
      startOffset,
      startOffset + Math.min(array.byteLength, length)
    );
  }
  const dataView = derived(
    [selectionDataStore, viewport],
    ([$selectionData, $viewport]) => {
      return new DataView(
        typedArrayToBuffer($viewport.data, $selectionData.startOffset, 8)
      );
    }
  );
  function validRequestableData(data2, viewport2, encoding, editMode2, radix) {
    switch (editMode2) {
      case EditByteModes.Single:
        if (data2.length === 0) return { valid: false, errMsg: "" };
        return viewport2 === "physical" ? validateEncodingStr(data2, radix, editMode2) : validateEncodingStr(data2, "latin1", editMode2);
      case EditByteModes.Multiple:
        return validateEncodingStr(data2, encoding);
      default:
        return { valid: false, errMsg: "illegal edit mode" };
    }
  }
  const dvOffset = derived(
    [selectionDataStore, addressRadix, viewport],
    ([$selectionData, $addressRadix, $viewport]) => {
      return $selectionData.active ? ($viewport.fileOffset + $selectionData.startOffset).toString(
        $addressRadix
      ) : "";
    }
  );
  const dvLatin1 = derived(
    [selectionDataStore, dataView],
    ([$selectionData, $dataView]) => {
      return $selectionData.active && $dataView.byteLength >= 1 ? String.fromCharCode($dataView.getUint8(0)) : "";
    }
  );
  const dvInt8 = derived(
    [selectionDataStore, dataView, displayRadix],
    ([$selectionData, $dataView, $displayRadix]) => {
      const value = $selectionData.active && $dataView.byteLength >= 1 ? $dataView.getInt8(0).toString($displayRadix) : "";
      return value && $displayRadix === 2 ? value.padStart(8, "0") : value;
    }
  );
  const dvUint8 = derived(
    [selectionDataStore, dataView, displayRadix],
    ([$selectionData, $dataView, $displayRadix]) => {
      const value = $selectionData.active && $dataView.byteLength >= 1 ? $dataView.getUint8(0).toString($displayRadix) : "";
      return value && $displayRadix === 2 ? value.padStart(8, "0") : value;
    }
  );
  const dvInt16 = derived(
    [selectionDataStore, dataView, displayRadix, dataViewEndianness],
    ([$selectionData, $dataView, $displayRadix, $dataViewEndianness]) => {
      const value = $selectionData.active && $dataView.byteLength >= 2 ? $dataView.getInt16(0, $dataViewEndianness === "le").toString($displayRadix) : "";
      return value && $displayRadix === 2 ? value.padStart(16, "0") : value;
    }
  );
  const dvUint16 = derived(
    [selectionDataStore, dataView, displayRadix, dataViewEndianness],
    ([$selectionData, $dataView, $displayRadix, $dataViewEndianness]) => {
      const value = $selectionData.active && $dataView.byteLength >= 2 ? $dataView.getUint16(0, $dataViewEndianness === "le").toString($displayRadix) : "";
      return value && $displayRadix === 2 ? value.padStart(16, "0") : value;
    }
  );
  const dvInt32 = derived(
    [selectionDataStore, dataView, displayRadix, dataViewEndianness],
    ([$selectionData, $dataView, $displayRadix, $dataViewEndianness]) => {
      const value = $selectionData.active && $dataView.byteLength >= 4 ? $dataView.getInt32(0, $dataViewEndianness === "le").toString($displayRadix) : "";
      return value && $displayRadix === 2 ? value.padStart(32, "0") : value;
    }
  );
  const dvUint32 = derived(
    [selectionDataStore, dataView, displayRadix, dataViewEndianness],
    ([$selectionData, $dataView, $displayRadix, $dataViewEndianness]) => {
      const value = $selectionData.active && $dataView.byteLength >= 4 ? $dataView.getUint32(0, $dataViewEndianness === "le").toString($displayRadix) : "";
      return value && $displayRadix === 2 ? value.padStart(32, "0") : value;
    }
  );
  const dvInt64 = derived(
    [selectionDataStore, dataView, displayRadix, dataViewEndianness],
    ([$selectionData, $dataView, $displayRadix, $dataViewEndianness]) => {
      const value = $selectionData.active && $dataView.byteLength >= 8 ? $dataView.getBigInt64(0, $dataViewEndianness === "le").toString($displayRadix) : "";
      return value && $displayRadix === 2 ? value.padStart(64, "0") : value;
    }
  );
  const dvUint64 = derived(
    [selectionDataStore, dataView, displayRadix, dataViewEndianness],
    ([$selectionData, $dataView, $displayRadix, $dataViewEndianness]) => {
      const value = $selectionData.active && $dataView.byteLength >= 8 ? $dataView.getBigUint64(0, $dataViewEndianness === "le").toString($displayRadix) : "";
      return value && $displayRadix === 2 ? value.padStart(64, "0") : value;
    }
  );
  function latin1Undefined(charCode) {
    return charCode < 32 || charCode > 126 && charCode < 160;
  }
  function logicalDisplay(bytes, bytesPerRow2) {
    let result = "";
    for (let i = 0, col = 0; i < bytes.length; ++i) {
      if (latin1Undefined(bytes[i])) {
        result += UNPRINTABLE_CHAR_STAND_IN;
      } else {
        const char = String.fromCharCode(bytes[i]);
        result += char === "\n" ? " " : char;
      }
      if (++col === bytesPerRow2) {
        col = 0;
        if (i < bytes.length) {
          result += "\n";
        }
      } else {
        result += " ";
      }
    }
    return result;
  }
  derived(
    [viewport, bytesPerRow],
    ([$viewport, $bytesPerRow]) => {
      return logicalDisplay($viewport.data, $bytesPerRow);
    }
  );
  var MessageCommand = /* @__PURE__ */ ((MessageCommand2) => {
    MessageCommand2[MessageCommand2["clearChanges"] = 0] = "clearChanges";
    MessageCommand2[MessageCommand2["applyChanges"] = 1] = "applyChanges";
    MessageCommand2[MessageCommand2["editorOnChange"] = 2] = "editorOnChange";
    MessageCommand2[MessageCommand2["fileInfo"] = 3] = "fileInfo";
    MessageCommand2[MessageCommand2["heartbeat"] = 4] = "heartbeat";
    MessageCommand2[MessageCommand2["profile"] = 5] = "profile";
    MessageCommand2[MessageCommand2["redoChange"] = 6] = "redoChange";
    MessageCommand2[MessageCommand2["replaceResults"] = 7] = "replaceResults";
    MessageCommand2[MessageCommand2["requestEditedData"] = 8] = "requestEditedData";
    MessageCommand2[MessageCommand2["save"] = 9] = "save";
    MessageCommand2[MessageCommand2["saveAs"] = 10] = "saveAs";
    MessageCommand2[MessageCommand2["saveSegment"] = 11] = "saveSegment";
    MessageCommand2[MessageCommand2["scrollViewport"] = 12] = "scrollViewport";
    MessageCommand2[MessageCommand2["search"] = 13] = "search";
    MessageCommand2[MessageCommand2["replace"] = 14] = "replace";
    MessageCommand2[MessageCommand2["searchResults"] = 15] = "searchResults";
    MessageCommand2[MessageCommand2["setUITheme"] = 16] = "setUITheme";
    MessageCommand2[MessageCommand2["showMessage"] = 17] = "showMessage";
    MessageCommand2[MessageCommand2["undoChange"] = 18] = "undoChange";
    MessageCommand2[MessageCommand2["updateLogicalDisplay"] = 19] = "updateLogicalDisplay";
    MessageCommand2[MessageCommand2["viewportRefresh"] = 20] = "viewportRefresh";
    return MessageCommand2;
  })(MessageCommand || {});
  class VSCodeAPIWrapper {
    constructor() {
      __publicField(this, "vsCodeApi");
      if (typeof acquireVsCodeApi === "function") {
        this.vsCodeApi = acquireVsCodeApi();
      }
    }
    /**
     * Post a message (i.e. send arbitrary data) to the owner of the webview.
     *
     * @remarks When running webview code inside a web browser, postMessage will instead
     * log the given message to the console.
     *
     * @param message Arbitrary data (must be JSON serializable) to send to the extension context.
     */
    postMessage(message) {
      if (this.vsCodeApi) {
        this.vsCodeApi.postMessage(message);
      } else {
        console.log(message);
      }
    }
    /**
     * Get the persistent state stored for this webview.
     *
     * @remarks When running webview source code inside a web browser, getState will retrieve state
     * from local storage (https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage).
     *
     * @return The current state or `undefined` if no state has been set.
     */
    getState() {
      if (this.vsCodeApi) {
        return this.vsCodeApi.getState();
      } else {
        const state2 = localStorage.getItem("vscodeState");
        return state2 ? JSON.parse(state2) : void 0;
      }
    }
    /**
     * Set the persistent state stored for this webview.
     *
     * @remarks When running webview source code inside a web browser, setState will set the given
     * state using local storage (https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage).
     *
     * @param newState New persisted state. This must be a JSON serializable object. Can be retrieved
     * using {@link getState}.
     *
     * @return The new state.
     */
    setState(newState) {
      if (this.vsCodeApi) {
        return this.vsCodeApi.setState(newState);
      } else {
        localStorage.setItem("vscodeState", JSON.stringify(newState));
        return newState;
      }
    }
  }
  const vscode = new VSCodeAPIWrapper();
  var root_2$b = /* @__PURE__ */ from_html(`<div> </div>`);
  var root_1$d = /* @__PURE__ */ from_html(`<span><!></span> <!>`, 1);
  var root_3$b = /* @__PURE__ */ from_html(`<span><!></span>`);
  function Tooltip($$anchor, $$props) {
    push($$props, false);
    const $tooltipsEnabled = () => store_get(tooltipsEnabled, "$tooltipsEnabled", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const NULL = () => {
    };
    const TOOLTIP_MIN_WIDTH = 50;
    const TOOLTIP_MIN_HEIGHT = 25;
    let description = prop($$props, "description", 8);
    let alwaysEnabled = prop($$props, "alwaysEnabled", 8, false);
    let tooltipSizeExtended = prop($$props, "tooltipSizeExtended", 8, false);
    let showTooltip = /* @__PURE__ */ mutable_source(false);
    let left = /* @__PURE__ */ mutable_source(0), top = /* @__PURE__ */ mutable_source(0);
    function renderTooltip(event2) {
      const targetElement = event2.target;
      switch (event2.type) {
        case "mouseenter":
          const clientWidth = document.body.clientWidth;
          const targetOffsetLeft = targetElement.offsetLeft;
          const clientHeight = window.innerHeight;
          const targetOffsetTop = targetElement.offsetTop;
          const targetHeight = targetElement.offsetHeight;
          set(left, clientWidth - targetOffsetLeft + TOOLTIP_MIN_WIDTH > targetOffsetLeft ? targetOffsetLeft : targetOffsetLeft - TOOLTIP_MIN_WIDTH);
          set(top, targetOffsetTop + targetHeight + TOOLTIP_MIN_HEIGHT < clientHeight - TOOLTIP_MIN_HEIGHT ? targetOffsetTop + targetHeight + 5 : targetOffsetTop - TOOLTIP_MIN_HEIGHT);
          set(showTooltip, true);
          break;
        case "mouseleave":
          set(showTooltip, false);
          break;
      }
    }
    init();
    var fragment = comment();
    var node = first_child(fragment);
    {
      var consequent_1 = ($$anchor2) => {
        var fragment_1 = root_1$d();
        var span = first_child(fragment_1);
        var node_1 = child(span);
        slot(node_1, $$props, "default", {});
        var node_2 = sibling(span, 2);
        {
          var consequent = ($$anchor3) => {
            var div = root_2$b();
            let styles;
            var text2 = child(div);
            template_effect(
              ($0) => {
                set_class(div, 1, `tooltip ${tooltipSizeExtended() ? "extended" : "fit-content"}`, "svelte-1j0gpuf");
                styles = set_style(div, "", styles, $0);
                set_text(text2, description());
              },
              [
                () => ({
                  left: (get$1(left), untrack(() => get$1(left).toString() + "px")),
                  top: (get$1(top), untrack(() => get$1(top).toString() + "px"))
                })
              ]
            );
            append($$anchor3, div);
          };
          if_block(node_2, ($$render) => {
            if (get$1(showTooltip)) $$render(consequent);
          });
        }
        event("mouseenter", span, function(...$$args) {
          var _a2;
          (_a2 = get$1(showTooltip) ? NULL : renderTooltip) == null ? void 0 : _a2.apply(this, $$args);
        });
        event("mouseleave", span, function(...$$args) {
          var _a2;
          (_a2 = get$1(showTooltip) ? renderTooltip : NULL) == null ? void 0 : _a2.apply(this, $$args);
        });
        event("focusout", span, () => {
          set(showTooltip, false);
        });
        append($$anchor2, fragment_1);
      };
      var alternate = ($$anchor2) => {
        var span_1 = root_3$b();
        var node_3 = child(span_1);
        slot(node_3, $$props, "default", {});
        append($$anchor2, span_1);
      };
      if_block(node, ($$render) => {
        if ($tooltipsEnabled(), deep_read_state(alwaysEnabled()), deep_read_state(description()), untrack(() => ($tooltipsEnabled() || alwaysEnabled()) && description().length > 0)) $$render(consequent_1);
        else $$render(alternate, false);
      });
    }
    append($$anchor, fragment);
    pop();
    $$cleanup();
  }
  var root$h = /* @__PURE__ */ from_html(`<div class="display svelte-1dewm9z"><!></div>`);
  function Error$1($$anchor, $$props) {
    push($$props, false);
    const $err = () => store_get(err(), "$err", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    let err = prop($$props, "err", 8);
    let display = prop($$props, "display", 8);
    init();
    var div = root$h();
    var node = child(div);
    {
      var consequent = ($$anchor2) => {
        Tooltip($$anchor2, {
          alwaysEnabled: true,
          get description() {
            return $err();
          },
          children: ($$anchor3, $$slotProps) => {
            var fragment_1 = comment();
            var node_1 = first_child(fragment_1);
            html(node_1, () => (deep_read_state(err()), untrack(() => err().innerHTML())));
            append($$anchor3, fragment_1);
          },
          $$slots: { default: true }
        });
      };
      if_block(node, ($$render) => {
        if (display()) $$render(consequent);
      });
    }
    append($$anchor, div);
    pop();
    $$cleanup();
  }
  var root$g = /* @__PURE__ */ from_html(`<div class="flex-container svelte-pjpb6a"><!></div>`);
  function FlexContainer($$anchor, $$props) {
    var div = root$g();
    var node = child(div);
    slot(node, $$props, "default", {});
    append($$anchor, div);
  }
  var root_4$a = /* @__PURE__ */ from_html(`<!> <!>`, 1);
  var root_2$a = /* @__PURE__ */ from_html(`<button><svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper></button>`);
  var root_7$9 = /* @__PURE__ */ from_html(`<!> <!> <!>`, 1);
  var root_5$8 = /* @__PURE__ */ from_html(`<button><svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper></button>`);
  function Button($$anchor, $$props) {
    push($$props, false);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    let fn = prop($$props, "fn", 8);
    let disabledBy = prop($$props, "disabledBy", 8, false);
    let width = prop($$props, "width", 8, "");
    let fixedWidth = prop($$props, "fixedWidth", 8, "");
    onMount(() => {
      set(collapseContent, shouldCollapseContent());
    });
    let description = prop($$props, "description", 8, "");
    let tooltipAlwaysEnabled = prop($$props, "tooltipAlwaysEnabled", 8, false);
    let collapseContentFn;
    let collapseContent = /* @__PURE__ */ mutable_source(false);
    window.addEventListener("resize", () => {
      clearTimeout(collapseContentFn);
      collapseContentFn = setTimeout(
        () => {
          set(collapseContent, shouldCollapseContent());
        },
        100
      );
    });
    legacy_pre_effect(() => get$1(collapseContent), () => {
      store_set(tooltipsEnabled, get$1(collapseContent));
    });
    legacy_pre_effect_reset();
    init();
    Tooltip($$anchor, {
      get alwaysEnabled() {
        return tooltipAlwaysEnabled();
      },
      get description() {
        return description();
      },
      children: ($$anchor2, $$slotProps) => {
        var fragment_1 = comment();
        var node = first_child(fragment_1);
        {
          var consequent = ($$anchor3) => {
            var button = root_2$a();
            let styles;
            var node_1 = child(button);
            {
              css_props(node_1, () => ({
                "--dir": "row",
                "--align-items": "center",
                "--justify-content": "center"
              }));
              FlexContainer(node_1.lastChild, {
                children: ($$anchor4, $$slotProps2) => {
                  var fragment_2 = root_4$a();
                  var node_2 = first_child(fragment_2);
                  slot(node_2, $$props, "left", {});
                  var node_3 = sibling(node_2, 2);
                  slot(node_3, $$props, "right", {});
                  append($$anchor4, fragment_2);
                },
                $$slots: { default: true }
              });
            }
            template_effect(() => {
              set_class(button, 1, $UIThemeCSSClass() + " collapsed", "svelte-6i35zw");
              button.disabled = disabledBy();
              styles = set_style(button, "", styles, { width: fixedWidth() });
            });
            event("click", button, function(...$$args) {
              var _a2;
              (_a2 = !disabledBy() ? fn() : () => {
              }) == null ? void 0 : _a2.apply(this, $$args);
            });
            append($$anchor3, button);
          };
          var alternate = ($$anchor3) => {
            var button_1 = root_5$8();
            let styles_1;
            var node_4 = child(button_1);
            {
              css_props(node_4, () => ({
                "--dir": "row",
                "--align-items": "center",
                "--justify-content": "center"
              }));
              FlexContainer(node_4.lastChild, {
                children: ($$anchor4, $$slotProps2) => {
                  var fragment_3 = root_7$9();
                  var node_5 = first_child(fragment_3);
                  slot(node_5, $$props, "left", {});
                  var node_6 = sibling(node_5, 2);
                  slot(node_6, $$props, "default", {});
                  var node_7 = sibling(node_6, 2);
                  slot(node_7, $$props, "right", {});
                  append($$anchor4, fragment_3);
                },
                $$slots: { default: true }
              });
            }
            template_effect(() => {
              set_class(button_1, 1, clsx($UIThemeCSSClass()), "svelte-6i35zw");
              button_1.disabled = disabledBy();
              styles_1 = set_style(button_1, "", styles_1, {
                width: (deep_read_state(fixedWidth()), deep_read_state(width()), untrack(() => fixedWidth().length > 0 ? fixedWidth() : width()))
              });
            });
            event("click", button_1, function(...$$args) {
              var _a2;
              (_a2 = !disabledBy() ? fn() : () => {
              }) == null ? void 0 : _a2.apply(this, $$args);
            });
            append($$anchor3, button_1);
          };
          if_block(node, ($$render) => {
            if (get$1(collapseContent)) $$render(consequent);
            else $$render(alternate, false);
          });
        }
        append($$anchor2, fragment_1);
      },
      $$slots: { default: true }
    });
    pop();
    $$cleanup();
  }
  var root_1$c = /* @__PURE__ */ from_html(`<span><span><input/> <!></span></span>`);
  function Input($$anchor, $$props) {
    push($$props, false);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const eventDispatcher = createEventDispatcher();
    let allowDefaultInput = prop($$props, "allowDefaultInput", 8, "false");
    let autofocus = prop($$props, "autofocus", 8, "false");
    let id = prop($$props, "id", 8, "");
    let maxlength = prop($$props, "maxlength", 8, 100);
    let placeholder = prop($$props, "placeholder", 8, "");
    let inputType = prop(
      $$props,
      "inputType",
      8,
      "search"
      // default to search for the clear button
    );
    let value = prop($$props, "value", 12, "");
    let width = prop($$props, "width", 8, "100%");
    let errMsg = prop($$props, "errMsg", 8, "");
    let themeClass = /* @__PURE__ */ mutable_source($UIThemeCSSClass());
    let containerClass = /* @__PURE__ */ mutable_source();
    let inlineClass = /* @__PURE__ */ mutable_source();
    let inputClass = /* @__PURE__ */ mutable_source();
    let initialValue;
    let allowDefaultInputBool;
    let thisElement = /* @__PURE__ */ mutable_source();
    function selectorCSSThemeClass(selectors, cssStoreTrigger) {
      return selectors + " " + cssStoreTrigger;
    }
    const setType = (node, _type) => {
      node.type = _type;
      return {
        update(_type2) {
          node.type = _type2;
        }
      };
    };
    function handleKeyPress(event2) {
      if (errMsg().length > 0) return;
      if (event2.key === "Enter" && (allowDefaultInputBool || get$1(thisElement).value !== "" && get$1(thisElement).value !== initialValue)) {
        eventDispatcher("inputEnter", { id: id(), initialValue, value: get$1(thisElement).value });
      }
    }
    function handleFocus(event2) {
      switch (event2.type) {
        case "focusin":
          eventDispatcher("inputFocusIn", { id: id(), initialValue, value: get$1(thisElement).value });
          break;
        case "focusout":
          eventDispatcher("inputFocusOut", { id: id(), initialValue, value: get$1(thisElement).value });
          break;
      }
    }
    onMount(() => {
      initialValue = value();
      allowDefaultInputBool = allowDefaultInput().toLowerCase() === "true";
      if (autofocus().toLowerCase() === "true") {
        get$1(thisElement).focus();
      }
    });
    legacy_pre_effect(() => (get$1(themeClass), $UIThemeCSSClass()), () => {
      set(themeClass, $UIThemeCSSClass());
      set(containerClass, selectorCSSThemeClass("input-actions", get$1(themeClass)));
      set(inlineClass, selectorCSSThemeClass("inline-container", get$1(themeClass)));
      set(inputClass, selectorCSSThemeClass("actionable", get$1(themeClass)));
    });
    legacy_pre_effect_reset();
    init();
    var fragment = comment();
    var node_1 = first_child(fragment);
    {
      var consequent = ($$anchor2) => {
        var span = root_1$c();
        var span_1 = child(span);
        var input = child(span_1);
        action(input, ($$node, $$action_arg) => setType == null ? void 0 : setType($$node, $$action_arg), inputType);
        bind_this(input, ($$value) => set(thisElement, $$value), () => get$1(thisElement));
        effect(() => bind_value(input, value));
        effect(() => event("blur", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("change", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("click", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("contextmenu", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("focus", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("input", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("keydown", input, handleKeyPress));
        effect(() => event("keypress", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("keyup", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("mouseenter", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("mouseleave", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("mouseover", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        effect(() => event("paste", input, function($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }));
        var node_2 = sibling(input, 2);
        slot(node_2, $$props, "default", {});
        template_effect(() => {
          set_class(span, 1, clsx(get$1(containerClass)), "svelte-1slwe07");
          set_attribute(span, "id", id());
          set_style(span, `width: ${width() ?? ""};`);
          set_class(span_1, 1, clsx(get$1(inlineClass)), "svelte-1slwe07");
          set_class(input, 1, `${get$1(themeClass) ?? ""} ${inputType() ?? ""}`, "svelte-1slwe07");
          set_attribute(input, "placeholder", placeholder());
          set_attribute(input, "maxlength", maxlength());
        });
        event("focusin", span, handleFocus);
        event("focusout", span, handleFocus);
        append($$anchor2, span);
      };
      if_block(node_1, ($$render) => {
        if (inputType() === "text" || inputType() === "search") $$render(consequent);
      });
    }
    append($$anchor, fragment);
    pop();
    $$cleanup();
  }
  var root_3$a = /* @__PURE__ */ from_html(`<!> <!> <!>`, 1);
  var root_1$b = /* @__PURE__ */ from_html(`<button><svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper></button>`);
  function ToggleableButton($$anchor, $$props) {
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    let fn = prop($$props, "fn", 8);
    let disabledBy = prop($$props, "disabledBy", 8, false);
    let width = prop($$props, "width", 8, "");
    let active = prop($$props, "active", 8, false);
    let description = prop($$props, "description", 8);
    Tooltip($$anchor, {
      get description() {
        return description();
      },
      alwaysEnabled: true,
      children: ($$anchor2, $$slotProps) => {
        var button = root_1$b();
        let classes;
        let styles;
        var node = child(button);
        {
          css_props(node, () => ({
            "--dir": "row",
            "--align-items": "center",
            "--justify-content": "center"
          }));
          FlexContainer(node.lastChild, {
            children: ($$anchor3, $$slotProps2) => {
              var fragment_1 = root_3$a();
              var node_1 = first_child(fragment_1);
              slot(node_1, $$props, "left", {});
              var node_2 = sibling(node_1, 2);
              slot(node_2, $$props, "default", {});
              var node_3 = sibling(node_2, 2);
              slot(node_3, $$props, "right", {});
              append($$anchor3, fragment_1);
            },
            $$slots: { default: true }
          });
        }
        template_effect(() => {
          classes = set_class(button, 1, clsx($UIThemeCSSClass()), "svelte-1n03fa8", classes, { active: active() });
          button.disabled = disabledBy();
          styles = set_style(button, "", styles, { width: width() });
        });
        event("click", button, function(...$$args) {
          var _a2;
          (_a2 = !disabledBy() ? fn() : () => {
          }) == null ? void 0 : _a2.apply(this, $$args);
        });
        append($$anchor2, button);
      },
      $$slots: { default: true }
    });
    $$cleanup();
  }
  var root_5$7 = /* @__PURE__ */ from_html(`<span class="btn-icon material-symbols-outlined">my_location</span>`);
  var root_6$9 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Seek</span>`);
  var root_7$8 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">start</span>`);
  var root_2$9 = /* @__PURE__ */ from_html(`<!> <!> <!>`, 1);
  var root_10$4 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  var root_13$5 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Search</span>`);
  var root_14$5 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">search</span>`);
  var root_8$7 = /* @__PURE__ */ from_html(`<!> <!> <!>`, 1);
  var root_16$5 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Replace&hellip;</span>`);
  var root_17$5 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">find_replace</span>`);
  var root_15$5 = /* @__PURE__ */ from_html(`<!> <!> <!>`, 1);
  var root_20$2 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;First</span>`);
  var root_21$2 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">first_page</span>`);
  var root_22$2 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Prev</span>`);
  var root_23$2 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">navigate_before</span>`);
  var root_25$2 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Replace</span>`);
  var root_26$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">find_replace</span>`);
  var root_27$1 = /* @__PURE__ */ from_html(`<span slot="default">Next&nbsp;</span>`);
  var root_28$1 = /* @__PURE__ */ from_html(`<span slot="right" class="btn-icon material-symbols-outlined">navigate_next</span>`);
  var root_29$1 = /* @__PURE__ */ from_html(`<span slot="default">Last&nbsp;</span>`);
  var root_30$1 = /* @__PURE__ */ from_html(`<span slot="right" class="btn-icon material-symbols-outlined">last_page</span>`);
  var root_31$1 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Cancel</span>`);
  var root_32$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">search_off</span>`);
  var root_19$3 = /* @__PURE__ */ from_html(`<!> <!> <!> <!> <!> <!>`, 1);
  var root_18$4 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  var root_1$a = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <!>`, 1);
  var root$f = /* @__PURE__ */ from_html(`<fieldset class="search-replace svelte-9munig"><legend>Search</legend> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper></fieldset>`);
  function SearchReplace($$anchor, $$props) {
    push($$props, false);
    const $editorEncoding = () => store_get(editorEncoding, "$editorEncoding", $$stores);
    const $searchErr = () => store_get(searchErr, "$searchErr", $$stores);
    const $searchable = () => store_get(searchable, "$searchable", $$stores);
    const $replaceErr = () => store_get(replaceErr, "$replaceErr", $$stores);
    const $replaceable = () => store_get(replaceable, "$replaceable", $$stores);
    const $seekable = () => store_get(seekable, "$seekable", $$stores);
    const $searchQuery = () => store_get(searchQuery, "$searchQuery", $$stores);
    const $replaceQuery = () => store_get(replaceQuery, "$replaceQuery", $$stores);
    const $editorActionsAllowed = () => store_get(editorActionsAllowed, "$editorActionsAllowed", $$stores);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const $seekOffsetInput = () => store_get(seekOffsetInput, "$seekOffsetInput", $$stores);
    const $addressRadix = () => store_get(addressRadix, "$addressRadix", $$stores);
    const $seekOffsetSearchType = () => store_get(seekOffsetSearchType, "$seekOffsetSearchType", $$stores);
    const $seekOffset = () => store_get(seekOffset, "$seekOffset", $$stores);
    const $allowCaseInsensitiveSearch = () => store_get(allowCaseInsensitiveSearch, "$allowCaseInsensitiveSearch", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const eventDispatcher = createEventDispatcher();
    let searchErrDisplay = /* @__PURE__ */ mutable_source();
    let replaceErrDisplay = /* @__PURE__ */ mutable_source();
    let caseInsensitive = /* @__PURE__ */ mutable_source(false);
    let containerClass = /* @__PURE__ */ mutable_source();
    let inlineClass = /* @__PURE__ */ mutable_source();
    let inputClass = /* @__PURE__ */ mutable_source();
    let replaceStarted = false;
    let searchStarted = false;
    let showSearchOptions = /* @__PURE__ */ mutable_source(false);
    let showReplaceOptions = /* @__PURE__ */ mutable_source(false);
    let matchOffset = -1;
    let hasNext = /* @__PURE__ */ mutable_source(false);
    let hasPrev = /* @__PURE__ */ mutable_source(false);
    let direction = "Home";
    let preReplaceHasPrev = false;
    let justReplaced = false;
    let searchReplaceButtonWidth = "85pt";
    let searchNavButtonWidth = "55pt";
    function clearOnEncodingChange(encoding) {
      cancel();
    }
    function search(searchOffset, searchLength, isReverse) {
      store_mutate(searchQuery, untrack($searchQuery).processing = true, untrack($searchQuery));
      vscode.postMessage({
        command: MessageCommand.search,
        data: {
          searchData: $searchQuery().input,
          caseInsensitive: get$1(caseInsensitive),
          isReverse,
          encoding: $editorEncoding(),
          searchOffset,
          searchLength,
          limit: 1
        }
      });
    }
    function searchFirst() {
      direction = "Home";
      search(0, 0, false);
    }
    function searchLast() {
      direction = "End";
      search(0, 0, true);
    }
    function searchNext() {
      direction = "Forward";
      search(matchOffset + 1, 0, false);
    }
    function searchPrev() {
      direction = "Backward";
      search(0, matchOffset, true);
    }
    function searchStart() {
      if (searchable) {
        matchOffset = -1;
        replaceStarted = false;
        searchStarted = true;
        searchQuery.clear();
        searchFirst();
      }
    }
    function replaceStart() {
      if (replaceable && !get$1(replaceErrDisplay)) {
        matchOffset = -1;
        replaceStarted = true;
        searchStarted = false;
        searchFirst();
      }
    }
    function replace() {
      store_mutate(replaceQuery, untrack($replaceQuery).processing = true, untrack($replaceQuery));
      vscode.postMessage({
        command: MessageCommand.replace,
        data: {
          searchData: $searchQuery().input,
          caseInsensitive: get$1(caseInsensitive),
          isReverse: false,
          replaceData: $replaceQuery().input,
          encoding: $editorEncoding(),
          overwriteOnly: $editorActionsAllowed() === EditActionRestrictions.OverwriteOnly,
          searchOffset: matchOffset,
          searchLength: 0,
          limit: 1
        }
      });
      eventDispatcher("clearDataDisplays");
    }
    function handleInputEnter(event2) {
      switch (event2.detail.id) {
        case "search":
          searchStart();
          break;
        case "replace":
          replaceStart();
          break;
        case "seek":
          eventDispatcher("seek");
          break;
      }
    }
    function CSSThemeClass2(selectors) {
      return selectors + " " + $UIThemeCSSClass();
    }
    function scrollToMatch() {
      if (matchOffset >= 0) {
        store_set(seekOffsetInput, matchOffset.toString($addressRadix()));
        eventDispatcher("seek");
      }
    }
    function cancel() {
      set(showSearchOptions, false);
      set(showReplaceOptions, false);
      searchStarted = false;
      replaceStarted = false;
      matchOffset = -1;
      clear_queryable_results();
      eventDispatcher("clearDataDisplays");
    }
    window.addEventListener("message", (msg) => {
      switch (msg.data.command) {
        case // handle search results
        MessageCommand.searchResults:
          if (msg.data.data.searchResults.length > 0) {
            searchQuery.updateSearchResults(msg.data.data);
            switch (direction) {
              case "Home":
                set(hasNext, $searchQuery().overflow);
                set(hasPrev, false);
                break;
              case "End":
                set(hasNext, false);
                set(hasPrev, $searchQuery().overflow);
                break;
              case "Forward":
                set(hasNext, $searchQuery().overflow);
                set(hasPrev, justReplaced ? preReplaceHasPrev : true);
                justReplaced = false;
                break;
              case "Backward":
                set(hasNext, true);
                set(hasPrev, $searchQuery().overflow);
                break;
            }
            matchOffset = $searchQuery().searchResults[0];
            scrollToMatch();
            if (searchStarted) {
              set(showReplaceOptions, false);
              set(showSearchOptions, true);
            } else if (replaceStarted) {
              set(showReplaceOptions, true);
              set(showSearchOptions, false);
            }
          } else {
            matchOffset = -1;
            store_mutate(searchQuery, untrack($searchQuery).overflow = set(showSearchOptions, set(showReplaceOptions, false)), untrack($searchQuery));
            searchQuery.clear();
          }
          searchStarted = replaceStarted = false;
          store_mutate(searchQuery, untrack($searchQuery).processing = false, untrack($searchQuery));
          break;
        case // handle replace results
        MessageCommand.replaceResults:
          searchStarted = replaceStarted = false;
          if (msg.data.data.replacementsCount > 0) {
            matchOffset = msg.data.data.nextOffset - 1;
            replaceQuery.addResult({
              byteLength: msg.data.data.replaceDataBytesLength,
              offset: msg.data.data.nextOffset - msg.data.data.replaceDataBytesLength
            });
            preReplaceHasPrev = get$1(hasPrev);
            justReplaced = true;
            searchNext();
          } else {
            matchOffset = -1;
            set(showReplaceOptions, false);
          }
          store_mutate(replaceQuery, untrack($replaceQuery).processing = false, untrack($replaceQuery));
          break;
        case MessageCommand.clearChanges:
          cancel();
          break;
      }
    });
    legacy_pre_effect(() => {
    }, () => {
      set(containerClass, CSSThemeClass2("input-actions"));
      set(inlineClass, CSSThemeClass2("inline-container"));
      set(inputClass, CSSThemeClass2("actionable"));
    });
    legacy_pre_effect(() => $editorEncoding(), () => {
      clearOnEncodingChange($editorEncoding());
    });
    legacy_pre_effect(() => ($searchErr(), $searchable()), () => {
      set(searchErrDisplay, $searchErr().length > 0 && !$searchable());
    });
    legacy_pre_effect(() => ($replaceErr(), $replaceable()), () => {
      set(replaceErrDisplay, $replaceErr().length > 0 && !$replaceable());
    });
    legacy_pre_effect(() => $seekable(), () => {
      store_set(seekErr, $seekable().seekErrMsg);
    });
    legacy_pre_effect_reset();
    init();
    var fieldset = root$f();
    var node = sibling(child(fieldset), 2);
    {
      css_props(node, () => ({ "--dir": "column", "--align-items": "center" }));
      FlexContainer(node.lastChild, {
        children: ($$anchor2, $$slotProps) => {
          var fragment = root_1$a();
          var node_1 = first_child(fragment);
          {
            css_props(node_1, () => ({ "--dir": "row" }));
            FlexContainer(node_1.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_1 = root_2$9();
                var node_2 = first_child(fragment_1);
                Input(node_2, {
                  id: "seek",
                  get placeholder() {
                    return `Seek To Offset (base ${$addressRadix() ?? ""})`;
                  },
                  allowDefaultInput: "true",
                  get value() {
                    mark_store_binding();
                    return $seekOffsetInput();
                  },
                  set value($$value) {
                    store_set(seekOffsetInput, $$value);
                  },
                  $$events: {
                    inputEnter(...$$args) {
                      var _a2;
                      (_a2 = $seekable().valid ? handleInputEnter : () => {
                      }) == null ? void 0 : _a2.apply(this, $$args);
                    }
                  },
                  children: ($$anchor4, $$slotProps3) => {
                    var fragment_2 = comment();
                    var node_3 = first_child(fragment_2);
                    {
                      var consequent = ($$anchor5) => {
                        {
                          let $0 = /* @__PURE__ */ derived_safe_equal(() => ($seekOffset(), $addressRadix(), untrack(() => "Offset input is relative to current offset: " + $seekOffset().toString($addressRadix()))));
                          Tooltip($$anchor5, {
                            alwaysEnabled: true,
                            get description() {
                              return get$1($0);
                            },
                            children: ($$anchor6, $$slotProps4) => {
                              var span = root_5$7();
                              append($$anchor6, span);
                            },
                            $$slots: { default: true }
                          });
                        }
                      };
                      if_block(node_3, ($$render) => {
                        if ($seekOffsetSearchType(), deep_read_state(OffsetSearchType), untrack(() => $seekOffsetSearchType() === OffsetSearchType.RELATIVE)) $$render(consequent);
                      });
                    }
                    append($$anchor4, fragment_2);
                  },
                  $$slots: { default: true },
                  $$legacy: true
                });
                var node_4 = sibling(node_2, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => ($seekOffsetInput(), $seekable(), untrack(() => $seekOffsetInput().length > 0 && !$seekable().valid)));
                  Error$1(node_4, {
                    get err() {
                      return seekErr;
                    },
                    get display() {
                      return get$1($0);
                    }
                  });
                }
                var node_5 = sibling(node_4, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => ($seekable(), untrack(() => !$seekable().valid)));
                  Button(node_5, {
                    get disabledBy() {
                      return get$1($0);
                    },
                    fn: () => {
                      eventDispatcher("seek");
                    },
                    width: searchReplaceButtonWidth,
                    description: "Seek to offset",
                    children: ($$anchor4, $$slotProps3) => {
                      var span_1 = root_6$9();
                      append($$anchor4, span_1);
                    },
                    $$slots: {
                      default: true,
                      left: ($$anchor4, $$slotProps3) => {
                        var span_2 = root_7$8();
                        append($$anchor4, span_2);
                      }
                    }
                  });
                }
                append($$anchor3, fragment_1);
              },
              $$slots: { default: true }
            });
          }
          var node_6 = sibling(node_1, 2);
          {
            css_props(node_6, () => ({ "--dir": "row", "--align-items": "center" }));
            FlexContainer(node_6.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_4 = root_8$7();
                var node_7 = first_child(fragment_4);
                {
                  var consequent_1 = ($$anchor4) => {
                    Input($$anchor4, {
                      id: "search",
                      placeholder: "Search",
                      get value() {
                        return $searchQuery().input;
                      },
                      set value($$value) {
                        store_mutate(searchQuery, untrack($searchQuery).input = $$value, untrack($searchQuery));
                      },
                      $$events: { inputEnter: handleInputEnter },
                      children: ($$anchor5, $$slotProps3) => {
                        var fragment_6 = root_10$4();
                        var node_8 = first_child(fragment_6);
                        {
                          let $0 = /* @__PURE__ */ derived_safe_equal(() => get$1(caseInsensitive) ? "on" : "off");
                          css_props(node_8, () => ({ "--width": "24px" }));
                          ToggleableButton(node_8.lastChild, {
                            fn: () => {
                              set(caseInsensitive, !get$1(caseInsensitive));
                            },
                            get active() {
                              return get$1(caseInsensitive);
                            },
                            get description() {
                              return `Case insensitive search: ${get$1($0) ?? ""}`;
                            },
                            children: ($$anchor6, $$slotProps4) => {
                              var text$1 = text("Aa");
                              append($$anchor6, text$1);
                            },
                            $$slots: { default: true }
                          });
                        }
                        append($$anchor5, fragment_6);
                      },
                      $$slots: { default: true },
                      $$legacy: true
                    });
                  };
                  var alternate = ($$anchor4) => {
                    Input($$anchor4, {
                      id: "search",
                      placeholder: "Search",
                      get value() {
                        return $searchQuery().input;
                      },
                      set value($$value) {
                        store_mutate(searchQuery, untrack($searchQuery).input = $$value, untrack($searchQuery));
                      },
                      $$events: { inputEnter: handleInputEnter },
                      $$legacy: true
                    });
                  };
                  if_block(node_7, ($$render) => {
                    if ($allowCaseInsensitiveSearch()) $$render(consequent_1);
                    else $$render(alternate, false);
                  });
                }
                var node_9 = sibling(node_7, 2);
                Error$1(node_9, {
                  get err() {
                    return searchErr;
                  },
                  get display() {
                    return get$1(searchErrDisplay);
                  }
                });
                var node_10 = sibling(node_9, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => !$searchable());
                  Button(node_10, {
                    get disabledBy() {
                      return get$1($0);
                    },
                    fn: searchStart,
                    width: searchReplaceButtonWidth,
                    description: "Start search",
                    children: ($$anchor4, $$slotProps3) => {
                      var span_3 = root_13$5();
                      append($$anchor4, span_3);
                    },
                    $$slots: {
                      default: true,
                      left: ($$anchor4, $$slotProps3) => {
                        var span_4 = root_14$5();
                        append($$anchor4, span_4);
                      }
                    }
                  });
                }
                append($$anchor3, fragment_4);
              },
              $$slots: { default: true }
            });
          }
          var node_11 = sibling(node_6, 2);
          {
            css_props(node_11, () => ({ "--dir": "row", "--align-items": "center" }));
            FlexContainer(node_11.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_8 = root_15$5();
                var node_12 = first_child(fragment_8);
                Input(node_12, {
                  id: "replace",
                  placeholder: "Replace",
                  allowDefaultInput: "true",
                  get value() {
                    return $replaceQuery().input;
                  },
                  set value($$value) {
                    store_mutate(replaceQuery, untrack($replaceQuery).input = $$value, untrack($replaceQuery));
                  },
                  $$events: { inputEnter: handleInputEnter },
                  $$legacy: true
                });
                var node_13 = sibling(node_12, 2);
                Error$1(node_13, {
                  get err() {
                    return replaceErr;
                  },
                  get display() {
                    return get$1(replaceErrDisplay);
                  }
                });
                var node_14 = sibling(node_13, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => !$replaceable());
                  Button(node_14, {
                    get disabledBy() {
                      return get$1($0);
                    },
                    fn: replaceStart,
                    width: searchReplaceButtonWidth,
                    description: "Start replacement",
                    children: ($$anchor4, $$slotProps3) => {
                      var span_5 = root_16$5();
                      append($$anchor4, span_5);
                    },
                    $$slots: {
                      default: true,
                      left: ($$anchor4, $$slotProps3) => {
                        var span_6 = root_17$5();
                        append($$anchor4, span_6);
                      }
                    }
                  });
                }
                append($$anchor3, fragment_8);
              },
              $$slots: { default: true }
            });
          }
          var node_15 = sibling(node_11, 2);
          {
            var consequent_3 = ($$anchor3) => {
              var fragment_9 = root_18$4();
              var node_16 = first_child(fragment_9);
              {
                css_props(node_16, () => ({ "--dir": "row" }));
                FlexContainer(node_16.lastChild, {
                  children: ($$anchor4, $$slotProps2) => {
                    var fragment_10 = root_19$3();
                    var node_17 = first_child(fragment_10);
                    {
                      let $0 = /* @__PURE__ */ derived_safe_equal(() => !get$1(hasPrev) || !$searchable());
                      Button(node_17, {
                        width: searchNavButtonWidth,
                        fn: searchFirst,
                        get disabledBy() {
                          return get$1($0);
                        },
                        description: "Seek to the first match",
                        children: ($$anchor5, $$slotProps3) => {
                          var span_7 = root_20$2();
                          append($$anchor5, span_7);
                        },
                        $$slots: {
                          default: true,
                          left: ($$anchor5, $$slotProps3) => {
                            var span_8 = root_21$2();
                            append($$anchor5, span_8);
                          }
                        }
                      });
                    }
                    var node_18 = sibling(node_17, 2);
                    {
                      let $0 = /* @__PURE__ */ derived_safe_equal(() => !get$1(hasPrev) || !$searchable());
                      Button(node_18, {
                        width: searchNavButtonWidth,
                        fn: searchPrev,
                        get disabledBy() {
                          return get$1($0);
                        },
                        description: "Seek to the previous match",
                        children: ($$anchor5, $$slotProps3) => {
                          var span_9 = root_22$2();
                          append($$anchor5, span_9);
                        },
                        $$slots: {
                          default: true,
                          left: ($$anchor5, $$slotProps3) => {
                            var span_10 = root_23$2();
                            append($$anchor5, span_10);
                          }
                        }
                      });
                    }
                    var node_19 = sibling(node_18, 2);
                    {
                      var consequent_2 = ($$anchor5) => {
                        {
                          let $0 = /* @__PURE__ */ derived_safe_equal(() => !replaceable || get$1(replaceErrDisplay));
                          Button($$anchor5, {
                            fn: replace,
                            description: "Replace the current match",
                            get disabledBy() {
                              return get$1($0);
                            },
                            children: ($$anchor6, $$slotProps3) => {
                              var span_11 = root_25$2();
                              append($$anchor6, span_11);
                            },
                            $$slots: {
                              default: true,
                              left: ($$anchor6, $$slotProps3) => {
                                var span_12 = root_26$1();
                                append($$anchor6, span_12);
                              }
                            }
                          });
                        }
                      };
                      if_block(node_19, ($$render) => {
                        if (get$1(showReplaceOptions)) $$render(consequent_2);
                      });
                    }
                    var node_20 = sibling(node_19, 2);
                    {
                      let $0 = /* @__PURE__ */ derived_safe_equal(() => !get$1(hasNext) || !$searchable());
                      Button(node_20, {
                        width: searchNavButtonWidth,
                        fn: searchNext,
                        get disabledBy() {
                          return get$1($0);
                        },
                        description: "Seek to the next match",
                        children: ($$anchor5, $$slotProps3) => {
                          var span_13 = root_27$1();
                          append($$anchor5, span_13);
                        },
                        $$slots: {
                          default: true,
                          right: ($$anchor5, $$slotProps3) => {
                            var span_14 = root_28$1();
                            append($$anchor5, span_14);
                          }
                        }
                      });
                    }
                    var node_21 = sibling(node_20, 2);
                    {
                      let $0 = /* @__PURE__ */ derived_safe_equal(() => !get$1(hasNext) || !$searchable());
                      Button(node_21, {
                        width: searchNavButtonWidth,
                        fn: searchLast,
                        get disabledBy() {
                          return get$1($0);
                        },
                        description: "Seek to the last match",
                        children: ($$anchor5, $$slotProps3) => {
                          var span_15 = root_29$1();
                          append($$anchor5, span_15);
                        },
                        $$slots: {
                          default: true,
                          right: ($$anchor5, $$slotProps3) => {
                            var span_16 = root_30$1();
                            append($$anchor5, span_16);
                          }
                        }
                      });
                    }
                    var node_22 = sibling(node_21, 2);
                    {
                      let $0 = /* @__PURE__ */ derived_safe_equal(() => get$1(showReplaceOptions) ? "replace" : "search");
                      Button(node_22, {
                        width: searchNavButtonWidth,
                        fn: cancel,
                        get description() {
                          return `Cancel ${get$1($0) ?? ""}`;
                        },
                        children: ($$anchor5, $$slotProps3) => {
                          var span_17 = root_31$1();
                          append($$anchor5, span_17);
                        },
                        $$slots: {
                          default: true,
                          left: ($$anchor5, $$slotProps3) => {
                            var span_18 = root_32$1();
                            append($$anchor5, span_18);
                          }
                        }
                      });
                    }
                    append($$anchor4, fragment_10);
                  },
                  $$slots: { default: true }
                });
              }
              append($$anchor3, fragment_9);
            };
            if_block(node_15, ($$render) => {
              if (get$1(showSearchOptions) || get$1(showReplaceOptions)) $$render(consequent_3);
            });
          }
          append($$anchor2, fragment);
        },
        $$slots: { default: true }
      });
    }
    append($$anchor, fieldset);
    pop();
    $$cleanup();
  }
  var root_1$9 = /* @__PURE__ */ from_html(`<span class="setting-icon svelte-3njtac"><span class="viewport physical svelte-3njtac"></span> <span class="viewport logical svelte-3njtac"></span></span>`);
  var root_3$9 = /* @__PURE__ */ from_html(`<span class="setting-icon selection physical svelte-3njtac"><span class="viewport svelte-3njtac"></span> <span class="viewport svelte-3njtac"></span></span>`);
  var root_4$9 = /* @__PURE__ */ from_html(`<span class="setting-icon selection logical svelte-3njtac"><span class="viewport svelte-3njtac"></span> <span class="viewport svelte-3njtac"></span></span>`);
  var root_5$6 = /* @__PURE__ */ from_html(`<span class="setting-icon selection all svelte-3njtac"><span class="viewport svelte-3njtac"></span> <span class="viewport svelte-3njtac"></span></span>`);
  var root_2$8 = /* @__PURE__ */ from_html(`<span class="material-symbols-outlined">chevron_right</span> <span class="selections-container svelte-3njtac"><!> <!> <!></span>`, 1);
  var root_6$8 = /* @__PURE__ */ from_html(`<span class="setting-icon svelte-3njtac"><span class="material-symbols-outlined">power_input</span></span>`);
  var root_7$7 = /* @__PURE__ */ from_html(`<span class="material-symbols-outlined">chevron_right</span> <span class="selections-container svelte-3njtac"><span class="setting-icon selection svelte-3njtac">8</span> <span class="setting-icon selection svelte-3njtac">16</span> <span class="setting-icon selection svelte-3njtac">24</span></span>`, 1);
  var root$e = /* @__PURE__ */ from_html(`<span class="icon-container svelte-3njtac"><!> <!></span> <span class="icon-container svelte-3njtac"><!> <!></span>`, 1);
  function ViewportVisibilityIcon($$anchor, $$props) {
    push($$props, false);
    const $dataDislayLineAmount = () => store_get(dataDislayLineAmount, "$dataDislayLineAmount", $$stores);
    const $bytesPerRow = () => store_get(bytesPerRow, "$bytesPerRow", $$stores);
    const $visableViewports = () => store_get(visableViewports, "$visableViewports", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    let dimension = prop($$props, "dimension", 8, 20);
    const defaultDimension = 20;
    const minDimension = 15;
    const maxDimension = 30;
    let width = valid_dimensions();
    let height = valid_dimensions();
    let minWidth = pixel_string(minDimension);
    let minHeight = pixel_string(minDimension);
    let maxWidth = pixel_string(maxDimension);
    let maxHeight = pixel_string(maxDimension);
    let selectionsDisplay = /* @__PURE__ */ mutable_source({ viewports: false, bytesPerRow: false });
    function valid_dimensions() {
      return dimension() > maxDimension || dimension() < minDimension ? pixel_string(defaultDimension) : pixel_string(dimension());
    }
    function pixel_string(value) {
      return value.toString() + "px";
    }
    function set_bytes_per_row(bytesPerRowSelection) {
      if ($dataDislayLineAmount() > BYTES_PER_ROW_MAX_LINE_NUM[bytesPerRowSelection]) store_set(dataDislayLineAmount, BYTES_PER_ROW_MAX_LINE_NUM[bytesPerRowSelection]);
      store_set(bytesPerRow, bytesPerRowSelection);
    }
    init();
    var fragment = root$e();
    var span = first_child(fragment);
    var node = child(span);
    Tooltip(node, {
      alwaysEnabled: true,
      get description() {
        return `Viewports visible: ${$visableViewports() ?? ""}`;
      },
      children: ($$anchor2, $$slotProps) => {
        var span_1 = root_1$9();
        let styles;
        var span_2 = child(span_1);
        let styles_1;
        var span_3 = sibling(span_2, 2);
        let styles_2;
        template_effect(() => {
          styles = set_style(span_1, "", styles, {
            width,
            height,
            "min-width": minWidth,
            "min-height": minHeight,
            "max-width": maxWidth,
            "max-height": maxHeight
          });
          styles_1 = set_style(span_2, "", styles_1, {
            "background-color": $visableViewports() === "all" || $visableViewports() === "physical" ? "white" : ""
          });
          styles_2 = set_style(span_3, "", styles_2, {
            "background-color": $visableViewports() === "all" || $visableViewports() === "logical" ? "white" : ""
          });
        });
        event("click", span_1, () => {
          mutate(selectionsDisplay, get$1(selectionsDisplay).viewports = get$1(selectionsDisplay).viewports ? false : true);
        });
        append($$anchor2, span_1);
      },
      $$slots: { default: true }
    });
    var node_1 = sibling(node, 2);
    {
      var consequent = ($$anchor2) => {
        var fragment_1 = root_2$8();
        var span_4 = first_child(fragment_1);
        set_style(span_4, "", {}, { width: "15px", "font-size": "20px" });
        var span_5 = sibling(span_4, 2);
        var node_2 = child(span_5);
        Tooltip(node_2, {
          alwaysEnabled: true,
          description: "physical",
          children: ($$anchor3, $$slotProps) => {
            var span_6 = root_3$9();
            var span_7 = child(span_6);
            set_style(span_7, "", {}, { "background-color": "white" });
            event("click", span_6, () => {
              store_set(visableViewports, "physical");
            });
            append($$anchor3, span_6);
          },
          $$slots: { default: true }
        });
        var node_3 = sibling(node_2, 2);
        Tooltip(node_3, {
          alwaysEnabled: true,
          description: "logical",
          children: ($$anchor3, $$slotProps) => {
            var span_8 = root_4$9();
            var span_9 = sibling(child(span_8), 2);
            set_style(span_9, "", {}, { "background-color": "white" });
            event("click", span_8, () => {
              store_set(visableViewports, "logical");
            });
            append($$anchor3, span_8);
          },
          $$slots: { default: true }
        });
        var node_4 = sibling(node_3, 2);
        Tooltip(node_4, {
          alwaysEnabled: true,
          description: "all",
          children: ($$anchor3, $$slotProps) => {
            var span_10 = root_5$6();
            var span_11 = child(span_10);
            set_style(span_11, "", {}, { "background-color": "white" });
            var span_12 = sibling(span_11, 2);
            set_style(span_12, "", {}, { "background-color": "white" });
            event("click", span_10, () => {
              store_set(visableViewports, "all");
            });
            append($$anchor3, span_10);
          },
          $$slots: { default: true }
        });
        append($$anchor2, fragment_1);
      };
      if_block(node_1, ($$render) => {
        if (get$1(selectionsDisplay), untrack(() => get$1(selectionsDisplay).viewports)) $$render(consequent);
      });
    }
    var span_13 = sibling(span, 2);
    var node_5 = child(span_13);
    Tooltip(node_5, {
      alwaysEnabled: true,
      get description() {
        return `Bytes per row: ${$bytesPerRow() ?? ""}`;
      },
      children: ($$anchor2, $$slotProps) => {
        var span_14 = root_6$8();
        let styles_3;
        var span_15 = child(span_14);
        set_style(span_15, "", {}, {
          display: "flex",
          "align-content": "center",
          "justify-content": "center",
          "font-size": "20px"
        });
        template_effect(() => styles_3 = set_style(span_14, "", styles_3, {
          width,
          height,
          "min-width": minWidth,
          "min-height": minHeight,
          "max-width": maxWidth,
          "max-height": maxHeight
        }));
        event("click", span_14, () => {
          mutate(selectionsDisplay, get$1(selectionsDisplay).bytesPerRow = get$1(selectionsDisplay).bytesPerRow ? false : true);
        });
        append($$anchor2, span_14);
      },
      $$slots: { default: true }
    });
    var node_6 = sibling(node_5, 2);
    {
      var consequent_1 = ($$anchor2) => {
        var fragment_2 = root_7$7();
        var span_16 = first_child(fragment_2);
        set_style(span_16, "", {}, { width: "15px", "font-size": "20px" });
        var span_17 = sibling(span_16, 2);
        var span_18 = child(span_17);
        var span_19 = sibling(span_18, 2);
        var span_20 = sibling(span_19, 2);
        event("click", span_18, () => {
          set_bytes_per_row(8);
        });
        event("click", span_19, () => {
          set_bytes_per_row(16);
        });
        event("click", span_20, () => {
          set_bytes_per_row(24);
        });
        append($$anchor2, fragment_2);
      };
      if_block(node_6, ($$render) => {
        if (get$1(selectionsDisplay), untrack(() => get$1(selectionsDisplay).bytesPerRow)) $$render(consequent_1);
      });
    }
    append($$anchor, fragment);
    pop();
    $$cleanup();
  }
  /* @__PURE__ */ state(proxy([]));
  var root_2$7 = /* @__PURE__ */ from_html(`<label for="radix" class="svelte-rdfoth">Display Radix:</label> <select id="radix"><option>Hexadecimal</option><option>Decimal</option><option>Octal</option><option>Binary</option></select>`, 1);
  var root_5$5 = /* @__PURE__ */ from_html(`<option> </option>`);
  var root_4$8 = /* @__PURE__ */ from_html(`<optgroup></optgroup>`);
  var root_3$8 = /* @__PURE__ */ from_html(`<label for="encoding" class="svelte-rdfoth">Edit Encoding:</label> <select id="encoding"></select>`, 1);
  var root_7$6 = /* @__PURE__ */ from_html(`<option> </option>`);
  var root_6$7 = /* @__PURE__ */ from_html(`<label for="encoding" class="svelte-rdfoth">Editing:</label> <select id="allowed-editing-actions"></select>`, 1);
  var root_1$8 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <hr class="svelte-rdfoth"/> <!>`, 1);
  var root$d = /* @__PURE__ */ from_html(`<fieldset class="svelte-rdfoth"><legend>Settings</legend> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper></fieldset>`);
  function Settings($$anchor, $$props) {
    push($$props, true);
    const $editorEncoding = () => store_get(editorEncoding, "$editorEncoding", $$stores);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const $displayRadix = () => store_get(displayRadix, "$displayRadix", $$stores);
    const $editorActionsAllowed = () => store_get(editorActionsAllowed, "$editorActionsAllowed", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    window.addEventListener("message", (msg) => {
      switch (msg.data.command) {
        case MessageCommand.fileInfo: {
          if ("byteOrderMark" in msg.data.data) {
            const { byteOrderMark } = msg.data.data;
            if (byteOrderMark === "UTF-8") store_set(editorEncoding, "utf-8");
            else if (byteOrderMark === "UTF-16LE") store_set(editorEncoding, "utf-16le");
            set(bom, byteOrderMark, true);
          }
        }
      }
    });
    var fieldset = root$d();
    var node = sibling(child(fieldset), 2);
    {
      css_props(node, () => ({ "--dir": "column" }));
      FlexContainer(node.lastChild, {
        children: ($$anchor2, $$slotProps) => {
          var fragment = root_1$8();
          var node_1 = first_child(fragment);
          {
            css_props(node_1, () => ({ "--dir": "row", "--align-items": "center" }));
            FlexContainer(node_1.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_1 = root_2$7();
                var select = sibling(first_child(fragment_1), 2);
                var option = child(select);
                var option_value = {};
                var option_1 = sibling(option);
                var option_1_value = {};
                var option_2 = sibling(option_1);
                var option_2_value = {};
                var option_3 = sibling(option_2);
                var option_3_value = {};
                template_effect(() => {
                  set_class(select, 1, clsx($UIThemeCSSClass()), "svelte-rdfoth");
                  if (option_value !== (option_value = RADIX_OPTIONS.Hexadecimal)) {
                    option.value = (option.__value = RADIX_OPTIONS.Hexadecimal) ?? "";
                  }
                  if (option_1_value !== (option_1_value = RADIX_OPTIONS.Decimal)) {
                    option_1.value = (option_1.__value = RADIX_OPTIONS.Decimal) ?? "";
                  }
                  if (option_2_value !== (option_2_value = RADIX_OPTIONS.Octal)) {
                    option_2.value = (option_2.__value = RADIX_OPTIONS.Octal) ?? "";
                  }
                  if (option_3_value !== (option_3_value = RADIX_OPTIONS.Binary)) {
                    option_3.value = (option_3.__value = RADIX_OPTIONS.Binary) ?? "";
                  }
                });
                bind_select_value(select, $displayRadix, ($$value) => store_set(displayRadix, $$value));
                append($$anchor3, fragment_1);
              },
              $$slots: { default: true }
            });
          }
          var node_2 = sibling(node_1, 2);
          {
            css_props(node_2, () => ({ "--dir": "row", "--align-items": "center" }));
            FlexContainer(node_2.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_2 = root_3$8();
                var select_1 = sibling(first_child(fragment_2), 2);
                each(select_1, 21, () => ENCODING_GROUPS, index, ($$anchor4, $$item) => {
                  let group = () => get$1($$item).group;
                  let encodings = () => get$1($$item).encodings;
                  var optgroup = root_4$8();
                  each(optgroup, 21, encodings, index, ($$anchor5, $$item2) => {
                    let name = () => get$1($$item2).name;
                    let value = () => get$1($$item2).value;
                    var option_4 = root_5$5();
                    var text2 = child(option_4);
                    var option_4_value = {};
                    template_effect(() => {
                      set_text(text2, name());
                      if (option_4_value !== (option_4_value = value())) {
                        option_4.value = (option_4.__value = value()) ?? "";
                      }
                    });
                    append($$anchor5, option_4);
                  });
                  template_effect(() => set_attribute(optgroup, "label", group()));
                  append($$anchor4, optgroup);
                });
                template_effect(() => set_class(select_1, 1, clsx($UIThemeCSSClass()), "svelte-rdfoth"));
                bind_select_value(select_1, $editorEncoding, ($$value) => store_set(editorEncoding, $$value));
                append($$anchor3, fragment_2);
              },
              $$slots: { default: true }
            });
          }
          var node_3 = sibling(node_2, 2);
          {
            css_props(node_3, () => ({ "--dir": "row", "--align-items": "center" }));
            FlexContainer(node_3.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_3 = root_6$7();
                var select_2 = sibling(first_child(fragment_3), 2);
                each(select_2, 21, () => EDIT_ACTIONS, index, ($$anchor4, $$item) => {
                  let name = () => get$1($$item).name;
                  let value = () => get$1($$item).value;
                  var option_5 = root_7$6();
                  var text_1 = child(option_5);
                  var option_5_value = {};
                  template_effect(() => {
                    set_text(text_1, name());
                    if (option_5_value !== (option_5_value = value())) {
                      option_5.value = (option_5.__value = value()) ?? "";
                    }
                  });
                  append($$anchor4, option_5);
                });
                template_effect(() => set_class(select_2, 1, clsx($UIThemeCSSClass()), "svelte-rdfoth"));
                bind_select_value(select_2, $editorActionsAllowed, ($$value) => store_set(editorActionsAllowed, $$value));
                append($$anchor3, fragment_3);
              },
              $$slots: { default: true }
            });
          }
          var node_4 = sibling(node_3, 4);
          ViewportVisibilityIcon(node_4, { dimension: 20 });
          append($$anchor2, fragment);
        },
        $$slots: { default: true }
      });
    }
    append($$anchor, fieldset);
    pop();
    $$cleanup();
  }
  var root_1$7 = /* @__PURE__ */ from_html(`<div class="overlay svelte-1qjii8j"></div>`);
  var root$c = /* @__PURE__ */ from_html(`<!> <div><div class="tab svelte-1qjii8j"><span class="svelte-1qjii8j"> </span></div> <div class="content svelte-1qjii8j"><!></div></div>`, 1);
  function SidePanel($$anchor, $$props) {
    let position = prop($$props, "position", 8, "top-left");
    let title = prop($$props, "title", 8, "Side Panel Title");
    let open = prop($$props, "open", 12, false);
    let panelWidth = prop(
      $$props,
      "panelWidth",
      8,
      "300px"
      // Default width
    );
    var fragment = root$c();
    var node = first_child(fragment);
    {
      var consequent = ($$anchor2) => {
        var div = root_1$7();
        event("click", div, () => open(false));
        append($$anchor2, div);
      };
      if_block(node, ($$render) => {
        if (open()) $$render(consequent);
      });
    }
    var div_1 = sibling(node, 2);
    var div_2 = child(div_1);
    var span = child(div_2);
    var text2 = child(span);
    var div_3 = sibling(div_2, 2);
    var node_1 = child(div_3);
    slot(node_1, $$props, "default", {});
    template_effect(() => {
      set_class(div_1, 1, `side-panel ${position()} ${open() ? "open" : ""}`, "svelte-1qjii8j");
      set_style(div_1, `width: ${panelWidth() ?? ""};`);
      set_text(text2, title());
    });
    event("click", div_2, () => open(false));
    append($$anchor, fragment);
  }
  function getDefaultExportFromCjs(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
  }
  var data;
  var hasRequiredData;
  function requireData() {
    if (hasRequiredData) return data;
    hasRequiredData = 1;
    const LANGUAGES_LIST = {
      aa: {
        name: "Afar",
        nativeName: "Afaraf"
      },
      ab: {
        name: "Abkhaz",
        nativeName: "аҧсуа бызшәа"
      },
      ae: {
        name: "Avestan",
        nativeName: "avesta"
      },
      af: {
        name: "Afrikaans",
        nativeName: "Afrikaans"
      },
      ak: {
        name: "Akan",
        nativeName: "Akan"
      },
      am: {
        name: "Amharic",
        nativeName: "አማርኛ"
      },
      an: {
        name: "Aragonese",
        nativeName: "aragonés"
      },
      ar: {
        name: "Arabic",
        nativeName: "العربية"
      },
      as: {
        name: "Assamese",
        nativeName: "অসমীয়া"
      },
      av: {
        name: "Avaric",
        nativeName: "авар мацӀ"
      },
      ay: {
        name: "Aymara",
        nativeName: "aymar aru"
      },
      az: {
        name: "Azerbaijani",
        nativeName: "azərbaycan dili"
      },
      ba: {
        name: "Bashkir",
        nativeName: "башҡорт теле"
      },
      be: {
        name: "Belarusian",
        nativeName: "беларуская мова"
      },
      bg: {
        name: "Bulgarian",
        nativeName: "български език"
      },
      bi: {
        name: "Bislama",
        nativeName: "Bislama"
      },
      bm: {
        name: "Bambara",
        nativeName: "bamanankan"
      },
      bn: {
        name: "Bengali",
        nativeName: "বাংলা"
      },
      bo: {
        name: "Tibetan",
        nativeName: "བོད་ཡིག"
      },
      br: {
        name: "Breton",
        nativeName: "brezhoneg"
      },
      bs: {
        name: "Bosnian",
        nativeName: "bosanski jezik"
      },
      ca: {
        name: "Catalan",
        nativeName: "Català"
      },
      ce: {
        name: "Chechen",
        nativeName: "нохчийн мотт"
      },
      ch: {
        name: "Chamorro",
        nativeName: "Chamoru"
      },
      co: {
        name: "Corsican",
        nativeName: "corsu"
      },
      cr: {
        name: "Cree",
        nativeName: "ᓀᐦᐃᔭᐍᐏᐣ"
      },
      cs: {
        name: "Czech",
        nativeName: "Čeština"
      },
      cu: {
        name: "Old Church Slavonic",
        nativeName: "ѩзыкъ словѣньскъ"
      },
      cv: {
        name: "Chuvash",
        nativeName: "чӑваш чӗлхи"
      },
      cy: {
        name: "Welsh",
        nativeName: "Cymraeg"
      },
      da: {
        name: "Danish",
        nativeName: "Dansk"
      },
      de: {
        name: "German",
        nativeName: "Deutsch"
      },
      dv: {
        name: "Divehi",
        nativeName: "ދިވެހި"
      },
      dz: {
        name: "Dzongkha",
        nativeName: "རྫོང་ཁ"
      },
      ee: {
        name: "Ewe",
        nativeName: "Eʋegbe"
      },
      el: {
        name: "Greek",
        nativeName: "Ελληνικά"
      },
      en: {
        name: "English",
        nativeName: "English"
      },
      eo: {
        name: "Esperanto",
        nativeName: "Esperanto"
      },
      es: {
        name: "Spanish",
        nativeName: "Español"
      },
      et: {
        name: "Estonian",
        nativeName: "eesti"
      },
      eu: {
        name: "Basque",
        nativeName: "euskara"
      },
      fa: {
        name: "Persian",
        nativeName: "فارسی"
      },
      ff: {
        name: "Fula",
        nativeName: "Fulfulde"
      },
      fi: {
        name: "Finnish",
        nativeName: "suomi"
      },
      fj: {
        name: "Fijian",
        nativeName: "vosa Vakaviti"
      },
      fo: {
        name: "Faroese",
        nativeName: "Føroyskt"
      },
      fr: {
        name: "French",
        nativeName: "Français"
      },
      fy: {
        name: "Western Frisian",
        nativeName: "Frysk"
      },
      ga: {
        name: "Irish",
        nativeName: "Gaeilge"
      },
      gd: {
        name: "Scottish Gaelic",
        nativeName: "Gàidhlig"
      },
      gl: {
        name: "Galician",
        nativeName: "galego"
      },
      gn: {
        name: "Guaraní",
        nativeName: "Avañe'ẽ"
      },
      gu: {
        name: "Gujarati",
        nativeName: "ગુજરાતી"
      },
      gv: {
        name: "Manx",
        nativeName: "Gaelg"
      },
      ha: {
        name: "Hausa",
        nativeName: "هَوُسَ"
      },
      he: {
        name: "Hebrew",
        nativeName: "עברית"
      },
      hi: {
        name: "Hindi",
        nativeName: "हिन्दी"
      },
      ho: {
        name: "Hiri Motu",
        nativeName: "Hiri Motu"
      },
      hr: {
        name: "Croatian",
        nativeName: "Hrvatski"
      },
      ht: {
        name: "Haitian",
        nativeName: "Kreyòl ayisyen"
      },
      hu: {
        name: "Hungarian",
        nativeName: "magyar"
      },
      hy: {
        name: "Armenian",
        nativeName: "Հայերեն"
      },
      hz: {
        name: "Herero",
        nativeName: "Otjiherero"
      },
      ia: {
        name: "Interlingua",
        nativeName: "Interlingua"
      },
      id: {
        name: "Indonesian",
        nativeName: "Bahasa Indonesia"
      },
      ie: {
        name: "Interlingue",
        nativeName: "Interlingue"
      },
      ig: {
        name: "Igbo",
        nativeName: "Asụsụ Igbo"
      },
      ii: {
        name: "Nuosu",
        nativeName: "ꆈꌠ꒿ Nuosuhxop"
      },
      ik: {
        name: "Inupiaq",
        nativeName: "Iñupiaq"
      },
      io: {
        name: "Ido",
        nativeName: "Ido"
      },
      is: {
        name: "Icelandic",
        nativeName: "Íslenska"
      },
      it: {
        name: "Italian",
        nativeName: "Italiano"
      },
      iu: {
        name: "Inuktitut",
        nativeName: "ᐃᓄᒃᑎᑐᑦ"
      },
      ja: {
        name: "Japanese",
        nativeName: "日本語"
      },
      jv: {
        name: "Javanese",
        nativeName: "basa Jawa"
      },
      ka: {
        name: "Georgian",
        nativeName: "ქართული"
      },
      kg: {
        name: "Kongo",
        nativeName: "Kikongo"
      },
      ki: {
        name: "Kikuyu",
        nativeName: "Gĩkũyũ"
      },
      kj: {
        name: "Kwanyama",
        nativeName: "Kuanyama"
      },
      kk: {
        name: "Kazakh",
        nativeName: "қазақ тілі"
      },
      kl: {
        name: "Kalaallisut",
        nativeName: "kalaallisut"
      },
      km: {
        name: "Khmer",
        nativeName: "ខេមរភាសា"
      },
      kn: {
        name: "Kannada",
        nativeName: "ಕನ್ನಡ"
      },
      ko: {
        name: "Korean",
        nativeName: "한국어"
      },
      kr: {
        name: "Kanuri",
        nativeName: "Kanuri"
      },
      ks: {
        name: "Kashmiri",
        nativeName: "कश्मीरी"
      },
      ku: {
        name: "Kurdish",
        nativeName: "Kurdî"
      },
      kv: {
        name: "Komi",
        nativeName: "коми кыв"
      },
      kw: {
        name: "Cornish",
        nativeName: "Kernewek"
      },
      ky: {
        name: "Kyrgyz",
        nativeName: "Кыргызча"
      },
      la: {
        name: "Latin",
        nativeName: "latine"
      },
      lb: {
        name: "Luxembourgish",
        nativeName: "Lëtzebuergesch"
      },
      lg: {
        name: "Ganda",
        nativeName: "Luganda"
      },
      li: {
        name: "Limburgish",
        nativeName: "Limburgs"
      },
      ln: {
        name: "Lingala",
        nativeName: "Lingála"
      },
      lo: {
        name: "Lao",
        nativeName: "ພາສາລາວ"
      },
      lt: {
        name: "Lithuanian",
        nativeName: "lietuvių kalba"
      },
      lu: {
        name: "Luba-Katanga",
        nativeName: "Kiluba"
      },
      lv: {
        name: "Latvian",
        nativeName: "latviešu valoda"
      },
      mg: {
        name: "Malagasy",
        nativeName: "fiteny malagasy"
      },
      mh: {
        name: "Marshallese",
        nativeName: "Kajin M̧ajeļ"
      },
      mi: {
        name: "Māori",
        nativeName: "te reo Māori"
      },
      mk: {
        name: "Macedonian",
        nativeName: "македонски јазик"
      },
      ml: {
        name: "Malayalam",
        nativeName: "മലയാളം"
      },
      mn: {
        name: "Mongolian",
        nativeName: "Монгол хэл"
      },
      mr: {
        name: "Marathi",
        nativeName: "मराठी"
      },
      ms: {
        name: "Malay",
        nativeName: "Bahasa Melayu"
      },
      mt: {
        name: "Maltese",
        nativeName: "Malti"
      },
      my: {
        name: "Burmese",
        nativeName: "ဗမာစာ"
      },
      na: {
        name: "Nauru",
        nativeName: "Dorerin Naoero"
      },
      nb: {
        name: "Norwegian Bokmål",
        nativeName: "Norsk bokmål"
      },
      nd: {
        name: "Northern Ndebele",
        nativeName: "isiNdebele"
      },
      ne: {
        name: "Nepali",
        nativeName: "नेपाली"
      },
      ng: {
        name: "Ndonga",
        nativeName: "Owambo"
      },
      nl: {
        name: "Dutch",
        nativeName: "Nederlands"
      },
      nn: {
        name: "Norwegian Nynorsk",
        nativeName: "Norsk nynorsk"
      },
      no: {
        name: "Norwegian",
        nativeName: "Norsk"
      },
      nr: {
        name: "Southern Ndebele",
        nativeName: "isiNdebele"
      },
      nv: {
        name: "Navajo",
        nativeName: "Diné bizaad"
      },
      ny: {
        name: "Chichewa",
        nativeName: "chiCheŵa"
      },
      oc: {
        name: "Occitan",
        nativeName: "occitan"
      },
      oj: {
        name: "Ojibwe",
        nativeName: "ᐊᓂᔑᓈᐯᒧᐎᓐ"
      },
      om: {
        name: "Oromo",
        nativeName: "Afaan Oromoo"
      },
      or: {
        name: "Oriya",
        nativeName: "ଓଡ଼ିଆ"
      },
      os: {
        name: "Ossetian",
        nativeName: "ирон æвзаг"
      },
      pa: {
        name: "Panjabi",
        nativeName: "ਪੰਜਾਬੀ"
      },
      pi: {
        name: "Pāli",
        nativeName: "पाऴि"
      },
      pl: {
        name: "Polish",
        nativeName: "Polski"
      },
      ps: {
        name: "Pashto",
        nativeName: "پښتو"
      },
      pt: {
        name: "Portuguese",
        nativeName: "Português"
      },
      qu: {
        name: "Quechua",
        nativeName: "Runa Simi"
      },
      rm: {
        name: "Romansh",
        nativeName: "rumantsch grischun"
      },
      rn: {
        name: "Kirundi",
        nativeName: "Ikirundi"
      },
      ro: {
        name: "Romanian",
        nativeName: "Română"
      },
      ru: {
        name: "Russian",
        nativeName: "Русский"
      },
      rw: {
        name: "Kinyarwanda",
        nativeName: "Ikinyarwanda"
      },
      sa: {
        name: "Sanskrit",
        nativeName: "संस्कृतम्"
      },
      sc: {
        name: "Sardinian",
        nativeName: "sardu"
      },
      sd: {
        name: "Sindhi",
        nativeName: "सिन्धी"
      },
      se: {
        name: "Northern Sami",
        nativeName: "Davvisámegiella"
      },
      sg: {
        name: "Sango",
        nativeName: "yângâ tî sängö"
      },
      si: {
        name: "Sinhala",
        nativeName: "සිංහල"
      },
      sk: {
        name: "Slovak",
        nativeName: "Slovenčina"
      },
      sl: {
        name: "Slovenian",
        nativeName: "slovenščina"
      },
      sm: {
        name: "Samoan",
        nativeName: "gagana fa'a Samoa"
      },
      sn: {
        name: "Shona",
        nativeName: "chiShona"
      },
      so: {
        name: "Somali",
        nativeName: "Soomaaliga"
      },
      sq: {
        name: "Albanian",
        nativeName: "Shqip"
      },
      sr: {
        name: "Serbian",
        nativeName: "српски језик"
      },
      ss: {
        name: "Swati",
        nativeName: "SiSwati"
      },
      st: {
        name: "Southern Sotho",
        nativeName: "Sesotho"
      },
      su: {
        name: "Sundanese",
        nativeName: "Basa Sunda"
      },
      sv: {
        name: "Swedish",
        nativeName: "Svenska"
      },
      sw: {
        name: "Swahili",
        nativeName: "Kiswahili"
      },
      ta: {
        name: "Tamil",
        nativeName: "தமிழ்"
      },
      te: {
        name: "Telugu",
        nativeName: "తెలుగు"
      },
      tg: {
        name: "Tajik",
        nativeName: "тоҷикӣ"
      },
      th: {
        name: "Thai",
        nativeName: "ไทย"
      },
      ti: {
        name: "Tigrinya",
        nativeName: "ትግርኛ"
      },
      tk: {
        name: "Turkmen",
        nativeName: "Türkmençe"
      },
      tl: {
        name: "Tagalog",
        nativeName: "Wikang Tagalog"
      },
      tn: {
        name: "Tswana",
        nativeName: "Setswana"
      },
      to: {
        name: "Tonga",
        nativeName: "faka Tonga"
      },
      tr: {
        name: "Turkish",
        nativeName: "Türkçe"
      },
      ts: {
        name: "Tsonga",
        nativeName: "Xitsonga"
      },
      tt: {
        name: "Tatar",
        nativeName: "татар теле"
      },
      tw: {
        name: "Twi",
        nativeName: "Twi"
      },
      ty: {
        name: "Tahitian",
        nativeName: "Reo Tahiti"
      },
      ug: {
        name: "Uyghur",
        nativeName: "ئۇيغۇرچە‎"
      },
      uk: {
        name: "Ukrainian",
        nativeName: "Українська"
      },
      ur: {
        name: "Urdu",
        nativeName: "اردو"
      },
      uz: {
        name: "Uzbek",
        nativeName: "Ўзбек"
      },
      ve: {
        name: "Venda",
        nativeName: "Tshivenḓa"
      },
      vi: {
        name: "Vietnamese",
        nativeName: "Tiếng Việt"
      },
      vo: {
        name: "Volapük",
        nativeName: "Volapük"
      },
      wa: {
        name: "Walloon",
        nativeName: "walon"
      },
      wo: {
        name: "Wolof",
        nativeName: "Wollof"
      },
      xh: {
        name: "Xhosa",
        nativeName: "isiXhosa"
      },
      yi: {
        name: "Yiddish",
        nativeName: "ייִדיש"
      },
      yo: {
        name: "Yoruba",
        nativeName: "Yorùbá"
      },
      za: {
        name: "Zhuang",
        nativeName: "Saɯ cueŋƅ"
      },
      zh: {
        name: "Chinese",
        nativeName: "中文"
      },
      zu: {
        name: "Zulu",
        nativeName: "isiZulu"
      }
    };
    data = LANGUAGES_LIST;
    return data;
  }
  var src;
  var hasRequiredSrc;
  function requireSrc() {
    if (hasRequiredSrc) return src;
    hasRequiredSrc = 1;
    const LANGUAGES_LIST = requireData();
    const LANGUAGES = {};
    const LANGUAGES_BY_NAME = {};
    const LANGUAGE_CODES = [];
    const LANGUAGE_NAMES = [];
    const LANGUAGE_NATIVE_NAMES = [];
    for (const code in LANGUAGES_LIST) {
      const { name, nativeName } = LANGUAGES_LIST[code];
      LANGUAGES[code] = LANGUAGES_BY_NAME[name.toLowerCase()] = LANGUAGES_BY_NAME[nativeName.toLowerCase()] = { code, name, nativeName };
      LANGUAGE_CODES.push(code);
      LANGUAGE_NAMES.push(name);
      LANGUAGE_NATIVE_NAMES.push(nativeName);
    }
    src = class ISO63912 {
      static getLanguages(codes = []) {
        return codes.map(
          (code) => ISO63912.validate(code) ? Object.assign({}, LANGUAGES[code]) : { code, name: "", nativeName: "" }
        );
      }
      static getName(code) {
        return ISO63912.validate(code) ? LANGUAGES_LIST[code].name : "";
      }
      static getAllNames() {
        return LANGUAGE_NAMES.slice();
      }
      static getNativeName(code) {
        return ISO63912.validate(code) ? LANGUAGES_LIST[code].nativeName : "";
      }
      static getAllNativeNames() {
        return LANGUAGE_NATIVE_NAMES.slice();
      }
      static getCode(name) {
        name = name.toLowerCase();
        return LANGUAGES_BY_NAME.hasOwnProperty(name) ? LANGUAGES_BY_NAME[name].code : "";
      }
      static getAllCodes() {
        return LANGUAGE_CODES.slice();
      }
      static validate(code) {
        return LANGUAGES_LIST.hasOwnProperty(code);
      }
    };
    return src;
  }
  var srcExports = requireSrc();
  const ISO6391 = /* @__PURE__ */ getDefaultExportFromCjs(srcExports);
  var root_1$6 = /* @__PURE__ */ from_html(`<div class="header svelte-2mj3pr"><h3> </h3></div>`);
  var root_2$6 = /* @__PURE__ */ from_html(`<div class="ascii-control-overlay svelte-2mj3pr"><div class="overlay-title svelte-2mj3pr">ctrl</div></div> <div class="printable-ascii-overlay svelte-2mj3pr"><div class="overlay-title svelte-2mj3pr">printable</div></div> <div class="ascii-control2-overlay svelte-2mj3pr"></div>`, 1);
  var root_3$7 = /* @__PURE__ */ from_html(`<div></div>`);
  var root_4$7 = /* @__PURE__ */ from_html(`<div class="tooltip svelte-2mj3pr"> <!></div>`);
  var root_6$6 = /* @__PURE__ */ from_html(`<div class="input-container"><label for="start-offset-input" class="label">Start Offset: <!></label></div>`);
  var root_7$5 = /* @__PURE__ */ from_html(`<div><label for="start-offset">Start Offset: <span id="start-offset" class="editable"> </span></label></div>`);
  var root_8$6 = /* @__PURE__ */ from_html(`<div class="input-container"><label for="end-offset-input" class="label">&nbsp;&nbsp;End Offset: <!></label></div>`);
  var root_9$4 = /* @__PURE__ */ from_html(`<div><label for="end-offset">&nbsp;&nbsp;End Offset: <span id="end-offset" class="editable"> </span></label></div>`);
  var root_10$3 = /* @__PURE__ */ from_html(`<div class="input-container"><label for="length-input" class="label">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Length: <!></label></div>`);
  var root_11$4 = /* @__PURE__ */ from_html(`<div><label for="length">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Length: <span id="length" class="editable"> </span></label></div>`);
  var root_12$4 = /* @__PURE__ */ from_html(`<span id="language" class="nowrap"> </span>`);
  var root_13$4 = /* @__PURE__ */ from_html(`<span>Profile&nbsp;as&nbsp;CSV</span>`);
  var root_14$4 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">download</span>`);
  var root_15$4 = /* @__PURE__ */ from_html(`<span slot="default">Save&nbsp;Segment&nbsp;As</span>`);
  var root_16$4 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">save_as</span>`);
  var root_17$4 = /* @__PURE__ */ from_html(`<div class="message status svelte-2mj3pr"> </div>`);
  var root_18$3 = /* @__PURE__ */ from_html(`<div class="message warning svelte-2mj3pr"> </div>`);
  var root_19$2 = /* @__PURE__ */ from_html(`<div class="message error svelte-2mj3pr"> </div>`);
  var root$b = /* @__PURE__ */ from_html(`<div class="container svelte-2mj3pr"><!> <div class="chart svelte-2mj3pr"><!> <!> <!></div> <hr/> <div><div class="input-container"><label for="scale">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scale: <span id="scale" class="editable"> </span></label></div> <div class="input-container"><label for="ascii-overlay-toggle">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Overlay: <span id="ascii-overlay-toggle" class="editable"> </span></label></div> <!> <!> <!></div> <hr/> <div class="stats"><label for="computed-size">&nbsp;&nbsp;Max Offset: <span id="computed-size" class="nowrap"> </span></label> <label for="language">&nbsp;&nbsp;&nbsp;&nbsp;Language:<!></label> <label for="content-type">Content Type: <span id="content-type" class="nowrap"> </span></label> <label for="min-frequency">&nbsp;&nbsp;&nbsp;Min Freq.: <span id="min-frequency" class="nowrap"> </span></label> <label for="max-frequency">&nbsp;&nbsp;&nbsp;Max Freq.: <span id="max-frequency" class="nowrap"> </span></label> <label for="mean-frequency">&nbsp;&nbsp;Mean Freq.: <span id="mean-frequency" class="nowrap"> </span></label> <label for="variance">&nbsp;&nbsp;&nbsp;&nbsp;Variance: <span id="variance" class="nowrap"> </span></label> <label for="stddev">&nbsp;&nbsp;&nbsp;Std. Dev.: <span id="stddev" class="nowrap"> </span></label> <label for="byte-count">&nbsp;&nbsp;Byte Count: <span id="byte-count" class="nowrap"> </span></label> <label for="distinct-count">&nbsp;&nbsp;&nbsp;&nbsp;Distinct: <span id="distinct-count" class="nowrap"> </span></label> <label for="dos_eol-count">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;DOS EOL: <span id="dos_eol-count" class="nowrap"> </span></label> <label for="ascii-count">&nbsp;ASCII Count: <span id="ascii-count" class="nowrap"> </span></label> <label for="ascii-percent">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;% ASCII: <span id="ascii-percent" class="nowrap"> </span></label></div> <hr/> <div class="char-count"><label for="char-count-bom">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;BOM: <span id="char-count-bom" class="nowrap"> </span></label> <label for="char-count-bom-bytes">&nbsp;&nbsp;BOM Bytes: <span id="char-count-bom-bytes" class="nowrap"> </span></label> <label for="char-count-single">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Single: <span id="char-count-single" class="nowrap"> </span></label> <label for="char-count-double">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Double: <span id="char-count-double" class="nowrap"> </span></label> <label for="char-count-triple">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Triple: <span id="char-count-triple" class="nowrap"> </span></label> <label for="char-count-quad">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quad: <span id="char-count-quad" class="nowrap"> </span></label> <label for="char-count-invalid">&nbsp;&nbsp;&nbsp;&nbsp;Invalid: <span id="char-count-invalid" class="nowrap"> </span></label></div> <hr/> <!> <!> <hr/> <!> <!> <!></div>`);
  function DataMetrics($$anchor, $$props) {
    push($$props, false);
    const $addressRadix = () => store_get(addressRadix, "$addressRadix", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const PROFILE_DOS_EOL = 256;
    const MAX_BYTE_VALUE = 255;
    let title = prop($$props, "title", 8);
    let startOffset = prop($$props, "startOffset", 12);
    let length = prop($$props, "length", 12);
    class CharacterCountData {
      constructor() {
        Object.defineProperty(this, "byteOrderMark", {
          enumerable: true,
          configurable: true,
          writable: true,
          value: ""
        });
        Object.defineProperty(this, "byteOrderMarkBytes", {
          enumerable: true,
          configurable: true,
          writable: true,
          value: 0
        });
        Object.defineProperty(this, "singleByteCount", {
          enumerable: true,
          configurable: true,
          writable: true,
          value: 0
        });
        Object.defineProperty(this, "doubleByteCount", {
          enumerable: true,
          configurable: true,
          writable: true,
          value: 0
        });
        Object.defineProperty(this, "tripleByteCount", {
          enumerable: true,
          configurable: true,
          writable: true,
          value: 0
        });
        Object.defineProperty(this, "quadByteCount", {
          enumerable: true,
          configurable: true,
          writable: true,
          value: 0
        });
        Object.defineProperty(this, "invalidBytes", {
          enumerable: true,
          configurable: true,
          writable: true,
          value: 0
        });
      }
    }
    let endOffset = /* @__PURE__ */ mutable_source(0);
    let byteProfile = /* @__PURE__ */ mutable_source([]);
    let language = /* @__PURE__ */ mutable_source("");
    let contentType = /* @__PURE__ */ mutable_source("");
    let currentTooltip = /* @__PURE__ */ mutable_source(null);
    let colorScaleData = /* @__PURE__ */ mutable_source([]);
    let scaledData = /* @__PURE__ */ mutable_source([]);
    let sum = /* @__PURE__ */ mutable_source(0);
    let minFrequency = /* @__PURE__ */ mutable_source(0);
    let maxFrequency = /* @__PURE__ */ mutable_source(0);
    let mean = /* @__PURE__ */ mutable_source(0);
    let variance = /* @__PURE__ */ mutable_source(0);
    let stdDev = /* @__PURE__ */ mutable_source(0);
    let characterCountData = /* @__PURE__ */ mutable_source(new CharacterCountData());
    let numAscii = /* @__PURE__ */ mutable_source(0);
    let numDistinct = /* @__PURE__ */ mutable_source(0);
    let fieldBeingEdited = /* @__PURE__ */ mutable_source("");
    let statusMessage = /* @__PURE__ */ mutable_source("");
    let warningMessage = /* @__PURE__ */ mutable_source("");
    let errorMessage = /* @__PURE__ */ mutable_source("");
    let statusMessageTimeout = null;
    let warningMessageTimeout = null;
    let errorMessageTimeout = null;
    let asciiOverlay = /* @__PURE__ */ mutable_source(true);
    let logScale = /* @__PURE__ */ mutable_source(false);
    function setStatusMessage(msg, timeout = 5e3) {
      if (statusMessageTimeout) clearTimeout(statusMessageTimeout);
      set(errorMessage, "");
      set(statusMessage, msg);
      if (timeout > 0) {
        statusMessageTimeout = setTimeout(
          () => {
            set(statusMessage, "");
          },
          timeout
        );
      }
    }
    function setWarningMessage(msg, timeout = 7500) {
      if (warningMessageTimeout) clearTimeout(warningMessageTimeout);
      set(errorMessage, "");
      set(warningMessage, msg);
      if (timeout > 0) {
        warningMessageTimeout = setTimeout(
          () => {
            set(warningMessage, "");
          },
          timeout
        );
      }
    }
    function setErrorMessage(msg, timeout = 1e4) {
      if (errorMessageTimeout) clearTimeout(errorMessageTimeout);
      set(statusMessage, "");
      set(warningMessage, "");
      set(errorMessage, msg);
      if (timeout > 0) {
        errorMessageTimeout = setTimeout(
          () => {
            set(errorMessage, "");
          },
          timeout
        );
      }
    }
    function handleCsvProfileDownload() {
      const csvContent = "Byte,Frequency\n" + get$1(byteProfile).filter((_, idx) => idx <= MAX_BYTE_VALUE).map((val, idx) => `${idx},${val}`).join("\n");
      const blob = new Blob([csvContent], { type: "text/csv;charset=utf-8;" });
      const link2 = document.createElement("a");
      link2.href = URL.createObjectURL(blob);
      link2.download = "profile-data.csv";
      link2.click();
    }
    function saveSegmentAs() {
      vscode.postMessage({
        command: MessageCommand.saveSegment,
        data: { offset: startOffset(), length: length() }
      });
    }
    function requestSessionProfile(startOffset2, length2) {
      setStatusMessage(`Profiling bytes from ${startOffset2} to ${startOffset2 + length2}...`, 0);
      vscode.postMessage({
        command: MessageCommand.profile,
        data: { startOffset: startOffset2, length: length2 }
      });
    }
    function handleInputEnter(e) {
      switch (e.detail.id) {
        case "start-offset-input":
          {
            const startOffsetTemp = parseInt(e.detail.value, $addressRadix());
            if (isNaN(startOffsetTemp) || !regexEditDataTest(e.detail.value, $addressRadix())) {
              setErrorMessage(`End offset must be a ${radixToString($addressRadix())} number`);
              return;
            } else if (startOffsetTemp < 0) {
              setErrorMessage("Start offset must be greater than or equal to 0");
              return;
            } else if (startOffsetTemp >= get$1(endOffset)) {
              setErrorMessage("Start offset must be less than end offset");
              return;
            }
            startOffset(startOffsetTemp);
            const lengthTemp = get$1(endOffset) - startOffset();
            if (lengthTemp > DATA_PROFILE_MAX_LENGTH) {
              setWarningMessage(`Length adjusted to ${DATA_PROFILE_MAX_LENGTH}`);
              length(DATA_PROFILE_MAX_LENGTH);
              set(endOffset, startOffset() + length());
            } else {
              length(lengthTemp);
            }
          }
          break;
        case "end-offset-input":
          {
            const endOffsetTemp = parseInt(e.detail.value, $addressRadix());
            if (isNaN(endOffsetTemp) || !regexEditDataTest(e.detail.value, $addressRadix())) {
              setErrorMessage(`End offset must be a ${radixToString($addressRadix())} number`);
              return;
            } else if (endOffsetTemp <= startOffset()) {
              setErrorMessage("End offset must be greater than start offset");
              return;
            } else if (endOffsetTemp > viewport.offsetMax) {
              setErrorMessage(`End offset must be less than or equal to ${viewport.offsetMax}`);
              return;
            }
            set(endOffset, endOffsetTemp);
            const lengthTemp = get$1(endOffset) - startOffset();
            if (lengthTemp > DATA_PROFILE_MAX_LENGTH) {
              setWarningMessage(`Length adjusted to ${DATA_PROFILE_MAX_LENGTH}`);
              length(DATA_PROFILE_MAX_LENGTH);
              startOffset(get$1(endOffset) - length());
            } else {
              length(lengthTemp);
            }
          }
          break;
        case "length-input":
          {
            const lengthTemp = parseInt(e.detail.value, $addressRadix());
            if (isNaN(lengthTemp) || !regexEditDataTest(e.detail.value, $addressRadix())) {
              setErrorMessage(`End offset must be a ${radixToString($addressRadix())} number`);
              return;
            } else if (lengthTemp <= 0) {
              setErrorMessage("Length must be greater than 0");
              return;
            } else if (lengthTemp > viewport.offsetMax - startOffset()) {
              setErrorMessage(`Length must be less than or equal to ${viewport.offsetMax - startOffset()}`);
              return;
            }
            if (lengthTemp > DATA_PROFILE_MAX_LENGTH) {
              setWarningMessage(`Length adjusted to ${DATA_PROFILE_MAX_LENGTH}`);
              length(DATA_PROFILE_MAX_LENGTH);
            } else {
              length(lengthTemp);
            }
            set(endOffset, startOffset() + length());
          }
          break;
      }
      set(fieldBeingEdited, "");
      requestSessionProfile(startOffset(), length());
    }
    function handleBlur() {
      set(fieldBeingEdited, "");
    }
    onMount(() => {
      window.addEventListener("message", (msg) => {
        switch (msg.data.command) {
          case MessageCommand.profile:
            set(numAscii, msg.data.data.numAscii);
            set(byteProfile, msg.data.data.byteProfile);
            set(language, msg.data.data.language);
            set(contentType, msg.data.data.contentType);
            mutate(characterCountData, get$1(characterCountData).byteOrderMark = msg.data.data.characterCount.byteOrderMark);
            mutate(characterCountData, get$1(characterCountData).byteOrderMarkBytes = msg.data.data.characterCount.byteOrderMarkBytes);
            mutate(characterCountData, get$1(characterCountData).singleByteCount = msg.data.data.characterCount.singleByteCount);
            mutate(characterCountData, get$1(characterCountData).doubleByteCount = msg.data.data.characterCount.doubleByteCount);
            mutate(characterCountData, get$1(characterCountData).tripleByteCount = msg.data.data.characterCount.tripleByteCount);
            mutate(characterCountData, get$1(characterCountData).quadByteCount = msg.data.data.characterCount.quadByteCount);
            mutate(characterCountData, get$1(characterCountData).invalidBytes = msg.data.data.characterCount.invalidBytes);
            setStatusMessage(`Profiled bytes from ${startOffset()} to ${startOffset() + length()}`);
            break;
        }
      });
      set(endOffset, startOffset() + length());
      requestSessionProfile(startOffset(), length());
    });
    legacy_pre_effect(
      () => (get$1(sum), get$1(byteProfile), get$1(mean), get$1(maxFrequency), get$1(variance), get$1(stdDev), get$1(logScale)),
      () => {
        set(sum, get$1(byteProfile).reduce((a, b) => a + b, 0));
        set(mean, get$1(sum) / get$1(byteProfile).length);
        set(minFrequency, Math.min(...get$1(byteProfile)));
        set(maxFrequency, Math.max(...get$1(byteProfile)));
        let squareDiffs = get$1(byteProfile).map((value) => Math.pow(value - get$1(mean), 2));
        set(variance, squareDiffs.reduce((a, b) => a + b, 0) / squareDiffs.length);
        set(stdDev, Math.sqrt(get$1(variance)));
        set(numDistinct, get$1(byteProfile).filter((value) => value > 0).length);
        set(colorScaleData, get$1(byteProfile).map((value) => {
          if (value < get$1(mean) - get$1(stdDev)) return "low";
          if (value > get$1(mean) + get$1(stdDev)) return "high";
          return "average";
        }));
        set(scaledData, get$1(byteProfile).map((d) => {
          return get$1(logScale) ? Math.round(Math.log2(d + 1) / Math.log2(get$1(
            maxFrequency
            // adding 1 to prevent log(0)
          ) + 1) * 300) : Math.round(d / get$1(maxFrequency) * 300);
        }));
      }
    );
    legacy_pre_effect_reset();
    init();
    var div = root$b();
    var node = child(div);
    {
      var consequent = ($$anchor2) => {
        var div_1 = root_1$6();
        var h3 = child(div_1);
        var text2 = child(h3);
        template_effect(() => set_text(text2, title()));
        append($$anchor2, div_1);
      };
      if_block(node, ($$render) => {
        if (deep_read_state(title()), untrack(() => title().length > 0)) $$render(consequent);
      });
    }
    var div_2 = sibling(node, 2);
    var node_1 = child(div_2);
    {
      var consequent_1 = ($$anchor2) => {
        var fragment = root_2$6();
        append($$anchor2, fragment);
      };
      if_block(node_1, ($$render) => {
        if (get$1(asciiOverlay)) $$render(consequent_1);
      });
    }
    var node_2 = sibling(node_1, 2);
    each(node_2, 1, () => get$1(scaledData), index, ($$anchor2, value, i) => {
      var div_3 = root_3$7();
      template_effect(() => {
        set_class(
          div_3,
          1,
          `bar ${(get$1(colorScaleData), untrack(() => get$1(colorScaleData)[i])) ?? ""}`,
          "svelte-2mj3pr"
        );
        set_style(div_3, `height: ${get$1(value) ?? ""}px;`);
      });
      event("mouseenter", div_3, () => set(currentTooltip, { index: i, value: get$1(value) }));
      event("mouseleave", div_3, () => set(currentTooltip, null));
      append($$anchor2, div_3);
    });
    var node_3 = sibling(node_2, 2);
    {
      var consequent_3 = ($$anchor2) => {
        var div_4 = root_4$7();
        var text_1 = child(div_4);
        var node_4 = sibling(text_1);
        {
          var consequent_2 = ($$anchor3) => {
            var text_2 = text();
            template_effect(($0) => set_text(text_2, `ASCII: '${$0 ?? ""}'`), [
              () => (get$1(currentTooltip), untrack(() => String.fromCharCode(get$1(currentTooltip).index)))
            ]);
            append($$anchor3, text_2);
          };
          if_block(node_4, ($$render) => {
            if (get$1(currentTooltip), untrack(() => get$1(currentTooltip).index >= 32 && get$1(currentTooltip).index <= 126)) $$render(consequent_2);
          });
        }
        template_effect(() => {
          set_style(div_4, `bottom: ${(get$1(currentTooltip), untrack(() => get$1(currentTooltip).value)) ?? ""}px;`);
          set_text(text_1, `Byte: ${(get$1(currentTooltip), untrack(() => get$1(currentTooltip).index)) ?? ""} Frequency: ${(get$1(byteProfile), get$1(currentTooltip), untrack(() => get$1(byteProfile)[get$1(currentTooltip).index])) ?? ""} `);
        });
        append($$anchor2, div_4);
      };
      if_block(node_3, ($$render) => {
        if (get$1(currentTooltip)) $$render(consequent_3);
      });
    }
    var div_5 = sibling(div_2, 4);
    var div_6 = child(div_5);
    var label = child(div_6);
    var span = sibling(child(label));
    var text_3 = child(span);
    var div_7 = sibling(div_6, 2);
    var label_1 = child(div_7);
    var span_1 = sibling(child(label_1));
    var text_4 = child(span_1);
    var node_5 = sibling(div_7, 2);
    {
      var consequent_4 = ($$anchor2) => {
        var div_8 = root_6$6();
        var label_2 = child(div_8);
        var node_6 = sibling(child(label_2));
        {
          let $0 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(startOffset()), $addressRadix(), untrack(() => startOffset().toString($addressRadix()))));
          let $1 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(radixToString), $addressRadix(), untrack(() => radixToString($addressRadix()))));
          let $2 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(startOffset()), $addressRadix(), untrack(() => startOffset().toString($addressRadix()))));
          Input(node_6, {
            id: "start-offset-input",
            get placeholder() {
              return `${get$1($0) ?? ""} (${get$1($1) ?? ""})`;
            },
            get value() {
              return get$1($2);
            },
            width: "20ch",
            autofocus: "true",
            $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
          });
        }
        append($$anchor2, div_8);
      };
      var alternate = ($$anchor2) => {
        var div_9 = root_7$5();
        var label_3 = child(div_9);
        var span_2 = sibling(child(label_3));
        var text_5 = child(span_2);
        template_effect(($0, $1) => set_text(text_5, `${$0 ?? ""} (${$1 ?? ""})`), [
          () => (deep_read_state(startOffset()), $addressRadix(), untrack(() => startOffset().toString($addressRadix()))),
          () => (deep_read_state(radixToString), $addressRadix(), untrack(() => radixToString($addressRadix())))
        ]);
        event("click", div_9, () => {
          set(fieldBeingEdited, "startOffset");
        });
        append($$anchor2, div_9);
      };
      if_block(node_5, ($$render) => {
        if (get$1(fieldBeingEdited) === "startOffset") $$render(consequent_4);
        else $$render(alternate, false);
      });
    }
    var node_7 = sibling(node_5, 2);
    {
      var consequent_5 = ($$anchor2) => {
        var div_10 = root_8$6();
        var label_4 = child(div_10);
        var node_8 = sibling(child(label_4));
        {
          let $0 = /* @__PURE__ */ derived_safe_equal(() => (get$1(endOffset), $addressRadix(), untrack(() => get$1(endOffset).toString($addressRadix()))));
          let $1 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(radixToString), $addressRadix(), untrack(() => radixToString($addressRadix()))));
          let $2 = /* @__PURE__ */ derived_safe_equal(() => (get$1(endOffset), $addressRadix(), untrack(() => get$1(endOffset).toString($addressRadix()))));
          Input(node_8, {
            id: "end-offset-input",
            get placeholder() {
              return `${get$1($0) ?? ""} (${get$1($1) ?? ""})`;
            },
            get value() {
              return get$1($2);
            },
            width: "20ch",
            autofocus: "true",
            $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
          });
        }
        append($$anchor2, div_10);
      };
      var alternate_1 = ($$anchor2) => {
        var div_11 = root_9$4();
        var label_5 = child(div_11);
        var span_3 = sibling(child(label_5));
        var text_6 = child(span_3);
        template_effect(($0, $1) => set_text(text_6, `${$0 ?? ""} (${$1 ?? ""})`), [
          () => (get$1(endOffset), $addressRadix(), untrack(() => get$1(endOffset).toString($addressRadix()))),
          () => (deep_read_state(radixToString), $addressRadix(), untrack(() => radixToString($addressRadix())))
        ]);
        event("click", div_11, () => {
          set(fieldBeingEdited, "endOffset");
        });
        append($$anchor2, div_11);
      };
      if_block(node_7, ($$render) => {
        if (get$1(fieldBeingEdited) === "endOffset") $$render(consequent_5);
        else $$render(alternate_1, false);
      });
    }
    var node_9 = sibling(node_7, 2);
    {
      var consequent_6 = ($$anchor2) => {
        var div_12 = root_10$3();
        var label_6 = child(div_12);
        var node_10 = sibling(child(label_6));
        {
          let $0 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(length()), $addressRadix(), untrack(() => length().toString($addressRadix()))));
          let $1 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(radixToString), $addressRadix(), untrack(() => radixToString($addressRadix()))));
          let $2 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(length()), $addressRadix(), untrack(() => length().toString($addressRadix()))));
          Input(node_10, {
            id: "length-input",
            get placeholder() {
              return `${get$1($0) ?? ""} (${get$1($1) ?? ""})`;
            },
            get value() {
              return get$1($2);
            },
            width: "20ch",
            autofocus: "true",
            $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
          });
        }
        append($$anchor2, div_12);
      };
      var alternate_2 = ($$anchor2) => {
        var div_13 = root_11$4();
        var label_7 = child(div_13);
        var span_4 = sibling(child(label_7));
        var text_7 = child(span_4);
        template_effect(($0, $1) => set_text(text_7, `${$0 ?? ""} (${$1 ?? ""})`), [
          () => (deep_read_state(length()), $addressRadix(), untrack(() => length().toString($addressRadix()))),
          () => (deep_read_state(radixToString), $addressRadix(), untrack(() => radixToString($addressRadix())))
        ]);
        event("click", div_13, () => {
          set(fieldBeingEdited, "length");
        });
        append($$anchor2, div_13);
      };
      if_block(node_9, ($$render) => {
        if (get$1(fieldBeingEdited) === "length") $$render(consequent_6);
        else $$render(alternate_2, false);
      });
    }
    var div_14 = sibling(div_5, 4);
    var label_8 = child(div_14);
    var span_5 = sibling(child(label_8));
    var text_8 = child(span_5);
    var label_9 = sibling(label_8, 2);
    var node_11 = sibling(child(label_9));
    {
      let $0 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(ISO6391), get$1(language), untrack(() => ISO6391.getName(get$1(language)))));
      Tooltip(node_11, {
        get description() {
          return get$1($0);
        },
        alwaysEnabled: true,
        children: ($$anchor2, $$slotProps) => {
          var span_6 = root_12$4();
          var text_9 = child(span_6);
          template_effect(() => set_text(text_9, get$1(language)));
          append($$anchor2, span_6);
        },
        $$slots: { default: true }
      });
    }
    var label_10 = sibling(label_9, 2);
    var span_7 = sibling(child(label_10));
    var text_10 = child(span_7);
    var label_11 = sibling(label_10, 2);
    var span_8 = sibling(child(label_11));
    var text_11 = child(span_8);
    var label_12 = sibling(label_11, 2);
    var span_9 = sibling(child(label_12));
    var text_12 = child(span_9);
    var label_13 = sibling(label_12, 2);
    var span_10 = sibling(child(label_13));
    var text_13 = child(span_10);
    var label_14 = sibling(label_13, 2);
    var span_11 = sibling(child(label_14));
    var text_14 = child(span_11);
    var label_15 = sibling(label_14, 2);
    var span_12 = sibling(child(label_15));
    var text_15 = child(span_12);
    var label_16 = sibling(label_15, 2);
    var span_13 = sibling(child(label_16));
    var text_16 = child(span_13);
    var label_17 = sibling(label_16, 2);
    var span_14 = sibling(child(label_17));
    var text_17 = child(span_14);
    var label_18 = sibling(label_17, 2);
    var span_15 = sibling(child(label_18));
    var text_18 = child(span_15);
    var label_19 = sibling(label_18, 2);
    var span_16 = sibling(child(label_19));
    var text_19 = child(span_16);
    var label_20 = sibling(label_19, 2);
    var span_17 = sibling(child(label_20));
    var text_20 = child(span_17);
    var div_15 = sibling(div_14, 4);
    var label_21 = child(div_15);
    var span_18 = sibling(child(label_21));
    var text_21 = child(span_18);
    var label_22 = sibling(label_21, 2);
    var span_19 = sibling(child(label_22));
    var text_22 = child(span_19);
    var label_23 = sibling(label_22, 2);
    var span_20 = sibling(child(label_23));
    var text_23 = child(span_20);
    var label_24 = sibling(label_23, 2);
    var span_21 = sibling(child(label_24));
    var text_24 = child(span_21);
    var label_25 = sibling(label_24, 2);
    var span_22 = sibling(child(label_25));
    var text_25 = child(span_22);
    var label_26 = sibling(label_25, 2);
    var span_23 = sibling(child(label_26));
    var text_26 = child(span_23);
    var label_27 = sibling(label_26, 2);
    var span_24 = sibling(child(label_27));
    var text_27 = child(span_24);
    var node_12 = sibling(div_15, 4);
    Button(node_12, {
      fn: handleCsvProfileDownload,
      description: "Download profiled data as .csv",
      children: ($$anchor2, $$slotProps) => {
        var span_25 = root_13$4();
        append($$anchor2, span_25);
      },
      $$slots: {
        default: true,
        left: ($$anchor2, $$slotProps) => {
          var span_26 = root_14$4();
          append($$anchor2, span_26);
        }
      }
    });
    var node_13 = sibling(node_12, 2);
    Button(node_13, {
      fn: saveSegmentAs,
      description: "Save segment as",
      children: ($$anchor2, $$slotProps) => {
        var span_27 = root_15$4();
        append($$anchor2, span_27);
      },
      $$slots: {
        default: true,
        left: ($$anchor2, $$slotProps) => {
          var span_28 = root_16$4();
          append($$anchor2, span_28);
        }
      }
    });
    var node_14 = sibling(node_13, 4);
    {
      var consequent_7 = ($$anchor2) => {
        var div_16 = root_17$4();
        var text_28 = child(div_16);
        template_effect(() => set_text(text_28, ` ${get$1(statusMessage) ?? ""} `));
        append($$anchor2, div_16);
      };
      if_block(node_14, ($$render) => {
        if (get$1(statusMessage), untrack(() => get$1(statusMessage).length > 0)) $$render(consequent_7);
      });
    }
    var node_15 = sibling(node_14, 2);
    {
      var consequent_8 = ($$anchor2) => {
        var div_17 = root_18$3();
        var text_29 = child(div_17);
        template_effect(() => set_text(text_29, ` ${get$1(warningMessage) ?? ""} `));
        append($$anchor2, div_17);
      };
      if_block(node_15, ($$render) => {
        if (get$1(warningMessage), untrack(() => get$1(warningMessage).length > 0)) $$render(consequent_8);
      });
    }
    var node_16 = sibling(node_15, 2);
    {
      var consequent_9 = ($$anchor2) => {
        var div_18 = root_19$2();
        var text_30 = child(div_18);
        template_effect(() => set_text(text_30, ` ${get$1(errorMessage) ?? ""} `));
        append($$anchor2, div_18);
      };
      if_block(node_16, ($$render) => {
        if (get$1(errorMessage), untrack(() => get$1(errorMessage).length > 0)) $$render(consequent_9);
      });
    }
    template_effect(
      ($0, $1, $2, $3, $4, $5) => {
        set_text(text_3, get$1(logScale) ? "Logarithmic" : "Linear");
        set_text(text_4, get$1(asciiOverlay) ? "ASCII" : "None");
        set_text(text_8, `${$0 ?? ""} (${$1 ?? ""})`);
        set_text(text_10, get$1(contentType));
        set_text(text_11, get$1(minFrequency));
        set_text(text_12, get$1(maxFrequency));
        set_text(text_13, $2);
        set_text(text_14, $3);
        set_text(text_15, $4);
        set_text(text_16, get$1(sum));
        set_text(text_17, get$1(numDistinct));
        set_text(text_18, (get$1(byteProfile), untrack(() => get$1(byteProfile)[PROFILE_DOS_EOL])));
        set_text(text_19, get$1(numAscii));
        set_text(text_20, $5);
        set_text(text_21, (get$1(characterCountData), untrack(() => get$1(characterCountData).byteOrderMark)));
        set_text(text_22, (get$1(characterCountData), untrack(() => get$1(characterCountData).byteOrderMarkBytes)));
        set_text(text_23, (get$1(characterCountData), untrack(() => get$1(characterCountData).singleByteCount)));
        set_text(text_24, (get$1(characterCountData), untrack(() => get$1(characterCountData).doubleByteCount)));
        set_text(text_25, (get$1(characterCountData), untrack(() => get$1(characterCountData).tripleByteCount)));
        set_text(text_26, (get$1(characterCountData), untrack(() => get$1(characterCountData).quadByteCount)));
        set_text(text_27, (get$1(characterCountData), untrack(() => get$1(characterCountData).invalidBytes)));
      },
      [
        () => (deep_read_state(viewport), $addressRadix(), untrack(() => viewport.offsetMax.toString($addressRadix()))),
        () => (deep_read_state(radixToString), $addressRadix(), untrack(() => radixToString($addressRadix()))),
        () => (get$1(mean), untrack(() => get$1(mean).toFixed(2))),
        () => (get$1(variance), untrack(() => get$1(variance).toFixed(2))),
        () => (get$1(stdDev), untrack(() => get$1(stdDev).toFixed(2))),
        () => (get$1(numAscii), get$1(sum), untrack(() => (get$1(numAscii) / get$1(sum) * 100).toFixed(2)))
      ]
    );
    event("click", span, () => {
      set(logScale, !get$1(logScale));
    });
    event("click", span_1, () => {
      set(asciiOverlay, !get$1(asciiOverlay));
    });
    append($$anchor, div);
    pop();
    $$cleanup();
  }
  var root_3$6 = /* @__PURE__ */ from_html(`<span id="file_name" class="nowrap svelte-1ctws1l"> </span>&nbsp;`, 1);
  var root_6$5 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Save</span>`);
  var root_7$4 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">save</span>`);
  var root_8$5 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Save As</span>`);
  var root_9$3 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">save_as</span>`);
  var root_5$4 = /* @__PURE__ */ from_html(`<!> <!>`, 1);
  var root_11$3 = /* @__PURE__ */ from_html(`<span slot="default">Save&hellip;</span>`);
  var root_12$3 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">save</span>`);
  var root_15$3 = /* @__PURE__ */ from_html(`<label for="disk_file_size" class="svelte-1ctws1l">Disk Size</label>`);
  var root_16$3 = /* @__PURE__ */ from_html(`<span id="disk_file_size" class="nowrap svelte-1ctws1l"> </span>`);
  var root_14$3 = /* @__PURE__ */ from_html(`<!> <!>`, 1);
  var root_18$2 = /* @__PURE__ */ from_html(`<label for="computed_file_size" class="svelte-1ctws1l">Computed Size</label>`);
  var root_19$1 = /* @__PURE__ */ from_html(`<span id="computed_file_size" class="nowrap svelte-1ctws1l"> </span>`);
  var root_17$3 = /* @__PURE__ */ from_html(`<!> <!>`, 1);
  var root_21$1 = /* @__PURE__ */ from_html(`<span id="content_type" class="nowrap svelte-1ctws1l"> </span>`);
  var root_20$1 = /* @__PURE__ */ from_html(`<label for="content_type" class="svelte-1ctws1l">Content Type</label> <!>`, 1);
  var root_23$1 = /* @__PURE__ */ from_html(`<span id="language" class="nowrap svelte-1ctws1l"> </span>`);
  var root_22$1 = /* @__PURE__ */ from_html(`<label for="language" class="svelte-1ctws1l">Language</label> <!>`, 1);
  var root_13$3 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  var root_27 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Redo</span>`);
  var root_28 = /* @__PURE__ */ from_html(`<span slot="left" class="icon-container"><span class="btn-icon material-symbols-outlined">redo</span> <div class="icon-badge"> </div></span>`);
  var root_29 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Undo</span>`);
  var root_30 = /* @__PURE__ */ from_html(`<span slot="left" class="icon-container"><span class="btn-icon material-symbols-outlined">undo</span> <div class="icon-badge"> </div></span>`);
  var root_31 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Revert All</span>`);
  var root_32 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">restart_alt</span>`);
  var root_26 = /* @__PURE__ */ from_html(`<!> <!> <!>`, 1);
  var root_25$1 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  var root_34 = /* @__PURE__ */ from_html(`<span slot="default">Profile</span>`);
  var root_35 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">functions</span>`);
  var root_24$1 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  var root$a = /* @__PURE__ */ from_html(`<!> <fieldset class="file-metrics svelte-1ctws1l"><legend>File Metrics</legend> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <hr/> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper> <hr/> <!></fieldset>`, 1);
  function FileMetrics($$anchor, $$props) {
    push($$props, false);
    const $fileMetrics = () => store_get(fileMetrics, "$fileMetrics", $$stores);
    const $saveable = () => store_get(saveable, "$saveable", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const eventDispatcher = createEventDispatcher();
    let displayOpts = /* @__PURE__ */ mutable_source(false);
    let isProfilerOpen = /* @__PURE__ */ mutable_source(false);
    let canUndo = /* @__PURE__ */ mutable_source();
    let canRedo = /* @__PURE__ */ mutable_source();
    let canRevert = /* @__PURE__ */ mutable_source();
    let startOffset = /* @__PURE__ */ mutable_source(0);
    let length = /* @__PURE__ */ mutable_source(0);
    function saveAs() {
      vscode.postMessage({ command: MessageCommand.saveAs });
      set(displayOpts, false);
    }
    function save() {
      vscode.postMessage({ command: MessageCommand.save });
      set(displayOpts, false);
    }
    function toggleSaveDisplay() {
      set(displayOpts, !get$1(displayOpts));
      if (get$1(displayOpts)) {
        setTimeout(
          () => {
            set(displayOpts, false);
          },
          1e4
        );
      }
    }
    window.addEventListener("message", (msg) => {
      switch (msg.data.command) {
        case MessageCommand.fileInfo:
          {
            set(isProfilerOpen, false);
            set(startOffset, set(length, 0));
            if ("fileName" in msg.data.data) {
              store_mutate(fileMetrics, untrack($fileMetrics).name = msg.data.data.fileName, untrack($fileMetrics));
            }
            if ("type" in msg.data.data) {
              store_mutate(fileMetrics, untrack($fileMetrics).type = msg.data.data.type, untrack($fileMetrics));
            }
            if ("language" in msg.data.data) {
              store_mutate(fileMetrics, untrack($fileMetrics).language = msg.data.data.language, untrack($fileMetrics));
            }
            if ("diskFileSize" in msg.data.data) {
              store_mutate(fileMetrics, untrack($fileMetrics).diskSize = msg.data.data.diskFileSize, untrack($fileMetrics));
            }
            if ("computedFileSize" in msg.data.data) {
              store_mutate(fileMetrics, untrack($fileMetrics).computedSize = msg.data.data.computedFileSize, untrack($fileMetrics));
            }
            if ("changeCount" in msg.data.data) {
              store_mutate(fileMetrics, untrack($fileMetrics).changeCount = msg.data.data.changeCount, untrack($fileMetrics));
            }
            if ("undoCount" in msg.data.data) {
              store_mutate(fileMetrics, untrack($fileMetrics).undoCount = msg.data.data.undoCount, untrack($fileMetrics));
            }
          }
          break;
      }
    });
    function redo() {
      eventDispatcher("redo");
    }
    function undo() {
      eventDispatcher("undo");
    }
    function clearChangeStack() {
      eventDispatcher("clearChangeStack");
    }
    function toggleDataProfiler() {
      set(isProfilerOpen, !get$1(isProfilerOpen));
    }
    legacy_pre_effect(() => ($fileMetrics(), get$1(length), get$1(startOffset)), () => {
      set(canUndo, $fileMetrics().changeCount > 0);
      set(canRedo, $fileMetrics().undoCount > 0);
      set(canRevert, $fileMetrics().undoCount + $fileMetrics().changeCount > 0);
      set(length, get$1(length) <= 0 ? viewport.offsetMax - get$1(startOffset) : get$1(length));
    });
    legacy_pre_effect_reset();
    init();
    var fragment = root$a();
    var node = first_child(fragment);
    SidePanel(node, {
      position: "top-left",
      title: "Data Profiler",
      panelWidth: "285px",
      get open() {
        return get$1(isProfilerOpen);
      },
      set open($$value) {
        set(isProfilerOpen, $$value);
      },
      children: ($$anchor2, $$slotProps) => {
        var fragment_1 = comment();
        var node_1 = first_child(fragment_1);
        {
          var consequent = ($$anchor3) => {
            {
              let $0 = /* @__PURE__ */ derived_safe_equal(() => (get$1(length), deep_read_state(DATA_PROFILE_MAX_LENGTH), untrack(() => Math.min(get$1(length), DATA_PROFILE_MAX_LENGTH))));
              DataMetrics($$anchor3, {
                title: "Byte Frequency Profile",
                get startOffset() {
                  return get$1(startOffset);
                },
                get length() {
                  return get$1($0);
                }
              });
            }
          };
          if_block(node_1, ($$render) => {
            if (get$1(isProfilerOpen)) $$render(consequent);
          });
        }
        append($$anchor2, fragment_1);
      },
      $$slots: { default: true },
      $$legacy: true
    });
    var fieldset = sibling(node, 2);
    var node_2 = sibling(child(fieldset), 2);
    {
      css_props(node_2, () => ({ "--dir": "row" }));
      FlexContainer(node_2.lastChild, {
        children: ($$anchor2, $$slotProps) => {
          var fragment_3 = root_3$6();
          var span = first_child(fragment_3);
          var text2 = child(span);
          template_effect(() => set_text(text2, ($fileMetrics(), untrack(() => $fileMetrics().name))));
          append($$anchor2, fragment_3);
        },
        $$slots: { default: true }
      });
    }
    var node_3 = sibling(node_2, 2);
    {
      css_props(node_3, () => ({ "--dir": "row", "--align-items": "center" }));
      FlexContainer(node_3.lastChild, {
        children: ($$anchor2, $$slotProps) => {
          var fragment_4 = comment();
          var node_4 = first_child(fragment_4);
          {
            var consequent_1 = ($$anchor3) => {
              var fragment_5 = root_5$4();
              var node_5 = first_child(fragment_5);
              {
                let $0 = /* @__PURE__ */ derived_safe_equal(() => !$saveable());
                Button(node_5, {
                  fn: save,
                  get disabledBy() {
                    return get$1($0);
                  },
                  description: "Save to disk",
                  children: ($$anchor4, $$slotProps2) => {
                    var span_1 = root_6$5();
                    append($$anchor4, span_1);
                  },
                  $$slots: {
                    default: true,
                    left: ($$anchor4, $$slotProps2) => {
                      var span_2 = root_7$4();
                      append($$anchor4, span_2);
                    }
                  }
                });
              }
              var node_6 = sibling(node_5, 2);
              Button(node_6, {
                fn: saveAs,
                description: "Save as",
                children: ($$anchor4, $$slotProps2) => {
                  var span_3 = root_8$5();
                  append($$anchor4, span_3);
                },
                $$slots: {
                  default: true,
                  left: ($$anchor4, $$slotProps2) => {
                    var span_4 = root_9$3();
                    append($$anchor4, span_4);
                  }
                }
              });
              append($$anchor3, fragment_5);
            };
            var alternate = ($$anchor3) => {
              Button($$anchor3, {
                fn: toggleSaveDisplay,
                description: "Save",
                children: ($$anchor4, $$slotProps2) => {
                  var span_5 = root_11$3();
                  append($$anchor4, span_5);
                },
                $$slots: {
                  default: true,
                  left: ($$anchor4, $$slotProps2) => {
                    var span_6 = root_12$3();
                    append($$anchor4, span_6);
                  }
                }
              });
            };
            if_block(node_4, ($$render) => {
              if (get$1(displayOpts)) $$render(consequent_1);
              else $$render(alternate, false);
            });
          }
          append($$anchor2, fragment_4);
        },
        $$slots: { default: true }
      });
    }
    var node_7 = sibling(node_3, 4);
    {
      css_props(node_7, () => ({ "--dir": "row" }));
      FlexContainer(node_7.lastChild, {
        children: ($$anchor2, $$slotProps) => {
          var fragment_7 = root_13$3();
          var node_8 = first_child(fragment_7);
          {
            css_props(node_8, () => ({ "--dir": "column" }));
            FlexContainer(node_8.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_8 = root_14$3();
                var node_9 = first_child(fragment_8);
                Tooltip(node_9, {
                  description: "Initial file size",
                  alwaysEnabled: true,
                  children: ($$anchor4, $$slotProps3) => {
                    var label = root_15$3();
                    append($$anchor4, label);
                  },
                  $$slots: { default: true }
                });
                var node_10 = sibling(node_9, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => ($fileMetrics(), untrack(() => $fileMetrics().diskSize.toLocaleString("en"))));
                  Tooltip(node_10, {
                    get description() {
                      return `${get$1($0) ?? ""} bytes`;
                    },
                    alwaysEnabled: true,
                    children: ($$anchor4, $$slotProps3) => {
                      var span_7 = root_16$3();
                      var text_1 = child(span_7);
                      template_effect(($02) => set_text(text_1, $02), [
                        () => (deep_read_state(humanReadableByteLength), $fileMetrics(), untrack(() => humanReadableByteLength($fileMetrics().diskSize)))
                      ]);
                      append($$anchor4, span_7);
                    },
                    $$slots: { default: true }
                  });
                }
                append($$anchor3, fragment_8);
              },
              $$slots: { default: true }
            });
          }
          var node_11 = sibling(node_8, 2);
          {
            css_props(node_11, () => ({ "--dir": "column" }));
            FlexContainer(node_11.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_9 = root_17$3();
                var node_12 = first_child(fragment_9);
                Tooltip(node_12, {
                  description: "Size as file is being edited",
                  alwaysEnabled: true,
                  children: ($$anchor4, $$slotProps3) => {
                    var label_1 = root_18$2();
                    append($$anchor4, label_1);
                  },
                  $$slots: { default: true }
                });
                var node_13 = sibling(node_12, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => ($fileMetrics(), untrack(() => $fileMetrics().computedSize.toLocaleString("en"))));
                  Tooltip(node_13, {
                    get description() {
                      return `${get$1($0) ?? ""} bytes`;
                    },
                    alwaysEnabled: true,
                    children: ($$anchor4, $$slotProps3) => {
                      var span_8 = root_19$1();
                      var text_2 = child(span_8);
                      template_effect(($02) => set_text(text_2, $02), [
                        () => (deep_read_state(humanReadableByteLength), $fileMetrics(), untrack(() => humanReadableByteLength($fileMetrics().computedSize)))
                      ]);
                      append($$anchor4, span_8);
                    },
                    $$slots: { default: true }
                  });
                }
                append($$anchor3, fragment_9);
              },
              $$slots: { default: true }
            });
          }
          var node_14 = sibling(node_11, 2);
          {
            css_props(node_14, () => ({ "--dir": "column" }));
            FlexContainer(node_14.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_10 = root_20$1();
                var node_15 = sibling(first_child(fragment_10), 2);
                Tooltip(node_15, {
                  get description() {
                    return $fileMetrics(), untrack(() => $fileMetrics().type);
                  },
                  alwaysEnabled: true,
                  children: ($$anchor4, $$slotProps3) => {
                    var span_9 = root_21$1();
                    var text_3 = child(span_9);
                    template_effect(($0) => set_text(text_3, $0), [
                      () => ($fileMetrics(), untrack(() => $fileMetrics().type.split("/").pop()))
                    ]);
                    append($$anchor4, span_9);
                  },
                  $$slots: { default: true }
                });
                append($$anchor3, fragment_10);
              },
              $$slots: { default: true }
            });
          }
          var node_16 = sibling(node_14, 2);
          {
            css_props(node_16, () => ({ "--dir": "column" }));
            FlexContainer(node_16.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_11 = root_22$1();
                var node_17 = sibling(first_child(fragment_11), 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(ISO6391), $fileMetrics(), untrack(() => ISO6391.getName($fileMetrics().language))));
                  Tooltip(node_17, {
                    get description() {
                      return get$1($0);
                    },
                    alwaysEnabled: true,
                    children: ($$anchor4, $$slotProps3) => {
                      var span_10 = root_23$1();
                      var text_4 = child(span_10);
                      template_effect(() => set_text(text_4, ($fileMetrics(), untrack(() => $fileMetrics().language))));
                      append($$anchor4, span_10);
                    },
                    $$slots: { default: true }
                  });
                }
                append($$anchor3, fragment_11);
              },
              $$slots: { default: true }
            });
          }
          append($$anchor2, fragment_7);
        },
        $$slots: { default: true }
      });
    }
    var node_18 = sibling(node_7, 4);
    FlexContainer(node_18, {
      children: ($$anchor2, $$slotProps) => {
        var fragment_12 = root_24$1();
        var node_19 = first_child(fragment_12);
        {
          css_props(node_19, () => ({ "--dir": "column", "--align-items": "center" }));
          FlexContainer(node_19.lastChild, {
            children: ($$anchor3, $$slotProps2) => {
              var fragment_13 = root_25$1();
              var node_20 = first_child(fragment_13);
              {
                css_props(node_20, () => ({ "--dir": "row" }));
                FlexContainer(node_20.lastChild, {
                  children: ($$anchor4, $$slotProps3) => {
                    var fragment_14 = root_26();
                    var node_21 = first_child(fragment_14);
                    {
                      let $0 = /* @__PURE__ */ derived_safe_equal(() => !get$1(canRedo));
                      Button(node_21, {
                        get disabledBy() {
                          return get$1($0);
                        },
                        fn: redo,
                        description: "Redo change",
                        children: ($$anchor5, $$slotProps4) => {
                          var span_11 = root_27();
                          append($$anchor5, span_11);
                        },
                        $$slots: {
                          default: true,
                          left: ($$anchor5, $$slotProps4) => {
                            var span_12 = root_28();
                            var div = sibling(child(span_12), 2);
                            var text_5 = child(div);
                            template_effect(() => set_text(text_5, ($fileMetrics(), untrack(() => $fileMetrics().undoCount))));
                            append($$anchor5, span_12);
                          }
                        }
                      });
                    }
                    var node_22 = sibling(node_21, 2);
                    {
                      let $0 = /* @__PURE__ */ derived_safe_equal(() => !get$1(canUndo));
                      Button(node_22, {
                        get disabledBy() {
                          return get$1($0);
                        },
                        fn: undo,
                        description: "Undo change",
                        children: ($$anchor5, $$slotProps4) => {
                          var span_13 = root_29();
                          append($$anchor5, span_13);
                        },
                        $$slots: {
                          default: true,
                          left: ($$anchor5, $$slotProps4) => {
                            var span_14 = root_30();
                            var div_1 = sibling(child(span_14), 2);
                            var text_6 = child(div_1);
                            template_effect(() => set_text(text_6, ($fileMetrics(), untrack(() => $fileMetrics().changeCount))));
                            append($$anchor5, span_14);
                          }
                        }
                      });
                    }
                    var node_23 = sibling(node_22, 2);
                    {
                      let $0 = /* @__PURE__ */ derived_safe_equal(() => !get$1(canRevert));
                      Button(node_23, {
                        get disabledBy() {
                          return get$1($0);
                        },
                        fn: clearChangeStack,
                        description: "Revert all changes",
                        children: ($$anchor5, $$slotProps4) => {
                          var span_15 = root_31();
                          append($$anchor5, span_15);
                        },
                        $$slots: {
                          default: true,
                          left: ($$anchor5, $$slotProps4) => {
                            var span_16 = root_32();
                            append($$anchor5, span_16);
                          }
                        }
                      });
                    }
                    append($$anchor4, fragment_14);
                  },
                  $$slots: { default: true }
                });
              }
              append($$anchor3, fragment_13);
            },
            $$slots: { default: true }
          });
        }
        var node_24 = sibling(node_19, 2);
        {
          css_props(node_24, () => ({ "--dir": "column", "--align-items": "end" }));
          FlexContainer(node_24.lastChild, {
            children: ($$anchor3, $$slotProps2) => {
              Button($$anchor3, {
                fn: toggleDataProfiler,
                description: "Open data profiler",
                children: ($$anchor4, $$slotProps3) => {
                  var span_17 = root_34();
                  append($$anchor4, span_17);
                },
                $$slots: {
                  default: true,
                  left: ($$anchor4, $$slotProps3) => {
                    var span_18 = root_35();
                    append($$anchor4, span_18);
                  }
                }
              });
            },
            $$slots: { default: true }
          });
        }
        append($$anchor2, fragment_12);
      },
      $$slots: { default: true }
    });
    append($$anchor, fragment);
    pop();
    $$cleanup();
  }
  var root_4$6 = /* @__PURE__ */ from_html(`<button><span class="material-symbols-outlined">expand_all</span></button>`);
  var root_3$5 = /* @__PURE__ */ from_html(`<div class="filename-display svelte-oys6o3"><b>File:</b> </div> <!>`, 1);
  var root_2$5 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  var root_7$3 = /* @__PURE__ */ from_html(`<!> <!> <!>`, 1);
  var root_8$4 = /* @__PURE__ */ from_html(`<button><span class="material-symbols-outlined"><!></span></button>`);
  var root_6$4 = /* @__PURE__ */ from_html(`<header class="svelte-oys6o3"><svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper></header> <div class="display-icons"><!></div>`, 1);
  var root_5$3 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  function Header($$anchor, $$props) {
    push($$props, false);
    const $fileMetrics = () => store_get(fileMetrics, "$fileMetrics", $$stores);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    let hideChildren = /* @__PURE__ */ mutable_source(false);
    init();
    var fragment = comment();
    var node = first_child(fragment);
    {
      var consequent = ($$anchor2) => {
        FlexContainer($$anchor2, {
          children: ($$anchor3, $$slotProps) => {
            var fragment_2 = root_2$5();
            var node_1 = first_child(fragment_2);
            {
              css_props(node_1, () => ({
                "--justify-content": "space-between",
                "--align-items": "center"
              }));
              FlexContainer(node_1.lastChild, {
                children: ($$anchor4, $$slotProps2) => {
                  var fragment_3 = root_3$5();
                  var div = first_child(fragment_3);
                  var text2 = sibling(child(div));
                  var node_2 = sibling(div, 2);
                  Tooltip(node_2, {
                    alwaysEnabled: true,
                    description: "Maximize header",
                    children: ($$anchor5, $$slotProps3) => {
                      var button = root_4$6();
                      template_effect(() => set_class(button, 1, $UIThemeCSSClass() + " minmax-icon", "svelte-oys6o3"));
                      event("click", button, () => {
                        set(hideChildren, get$1(hideChildren) ? false : true);
                      });
                      append($$anchor5, button);
                    },
                    $$slots: { default: true }
                  });
                  template_effect(() => set_text(text2, ` ${$fileMetrics().name ?? ""}`));
                  append($$anchor4, fragment_3);
                },
                $$slots: { default: true }
              });
            }
            append($$anchor3, fragment_2);
          },
          $$slots: { default: true }
        });
      };
      var alternate_1 = ($$anchor2) => {
        var fragment_4 = root_5$3();
        var node_3 = first_child(fragment_4);
        {
          css_props(node_3, () => ({ "--height": "150pt" }));
          FlexContainer(node_3.lastChild, {
            children: ($$anchor3, $$slotProps) => {
              var fragment_5 = root_6$4();
              var header = first_child(fragment_5);
              var node_4 = child(header);
              {
                css_props(node_4, () => ({ "--height": "fit-content" }));
                FlexContainer(node_4.lastChild, {
                  children: ($$anchor4, $$slotProps2) => {
                    var fragment_6 = root_7$3();
                    var node_5 = first_child(fragment_6);
                    FileMetrics(node_5, {
                      $$events: {
                        clearChangeStack($$arg) {
                          bubble_event.call(this, $$props, $$arg);
                        },
                        redo($$arg) {
                          bubble_event.call(this, $$props, $$arg);
                        },
                        undo($$arg) {
                          bubble_event.call(this, $$props, $$arg);
                        }
                      }
                    });
                    var node_6 = sibling(node_5, 2);
                    SearchReplace(node_6, {
                      $$events: {
                        seek($$arg) {
                          bubble_event.call(this, $$props, $$arg);
                        },
                        clearDataDisplays($$arg) {
                          bubble_event.call(this, $$props, $$arg);
                        }
                      }
                    });
                    var node_7 = sibling(node_6, 2);
                    Settings(node_7, {
                      $$events: {
                        seek($$arg) {
                          bubble_event.call(this, $$props, $$arg);
                        }
                      }
                    });
                    append($$anchor4, fragment_6);
                  },
                  $$slots: { default: true }
                });
              }
              var div_1 = sibling(header, 2);
              var node_8 = child(div_1);
              Tooltip(node_8, {
                alwaysEnabled: true,
                description: "Minimize header",
                children: ($$anchor4, $$slotProps2) => {
                  var button_1 = root_8$4();
                  var span = child(button_1);
                  var node_9 = child(span);
                  {
                    var consequent_1 = ($$anchor5) => {
                      var text_1 = text("expand_all");
                      append($$anchor5, text_1);
                    };
                    var alternate = ($$anchor5) => {
                      var text_2 = text("expand_less");
                      append($$anchor5, text_2);
                    };
                    if_block(node_9, ($$render) => {
                      if (get$1(hideChildren)) $$render(consequent_1);
                      else $$render(alternate, false);
                    });
                  }
                  template_effect(() => set_class(button_1, 1, $UIThemeCSSClass() + " minmax-icon", "svelte-oys6o3"));
                  event("click", button_1, () => {
                    set(hideChildren, !get$1(hideChildren));
                  });
                  append($$anchor4, button_1);
                },
                $$slots: { default: true }
              });
              append($$anchor3, fragment_5);
            },
            $$slots: { default: true }
          });
        }
        append($$anchor2, fragment_4);
      };
      if_block(node, ($$render) => {
        if (get$1(hideChildren)) $$render(consequent);
        else $$render(alternate_1, false);
      });
    }
    append($$anchor, fragment);
    pop();
    $$cleanup();
  }
  var root_1$5 = /* @__PURE__ */ from_html(`<span class="errMsg"> </span>`);
  var root_4$5 = /* @__PURE__ */ from_html(`<span slot="default">&nbsp;Apply</span>`);
  var root_5$2 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined">commit</span>`);
  var root$9 = /* @__PURE__ */ from_html(`<fieldset class="box margin-top"><legend>Content Controls <!></legend> <!></fieldset>`);
  function ContentControls($$anchor, $$props) {
    push($$props, false);
    const $applicable = () => store_get(applicable, "$applicable", $$stores);
    const $editMode = () => store_get(editMode, "$editMode", $$stores);
    const $applyErrMsg = () => store_get(applyErrMsg, "$applyErrMsg", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const eventDispatcher = createEventDispatcher();
    function applyChanges(event2) {
      eventDispatcher("applyChanges", { action: "insert-replace" });
    }
    init();
    var fieldset = root$9();
    var legend = child(fieldset);
    var node = sibling(child(legend));
    {
      var consequent = ($$anchor2) => {
        var span = root_1$5();
        var text2 = child(span);
        template_effect(() => set_text(text2, $applyErrMsg()));
        append($$anchor2, span);
      };
      if_block(node, ($$render) => {
        if (!$applicable() && $editMode() === EditByteModes.Multiple) $$render(consequent);
      });
    }
    var node_1 = sibling(legend, 2);
    {
      var consequent_1 = ($$anchor2) => {
        FlexContainer($$anchor2, {
          children: ($$anchor3, $$slotProps) => {
            {
              let $0 = /* @__PURE__ */ derived_safe_equal(() => !$applicable());
              Button($$anchor3, {
                get disabledBy() {
                  return get$1($0);
                },
                fn: (e) => {
                  applyChanges();
                },
                description: "Apply changes",
                children: ($$anchor4, $$slotProps2) => {
                  var span_1 = root_4$5();
                  append($$anchor4, span_1);
                },
                $$slots: {
                  default: true,
                  left: ($$anchor4, $$slotProps2) => {
                    var span_2 = root_5$2();
                    append($$anchor4, span_2);
                  }
                }
              });
            }
          },
          $$slots: { default: true }
        });
      };
      if_block(node_1, ($$render) => {
        if ($editMode() === EditByteModes.Multiple) $$render(consequent_1);
      });
    }
    append($$anchor, fieldset);
    pop();
    $$cleanup();
  }
  var root_2$4 = /* @__PURE__ */ from_html(`<b> </b><br/>`, 1);
  var root_3$4 = /* @__PURE__ */ from_html(`<option> </option>`);
  var root_5$1 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="latin1_dv">latin-1:</label> <!></div>`);
  var root_6$3 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f" id="latin1"><label for="latin1_dv_ro">latin-1:</label> <span id="latin1_dv_ro" class="editable"> </span></div>`);
  var root_7$2 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="int8_dv">&nbsp;&nbsp;&nbsp;int8:</label> <!></div>`);
  var root_8$3 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="int8_dv_ro">&nbsp;&nbsp;&nbsp;int8:</label> <span id="int8_dv_ro" class="editable"> </span></div>`);
  var root_9$2 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="uint8_dv">&nbsp;&nbsp;uint8:</label> <!></div>`);
  var root_10$2 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="uint8_dv_ro">&nbsp;&nbsp;uint8:</label> <span id="uint8_dv_ro" class="editable"> </span></div>`);
  var root_12$2 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="int16_dv">&nbsp;&nbsp;int16:</label> <!></div>`);
  var root_13$2 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="int16_dv_ro">&nbsp;&nbsp;int16:</label> <span id="int16_dv_ro" class="editable"> </span></div>`);
  var root_14$2 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="uint16_dv">&nbsp;uint16:</label> <!></div>`);
  var root_15$2 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="uint16_dv_ro">&nbsp;uint16:</label> <span id="uint16_dv_ro" class="editable"> </span></div>`);
  var root_11$2 = /* @__PURE__ */ from_html(`<!> <!>`, 1);
  var root_17$2 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="int32_dv">&nbsp;&nbsp;int32:</label> <!></div>`);
  var root_18$1 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="int32_dv_ro">&nbsp;&nbsp;int32:</label> <span id="int32_dv_ro" class="editable"> </span></div>`);
  var root_19 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="uint32_dv">&nbsp;uint32:</label> <!></div>`);
  var root_20 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="uint32_dv_ro">&nbsp;uint32:</label> <span id="uint32_dv_ro" class="editable"> </span></div>`);
  var root_16$2 = /* @__PURE__ */ from_html(`<!> <!>`, 1);
  var root_22 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="int64_dv">&nbsp;&nbsp;int64:</label> <!></div>`);
  var root_23 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="int64_dv_ro">&nbsp;&nbsp;int64:</label> <span id="int64_dv_ro" class="editable"> </span></div>`);
  var root_24 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="uint64_dv">&nbsp;uint64:</label> <!></div>`);
  var root_25 = /* @__PURE__ */ from_html(`<div class="input-container svelte-1f4rc2f"><label for="uint64_dv_ro">&nbsp;uint64:</label> <span id="uint64_dv_ro" class="editable"> </span></div>`);
  var root_21 = /* @__PURE__ */ from_html(`<!> <!>`, 1);
  var root_4$4 = /* @__PURE__ */ from_html(`<!> <!> <!> <!> <!> <!>`, 1);
  var root$8 = /* @__PURE__ */ from_html(`<fieldset class="box margin-top"><legend>Data <!></legend> <!> <div class="input-container svelte-1f4rc2f"><label for="endian">&nbsp;endian:</label><select id="endian"></select></div> <!></fieldset>`);
  function DataView_1($$anchor, $$props) {
    push($$props, false);
    const $displayRadix = () => store_get(displayRadix, "$displayRadix", $$stores);
    const $dataViewEndianness = () => store_get(dataViewEndianness, "$dataViewEndianness", $$stores);
    const $selectedByte = () => store_get(selectedByte, "$selectedByte", $$stores);
    const $dvOffset = () => store_get(dvOffset, "$dvOffset", $$stores);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const $selectionDataStore = () => store_get(selectionDataStore, "$selectionDataStore", $$stores);
    const $dvInt8 = () => store_get(dvInt8, "$dvInt8", $$stores);
    const $dvLatin1 = () => store_get(dvLatin1, "$dvLatin1", $$stores);
    const $dvUint8 = () => store_get(dvUint8, "$dvUint8", $$stores);
    const $dvInt16 = () => store_get(dvInt16, "$dvInt16", $$stores);
    const $dvUint16 = () => store_get(dvUint16, "$dvUint16", $$stores);
    const $dvInt32 = () => store_get(dvInt32, "$dvInt32", $$stores);
    const $dvUint32 = () => store_get(dvUint32, "$dvUint32", $$stores);
    const $dvInt64 = () => store_get(dvInt64, "$dvInt64", $$stores);
    const $dvUint64 = () => store_get(dvUint64, "$dvUint64", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const eventDispatcher = createEventDispatcher();
    const ERROR_MESSAGE_TIMEOUT = 5e3;
    const INPUT_WIDTH = "64ch";
    let errorMessage = /* @__PURE__ */ mutable_source();
    let isEditing = /* @__PURE__ */ mutable_source("");
    function handleSubmit(inputValue, intType) {
      const rangeChecks = {
        int8: [1, -128, 127],
        uint8: [1, 0, 255],
        int16: [2, -32768, 32767],
        uint16: [2, 0, 65535],
        int32: [4, -2147483648, 2147483647],
        uint32: [4, 0, 4294967295],
        int64: [8, -9223372036854776e3, 9223372036854776e3],
        uint64: [8, 0, 18446744073709552e3]
      };
      let value = NaN;
      set(isEditing, "");
      if (intType === "latin1") {
        if (inputValue.length !== 1) {
          set(errorMessage, `Value out of range for ${intType} (${displayRadix}): ${inputValue}`);
          setTimeout(
            () => {
              set(errorMessage, "");
            },
            ERROR_MESSAGE_TIMEOUT
          );
          return false;
        }
        value = inputValue.charCodeAt(0);
        intType = "uint8";
      } else {
        value = parseInt(inputValue, $displayRadix());
      }
      if (!isNaN(value) && rangeChecks.hasOwnProperty(intType)) {
        const [byteSize, minValue, maxValue] = rangeChecks[intType];
        if (value < minValue || value > maxValue) {
          set(errorMessage, `Value out of range for ${intType}: ${value}`);
          setTimeout(
            () => {
              set(errorMessage, "");
            },
            ERROR_MESSAGE_TIMEOUT
          );
          return false;
        }
        const dv = new DataView(new ArrayBuffer(byteSize));
        const littleEndian = $dataViewEndianness() === "le";
        switch (intType) {
          case "int8":
            dv.setInt8(0, value);
            break;
          case "uint8":
            dv.setUint8(0, value);
            break;
          case "int16":
            dv.setInt16(0, value, littleEndian);
            break;
          case "uint16":
            dv.setUint16(0, value, littleEndian);
            break;
          case "int32":
            dv.setInt32(0, value, littleEndian);
            break;
          case "uint32":
            dv.setUint32(0, value, littleEndian);
            break;
          case "int64":
            dv.setBigInt64(0, BigInt(value), littleEndian);
            break;
          case "uint64":
            dv.setBigUint64(0, BigInt(value), littleEndian);
            break;
          default:
            console.error("Invalid integer type: " + intType);
            return false;
        }
        editedDataSegment.update(() => {
          return new Uint8Array(dv.buffer, 0, byteSize);
        });
        eventDispatcher("applyChanges", { byte: $selectedByte(), action: "insert-replace" });
      } else {
        set(errorMessage, `Invalid value ${inputValue} (radix ${$displayRadix()}) for ${intType}`);
        setTimeout(
          () => {
            set(errorMessage, "");
          },
          ERROR_MESSAGE_TIMEOUT
        );
      }
      return true;
    }
    function handleInputEnter(e) {
      switch (e.detail.id) {
        case "latin1_dv":
          handleSubmit(e.detail.value, "latin1");
          break;
        case "int8_dv":
          handleSubmit(e.detail.value, "int8");
          break;
        case "uint8_dv":
          handleSubmit(e.detail.value, "uint8");
          break;
        case "int16_dv":
          handleSubmit(e.detail.value, "int16");
          break;
        case "uint16_dv":
          handleSubmit(e.detail.value, "uint16");
          break;
        case "int32_dv":
          handleSubmit(e.detail.value, "int32");
          break;
        case "uint32_dv":
          handleSubmit(e.detail.value, "uint32");
          break;
        case "int64_dv":
          handleSubmit(e.detail.value, "int64");
          break;
        case "uint64_dv":
          handleSubmit(e.detail.value, "uint64");
          break;
      }
    }
    function handleBlur() {
      set(isEditing, "");
    }
    init();
    var fieldset = root$8();
    var legend = child(fieldset);
    var node = sibling(child(legend));
    {
      var consequent = ($$anchor2) => {
        var text$1 = text();
        template_effect(() => set_text(text$1, `@ ${$dvOffset() ?? ""}`));
        append($$anchor2, text$1);
      };
      if_block(node, ($$render) => {
        if ($dvOffset()) $$render(consequent);
      });
    }
    var node_1 = sibling(legend, 2);
    {
      var consequent_1 = ($$anchor2) => {
        var fragment_1 = root_2$4();
        var b = first_child(fragment_1);
        var text_1 = child(b);
        template_effect(() => set_text(text_1, `message: ${get$1(errorMessage) ?? ""}`));
        append($$anchor2, fragment_1);
      };
      if_block(node_1, ($$render) => {
        if (get$1(errorMessage)) $$render(consequent_1);
      });
    }
    var div = sibling(node_1, 2);
    var select = sibling(child(div));
    template_effect(() => {
      $dataViewEndianness();
      invalidate_inner_signals(() => {
        $UIThemeCSSClass();
      });
    });
    each(select, 5, () => ENDIANNESS_OPTIONS, index, ($$anchor2, $$item) => {
      let name = () => get$1($$item).name;
      let value = () => get$1($$item).value;
      var option = root_3$4();
      var text_2 = child(option);
      var option_value = {};
      template_effect(() => {
        set_text(text_2, name());
        if (option_value !== (option_value = value())) {
          option.value = (option.__value = value()) ?? "";
        }
      });
      append($$anchor2, option);
    });
    var node_2 = sibling(div, 2);
    {
      var consequent_14 = ($$anchor2) => {
        var fragment_2 = root_4$4();
        var node_3 = first_child(fragment_2);
        {
          var consequent_2 = ($$anchor3) => {
            var div_1 = root_5$1();
            var node_4 = sibling(child(div_1), 2);
            Input(node_4, {
              id: "latin1_dv",
              get placeholder() {
                return $dvLatin1();
              },
              maxlength: 1,
              width: INPUT_WIDTH,
              autofocus: "true",
              $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
            });
            append($$anchor3, div_1);
          };
          var alternate = ($$anchor3) => {
            var div_2 = root_6$3();
            var span = sibling(child(div_2), 2);
            var text_3 = child(span);
            template_effect(() => set_text(text_3, $dvLatin1()));
            event("click", div_2, () => {
              set(isEditing, "latin1");
            });
            event("keydown", div_2, () => {
            });
            append($$anchor3, div_2);
          };
          if_block(node_3, ($$render) => {
            if (get$1(isEditing) === "latin1") $$render(consequent_2);
            else $$render(alternate, false);
          });
        }
        var node_5 = sibling(node_3, 2);
        {
          var consequent_3 = ($$anchor3) => {
            var div_3 = root_7$2();
            var node_6 = sibling(child(div_3), 2);
            Input(node_6, {
              id: "int8_dv",
              get placeholder() {
                return $dvInt8();
              },
              get value() {
                return $dvInt8();
              },
              maxlength: 8,
              width: INPUT_WIDTH,
              autofocus: "true",
              $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
            });
            append($$anchor3, div_3);
          };
          var alternate_1 = ($$anchor3) => {
            var div_4 = root_8$3();
            var span_1 = sibling(child(div_4), 2);
            var text_4 = child(span_1);
            template_effect(() => set_text(text_4, $dvInt8()));
            event("click", div_4, () => {
              set(isEditing, "int8");
            });
            event("keydown", div_4, () => {
            });
            append($$anchor3, div_4);
          };
          if_block(node_5, ($$render) => {
            if (get$1(isEditing) === "int8") $$render(consequent_3);
            else $$render(alternate_1, false);
          });
        }
        var node_7 = sibling(node_5, 2);
        {
          var consequent_4 = ($$anchor3) => {
            var div_5 = root_9$2();
            var node_8 = sibling(child(div_5), 2);
            Input(node_8, {
              id: "uint8_dv",
              get placeholder() {
                return $dvUint8();
              },
              get value() {
                return $dvUint8();
              },
              maxlength: 8,
              width: INPUT_WIDTH,
              autofocus: "true",
              $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
            });
            append($$anchor3, div_5);
          };
          var alternate_2 = ($$anchor3) => {
            var div_6 = root_10$2();
            var span_2 = sibling(child(div_6), 2);
            var text_5 = child(span_2);
            template_effect(() => set_text(text_5, $dvUint8()));
            event("click", div_6, () => {
              set(isEditing, "uint8");
            });
            event("keydown", div_6, () => {
            });
            append($$anchor3, div_6);
          };
          if_block(node_7, ($$render) => {
            if (get$1(isEditing) === "uint8") $$render(consequent_4);
            else $$render(alternate_2, false);
          });
        }
        var node_9 = sibling(node_7, 2);
        {
          var consequent_7 = ($$anchor3) => {
            var fragment_3 = root_11$2();
            var node_10 = first_child(fragment_3);
            {
              var consequent_5 = ($$anchor4) => {
                var div_7 = root_12$2();
                var node_11 = sibling(child(div_7), 2);
                Input(node_11, {
                  id: "int16_dv",
                  get placeholder() {
                    return $dvInt16();
                  },
                  get value() {
                    return $dvInt16();
                  },
                  maxlength: 16,
                  width: INPUT_WIDTH,
                  autofocus: "true",
                  $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
                });
                append($$anchor4, div_7);
              };
              var alternate_3 = ($$anchor4) => {
                var div_8 = root_13$2();
                var span_3 = sibling(child(div_8), 2);
                var text_6 = child(span_3);
                template_effect(() => set_text(text_6, $dvInt16()));
                event("click", div_8, () => {
                  set(isEditing, "int16");
                });
                event("keydown", div_8, () => {
                });
                append($$anchor4, div_8);
              };
              if_block(node_10, ($$render) => {
                if (get$1(isEditing) === "int16") $$render(consequent_5);
                else $$render(alternate_3, false);
              });
            }
            var node_12 = sibling(node_10, 2);
            {
              var consequent_6 = ($$anchor4) => {
                var div_9 = root_14$2();
                var node_13 = sibling(child(div_9), 2);
                Input(node_13, {
                  id: "uint16_dv",
                  get placeholder() {
                    return $dvUint16();
                  },
                  get value() {
                    return $dvUint16();
                  },
                  maxlength: 16,
                  width: INPUT_WIDTH,
                  autofocus: "true",
                  $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
                });
                append($$anchor4, div_9);
              };
              var alternate_4 = ($$anchor4) => {
                var div_10 = root_15$2();
                var span_4 = sibling(child(div_10), 2);
                var text_7 = child(span_4);
                template_effect(() => set_text(text_7, $dvUint16()));
                event("click", div_10, () => {
                  set(isEditing, "uint16");
                });
                event("keydown", div_10, () => {
                });
                append($$anchor4, div_10);
              };
              if_block(node_12, ($$render) => {
                if (get$1(isEditing) === "uint16") $$render(consequent_6);
                else $$render(alternate_4, false);
              });
            }
            append($$anchor3, fragment_3);
          };
          if_block(node_9, ($$render) => {
            if ($dvInt16()) $$render(consequent_7);
          });
        }
        var node_14 = sibling(node_9, 2);
        {
          var consequent_10 = ($$anchor3) => {
            var fragment_4 = root_16$2();
            var node_15 = first_child(fragment_4);
            {
              var consequent_8 = ($$anchor4) => {
                var div_11 = root_17$2();
                var node_16 = sibling(child(div_11), 2);
                Input(node_16, {
                  id: "int32_dv",
                  get placeholder() {
                    return $dvInt32();
                  },
                  get value() {
                    return $dvInt32();
                  },
                  maxlength: 32,
                  width: INPUT_WIDTH,
                  autofocus: "true",
                  $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
                });
                append($$anchor4, div_11);
              };
              var alternate_5 = ($$anchor4) => {
                var div_12 = root_18$1();
                var span_5 = sibling(child(div_12), 2);
                var text_8 = child(span_5);
                template_effect(() => set_text(text_8, $dvInt32()));
                event("click", div_12, () => {
                  set(isEditing, "int32");
                });
                event("keydown", div_12, () => {
                });
                append($$anchor4, div_12);
              };
              if_block(node_15, ($$render) => {
                if (get$1(isEditing) === "int32") $$render(consequent_8);
                else $$render(alternate_5, false);
              });
            }
            var node_17 = sibling(node_15, 2);
            {
              var consequent_9 = ($$anchor4) => {
                var div_13 = root_19();
                var node_18 = sibling(child(div_13), 2);
                Input(node_18, {
                  id: "uint32_dv",
                  get placeholder() {
                    return $dvUint32();
                  },
                  get value() {
                    return $dvUint32();
                  },
                  maxlength: 32,
                  width: INPUT_WIDTH,
                  autofocus: "true",
                  $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
                });
                append($$anchor4, div_13);
              };
              var alternate_6 = ($$anchor4) => {
                var div_14 = root_20();
                var span_6 = sibling(child(div_14), 2);
                var text_9 = child(span_6);
                template_effect(() => set_text(text_9, $dvUint32()));
                event("click", div_14, () => {
                  set(isEditing, "uint32");
                });
                event("keydown", div_14, () => {
                });
                append($$anchor4, div_14);
              };
              if_block(node_17, ($$render) => {
                if (get$1(isEditing) === "uint32") $$render(consequent_9);
                else $$render(alternate_6, false);
              });
            }
            append($$anchor3, fragment_4);
          };
          if_block(node_14, ($$render) => {
            if ($dvInt32()) $$render(consequent_10);
          });
        }
        var node_19 = sibling(node_14, 2);
        {
          var consequent_13 = ($$anchor3) => {
            var fragment_5 = root_21();
            var node_20 = first_child(fragment_5);
            {
              var consequent_11 = ($$anchor4) => {
                var div_15 = root_22();
                var node_21 = sibling(child(div_15), 2);
                Input(node_21, {
                  id: "int64_dv",
                  get placeholder() {
                    return $dvInt64();
                  },
                  get value() {
                    return $dvInt64();
                  },
                  maxlength: 64,
                  width: INPUT_WIDTH,
                  autofocus: "true",
                  $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
                });
                append($$anchor4, div_15);
              };
              var alternate_7 = ($$anchor4) => {
                var div_16 = root_23();
                var span_7 = sibling(child(div_16), 2);
                var text_10 = child(span_7);
                template_effect(() => set_text(text_10, $dvInt64()));
                event("click", div_16, () => {
                  set(isEditing, "int64");
                });
                event("keydown", div_16, () => {
                });
                append($$anchor4, div_16);
              };
              if_block(node_20, ($$render) => {
                if (get$1(isEditing) === "int64") $$render(consequent_11);
                else $$render(alternate_7, false);
              });
            }
            var node_22 = sibling(node_20, 2);
            {
              var consequent_12 = ($$anchor4) => {
                var div_17 = root_24();
                var node_23 = sibling(child(div_17), 2);
                Input(node_23, {
                  id: "uint64_dv",
                  get placeholder() {
                    return $dvUint64();
                  },
                  get value() {
                    return $dvUint64();
                  },
                  maxlength: 64,
                  width: INPUT_WIDTH,
                  autofocus: "true",
                  $$events: { inputEnter: handleInputEnter, inputFocusOut: handleBlur }
                });
                append($$anchor4, div_17);
              };
              var alternate_8 = ($$anchor4) => {
                var div_18 = root_25();
                var span_8 = sibling(child(div_18), 2);
                var text_11 = child(span_8);
                template_effect(() => set_text(text_11, $dvUint64()));
                event("click", div_18, () => {
                  set(isEditing, "uint64");
                });
                event("keydown", div_18, () => {
                });
                append($$anchor4, div_18);
              };
              if_block(node_22, ($$render) => {
                if (get$1(isEditing) === "uint64") $$render(consequent_12);
                else $$render(alternate_8, false);
              });
            }
            append($$anchor3, fragment_5);
          };
          if_block(node_19, ($$render) => {
            if ($dvInt64()) $$render(consequent_13);
          });
        }
        append($$anchor2, fragment_2);
      };
      if_block(node_2, ($$render) => {
        if ($selectionDataStore().active && $dvInt8()) $$render(consequent_14);
      });
    }
    template_effect(() => set_class(select, 1, clsx($UIThemeCSSClass()), "svelte-1f4rc2f"));
    bind_select_value(select, $dataViewEndianness, ($$value) => store_set(dataViewEndianness, $$value));
    append($$anchor, fieldset);
    pop();
    $$cleanup();
  }
  var root$7 = /* @__PURE__ */ from_html(`<span class="help-icon svelte-pbx8hy">?</span>`);
  function HelpIcon($$anchor, $$props) {
    const [$$stores, $$cleanup] = setup_stores();
    let helpSectionId = prop($$props, "helpSectionId", 8);
    var span = root$7();
    event("click", span, (e) => {
      store_set(currentHelpSectionEvent, e);
      store_set(currentHelpSectionDisplayed, helpSectionId());
    });
    append($$anchor, span);
    $$cleanup();
  }
  var root_1$4 = /* @__PURE__ */ from_html(`<div class="clear-selection" title="Clear selection data">&#10006;</div> <div> </div>`, 1);
  var root_2$3 = /* @__PURE__ */ from_html(`<textarea id="selectedContent" contenteditable="true"></textarea> <!>`, 1);
  var root$6 = /* @__PURE__ */ from_html(`<div class="editView" id="edit_view"><div class="hdr editor-header svelte-wqg4wi"><div>Editor <!></div> <div><!></div></div> <!></div>`);
  function DataEditor($$anchor, $$props) {
    push($$props, false);
    const $selectionDataStore = () => store_get(selectionDataStore, "$selectionDataStore", $$stores);
    const $viewport = () => store_get(viewport, "$viewport", $$stores);
    const $selectionSize = () => store_get(selectionSize, "$selectionSize", $$stores);
    const $addressRadix = () => store_get(addressRadix, "$addressRadix", $$stores);
    const $editMode = () => store_get(editMode, "$editMode", $$stores);
    const $regularSizedFile = () => store_get(regularSizedFile, "$regularSizedFile", $$stores);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const $editorSelection = () => store_get(editorSelection, "$editorSelection", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const eventDispatcher = createEventDispatcher();
    let selectionOffsetText = /* @__PURE__ */ mutable_source();
    let displayTextEditorArea = /* @__PURE__ */ mutable_source();
    function clearDataDisplays() {
      eventDispatcher("clearDataDisplays");
    }
    function handleEditorEvent(event2) {
      switch (event2.type) {
        case "input":
          {
            const eventDetails = event2;
            const editorElement = eventDetails.target;
            editorSelection.update(() => {
              return editorElement.value;
            });
          }
          break;
      }
      eventDispatcher("handleEditorEvent", event2);
    }
    function setSelectionOffsetInfo(from, start, end, size, radix) {
      return `${from} [${start.toString(radix)} - ${end.toString(radix)}] Size: ${size.toString(radix)} `;
    }
    legacy_pre_effect(
      () => ($viewport(), $selectionDataStore(), $selectionSize(), $addressRadix()),
      () => {
        set(selectionOffsetText, setSelectionOffsetInfo("Selection", $viewport().fileOffset + $selectionDataStore().startOffset, $viewport().fileOffset + $selectionDataStore().endOffset, $selectionSize(), $addressRadix()));
      }
    );
    legacy_pre_effect(
      () => ($editMode(), $selectionDataStore(), $regularSizedFile()),
      () => {
        set(displayTextEditorArea, $editMode() === EditByteModes.Multiple && ($selectionDataStore().active || !$regularSizedFile()));
      }
    );
    legacy_pre_effect_reset();
    var $$exports = { setSelectionOffsetInfo };
    init();
    var div = root$6();
    let styles;
    var div_1 = child(div);
    var div_2 = child(div_1);
    var node = sibling(child(div_2));
    HelpIcon(node, { helpSectionId: "edit-instructions" });
    var div_3 = sibling(div_2, 2);
    var node_1 = child(div_3);
    {
      var consequent = ($$anchor2) => {
        var fragment = root_1$4();
        var div_4 = first_child(fragment);
        var div_5 = sibling(div_4, 2);
        var text2 = child(div_5);
        template_effect(() => set_text(text2, get$1(selectionOffsetText)));
        event("click", div_4, clearDataDisplays);
        event("keypress", div_4, clearDataDisplays);
        append($$anchor2, fragment);
      };
      if_block(node_1, ($$render) => {
        if ($selectionDataStore(), $editMode(), deep_read_state(EditByteModes), untrack(() => $selectionDataStore().active && $editMode() !== EditByteModes.Single)) $$render(consequent);
      });
    }
    var node_2 = sibling(div_1, 2);
    {
      var consequent_1 = ($$anchor2) => {
        var fragment_1 = root_2$3();
        var textarea = first_child(fragment_1);
        var node_3 = sibling(textarea, 2);
        FlexContainer(node_3, {
          children: ($$anchor3, $$slotProps) => {
            ContentControls($$anchor3, {
              $$events: {
                applyChanges($$arg) {
                  bubble_event.call(this, $$props, $$arg);
                }
              }
            });
          },
          $$slots: { default: true }
        });
        template_effect(() => set_class(textarea, 1, clsx($UIThemeCSSClass()), "svelte-wqg4wi"));
        event("keyup", textarea, handleEditorEvent, void 0, false);
        event("click", textarea, handleEditorEvent);
        event("input", textarea, handleEditorEvent);
        bind_value(textarea, $editorSelection, ($$value) => store_set(editorSelection, $$value));
        append($$anchor2, fragment_1);
      };
      var alternate = ($$anchor2) => {
        FlexContainer($$anchor2, {
          children: ($$anchor3, $$slotProps) => {
            DataView_1($$anchor3, {
              $$events: {
                applyChanges($$arg) {
                  bubble_event.call(this, $$props, $$arg);
                }
              }
            });
          },
          $$slots: { default: true }
        });
      };
      if_block(node_2, ($$render) => {
        if (get$1(displayTextEditorArea)) $$render(consequent_1);
        else $$render(alternate, false);
      });
    }
    template_effect(() => {
      styles = set_style(div, "", styles, {
        "justify-content": get$1(displayTextEditorArea) ? "flex-end" : "flex-start"
      });
      set_class(div_2, 1, $UIThemeCSSClass() + " hd", "svelte-wqg4wi");
      set_class(div_3, 1, $UIThemeCSSClass() + " measure selection-content", "svelte-wqg4wi");
    });
    append($$anchor, div);
    bind_prop($$props, "setSelectionOffsetInfo", setSelectionOffsetInfo);
    var $$pop = pop($$exports);
    $$cleanup();
    return $$pop;
  }
  var root_1$3 = /* @__PURE__ */ from_html(`<div class="byte disabled svelte-5cc6pp"></div>`);
  var root_3$3 = /* @__PURE__ */ from_html(`<div> </div>`);
  var root_4$3 = /* @__PURE__ */ from_html(`<div> </div>`);
  function DataValue($$anchor, $$props) {
    push($$props, false);
    let id = prop($$props, "id", 8);
    let byte = prop($$props, "byte", 8);
    let disabled = prop($$props, "disabled", 8, false);
    let width = prop($$props, "width", 8, "20px");
    let categoryIndicationSelectors = prop($$props, "categoryIndicationSelectors", 8);
    init();
    var fragment = comment();
    var node = first_child(fragment);
    {
      var consequent = ($$anchor2) => {
        var div = root_1$3();
        let styles;
        template_effect(() => styles = set_style(div, "", styles, { width: id() === "logical" ? "20px" : width() }));
        append($$anchor2, div);
      };
      var alternate_1 = ($$anchor2) => {
        var fragment_1 = comment();
        var node_1 = first_child(fragment_1);
        {
          var consequent_1 = ($$anchor3) => {
            var div_1 = root_3$3();
            let styles_1;
            var text2 = child(div_1);
            template_effect(
              ($0) => {
                set_class(div_1, 1, "byte " + categoryIndicationSelectors(), "svelte-5cc6pp");
                set_attribute(div_1, "id", $0);
                set_attribute(div_1, "offset", (deep_read_state(byte()), untrack(() => byte().offset)));
                styles_1 = set_style(div_1, "", styles_1, { width: width() });
                set_text(text2, (deep_read_state(byte()), untrack(() => byte().text)));
              },
              [
                () => (deep_read_state(id()), deep_read_state(byte()), untrack(() => id() + "-" + byte().offset.toString()))
              ]
            );
            append($$anchor3, div_1);
          };
          var alternate = ($$anchor3) => {
            var div_2 = root_4$3();
            let classes;
            set_style(div_2, "", {}, { width: "20px" });
            var text_1 = child(div_2);
            template_effect(
              ($0, $1, $2) => {
                classes = set_class(div_2, 1, "byte " + categoryIndicationSelectors(), "svelte-5cc6pp", classes, $0);
                set_attribute(div_2, "id", $1);
                set_attribute(div_2, "offset", (deep_read_state(byte()), untrack(() => byte().offset)));
                set_text(text_1, $2);
              },
              [
                () => ({ latin1Undefined: latin1Undefined$1(byte().value) }),
                () => (deep_read_state(id()), deep_read_state(byte()), untrack(() => id() + "-" + byte().offset.toString())),
                () => (deep_read_state(latin1Undefined$1), deep_read_state(byte()), untrack(() => latin1Undefined$1(byte().value) ? "" : String.fromCharCode(byte().value)))
              ]
            );
            append($$anchor3, div_2);
          };
          if_block(
            node_1,
            ($$render) => {
              if (id() === "physical") $$render(consequent_1);
              else $$render(alternate, false);
            },
            true
          );
        }
        append($$anchor2, fragment_1);
      };
      if_block(node, ($$render) => {
        if (disabled()) $$render(consequent);
        else $$render(alternate_1, false);
      });
    }
    append($$anchor, fragment);
    pop();
  }
  var root$5 = /* @__PURE__ */ from_html(`<div><div class="traversal-thumb svelte-1ahksbv"></div></div>`);
  function FileTraversalIndicator($$anchor, $$props) {
    push($$props, false);
    const $bytesPerRow = () => store_get(bytesPerRow, "$bytesPerRow", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const eventDispatcher = createEventDispatcher();
    let totalLines = prop($$props, "totalLines", 8, 0);
    let currentLine = prop($$props, "currentLine", 8, 0);
    let fileOffset = prop($$props, "fileOffset", 8, 0);
    let percentageTraversed = prop($$props, "percentageTraversed", 12);
    let maxDisplayLines = prop($$props, "maxDisplayLines", 8, 20);
    let selectionActive = prop($$props, "selectionActive", 8);
    let indicatorContainer = /* @__PURE__ */ mutable_source();
    let indicatorClickDisabled = /* @__PURE__ */ mutable_source(false);
    function updatePercentageTraversed(e) {
      if (selectionActive()) return;
      const relativeClickPosition = e.clientX - get$1(indicatorContainer).getBoundingClientRect().left;
      const indicatorContainerWidth = get$1(indicatorContainer).getBoundingClientRect().width;
      percentageTraversed(relativeClickPosition / indicatorContainerWidth * 100);
      eventDispatcher("indicatorClicked", percentageTraversed());
    }
    legacy_pre_effect(
      () => (deep_read_state(totalLines()), deep_read_state(maxDisplayLines()), get$1(indicatorContainer), deep_read_state(currentLine()), deep_read_state(fileOffset()), $bytesPerRow()),
      () => {
        if (totalLines() <= maxDisplayLines()) {
          percentageTraversed(100);
          set(indicatorClickDisabled, true);
          if (get$1(indicatorContainer)) get$1(indicatorContainer).removeEventListener("click", updatePercentageTraversed);
        } else {
          set(indicatorClickDisabled, false);
          percentageTraversed((currentLine() + (fileOffset() / $bytesPerRow() + 20)) / totalLines() * 100);
          if (get$1(indicatorContainer)) get$1(indicatorContainer).addEventListener("click", updatePercentageTraversed);
        }
      }
    );
    legacy_pre_effect_reset();
    init();
    var div = root$5();
    var div_1 = child(div);
    let styles;
    bind_this(
      div,
      ($$value) => set(
        // Calculate the position of the click relative to the indicator container
        // Calculate the width of the indicator container
        // Calculate the percentage into the file
        indicatorContainer,
        $$value
      ),
      () => get$1(indicatorContainer)
    );
    template_effect(() => {
      set_class(div, 1, `traversal-container ${selectionActive() || get$1(indicatorClickDisabled) ? "disabled" : "enabled"}`, "svelte-1ahksbv");
      styles = set_style(div_1, "", styles, { width: `${percentageTraversed() ?? ""}%` });
    });
    append($$anchor, div);
    pop();
    $$cleanup();
  }
  const MappableKeys = {
    Enter: true,
    Delete: true
  };
  class ElementKeypressEventMap {
    constructor() {
      __publicField(this, "events", {
        Delete: [],
        Enter: []
      });
    }
    register(key2, event2) {
      this.remove_and_replace(key2, event2);
    }
    run(elementId, keyEvent) {
      this.events[keyEvent.key].forEach((eventItem) => {
        if (eventItem.elementId === elementId) eventItem.run(keyEvent);
      });
    }
    remove_and_replace(key2, event2) {
      const replaceIndex = this.events[key2].findIndex((storedEvent) => {
        return storedEvent.elementId === event2.elementId;
      });
      replaceIndex >= 0 ? this.events[key2][replaceIndex] = event2 : this.events[key2].push(event2);
    }
  }
  function key_is_mappable(eventKey) {
    return MappableKeys[eventKey] === true;
  }
  let elementKeypressEventMap = new ElementKeypressEventMap();
  var root_3$2 = /* @__PURE__ */ from_html(`<div><!></div>`);
  var root_5 = /* @__PURE__ */ from_html(`<div><!></div>`);
  var root_1$2 = /* @__PURE__ */ from_html(`<span class="svelte-o73rmp"><input/>  <div><!></div></span>  <!>  <!>`, 1);
  var root_7$1 = /* @__PURE__ */ from_html(`<span class="svelte-o73rmp"><input/></span>`);
  function SelectedByteEdit($$anchor, $$props) {
    push($$props, false);
    const $bytesPerRow = () => store_get(bytesPerRow, "$bytesPerRow", $$stores);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const $selectionDataStore = () => store_get(selectionDataStore, "$selectionDataStore", $$stores);
    const $focusedViewportId = () => store_get(focusedViewportId, "$focusedViewportId", $$stores);
    const $displayRadix = () => store_get(displayRadix, "$displayRadix", $$stores);
    const $applicable = () => store_get(applicable, "$applicable", $$stores);
    const $applyErrMsg = () => store_get(applyErrMsg, "$applyErrMsg", $$stores);
    const $editorSelection = () => store_get(editorSelection, "$editorSelection", $$stores);
    const $addressRadix = () => store_get(addressRadix, "$addressRadix", $$stores);
    const $editorActionsAllowed = () => store_get(editorActionsAllowed, "$editorActionsAllowed", $$stores);
    const $rerenderActionElements = () => store_get(rerenderActionElements, "$rerenderActionElements", $$stores);
    const $editByte = () => store_get(editByte, "$editByte", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const eventDispatcher = createEventDispatcher();
    let actionElements = /* @__PURE__ */ mutable_source({
      input: {
        id: "binary-action-input",
        HTMLRef: void 0,
        render: true,
        position: { viewportLine: -1, viewportByteIndex: -1 }
      },
      "insert-before": {
        id: "binary-action-before",
        HTMLRef: void 0,
        render: true,
        position: { viewportLine: -1, viewportByteIndex: -1 }
      },
      "insert-after": {
        id: "binary-action-after",
        HTMLRef: void 0,
        render: true,
        position: { viewportLine: -1, viewportByteIndex: -1 }
      },
      delete: {
        id: "binary-action-delete",
        HTMLRef: void 0,
        render: true,
        position: { viewportLine: -1, viewportByteIndex: -1 }
      }
    });
    let byte = prop($$props, "byte", 12);
    let target;
    let targetParent;
    let targetElementId = /* @__PURE__ */ mutable_source();
    let BPR = /* @__PURE__ */ mutable_source($bytesPerRow());
    let editedByteText;
    let invalid = /* @__PURE__ */ mutable_source();
    let inProgress = /* @__PURE__ */ mutable_source();
    let active = /* @__PURE__ */ mutable_source();
    let elementDivWidth = /* @__PURE__ */ mutable_source();
    let restorationFns = [];
    let themeClass = /* @__PURE__ */ mutable_source();
    elementKeypressEventMap.register("Enter", {
      elementId: get$1(actionElements).input.id,
      run: (keyEvent) => {
        if (is_input_invalid() || is_input_inprogress()) return;
        if (keyEvent.shiftKey && !keyEvent.ctrlKey) applyChanges("insert-after");
        else if (!keyEvent.shiftKey && keyEvent.ctrlKey) applyChanges("insert-before");
        else applyChanges("byte-input");
      }
    });
    elementKeypressEventMap.register("Delete", {
      elementId: get$1(actionElements).input.id,
      run: (keyEvent) => {
        applyChanges("delete");
      }
    });
    onMount(() => {
      target = document.getElementById(get$1(targetElementId));
      if (target) targetParent = target.parentElement;
      else {
        store_set(seekOffsetInput, byte().offset.toString($addressRadix()));
        eventDispatcher("seek");
        return;
      }
      store_set(editorSelection, byte().text);
      grab_action_element_refs();
      initialize_action_elements();
      get$1(actionElements)["input"].HTMLRef.focus();
      mutate(actionElements, get$1(actionElements)["input"].HTMLRef.value = "");
      return restore_original_target;
    });
    function is_input_invalid() {
      return get$1(invalid);
    }
    function is_input_inprogress() {
      return get$1(inProgress);
    }
    function grab_action_element_refs() {
      for (const element in get$1(actionElements)) mutate(actionElements, get$1(actionElements)[element].HTMLRef = document.getElementById(get$1(actionElements)[element].id));
    }
    function initialize_action_elements() {
      setup_action_element("input");
      if ($editorActionsAllowed() == EditActionRestrictions.OverwriteOnly) return;
      setup_action_element("insert-before");
      setup_action_element("insert-after");
    }
    function restore_original_target() {
      const input = document.getElementById("binary-action-input");
      if (target && input) {
        restorationFns.forEach((fn) => {
          fn();
        });
        restorationFns = [];
      }
      if ($rerenderActionElements()) store_set(rerenderActionElements, false);
    }
    function update_selectedByte(editByte2) {
      if (get$1(invalid)) return;
      byte(editByte2);
    }
    function send_delete(_) {
      applyChanges("delete");
    }
    function setup_action_element(element) {
      switch (element) {
        case "input":
          const inputContainer = get$1(actionElements)[element].HTMLRef.parentElement;
          apply_element_replacements(targetParent, target, inputContainer);
          break;
        case "insert-before":
          {
            const previousByteId = byteOffsetToElementId(byte().offset - 1);
            const insertBeforeElement = get$1(actionElements)[element].HTMLRef;
            let elementToReplace = document.getElementById(previousByteId);
            if (!elementToReplace) {
              mutate(actionElements, get$1(actionElements)[element].render = false);
              break;
            }
            targetParent.contains(elementToReplace) ? apply_element_replacements(targetParent, elementToReplace, insertBeforeElement) : apply_element_replacements(elementToReplace.parentElement, elementToReplace, insertBeforeElement);
          }
          break;
        case "insert-after":
          {
            const nextByteId = byteOffsetToElementId(byte().offset + 1);
            const insertAfterElement = get$1(actionElements)[element].HTMLRef;
            let elementToReplace = document.getElementById(nextByteId);
            if (!elementToReplace) {
              mutate(actionElements, get$1(actionElements)[element].render = false);
              break;
            }
            targetParent.contains(elementToReplace) ? apply_element_replacements(targetParent, elementToReplace, insertAfterElement) : apply_element_replacements(elementToReplace.parentElement, elementToReplace, insertAfterElement);
          }
          break;
      }
    }
    function apply_element_replacements(parent, replacee, replacer) {
      parent.replaceChild(replacer, replacee);
      restorationFns.push(() => {
        parent.replaceChild(replacee, replacer);
      });
    }
    function send_insert(event2) {
      const target2 = event2.currentTarget;
      switch (target2.id) {
        case get$1(actionElements)["insert-after"].id:
          applyChanges("insert-after");
          break;
        case get$1(actionElements)["insert-before"].id:
          applyChanges("insert-before");
          break;
      }
    }
    function applyChanges(action2) {
      if (action2 === "byte-input") {
        update_selectedByte({
          text: $editorSelection(),
          offset: byte().offset,
          value: parseInt(editedByteText, 16)
        });
      }
      eventDispatcher("applyChanges", { byte: byte(), action: action2 });
    }
    function handleEditorEvent() {
      eventDispatcher("handleEditorEvent");
    }
    function byteOffsetToElementId(byteOffset) {
      return $focusedViewportId() + "-" + byteOffset.toString();
    }
    legacy_pre_effect(() => $UIThemeCSSClass(), () => {
      set(themeClass, $UIThemeCSSClass());
    });
    legacy_pre_effect(
      () => ($selectionDataStore(), $bytesPerRow(), $focusedViewportId(), $displayRadix(), deep_read_state(byte())),
      () => {
        set(active, $selectionDataStore().active);
        set(BPR, $bytesPerRow());
        set(elementDivWidth, $focusedViewportId() === "physical" ? byteDivWidthFromRadix($displayRadix()) : "20px");
        set(targetElementId, byteOffsetToElementId(byte().offset));
      }
    );
    legacy_pre_effect(
      () => ($applicable(), $applyErrMsg(), $editorSelection(), $displayRadix()),
      () => {
        if (!$applicable() && $applyErrMsg().length > 0 && $editorSelection().length >= radixBytePad($displayRadix())) {
          set(invalid, true);
          set(inProgress, false);
        } else if (!$applicable() && $applyErrMsg().length > 0 && $editorSelection().length < radixBytePad($displayRadix())) {
          set(invalid, false);
          set(inProgress, true);
        } else {
          set(invalid, false);
          set(inProgress, false);
        }
      }
    );
    legacy_pre_effect_reset();
    init();
    var fragment = comment();
    var node = first_child(fragment);
    {
      var consequent_2 = ($$anchor2) => {
        var fragment_1 = root_1$2();
        var span = first_child(fragment_1);
        var input_1 = child(span);
        let classes;
        let styles;
        var div = sibling(input_1, 2);
        let styles_1;
        var node_1 = child(div);
        Tooltip(node_1, {
          alwaysEnabled: true,
          description: "Delete byte",
          children: ($$anchor3, $$slotProps) => {
            var text$1 = text("✖");
            append($$anchor3, text$1);
          },
          $$slots: { default: true }
        });
        var node_2 = sibling(span, 2);
        {
          var consequent = ($$anchor3) => {
            var div_1 = root_3$2();
            let styles_2;
            var node_3 = child(div_1);
            Tooltip(node_3, {
              alwaysEnabled: true,
              description: "Insert as preceding byte",
              children: ($$anchor4, $$slotProps) => {
                var text_1 = text("⇤");
                append($$anchor4, text_1);
              },
              $$slots: { default: true }
            });
            template_effect(() => {
              set_class(div_1, 1, `insert-before ${get$1(themeClass) ?? ""}`, "svelte-o73rmp");
              set_attribute(div_1, "id", (get$1(actionElements), untrack(() => get$1(actionElements)["insert-before"].id)));
              styles_2 = set_style(div_1, "", styles_2, { width: get$1(elementDivWidth) });
            });
            event("mousedown", div_1, stopPropagation(send_insert));
            append($$anchor3, div_1);
          };
          if_block(node_2, ($$render) => {
            if (get$1(actionElements), untrack(() => get$1(actionElements)["insert-before"].render)) $$render(consequent);
          });
        }
        var node_4 = sibling(node_2, 2);
        {
          var consequent_1 = ($$anchor3) => {
            var div_2 = root_5();
            let styles_3;
            var node_5 = child(div_2);
            Tooltip(node_5, {
              alwaysEnabled: true,
              description: "Insert as following byte",
              children: ($$anchor4, $$slotProps) => {
                var text_2 = text("⇥");
                append($$anchor4, text_2);
              },
              $$slots: { default: true }
            });
            template_effect(() => {
              set_class(div_2, 1, `insert-after ${get$1(themeClass) ?? ""}`, "svelte-o73rmp");
              set_attribute(div_2, "id", (get$1(actionElements), untrack(() => get$1(actionElements)["insert-after"].id)));
              styles_3 = set_style(div_2, "", styles_3, { width: get$1(elementDivWidth) });
            });
            event("mousedown", div_2, stopPropagation(send_insert));
            append($$anchor3, div_2);
          };
          if_block(node_4, ($$render) => {
            if (get$1(actionElements), untrack(() => get$1(actionElements)["insert-after"].render)) $$render(consequent_1);
          });
        }
        template_effect(() => {
          classes = set_class(input_1, 1, `insert ${get$1(themeClass) ?? ""}`, "svelte-o73rmp", classes, { invalid: get$1(invalid), inProgress: get$1(inProgress) });
          set_attribute(input_1, "id", (get$1(actionElements), untrack(() => get$1(actionElements)["input"].id)));
          set_attribute(input_1, "placeholder", $editByte());
          styles = set_style(input_1, "", styles, { width: get$1(elementDivWidth) });
          set_class(div, 1, `delete ${get$1(themeClass) ?? ""}`, "svelte-o73rmp");
          set_attribute(div, "id", (get$1(actionElements), untrack(() => get$1(actionElements)["delete"].id)));
          styles_1 = set_style(div, "", styles_1, { width: get$1(elementDivWidth) });
        });
        bind_value(input_1, $editorSelection, ($$value) => store_set(editorSelection, $$value));
        event("input", input_1, handleEditorEvent);
        event("mousedown", div, stopPropagation(send_delete));
        append($$anchor2, fragment_1);
      };
      var alternate = ($$anchor2) => {
        var span_1 = root_7$1();
        var input_2 = child(span_1);
        let classes_1;
        let styles_4;
        template_effect(() => {
          classes_1 = set_class(input_2, 1, `insert ${get$1(themeClass) ?? ""}`, "svelte-o73rmp", classes_1, { invalid: get$1(invalid), inProgress: get$1(inProgress) });
          set_attribute(input_2, "id", (get$1(actionElements), untrack(() => get$1(actionElements)["input"].id)));
          set_attribute(input_2, "placeholder", $editByte());
          styles_4 = set_style(input_2, "", styles_4, { width: get$1(elementDivWidth) });
        });
        bind_value(input_2, $editorSelection, ($$value) => store_set(editorSelection, $$value));
        event("input", input_2, handleEditorEvent);
        append($$anchor2, span_1);
      };
      if_block(node, ($$render) => {
        if ($editorActionsAllowed(), deep_read_state(EditActionRestrictions), untrack(() => $editorActionsAllowed() === EditActionRestrictions.None)) $$render(consequent_2);
        else $$render(alternate, false);
      });
    }
    append($$anchor, fragment);
    pop();
    $$cleanup();
  }
  var root_4$2 = /* @__PURE__ */ from_html(`<div class="byte-line svelte-1ltndc4"></div>`);
  var root_6$2 = /* @__PURE__ */ from_html(`<div class="byte-line svelte-1ltndc4"></div>`);
  var root_3$1 = /* @__PURE__ */ from_html(`<div><div class="address svelte-1ltndc4" id="address"><b class="svelte-1ltndc4"> </b></div> <!> <!></div>`);
  var root_10$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined svelte-1ltndc4">stat_minus_3</span>`);
  var root_11$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined svelte-1ltndc4">keyboard_double_arrow_down</span>`);
  var root_12$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined svelte-1ltndc4">keyboard_arrow_down</span>`);
  var root_13$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined svelte-1ltndc4">keyboard_arrow_up</span>`);
  var root_14$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined svelte-1ltndc4">keyboard_double_arrow_up</span>`);
  var root_15$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined svelte-1ltndc4">stat_3</span>`);
  var root_16$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined svelte-1ltndc4">playlist_add</span>`);
  var root_17$1 = /* @__PURE__ */ from_html(`<span slot="left" class="btn-icon material-symbols-outlined svelte-1ltndc4">playlist_remove</span>`);
  var root_9$1 = /* @__PURE__ */ from_html(`<!> <!> <!> <!> <!> <!> <span class="separator svelte-1ltndc4"></span> <!> <!>`, 1);
  var root_8$2 = /* @__PURE__ */ from_html(`<!> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  var root$4 = /* @__PURE__ */ from_html(`<div class="container svelte-1ltndc4"><!> <!> <svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper></div>`);
  function DataLineFeed($$anchor, $$props) {
    push($$props, false);
    const $bytesPerRow = () => store_get(bytesPerRow, "$bytesPerRow", $$stores);
    const $dataFeedLineTop = () => store_get(dataFeedLineTop, "$dataFeedLineTop", $$stores);
    const $fileMetrics = () => store_get(fileMetrics, "$fileMetrics", $$stores);
    const $dataDislayLineAmount = () => store_get(dataDislayLineAmount, "$dataDislayLineAmount", $$stores);
    const $selectionDataStore = () => store_get(selectionDataStore, "$selectionDataStore", $$stores);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const $searchQuery = () => store_get(searchQuery, "$searchQuery", $$stores);
    const $replaceQuery = () => store_get(replaceQuery, "$replaceQuery", $$stores);
    const $dfdlBytePos = () => store_get(dfdlBytePos, "$dfdlBytePos", $$stores);
    const $selectedByte = () => store_get(selectedByte, "$selectedByte", $$stores);
    const $editMode = () => store_get(editMode, "$editMode", $$stores);
    const $editedDataSegment = () => store_get(editedDataSegment, "$editedDataSegment", $$stores);
    const $editorEncoding = () => store_get(editorEncoding, "$editorEncoding", $$stores);
    const $selectionSize = () => store_get(selectionSize, "$selectionSize", $$stores);
    const $editorActionsAllowed = () => store_get(editorActionsAllowed, "$editorActionsAllowed", $$stores);
    const $visableViewports = () => store_get(visableViewports, "$visableViewports", $$stores);
    const $viewportByteIndicators = () => store_get(viewportByteIndicators, "$viewportByteIndicators", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    const byteElementWidth = /* @__PURE__ */ mutable_source();
    let awaitViewportSeek = prop($$props, "awaitViewportSeek", 12);
    let dataRadix = prop($$props, "dataRadix", 8, 16);
    let addressRadix2 = prop($$props, "addressRadix", 8, 16);
    let viewportData = prop($$props, "viewportData", 8);
    const DEBOUNCE_TIMEOUT_MS = 20;
    const CONTAINER_ID = "viewportData-container";
    const eventDispatcher = createEventDispatcher();
    function OFFSET_FETCH_ADJUSTMENT(direction, numLinesToScroll) {
      const newLineTopOffset = numLinesToScroll * $bytesPerRow() + $dataFeedLineTop() * $bytesPerRow();
      let scroll_count = Math.floor(newLineTopOffset / VIEWPORT_SCROLL_INCREMENT);
      if (direction === ViewportScrollDirection.INCREMENT) {
        const fetchBound = viewportData().fileOffset + scroll_count * VIEWPORT_SCROLL_INCREMENT;
        if (fetchBound > $fileMetrics().computedSize) return $fileMetrics().computedSize / $bytesPerRow() * $bytesPerRow() - $dataDislayLineAmount() * $bytesPerRow();
        return fetchBound;
      } else {
        const validBytesRemaining = viewportData().fileOffset + scroll_count * VIEWPORT_SCROLL_INCREMENT > 0;
        if (!validBytesRemaining) return 0;
        else {
          return viewportData().fileOffset + scroll_count * VIEWPORT_SCROLL_INCREMENT;
        }
      }
    }
    const INCREMENT_LINE = () => {
      store_set(seekOffsetInput, line_num_to_file_offset($dataFeedLineTop() + 1, viewportData().fileOffset, $bytesPerRow()).toString(addressRadix2()));
      eventDispatcher("seek");
    };
    const DECREMENT_LINE = () => {
      store_set(seekOffsetInput, line_num_to_file_offset($dataFeedLineTop() - 1, viewportData().fileOffset, $bytesPerRow()).toString(addressRadix2()));
      eventDispatcher("seek");
    };
    const INCREMENT_SEGMENT = () => {
      store_set(seekOffsetInput, line_num_to_file_offset($dataFeedLineTop() + $dataDislayLineAmount(), viewportData().fileOffset, $bytesPerRow()).toString(addressRadix2()));
      eventDispatcher("seek");
    };
    const DECREMENT_SEGMENT = () => {
      store_set(seekOffsetInput, line_num_to_file_offset($dataFeedLineTop() - $dataDislayLineAmount(), viewportData().fileOffset, $bytesPerRow()).toString(addressRadix2()));
      eventDispatcher("seek");
    };
    const SCROLL_TO_END = () => {
      store_set(seekOffsetInput, $fileMetrics().computedSize.toString(addressRadix2()));
      eventDispatcher("seek");
    };
    const SCROLL_TO_TOP = () => {
      store_set(seekOffsetInput, "0");
      eventDispatcher("seek");
    };
    let totalLinesPerFilesize = /* @__PURE__ */ mutable_source(0);
    let totalLinesPerViewport = /* @__PURE__ */ mutable_source(0);
    let lineTopMaxViewport = /* @__PURE__ */ mutable_source(64);
    let lineTopMaxFile = /* @__PURE__ */ mutable_source(64);
    let atViewportHead = /* @__PURE__ */ mutable_source(true);
    let atViewportTail = /* @__PURE__ */ mutable_source(false);
    let atFileHead = /* @__PURE__ */ mutable_source(true);
    let atFileTail = /* @__PURE__ */ mutable_source(false);
    let scrollDebounce = null;
    let percentageTraversed = /* @__PURE__ */ mutable_source(0);
    let disableIncrement = /* @__PURE__ */ mutable_source(false);
    let disableDecrement = /* @__PURE__ */ mutable_source(false);
    class ViewportScrollDirection {
    }
    Object.defineProperty(ViewportScrollDirection, "DECREMENT", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: -1
    });
    Object.defineProperty(ViewportScrollDirection, "NONE", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: 0
    });
    Object.defineProperty(ViewportScrollDirection, "INCREMENT", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: 1
    });
    let height = `calc(${$dataDislayLineAmount()} * 20)px`;
    let viewportLines = /* @__PURE__ */ mutable_source([]);
    let viewportDataContainer = /* @__PURE__ */ mutable_source();
    let selectedByteElement = /* @__PURE__ */ mutable_source();
    let themeClass = /* @__PURE__ */ mutable_source();
    let lineTopFileOffset = /* @__PURE__ */ mutable_source();
    let makingSelection = /* @__PURE__ */ mutable_source(false);
    onMount(() => {
      set(viewportDataContainer, document.getElementById(CONTAINER_ID));
      get$1(viewportDataContainer).addEventListener("wheel", navigation_wheel_event);
    });
    function generate_line_data(startIndex, dataRadix2, addressRadix3, endIndex = startIndex + ($dataDislayLineAmount() - 1)) {
      let ret = [];
      for (let i = startIndex; i <= endIndex; i++) {
        const viewportLineOffset = i * $bytesPerRow();
        const fileOffset = viewportLineOffset + viewportData().fileOffset;
        let bytes = [];
        const highlight = i % 2 === 0;
        for (let bytePos = 0; bytePos < $bytesPerRow(); bytePos++) {
          let byteOffset = viewportLineOffset + bytePos;
          bytes.push({
            offset: byteOffset,
            value: viewportData().data[byteOffset] !== void 0 ? viewportData().data[byteOffset] : -1,
            text: byteOffset < viewportData().length ? byte_value_string(viewportData().data[byteOffset], dataRadix2) : ""
          });
        }
        ret.push({
          offset: fileOffset.toString(addressRadix3).padStart(8, "0"),
          fileLine: fileOffset / $bytesPerRow(),
          bytes,
          highlight: highlight ? "even" : "odd"
        });
      }
      return ret;
    }
    function navigation_keydown_event(event2) {
      const { key: key2, shiftKey } = event2;
      if (key2 === "PageDown" || key2 === "ArrowDown") shiftKey ? INCREMENT_SEGMENT() : INCREMENT_LINE();
      else if (key2 === "PageUp" || key2 === "ArrowUp") shiftKey ? DECREMENT_SEGMENT() : DECREMENT_LINE();
      else if (key2 === "Home") DECREMENT_SEGMENT();
      else if (key2 === "End") INCREMENT_SEGMENT();
    }
    function navigation_wheel_event(event2) {
      event2.preventDefault();
      if (scrollDebounce) clearTimeout(scrollDebounce);
      scrollDebounce = setTimeout(
        () => {
          scrollDebounce = null;
          const direction = Math.sign(event2.deltaY);
          handle_navigation(direction);
        },
        DEBOUNCE_TIMEOUT_MS
      );
    }
    function at_scroll_boundary(direction) {
      return direction === ViewportScrollDirection.DECREMENT ? get$1(atViewportHead) && get$1(atFileHead) : get$1(atViewportTail) && get$1(atFileTail);
    }
    function direction_of_scroll(numLinesToScroll) {
      if (Math.sign(numLinesToScroll) > 0) return ViewportScrollDirection.INCREMENT;
      if (Math.sign(numLinesToScroll) < 0) return ViewportScrollDirection.DECREMENT;
      return ViewportScrollDirection.NONE;
    }
    function handle_navigation(numLinesToScroll) {
      const navDirection = direction_of_scroll(numLinesToScroll);
      if (at_scroll_boundary(navDirection)) return;
      if (at_fetch_boundary(navDirection, numLinesToScroll)) {
        const viewportOffset = viewportData().fileOffset;
        const lineTopOffset = get$1(viewportLines)[0].bytes[0].offset;
        const nextViewportOffset = OFFSET_FETCH_ADJUSTMENT(navDirection, numLinesToScroll);
        eventDispatcher("traverse-file", {
          nextViewportOffset,
          lineTopOnRefresh: Math.floor((viewportOffset + lineTopOffset - nextViewportOffset) / $bytesPerRow()) + numLinesToScroll
        });
        return;
      }
      const newLine = $dataFeedLineTop() + numLinesToScroll;
      store_set(dataFeedLineTop, Math.max(0, Math.min(newLine, get$1(lineTopMaxViewport))));
    }
    function at_fetch_boundary(direction, linesToMove = direction) {
      if (linesToMove != direction) return direction === ViewportScrollDirection.INCREMENT ? $dataFeedLineTop() + linesToMove >= get$1(lineTopMaxViewport) && !get$1(atFileTail) : $dataFeedLineTop() + linesToMove <= 0 && !get$1(atFileHead);
      return direction === ViewportScrollDirection.INCREMENT ? get$1(atViewportTail) && !get$1(atFileTail) : get$1(atViewportHead) && !get$1(atFileHead);
    }
    function mousedown(event2) {
      selectionDataStore.update((selections) => {
        selections.active = false;
        selections.startOffset = event2.targetByte.offset;
        selections.endOffset = -1;
        selections.originalEndOffset = -1;
        return selections;
      });
    }
    function mouseup(event2) {
      selectionDataStore.update((selections) => {
        selections.active = true;
        selections.endOffset = event2.targetByte.offset;
        selections.originalEndOffset = event2.targetByte.offset;
        adjust_event_offsets();
        return selections;
      });
      if (!$selectionDataStore().isValid()) {
        selectionDataStore.reset();
        return;
      }
      setByteSelection(event2);
    }
    function adjust_event_offsets() {
      const start = $selectionDataStore().startOffset;
      const end = $selectionDataStore().endOffset;
      if (start > end) {
        selectionDataStore.update((selections) => {
          selections.startOffset = end;
          selections.endOffset = start;
          return selections;
        });
      }
    }
    function setByteSelection(selectionEvent) {
      store_set(focusedViewportId, selectionEvent.fromViewport);
      store_set(selectedByte, $editMode() === EditByteModes.Single ? selectionEvent.targetByte : null_byte());
      set(selectedByteElement, selectionEvent.targetElement);
      editedDataSegment.update(() => {
        return viewportData().data.slice($selectionDataStore().startOffset, $selectionDataStore().originalEndOffset + 1);
      });
      $editMode() === EditByteModes.Single ? postEditorOnChangeMsg("hex") : postEditorOnChangeMsg();
    }
    function postEditorOnChangeMsg(forcedEncoding) {
      vscode.postMessage({
        command: MessageCommand.editorOnChange,
        data: {
          fileOffset: $selectionDataStore().startOffset + viewportData().fileOffset,
          selectionData: $editedDataSegment(),
          encoding: forcedEncoding ? forcedEncoding : $editorEncoding(),
          selectionSize: $selectionSize(),
          editMode: $editMode()
        }
      });
    }
    function handleClickedIndicator(e) {
      const offset = Math.ceil($fileMetrics().computedSize * (get$1(percentageTraversed) / 100) / $bytesPerRow()) * $bytesPerRow();
      const firstPageThreshold = $bytesPerRow() * $dataDislayLineAmount();
      const lastPageThreshold = $fileMetrics().computedSize - firstPageThreshold;
      if (offset <= firstPageThreshold) {
        SCROLL_TO_TOP();
      } else if (offset >= lastPageThreshold) {
        SCROLL_TO_END();
      } else {
        store_set(seekOffsetInput, offset.toString(addressRadix2()));
        eventDispatcher("seek");
        get$1(lineTopMaxViewport);
        awaitViewportSeek(true);
      }
    }
    function mouseover_handler(e) {
      if (!get$1(makingSelection)) return;
      const target = e.target;
      let targetViewportIndex = parseInt(target.getAttribute("offset"));
      selectionDataStore.update((selections) => {
        selections.endOffset = targetViewportIndex;
        adjust_event_offsets();
        return selections;
      });
    }
    function mouseclick_handler(e) {
      const type = e.type;
      const targetElement = e.target;
      let targetViewportIndex = parseInt(targetElement.getAttribute("offset"));
      let byteText = targetElement.innerHTML;
      let byteValue = byteText === void 0 ? -1 : parseInt(byteText);
      let targetByte = {
        offset: targetViewportIndex,
        text: byteText,
        value: byteValue
      };
      const byteSelectionEvent = {
        targetElement,
        targetByte,
        fromViewport: targetElement.id.includes("logical") ? "logical" : "physical"
      };
      switch (type) {
        case "mousedown":
          mousedown(byteSelectionEvent);
          break;
        case "mouseup":
          mouseup(byteSelectionEvent);
      }
    }
    function offsetDisplayRange() {
      return {
        first: get$1(viewportLines)[0].bytes[0].offset,
        last: get$1(viewportLines)[$dataDislayLineAmount() - 1].bytes[$bytesPerRow() - 1].offset
      };
    }
    function bytePosIsDisplayable(bytepos) {
      const { first, last } = offsetDisplayRange();
      return bytepos >= first + viewportData().fileOffset && bytepos < last + viewportData().fileOffset;
    }
    window.addEventListener("keydown", navigation_keydown_event);
    window.addEventListener("message", (msg) => {
      switch (msg.data.command) {
        case MessageCommand.viewportRefresh:
          if (awaitViewportSeek()) {
            awaitViewportSeek(false);
            store_set(dataFeedLineTop, Math.max(0, Math.min(get$1(lineTopMaxViewport), $dataFeedLineTop())));
            if ($selectionDataStore().active) set(selectedByteElement, document.getElementById($selectedByte().offset.toString()));
          }
          break;
        case "daffodil.data":
          const { bytePos1b } = msg.data.data;
          if (!bytePosIsDisplayable(bytePos1b - 1)) {
            store_set(seekOffsetInput, bytePos1b.toString(addressRadix2()));
            eventDispatcher("seek");
          }
          store_set(dfdlBytePos, bytePos1b - 1);
          break;
      }
    });
    legacy_pre_effect(() => $selectionDataStore(), () => {
      set(makingSelection, $selectionDataStore().startOffset >= 0 && $selectionDataStore().active === false);
    });
    legacy_pre_effect(() => $UIThemeCSSClass(), () => {
      set(themeClass, $UIThemeCSSClass());
    });
    legacy_pre_effect(
      () => (deep_read_state(viewportData()), deep_read_state(awaitViewportSeek()), $dataFeedLineTop(), get$1(viewportLines), $bytesPerRow(), deep_read_state(addressRadix2()), deep_read_state(dataRadix())),
      () => {
        if (viewportData().fileOffset >= 0 && !awaitViewportSeek() && $dataFeedLineTop() >= 0) {
          if (get$1(viewportLines).length !== 0 && $bytesPerRow() !== get$1(viewportLines)[0].bytes.length) {
            store_set(dataFeedLineTop, viewport_offset_to_line_num(parseInt(get$1(viewportLines)[0].offset, addressRadix2()), viewportData().fileOffset, $bytesPerRow()));
          }
          set(viewportLines, generate_line_data($dataFeedLineTop(), dataRadix(), addressRadix2()));
          store_set(searchResultsUpdated, false);
        }
      }
    );
    legacy_pre_effect(
      () => (get$1(totalLinesPerFilesize), $fileMetrics(), $bytesPerRow(), get$1(totalLinesPerViewport), deep_read_state(viewportData()), $dataDislayLineAmount(), get$1(lineTopMaxViewport), get$1(atViewportHead), $dataFeedLineTop(), get$1(atViewportTail), get$1(atFileHead), get$1(atFileTail), $selectionDataStore()),
      () => {
        set(totalLinesPerFilesize, Math.ceil($fileMetrics().computedSize / $bytesPerRow()));
        set(totalLinesPerViewport, Math.ceil(viewportData().data.length / $bytesPerRow()));
        set(lineTopMaxFile, Math.max(get$1(totalLinesPerFilesize) - $dataDislayLineAmount(), 0));
        set(lineTopMaxViewport, Math.max(get$1(totalLinesPerViewport) - $dataDislayLineAmount(), 0));
        set(atViewportHead, $dataFeedLineTop() === 0);
        set(atViewportTail, $dataFeedLineTop() === get$1(lineTopMaxViewport));
        set(atFileHead, viewportData().fileOffset === 0);
        set(atFileTail, viewportData().bytesLeft === 0);
        set(disableDecrement, $selectionDataStore().active || get$1(atViewportHead) && get$1(atFileHead));
        set(disableIncrement, $selectionDataStore().active || get$1(atViewportTail) && get$1(atFileTail));
        set(lineTopFileOffset, $dataFeedLineTop() * $bytesPerRow());
      }
    );
    legacy_pre_effect(() => deep_read_state(dataRadix()), () => {
      set(byteElementWidth, byteDivWidthFromRadix(dataRadix()));
    });
    legacy_pre_effect(() => $selectionDataStore(), () => {
      viewportByteIndicators.updateSelectionIndications($selectionDataStore());
    });
    legacy_pre_effect(
      () => ($searchQuery(), deep_read_state(viewportData())),
      () => {
        viewportByteIndicators.updateSearchIndications($searchQuery(), viewportData().fileOffset);
      }
    );
    legacy_pre_effect(
      () => ($replaceQuery(), deep_read_state(viewportData())),
      () => {
        viewportByteIndicators.updateReplaceIndications($replaceQuery(), viewportData().fileOffset);
      }
    );
    legacy_pre_effect(
      () => ($dfdlBytePos(), deep_read_state(viewportData())),
      () => {
        viewportByteIndicators.updateDebuggerPosIndication($dfdlBytePos(), viewportData().fileOffset);
      }
    );
    legacy_pre_effect(() => ($selectionDataStore(), get$1(viewportDataContainer)), () => {
      if ($selectionDataStore().active) {
        window.removeEventListener("keydown", navigation_keydown_event);
        if (get$1(viewportDataContainer)) get$1(viewportDataContainer).removeEventListener("wheel", navigation_wheel_event);
      } else {
        window.addEventListener("keydown", navigation_keydown_event);
        if (get$1(viewportDataContainer)) get$1(viewportDataContainer).addEventListener("wheel", navigation_wheel_event);
      }
    });
    legacy_pre_effect_reset();
    init();
    var div = root$4();
    event("mousemove", $window, mouseover_handler);
    set_attribute(div, "id", CONTAINER_ID);
    set_style(div, "", {}, { height });
    var node = child(div);
    {
      var consequent = ($$anchor2) => {
        var fragment = comment();
        var node_1 = first_child(fragment);
        key(
          node_1,
          () => ($selectedByte(), get$1(selectedByteElement), deep_read_state(dataRadix()), $editorActionsAllowed(), deep_read_state(EditActionRestrictions), untrack(() => $selectedByte() || get$1(selectedByteElement) || dataRadix() || $editorActionsAllowed() == EditActionRestrictions.None)),
          ($$anchor3) => {
            SelectedByteEdit($$anchor3, {
              get byte() {
                return $selectedByte();
              },
              $$events: {
                seek($$arg) {
                  bubble_event.call(this, $$props, $$arg);
                },
                applyChanges($$arg) {
                  bubble_event.call(this, $$props, $$arg);
                },
                handleEditorEvent($$arg) {
                  bubble_event.call(this, $$props, $$arg);
                }
              }
            });
          }
        );
        append($$anchor2, fragment);
      };
      if_block(node, ($$render) => {
        if ($selectionDataStore(), $editMode(), deep_read_state(EditByteModes), untrack(() => $selectionDataStore().active && $editMode() == EditByteModes.Single)) $$render(consequent);
      });
    }
    var node_2 = sibling(node, 2);
    each(node_2, 1, () => get$1(viewportLines), index, ($$anchor2, viewportLine, i) => {
      var div_1 = root_3$1();
      var div_2 = child(div_1);
      var b = child(div_2);
      var text2 = child(b);
      var node_3 = sibling(div_2, 2);
      {
        var consequent_1 = ($$anchor3) => {
          var div_3 = root_4$2();
          each(
            div_3,
            5,
            () => (get$1(viewportLine), untrack(() => get$1(viewportLine).bytes)),
            index,
            ($$anchor4, byte) => {
              {
                let $0 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(categoryCSSSelectors), $viewportByteIndicators(), get$1(byte), untrack(() => categoryCSSSelectors($viewportByteIndicators()[get$1(byte).offset]))));
                let $1 = /* @__PURE__ */ derived_safe_equal(() => (get$1(byte), untrack(() => get$1(byte).value === -1)));
                DataValue($$anchor4, {
                  get byte() {
                    return get$1(byte);
                  },
                  id: "physical",
                  get categoryIndicationSelectors() {
                    return get$1($0);
                  },
                  get width() {
                    return get$1(byteElementWidth);
                  },
                  get disabled() {
                    return get$1($1);
                  }
                });
              }
            }
          );
          template_effect(($0) => set_attribute(div_3, "id", `physical-line-${$0 ?? ""}`), [() => untrack(() => i.toString(16).padStart(2, "0"))]);
          append($$anchor3, div_3);
        };
        if_block(node_3, ($$render) => {
          if ($visableViewports() === "physical" || $visableViewports() === "all") $$render(consequent_1);
        });
      }
      var node_4 = sibling(node_3, 2);
      {
        var consequent_2 = ($$anchor3) => {
          var div_4 = root_6$2();
          each(
            div_4,
            5,
            () => (get$1(viewportLine), untrack(() => get$1(viewportLine).bytes)),
            index,
            ($$anchor4, byte) => {
              {
                let $0 = /* @__PURE__ */ derived_safe_equal(() => (deep_read_state(categoryCSSSelectors), $viewportByteIndicators(), get$1(byte), untrack(() => categoryCSSSelectors($viewportByteIndicators()[get$1(byte).offset]))));
                let $1 = /* @__PURE__ */ derived_safe_equal(() => (get$1(byte), untrack(() => get$1(byte).value === -1)));
                DataValue($$anchor4, {
                  get byte() {
                    return get$1(byte);
                  },
                  get categoryIndicationSelectors() {
                    return get$1($0);
                  },
                  id: "logical",
                  get width() {
                    return get$1(byteElementWidth);
                  },
                  get disabled() {
                    return get$1($1);
                  }
                });
              }
            }
          );
          template_effect(($0) => set_attribute(div_4, "id", `logical-line-${$0 ?? ""}`), [() => untrack(() => i.toString(16).padStart(2, "0"))]);
          append($$anchor3, div_4);
        };
        if_block(node_4, ($$render) => {
          if ($visableViewports() === "logical" || $visableViewports() === "all") $$render(consequent_2);
        });
      }
      template_effect(() => {
        set_class(
          div_1,
          1,
          (get$1(viewportLine), get$1(themeClass), untrack(() => `line ${get$1(viewportLine).highlight} ${get$1(themeClass)}`)),
          "svelte-1ltndc4"
        );
        set_text(text2, (get$1(viewportLine), untrack(() => get$1(viewportLine).offset)));
      });
      append($$anchor2, div_1);
    });
    var node_5 = sibling(node_2, 2);
    {
      css_props(node_5, () => ({ "--dir": "column" }));
      FlexContainer(node_5.lastChild, {
        children: ($$anchor2, $$slotProps) => {
          var fragment_4 = root_8$2();
          var node_6 = first_child(fragment_4);
          FileTraversalIndicator(node_6, {
            get totalLines() {
              return get$1(totalLinesPerFilesize);
            },
            get selectionActive() {
              return $selectionDataStore(), untrack(() => $selectionDataStore().active);
            },
            get currentLine() {
              return $dataFeedLineTop();
            },
            get fileOffset() {
              return deep_read_state(viewportData()), untrack(() => viewportData().fileOffset);
            },
            get maxDisplayLines() {
              return $dataDislayLineAmount();
            },
            get percentageTraversed() {
              return get$1(percentageTraversed);
            },
            set percentageTraversed($$value) {
              set(percentageTraversed, $$value);
            },
            $$events: { indicatorClicked: handleClickedIndicator },
            $$legacy: true
          });
          var node_7 = sibling(node_6, 2);
          {
            css_props(node_7, () => ({ "--dir": "row" }));
            FlexContainer(node_7.lastChild, {
              children: ($$anchor3, $$slotProps2) => {
                var fragment_5 = root_9$1();
                var node_8 = first_child(fragment_5);
                Button(node_8, {
                  fn: SCROLL_TO_END,
                  get disabledBy() {
                    return get$1(disableIncrement);
                  },
                  width: "30pt",
                  description: "Navigate to EOF",
                  tooltipAlwaysEnabled: true,
                  $$slots: {
                    left: ($$anchor4, $$slotProps3) => {
                      var span = root_10$1();
                      append($$anchor4, span);
                    }
                  }
                });
                var node_9 = sibling(node_8, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => $dataDislayLineAmount() * $bytesPerRow());
                  Button(node_9, {
                    fn: INCREMENT_SEGMENT,
                    get disabledBy() {
                      return get$1(disableIncrement);
                    },
                    width: "30pt",
                    get description() {
                      return `Increment offset by ${get$1($0) ?? ""} bytes`;
                    },
                    tooltipAlwaysEnabled: true,
                    $$slots: {
                      left: ($$anchor4, $$slotProps3) => {
                        var span_1 = root_11$1();
                        append($$anchor4, span_1);
                      }
                    }
                  });
                }
                var node_10 = sibling(node_9, 2);
                Button(node_10, {
                  fn: INCREMENT_LINE,
                  get disabledBy() {
                    return get$1(disableIncrement);
                  },
                  width: "30pt",
                  get description() {
                    return `Increment offset by ${$bytesPerRow() ?? ""} bytes`;
                  },
                  tooltipAlwaysEnabled: true,
                  $$slots: {
                    left: ($$anchor4, $$slotProps3) => {
                      var span_2 = root_12$1();
                      append($$anchor4, span_2);
                    }
                  }
                });
                var node_11 = sibling(node_10, 2);
                Button(node_11, {
                  fn: DECREMENT_LINE,
                  get disabledBy() {
                    return get$1(disableDecrement);
                  },
                  width: "30pt",
                  get description() {
                    return `Decrement offset by ${$bytesPerRow() ?? ""} bytes`;
                  },
                  tooltipAlwaysEnabled: true,
                  $$slots: {
                    left: ($$anchor4, $$slotProps3) => {
                      var span_3 = root_13$1();
                      append($$anchor4, span_3);
                    }
                  }
                });
                var node_12 = sibling(node_11, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => $dataDislayLineAmount() * $bytesPerRow());
                  Button(node_12, {
                    fn: DECREMENT_SEGMENT,
                    get disabledBy() {
                      return get$1(disableDecrement);
                    },
                    width: "30pt",
                    get description() {
                      return `Decrement offset by ${get$1($0) ?? ""} bytes`;
                    },
                    tooltipAlwaysEnabled: true,
                    $$slots: {
                      left: ($$anchor4, $$slotProps3) => {
                        var span_4 = root_14$1();
                        append($$anchor4, span_4);
                      }
                    }
                  });
                }
                var node_13 = sibling(node_12, 2);
                Button(node_13, {
                  fn: SCROLL_TO_TOP,
                  get disabledBy() {
                    return get$1(disableDecrement);
                  },
                  width: "30pt",
                  description: "Navigate to offset 0",
                  tooltipAlwaysEnabled: true,
                  $$slots: {
                    left: ($$anchor4, $$slotProps3) => {
                      var span_5 = root_15$1();
                      append($$anchor4, span_5);
                    }
                  }
                });
                var node_14 = sibling(node_13, 4);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => ($dataDislayLineAmount() + 1) * $bytesPerRow() >= VIEWPORT_SCROLL_INCREMENT);
                  let $1 = /* @__PURE__ */ derived_safe_equal(() => "Increment display lines (" + ($dataDislayLineAmount() + 1) + ")");
                  Button(node_14, {
                    fn: () => {
                      store_set(dataDislayLineAmount, $dataDislayLineAmount() + 1);
                      set(viewportLines, generate_line_data($dataFeedLineTop(), dataRadix(), addressRadix2()));
                    },
                    get disabledBy() {
                      return get$1($0);
                    },
                    get description() {
                      return get$1($1);
                    },
                    tooltipAlwaysEnabled: true,
                    width: "30pt",
                    $$slots: {
                      left: ($$anchor4, $$slotProps3) => {
                        var span_6 = root_16$1();
                        append($$anchor4, span_6);
                      }
                    }
                  });
                }
                var node_15 = sibling(node_14, 2);
                {
                  let $0 = /* @__PURE__ */ derived_safe_equal(() => $dataDislayLineAmount() === 1);
                  let $1 = /* @__PURE__ */ derived_safe_equal(() => "Decrement display lines (" + ($dataDislayLineAmount() - 1) + ")");
                  Button(node_15, {
                    fn: () => {
                      store_set(dataDislayLineAmount, $dataDislayLineAmount() - 1);
                      set(viewportLines, generate_line_data($dataFeedLineTop(), dataRadix(), addressRadix2()));
                    },
                    get disabledBy() {
                      return get$1($0);
                    },
                    get description() {
                      return get$1($1);
                    },
                    tooltipAlwaysEnabled: true,
                    width: "30pt",
                    $$slots: {
                      left: ($$anchor4, $$slotProps3) => {
                        var span_7 = root_17$1();
                        append($$anchor4, span_7);
                      }
                    }
                  });
                }
                append($$anchor3, fragment_5);
              },
              $$slots: { default: true }
            });
          }
          append($$anchor2, fragment_4);
        },
        $$slots: { default: true }
      });
    }
    event("mousedown", div, mouseclick_handler);
    event("mouseup", div, mouseclick_handler);
    append($$anchor, div);
    pop();
    $$cleanup();
  }
  function DataViewports($$anchor, $$props) {
    const $viewport = () => store_get(viewport, "$viewport", $$stores);
    const $displayRadix = () => store_get(displayRadix, "$displayRadix", $$stores);
    const $addressRadix = () => store_get(addressRadix, "$addressRadix", $$stores);
    const $dataFeedAwaitRefresh = () => store_get(dataFeedAwaitRefresh, "$dataFeedAwaitRefresh", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    DataLineFeed($$anchor, {
      get viewportData() {
        return $viewport();
      },
      get dataRadix() {
        return $displayRadix();
      },
      get addressRadix() {
        return $addressRadix();
      },
      get awaitViewportSeek() {
        mark_store_binding();
        return $dataFeedAwaitRefresh();
      },
      set awaitViewportSeek($$value) {
        store_set(dataFeedAwaitRefresh, $$value);
      },
      $$events: {
        "traverse-file"($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        seek($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        applyChanges($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        handleEditorEvent($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }
      },
      $$legacy: true
    });
    $$cleanup();
  }
  var root_1$1 = /* @__PURE__ */ from_html(`<option> </option>`);
  var root_4$1 = /* @__PURE__ */ from_html(`<div class="physical-addr-seg binary svelte-1qjtql"><div><b> </b></div> <div><b></b></div></div>`);
  var root_6$1 = /* @__PURE__ */ from_html(`<div class="physical-addr-seg svelte-1qjtql"><b> </b></div>`);
  var root_2$2 = /* @__PURE__ */ from_html(`<div class="hdr physical-header svelte-1qjtql"><div>Physical</div> <div><!></div></div>`);
  var root_8$1 = /* @__PURE__ */ from_html(`<div class="logical-addr-seg svelte-1qjtql"> </div>`);
  var root_7 = /* @__PURE__ */ from_html(`<div class="hdr logical-header svelte-1qjtql"><div>Logical</div> <div></div></div>`);
  var root$3 = /* @__PURE__ */ from_html(`<div class="headers svelte-1qjtql"><div class="hdr address-header svelte-1qjtql"><div>Address</div> <select id="address_numbering"></select></div> <!> <!></div>`);
  function DisplayHeader($$anchor, $$props) {
    push($$props, false);
    const $addressRadix = () => store_get(addressRadix, "$addressRadix", $$stores);
    const $displayRadix = () => store_get(displayRadix, "$displayRadix", $$stores);
    const $bytesPerRow = () => store_get(bytesPerRow, "$bytesPerRow", $$stores);
    const $seekOffsetSearchType = () => store_get(seekOffsetSearchType, "$seekOffsetSearchType", $$stores);
    const $seekOffsetInput = () => store_get(seekOffsetInput, "$seekOffsetInput", $$stores);
    const $seekOffset = () => store_get(seekOffset, "$seekOffset", $$stores);
    const $UIThemeCSSClass = () => store_get(UIThemeCSSClass, "$UIThemeCSSClass", $$stores);
    const $visableViewports = () => store_get(visableViewports, "$visableViewports", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    let offsetLine = /* @__PURE__ */ mutable_source([]);
    function generate_offset_headers(addressRadix2, displayRadix2, bytesPerRow2) {
      let ret = [];
      if (displayRadix2 != RADIX_OPTIONS.Binary) {
        for (let i = 0; i < bytesPerRow2; i++) {
          ret.push(i.toString(addressRadix2).padStart(2, "0"));
        }
      } else {
        for (let i = 0; i < bytesPerRow2; i++) {
          ret.push(i.toString(addressRadix2));
        }
      }
      return ret;
    }
    function setSelectionOffsetInfo(from, start, end, size, radix) {
      return `${from} [${start.toString(radix)} - ${end.toString(radix)}] Size: ${size.toString(radix)} `;
    }
    function updateAddressValue(event2) {
      const addrSelect = event2.target;
      const newAddrRadix = parseInt(addrSelect.value);
      if ($seekOffsetSearchType() === OffsetSearchType.RELATIVE) {
        const sign = $seekOffsetInput().substring(0, 1);
        const value = parseInt($seekOffsetInput().substring(1), $addressRadix()).toString(newAddrRadix);
        store_set(seekOffsetInput, value === "NaN" ? "0" : sign + value);
      } else {
        const newSeekInput = $seekOffset().toString(parseInt(addrSelect.value));
        store_set(seekOffsetInput, newSeekInput === "NaN" ? "0" : newSeekInput);
      }
      store_set(addressRadix, newAddrRadix);
    }
    legacy_pre_effect(() => ($addressRadix(), $displayRadix(), $bytesPerRow()), () => {
      set(offsetLine, generate_offset_headers($addressRadix(), $displayRadix(), $bytesPerRow()));
    });
    legacy_pre_effect_reset();
    var $$exports = { setSelectionOffsetInfo };
    init();
    var div = root$3();
    var div_1 = child(div);
    set_style(div_1, "", {}, { "min-width": "110px" });
    var div_2 = child(div_1);
    var select = sibling(div_2, 2);
    each(select, 5, () => ADDRESS_RADIX_OPTIONS, index, ($$anchor2, $$item) => {
      let name = () => get$1($$item).name;
      let value = () => get$1($$item).value;
      var option = root_1$1();
      var text2 = child(option);
      var option_value = {};
      template_effect(() => {
        set_text(text2, name());
        if (option_value !== (option_value = value())) {
          option.value = (option.__value = value()) ?? "";
        }
      });
      append($$anchor2, option);
    });
    var node = sibling(div_1, 2);
    {
      var consequent_1 = ($$anchor2) => {
        var div_3 = root_2$2();
        var div_4 = child(div_3);
        var div_5 = sibling(div_4, 2);
        var node_1 = child(div_5);
        {
          var consequent = ($$anchor3) => {
            var fragment = comment();
            var node_2 = first_child(fragment);
            each(node_2, 1, () => get$1(offsetLine), index, ($$anchor4, offset) => {
              var div_6 = root_4$1();
              let styles;
              var div_7 = child(div_6);
              var b = child(div_7);
              var text_1 = child(b);
              var div_8 = sibling(div_7, 2);
              var b_1 = child(div_8);
              b_1.textContent = "01234567";
              template_effect(
                ($0) => {
                  styles = set_style(div_6, "", styles, $0);
                  set_text(text_1, get$1(offset));
                },
                [
                  () => ({
                    "min-width": (deep_read_state(byteDivWidthFromRadix), $displayRadix(), untrack(() => byteDivWidthFromRadix($displayRadix())))
                  })
                ]
              );
              append($$anchor4, div_6);
            });
            append($$anchor3, fragment);
          };
          var alternate = ($$anchor3) => {
            var fragment_1 = comment();
            var node_3 = first_child(fragment_1);
            each(node_3, 1, () => get$1(offsetLine), index, ($$anchor4, offset) => {
              var div_9 = root_6$1();
              let styles_1;
              var b_2 = child(div_9);
              var text_2 = child(b_2);
              template_effect(
                ($0) => {
                  styles_1 = set_style(div_9, "", styles_1, $0);
                  set_text(text_2, get$1(offset));
                },
                [
                  () => ({
                    "min-width": (deep_read_state(byteDivWidthFromRadix), $displayRadix(), untrack(() => byteDivWidthFromRadix($displayRadix())))
                  })
                ]
              );
              append($$anchor4, div_9);
            });
            append($$anchor3, fragment_1);
          };
          if_block(node_1, ($$render) => {
            if ($displayRadix(), deep_read_state(RADIX_OPTIONS), untrack(() => $displayRadix() === RADIX_OPTIONS.Binary)) $$render(consequent);
            else $$render(alternate, false);
          });
        }
        template_effect(() => {
          set_class(div_4, 1, $UIThemeCSSClass() + " hd", "svelte-1qjtql");
          set_class(div_5, 1, $UIThemeCSSClass() + " measure physical-viewport-header", "svelte-1qjtql");
        });
        append($$anchor2, div_3);
      };
      if_block(node, ($$render) => {
        if ($visableViewports() === "physical" || $visableViewports() === "all") $$render(consequent_1);
      });
    }
    var node_4 = sibling(node, 2);
    {
      var consequent_2 = ($$anchor2) => {
        var div_10 = root_7();
        var div_11 = child(div_10);
        var div_12 = sibling(div_11, 2);
        let styles_2;
        each(div_12, 5, () => get$1(offsetLine), index, ($$anchor3, offset) => {
          var div_13 = root_8$1();
          let styles_3;
          var text_3 = child(div_13);
          template_effect(
            ($0) => {
              styles_3 = set_style(div_13, "", styles_3, $0);
              set_text(text_3, get$1(offset));
            },
            [
              () => ({
                "min-width": (deep_read_state(byteDivWidthFromRadix), deep_read_state(RADIX_OPTIONS), untrack(() => byteDivWidthFromRadix(RADIX_OPTIONS.Hexadecimal)))
              })
            ]
          );
          append($$anchor3, div_13);
        });
        template_effect(() => {
          set_class(div_11, 1, $UIThemeCSSClass() + " hd", "svelte-1qjtql");
          set_class(div_12, 1, $UIThemeCSSClass() + " measure logical logical-viewport-header", "svelte-1qjtql");
          styles_2 = set_style(div_12, "", styles_2, {
            "align-items": ($displayRadix(), deep_read_state(RADIX_OPTIONS), untrack(() => $displayRadix() === RADIX_OPTIONS.Binary ? "flex-end" : "normal"))
          });
        });
        append($$anchor2, div_10);
      };
      if_block(node_4, ($$render) => {
        if ($visableViewports() === "logical" || $visableViewports() === "all") $$render(consequent_2);
      });
    }
    template_effect(() => {
      set_class(div_2, 1, $UIThemeCSSClass() + " hd", "svelte-1qjtql");
      set_class(select, 1, $UIThemeCSSClass() + " address_type", "svelte-1qjtql");
    });
    event("change", select, updateAddressValue);
    append($$anchor, div);
    bind_prop($$props, "setSelectionOffsetInfo", setSelectionOffsetInfo);
    var $$pop = pop($$exports);
    $$cleanup();
    return $$pop;
  }
  var root$2 = /* @__PURE__ */ from_html(`<main class="dataEditor"><div class="data-viewports svelte-1bojhsa"><!> <!></div> <div class="data-editor svelte-1bojhsa"><!></div></main>`);
  function Main($$anchor, $$props) {
    var main = root$2();
    var div = child(main);
    var node = child(div);
    DisplayHeader(node, {
      $$events: {
        clearDataDisplays($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }
      }
    });
    var node_1 = sibling(node, 2);
    DataViewports(node_1, {
      $$events: {
        clearDataDisplays($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        scrolledToTop($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        scrolledToEnd($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        applyChanges($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        handleEditorEvent($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        scrollBoundary($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        "traverse-file"($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        seek($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }
      }
    });
    var div_1 = sibling(div, 2);
    var node_2 = child(div_1);
    DataEditor(node_2, {
      $$events: {
        applyChanges($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        handleEditorEvent($$arg) {
          bubble_event.call(this, $$props, $$arg);
        },
        clearDataDisplays($$arg) {
          bubble_event.call(this, $$props, $$arg);
        }
      }
    });
    append($$anchor, main);
  }
  var root_4 = /* @__PURE__ */ from_svg(`<circle cx="50%" cy="50%" r="4pt" fill="green"></circle>`);
  var root_6 = /* @__PURE__ */ from_svg(`<circle cx="50%" cy="50%" r="4pt" fill="yellow"></circle>`);
  var root_8 = /* @__PURE__ */ from_svg(`<circle cx="50%" cy="50%" r="4pt" fill="red"></circle>`);
  var root_9 = /* @__PURE__ */ from_svg(`<circle cx="50%" cy="50%" r="4pt" fill="grey"></circle>`);
  var root_10 = /* @__PURE__ */ from_html(`<b>Latency:</b> `, 1);
  var root_11 = /* @__PURE__ */ from_html(`<b>Uptime:</b> `, 1);
  var root_12 = /* @__PURE__ */ from_html(`<b>Session Count:</b> `, 1);
  var root_13 = /* @__PURE__ */ from_html(`<b>CPU Load Avg:</b> `, 1);
  var root_14 = /* @__PURE__ */ from_html(`<b>Memory Usage:</b> `, 1);
  var root_15 = /* @__PURE__ */ from_html(`<b>Process ID:</b> `, 1);
  var root_16 = /* @__PURE__ */ from_html(`<b>JVM Version:</b> `, 1);
  var root_17 = /* @__PURE__ */ from_html(`<b>JVM Vendor:</b> `, 1);
  var root_3 = /* @__PURE__ */ from_html(`<svg class="latency-indicator svelte-uol2nb"><!></svg> <div class="heartbeat-info svelte-uol2nb"><!> <!> <!> <!> <!> <!> <!> <!></div>`, 1);
  var root_2$1 = /* @__PURE__ */ from_html(`<div class="info svelte-uol2nb"> </div> <!>`, 1);
  var root_18 = /* @__PURE__ */ from_html(`<div class="info svelte-uol2nb">&#9889; Powered by Ωedit™ (heartbeat not received)</div>`);
  var root$1 = /* @__PURE__ */ from_html(`<svelte-css-wrapper style="display: contents"><!></svelte-css-wrapper>`, 1);
  function ServerMetrics($$anchor, $$props) {
    push($$props, false);
    let heartbeat = /* @__PURE__ */ mutable_source({
      latency: 0,
      serverCpuLoadAverage: 0,
      serverTimestamp: 0,
      serverUptime: 0,
      serverUsedMemory: 0,
      sessionCount: 0,
      omegaEditPort: 0,
      serverVersion: "Unknown",
      serverHostname: "Unknown",
      serverProcessId: 0,
      jvmVersion: "Unknown",
      jvmVendor: "Unknown",
      jvmPath: "Unknown",
      availableProcessors: 0
    });
    let timerId;
    function showHeartbeatInfo(show) {
      const element = document.getElementsByClassName("heartbeat-info")[0];
      element.style.opacity = show ? ".7" : "0";
    }
    function prettyPrintUptime(uptimeInMilliseconds) {
      const uptimeSeconds = Math.floor(uptimeInMilliseconds / 1e3);
      const days = Math.floor(uptimeSeconds / (60 * 60 * 24));
      const hours = Math.floor(uptimeSeconds % (60 * 60 * 24) / (60 * 60));
      const minutes = Math.floor(uptimeSeconds % (60 * 60) / 60);
      const seconds = Math.floor(uptimeSeconds % 60);
      let uptimeString = "";
      if (days > 0) {
        uptimeString += days === 1 ? `${days} day, ` : `${days} days, `;
      }
      if (hours > 0) {
        uptimeString += hours === 1 ? `${hours} hour, ` : `${hours} hours, `;
      }
      if (minutes > 0) {
        uptimeString += minutes === 1 ? `${minutes} minute, ` : `${minutes} minutes, `;
      }
      return uptimeString + (seconds === 1) ? `${seconds} second` : `${seconds} seconds`;
    }
    window.addEventListener("message", (msg) => {
      switch (msg.data.command) {
        case MessageCommand.heartbeat:
          mutate(heartbeat, get$1(heartbeat).latency = msg.data.data.latency);
          mutate(heartbeat, get$1(heartbeat).serverCpuLoadAverage = msg.data.data.serverCpuLoadAverage);
          mutate(heartbeat, get$1(heartbeat).serverTimestamp = msg.data.data.serverTimestamp);
          mutate(heartbeat, get$1(heartbeat).serverUptime = msg.data.data.serverUptime);
          mutate(heartbeat, get$1(heartbeat).serverUsedMemory = msg.data.data.serverUsedMemory);
          mutate(heartbeat, get$1(heartbeat).sessionCount = msg.data.data.sessionCount);
          mutate(heartbeat, get$1(heartbeat).omegaEditPort = msg.data.data.serverInfo.omegaEditPort);
          mutate(heartbeat, get$1(heartbeat).serverVersion = msg.data.data.serverInfo.serverVersion);
          mutate(heartbeat, get$1(heartbeat).serverHostname = msg.data.data.serverInfo.serverHostname);
          mutate(heartbeat, get$1(heartbeat).serverProcessId = msg.data.data.serverInfo.serverProcessId);
          mutate(heartbeat, get$1(heartbeat).jvmVersion = msg.data.data.serverInfo.jvmVersion);
          mutate(heartbeat, get$1(heartbeat).jvmVendor = msg.data.data.serverInfo.jvmVendor);
          mutate(heartbeat, get$1(heartbeat).jvmPath = msg.data.data.serverInfo.jvmPath);
          mutate(heartbeat, get$1(heartbeat).availableProcessors = msg.data.data.serverInfo.availableProcessors);
          clearTimeout(timerId);
          timerId = setTimeout(
            () => {
              mutate(heartbeat, get$1(heartbeat).serverTimestamp = 0);
            },
            5e3
          );
          break;
      }
    });
    init();
    var fragment = root$1();
    var node = first_child(fragment);
    {
      css_props(node, () => ({ "--height": "25pt", "--align-items": "center" }));
      FlexContainer(node.lastChild, {
        children: ($$anchor2, $$slotProps) => {
          var fragment_1 = comment();
          var node_1 = first_child(fragment_1);
          {
            var consequent_11 = ($$anchor3) => {
              var fragment_2 = root_2$1();
              var div = first_child(fragment_2);
              var text2 = child(div);
              var node_2 = sibling(div, 2);
              FlexContainer(node_2, {
                children: ($$anchor4, $$slotProps2) => {
                  var fragment_3 = root_3();
                  var svg = first_child(fragment_3);
                  var node_3 = child(svg);
                  {
                    var consequent = ($$anchor5) => {
                      var circle = root_4();
                      append($$anchor5, circle);
                    };
                    var alternate_2 = ($$anchor5) => {
                      var fragment_4 = comment();
                      var node_4 = first_child(fragment_4);
                      {
                        var consequent_1 = ($$anchor6) => {
                          var circle_1 = root_6();
                          append($$anchor6, circle_1);
                        };
                        var alternate_1 = ($$anchor6) => {
                          var fragment_5 = comment();
                          var node_5 = first_child(fragment_5);
                          {
                            var consequent_2 = ($$anchor7) => {
                              var circle_2 = root_8();
                              append($$anchor7, circle_2);
                            };
                            var alternate = ($$anchor7) => {
                              var circle_3 = root_9();
                              append($$anchor7, circle_3);
                            };
                            if_block(
                              node_5,
                              ($$render) => {
                                if (0 < get$1(heartbeat).latency && get$1(heartbeat).latency > 60) $$render(consequent_2);
                                else $$render(alternate, false);
                              },
                              true
                            );
                          }
                          append($$anchor6, fragment_5);
                        };
                        if_block(
                          node_4,
                          ($$render) => {
                            if (0 < get$1(heartbeat).latency && get$1(heartbeat).latency < 40) $$render(consequent_1);
                            else $$render(alternate_1, false);
                          },
                          true
                        );
                      }
                      append($$anchor5, fragment_4);
                    };
                    if_block(node_3, ($$render) => {
                      if (0 < get$1(heartbeat).latency && get$1(heartbeat).latency < 20) $$render(consequent);
                      else $$render(alternate_2, false);
                    });
                  }
                  var div_1 = sibling(svg, 2);
                  var node_6 = child(div_1);
                  {
                    var consequent_3 = ($$anchor5) => {
                      var fragment_6 = root_10();
                      var text_1 = sibling(first_child(fragment_6));
                      template_effect(() => set_text(text_1, ` ${get$1(heartbeat).latency ?? ""}ms,`));
                      append($$anchor5, fragment_6);
                    };
                    if_block(node_6, ($$render) => {
                      if (get$1(heartbeat).latency > 0) $$render(consequent_3);
                    });
                  }
                  var node_7 = sibling(node_6, 2);
                  {
                    var consequent_4 = ($$anchor5) => {
                      var fragment_7 = root_11();
                      var text_2 = sibling(first_child(fragment_7));
                      template_effect(($0) => set_text(text_2, ` ${$0 ?? ""}`), [() => prettyPrintUptime(get$1(heartbeat).serverUptime)]);
                      append($$anchor5, fragment_7);
                    };
                    if_block(node_7, ($$render) => {
                      if (get$1(heartbeat).serverUptime > 0) $$render(consequent_4);
                    });
                  }
                  var node_8 = sibling(node_7, 2);
                  {
                    var consequent_5 = ($$anchor5) => {
                      var fragment_8 = root_12();
                      var text_3 = sibling(first_child(fragment_8));
                      template_effect(() => set_text(text_3, ` ${get$1(heartbeat).sessionCount ?? ""},`));
                      append($$anchor5, fragment_8);
                    };
                    if_block(node_8, ($$render) => {
                      if (get$1(heartbeat).sessionCount > 0) $$render(consequent_5);
                    });
                  }
                  var node_9 = sibling(node_8, 2);
                  {
                    var consequent_6 = ($$anchor5) => {
                      var fragment_9 = root_13();
                      var text_4 = sibling(first_child(fragment_9));
                      template_effect(($0) => set_text(text_4, ` ${$0 ?? ""},`), [() => get$1(heartbeat).serverCpuLoadAverage.toFixed(2)]);
                      append($$anchor5, fragment_9);
                    };
                    if_block(node_9, ($$render) => {
                      if (get$1(heartbeat).serverCpuLoadAverage > 0) $$render(consequent_6);
                    });
                  }
                  var node_10 = sibling(node_9, 2);
                  {
                    var consequent_7 = ($$anchor5) => {
                      var fragment_10 = root_14();
                      var text_5 = sibling(first_child(fragment_10));
                      template_effect(() => set_text(text_5, ` ${get$1(heartbeat).serverUsedMemory ?? ""},`));
                      append($$anchor5, fragment_10);
                    };
                    if_block(node_10, ($$render) => {
                      if (get$1(heartbeat).serverUsedMemory > 0) $$render(consequent_7);
                    });
                  }
                  var node_11 = sibling(node_10, 2);
                  {
                    var consequent_8 = ($$anchor5) => {
                      var fragment_11 = root_15();
                      var text_6 = sibling(first_child(fragment_11));
                      template_effect(() => set_text(text_6, ` ${get$1(heartbeat).serverProcessId ?? ""},`));
                      append($$anchor5, fragment_11);
                    };
                    if_block(node_11, ($$render) => {
                      if (get$1(heartbeat).serverProcessId > 0) $$render(consequent_8);
                    });
                  }
                  var node_12 = sibling(node_11, 2);
                  {
                    var consequent_9 = ($$anchor5) => {
                      var fragment_12 = root_16();
                      var text_7 = sibling(first_child(fragment_12));
                      template_effect(() => set_text(text_7, ` ${get$1(heartbeat).jvmVersion ?? ""}`));
                      append($$anchor5, fragment_12);
                    };
                    if_block(node_12, ($$render) => {
                      if (get$1(heartbeat).jvmVersion.length > 0) $$render(consequent_9);
                    });
                  }
                  var node_13 = sibling(node_12, 2);
                  {
                    var consequent_10 = ($$anchor5) => {
                      var fragment_13 = root_17();
                      var text_8 = sibling(first_child(fragment_13));
                      template_effect(() => set_text(text_8, ` ${get$1(heartbeat).jvmVendor ?? ""}`));
                      append($$anchor5, fragment_13);
                    };
                    if_block(node_13, ($$render) => {
                      if (get$1(heartbeat).jvmVendor.length > 0) $$render(consequent_10);
                    });
                  }
                  event("mouseenter", svg, () => showHeartbeatInfo(true));
                  event("mouseleave", svg, () => showHeartbeatInfo(false));
                  append($$anchor4, fragment_3);
                },
                $$slots: { default: true }
              });
              template_effect(() => set_text(text2, `⚡ Powered by Ωedit™ v${get$1(heartbeat).serverVersion ?? ""} on port ${get$1(heartbeat).omegaEditPort ?? ""}
       `));
              append($$anchor3, fragment_2);
            };
            var alternate_3 = ($$anchor3) => {
              var div_2 = root_18();
              append($$anchor3, div_2);
            };
            if_block(node_1, ($$render) => {
              if (get$1(heartbeat).serverTimestamp !== 0) $$render(consequent_11);
              else $$render(alternate_3, false);
            });
          }
          append($$anchor2, fragment_1);
        },
        $$slots: { default: true }
      });
    }
    append($$anchor, fragment);
    pop();
  }
  const EditInstructionsHelp = {
    title: "Edit Modes",
    sectionId: "edit-instructions",
    descriptionBody: [
      "<h3>Multiple Byte Edits</h3>",
      "To edit multiple bytes, highlight, by clicking and dragging over, a selection of bytes in either the physical or logical viewports. This will populate the     'Edit' panel with the data to edit.",
      "<h3>Single Byte Edits</h3>",
      "To edit a single byte, simply click any singular byte within either of the viewports. This is replace the content with an input field to perform edits."
    ]
  };
  const AvailableHelpSections = {
    "edit-instructions": EditInstructionsHelp
  };
  var root_2 = /* @__PURE__ */ from_html(`<div class="help-section-info"><!></div>`);
  var root_1 = /* @__PURE__ */ from_html(`<div class="help-container svelte-1ptnp2d"><div class="header svelte-1ptnp2d"><span class="material-symbols-outlined exit svelte-1ptnp2d">close</span> <h3 class="svelte-1ptnp2d"> </h3></div> <!></div>`);
  function Help($$anchor, $$props) {
    push($$props, false);
    const $currentHelpSectionDisplayed = () => store_get(currentHelpSectionDisplayed, "$currentHelpSectionDisplayed", $$stores);
    const $currentHelpSectionEvent = () => store_get(currentHelpSectionEvent, "$currentHelpSectionEvent", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    let displayHelp = /* @__PURE__ */ mutable_source(false);
    let top = /* @__PURE__ */ mutable_source(), left = /* @__PURE__ */ mutable_source();
    legacy_pre_effect(() => $currentHelpSectionDisplayed(), () => {
      set(displayHelp, $currentHelpSectionDisplayed().length > 0);
    });
    legacy_pre_effect(() => $currentHelpSectionEvent(), () => {
      let sectionTarget = $currentHelpSectionEvent().target;
      if (sectionTarget) {
        set(top, sectionTarget.offsetTop + 352 > document.body.clientHeight ? (document.body.clientHeight - 352).toString() + "px" : sectionTarget.offsetTop.toString() + "px");
        set(left, sectionTarget.offsetLeft + 402 > document.body.clientWidth ? (document.body.clientWidth - 402).toString() + "px" : sectionTarget.offsetLeft.toString() + "px");
      }
    });
    legacy_pre_effect_reset();
    init();
    var fragment = comment();
    var node = first_child(fragment);
    {
      var consequent = ($$anchor2) => {
        var div = root_1();
        let styles;
        var div_1 = child(div);
        var span = child(div_1);
        var h3 = sibling(span, 2);
        var text2 = child(h3);
        var node_1 = sibling(div_1, 2);
        each(
          node_1,
          1,
          () => (deep_read_state(AvailableHelpSections), $currentHelpSectionDisplayed(), untrack(() => AvailableHelpSections[$currentHelpSectionDisplayed()].descriptionBody)),
          index,
          ($$anchor3, sectional) => {
            var div_2 = root_2();
            var node_2 = child(div_2);
            html(node_2, () => get$1(sectional));
            append($$anchor3, div_2);
          }
        );
        template_effect(() => {
          styles = set_style(div, "", styles, { top: get$1(top), left: get$1(left) });
          set_text(text2, `Help: ${(deep_read_state(AvailableHelpSections), $currentHelpSectionDisplayed(), untrack(() => AvailableHelpSections[$currentHelpSectionDisplayed()].title)) ?? ""}`);
        });
        event("click", span, () => {
          store_set(currentHelpSectionDisplayed, "");
        });
        append($$anchor2, div);
      };
      if_block(node, ($$render) => {
        if (get$1(displayHelp)) $$render(consequent);
      });
    }
    append($$anchor, fragment);
    pop();
    $$cleanup();
  }
  var root = /* @__PURE__ */ from_html(`<!> <!> <!> <hr class="svelte-1n46o8q"/> <!>`, 1);
  function App($$anchor, $$props) {
    push($$props, false);
    const $requestable = () => store_get(requestable, "$requestable", $$stores);
    const $selectionDataStore = () => store_get(selectionDataStore, "$selectionDataStore", $$stores);
    const $editorSelection = () => store_get(editorSelection, "$editorSelection", $$stores);
    const $focusedViewportId = () => store_get(focusedViewportId, "$focusedViewportId", $$stores);
    const $selectionSize = () => store_get(selectionSize, "$selectionSize", $$stores);
    const $editorEncoding = () => store_get(editorEncoding, "$editorEncoding", $$stores);
    const $displayRadix = () => store_get(displayRadix, "$displayRadix", $$stores);
    const $editMode = () => store_get(editMode, "$editMode", $$stores);
    const $viewport = () => store_get(viewport, "$viewport", $$stores);
    const $bytesPerRow = () => store_get(bytesPerRow, "$bytesPerRow", $$stores);
    const $seekOffset = () => store_get(seekOffset, "$seekOffset", $$stores);
    const $dataDislayLineAmount = () => store_get(dataDislayLineAmount, "$dataDislayLineAmount", $$stores);
    const $regularSizedFile = () => store_get(regularSizedFile, "$regularSizedFile", $$stores);
    const $originalDataSegment = () => store_get(originalDataSegment, "$originalDataSegment", $$stores);
    const $editedDataSegment = () => store_get(editedDataSegment, "$editedDataSegment", $$stores);
    const $darkUITheme = () => store_get(darkUITheme, "$darkUITheme", $$stores);
    const [$$stores, $$cleanup] = setup_stores();
    function requestEditedData() {
      if ($requestable()) {
        vscode.postMessage({
          command: MessageCommand.requestEditedData,
          data: {
            selectionToFileOffset: $selectionDataStore().startOffset,
            editedContent: $editorSelection(),
            viewport: $focusedViewportId(),
            selectionSize: $selectionSize(),
            encoding: $editorEncoding(),
            radix: $displayRadix(),
            editMode: $editMode()
          }
        });
      }
    }
    function offset_to_viewport_line_number(offset, bytesPerRow2, viewportStartOffset = $viewport().fileOffset) {
      const nearestBPRdivisibleTargetFileOffset = byte_count_divisible_offset(offset, bytesPerRow2);
      const nearestBPRdivisibleViewportFileOffset = byte_count_divisible_offset(viewportStartOffset, bytesPerRow2);
      return (nearestBPRdivisibleTargetFileOffset - nearestBPRdivisibleViewportFileOffset) / bytesPerRow2;
    }
    function fetchable_content(offset) {
      return offset > $viewport().fileOffset ? $viewport().bytesLeft > 0 : $viewport().fileOffset > 0;
    }
    function should_fetch_new_viewoprt(offset) {
      const lowerBound = viewport.lowerFetchBoundary();
      const upperBound = viewport.upperFetchBoundary($bytesPerRow());
      const fetchableContent = fetchable_content(offset);
      if (!fetchableContent) return false;
      const boundaryTripped = offset < lowerBound || offset > upperBound;
      return boundaryTripped;
    }
    function seek(offsetArg) {
      if (!offsetArg) offsetArg = $seekOffset();
      const shouldFetchData = should_fetch_new_viewoprt(offsetArg);
      if (!shouldFetchData) {
        store_set(dataFeedLineTop, Math.min(viewport.lineTopMax($bytesPerRow()), offset_to_viewport_line_number(offsetArg, $bytesPerRow())));
        return;
      }
      store_set(dataFeedAwaitRefresh, true);
      const fetchOffset = Math.max(0, byte_count_divisible_offset(offsetArg - (VIEWPORT_SCROLL_INCREMENT - $bytesPerRow()), $bytesPerRow()));
      store_set(dataFeedLineTop, offset_to_viewport_line_number(offsetArg, $bytesPerRow(), fetchOffset));
      vscode.postMessage({
        command: MessageCommand.scrollViewport,
        data: {
          scrollOffset: fetchOffset,
          bytesPerRow: $bytesPerRow(),
          numLinesDisplayed: $dataDislayLineAmount()
        }
      });
      clearDataDisplays();
    }
    function seekEventHandler(_) {
      seek($seekOffset());
    }
    function traversalEventHandler(navigationEvent) {
      const navigationData = navigationEvent.detail;
      store_set(dataFeedAwaitRefresh, true);
      vscode.postMessage({
        command: MessageCommand.scrollViewport,
        data: {
          scrollOffset: navigationData.nextViewportOffset,
          bytesPerRow: $bytesPerRow()
        }
      });
      store_set(dataFeedLineTop, navigationData.lineTopOnRefresh);
      clearDataDisplays();
    }
    function handleEditorEvent(_) {
      if ($regularSizedFile() && $selectionSize() < 0) {
        clearDataDisplays();
        return;
      }
      if (!$regularSizedFile() && $editorSelection().length == 0) return;
      requestEditedData();
    }
    function custom_apply_changes(event2) {
      const action2 = event2.detail.action;
      let editedData;
      let originalData = $originalDataSegment();
      let editedOffset = $regularSizedFile() ? $selectionDataStore().startOffset + $viewport().fileOffset : 0;
      switch (action2) {
        case "insert-after":
          ++editedOffset;
        case // intentional fallthrough
        "insert-before":
          originalData = new Uint8Array(0);
        case "byte-input":
          editedData = $editedDataSegment().subarray(0, 1);
          break;
        case "insert-replace":
          editedData = !$regularSizedFile() && $editorSelection().length == 0 ? new Uint8Array(0) : $editedDataSegment();
          break;
        case "delete":
          editedData = new Uint8Array(0);
          break;
      }
      vscode.postMessage({
        command: MessageCommand.applyChanges,
        data: {
          offset: editedOffset,
          originalSegment: originalData,
          editedSegment: editedData
        }
      });
      clearDataDisplays();
      clearQueryableData();
    }
    function undo() {
      vscode.postMessage({ command: MessageCommand.undoChange });
    }
    function redo() {
      vscode.postMessage({ command: MessageCommand.redoChange });
    }
    function clearChangeStack() {
      vscode.postMessage({ command: MessageCommand.clearChanges });
    }
    function clearDataDisplays() {
      store_set(selectionDataStore, new SelectionData_t());
      store_set(editorSelection, "");
      store_set(editedDataSegment, new Uint8Array(0));
    }
    function clearQueryableData() {
      searchQuery.clear();
    }
    function handleKeyBind(event2) {
      const kbdEvent = event2;
      if (key_is_mappable(kbdEvent.key)) {
        if (document.activeElement)
          elementKeypressEventMap.run(document.activeElement.id, kbdEvent);
        return;
      }
      switch (kbdEvent.key) {
        case "Escape":
          clearDataDisplays();
          return;
      }
    }
    window.addEventListener("message", (msg) => {
      switch (msg.data.command) {
        case MessageCommand.editorOnChange:
          if ($editMode() === EditByteModes.Multiple) store_set(editorSelection, msg.data.display);
          break;
        case MessageCommand.requestEditedData:
          store_set(editorSelection, msg.data.data.dataDisplay);
          if ($editMode() === EditByteModes.Multiple) {
            store_set(editedDataSegment, new Uint8Array(msg.data.data.data));
          } else {
            store_mutate(editedDataSegment, untrack($editedDataSegment)[0] = msg.data.data.data, untrack($editedDataSegment));
          }
          store_mutate(selectionDataStore, untrack($selectionDataStore).endOffset = $selectionDataStore().startOffset + $editedDataSegment().byteLength - 1, untrack($selectionDataStore));
          break;
        case MessageCommand.setUITheme:
          store_set(darkUITheme, msg.data.theme === 2);
          store_set(UIThemeCSSClass, $darkUITheme() ? CSSThemeClass.Dark : CSSThemeClass.Light);
          break;
        case MessageCommand.viewportRefresh:
          const { data: data2, fileOffset, length, bytesLeft } = msg.data.data;
          store_set(viewport, { data: data2, fileOffset, length, bytesLeft });
          break;
      }
    });
    init();
    var fragment = root();
    event("keydown", $window, handleKeyBind, void 0, false);
    var node = first_child(fragment);
    Header(node, {
      $$events: {
        clearChangeStack,
        seek: seekEventHandler,
        clearDataDisplays,
        redo,
        undo
      }
    });
    var node_1 = sibling(node, 2);
    Main(node_1, {
      $$events: {
        clearDataDisplays,
        applyChanges: custom_apply_changes,
        handleEditorEvent,
        "traverse-file": traversalEventHandler,
        seek: seekEventHandler
      }
    });
    var node_2 = sibling(node_1, 2);
    Help(node_2, {});
    var node_3 = sibling(node_2, 4);
    ServerMetrics(node_3, {});
    append($$anchor, fragment);
    pop();
    $$cleanup();
  }
  mount(App, {
    target: document.getElementById("app")
  });
})();
//# sourceMappingURL=index.js.map
