"use strict";
Object.defineProperty(exports, Symbol.toStringTag, { value: "Module" });
const vscode = require("vscode");
const require$$1 = require("events");
const require$$3 = require("url");
const path = require("path");
const fs = require("fs");
const os = require("os");
const child_process = require("child_process");
const require$$0 = require("stream");
const require$$1$1 = require("util");
const require$$3$1 = require("zlib");
const promises = require("stream/promises");
const require$$1$2 = require("string_decoder");
const require$$1$3 = require("buffer");
const require$$3$2 = require("process");
const require$$4 = require("tty");
const require$$6 = require("dns");
const assert = require("assert");
const require$$8 = require("node:diagnostics_channel");
const require$$10 = require("module");
const require$$12 = require("tls");
const require$$14 = require("http2");
const require$$15 = require("node:process");
const require$$16 = require("node:url");
const require$$17 = require("node:child_process");
const require$$18 = require("node:string_decoder");
const require$$19 = require("node:util");
const require$$20 = require("node:tty");
const require$$21 = require("node:timers/promises");
const require$$22 = require("node:v8");
const require$$23 = require("node:fs");
const require$$24 = require("node:stream");
const require$$25 = require("node:buffer");
const require$$26 = require("node:stream/promises");
const require$$27 = require("node:path");
const require$$29 = require("node:os");
const require$$30 = require("worker_threads");
const require$$31 = require("node:events");
const require$$32 = require("http");
const require$$34 = require("net");
const require$$4$1 = require("timers");
function _interopNamespaceDefault(e) {
  const n = Object.create(null, { [Symbol.toStringTag]: { value: "Module" } });
  if (e) {
    for (const k in e) {
      if (k !== "default") {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}
const vscode__namespace = /* @__PURE__ */ _interopNamespaceDefault(vscode);
const path__namespace = /* @__PURE__ */ _interopNamespaceDefault(path);
const fs__namespace = /* @__PURE__ */ _interopNamespaceDefault(fs);
const os__namespace = /* @__PURE__ */ _interopNamespaceDefault(os);
const child_process__namespace = /* @__PURE__ */ _interopNamespaceDefault(child_process);
function activate$9(context) {
  var controller = new PositionController();
  context.subscriptions.push(controller);
  context.subscriptions.push(
    vscode__namespace.commands.registerCommand(
      "position.goto",
      () => controller.goToPositionCommand()
    )
  );
}
function getOptionalNumber(numberAsString) {
  let optionalNumber = void 0;
  let isRelative = false;
  let num = Number(numberAsString);
  if (!isNaN(num) && numberAsString && numberAsString.length) {
    optionalNumber = num;
    isRelative = ["+", "-"].includes(numberAsString.charAt(0));
  }
  return [optionalNumber, isRelative];
}
class PositionController {
  constructor() {
    this.statusBarItem = vscode__namespace.window.createStatusBarItem(
      vscode__namespace.StatusBarAlignment.Right,
      100
    );
    this.statusBarItem.command = "position.goto";
    this.statusBarItem.tooltip = "Go to position";
    let subscriptions = [];
    vscode__namespace.window.onDidChangeTextEditorSelection(
      this.onEvent,
      this,
      subscriptions
    );
    vscode__namespace.window.onDidChangeActiveTextEditor(this.onEvent, this, subscriptions);
    this.disposable = vscode__namespace.Disposable.from(...subscriptions);
    this.updatePosition();
  }
  goToPositionCommand() {
    let manager;
    manager = CursorManager.create();
    if (!manager) {
      return;
    }
    vscode__namespace.window.showInputBox({
      prompt: `Type an offset number from 0 to ${manager.maxPosition}.`,
      value: String(manager.cursorOffset),
      validateInput: (input) => {
        manager.previewCursorOffset(input);
        return void 0;
      }
    }).then((input) => {
      input !== void 0 ? manager.commit() : manager.abort();
    });
  }
  updatePosition() {
    let manager = CursorManager.create();
    if (!manager) {
      this.statusBarItem.hide();
      return;
    }
    let offset = manager.cursorOffset;
    if (offset !== void 0) {
      this.statusBarItem.text = `Pos ${offset}`;
      this.statusBarItem.show();
    }
  }
  onEvent() {
    this.updatePosition();
  }
  dispose() {
    this.disposable.dispose();
    this.statusBarItem.dispose();
  }
}
class CursorManager {
  constructor(editor, document2) {
    this.editor = editor;
    this.document = document2;
    this.originalCursorOffset = document2.offsetAt(editor.selection.active);
    this.cachedSelections = [editor.selection];
    this.cachedSelections.push(...editor.selections);
  }
  static {
    this.cursorPositionDecoration = vscode__namespace.window.createTextEditorDecorationType({
      borderColor: new vscode__namespace.ThemeColor("editor.foreground"),
      borderStyle: "solid",
      borderWidth: "1px",
      outlineColor: new vscode__namespace.ThemeColor("editor.foreground"),
      outlineStyle: "solid",
      outlineWidth: "1px"
    });
  }
  static create() {
    let editor = vscode__namespace.window.activeTextEditor;
    let doc = editor ? editor.document : void 0;
    if (!doc) {
      return void 0;
    }
    return new CursorManager(editor, doc);
  }
  get cursor() {
    return this.editor.selection.active;
  }
  get cursorOffset() {
    return this.document.offsetAt(this.cursor);
  }
  // public get selections() : vscode.Selection[] {
  //     return this.editor.selections;
  // }
  set selections(selections) {
    this.editor.selections = selections;
  }
  get maxPosition() {
    return this.document.offsetAt(
      new vscode__namespace.Position(Number.MAX_SAFE_INTEGER, Number.MAX_SAFE_INTEGER)
    );
  }
  previewCursorOffset(offset) {
    let [newOffset, isRelative] = getOptionalNumber(offset);
    let success = false;
    if (newOffset !== void 0) {
      if (isRelative) {
        newOffset += this.originalCursorOffset;
      }
      if (newOffset !== this.cursorOffset) {
        let newPosition = this.document.positionAt(newOffset);
        this.cachedSelections[0] = new vscode__namespace.Selection(
          newPosition,
          newPosition
        );
        this.editor.selections = this.cachedSelections;
      }
      success = true;
    }
    const range2 = new vscode__namespace.Range(this.cursor, this.cursor.translate(0, 1));
    this.editor.setDecorations(CursorManager.cursorPositionDecoration, [range2]);
    this.reveal();
    return success;
  }
  commit() {
    this.clearDecorations();
    this.editor.selection = this.cachedSelections[0];
    vscode__namespace.window.showTextDocument(this.document, {
      selection: this.cachedSelections[0]
    });
  }
  abort() {
    this.clearDecorations();
    this.cachedSelections.splice(0, 1);
    this.editor.selections = this.cachedSelections;
    this.reveal();
  }
  clearDecorations() {
    this.editor.setDecorations(CursorManager.cursorPositionDecoration, []);
  }
  reveal(revealType) {
    revealType = revealType || vscode__namespace.TextEditorRevealType.InCenterIfOutsideViewport;
    this.editor.revealRange(this.editor.selection, revealType);
  }
}
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
var main = {};
var debugSession = {};
var protocol = {};
var messages = {};
var hasRequiredMessages;
function requireMessages() {
  if (hasRequiredMessages) return messages;
  hasRequiredMessages = 1;
  Object.defineProperty(messages, "__esModule", { value: true });
  messages.Event = messages.Response = messages.Message = void 0;
  class Message {
    constructor(type) {
      this.seq = 0;
      this.type = type;
    }
  }
  messages.Message = Message;
  class Response extends Message {
    constructor(request, message) {
      super("response");
      this.request_seq = request.seq;
      this.command = request.command;
      if (message) {
        this.success = false;
        this.message = message;
      } else {
        this.success = true;
      }
    }
  }
  messages.Response = Response;
  class Event extends Message {
    constructor(event, body) {
      super("event");
      this.event = event;
      if (body) {
        this.body = body;
      }
    }
  }
  messages.Event = Event;
  return messages;
}
var hasRequiredProtocol;
function requireProtocol() {
  if (hasRequiredProtocol) return protocol;
  hasRequiredProtocol = 1;
  Object.defineProperty(protocol, "__esModule", { value: true });
  protocol.ProtocolServer = void 0;
  const ee = require$$1;
  const messages_1 = requireMessages();
  class Emitter {
    get event() {
      if (!this._event) {
        this._event = (listener, thisArg) => {
          this._listener = listener;
          this._this = thisArg;
          let result;
          result = {
            dispose: () => {
              this._listener = void 0;
              this._this = void 0;
            }
          };
          return result;
        };
      }
      return this._event;
    }
    fire(event) {
      if (this._listener) {
        try {
          this._listener.call(this._this, event);
        } catch (e) {
        }
      }
    }
    hasListener() {
      return !!this._listener;
    }
    dispose() {
      this._listener = void 0;
      this._this = void 0;
    }
  }
  class ProtocolServer extends ee.EventEmitter {
    constructor() {
      super();
      this._sendMessage = new Emitter();
      this._sequence = 1;
      this._pendingRequests = /* @__PURE__ */ new Map();
      this.onDidSendMessage = this._sendMessage.event;
    }
    // ---- implements vscode.Debugadapter interface ---------------------------
    dispose() {
    }
    handleMessage(msg) {
      if (msg.type === "request") {
        this.dispatchRequest(msg);
      } else if (msg.type === "response") {
        const response = msg;
        const clb = this._pendingRequests.get(response.request_seq);
        if (clb) {
          this._pendingRequests.delete(response.request_seq);
          clb(response);
        }
      }
    }
    _isRunningInline() {
      return this._sendMessage && this._sendMessage.hasListener();
    }
    //--------------------------------------------------------------------------
    start(inStream, outStream) {
      this._writableStream = outStream;
      this._rawData = Buffer.alloc(0);
      inStream.on("data", (data) => this._handleData(data));
      inStream.on("close", () => {
        this._emitEvent(new messages_1.Event("close"));
      });
      inStream.on("error", (error) => {
        this._emitEvent(new messages_1.Event("error", "inStream error: " + (error && error.message)));
      });
      outStream.on("error", (error) => {
        this._emitEvent(new messages_1.Event("error", "outStream error: " + (error && error.message)));
      });
      inStream.resume();
    }
    stop() {
      if (this._writableStream) {
        this._writableStream.end();
      }
    }
    sendEvent(event) {
      this._send("event", event);
    }
    sendResponse(response) {
      if (response.seq > 0) {
        console.error(`attempt to send more than one response for command ${response.command}`);
      } else {
        this._send("response", response);
      }
    }
    sendRequest(command, args, timeout2, cb) {
      const request = {
        command
      };
      if (args && Object.keys(args).length > 0) {
        request.arguments = args;
      }
      this._send("request", request);
      if (cb) {
        this._pendingRequests.set(request.seq, cb);
        const timer = setTimeout(() => {
          clearTimeout(timer);
          const clb = this._pendingRequests.get(request.seq);
          if (clb) {
            this._pendingRequests.delete(request.seq);
            clb(new messages_1.Response(request, "timeout"));
          }
        }, timeout2);
      }
    }
    // ---- protected ----------------------------------------------------------
    dispatchRequest(request) {
    }
    // ---- private ------------------------------------------------------------
    _emitEvent(event) {
      this.emit(event.event, event);
    }
    _send(typ, message) {
      message.type = typ;
      message.seq = this._sequence++;
      if (this._writableStream) {
        const json = JSON.stringify(message);
        this._writableStream.write(`Content-Length: ${Buffer.byteLength(json, "utf8")}\r
\r
${json}`, "utf8");
      }
      this._sendMessage.fire(message);
    }
    _handleData(data) {
      this._rawData = Buffer.concat([this._rawData, data]);
      while (true) {
        if (this._contentLength >= 0) {
          if (this._rawData.length >= this._contentLength) {
            const message = this._rawData.toString("utf8", 0, this._contentLength);
            this._rawData = this._rawData.slice(this._contentLength);
            this._contentLength = -1;
            if (message.length > 0) {
              try {
                let msg = JSON.parse(message);
                this.handleMessage(msg);
              } catch (e) {
                this._emitEvent(new messages_1.Event("error", "Error handling data: " + (e && e.message)));
              }
            }
            continue;
          }
        } else {
          const idx = this._rawData.indexOf(ProtocolServer.TWO_CRLF);
          if (idx !== -1) {
            const header = this._rawData.toString("utf8", 0, idx);
            const lines = header.split("\r\n");
            for (let i = 0; i < lines.length; i++) {
              const pair = lines[i].split(/: +/);
              if (pair[0] == "Content-Length") {
                this._contentLength = +pair[1];
              }
            }
            this._rawData = this._rawData.slice(idx + ProtocolServer.TWO_CRLF.length);
            continue;
          }
        }
        break;
      }
    }
  }
  protocol.ProtocolServer = ProtocolServer;
  ProtocolServer.TWO_CRLF = "\r\n\r\n";
  return protocol;
}
var runDebugAdapterStub = {};
var hasRequiredRunDebugAdapterStub;
function requireRunDebugAdapterStub() {
  if (hasRequiredRunDebugAdapterStub) return runDebugAdapterStub;
  hasRequiredRunDebugAdapterStub = 1;
  Object.defineProperty(runDebugAdapterStub, "__esModule", { value: true });
  runDebugAdapterStub.runDebugAdapter = void 0;
  function runDebugAdapter() {
  }
  runDebugAdapterStub.runDebugAdapter = runDebugAdapter;
  return runDebugAdapterStub;
}
var hasRequiredDebugSession;
function requireDebugSession() {
  if (hasRequiredDebugSession) return debugSession;
  hasRequiredDebugSession = 1;
  (function(exports2) {
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DebugSession = exports2.ErrorDestination = exports2.MemoryEvent = exports2.InvalidatedEvent = exports2.ProgressEndEvent = exports2.ProgressUpdateEvent = exports2.ProgressStartEvent = exports2.CapabilitiesEvent = exports2.LoadedSourceEvent = exports2.ModuleEvent = exports2.BreakpointEvent = exports2.ThreadEvent = exports2.OutputEvent = exports2.ExitedEvent = exports2.TerminatedEvent = exports2.InitializedEvent = exports2.ContinuedEvent = exports2.StoppedEvent = exports2.CompletionItem = exports2.Module = exports2.Breakpoint = exports2.Variable = exports2.Thread = exports2.StackFrame = exports2.Scope = exports2.Source = void 0;
    const protocol_1 = requireProtocol();
    const messages_1 = requireMessages();
    const runDebugAdapter_1 = requireRunDebugAdapterStub();
    const url_1 = require$$3;
    class Source {
      constructor(name, path2, id = 0, origin, data) {
        this.name = name;
        this.path = path2;
        this.sourceReference = id;
        if (origin) {
          this.origin = origin;
        }
        if (data) {
          this.adapterData = data;
        }
      }
    }
    exports2.Source = Source;
    class Scope {
      constructor(name, reference, expensive = false) {
        this.name = name;
        this.variablesReference = reference;
        this.expensive = expensive;
      }
    }
    exports2.Scope = Scope;
    class StackFrame {
      constructor(i, nm, src, ln = 0, col = 0) {
        this.id = i;
        this.source = src;
        this.line = ln;
        this.column = col;
        this.name = nm;
      }
    }
    exports2.StackFrame = StackFrame;
    class Thread {
      constructor(id, name) {
        this.id = id;
        if (name) {
          this.name = name;
        } else {
          this.name = "Thread #" + id;
        }
      }
    }
    exports2.Thread = Thread;
    class Variable {
      constructor(name, value, ref = 0, indexedVariables, namedVariables) {
        this.name = name;
        this.value = value;
        this.variablesReference = ref;
        if (typeof namedVariables === "number") {
          this.namedVariables = namedVariables;
        }
        if (typeof indexedVariables === "number") {
          this.indexedVariables = indexedVariables;
        }
      }
    }
    exports2.Variable = Variable;
    class Breakpoint {
      constructor(verified, line, column, source) {
        this.verified = verified;
        const e = this;
        if (typeof line === "number") {
          e.line = line;
        }
        if (typeof column === "number") {
          e.column = column;
        }
        if (source) {
          e.source = source;
        }
      }
      setId(id) {
        this.id = id;
      }
    }
    exports2.Breakpoint = Breakpoint;
    class Module {
      constructor(id, name) {
        this.id = id;
        this.name = name;
      }
    }
    exports2.Module = Module;
    class CompletionItem {
      constructor(label, start, length = 0) {
        this.label = label;
        this.start = start;
        this.length = length;
      }
    }
    exports2.CompletionItem = CompletionItem;
    class StoppedEvent extends messages_1.Event {
      constructor(reason, threadId, exceptionText) {
        super("stopped");
        this.body = {
          reason
        };
        if (typeof threadId === "number") {
          this.body.threadId = threadId;
        }
        if (typeof exceptionText === "string") {
          this.body.text = exceptionText;
        }
      }
    }
    exports2.StoppedEvent = StoppedEvent;
    class ContinuedEvent extends messages_1.Event {
      constructor(threadId, allThreadsContinued) {
        super("continued");
        this.body = {
          threadId
        };
        if (typeof allThreadsContinued === "boolean") {
          this.body.allThreadsContinued = allThreadsContinued;
        }
      }
    }
    exports2.ContinuedEvent = ContinuedEvent;
    class InitializedEvent extends messages_1.Event {
      constructor() {
        super("initialized");
      }
    }
    exports2.InitializedEvent = InitializedEvent;
    class TerminatedEvent extends messages_1.Event {
      constructor(restart) {
        super("terminated");
        if (typeof restart === "boolean" || restart) {
          const e = this;
          e.body = {
            restart
          };
        }
      }
    }
    exports2.TerminatedEvent = TerminatedEvent;
    class ExitedEvent extends messages_1.Event {
      constructor(exitCode) {
        super("exited");
        this.body = {
          exitCode
        };
      }
    }
    exports2.ExitedEvent = ExitedEvent;
    class OutputEvent extends messages_1.Event {
      constructor(output, category = "console", data) {
        super("output");
        this.body = {
          category,
          output
        };
        if (data !== void 0) {
          this.body.data = data;
        }
      }
    }
    exports2.OutputEvent = OutputEvent;
    class ThreadEvent extends messages_1.Event {
      constructor(reason, threadId) {
        super("thread");
        this.body = {
          reason,
          threadId
        };
      }
    }
    exports2.ThreadEvent = ThreadEvent;
    class BreakpointEvent extends messages_1.Event {
      constructor(reason, breakpoint) {
        super("breakpoint");
        this.body = {
          reason,
          breakpoint
        };
      }
    }
    exports2.BreakpointEvent = BreakpointEvent;
    class ModuleEvent extends messages_1.Event {
      constructor(reason, module2) {
        super("module");
        this.body = {
          reason,
          module: module2
        };
      }
    }
    exports2.ModuleEvent = ModuleEvent;
    class LoadedSourceEvent extends messages_1.Event {
      constructor(reason, source) {
        super("loadedSource");
        this.body = {
          reason,
          source
        };
      }
    }
    exports2.LoadedSourceEvent = LoadedSourceEvent;
    class CapabilitiesEvent extends messages_1.Event {
      constructor(capabilities) {
        super("capabilities");
        this.body = {
          capabilities
        };
      }
    }
    exports2.CapabilitiesEvent = CapabilitiesEvent;
    class ProgressStartEvent extends messages_1.Event {
      constructor(progressId, title, message) {
        super("progressStart");
        this.body = {
          progressId,
          title
        };
        if (typeof message === "string") {
          this.body.message = message;
        }
      }
    }
    exports2.ProgressStartEvent = ProgressStartEvent;
    class ProgressUpdateEvent extends messages_1.Event {
      constructor(progressId, message) {
        super("progressUpdate");
        this.body = {
          progressId
        };
        if (typeof message === "string") {
          this.body.message = message;
        }
      }
    }
    exports2.ProgressUpdateEvent = ProgressUpdateEvent;
    class ProgressEndEvent extends messages_1.Event {
      constructor(progressId, message) {
        super("progressEnd");
        this.body = {
          progressId
        };
        if (typeof message === "string") {
          this.body.message = message;
        }
      }
    }
    exports2.ProgressEndEvent = ProgressEndEvent;
    class InvalidatedEvent extends messages_1.Event {
      constructor(areas, threadId, stackFrameId) {
        super("invalidated");
        this.body = {};
        if (areas) {
          this.body.areas = areas;
        }
        if (threadId) {
          this.body.threadId = threadId;
        }
        if (stackFrameId) {
          this.body.stackFrameId = stackFrameId;
        }
      }
    }
    exports2.InvalidatedEvent = InvalidatedEvent;
    class MemoryEvent extends messages_1.Event {
      constructor(memoryReference, offset, count) {
        super("memory");
        this.body = { memoryReference, offset, count };
      }
    }
    exports2.MemoryEvent = MemoryEvent;
    var ErrorDestination;
    (function(ErrorDestination2) {
      ErrorDestination2[ErrorDestination2["User"] = 1] = "User";
      ErrorDestination2[ErrorDestination2["Telemetry"] = 2] = "Telemetry";
    })(ErrorDestination = exports2.ErrorDestination || (exports2.ErrorDestination = {}));
    class DebugSession extends protocol_1.ProtocolServer {
      constructor(obsolete_debuggerLinesAndColumnsStartAt1, obsolete_isServer) {
        super();
        const linesAndColumnsStartAt1 = typeof obsolete_debuggerLinesAndColumnsStartAt1 === "boolean" ? obsolete_debuggerLinesAndColumnsStartAt1 : false;
        this._debuggerLinesStartAt1 = linesAndColumnsStartAt1;
        this._debuggerColumnsStartAt1 = linesAndColumnsStartAt1;
        this._debuggerPathsAreURIs = false;
        this._clientLinesStartAt1 = true;
        this._clientColumnsStartAt1 = true;
        this._clientPathsAreURIs = false;
        this._isServer = typeof obsolete_isServer === "boolean" ? obsolete_isServer : false;
        this.on("close", () => {
          this.shutdown();
        });
        this.on("error", (error) => {
          this.shutdown();
        });
      }
      setDebuggerPathFormat(format) {
        this._debuggerPathsAreURIs = format !== "path";
      }
      setDebuggerLinesStartAt1(enable) {
        this._debuggerLinesStartAt1 = enable;
      }
      setDebuggerColumnsStartAt1(enable) {
        this._debuggerColumnsStartAt1 = enable;
      }
      setRunAsServer(enable) {
        this._isServer = enable;
      }
      /**
       * A virtual constructor...
       */
      static run(debugSession2) {
        (0, runDebugAdapter_1.runDebugAdapter)(debugSession2);
      }
      shutdown() {
        if (this._isServer || this._isRunningInline()) ;
        else {
          setTimeout(() => {
            process.exit(0);
          }, 100);
        }
      }
      sendErrorResponse(response, codeOrMessage, format, variables, dest = ErrorDestination.User) {
        let msg;
        if (typeof codeOrMessage === "number") {
          msg = {
            id: codeOrMessage,
            format
          };
          if (variables) {
            msg.variables = variables;
          }
          if (dest & ErrorDestination.User) {
            msg.showUser = true;
          }
          if (dest & ErrorDestination.Telemetry) {
            msg.sendTelemetry = true;
          }
        } else {
          msg = codeOrMessage;
        }
        response.success = false;
        response.message = DebugSession.formatPII(msg.format, true, msg.variables);
        if (!response.body) {
          response.body = {};
        }
        response.body.error = msg;
        this.sendResponse(response);
      }
      runInTerminalRequest(args, timeout2, cb) {
        this.sendRequest("runInTerminal", args, timeout2, cb);
      }
      dispatchRequest(request) {
        const response = new messages_1.Response(request);
        try {
          if (request.command === "initialize") {
            var args = request.arguments;
            if (typeof args.linesStartAt1 === "boolean") {
              this._clientLinesStartAt1 = args.linesStartAt1;
            }
            if (typeof args.columnsStartAt1 === "boolean") {
              this._clientColumnsStartAt1 = args.columnsStartAt1;
            }
            if (args.pathFormat !== "path") {
              this.sendErrorResponse(response, 2018, "debug adapter only supports native paths", null, ErrorDestination.Telemetry);
            } else {
              const initializeResponse = response;
              initializeResponse.body = {};
              this.initializeRequest(initializeResponse, args);
            }
          } else if (request.command === "launch") {
            this.launchRequest(response, request.arguments, request);
          } else if (request.command === "attach") {
            this.attachRequest(response, request.arguments, request);
          } else if (request.command === "disconnect") {
            this.disconnectRequest(response, request.arguments, request);
          } else if (request.command === "terminate") {
            this.terminateRequest(response, request.arguments, request);
          } else if (request.command === "restart") {
            this.restartRequest(response, request.arguments, request);
          } else if (request.command === "setBreakpoints") {
            this.setBreakPointsRequest(response, request.arguments, request);
          } else if (request.command === "setFunctionBreakpoints") {
            this.setFunctionBreakPointsRequest(response, request.arguments, request);
          } else if (request.command === "setExceptionBreakpoints") {
            this.setExceptionBreakPointsRequest(response, request.arguments, request);
          } else if (request.command === "configurationDone") {
            this.configurationDoneRequest(response, request.arguments, request);
          } else if (request.command === "continue") {
            this.continueRequest(response, request.arguments, request);
          } else if (request.command === "next") {
            this.nextRequest(response, request.arguments, request);
          } else if (request.command === "stepIn") {
            this.stepInRequest(response, request.arguments, request);
          } else if (request.command === "stepOut") {
            this.stepOutRequest(response, request.arguments, request);
          } else if (request.command === "stepBack") {
            this.stepBackRequest(response, request.arguments, request);
          } else if (request.command === "reverseContinue") {
            this.reverseContinueRequest(response, request.arguments, request);
          } else if (request.command === "restartFrame") {
            this.restartFrameRequest(response, request.arguments, request);
          } else if (request.command === "goto") {
            this.gotoRequest(response, request.arguments, request);
          } else if (request.command === "pause") {
            this.pauseRequest(response, request.arguments, request);
          } else if (request.command === "stackTrace") {
            this.stackTraceRequest(response, request.arguments, request);
          } else if (request.command === "scopes") {
            this.scopesRequest(response, request.arguments, request);
          } else if (request.command === "variables") {
            this.variablesRequest(response, request.arguments, request);
          } else if (request.command === "setVariable") {
            this.setVariableRequest(response, request.arguments, request);
          } else if (request.command === "setExpression") {
            this.setExpressionRequest(response, request.arguments, request);
          } else if (request.command === "source") {
            this.sourceRequest(response, request.arguments, request);
          } else if (request.command === "threads") {
            this.threadsRequest(response, request);
          } else if (request.command === "terminateThreads") {
            this.terminateThreadsRequest(response, request.arguments, request);
          } else if (request.command === "evaluate") {
            this.evaluateRequest(response, request.arguments, request);
          } else if (request.command === "stepInTargets") {
            this.stepInTargetsRequest(response, request.arguments, request);
          } else if (request.command === "gotoTargets") {
            this.gotoTargetsRequest(response, request.arguments, request);
          } else if (request.command === "completions") {
            this.completionsRequest(response, request.arguments, request);
          } else if (request.command === "exceptionInfo") {
            this.exceptionInfoRequest(response, request.arguments, request);
          } else if (request.command === "loadedSources") {
            this.loadedSourcesRequest(response, request.arguments, request);
          } else if (request.command === "dataBreakpointInfo") {
            this.dataBreakpointInfoRequest(response, request.arguments, request);
          } else if (request.command === "setDataBreakpoints") {
            this.setDataBreakpointsRequest(response, request.arguments, request);
          } else if (request.command === "readMemory") {
            this.readMemoryRequest(response, request.arguments, request);
          } else if (request.command === "writeMemory") {
            this.writeMemoryRequest(response, request.arguments, request);
          } else if (request.command === "disassemble") {
            this.disassembleRequest(response, request.arguments, request);
          } else if (request.command === "cancel") {
            this.cancelRequest(response, request.arguments, request);
          } else if (request.command === "breakpointLocations") {
            this.breakpointLocationsRequest(response, request.arguments, request);
          } else if (request.command === "setInstructionBreakpoints") {
            this.setInstructionBreakpointsRequest(response, request.arguments, request);
          } else {
            this.customRequest(request.command, response, request.arguments, request);
          }
        } catch (e) {
          this.sendErrorResponse(response, 1104, "{_stack}", { _exception: e.message, _stack: e.stack }, ErrorDestination.Telemetry);
        }
      }
      initializeRequest(response, args) {
        response.body.supportsConditionalBreakpoints = false;
        response.body.supportsHitConditionalBreakpoints = false;
        response.body.supportsFunctionBreakpoints = false;
        response.body.supportsConfigurationDoneRequest = true;
        response.body.supportsEvaluateForHovers = false;
        response.body.supportsStepBack = false;
        response.body.supportsSetVariable = false;
        response.body.supportsRestartFrame = false;
        response.body.supportsStepInTargetsRequest = false;
        response.body.supportsGotoTargetsRequest = false;
        response.body.supportsCompletionsRequest = false;
        response.body.supportsRestartRequest = false;
        response.body.supportsExceptionOptions = false;
        response.body.supportsValueFormattingOptions = false;
        response.body.supportsExceptionInfoRequest = false;
        response.body.supportTerminateDebuggee = false;
        response.body.supportsDelayedStackTraceLoading = false;
        response.body.supportsLoadedSourcesRequest = false;
        response.body.supportsLogPoints = false;
        response.body.supportsTerminateThreadsRequest = false;
        response.body.supportsSetExpression = false;
        response.body.supportsTerminateRequest = false;
        response.body.supportsDataBreakpoints = false;
        response.body.supportsReadMemoryRequest = false;
        response.body.supportsDisassembleRequest = false;
        response.body.supportsCancelRequest = false;
        response.body.supportsBreakpointLocationsRequest = false;
        response.body.supportsClipboardContext = false;
        response.body.supportsSteppingGranularity = false;
        response.body.supportsInstructionBreakpoints = false;
        response.body.supportsExceptionFilterOptions = false;
        this.sendResponse(response);
      }
      disconnectRequest(response, args, request) {
        this.sendResponse(response);
        this.shutdown();
      }
      launchRequest(response, args, request) {
        this.sendResponse(response);
      }
      attachRequest(response, args, request) {
        this.sendResponse(response);
      }
      terminateRequest(response, args, request) {
        this.sendResponse(response);
      }
      restartRequest(response, args, request) {
        this.sendResponse(response);
      }
      setBreakPointsRequest(response, args, request) {
        this.sendResponse(response);
      }
      setFunctionBreakPointsRequest(response, args, request) {
        this.sendResponse(response);
      }
      setExceptionBreakPointsRequest(response, args, request) {
        this.sendResponse(response);
      }
      configurationDoneRequest(response, args, request) {
        this.sendResponse(response);
      }
      continueRequest(response, args, request) {
        this.sendResponse(response);
      }
      nextRequest(response, args, request) {
        this.sendResponse(response);
      }
      stepInRequest(response, args, request) {
        this.sendResponse(response);
      }
      stepOutRequest(response, args, request) {
        this.sendResponse(response);
      }
      stepBackRequest(response, args, request) {
        this.sendResponse(response);
      }
      reverseContinueRequest(response, args, request) {
        this.sendResponse(response);
      }
      restartFrameRequest(response, args, request) {
        this.sendResponse(response);
      }
      gotoRequest(response, args, request) {
        this.sendResponse(response);
      }
      pauseRequest(response, args, request) {
        this.sendResponse(response);
      }
      sourceRequest(response, args, request) {
        this.sendResponse(response);
      }
      threadsRequest(response, request) {
        this.sendResponse(response);
      }
      terminateThreadsRequest(response, args, request) {
        this.sendResponse(response);
      }
      stackTraceRequest(response, args, request) {
        this.sendResponse(response);
      }
      scopesRequest(response, args, request) {
        this.sendResponse(response);
      }
      variablesRequest(response, args, request) {
        this.sendResponse(response);
      }
      setVariableRequest(response, args, request) {
        this.sendResponse(response);
      }
      setExpressionRequest(response, args, request) {
        this.sendResponse(response);
      }
      evaluateRequest(response, args, request) {
        this.sendResponse(response);
      }
      stepInTargetsRequest(response, args, request) {
        this.sendResponse(response);
      }
      gotoTargetsRequest(response, args, request) {
        this.sendResponse(response);
      }
      completionsRequest(response, args, request) {
        this.sendResponse(response);
      }
      exceptionInfoRequest(response, args, request) {
        this.sendResponse(response);
      }
      loadedSourcesRequest(response, args, request) {
        this.sendResponse(response);
      }
      dataBreakpointInfoRequest(response, args, request) {
        this.sendResponse(response);
      }
      setDataBreakpointsRequest(response, args, request) {
        this.sendResponse(response);
      }
      readMemoryRequest(response, args, request) {
        this.sendResponse(response);
      }
      writeMemoryRequest(response, args, request) {
        this.sendResponse(response);
      }
      disassembleRequest(response, args, request) {
        this.sendResponse(response);
      }
      cancelRequest(response, args, request) {
        this.sendResponse(response);
      }
      breakpointLocationsRequest(response, args, request) {
        this.sendResponse(response);
      }
      setInstructionBreakpointsRequest(response, args, request) {
        this.sendResponse(response);
      }
      /**
       * Override this hook to implement custom requests.
       */
      customRequest(command, response, args, request) {
        this.sendErrorResponse(response, 1014, "unrecognized request", null, ErrorDestination.Telemetry);
      }
      //---- protected -------------------------------------------------------------------------------------------------
      convertClientLineToDebugger(line) {
        if (this._debuggerLinesStartAt1) {
          return this._clientLinesStartAt1 ? line : line + 1;
        }
        return this._clientLinesStartAt1 ? line - 1 : line;
      }
      convertDebuggerLineToClient(line) {
        if (this._debuggerLinesStartAt1) {
          return this._clientLinesStartAt1 ? line : line - 1;
        }
        return this._clientLinesStartAt1 ? line + 1 : line;
      }
      convertClientColumnToDebugger(column) {
        if (this._debuggerColumnsStartAt1) {
          return this._clientColumnsStartAt1 ? column : column + 1;
        }
        return this._clientColumnsStartAt1 ? column - 1 : column;
      }
      convertDebuggerColumnToClient(column) {
        if (this._debuggerColumnsStartAt1) {
          return this._clientColumnsStartAt1 ? column : column - 1;
        }
        return this._clientColumnsStartAt1 ? column + 1 : column;
      }
      convertClientPathToDebugger(clientPath) {
        if (this._clientPathsAreURIs !== this._debuggerPathsAreURIs) {
          if (this._clientPathsAreURIs) {
            return DebugSession.uri2path(clientPath);
          } else {
            return DebugSession.path2uri(clientPath);
          }
        }
        return clientPath;
      }
      convertDebuggerPathToClient(debuggerPath) {
        if (this._debuggerPathsAreURIs !== this._clientPathsAreURIs) {
          if (this._debuggerPathsAreURIs) {
            return DebugSession.uri2path(debuggerPath);
          } else {
            return DebugSession.path2uri(debuggerPath);
          }
        }
        return debuggerPath;
      }
      //---- private -------------------------------------------------------------------------------
      static path2uri(path2) {
        if (process.platform === "win32") {
          if (/^[A-Z]:/.test(path2)) {
            path2 = path2[0].toLowerCase() + path2.substr(1);
          }
          path2 = path2.replace(/\\/g, "/");
        }
        path2 = encodeURI(path2);
        let uri = new url_1.URL(`file:`);
        uri.pathname = path2;
        return uri.toString();
      }
      static uri2path(sourceUri) {
        let uri = new url_1.URL(sourceUri);
        let s = decodeURIComponent(uri.pathname);
        if (process.platform === "win32") {
          if (/^\/[a-zA-Z]:/.test(s)) {
            s = s[1].toLowerCase() + s.substr(2);
          }
          s = s.replace(/\//g, "\\");
        }
        return s;
      }
      /*
      * If argument starts with '_' it is OK to send its value to telemetry.
      */
      static formatPII(format, excludePII, args) {
        return format.replace(DebugSession._formatPIIRegexp, function(match, paramName) {
          if (excludePII && paramName.length > 0 && paramName[0] !== "_") {
            return match;
          }
          return args[paramName] && args.hasOwnProperty(paramName) ? args[paramName] : match;
        });
      }
    }
    exports2.DebugSession = DebugSession;
    DebugSession._formatPIIRegexp = /{([^}]+)}/g;
  })(debugSession);
  return debugSession;
}
var loggingDebugSession = {};
var logger = {};
var internalLoggerStub = {};
var hasRequiredInternalLoggerStub;
function requireInternalLoggerStub() {
  if (hasRequiredInternalLoggerStub) return internalLoggerStub;
  hasRequiredInternalLoggerStub = 1;
  Object.defineProperty(internalLoggerStub, "__esModule", { value: true });
  internalLoggerStub.InternalLogger = void 0;
  class InternalLogger {
    dispose() {
      return void 0;
    }
    log(msg, level, prependTimestamp) {
    }
    setup(options) {
      return void 0;
    }
  }
  internalLoggerStub.InternalLogger = InternalLogger;
  return internalLoggerStub;
}
var hasRequiredLogger;
function requireLogger() {
  if (hasRequiredLogger) return logger;
  hasRequiredLogger = 1;
  (function(exports2) {
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.trimLastNewline = exports2.LogOutputEvent = exports2.logger = exports2.Logger = exports2.LogLevel = void 0;
    const internalLogger_1 = requireInternalLoggerStub();
    const debugSession_1 = requireDebugSession();
    var LogLevel;
    (function(LogLevel2) {
      LogLevel2[LogLevel2["Verbose"] = 0] = "Verbose";
      LogLevel2[LogLevel2["Log"] = 1] = "Log";
      LogLevel2[LogLevel2["Warn"] = 2] = "Warn";
      LogLevel2[LogLevel2["Error"] = 3] = "Error";
      LogLevel2[LogLevel2["Stop"] = 4] = "Stop";
    })(LogLevel = exports2.LogLevel || (exports2.LogLevel = {}));
    class Logger {
      constructor() {
        this._pendingLogQ = [];
      }
      log(msg, level = LogLevel.Log) {
        msg = msg + "\n";
        this._write(msg, level);
      }
      verbose(msg) {
        this.log(msg, LogLevel.Verbose);
      }
      warn(msg) {
        this.log(msg, LogLevel.Warn);
      }
      error(msg) {
        this.log(msg, LogLevel.Error);
      }
      dispose() {
        if (this._currentLogger) {
          const disposeP = this._currentLogger.dispose();
          this._currentLogger = null;
          return disposeP;
        } else {
          return Promise.resolve();
        }
      }
      /**
       * `log` adds a newline, `write` doesn't
       */
      _write(msg, level = LogLevel.Log) {
        msg = msg + "";
        if (this._pendingLogQ) {
          this._pendingLogQ.push({ msg, level });
        } else if (this._currentLogger) {
          this._currentLogger.log(msg, level);
        }
      }
      /**
       * Set the logger's minimum level to log in the console, and whether to log to the file. Log messages are queued before this is
       * called the first time, because minLogLevel defaults to Warn.
       */
      setup(consoleMinLogLevel, _logFilePath, prependTimestamp = true) {
        const logFilePath = typeof _logFilePath === "string" ? _logFilePath : _logFilePath && this._logFilePathFromInit;
        if (this._currentLogger) {
          const options = {
            consoleMinLogLevel,
            logFilePath,
            prependTimestamp
          };
          this._currentLogger.setup(options).then(() => {
            if (this._pendingLogQ) {
              const logQ = this._pendingLogQ;
              this._pendingLogQ = null;
              logQ.forEach((item) => this._write(item.msg, item.level));
            }
          });
        }
      }
      init(logCallback, logFilePath, logToConsole) {
        this._pendingLogQ = this._pendingLogQ || [];
        this._currentLogger = new internalLogger_1.InternalLogger(logCallback, logToConsole);
        this._logFilePathFromInit = logFilePath;
      }
    }
    exports2.Logger = Logger;
    exports2.logger = new Logger();
    class LogOutputEvent extends debugSession_1.OutputEvent {
      constructor(msg, level) {
        const category = level === LogLevel.Error ? "stderr" : level === LogLevel.Warn ? "console" : "stdout";
        super(msg, category);
      }
    }
    exports2.LogOutputEvent = LogOutputEvent;
    function trimLastNewline(str) {
      return str.replace(/(\n|\r\n)$/, "");
    }
    exports2.trimLastNewline = trimLastNewline;
  })(logger);
  return logger;
}
var hasRequiredLoggingDebugSession;
function requireLoggingDebugSession() {
  if (hasRequiredLoggingDebugSession) return loggingDebugSession;
  hasRequiredLoggingDebugSession = 1;
  Object.defineProperty(loggingDebugSession, "__esModule", { value: true });
  loggingDebugSession.LoggingDebugSession = void 0;
  const Logger = requireLogger();
  const logger2 = Logger.logger;
  const debugSession_1 = requireDebugSession();
  class LoggingDebugSession extends debugSession_1.DebugSession {
    constructor(obsolete_logFilePath, obsolete_debuggerLinesAndColumnsStartAt1, obsolete_isServer) {
      super(obsolete_debuggerLinesAndColumnsStartAt1, obsolete_isServer);
      this.obsolete_logFilePath = obsolete_logFilePath;
      this.on("error", (event) => {
        logger2.error(event.body);
      });
    }
    start(inStream, outStream) {
      super.start(inStream, outStream);
      logger2.init((e) => this.sendEvent(e), this.obsolete_logFilePath, this._isServer);
    }
    /**
     * Overload sendEvent to log
     */
    sendEvent(event) {
      if (!(event instanceof Logger.LogOutputEvent)) {
        let objectToLog = event;
        if (event instanceof debugSession_1.OutputEvent && event.body && event.body.data && event.body.data.doNotLogOutput) {
          delete event.body.data.doNotLogOutput;
          objectToLog = { ...event };
          objectToLog.body = { ...event.body, output: "<output not logged>" };
        }
        logger2.verbose(`To client: ${JSON.stringify(objectToLog)}`);
      }
      super.sendEvent(event);
    }
    /**
     * Overload sendRequest to log
     */
    sendRequest(command, args, timeout2, cb) {
      logger2.verbose(`To client: ${JSON.stringify(command)}(${JSON.stringify(args)}), timeout: ${timeout2}`);
      super.sendRequest(command, args, timeout2, cb);
    }
    /**
     * Overload sendResponse to log
     */
    sendResponse(response) {
      logger2.verbose(`To client: ${JSON.stringify(response)}`);
      super.sendResponse(response);
    }
    dispatchRequest(request) {
      logger2.verbose(`From client: ${request.command}(${JSON.stringify(request.arguments)})`);
      super.dispatchRequest(request);
    }
  }
  loggingDebugSession.LoggingDebugSession = LoggingDebugSession;
  return loggingDebugSession;
}
var handles = {};
var hasRequiredHandles;
function requireHandles() {
  if (hasRequiredHandles) return handles;
  hasRequiredHandles = 1;
  Object.defineProperty(handles, "__esModule", { value: true });
  handles.Handles = void 0;
  class Handles {
    constructor(startHandle) {
      this.START_HANDLE = 1e3;
      this._handleMap = /* @__PURE__ */ new Map();
      this._nextHandle = typeof startHandle === "number" ? startHandle : this.START_HANDLE;
    }
    reset() {
      this._nextHandle = this.START_HANDLE;
      this._handleMap = /* @__PURE__ */ new Map();
    }
    create(value) {
      var handle = this._nextHandle++;
      this._handleMap.set(handle, value);
      return handle;
    }
    get(handle, dflt) {
      return this._handleMap.get(handle) || dflt;
    }
  }
  handles.Handles = Handles;
  return handles;
}
var hasRequiredMain;
function requireMain() {
  if (hasRequiredMain) return main;
  hasRequiredMain = 1;
  (function(exports2) {
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Handles = exports2.Response = exports2.Event = exports2.ErrorDestination = exports2.CompletionItem = exports2.Module = exports2.Source = exports2.Breakpoint = exports2.Variable = exports2.Scope = exports2.StackFrame = exports2.Thread = exports2.MemoryEvent = exports2.InvalidatedEvent = exports2.ProgressEndEvent = exports2.ProgressUpdateEvent = exports2.ProgressStartEvent = exports2.CapabilitiesEvent = exports2.LoadedSourceEvent = exports2.ModuleEvent = exports2.BreakpointEvent = exports2.ThreadEvent = exports2.OutputEvent = exports2.ContinuedEvent = exports2.StoppedEvent = exports2.ExitedEvent = exports2.TerminatedEvent = exports2.InitializedEvent = exports2.logger = exports2.Logger = exports2.LoggingDebugSession = exports2.DebugSession = void 0;
    const debugSession_1 = requireDebugSession();
    Object.defineProperty(exports2, "DebugSession", { enumerable: true, get: function() {
      return debugSession_1.DebugSession;
    } });
    Object.defineProperty(exports2, "InitializedEvent", { enumerable: true, get: function() {
      return debugSession_1.InitializedEvent;
    } });
    Object.defineProperty(exports2, "TerminatedEvent", { enumerable: true, get: function() {
      return debugSession_1.TerminatedEvent;
    } });
    Object.defineProperty(exports2, "ExitedEvent", { enumerable: true, get: function() {
      return debugSession_1.ExitedEvent;
    } });
    Object.defineProperty(exports2, "StoppedEvent", { enumerable: true, get: function() {
      return debugSession_1.StoppedEvent;
    } });
    Object.defineProperty(exports2, "ContinuedEvent", { enumerable: true, get: function() {
      return debugSession_1.ContinuedEvent;
    } });
    Object.defineProperty(exports2, "OutputEvent", { enumerable: true, get: function() {
      return debugSession_1.OutputEvent;
    } });
    Object.defineProperty(exports2, "ThreadEvent", { enumerable: true, get: function() {
      return debugSession_1.ThreadEvent;
    } });
    Object.defineProperty(exports2, "BreakpointEvent", { enumerable: true, get: function() {
      return debugSession_1.BreakpointEvent;
    } });
    Object.defineProperty(exports2, "ModuleEvent", { enumerable: true, get: function() {
      return debugSession_1.ModuleEvent;
    } });
    Object.defineProperty(exports2, "LoadedSourceEvent", { enumerable: true, get: function() {
      return debugSession_1.LoadedSourceEvent;
    } });
    Object.defineProperty(exports2, "CapabilitiesEvent", { enumerable: true, get: function() {
      return debugSession_1.CapabilitiesEvent;
    } });
    Object.defineProperty(exports2, "ProgressStartEvent", { enumerable: true, get: function() {
      return debugSession_1.ProgressStartEvent;
    } });
    Object.defineProperty(exports2, "ProgressUpdateEvent", { enumerable: true, get: function() {
      return debugSession_1.ProgressUpdateEvent;
    } });
    Object.defineProperty(exports2, "ProgressEndEvent", { enumerable: true, get: function() {
      return debugSession_1.ProgressEndEvent;
    } });
    Object.defineProperty(exports2, "InvalidatedEvent", { enumerable: true, get: function() {
      return debugSession_1.InvalidatedEvent;
    } });
    Object.defineProperty(exports2, "MemoryEvent", { enumerable: true, get: function() {
      return debugSession_1.MemoryEvent;
    } });
    Object.defineProperty(exports2, "Thread", { enumerable: true, get: function() {
      return debugSession_1.Thread;
    } });
    Object.defineProperty(exports2, "StackFrame", { enumerable: true, get: function() {
      return debugSession_1.StackFrame;
    } });
    Object.defineProperty(exports2, "Scope", { enumerable: true, get: function() {
      return debugSession_1.Scope;
    } });
    Object.defineProperty(exports2, "Variable", { enumerable: true, get: function() {
      return debugSession_1.Variable;
    } });
    Object.defineProperty(exports2, "Breakpoint", { enumerable: true, get: function() {
      return debugSession_1.Breakpoint;
    } });
    Object.defineProperty(exports2, "Source", { enumerable: true, get: function() {
      return debugSession_1.Source;
    } });
    Object.defineProperty(exports2, "Module", { enumerable: true, get: function() {
      return debugSession_1.Module;
    } });
    Object.defineProperty(exports2, "CompletionItem", { enumerable: true, get: function() {
      return debugSession_1.CompletionItem;
    } });
    Object.defineProperty(exports2, "ErrorDestination", { enumerable: true, get: function() {
      return debugSession_1.ErrorDestination;
    } });
    const loggingDebugSession_1 = requireLoggingDebugSession();
    Object.defineProperty(exports2, "LoggingDebugSession", { enumerable: true, get: function() {
      return loggingDebugSession_1.LoggingDebugSession;
    } });
    const Logger = requireLogger();
    exports2.Logger = Logger;
    const messages_1 = requireMessages();
    Object.defineProperty(exports2, "Event", { enumerable: true, get: function() {
      return messages_1.Event;
    } });
    Object.defineProperty(exports2, "Response", { enumerable: true, get: function() {
      return messages_1.Response;
    } });
    const handles_1 = requireHandles();
    Object.defineProperty(exports2, "Handles", { enumerable: true, get: function() {
      return handles_1.Handles;
    } });
    const logger2 = Logger.logger;
    exports2.logger = logger2;
  })(main);
  return main;
}
var mainExports = requireMain();
class DaffodilRuntime extends require$$1.EventEmitter {
  constructor(_fileAccessor) {
    super();
    this._fileAccessor = _fileAccessor;
    this._sourceFile = "";
    this._sourceLines = [];
    this._currentLine = 0;
    this._breakPoints = /* @__PURE__ */ new Map();
    this._breakpointId = 1;
    this._breakAddresses = /* @__PURE__ */ new Set();
    this._noDebug = false;
    this._otherExceptions = false;
  }
  get sourceFile() {
    return this._sourceFile;
  }
  /**
   * Start executing the given program.
   */
  async start(program, stopOnEntry, noDebug) {
    this._noDebug = noDebug;
    await this.loadSource(program);
    this._currentLine = -1;
    await this.verifyBreakpoints(this._sourceFile);
    if (stopOnEntry) {
      this.step(false, "stopOnEntry");
    } else {
      this.continue();
    }
  }
  /**
   * Continue execution to the end/beginning.
   */
  continue(reverse = false) {
    this.run(reverse, void 0);
  }
  /**
   * Step to the next/previous non empty line.
   */
  step(reverse = false, event = "stopOnStep") {
    this.run(reverse, event);
  }
  /**
   * "Step into" for Daffodil Debug means: go to next character
   */
  stepIn(targetId) {
    if (typeof targetId === "number") {
      this._currentColumn = targetId;
      this.sendEvent("stopOnStep");
    } else {
      if (typeof this._currentColumn === "number") {
        if (this._currentColumn <= this._sourceLines[this._currentLine].length) {
          this._currentColumn += 1;
        }
      } else {
        this._currentColumn = 1;
      }
      this.sendEvent("stopOnStep");
    }
  }
  /**
   * "Step out" for Daffodil Debug means: go to previous character
   */
  stepOut() {
    if (typeof this._currentColumn === "number") {
      this._currentColumn -= 1;
      if (this._currentColumn === 0) {
        this._currentColumn = void 0;
      }
    }
    this.sendEvent("stopOnStep");
  }
  getStepInTargets(frameId) {
    const line = this._sourceLines[this._currentLine].trim();
    const words = line.split(/\s+/);
    if (frameId < 0 || frameId >= words.length) {
      return [];
    }
    const frame = words[frameId];
    const pos = line.indexOf(frame);
    return frame.split("").map((c, ix) => {
      return {
        id: pos + ix,
        label: `target: ${c}`
      };
    });
  }
  /**
   * Returns a fake 'stacktrace' where every 'stackframe' is a word from the current line.
   */
  stack(startFrame, endFrame) {
    const words = this._sourceLines[this._currentLine].trim().split(/\s+/);
    const frames = new Array();
    for (let i = startFrame; i < Math.min(endFrame, words.length); i++) {
      const name = words[i];
      const stackFrame = {
        index: i,
        name: `${name}(${i})`,
        file: this._sourceFile,
        line: this._currentLine
      };
      if (typeof this._currentColumn === "number") {
        stackFrame.column = this._currentColumn;
      }
      frames.push(stackFrame);
    }
    return {
      frames,
      count: words.length
    };
  }
  getBreakpoints(path2, line) {
    const l = this._sourceLines[line];
    let sawSpace = true;
    const bps = [];
    for (let i = 0; i < l.length; i++) {
      if (l[i] !== " ") {
        if (sawSpace) {
          bps.push(i);
          sawSpace = false;
        }
      } else {
        sawSpace = true;
      }
    }
    return bps;
  }
  /*
   * Set breakpoint in file with given line.
   */
  async setBreakPoint(path2, line) {
    const bp = {
      verified: false,
      line,
      id: this._breakpointId++
    };
    let bps = this._breakPoints.get(path2);
    if (!bps) {
      bps = new Array();
      this._breakPoints.set(path2, bps);
    }
    bps.push(bp);
    await this.verifyBreakpoints(path2);
    return bp;
  }
  /*
   * Clear breakpoint in file with given line.
   */
  clearBreakPoint(path2, line) {
    const bps = this._breakPoints.get(path2);
    if (bps) {
      const index = bps.findIndex((bp) => bp.line === line);
      if (index >= 0) {
        const bp = bps[index];
        bps.splice(index, 1);
        return bp;
      }
    }
    return void 0;
  }
  /*
   * Clear all breakpoints for file.
   */
  clearBreakpoints(path2) {
    this._breakPoints.delete(path2);
  }
  /*
   * Set data breakpoint.
   */
  setDataBreakpoint(address) {
    if (address) {
      this._breakAddresses.add(address);
      return true;
    }
    return false;
  }
  setExceptionsFilters(namedException, otherExceptions) {
    this._namedException = namedException;
    this._otherExceptions = otherExceptions;
  }
  /*
   * Clear all data breakpoints.
   */
  clearAllDataBreakpoints() {
    this._breakAddresses.clear();
  }
  // private methods
  async loadSource(file) {
    if (this._sourceFile !== file) {
      this._sourceFile = file;
      const contents = await this._fileAccessor.readFile(file);
      this._sourceLines = contents.split(/\r?\n/);
    }
  }
  /**
   * Run through the file.
   * If stepEvent is specified only run a single step and emit the stepEvent.
   */
  run(reverse = false, stepEvent) {
    if (reverse) {
      for (let ln = this._currentLine - 1; ln >= 0; ln--) {
        if (this.fireEventsForLine(ln, stepEvent)) {
          this._currentLine = ln;
          this._currentColumn = void 0;
          return;
        }
      }
      this._currentLine = 0;
      this._currentColumn = void 0;
      this.sendEvent("stopOnEntry");
    } else {
      for (let ln = this._currentLine + 1; ln < this._sourceLines.length; ln++) {
        if (this.fireEventsForLine(ln, stepEvent)) {
          this._currentLine = ln;
          this._currentColumn = void 0;
          return true;
        }
      }
      this.sendEvent("end");
    }
  }
  async verifyBreakpoints(path2) {
    if (this._noDebug) {
      return;
    }
    const bps = this._breakPoints.get(path2);
    if (bps) {
      await this.loadSource(path2);
      bps.forEach((bp) => {
        if (!bp.verified && bp.line < this._sourceLines.length) {
          const srcLine = this._sourceLines[bp.line].trim();
          if (srcLine.length === 0 || srcLine.indexOf("+") === 0) {
            bp.line++;
          }
          if (srcLine.indexOf("-") === 0) {
            bp.line--;
          }
          if (srcLine.indexOf("lazy") < 0) {
            bp.verified = true;
            this.sendEvent("breakpointValidated", bp);
          }
        }
      });
    }
  }
  /**
   * Fire events if line has a breakpoint or the word 'exception' or 'exception(...)' is found.
   * Returns true if execution needs to stop.
   */
  fireEventsForLine(ln, stepEvent) {
    if (this._noDebug) {
      return false;
    }
    const line = this._sourceLines[ln].trim();
    const matches = /log\((.*)\)/.exec(line);
    if (matches && matches.length === 2) {
      this.sendEvent("output", matches[1], this._sourceFile, ln, matches.index);
    }
    const words = line.split(" ");
    for (const word of words) {
      if (this._breakAddresses.has(word)) {
        this.sendEvent("stopOnDataBreakpoint");
        return true;
      }
    }
    const matches2 = /exception\((.*)\)/.exec(line);
    if (matches2 && matches2.length === 2) {
      const exception = matches2[1].trim();
      if (this._namedException === exception) {
        this.sendEvent("stopOnException", exception);
        return true;
      } else {
        if (this._otherExceptions) {
          this.sendEvent("stopOnException", void 0);
          return true;
        }
      }
    } else {
      if (line.indexOf("exception") >= 0) {
        if (this._otherExceptions) {
          this.sendEvent("stopOnException", void 0);
          return true;
        }
      }
    }
    const breakpoints = this._breakPoints.get(this._sourceFile);
    if (breakpoints) {
      const bps = breakpoints.filter((bp) => bp.line === ln);
      if (bps.length > 0) {
        this.sendEvent("stopOnBreakpoint");
        if (!bps[0].verified) {
          bps[0].verified = true;
          this.sendEvent("breakpointValidated", bps[0]);
        }
        return true;
      }
    }
    if (stepEvent && line.length > 0) {
      this.sendEvent(stepEvent);
      return true;
    }
    return false;
  }
  sendEvent(event, ...args) {
    setImmediate((_2) => {
      this.emit(event, ...args);
    });
  }
}
var awaitNotify = {};
var hasRequiredAwaitNotify;
function requireAwaitNotify() {
  if (hasRequiredAwaitNotify) return awaitNotify;
  hasRequiredAwaitNotify = 1;
  function Subject() {
    this.waiters = [];
  }
  Subject.prototype.wait = function(timeout2) {
    var self2 = this;
    var waiter = {};
    this.waiters.push(waiter);
    var promise = new Promise(function(resolve) {
      var resolved = false;
      waiter.resolve = function(noRemove) {
        if (resolved) {
          return;
        }
        resolved = true;
        if (waiter.timeout) {
          clearTimeout(waiter.timeout);
          waiter.timeout = null;
        }
        if (!noRemove) {
          var pos = self2.waiters.indexOf(waiter);
          if (pos > -1) {
            self2.waiters.splice(pos, 1);
          }
        }
        resolve();
      };
    });
    if (timeout2 > 0 && isFinite(timeout2)) {
      waiter.timeout = setTimeout(function() {
        waiter.timeout = null;
        waiter.resolve();
      }, timeout2);
    }
    return promise;
  };
  Subject.prototype.notify = function() {
    if (this.waiters.length > 0) {
      this.waiters.pop().resolve(true);
    }
  };
  Subject.prototype.notifyAll = function() {
    for (var i = this.waiters.length - 1; i >= 0; i--) {
      this.waiters[i].resolve(true);
    }
    this.waiters = [];
  };
  awaitNotify.Subject = Subject;
  return awaitNotify;
}
var awaitNotifyExports = requireAwaitNotify();
function timeout(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}
class DaffodilDebugSession extends mainExports.LoggingDebugSession {
  /**
   * Creates a new debug adapter that is used for one debug session.
   * We configure the default implementation of a debug adapter here.
   */
  constructor(fileAccessor) {
    super("daffodil-debugger.txt");
    this._variableHandles = new mainExports.Handles();
    this._configurationDone = new awaitNotifyExports.Subject();
    this._cancelationTokens = /* @__PURE__ */ new Map();
    this._isLongrunning = /* @__PURE__ */ new Map();
    this._reportProgress = false;
    this._progressId = 1e4;
    this._cancelledProgressId = void 0;
    this._isProgressCancellable = true;
    this._showHex = false;
    this._useInvalidatedEvent = false;
    this.setDebuggerLinesStartAt1(false);
    this.setDebuggerColumnsStartAt1(false);
    this._runtime = new DaffodilRuntime(fileAccessor);
    this._runtime.on("stopOnEntry", () => {
      this.sendEvent(new mainExports.StoppedEvent("entry", DaffodilDebugSession.threadID));
    });
    this._runtime.on("stopOnStep", () => {
      this.sendEvent(new mainExports.StoppedEvent("step", DaffodilDebugSession.threadID));
    });
    this._runtime.on("stopOnBreakpoint", () => {
      this.sendEvent(
        new mainExports.StoppedEvent("breakpoint", DaffodilDebugSession.threadID)
      );
    });
    this._runtime.on("stopOnDataBreakpoint", () => {
      this.sendEvent(
        new mainExports.StoppedEvent("data breakpoint", DaffodilDebugSession.threadID)
      );
    });
    this._runtime.on("stopOnException", (exception) => {
      if (exception) {
        this.sendEvent(
          new mainExports.StoppedEvent(
            `exception(${exception})`,
            DaffodilDebugSession.threadID
          )
        );
      } else {
        this.sendEvent(
          new mainExports.StoppedEvent("exception", DaffodilDebugSession.threadID)
        );
      }
    });
    this._runtime.on("breakpointValidated", (bp) => {
      this.sendEvent(
        new mainExports.BreakpointEvent("changed", {
          verified: bp.verified,
          id: bp.id
        })
      );
    });
    this._runtime.on("output", (text, filePath, line, column) => {
      const e = new mainExports.OutputEvent(`${text}
`);
      if (text === "start" || text === "startCollapsed" || text === "end") {
        e.body.group = text;
        e.body.output = `group-${text}
`;
      }
      e.body.source = this.createSource(filePath);
      e.body.line = this.convertDebuggerLineToClient(line);
      e.body.column = this.convertDebuggerColumnToClient(column);
      this.sendEvent(e);
    });
    this._runtime.on("end", () => {
      this.sendEvent(new mainExports.TerminatedEvent());
    });
  }
  static {
    this.threadID = 1;
  }
  /**
   * The 'initialize' request is the first request called by the frontend
   * to interrogate the features the debug adapter provides.
   */
  initializeRequest(response, args) {
    if (args.supportsProgressReporting) {
      this._reportProgress = true;
    }
    if (args.supportsInvalidatedEvent) {
      this._useInvalidatedEvent = true;
    }
    response.body = response.body || {};
    response.body.supportsConfigurationDoneRequest = true;
    response.body.supportsEvaluateForHovers = true;
    response.body.supportsStepBack = true;
    response.body.supportsDataBreakpoints = true;
    response.body.supportsCompletionsRequest = true;
    response.body.completionTriggerCharacters = [".", "["];
    response.body.supportsCancelRequest = true;
    response.body.supportsBreakpointLocationsRequest = true;
    response.body.supportsStepInTargetsRequest = true;
    response.body.supportsExceptionFilterOptions = true;
    response.body.exceptionBreakpointFilters = [
      {
        filter: "namedException",
        label: "Named Exception",
        description: `Break on named exceptions. Enter the exception's name as the Condition.`,
        default: false,
        supportsCondition: true,
        conditionDescription: `Enter the exception's name`
      },
      {
        filter: "otherExceptions",
        label: "Other Exceptions",
        description: "This is a other exception",
        default: true,
        supportsCondition: false
      }
    ];
    response.body.supportsExceptionInfoRequest = true;
    this.sendResponse(response);
    this.sendEvent(new mainExports.InitializedEvent());
  }
  /**
   * Called at the end of the configuration sequence.
   * Indicates that all breakpoints etc. have been sent to the DA and that the 'launch' can start.
   */
  configurationDoneRequest(response, args) {
    super.configurationDoneRequest(response, args);
    this._configurationDone.notify();
  }
  async launchRequest(response, args) {
    mainExports.logger.setup(
      args.trace ? mainExports.Logger.LogLevel.Verbose : mainExports.Logger.LogLevel.Stop,
      false
    );
    await this._configurationDone.wait(1e3);
    await this._runtime.start(args.schema, !!args.stopOnEntry, !!args.noDebug);
    this.sendResponse(response);
  }
  async setBreakPointsRequest(response, args) {
    const path2 = args.source.path;
    const clientLines = args.lines || [];
    this._runtime.clearBreakpoints(path2);
    const actualBreakpoints0 = clientLines.map(async (l) => {
      const { verified, line, id } = await this._runtime.setBreakPoint(
        path2,
        this.convertClientLineToDebugger(l)
      );
      const bp = new mainExports.Breakpoint(
        verified,
        this.convertDebuggerLineToClient(line)
      );
      bp.id = id;
      return bp;
    });
    const actualBreakpoints = await Promise.all(actualBreakpoints0);
    response.body = {
      breakpoints: actualBreakpoints
    };
    this.sendResponse(response);
  }
  breakpointLocationsRequest(response, args, request) {
    if (args.source.path) {
      const bps = this._runtime.getBreakpoints(
        args.source.path,
        this.convertClientLineToDebugger(args.line)
      );
      response.body = {
        breakpoints: bps.map((col) => {
          return {
            line: args.line,
            column: this.convertDebuggerColumnToClient(col)
          };
        })
      };
    } else {
      response.body = {
        breakpoints: []
      };
    }
    this.sendResponse(response);
  }
  async setExceptionBreakPointsRequest(response, args) {
    let namedException = void 0;
    let otherExceptions = false;
    if (args.filterOptions) {
      for (const filterOption of args.filterOptions) {
        switch (filterOption.filterId) {
          case "namedException":
            namedException = args.filterOptions[0].condition;
            break;
          case "otherExceptions":
            otherExceptions = true;
            break;
        }
      }
    }
    if (args.filters) {
      if (args.filters.indexOf("otherExceptions") >= 0) {
        otherExceptions = true;
      }
    }
    this._runtime.setExceptionsFilters(namedException, otherExceptions);
    this.sendResponse(response);
  }
  exceptionInfoRequest(response, args) {
    response.body = {
      exceptionId: "Exception ID",
      description: "This is a descriptive description of the exception.",
      breakMode: "always",
      details: {
        message: "Message contained in the exception.",
        typeName: "Short type name of the exception object",
        stackTrace: "stack frame 1\nstack frame 2"
      }
    };
    this.sendResponse(response);
  }
  threadsRequest(response) {
    response.body = {
      threads: [new mainExports.Thread(DaffodilDebugSession.threadID, "thread 1")]
    };
    this.sendResponse(response);
  }
  stackTraceRequest(response, args) {
    const startFrame = typeof args.startFrame === "number" ? args.startFrame : 0;
    const maxLevels = typeof args.levels === "number" ? args.levels : 1e3;
    const endFrame = startFrame + maxLevels;
    const stk = this._runtime.stack(startFrame, endFrame);
    response.body = {
      stackFrames: stk.frames.map((f) => {
        const sf = new mainExports.StackFrame(
          f.index,
          f.name,
          this.createSource(f.file),
          this.convertDebuggerLineToClient(f.line)
        );
        if (typeof f.column === "number") {
          sf.column = this.convertDebuggerColumnToClient(f.column);
        }
        return sf;
      }),
      //no totalFrames: 				// VS Code has to probe/guess. Should result in a max. of two requests
      totalFrames: stk.count
      // stk.count is the correct size, should result in a max. of two requests
      //totalFrames: 1000000 			// not the correct size, should result in a max. of two requests
      //totalFrames: endFrame + 20 	// dynamically increases the size with every requested chunk, results in paging
    };
    this.sendResponse(response);
  }
  scopesRequest(response, args) {
    response.body = {
      scopes: [
        new mainExports.Scope("Local", this._variableHandles.create("local"), false),
        new mainExports.Scope("Global", this._variableHandles.create("global"), true)
      ]
    };
    this.sendResponse(response);
  }
  async variablesRequest(response, args, request) {
    const variables = [];
    if (this._isLongrunning.get(args.variablesReference)) {
      if (request) {
        this._cancelationTokens.set(request.seq, false);
      }
      for (let i = 0; i < 100; i++) {
        await timeout(1e3);
        variables.push({
          name: `i_${i}`,
          type: "integer",
          value: `${i}`,
          variablesReference: 0
        });
        if (request && this._cancelationTokens.get(request.seq)) {
          break;
        }
      }
      if (request) {
        this._cancelationTokens.delete(request.seq);
      }
    } else {
      const id = this._variableHandles.get(args.variablesReference);
      if (id) {
        const i = 12345678;
        variables.push({
          name: id + "_i",
          type: "integer",
          value: this._showHex ? "0x" + i.toString(16) : i.toString(10),
          __vscodeVariableMenuContext: "simple",
          variablesReference: 0
        });
        variables.push({
          name: id + "_f",
          type: "float",
          value: "3.14",
          variablesReference: 0
        });
        variables.push({
          name: id + "_f",
          type: "float",
          value: "6.28",
          variablesReference: 0
        });
        variables.push({
          name: id + "_f",
          type: "float",
          value: "6.28",
          variablesReference: 0
        });
        variables.push({
          name: id + "_s",
          type: "string",
          value: "hello world",
          variablesReference: 0
        });
        variables.push({
          name: id + "_o",
          type: "object",
          value: "Object",
          variablesReference: this._variableHandles.create(id + "_o")
        });
        const nm = id + "_long_running";
        const ref = this._variableHandles.create(id + "_lr");
        variables.push({
          name: nm,
          type: "object",
          value: "Object",
          variablesReference: ref
        });
        this._isLongrunning.set(ref, true);
      }
    }
    response.body = {
      variables
    };
    this.sendResponse(response);
  }
  continueRequest(response, args) {
    this._runtime.continue();
    this.sendResponse(response);
  }
  reverseContinueRequest(response, args) {
    this._runtime.continue(true);
    this.sendResponse(response);
  }
  nextRequest(response, args) {
    this._runtime.step();
    this.sendResponse(response);
  }
  stepBackRequest(response, args) {
    this._runtime.step(true);
    this.sendResponse(response);
  }
  stepInTargetsRequest(response, args) {
    const targets = this._runtime.getStepInTargets(args.frameId);
    response.body = {
      targets: targets.map((t) => {
        return { id: t.id, label: t.label };
      })
    };
    this.sendResponse(response);
  }
  stepInRequest(response, args) {
    this._runtime.stepIn(args.targetId);
    this.sendResponse(response);
  }
  stepOutRequest(response, args) {
    this._runtime.stepOut();
    this.sendResponse(response);
  }
  async evaluateRequest(response, args) {
    let reply = void 0;
    if (args.context === "repl") {
      const matches = /new +([0-9]+)/.exec(args.expression);
      if (matches && matches.length === 2) {
        const mbp = await this._runtime.setBreakPoint(
          this._runtime.sourceFile,
          this.convertClientLineToDebugger(parseInt(matches[1]))
        );
        const bp = new mainExports.Breakpoint(
          mbp.verified,
          this.convertDebuggerLineToClient(mbp.line),
          void 0,
          this.createSource(this._runtime.sourceFile)
        );
        bp.id = mbp.id;
        this.sendEvent(new mainExports.BreakpointEvent("new", bp));
        reply = `breakpoint created`;
      } else {
        const matches2 = /del +([0-9]+)/.exec(args.expression);
        if (matches2 && matches2.length === 2) {
          const mbp = this._runtime.clearBreakPoint(
            this._runtime.sourceFile,
            this.convertClientLineToDebugger(parseInt(matches2[1]))
          );
          if (mbp) {
            const bp = new mainExports.Breakpoint(false);
            bp.id = mbp.id;
            this.sendEvent(new mainExports.BreakpointEvent("removed", bp));
            reply = `breakpoint deleted`;
          }
        } else {
          const matches3 = /progress/.exec(args.expression);
          if (matches3 && matches3.length === 1) {
            if (this._reportProgress) {
              reply = `progress started`;
              await this.progressSequence();
            } else {
              reply = `frontend doesn't support progress (capability 'supportsProgressReporting' not set)`;
            }
          }
        }
      }
    }
    response.body = {
      result: reply ? reply : `evaluate(context: '${args.context}', '${args.expression}')`,
      variablesReference: 0
    };
    this.sendResponse(response);
  }
  async progressSequence() {
    const ID = "" + this._progressId++;
    await timeout(100);
    const title = this._isProgressCancellable ? "Cancellable operation" : "Long running operation";
    const startEvent = new mainExports.ProgressStartEvent(
      ID,
      title
    );
    startEvent.body.cancellable = this._isProgressCancellable;
    this._isProgressCancellable = !this._isProgressCancellable;
    this.sendEvent(startEvent);
    this.sendEvent(new mainExports.OutputEvent(`start progress: ${ID}
`));
    let endMessage = "progress ended";
    for (let i = 0; i < 100; i++) {
      await timeout(500);
      this.sendEvent(new mainExports.ProgressUpdateEvent(ID, `progress: ${i}`));
      if (this._cancelledProgressId === ID) {
        endMessage = "progress cancelled";
        this._cancelledProgressId = void 0;
        this.sendEvent(new mainExports.OutputEvent(`cancel progress: ${ID}
`));
        break;
      }
    }
    this.sendEvent(new mainExports.ProgressEndEvent(ID, endMessage));
    this.sendEvent(new mainExports.OutputEvent(`end progress: ${ID}
`));
    this._cancelledProgressId = void 0;
  }
  dataBreakpointInfoRequest(response, args) {
    response.body = {
      dataId: null,
      description: "cannot break on data access",
      accessTypes: void 0,
      canPersist: false
    };
    if (args.variablesReference && args.name) {
      const id = this._variableHandles.get(args.variablesReference);
      if (id === "global") {
        response.body.dataId = args.name;
        response.body.description = args.name;
        response.body.accessTypes = ["write"];
        response.body.canPersist = true;
      } else {
        response.body.dataId = args.name;
        response.body.description = args.name;
        response.body.accessTypes = ["read", "write", "readWrite"];
        response.body.canPersist = true;
      }
    }
    this.sendResponse(response);
  }
  setDataBreakpointsRequest(response, args) {
    this._runtime.clearAllDataBreakpoints();
    response.body = {
      breakpoints: []
    };
    for (const dbp of args.breakpoints) {
      const dataId = dbp.dataId + `_${dbp.accessType ? dbp.accessType : "write"}`;
      const ok = this._runtime.setDataBreakpoint(dataId);
      response.body.breakpoints.push({
        verified: ok
      });
    }
    this.sendResponse(response);
  }
  completionsRequest(response, args) {
    response.body = {
      targets: [
        {
          label: "item 10",
          sortText: "10"
        },
        {
          label: "item 1",
          sortText: "01"
        },
        {
          label: "item 2",
          sortText: "02"
        },
        {
          label: "array[]",
          selectionStart: 6,
          sortText: "03"
        },
        {
          label: "func(arg)",
          selectionStart: 5,
          selectionLength: 3,
          sortText: "04"
        }
      ]
    };
    this.sendResponse(response);
  }
  cancelRequest(response, args) {
    if (args.requestId) {
      this._cancelationTokens.set(args.requestId, true);
    }
    if (args.progressId) {
      this._cancelledProgressId = args.progressId;
    }
  }
  customRequest(command, response, args) {
    if (command === "toggleFormatting") {
      this._showHex = !this._showHex;
      if (this._useInvalidatedEvent) {
        this.sendEvent(new mainExports.InvalidatedEvent(["variables"]));
      }
      this.sendResponse(response);
    } else {
      super.customRequest(command, response, args);
    }
  }
  //---- helpers
  createSource(filePath) {
    return new mainExports.Source(
      path.basename(filePath),
      this.convertDebuggerPathToClient(filePath),
      void 0,
      void 0,
      "daffodil-adapter-data"
    );
  }
}
const nameStartChar = ":A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD";
const nameChar = nameStartChar + "\\-.\\d\\u00B7\\u0300-\\u036F\\u203F-\\u2040";
const nameRegexp = "[" + nameStartChar + "][" + nameChar + "]*";
const regexName = new RegExp("^" + nameRegexp + "$");
function getAllMatches(string, regex) {
  const matches = [];
  let match = regex.exec(string);
  while (match) {
    const allmatches = [];
    allmatches.startIndex = regex.lastIndex - match[0].length;
    const len = match.length;
    for (let index = 0; index < len; index++) {
      allmatches.push(match[index]);
    }
    matches.push(allmatches);
    match = regex.exec(string);
  }
  return matches;
}
const isName = function(string) {
  const match = regexName.exec(string);
  return !(match === null || typeof match === "undefined");
};
function isExist(v) {
  return typeof v !== "undefined";
}
const defaultOptions$2 = {
  allowBooleanAttributes: false,
  //A tag can have attributes without any value
  unpairedTags: []
};
function validate(xmlData, options) {
  options = Object.assign({}, defaultOptions$2, options);
  const tags = [];
  let tagFound = false;
  let reachedRoot = false;
  if (xmlData[0] === "\uFEFF") {
    xmlData = xmlData.substr(1);
  }
  for (let i = 0; i < xmlData.length; i++) {
    if (xmlData[i] === "<" && xmlData[i + 1] === "?") {
      i += 2;
      i = readPI(xmlData, i);
      if (i.err) return i;
    } else if (xmlData[i] === "<") {
      let tagStartPos = i;
      i++;
      if (xmlData[i] === "!") {
        i = readCommentAndCDATA(xmlData, i);
        continue;
      } else {
        let closingTag = false;
        if (xmlData[i] === "/") {
          closingTag = true;
          i++;
        }
        let tagName = "";
        for (; i < xmlData.length && xmlData[i] !== ">" && xmlData[i] !== " " && xmlData[i] !== "	" && xmlData[i] !== "\n" && xmlData[i] !== "\r"; i++) {
          tagName += xmlData[i];
        }
        tagName = tagName.trim();
        if (tagName[tagName.length - 1] === "/") {
          tagName = tagName.substring(0, tagName.length - 1);
          i--;
        }
        if (!validateTagName(tagName)) {
          let msg;
          if (tagName.trim().length === 0) {
            msg = "Invalid space after '<'.";
          } else {
            msg = "Tag '" + tagName + "' is an invalid name.";
          }
          return getErrorObject("InvalidTag", msg, getLineNumberForPosition(xmlData, i));
        }
        const result = readAttributeStr(xmlData, i);
        if (result === false) {
          return getErrorObject("InvalidAttr", "Attributes for '" + tagName + "' have open quote.", getLineNumberForPosition(xmlData, i));
        }
        let attrStr = result.value;
        i = result.index;
        if (attrStr[attrStr.length - 1] === "/") {
          const attrStrStart = i - attrStr.length;
          attrStr = attrStr.substring(0, attrStr.length - 1);
          const isValid = validateAttributeString(attrStr, options);
          if (isValid === true) {
            tagFound = true;
          } else {
            return getErrorObject(isValid.err.code, isValid.err.msg, getLineNumberForPosition(xmlData, attrStrStart + isValid.err.line));
          }
        } else if (closingTag) {
          if (!result.tagClosed) {
            return getErrorObject("InvalidTag", "Closing tag '" + tagName + "' doesn't have proper closing.", getLineNumberForPosition(xmlData, i));
          } else if (attrStr.trim().length > 0) {
            return getErrorObject("InvalidTag", "Closing tag '" + tagName + "' can't have attributes or invalid starting.", getLineNumberForPosition(xmlData, tagStartPos));
          } else if (tags.length === 0) {
            return getErrorObject("InvalidTag", "Closing tag '" + tagName + "' has not been opened.", getLineNumberForPosition(xmlData, tagStartPos));
          } else {
            const otg = tags.pop();
            if (tagName !== otg.tagName) {
              let openPos = getLineNumberForPosition(xmlData, otg.tagStartPos);
              return getErrorObject(
                "InvalidTag",
                "Expected closing tag '" + otg.tagName + "' (opened in line " + openPos.line + ", col " + openPos.col + ") instead of closing tag '" + tagName + "'.",
                getLineNumberForPosition(xmlData, tagStartPos)
              );
            }
            if (tags.length == 0) {
              reachedRoot = true;
            }
          }
        } else {
          const isValid = validateAttributeString(attrStr, options);
          if (isValid !== true) {
            return getErrorObject(isValid.err.code, isValid.err.msg, getLineNumberForPosition(xmlData, i - attrStr.length + isValid.err.line));
          }
          if (reachedRoot === true) {
            return getErrorObject("InvalidXml", "Multiple possible root nodes found.", getLineNumberForPosition(xmlData, i));
          } else if (options.unpairedTags.indexOf(tagName) !== -1) ;
          else {
            tags.push({ tagName, tagStartPos });
          }
          tagFound = true;
        }
        for (i++; i < xmlData.length; i++) {
          if (xmlData[i] === "<") {
            if (xmlData[i + 1] === "!") {
              i++;
              i = readCommentAndCDATA(xmlData, i);
              continue;
            } else if (xmlData[i + 1] === "?") {
              i = readPI(xmlData, ++i);
              if (i.err) return i;
            } else {
              break;
            }
          } else if (xmlData[i] === "&") {
            const afterAmp = validateAmpersand(xmlData, i);
            if (afterAmp == -1)
              return getErrorObject("InvalidChar", "char '&' is not expected.", getLineNumberForPosition(xmlData, i));
            i = afterAmp;
          } else {
            if (reachedRoot === true && !isWhiteSpace$1(xmlData[i])) {
              return getErrorObject("InvalidXml", "Extra text at the end", getLineNumberForPosition(xmlData, i));
            }
          }
        }
        if (xmlData[i] === "<") {
          i--;
        }
      }
    } else {
      if (isWhiteSpace$1(xmlData[i])) {
        continue;
      }
      return getErrorObject("InvalidChar", "char '" + xmlData[i] + "' is not expected.", getLineNumberForPosition(xmlData, i));
    }
  }
  if (!tagFound) {
    return getErrorObject("InvalidXml", "Start tag expected.", 1);
  } else if (tags.length == 1) {
    return getErrorObject("InvalidTag", "Unclosed tag '" + tags[0].tagName + "'.", getLineNumberForPosition(xmlData, tags[0].tagStartPos));
  } else if (tags.length > 0) {
    return getErrorObject("InvalidXml", "Invalid '" + JSON.stringify(tags.map((t) => t.tagName), null, 4).replace(/\r?\n/g, "") + "' found.", { line: 1, col: 1 });
  }
  return true;
}
function isWhiteSpace$1(char) {
  return char === " " || char === "	" || char === "\n" || char === "\r";
}
function readPI(xmlData, i) {
  const start = i;
  for (; i < xmlData.length; i++) {
    if (xmlData[i] == "?" || xmlData[i] == " ") {
      const tagname = xmlData.substr(start, i - start);
      if (i > 5 && tagname === "xml") {
        return getErrorObject("InvalidXml", "XML declaration allowed only at the start of the document.", getLineNumberForPosition(xmlData, i));
      } else if (xmlData[i] == "?" && xmlData[i + 1] == ">") {
        i++;
        break;
      } else {
        continue;
      }
    }
  }
  return i;
}
function readCommentAndCDATA(xmlData, i) {
  if (xmlData.length > i + 5 && xmlData[i + 1] === "-" && xmlData[i + 2] === "-") {
    for (i += 3; i < xmlData.length; i++) {
      if (xmlData[i] === "-" && xmlData[i + 1] === "-" && xmlData[i + 2] === ">") {
        i += 2;
        break;
      }
    }
  } else if (xmlData.length > i + 8 && xmlData[i + 1] === "D" && xmlData[i + 2] === "O" && xmlData[i + 3] === "C" && xmlData[i + 4] === "T" && xmlData[i + 5] === "Y" && xmlData[i + 6] === "P" && xmlData[i + 7] === "E") {
    let angleBracketsCount = 1;
    for (i += 8; i < xmlData.length; i++) {
      if (xmlData[i] === "<") {
        angleBracketsCount++;
      } else if (xmlData[i] === ">") {
        angleBracketsCount--;
        if (angleBracketsCount === 0) {
          break;
        }
      }
    }
  } else if (xmlData.length > i + 9 && xmlData[i + 1] === "[" && xmlData[i + 2] === "C" && xmlData[i + 3] === "D" && xmlData[i + 4] === "A" && xmlData[i + 5] === "T" && xmlData[i + 6] === "A" && xmlData[i + 7] === "[") {
    for (i += 8; i < xmlData.length; i++) {
      if (xmlData[i] === "]" && xmlData[i + 1] === "]" && xmlData[i + 2] === ">") {
        i += 2;
        break;
      }
    }
  }
  return i;
}
const doubleQuote = '"';
const singleQuote = "'";
function readAttributeStr(xmlData, i) {
  let attrStr = "";
  let startChar = "";
  let tagClosed = false;
  for (; i < xmlData.length; i++) {
    if (xmlData[i] === doubleQuote || xmlData[i] === singleQuote) {
      if (startChar === "") {
        startChar = xmlData[i];
      } else if (startChar !== xmlData[i]) ;
      else {
        startChar = "";
      }
    } else if (xmlData[i] === ">") {
      if (startChar === "") {
        tagClosed = true;
        break;
      }
    }
    attrStr += xmlData[i];
  }
  if (startChar !== "") {
    return false;
  }
  return {
    value: attrStr,
    index: i,
    tagClosed
  };
}
const validAttrStrRegxp = new RegExp(`(\\s*)([^\\s=]+)(\\s*=)?(\\s*(['"])(([\\s\\S])*?)\\5)?`, "g");
function validateAttributeString(attrStr, options) {
  const matches = getAllMatches(attrStr, validAttrStrRegxp);
  const attrNames = {};
  for (let i = 0; i < matches.length; i++) {
    if (matches[i][1].length === 0) {
      return getErrorObject("InvalidAttr", "Attribute '" + matches[i][2] + "' has no space in starting.", getPositionFromMatch(matches[i]));
    } else if (matches[i][3] !== void 0 && matches[i][4] === void 0) {
      return getErrorObject("InvalidAttr", "Attribute '" + matches[i][2] + "' is without value.", getPositionFromMatch(matches[i]));
    } else if (matches[i][3] === void 0 && !options.allowBooleanAttributes) {
      return getErrorObject("InvalidAttr", "boolean attribute '" + matches[i][2] + "' is not allowed.", getPositionFromMatch(matches[i]));
    }
    const attrName = matches[i][2];
    if (!validateAttrName(attrName)) {
      return getErrorObject("InvalidAttr", "Attribute '" + attrName + "' is an invalid name.", getPositionFromMatch(matches[i]));
    }
    if (!attrNames.hasOwnProperty(attrName)) {
      attrNames[attrName] = 1;
    } else {
      return getErrorObject("InvalidAttr", "Attribute '" + attrName + "' is repeated.", getPositionFromMatch(matches[i]));
    }
  }
  return true;
}
function validateNumberAmpersand(xmlData, i) {
  let re2 = /\d/;
  if (xmlData[i] === "x") {
    i++;
    re2 = /[\da-fA-F]/;
  }
  for (; i < xmlData.length; i++) {
    if (xmlData[i] === ";")
      return i;
    if (!xmlData[i].match(re2))
      break;
  }
  return -1;
}
function validateAmpersand(xmlData, i) {
  i++;
  if (xmlData[i] === ";")
    return -1;
  if (xmlData[i] === "#") {
    i++;
    return validateNumberAmpersand(xmlData, i);
  }
  let count = 0;
  for (; i < xmlData.length; i++, count++) {
    if (xmlData[i].match(/\w/) && count < 20)
      continue;
    if (xmlData[i] === ";")
      break;
    return -1;
  }
  return i;
}
function getErrorObject(code, message, lineNumber) {
  return {
    err: {
      code,
      msg: message,
      line: lineNumber.line || lineNumber,
      col: lineNumber.col
    }
  };
}
function validateAttrName(attrName) {
  return isName(attrName);
}
function validateTagName(tagname) {
  return isName(tagname);
}
function getLineNumberForPosition(xmlData, index) {
  const lines = xmlData.substring(0, index).split(/\r?\n/);
  return {
    line: lines.length,
    // column number is last line's length + 1, because column numbering starts at 1:
    col: lines[lines.length - 1].length + 1
  };
}
function getPositionFromMatch(match) {
  return match.startIndex + match[1].length;
}
const defaultOptions$1 = {
  preserveOrder: false,
  attributeNamePrefix: "@_",
  attributesGroupName: false,
  textNodeName: "#text",
  ignoreAttributes: true,
  removeNSPrefix: false,
  // remove NS from tag name or attribute name if true
  allowBooleanAttributes: false,
  //a tag can have attributes without any value
  //ignoreRootElement : false,
  parseTagValue: true,
  parseAttributeValue: false,
  trimValues: true,
  //Trim string values of tag and attributes
  cdataPropName: false,
  numberParseOptions: {
    hex: true,
    leadingZeros: true,
    eNotation: true
  },
  tagValueProcessor: function(tagName, val) {
    return val;
  },
  attributeValueProcessor: function(attrName, val) {
    return val;
  },
  stopNodes: [],
  //nested tags will not be parsed even for errors
  alwaysCreateTextNode: false,
  isArray: () => false,
  commentPropName: false,
  unpairedTags: [],
  processEntities: true,
  htmlEntities: false,
  ignoreDeclaration: false,
  ignorePiTags: false,
  transformTagName: false,
  transformAttributeName: false,
  updateTag: function(tagName, jPath, attrs) {
    return tagName;
  },
  // skipEmptyListItem: false
  captureMetaData: false
};
const buildOptions = function(options) {
  return Object.assign({}, defaultOptions$1, options);
};
let METADATA_SYMBOL$1;
if (typeof Symbol !== "function") {
  METADATA_SYMBOL$1 = "@@xmlMetadata";
} else {
  METADATA_SYMBOL$1 = Symbol("XML Node Metadata");
}
class XmlNode {
  constructor(tagname) {
    this.tagname = tagname;
    this.child = [];
    this[":@"] = {};
  }
  add(key, val) {
    if (key === "__proto__") key = "#__proto__";
    this.child.push({ [key]: val });
  }
  addChild(node2, startIndex) {
    if (node2.tagname === "__proto__") node2.tagname = "#__proto__";
    if (node2[":@"] && Object.keys(node2[":@"]).length > 0) {
      this.child.push({ [node2.tagname]: node2.child, [":@"]: node2[":@"] });
    } else {
      this.child.push({ [node2.tagname]: node2.child });
    }
    if (startIndex !== void 0) {
      this.child[this.child.length - 1][METADATA_SYMBOL$1] = { startIndex };
    }
  }
  /** symbol used for metadata */
  static getMetaDataSymbol() {
    return METADATA_SYMBOL$1;
  }
}
function readDocType(xmlData, i) {
  const entities = {};
  if (xmlData[i + 3] === "O" && xmlData[i + 4] === "C" && xmlData[i + 5] === "T" && xmlData[i + 6] === "Y" && xmlData[i + 7] === "P" && xmlData[i + 8] === "E") {
    i = i + 9;
    let angleBracketsCount = 1;
    let hasBody = false, comment = false;
    let exp = "";
    for (; i < xmlData.length; i++) {
      if (xmlData[i] === "<" && !comment) {
        if (hasBody && hasSeq(xmlData, "!ENTITY", i)) {
          i += 7;
          let entityName, val;
          [entityName, val, i] = readEntityExp(xmlData, i + 1);
          if (val.indexOf("&") === -1)
            entities[entityName] = {
              regx: RegExp(`&${entityName};`, "g"),
              val
            };
        } else if (hasBody && hasSeq(xmlData, "!ELEMENT", i)) {
          i += 8;
          const { index } = readElementExp(xmlData, i + 1);
          i = index;
        } else if (hasBody && hasSeq(xmlData, "!ATTLIST", i)) {
          i += 8;
        } else if (hasBody && hasSeq(xmlData, "!NOTATION", i)) {
          i += 9;
          const { index } = readNotationExp(xmlData, i + 1);
          i = index;
        } else if (hasSeq(xmlData, "!--", i)) comment = true;
        else throw new Error(`Invalid DOCTYPE`);
        angleBracketsCount++;
        exp = "";
      } else if (xmlData[i] === ">") {
        if (comment) {
          if (xmlData[i - 1] === "-" && xmlData[i - 2] === "-") {
            comment = false;
            angleBracketsCount--;
          }
        } else {
          angleBracketsCount--;
        }
        if (angleBracketsCount === 0) {
          break;
        }
      } else if (xmlData[i] === "[") {
        hasBody = true;
      } else {
        exp += xmlData[i];
      }
    }
    if (angleBracketsCount !== 0) {
      throw new Error(`Unclosed DOCTYPE`);
    }
  } else {
    throw new Error(`Invalid Tag instead of DOCTYPE`);
  }
  return { entities, i };
}
const skipWhitespace = (data, index) => {
  while (index < data.length && /\s/.test(data[index])) {
    index++;
  }
  return index;
};
function readEntityExp(xmlData, i) {
  i = skipWhitespace(xmlData, i);
  let entityName = "";
  while (i < xmlData.length && !/\s/.test(xmlData[i]) && xmlData[i] !== '"' && xmlData[i] !== "'") {
    entityName += xmlData[i];
    i++;
  }
  validateEntityName(entityName);
  i = skipWhitespace(xmlData, i);
  if (xmlData.substring(i, i + 6).toUpperCase() === "SYSTEM") {
    throw new Error("External entities are not supported");
  } else if (xmlData[i] === "%") {
    throw new Error("Parameter entities are not supported");
  }
  let entityValue = "";
  [i, entityValue] = readIdentifierVal(xmlData, i, "entity");
  i--;
  return [entityName, entityValue, i];
}
function readNotationExp(xmlData, i) {
  i = skipWhitespace(xmlData, i);
  let notationName = "";
  while (i < xmlData.length && !/\s/.test(xmlData[i])) {
    notationName += xmlData[i];
    i++;
  }
  validateEntityName(notationName);
  i = skipWhitespace(xmlData, i);
  const identifierType = xmlData.substring(i, i + 6).toUpperCase();
  if (identifierType !== "SYSTEM" && identifierType !== "PUBLIC") {
    throw new Error(`Expected SYSTEM or PUBLIC, found "${identifierType}"`);
  }
  i += identifierType.length;
  i = skipWhitespace(xmlData, i);
  let publicIdentifier = null;
  let systemIdentifier = null;
  if (identifierType === "PUBLIC") {
    [i, publicIdentifier] = readIdentifierVal(xmlData, i, "publicIdentifier");
    i = skipWhitespace(xmlData, i);
    if (xmlData[i] === '"' || xmlData[i] === "'") {
      [i, systemIdentifier] = readIdentifierVal(xmlData, i, "systemIdentifier");
    }
  } else if (identifierType === "SYSTEM") {
    [i, systemIdentifier] = readIdentifierVal(xmlData, i, "systemIdentifier");
    if (!systemIdentifier) {
      throw new Error("Missing mandatory system identifier for SYSTEM notation");
    }
  }
  return { notationName, publicIdentifier, systemIdentifier, index: --i };
}
function readIdentifierVal(xmlData, i, type) {
  let identifierVal = "";
  const startChar = xmlData[i];
  if (startChar !== '"' && startChar !== "'") {
    throw new Error(`Expected quoted string, found "${startChar}"`);
  }
  i++;
  while (i < xmlData.length && xmlData[i] !== startChar) {
    identifierVal += xmlData[i];
    i++;
  }
  if (xmlData[i] !== startChar) {
    throw new Error(`Unterminated ${type} value`);
  }
  i++;
  return [i, identifierVal];
}
function readElementExp(xmlData, i) {
  i = skipWhitespace(xmlData, i);
  let elementName = "";
  while (i < xmlData.length && !/\s/.test(xmlData[i])) {
    elementName += xmlData[i];
    i++;
  }
  if (!validateEntityName(elementName)) {
    throw new Error(`Invalid element name: "${elementName}"`);
  }
  i = skipWhitespace(xmlData, i);
  let contentModel = "";
  if (xmlData[i] === "E" && hasSeq(xmlData, "MPTY", i)) i += 4;
  else if (xmlData[i] === "A" && hasSeq(xmlData, "NY", i)) i += 2;
  else if (xmlData[i] === "(") {
    i++;
    while (i < xmlData.length && xmlData[i] !== ")") {
      contentModel += xmlData[i];
      i++;
    }
    if (xmlData[i] !== ")") {
      throw new Error("Unterminated content model");
    }
  } else {
    throw new Error(`Invalid Element Expression, found "${xmlData[i]}"`);
  }
  return {
    elementName,
    contentModel: contentModel.trim(),
    index: i
  };
}
function hasSeq(data, seq, i) {
  for (let j = 0; j < seq.length; j++) {
    if (seq[j] !== data[i + j + 1]) return false;
  }
  return true;
}
function validateEntityName(name) {
  if (isName(name))
    return name;
  else
    throw new Error(`Invalid entity name ${name}`);
}
const hexRegex = /^[-+]?0x[a-fA-F0-9]+$/;
const numRegex = /^([\-\+])?(0*)([0-9]*(\.[0-9]*)?)$/;
const consider = {
  hex: true,
  // oct: false,
  leadingZeros: true,
  decimalPoint: ".",
  eNotation: true
  //skipLike: /regex/
};
function toNumber(str, options = {}) {
  options = Object.assign({}, consider, options);
  if (!str || typeof str !== "string") return str;
  let trimmedStr = str.trim();
  if (options.skipLike !== void 0 && options.skipLike.test(trimmedStr)) return str;
  else if (str === "0") return 0;
  else if (options.hex && hexRegex.test(trimmedStr)) {
    return parse_int(trimmedStr, 16);
  } else if (trimmedStr.search(/.+[eE].+/) !== -1) {
    return resolveEnotation(str, trimmedStr, options);
  } else {
    const match = numRegex.exec(trimmedStr);
    if (match) {
      const sign = match[1] || "";
      const leadingZeros = match[2];
      let numTrimmedByZeros = trimZeros(match[3]);
      const decimalAdjacentToLeadingZeros = sign ? (
        // 0., -00., 000.
        str[leadingZeros.length + 1] === "."
      ) : str[leadingZeros.length] === ".";
      if (!options.leadingZeros && (leadingZeros.length > 1 || leadingZeros.length === 1 && !decimalAdjacentToLeadingZeros)) {
        return str;
      } else {
        const num = Number(trimmedStr);
        const parsedStr = String(num);
        if (num === 0) return num;
        if (parsedStr.search(/[eE]/) !== -1) {
          if (options.eNotation) return num;
          else return str;
        } else if (trimmedStr.indexOf(".") !== -1) {
          if (parsedStr === "0") return num;
          else if (parsedStr === numTrimmedByZeros) return num;
          else if (parsedStr === `${sign}${numTrimmedByZeros}`) return num;
          else return str;
        }
        let n = leadingZeros ? numTrimmedByZeros : trimmedStr;
        if (leadingZeros) {
          return n === parsedStr || sign + n === parsedStr ? num : str;
        } else {
          return n === parsedStr || n === sign + parsedStr ? num : str;
        }
      }
    } else {
      return str;
    }
  }
}
const eNotationRegx = /^([-+])?(0*)(\d*(\.\d*)?[eE][-\+]?\d+)$/;
function resolveEnotation(str, trimmedStr, options) {
  if (!options.eNotation) return str;
  const notation = trimmedStr.match(eNotationRegx);
  if (notation) {
    let sign = notation[1] || "";
    const eChar = notation[3].indexOf("e") === -1 ? "E" : "e";
    const leadingZeros = notation[2];
    const eAdjacentToLeadingZeros = sign ? (
      // 0E.
      str[leadingZeros.length + 1] === eChar
    ) : str[leadingZeros.length] === eChar;
    if (leadingZeros.length > 1 && eAdjacentToLeadingZeros) return str;
    else if (leadingZeros.length === 1 && (notation[3].startsWith(`.${eChar}`) || notation[3][0] === eChar)) {
      return Number(trimmedStr);
    } else if (options.leadingZeros && !eAdjacentToLeadingZeros) {
      trimmedStr = (notation[1] || "") + notation[3];
      return Number(trimmedStr);
    } else return str;
  } else {
    return str;
  }
}
function trimZeros(numStr) {
  if (numStr && numStr.indexOf(".") !== -1) {
    numStr = numStr.replace(/0+$/, "");
    if (numStr === ".") numStr = "0";
    else if (numStr[0] === ".") numStr = "0" + numStr;
    else if (numStr[numStr.length - 1] === ".") numStr = numStr.substring(0, numStr.length - 1);
    return numStr;
  }
  return numStr;
}
function parse_int(numStr, base) {
  if (parseInt) return parseInt(numStr, base);
  else if (Number.parseInt) return Number.parseInt(numStr, base);
  else if (window && window.parseInt) return window.parseInt(numStr, base);
  else throw new Error("parseInt, Number.parseInt, window.parseInt are not supported");
}
function getIgnoreAttributesFn(ignoreAttributes) {
  if (typeof ignoreAttributes === "function") {
    return ignoreAttributes;
  }
  if (Array.isArray(ignoreAttributes)) {
    return (attrName) => {
      for (const pattern of ignoreAttributes) {
        if (typeof pattern === "string" && attrName === pattern) {
          return true;
        }
        if (pattern instanceof RegExp && pattern.test(attrName)) {
          return true;
        }
      }
    };
  }
  return () => false;
}
class OrderedObjParser {
  constructor(options) {
    this.options = options;
    this.currentNode = null;
    this.tagsNodeStack = [];
    this.docTypeEntities = {};
    this.lastEntities = {
      "apos": { regex: /&(apos|#39|#x27);/g, val: "'" },
      "gt": { regex: /&(gt|#62|#x3E);/g, val: ">" },
      "lt": { regex: /&(lt|#60|#x3C);/g, val: "<" },
      "quot": { regex: /&(quot|#34|#x22);/g, val: '"' }
    };
    this.ampEntity = { regex: /&(amp|#38|#x26);/g, val: "&" };
    this.htmlEntities = {
      "space": { regex: /&(nbsp|#160);/g, val: " " },
      // "lt" : { regex: /&(lt|#60);/g, val: "<" },
      // "gt" : { regex: /&(gt|#62);/g, val: ">" },
      // "amp" : { regex: /&(amp|#38);/g, val: "&" },
      // "quot" : { regex: /&(quot|#34);/g, val: "\"" },
      // "apos" : { regex: /&(apos|#39);/g, val: "'" },
      "cent": { regex: /&(cent|#162);/g, val: "¢" },
      "pound": { regex: /&(pound|#163);/g, val: "£" },
      "yen": { regex: /&(yen|#165);/g, val: "¥" },
      "euro": { regex: /&(euro|#8364);/g, val: "€" },
      "copyright": { regex: /&(copy|#169);/g, val: "©" },
      "reg": { regex: /&(reg|#174);/g, val: "®" },
      "inr": { regex: /&(inr|#8377);/g, val: "₹" },
      "num_dec": { regex: /&#([0-9]{1,7});/g, val: (_2, str) => String.fromCodePoint(Number.parseInt(str, 10)) },
      "num_hex": { regex: /&#x([0-9a-fA-F]{1,6});/g, val: (_2, str) => String.fromCodePoint(Number.parseInt(str, 16)) }
    };
    this.addExternalEntities = addExternalEntities;
    this.parseXml = parseXml;
    this.parseTextData = parseTextData;
    this.resolveNameSpace = resolveNameSpace;
    this.buildAttributesMap = buildAttributesMap;
    this.isItStopNode = isItStopNode;
    this.replaceEntitiesValue = replaceEntitiesValue;
    this.readStopNodeData = readStopNodeData;
    this.saveTextToParentTag = saveTextToParentTag;
    this.addChild = addChild;
    this.ignoreAttributesFn = getIgnoreAttributesFn(this.options.ignoreAttributes);
  }
}
function addExternalEntities(externalEntities) {
  const entKeys = Object.keys(externalEntities);
  for (let i = 0; i < entKeys.length; i++) {
    const ent = entKeys[i];
    this.lastEntities[ent] = {
      regex: new RegExp("&" + ent + ";", "g"),
      val: externalEntities[ent]
    };
  }
}
function parseTextData(val, tagName, jPath, dontTrim, hasAttributes, isLeafNode, escapeEntities) {
  if (val !== void 0) {
    if (this.options.trimValues && !dontTrim) {
      val = val.trim();
    }
    if (val.length > 0) {
      if (!escapeEntities) val = this.replaceEntitiesValue(val);
      const newval = this.options.tagValueProcessor(tagName, val, jPath, hasAttributes, isLeafNode);
      if (newval === null || newval === void 0) {
        return val;
      } else if (typeof newval !== typeof val || newval !== val) {
        return newval;
      } else if (this.options.trimValues) {
        return parseValue(val, this.options.parseTagValue, this.options.numberParseOptions);
      } else {
        const trimmedVal = val.trim();
        if (trimmedVal === val) {
          return parseValue(val, this.options.parseTagValue, this.options.numberParseOptions);
        } else {
          return val;
        }
      }
    }
  }
}
function resolveNameSpace(tagname) {
  if (this.options.removeNSPrefix) {
    const tags = tagname.split(":");
    const prefix = tagname.charAt(0) === "/" ? "/" : "";
    if (tags[0] === "xmlns") {
      return "";
    }
    if (tags.length === 2) {
      tagname = prefix + tags[1];
    }
  }
  return tagname;
}
const attrsRegx = new RegExp(`([^\\s=]+)\\s*(=\\s*(['"])([\\s\\S]*?)\\3)?`, "gm");
function buildAttributesMap(attrStr, jPath, tagName) {
  if (this.options.ignoreAttributes !== true && typeof attrStr === "string") {
    const matches = getAllMatches(attrStr, attrsRegx);
    const len = matches.length;
    const attrs = {};
    for (let i = 0; i < len; i++) {
      const attrName = this.resolveNameSpace(matches[i][1]);
      if (this.ignoreAttributesFn(attrName, jPath)) {
        continue;
      }
      let oldVal = matches[i][4];
      let aName = this.options.attributeNamePrefix + attrName;
      if (attrName.length) {
        if (this.options.transformAttributeName) {
          aName = this.options.transformAttributeName(aName);
        }
        if (aName === "__proto__") aName = "#__proto__";
        if (oldVal !== void 0) {
          if (this.options.trimValues) {
            oldVal = oldVal.trim();
          }
          oldVal = this.replaceEntitiesValue(oldVal);
          const newVal = this.options.attributeValueProcessor(attrName, oldVal, jPath);
          if (newVal === null || newVal === void 0) {
            attrs[aName] = oldVal;
          } else if (typeof newVal !== typeof oldVal || newVal !== oldVal) {
            attrs[aName] = newVal;
          } else {
            attrs[aName] = parseValue(
              oldVal,
              this.options.parseAttributeValue,
              this.options.numberParseOptions
            );
          }
        } else if (this.options.allowBooleanAttributes) {
          attrs[aName] = true;
        }
      }
    }
    if (!Object.keys(attrs).length) {
      return;
    }
    if (this.options.attributesGroupName) {
      const attrCollection = {};
      attrCollection[this.options.attributesGroupName] = attrs;
      return attrCollection;
    }
    return attrs;
  }
}
const parseXml = function(xmlData) {
  xmlData = xmlData.replace(/\r\n?/g, "\n");
  const xmlObj = new XmlNode("!xml");
  let currentNode = xmlObj;
  let textData = "";
  let jPath = "";
  for (let i = 0; i < xmlData.length; i++) {
    const ch = xmlData[i];
    if (ch === "<") {
      if (xmlData[i + 1] === "/") {
        const closeIndex = findClosingIndex(xmlData, ">", i, "Closing Tag is not closed.");
        let tagName = xmlData.substring(i + 2, closeIndex).trim();
        if (this.options.removeNSPrefix) {
          const colonIndex = tagName.indexOf(":");
          if (colonIndex !== -1) {
            tagName = tagName.substr(colonIndex + 1);
          }
        }
        if (this.options.transformTagName) {
          tagName = this.options.transformTagName(tagName);
        }
        if (currentNode) {
          textData = this.saveTextToParentTag(textData, currentNode, jPath);
        }
        const lastTagName = jPath.substring(jPath.lastIndexOf(".") + 1);
        if (tagName && this.options.unpairedTags.indexOf(tagName) !== -1) {
          throw new Error(`Unpaired tag can not be used as closing tag: </${tagName}>`);
        }
        let propIndex = 0;
        if (lastTagName && this.options.unpairedTags.indexOf(lastTagName) !== -1) {
          propIndex = jPath.lastIndexOf(".", jPath.lastIndexOf(".") - 1);
          this.tagsNodeStack.pop();
        } else {
          propIndex = jPath.lastIndexOf(".");
        }
        jPath = jPath.substring(0, propIndex);
        currentNode = this.tagsNodeStack.pop();
        textData = "";
        i = closeIndex;
      } else if (xmlData[i + 1] === "?") {
        let tagData = readTagExp(xmlData, i, false, "?>");
        if (!tagData) throw new Error("Pi Tag is not closed.");
        textData = this.saveTextToParentTag(textData, currentNode, jPath);
        if (this.options.ignoreDeclaration && tagData.tagName === "?xml" || this.options.ignorePiTags) ;
        else {
          const childNode = new XmlNode(tagData.tagName);
          childNode.add(this.options.textNodeName, "");
          if (tagData.tagName !== tagData.tagExp && tagData.attrExpPresent) {
            childNode[":@"] = this.buildAttributesMap(tagData.tagExp, jPath, tagData.tagName);
          }
          this.addChild(currentNode, childNode, jPath, i);
        }
        i = tagData.closeIndex + 1;
      } else if (xmlData.substr(i + 1, 3) === "!--") {
        const endIndex = findClosingIndex(xmlData, "-->", i + 4, "Comment is not closed.");
        if (this.options.commentPropName) {
          const comment = xmlData.substring(i + 4, endIndex - 2);
          textData = this.saveTextToParentTag(textData, currentNode, jPath);
          currentNode.add(this.options.commentPropName, [{ [this.options.textNodeName]: comment }]);
        }
        i = endIndex;
      } else if (xmlData.substr(i + 1, 2) === "!D") {
        const result = readDocType(xmlData, i);
        this.docTypeEntities = result.entities;
        i = result.i;
      } else if (xmlData.substr(i + 1, 2) === "![") {
        const closeIndex = findClosingIndex(xmlData, "]]>", i, "CDATA is not closed.") - 2;
        const tagExp = xmlData.substring(i + 9, closeIndex);
        textData = this.saveTextToParentTag(textData, currentNode, jPath);
        let val = this.parseTextData(tagExp, currentNode.tagname, jPath, true, false, true, true);
        if (val == void 0) val = "";
        if (this.options.cdataPropName) {
          currentNode.add(this.options.cdataPropName, [{ [this.options.textNodeName]: tagExp }]);
        } else {
          currentNode.add(this.options.textNodeName, val);
        }
        i = closeIndex + 2;
      } else {
        let result = readTagExp(xmlData, i, this.options.removeNSPrefix);
        let tagName = result.tagName;
        const rawTagName = result.rawTagName;
        let tagExp = result.tagExp;
        let attrExpPresent = result.attrExpPresent;
        let closeIndex = result.closeIndex;
        if (this.options.transformTagName) {
          tagName = this.options.transformTagName(tagName);
        }
        if (currentNode && textData) {
          if (currentNode.tagname !== "!xml") {
            textData = this.saveTextToParentTag(textData, currentNode, jPath, false);
          }
        }
        const lastTag = currentNode;
        if (lastTag && this.options.unpairedTags.indexOf(lastTag.tagname) !== -1) {
          currentNode = this.tagsNodeStack.pop();
          jPath = jPath.substring(0, jPath.lastIndexOf("."));
        }
        if (tagName !== xmlObj.tagname) {
          jPath += jPath ? "." + tagName : tagName;
        }
        const startIndex = i;
        if (this.isItStopNode(this.options.stopNodes, jPath, tagName)) {
          let tagContent = "";
          if (tagExp.length > 0 && tagExp.lastIndexOf("/") === tagExp.length - 1) {
            if (tagName[tagName.length - 1] === "/") {
              tagName = tagName.substr(0, tagName.length - 1);
              jPath = jPath.substr(0, jPath.length - 1);
              tagExp = tagName;
            } else {
              tagExp = tagExp.substr(0, tagExp.length - 1);
            }
            i = result.closeIndex;
          } else if (this.options.unpairedTags.indexOf(tagName) !== -1) {
            i = result.closeIndex;
          } else {
            const result2 = this.readStopNodeData(xmlData, rawTagName, closeIndex + 1);
            if (!result2) throw new Error(`Unexpected end of ${rawTagName}`);
            i = result2.i;
            tagContent = result2.tagContent;
          }
          const childNode = new XmlNode(tagName);
          if (tagName !== tagExp && attrExpPresent) {
            childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
          }
          if (tagContent) {
            tagContent = this.parseTextData(tagContent, tagName, jPath, true, attrExpPresent, true, true);
          }
          jPath = jPath.substr(0, jPath.lastIndexOf("."));
          childNode.add(this.options.textNodeName, tagContent);
          this.addChild(currentNode, childNode, jPath, startIndex);
        } else {
          if (tagExp.length > 0 && tagExp.lastIndexOf("/") === tagExp.length - 1) {
            if (tagName[tagName.length - 1] === "/") {
              tagName = tagName.substr(0, tagName.length - 1);
              jPath = jPath.substr(0, jPath.length - 1);
              tagExp = tagName;
            } else {
              tagExp = tagExp.substr(0, tagExp.length - 1);
            }
            if (this.options.transformTagName) {
              tagName = this.options.transformTagName(tagName);
            }
            const childNode = new XmlNode(tagName);
            if (tagName !== tagExp && attrExpPresent) {
              childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
            }
            this.addChild(currentNode, childNode, jPath, startIndex);
            jPath = jPath.substr(0, jPath.lastIndexOf("."));
          } else {
            const childNode = new XmlNode(tagName);
            this.tagsNodeStack.push(currentNode);
            if (tagName !== tagExp && attrExpPresent) {
              childNode[":@"] = this.buildAttributesMap(tagExp, jPath, tagName);
            }
            this.addChild(currentNode, childNode, jPath, startIndex);
            currentNode = childNode;
          }
          textData = "";
          i = closeIndex;
        }
      }
    } else {
      textData += xmlData[i];
    }
  }
  return xmlObj.child;
};
function addChild(currentNode, childNode, jPath, startIndex) {
  if (!this.options.captureMetaData) startIndex = void 0;
  const result = this.options.updateTag(childNode.tagname, jPath, childNode[":@"]);
  if (result === false) ;
  else if (typeof result === "string") {
    childNode.tagname = result;
    currentNode.addChild(childNode, startIndex);
  } else {
    currentNode.addChild(childNode, startIndex);
  }
}
const replaceEntitiesValue = function(val) {
  if (this.options.processEntities) {
    for (let entityName in this.docTypeEntities) {
      const entity = this.docTypeEntities[entityName];
      val = val.replace(entity.regx, entity.val);
    }
    for (let entityName in this.lastEntities) {
      const entity = this.lastEntities[entityName];
      val = val.replace(entity.regex, entity.val);
    }
    if (this.options.htmlEntities) {
      for (let entityName in this.htmlEntities) {
        const entity = this.htmlEntities[entityName];
        val = val.replace(entity.regex, entity.val);
      }
    }
    val = val.replace(this.ampEntity.regex, this.ampEntity.val);
  }
  return val;
};
function saveTextToParentTag(textData, currentNode, jPath, isLeafNode) {
  if (textData) {
    if (isLeafNode === void 0) isLeafNode = currentNode.child.length === 0;
    textData = this.parseTextData(
      textData,
      currentNode.tagname,
      jPath,
      false,
      currentNode[":@"] ? Object.keys(currentNode[":@"]).length !== 0 : false,
      isLeafNode
    );
    if (textData !== void 0 && textData !== "")
      currentNode.add(this.options.textNodeName, textData);
    textData = "";
  }
  return textData;
}
function isItStopNode(stopNodes, jPath, currentTagName) {
  const allNodesExp = "*." + currentTagName;
  for (const stopNodePath in stopNodes) {
    const stopNodeExp = stopNodes[stopNodePath];
    if (allNodesExp === stopNodeExp || jPath === stopNodeExp) return true;
  }
  return false;
}
function tagExpWithClosingIndex(xmlData, i, closingChar = ">") {
  let attrBoundary;
  let tagExp = "";
  for (let index = i; index < xmlData.length; index++) {
    let ch = xmlData[index];
    if (attrBoundary) {
      if (ch === attrBoundary) attrBoundary = "";
    } else if (ch === '"' || ch === "'") {
      attrBoundary = ch;
    } else if (ch === closingChar[0]) {
      if (closingChar[1]) {
        if (xmlData[index + 1] === closingChar[1]) {
          return {
            data: tagExp,
            index
          };
        }
      } else {
        return {
          data: tagExp,
          index
        };
      }
    } else if (ch === "	") {
      ch = " ";
    }
    tagExp += ch;
  }
}
function findClosingIndex(xmlData, str, i, errMsg) {
  const closingIndex = xmlData.indexOf(str, i);
  if (closingIndex === -1) {
    throw new Error(errMsg);
  } else {
    return closingIndex + str.length - 1;
  }
}
function readTagExp(xmlData, i, removeNSPrefix, closingChar = ">") {
  const result = tagExpWithClosingIndex(xmlData, i + 1, closingChar);
  if (!result) return;
  let tagExp = result.data;
  const closeIndex = result.index;
  const separatorIndex = tagExp.search(/\s/);
  let tagName = tagExp;
  let attrExpPresent = true;
  if (separatorIndex !== -1) {
    tagName = tagExp.substring(0, separatorIndex);
    tagExp = tagExp.substring(separatorIndex + 1).trimStart();
  }
  const rawTagName = tagName;
  if (removeNSPrefix) {
    const colonIndex = tagName.indexOf(":");
    if (colonIndex !== -1) {
      tagName = tagName.substr(colonIndex + 1);
      attrExpPresent = tagName !== result.data.substr(colonIndex + 1);
    }
  }
  return {
    tagName,
    tagExp,
    closeIndex,
    attrExpPresent,
    rawTagName
  };
}
function readStopNodeData(xmlData, tagName, i) {
  const startIndex = i;
  let openTagCount = 1;
  for (; i < xmlData.length; i++) {
    if (xmlData[i] === "<") {
      if (xmlData[i + 1] === "/") {
        const closeIndex = findClosingIndex(xmlData, ">", i, `${tagName} is not closed`);
        let closeTagName = xmlData.substring(i + 2, closeIndex).trim();
        if (closeTagName === tagName) {
          openTagCount--;
          if (openTagCount === 0) {
            return {
              tagContent: xmlData.substring(startIndex, i),
              i: closeIndex
            };
          }
        }
        i = closeIndex;
      } else if (xmlData[i + 1] === "?") {
        const closeIndex = findClosingIndex(xmlData, "?>", i + 1, "StopNode is not closed.");
        i = closeIndex;
      } else if (xmlData.substr(i + 1, 3) === "!--") {
        const closeIndex = findClosingIndex(xmlData, "-->", i + 3, "StopNode is not closed.");
        i = closeIndex;
      } else if (xmlData.substr(i + 1, 2) === "![") {
        const closeIndex = findClosingIndex(xmlData, "]]>", i, "StopNode is not closed.") - 2;
        i = closeIndex;
      } else {
        const tagData = readTagExp(xmlData, i, ">");
        if (tagData) {
          const openTagName = tagData && tagData.tagName;
          if (openTagName === tagName && tagData.tagExp[tagData.tagExp.length - 1] !== "/") {
            openTagCount++;
          }
          i = tagData.closeIndex;
        }
      }
    }
  }
}
function parseValue(val, shouldParse, options) {
  if (shouldParse && typeof val === "string") {
    const newval = val.trim();
    if (newval === "true") return true;
    else if (newval === "false") return false;
    else return toNumber(val, options);
  } else {
    if (isExist(val)) {
      return val;
    } else {
      return "";
    }
  }
}
const METADATA_SYMBOL = XmlNode.getMetaDataSymbol();
function prettify(node2, options) {
  return compress(node2, options);
}
function compress(arr, options, jPath) {
  let text;
  const compressedObj = {};
  for (let i = 0; i < arr.length; i++) {
    const tagObj = arr[i];
    const property = propName(tagObj);
    let newJpath = "";
    if (jPath === void 0) newJpath = property;
    else newJpath = jPath + "." + property;
    if (property === options.textNodeName) {
      if (text === void 0) text = tagObj[property];
      else text += "" + tagObj[property];
    } else if (property === void 0) {
      continue;
    } else if (tagObj[property]) {
      let val = compress(tagObj[property], options, newJpath);
      const isLeaf = isLeafTag(val, options);
      if (tagObj[METADATA_SYMBOL] !== void 0) {
        val[METADATA_SYMBOL] = tagObj[METADATA_SYMBOL];
      }
      if (tagObj[":@"]) {
        assignAttributes(val, tagObj[":@"], newJpath, options);
      } else if (Object.keys(val).length === 1 && val[options.textNodeName] !== void 0 && !options.alwaysCreateTextNode) {
        val = val[options.textNodeName];
      } else if (Object.keys(val).length === 0) {
        if (options.alwaysCreateTextNode) val[options.textNodeName] = "";
        else val = "";
      }
      if (compressedObj[property] !== void 0 && compressedObj.hasOwnProperty(property)) {
        if (!Array.isArray(compressedObj[property])) {
          compressedObj[property] = [compressedObj[property]];
        }
        compressedObj[property].push(val);
      } else {
        if (options.isArray(property, newJpath, isLeaf)) {
          compressedObj[property] = [val];
        } else {
          compressedObj[property] = val;
        }
      }
    }
  }
  if (typeof text === "string") {
    if (text.length > 0) compressedObj[options.textNodeName] = text;
  } else if (text !== void 0) compressedObj[options.textNodeName] = text;
  return compressedObj;
}
function propName(obj) {
  const keys = Object.keys(obj);
  for (let i = 0; i < keys.length; i++) {
    const key = keys[i];
    if (key !== ":@") return key;
  }
}
function assignAttributes(obj, attrMap, jpath, options) {
  if (attrMap) {
    const keys = Object.keys(attrMap);
    const len = keys.length;
    for (let i = 0; i < len; i++) {
      const atrrName = keys[i];
      if (options.isArray(atrrName, jpath + "." + atrrName, true, true)) {
        obj[atrrName] = [attrMap[atrrName]];
      } else {
        obj[atrrName] = attrMap[atrrName];
      }
    }
  }
}
function isLeafTag(obj, options) {
  const { textNodeName } = options;
  const propCount = Object.keys(obj).length;
  if (propCount === 0) {
    return true;
  }
  if (propCount === 1 && (obj[textNodeName] || typeof obj[textNodeName] === "boolean" || obj[textNodeName] === 0)) {
    return true;
  }
  return false;
}
class XMLParser {
  constructor(options) {
    this.externalEntities = {};
    this.options = buildOptions(options);
  }
  /**
   * Parse XML dats to JS object 
   * @param {string|Buffer} xmlData 
   * @param {boolean|Object} validationOption 
   */
  parse(xmlData, validationOption) {
    if (typeof xmlData === "string") ;
    else if (xmlData.toString) {
      xmlData = xmlData.toString();
    } else {
      throw new Error("XML data is accepted in String or Bytes[] form.");
    }
    if (validationOption) {
      if (validationOption === true) validationOption = {};
      const result = validate(xmlData, validationOption);
      if (result !== true) {
        throw Error(`${result.err.msg}:${result.err.line}:${result.err.col}`);
      }
    }
    const orderedObjParser = new OrderedObjParser(this.options);
    orderedObjParser.addExternalEntities(this.externalEntities);
    const orderedResult = orderedObjParser.parseXml(xmlData);
    if (this.options.preserveOrder || orderedResult === void 0) return orderedResult;
    else return prettify(orderedResult, this.options);
  }
  /**
   * Add Entity which is not by default supported by this library
   * @param {string} key 
   * @param {string} value 
   */
  addEntity(key, value) {
    if (value.indexOf("&") !== -1) {
      throw new Error("Entity value can't have '&'");
    } else if (key.indexOf("&") !== -1 || key.indexOf(";") !== -1) {
      throw new Error("An entity must be set without '&' and ';'. Eg. use '#xD' for '&#xD;'");
    } else if (value === "&") {
      throw new Error("An entity with value '&' is not permitted");
    } else {
      this.externalEntities[key] = value;
    }
  }
  /**
   * Returns a Symbol that can be used to access the metadata
   * property on a node.
   * 
   * If Symbol is not available in the environment, an ordinary property is used
   * and the name of the property is here returned.
   * 
   * The XMLMetaData property is only present when `captureMetaData`
   * is true in the options.
   */
  static getMetaDataSymbol() {
    return XmlNode.getMetaDataSymbol();
  }
}
var unzip = {};
var binary = { exports: {} };
var traverse;
var hasRequiredTraverse;
function requireTraverse() {
  if (hasRequiredTraverse) return traverse;
  hasRequiredTraverse = 1;
  traverse = Traverse;
  function Traverse(obj) {
    if (!(this instanceof Traverse)) return new Traverse(obj);
    this.value = obj;
  }
  Traverse.prototype.get = function(ps) {
    var node2 = this.value;
    for (var i = 0; i < ps.length; i++) {
      var key = ps[i];
      if (!Object.hasOwnProperty.call(node2, key)) {
        node2 = void 0;
        break;
      }
      node2 = node2[key];
    }
    return node2;
  };
  Traverse.prototype.set = function(ps, value) {
    var node2 = this.value;
    for (var i = 0; i < ps.length - 1; i++) {
      var key = ps[i];
      if (!Object.hasOwnProperty.call(node2, key)) node2[key] = {};
      node2 = node2[key];
    }
    node2[ps[i]] = value;
    return value;
  };
  Traverse.prototype.map = function(cb) {
    return walk(this.value, cb, true);
  };
  Traverse.prototype.forEach = function(cb) {
    this.value = walk(this.value, cb, false);
    return this.value;
  };
  Traverse.prototype.reduce = function(cb, init) {
    var skip = arguments.length === 1;
    var acc = skip ? this.value : init;
    this.forEach(function(x) {
      if (!this.isRoot || !skip) {
        acc = cb.call(this, acc, x);
      }
    });
    return acc;
  };
  Traverse.prototype.deepEqual = function(obj) {
    if (arguments.length !== 1) {
      throw new Error(
        "deepEqual requires exactly one object to compare against"
      );
    }
    var equal = true;
    var node2 = obj;
    this.forEach(function(y) {
      var notEqual = (function() {
        equal = false;
        return void 0;
      }).bind(this);
      if (!this.isRoot) {
        if (typeof node2 !== "object") return notEqual();
        node2 = node2[this.key];
      }
      var x = node2;
      this.post(function() {
        node2 = x;
      });
      var toS = function(o) {
        return Object.prototype.toString.call(o);
      };
      if (this.circular) {
        if (Traverse(obj).get(this.circular.path) !== x) notEqual();
      } else if (typeof x !== typeof y) {
        notEqual();
      } else if (x === null || y === null || x === void 0 || y === void 0) {
        if (x !== y) notEqual();
      } else if (x.__proto__ !== y.__proto__) {
        notEqual();
      } else if (x === y) ;
      else if (typeof x === "function") {
        if (x instanceof RegExp) {
          if (x.toString() != y.toString()) notEqual();
        } else if (x !== y) notEqual();
      } else if (typeof x === "object") {
        if (toS(y) === "[object Arguments]" || toS(x) === "[object Arguments]") {
          if (toS(x) !== toS(y)) {
            notEqual();
          }
        } else if (x instanceof Date || y instanceof Date) {
          if (!(x instanceof Date) || !(y instanceof Date) || x.getTime() !== y.getTime()) {
            notEqual();
          }
        } else {
          var kx = Object.keys(x);
          var ky = Object.keys(y);
          if (kx.length !== ky.length) return notEqual();
          for (var i = 0; i < kx.length; i++) {
            var k = kx[i];
            if (!Object.hasOwnProperty.call(y, k)) {
              notEqual();
            }
          }
        }
      }
    });
    return equal;
  };
  Traverse.prototype.paths = function() {
    var acc = [];
    this.forEach(function(x) {
      acc.push(this.path);
    });
    return acc;
  };
  Traverse.prototype.nodes = function() {
    var acc = [];
    this.forEach(function(x) {
      acc.push(this.node);
    });
    return acc;
  };
  Traverse.prototype.clone = function() {
    var parents = [], nodes = [];
    return (function clone(src) {
      for (var i = 0; i < parents.length; i++) {
        if (parents[i] === src) {
          return nodes[i];
        }
      }
      if (typeof src === "object" && src !== null) {
        var dst = copy(src);
        parents.push(src);
        nodes.push(dst);
        Object.keys(src).forEach(function(key) {
          dst[key] = clone(src[key]);
        });
        parents.pop();
        nodes.pop();
        return dst;
      } else {
        return src;
      }
    })(this.value);
  };
  function walk(root, cb, immutable) {
    var path2 = [];
    var parents = [];
    var alive = true;
    return (function walker(node_) {
      var node2 = immutable ? copy(node_) : node_;
      var modifiers = {};
      var state = {
        node: node2,
        node_,
        path: [].concat(path2),
        parent: parents.slice(-1)[0],
        key: path2.slice(-1)[0],
        isRoot: path2.length === 0,
        level: path2.length,
        circular: null,
        update: function(x) {
          if (!state.isRoot) {
            state.parent.node[state.key] = x;
          }
          state.node = x;
        },
        "delete": function() {
          delete state.parent.node[state.key];
        },
        remove: function() {
          if (Array.isArray(state.parent.node)) {
            state.parent.node.splice(state.key, 1);
          } else {
            delete state.parent.node[state.key];
          }
        },
        before: function(f) {
          modifiers.before = f;
        },
        after: function(f) {
          modifiers.after = f;
        },
        pre: function(f) {
          modifiers.pre = f;
        },
        post: function(f) {
          modifiers.post = f;
        },
        stop: function() {
          alive = false;
        }
      };
      if (!alive) return state;
      if (typeof node2 === "object" && node2 !== null) {
        state.isLeaf = Object.keys(node2).length == 0;
        for (var i = 0; i < parents.length; i++) {
          if (parents[i].node_ === node_) {
            state.circular = parents[i];
            break;
          }
        }
      } else {
        state.isLeaf = true;
      }
      state.notLeaf = !state.isLeaf;
      state.notRoot = !state.isRoot;
      var ret = cb.call(state, state.node);
      if (ret !== void 0 && state.update) state.update(ret);
      if (modifiers.before) modifiers.before.call(state, state.node);
      if (typeof state.node == "object" && state.node !== null && !state.circular) {
        parents.push(state);
        var keys = Object.keys(state.node);
        keys.forEach(function(key, i2) {
          path2.push(key);
          if (modifiers.pre) modifiers.pre.call(state, state.node[key], key);
          var child = walker(state.node[key]);
          if (immutable && Object.hasOwnProperty.call(state.node, key)) {
            state.node[key] = child.node;
          }
          child.isLast = i2 == keys.length - 1;
          child.isFirst = i2 == 0;
          if (modifiers.post) modifiers.post.call(state, child);
          path2.pop();
        });
        parents.pop();
      }
      if (modifiers.after) modifiers.after.call(state, state.node);
      return state;
    })(root).node;
  }
  Object.keys(Traverse.prototype).forEach(function(key) {
    Traverse[key] = function(obj) {
      var args = [].slice.call(arguments, 1);
      var t = Traverse(obj);
      return t[key].apply(t, args);
    };
  });
  function copy(src) {
    if (typeof src === "object" && src !== null) {
      var dst;
      if (Array.isArray(src)) {
        dst = [];
      } else if (src instanceof Date) {
        dst = new Date(src);
      } else if (src instanceof Boolean) {
        dst = new Boolean(src);
      } else if (src instanceof Number) {
        dst = new Number(src);
      } else if (src instanceof String) {
        dst = new String(src);
      } else {
        dst = Object.create(Object.getPrototypeOf(src));
      }
      Object.keys(src).forEach(function(key) {
        dst[key] = src[key];
      });
      return dst;
    } else return src;
  }
  return traverse;
}
var chainsaw;
var hasRequiredChainsaw;
function requireChainsaw() {
  if (hasRequiredChainsaw) return chainsaw;
  hasRequiredChainsaw = 1;
  var Traverse = requireTraverse();
  var EventEmitter = require$$1.EventEmitter;
  chainsaw = Chainsaw;
  function Chainsaw(builder2) {
    var saw = Chainsaw.saw(builder2, {});
    var r = builder2.call(saw.handlers, saw);
    if (r !== void 0) saw.handlers = r;
    saw.record();
    return saw.chain();
  }
  Chainsaw.light = function ChainsawLight(builder2) {
    var saw = Chainsaw.saw(builder2, {});
    var r = builder2.call(saw.handlers, saw);
    if (r !== void 0) saw.handlers = r;
    return saw.chain();
  };
  Chainsaw.saw = function(builder2, handlers) {
    var saw = new EventEmitter();
    saw.handlers = handlers;
    saw.actions = [];
    saw.chain = function() {
      var ch = Traverse(saw.handlers).map(function(node2) {
        if (this.isRoot) return node2;
        var ps = this.path;
        if (typeof node2 === "function") {
          this.update(function() {
            saw.actions.push({
              path: ps,
              args: [].slice.call(arguments)
            });
            return ch;
          });
        }
      });
      process.nextTick(function() {
        saw.emit("begin");
        saw.next();
      });
      return ch;
    };
    saw.pop = function() {
      return saw.actions.shift();
    };
    saw.next = function() {
      var action = saw.pop();
      if (!action) {
        saw.emit("end");
      } else if (!action.trap) {
        var node2 = saw.handlers;
        action.path.forEach(function(key) {
          node2 = node2[key];
        });
        node2.apply(saw.handlers, action.args);
      }
    };
    saw.nest = function(cb) {
      var args = [].slice.call(arguments, 1);
      var autonext = true;
      if (typeof cb === "boolean") {
        var autonext = cb;
        cb = args.shift();
      }
      var s = Chainsaw.saw(builder2, {});
      var r = builder2.call(s.handlers, s);
      if (r !== void 0) s.handlers = r;
      if ("undefined" !== typeof saw.step) {
        s.record();
      }
      cb.apply(s.chain(), args);
      if (autonext !== false) s.on("end", saw.next);
    };
    saw.record = function() {
      upgradeChainsaw(saw);
    };
    ["trap", "down", "jump"].forEach(function(method) {
      saw[method] = function() {
        throw new Error("To use the trap, down and jump features, please call record() first to start recording actions.");
      };
    });
    return saw;
  };
  function upgradeChainsaw(saw) {
    saw.step = 0;
    saw.pop = function() {
      return saw.actions[saw.step++];
    };
    saw.trap = function(name, cb) {
      var ps = Array.isArray(name) ? name : [name];
      saw.actions.push({
        path: ps,
        step: saw.step,
        cb,
        trap: true
      });
    };
    saw.down = function(name) {
      var ps = (Array.isArray(name) ? name : [name]).join("/");
      var i = saw.actions.slice(saw.step).map(function(x) {
        if (x.trap && x.step <= saw.step) return false;
        return x.path.join("/") == ps;
      }).indexOf(true);
      if (i >= 0) saw.step += i;
      else saw.step = saw.actions.length;
      var act = saw.actions[saw.step - 1];
      if (act && act.trap) {
        saw.step = act.step;
        act.cb();
      } else saw.next();
    };
    saw.jump = function(step) {
      saw.step = step;
      saw.next();
    };
  }
  return chainsaw;
}
var buffers;
var hasRequiredBuffers;
function requireBuffers() {
  if (hasRequiredBuffers) return buffers;
  hasRequiredBuffers = 1;
  buffers = Buffers;
  function Buffers(bufs) {
    if (!(this instanceof Buffers)) return new Buffers(bufs);
    this.buffers = bufs || [];
    this.length = this.buffers.reduce(function(size, buf) {
      return size + buf.length;
    }, 0);
  }
  Buffers.prototype.push = function() {
    for (var i = 0; i < arguments.length; i++) {
      if (!Buffer.isBuffer(arguments[i])) {
        throw new TypeError("Tried to push a non-buffer");
      }
    }
    for (var i = 0; i < arguments.length; i++) {
      var buf = arguments[i];
      this.buffers.push(buf);
      this.length += buf.length;
    }
    return this.length;
  };
  Buffers.prototype.unshift = function() {
    for (var i = 0; i < arguments.length; i++) {
      if (!Buffer.isBuffer(arguments[i])) {
        throw new TypeError("Tried to unshift a non-buffer");
      }
    }
    for (var i = 0; i < arguments.length; i++) {
      var buf = arguments[i];
      this.buffers.unshift(buf);
      this.length += buf.length;
    }
    return this.length;
  };
  Buffers.prototype.copy = function(dst, dStart, start, end) {
    return this.slice(start, end).copy(dst, dStart, 0, end - start);
  };
  Buffers.prototype.splice = function(i, howMany) {
    var buffers2 = this.buffers;
    var index = i >= 0 ? i : this.length - i;
    var reps = [].slice.call(arguments, 2);
    if (howMany === void 0) {
      howMany = this.length - index;
    } else if (howMany > this.length - index) {
      howMany = this.length - index;
    }
    for (var i = 0; i < reps.length; i++) {
      this.length += reps[i].length;
    }
    var removed = new Buffers();
    var startBytes = 0;
    for (var ii = 0; ii < buffers2.length && startBytes + buffers2[ii].length < index; ii++) {
      startBytes += buffers2[ii].length;
    }
    if (index - startBytes > 0) {
      var start = index - startBytes;
      if (start + howMany < buffers2[ii].length) {
        removed.push(buffers2[ii].slice(start, start + howMany));
        var orig = buffers2[ii];
        var buf0 = new Buffer(start);
        for (var i = 0; i < start; i++) {
          buf0[i] = orig[i];
        }
        var buf1 = new Buffer(orig.length - start - howMany);
        for (var i = start + howMany; i < orig.length; i++) {
          buf1[i - howMany - start] = orig[i];
        }
        if (reps.length > 0) {
          var reps_ = reps.slice();
          reps_.unshift(buf0);
          reps_.push(buf1);
          buffers2.splice.apply(buffers2, [ii, 1].concat(reps_));
          ii += reps_.length;
          reps = [];
        } else {
          buffers2.splice(ii, 1, buf0, buf1);
          ii += 2;
        }
      } else {
        removed.push(buffers2[ii].slice(start));
        buffers2[ii] = buffers2[ii].slice(0, start);
        ii++;
      }
    }
    if (reps.length > 0) {
      buffers2.splice.apply(buffers2, [ii, 0].concat(reps));
      ii += reps.length;
    }
    while (removed.length < howMany) {
      var buf = buffers2[ii];
      var len = buf.length;
      var take = Math.min(len, howMany - removed.length);
      if (take === len) {
        removed.push(buf);
        buffers2.splice(ii, 1);
      } else {
        removed.push(buf.slice(0, take));
        buffers2[ii] = buffers2[ii].slice(take);
      }
    }
    this.length -= removed.length;
    return removed;
  };
  Buffers.prototype.slice = function(i, j) {
    var buffers2 = this.buffers;
    if (j === void 0) j = this.length;
    if (i === void 0) i = 0;
    if (j > this.length) j = this.length;
    var startBytes = 0;
    for (var si = 0; si < buffers2.length && startBytes + buffers2[si].length <= i; si++) {
      startBytes += buffers2[si].length;
    }
    var target = new Buffer(j - i);
    var ti = 0;
    for (var ii = si; ti < j - i && ii < buffers2.length; ii++) {
      var len = buffers2[ii].length;
      var start = ti === 0 ? i - startBytes : 0;
      var end = ti + len >= j - i ? Math.min(start + (j - i) - ti, len) : len;
      buffers2[ii].copy(target, ti, start, end);
      ti += end - start;
    }
    return target;
  };
  Buffers.prototype.pos = function(i) {
    if (i < 0 || i >= this.length) throw new Error("oob");
    var l = i, bi = 0, bu = null;
    for (; ; ) {
      bu = this.buffers[bi];
      if (l < bu.length) {
        return { buf: bi, offset: l };
      } else {
        l -= bu.length;
      }
      bi++;
    }
  };
  Buffers.prototype.get = function get(i) {
    var pos = this.pos(i);
    return this.buffers[pos.buf].get(pos.offset);
  };
  Buffers.prototype.set = function set(i, b) {
    var pos = this.pos(i);
    return this.buffers[pos.buf].set(pos.offset, b);
  };
  Buffers.prototype.indexOf = function(needle, offset) {
    if ("string" === typeof needle) {
      needle = new Buffer(needle);
    } else if (needle instanceof Buffer) ;
    else {
      throw new Error("Invalid type for a search string");
    }
    if (!needle.length) {
      return 0;
    }
    if (!this.length) {
      return -1;
    }
    var i = 0, j = 0, match = 0, mstart, pos = 0;
    if (offset) {
      var p = this.pos(offset);
      i = p.buf;
      j = p.offset;
      pos = offset;
    }
    for (; ; ) {
      while (j >= this.buffers[i].length) {
        j = 0;
        i++;
        if (i >= this.buffers.length) {
          return -1;
        }
      }
      var char = this.buffers[i][j];
      if (char == needle[match]) {
        if (match == 0) {
          mstart = {
            i,
            j,
            pos
          };
        }
        match++;
        if (match == needle.length) {
          return mstart.pos;
        }
      } else if (match != 0) {
        i = mstart.i;
        j = mstart.j;
        pos = mstart.pos;
        match = 0;
      }
      j++;
      pos++;
    }
  };
  Buffers.prototype.toBuffer = function() {
    return this.slice();
  };
  Buffers.prototype.toString = function(encoding, start, end) {
    return this.slice(start, end).toString(encoding);
  };
  return buffers;
}
var vars;
var hasRequiredVars;
function requireVars() {
  if (hasRequiredVars) return vars;
  hasRequiredVars = 1;
  vars = function(store) {
    function getset(name, value) {
      var node2 = vars2.store;
      var keys = name.split(".");
      keys.slice(0, -1).forEach(function(k) {
        if (node2[k] === void 0) node2[k] = {};
        node2 = node2[k];
      });
      var key = keys[keys.length - 1];
      if (arguments.length == 1) {
        return node2[key];
      } else {
        return node2[key] = value;
      }
    }
    var vars2 = {
      get: function(name) {
        return getset(name);
      },
      set: function(name, value) {
        return getset(name, value);
      },
      store: store || {}
    };
    return vars2;
  };
  return vars;
}
var hasRequiredBinary;
function requireBinary() {
  if (hasRequiredBinary) return binary.exports;
  hasRequiredBinary = 1;
  (function(module2, exports2) {
    var Chainsaw = requireChainsaw();
    var EventEmitter = require$$1.EventEmitter;
    var Buffers = requireBuffers();
    var Vars = requireVars();
    var Stream = require$$0.Stream;
    exports2 = module2.exports = function(bufOrEm, eventName) {
      if (Buffer.isBuffer(bufOrEm)) {
        return exports2.parse(bufOrEm);
      }
      var s = exports2.stream();
      if (bufOrEm && bufOrEm.pipe) {
        bufOrEm.pipe(s);
      } else if (bufOrEm) {
        bufOrEm.on(eventName || "data", function(buf) {
          s.write(buf);
        });
        bufOrEm.on("end", function() {
          s.end();
        });
      }
      return s;
    };
    exports2.stream = function(input) {
      if (input) return exports2.apply(null, arguments);
      var pending = null;
      function getBytes(bytes, cb, skip) {
        pending = {
          bytes,
          skip,
          cb: function(buf) {
            pending = null;
            cb(buf);
          }
        };
        dispatch();
      }
      var offset = null;
      function dispatch() {
        if (!pending) {
          if (caughtEnd) done = true;
          return;
        }
        if (typeof pending === "function") {
          pending();
        } else {
          var bytes = offset + pending.bytes;
          if (buffers2.length >= bytes) {
            var buf;
            if (offset == null) {
              buf = buffers2.splice(0, bytes);
              if (!pending.skip) {
                buf = buf.slice();
              }
            } else {
              if (!pending.skip) {
                buf = buffers2.slice(offset, bytes);
              }
              offset = bytes;
            }
            if (pending.skip) {
              pending.cb();
            } else {
              pending.cb(buf);
            }
          }
        }
      }
      function builder2(saw) {
        function next() {
          if (!done) saw.next();
        }
        var self2 = words(function(bytes, cb) {
          return function(name) {
            getBytes(bytes, function(buf) {
              vars2.set(name, cb(buf));
              next();
            });
          };
        });
        self2.tap = function(cb) {
          saw.nest(cb, vars2.store);
        };
        self2.into = function(key, cb) {
          if (!vars2.get(key)) vars2.set(key, {});
          var parent = vars2;
          vars2 = Vars(parent.get(key));
          saw.nest(function() {
            cb.apply(this, arguments);
            this.tap(function() {
              vars2 = parent;
            });
          }, vars2.store);
        };
        self2.flush = function() {
          vars2.store = {};
          next();
        };
        self2.loop = function(cb) {
          var end = false;
          saw.nest(false, function loop() {
            this.vars = vars2.store;
            cb.call(this, function() {
              end = true;
              next();
            }, vars2.store);
            this.tap(function() {
              if (end) saw.next();
              else loop.call(this);
            }.bind(this));
          }, vars2.store);
        };
        self2.buffer = function(name, bytes) {
          if (typeof bytes === "string") {
            bytes = vars2.get(bytes);
          }
          getBytes(bytes, function(buf) {
            vars2.set(name, buf);
            next();
          });
        };
        self2.skip = function(bytes) {
          if (typeof bytes === "string") {
            bytes = vars2.get(bytes);
          }
          getBytes(bytes, function() {
            next();
          });
        };
        self2.scan = function find(name, search) {
          if (typeof search === "string") {
            search = new Buffer(search);
          } else if (!Buffer.isBuffer(search)) {
            throw new Error("search must be a Buffer or a string");
          }
          var taken = 0;
          pending = function() {
            var pos = buffers2.indexOf(search, offset + taken);
            var i = pos - offset - taken;
            if (pos !== -1) {
              pending = null;
              if (offset != null) {
                vars2.set(
                  name,
                  buffers2.slice(offset, offset + taken + i)
                );
                offset += taken + i + search.length;
              } else {
                vars2.set(
                  name,
                  buffers2.slice(0, taken + i)
                );
                buffers2.splice(0, taken + i + search.length);
              }
              next();
              dispatch();
            } else {
              i = Math.max(buffers2.length - search.length - offset - taken, 0);
            }
            taken += i;
          };
          dispatch();
        };
        self2.peek = function(cb) {
          offset = 0;
          saw.nest(function() {
            cb.call(this, vars2.store);
            this.tap(function() {
              offset = null;
            });
          });
        };
        return self2;
      }
      var stream = Chainsaw.light(builder2);
      stream.writable = true;
      var buffers2 = Buffers();
      stream.write = function(buf) {
        buffers2.push(buf);
        dispatch();
      };
      var vars2 = Vars();
      var done = false, caughtEnd = false;
      stream.end = function() {
        caughtEnd = true;
      };
      stream.pipe = Stream.prototype.pipe;
      Object.getOwnPropertyNames(EventEmitter.prototype).forEach(function(name) {
        stream[name] = EventEmitter.prototype[name];
      });
      return stream;
    };
    exports2.parse = function parse2(buffer) {
      var self2 = words(function(bytes, cb) {
        return function(name) {
          if (offset + bytes <= buffer.length) {
            var buf = buffer.slice(offset, offset + bytes);
            offset += bytes;
            vars2.set(name, cb(buf));
          } else {
            vars2.set(name, null);
          }
          return self2;
        };
      });
      var offset = 0;
      var vars2 = Vars();
      self2.vars = vars2.store;
      self2.tap = function(cb) {
        cb.call(self2, vars2.store);
        return self2;
      };
      self2.into = function(key, cb) {
        if (!vars2.get(key)) {
          vars2.set(key, {});
        }
        var parent = vars2;
        vars2 = Vars(parent.get(key));
        cb.call(self2, vars2.store);
        vars2 = parent;
        return self2;
      };
      self2.loop = function(cb) {
        var end = false;
        var ender = function() {
          end = true;
        };
        while (end === false) {
          cb.call(self2, ender, vars2.store);
        }
        return self2;
      };
      self2.buffer = function(name, size) {
        if (typeof size === "string") {
          size = vars2.get(size);
        }
        var buf = buffer.slice(offset, Math.min(buffer.length, offset + size));
        offset += size;
        vars2.set(name, buf);
        return self2;
      };
      self2.skip = function(bytes) {
        if (typeof bytes === "string") {
          bytes = vars2.get(bytes);
        }
        offset += bytes;
        return self2;
      };
      self2.scan = function(name, search) {
        if (typeof search === "string") {
          search = new Buffer(search);
        } else if (!Buffer.isBuffer(search)) {
          throw new Error("search must be a Buffer or a string");
        }
        vars2.set(name, null);
        for (var i = 0; i + offset <= buffer.length - search.length + 1; i++) {
          for (var j = 0; j < search.length && buffer[offset + i + j] === search[j]; j++) ;
          if (j === search.length) break;
        }
        vars2.set(name, buffer.slice(offset, offset + i));
        offset += i + search.length;
        return self2;
      };
      self2.peek = function(cb) {
        var was = offset;
        cb.call(self2, vars2.store);
        offset = was;
        return self2;
      };
      self2.flush = function() {
        vars2.store = {};
        return self2;
      };
      self2.eof = function() {
        return offset >= buffer.length;
      };
      return self2;
    };
    function decodeLEu(bytes) {
      var acc = 0;
      for (var i = 0; i < bytes.length; i++) {
        acc += Math.pow(256, i) * bytes[i];
      }
      return acc;
    }
    function decodeBEu(bytes) {
      var acc = 0;
      for (var i = 0; i < bytes.length; i++) {
        acc += Math.pow(256, bytes.length - i - 1) * bytes[i];
      }
      return acc;
    }
    function decodeBEs(bytes) {
      var val = decodeBEu(bytes);
      if ((bytes[0] & 128) == 128) {
        val -= Math.pow(256, bytes.length);
      }
      return val;
    }
    function decodeLEs(bytes) {
      var val = decodeLEu(bytes);
      if ((bytes[bytes.length - 1] & 128) == 128) {
        val -= Math.pow(256, bytes.length);
      }
      return val;
    }
    function words(decode) {
      var self2 = {};
      [1, 2, 4, 8].forEach(function(bytes) {
        var bits = bytes * 8;
        self2["word" + bits + "le"] = self2["word" + bits + "lu"] = decode(bytes, decodeLEu);
        self2["word" + bits + "ls"] = decode(bytes, decodeLEs);
        self2["word" + bits + "be"] = self2["word" + bits + "bu"] = decode(bytes, decodeBEu);
        self2["word" + bits + "bs"] = decode(bytes, decodeBEs);
      });
      self2.word8 = self2.word8u = self2.word8be;
      self2.word8s = self2.word8bs;
      return self2;
    }
  })(binary, binary.exports);
  return binary.exports;
}
var matcherStream;
var hasRequiredMatcherStream;
function requireMatcherStream() {
  if (hasRequiredMatcherStream) return matcherStream;
  hasRequiredMatcherStream = 1;
  var Transform = require$$0.Transform;
  var util = require$$1$1;
  function MatcherStream(patternDesc, matchFn) {
    if (!(this instanceof MatcherStream)) {
      return new MatcherStream();
    }
    Transform.call(this);
    var p = typeof patternDesc === "object" ? patternDesc.pattern : patternDesc;
    this.pattern = Buffer.isBuffer(p) ? p : Buffer.from(p);
    this.requiredLength = this.pattern.length;
    if (patternDesc.requiredExtraSize) this.requiredLength += patternDesc.requiredExtraSize;
    this.data = new Buffer("");
    this.bytesSoFar = 0;
    this.matchFn = matchFn;
  }
  util.inherits(MatcherStream, Transform);
  MatcherStream.prototype.checkDataChunk = function(ignoreMatchZero) {
    var enoughData = this.data.length >= this.requiredLength;
    if (!enoughData) {
      return;
    }
    var matchIndex = this.data.indexOf(this.pattern, ignoreMatchZero ? 1 : 0);
    if (matchIndex >= 0 && matchIndex + this.requiredLength > this.data.length) {
      if (matchIndex > 0) {
        var packet = this.data.slice(0, matchIndex);
        this.push(packet);
        this.bytesSoFar += matchIndex;
        this.data = this.data.slice(matchIndex);
      }
      return;
    }
    if (matchIndex === -1) {
      var packetLen = this.data.length - this.requiredLength + 1;
      var packet = this.data.slice(0, packetLen);
      this.push(packet);
      this.bytesSoFar += packetLen;
      this.data = this.data.slice(packetLen);
      return;
    }
    if (matchIndex > 0) {
      var packet = this.data.slice(0, matchIndex);
      this.data = this.data.slice(matchIndex);
      this.push(packet);
      this.bytesSoFar += matchIndex;
    }
    var finished = this.matchFn ? this.matchFn(this.data, this.bytesSoFar) : true;
    if (finished) {
      this.data = new Buffer("");
      return;
    }
    return true;
  };
  MatcherStream.prototype._transform = function(chunk, encoding, cb) {
    this.data = Buffer.concat([this.data, chunk]);
    var firstIteration = true;
    while (this.checkDataChunk(!firstIteration)) {
      firstIteration = false;
    }
    cb();
  };
  MatcherStream.prototype._flush = function(cb) {
    if (this.data.length > 0) {
      var firstIteration = true;
      while (this.checkDataChunk(!firstIteration)) {
        firstIteration = false;
      }
    }
    if (this.data.length > 0) {
      this.push(this.data);
      this.data = null;
    }
    cb();
  };
  matcherStream = MatcherStream;
  return matcherStream;
}
var entry;
var hasRequiredEntry;
function requireEntry() {
  if (hasRequiredEntry) return entry;
  hasRequiredEntry = 1;
  var stream = require$$0;
  var inherits = require$$1$1.inherits;
  function Entry() {
    if (!(this instanceof Entry)) {
      return new Entry();
    }
    stream.PassThrough.call(this);
    this.path = null;
    this.type = null;
    this.isDirectory = false;
  }
  inherits(Entry, stream.PassThrough);
  Entry.prototype.autodrain = function() {
    return this.pipe(new stream.Transform({ transform: function(d, e, cb) {
      cb();
    } }));
  };
  entry = Entry;
  return entry;
}
var unzipStream;
var hasRequiredUnzipStream;
function requireUnzipStream() {
  if (hasRequiredUnzipStream) return unzipStream;
  hasRequiredUnzipStream = 1;
  var binary2 = requireBinary();
  var stream = require$$0;
  var util = require$$1$1;
  var zlib = require$$3$1;
  var MatcherStream = requireMatcherStream();
  var Entry = requireEntry();
  const states = {
    STREAM_START: 0,
    START: 1,
    LOCAL_FILE_HEADER: 2,
    LOCAL_FILE_HEADER_SUFFIX: 3,
    FILE_DATA: 4,
    FILE_DATA_END: 5,
    DATA_DESCRIPTOR: 6,
    CENTRAL_DIRECTORY_FILE_HEADER: 7,
    CENTRAL_DIRECTORY_FILE_HEADER_SUFFIX: 8,
    CDIR64_END: 9,
    CDIR64_END_DATA_SECTOR: 10,
    CDIR64_LOCATOR: 11,
    CENTRAL_DIRECTORY_END: 12,
    CENTRAL_DIRECTORY_END_COMMENT: 13,
    TRAILING_JUNK: 14,
    ERROR: 99
  };
  const FOUR_GIGS = 4294967296;
  const SIG_LOCAL_FILE_HEADER = 67324752;
  const SIG_DATA_DESCRIPTOR = 134695760;
  const SIG_CDIR_RECORD = 33639248;
  const SIG_CDIR64_RECORD_END = 101075792;
  const SIG_CDIR64_LOCATOR_END = 117853008;
  const SIG_CDIR_RECORD_END = 101010256;
  function UnzipStream(options) {
    if (!(this instanceof UnzipStream)) {
      return new UnzipStream(options);
    }
    stream.Transform.call(this);
    this.options = options || {};
    this.data = new Buffer("");
    this.state = states.STREAM_START;
    this.skippedBytes = 0;
    this.parsedEntity = null;
    this.outStreamInfo = {};
  }
  util.inherits(UnzipStream, stream.Transform);
  UnzipStream.prototype.processDataChunk = function(chunk) {
    var requiredLength;
    switch (this.state) {
      case states.STREAM_START:
      case states.START:
        requiredLength = 4;
        break;
      case states.LOCAL_FILE_HEADER:
        requiredLength = 26;
        break;
      case states.LOCAL_FILE_HEADER_SUFFIX:
        requiredLength = this.parsedEntity.fileNameLength + this.parsedEntity.extraFieldLength;
        break;
      case states.DATA_DESCRIPTOR:
        requiredLength = 12;
        break;
      case states.CENTRAL_DIRECTORY_FILE_HEADER:
        requiredLength = 42;
        break;
      case states.CENTRAL_DIRECTORY_FILE_HEADER_SUFFIX:
        requiredLength = this.parsedEntity.fileNameLength + this.parsedEntity.extraFieldLength + this.parsedEntity.fileCommentLength;
        break;
      case states.CDIR64_END:
        requiredLength = 52;
        break;
      case states.CDIR64_END_DATA_SECTOR:
        requiredLength = this.parsedEntity.centralDirectoryRecordSize - 44;
        break;
      case states.CDIR64_LOCATOR:
        requiredLength = 16;
        break;
      case states.CENTRAL_DIRECTORY_END:
        requiredLength = 18;
        break;
      case states.CENTRAL_DIRECTORY_END_COMMENT:
        requiredLength = this.parsedEntity.commentLength;
        break;
      case states.FILE_DATA:
        return 0;
      case states.FILE_DATA_END:
        return 0;
      case states.TRAILING_JUNK:
        if (this.options.debug) console.log("found", chunk.length, "bytes of TRAILING_JUNK");
        return chunk.length;
      default:
        return chunk.length;
    }
    var chunkLength = chunk.length;
    if (chunkLength < requiredLength) {
      return 0;
    }
    switch (this.state) {
      case states.STREAM_START:
      case states.START:
        var signature = chunk.readUInt32LE(0);
        switch (signature) {
          case SIG_LOCAL_FILE_HEADER:
            this.state = states.LOCAL_FILE_HEADER;
            break;
          case SIG_CDIR_RECORD:
            this.state = states.CENTRAL_DIRECTORY_FILE_HEADER;
            break;
          case SIG_CDIR64_RECORD_END:
            this.state = states.CDIR64_END;
            break;
          case SIG_CDIR64_LOCATOR_END:
            this.state = states.CDIR64_LOCATOR;
            break;
          case SIG_CDIR_RECORD_END:
            this.state = states.CENTRAL_DIRECTORY_END;
            break;
          default:
            var isStreamStart = this.state === states.STREAM_START;
            if (!isStreamStart && (signature & 65535) !== 19280 && this.skippedBytes < 26) {
              var remaining = signature;
              var toSkip = 4;
              for (var i = 1; i < 4 && remaining !== 0; i++) {
                remaining = remaining >>> 8;
                if ((remaining & 255) === 80) {
                  toSkip = i;
                  break;
                }
              }
              this.skippedBytes += toSkip;
              if (this.options.debug) console.log("Skipped", this.skippedBytes, "bytes");
              return toSkip;
            }
            this.state = states.ERROR;
            var errMsg = isStreamStart ? "Not a valid zip file" : "Invalid signature in zip file";
            if (this.options.debug) {
              var sig = chunk.readUInt32LE(0);
              var asString;
              try {
                asString = chunk.slice(0, 4).toString();
              } catch (e) {
              }
              console.log("Unexpected signature in zip file: 0x" + sig.toString(16), '"' + asString + '", skipped', this.skippedBytes, "bytes");
            }
            this.emit("error", new Error(errMsg));
            return chunk.length;
        }
        this.skippedBytes = 0;
        return requiredLength;
      case states.LOCAL_FILE_HEADER:
        this.parsedEntity = this._readFile(chunk);
        this.state = states.LOCAL_FILE_HEADER_SUFFIX;
        return requiredLength;
      case states.LOCAL_FILE_HEADER_SUFFIX:
        var entry2 = new Entry();
        var isUtf8 = (this.parsedEntity.flags & 2048) !== 0;
        entry2.path = this._decodeString(chunk.slice(0, this.parsedEntity.fileNameLength), isUtf8);
        var extraDataBuffer = chunk.slice(this.parsedEntity.fileNameLength, this.parsedEntity.fileNameLength + this.parsedEntity.extraFieldLength);
        var extra = this._readExtraFields(extraDataBuffer);
        if (extra && extra.parsed) {
          if (extra.parsed.path && !isUtf8) {
            entry2.path = extra.parsed.path;
          }
          if (Number.isFinite(extra.parsed.uncompressedSize) && this.parsedEntity.uncompressedSize === FOUR_GIGS - 1) {
            this.parsedEntity.uncompressedSize = extra.parsed.uncompressedSize;
          }
          if (Number.isFinite(extra.parsed.compressedSize) && this.parsedEntity.compressedSize === FOUR_GIGS - 1) {
            this.parsedEntity.compressedSize = extra.parsed.compressedSize;
          }
        }
        this.parsedEntity.extra = extra.parsed || {};
        if (this.options.debug) {
          const debugObj = Object.assign({}, this.parsedEntity, {
            path: entry2.path,
            flags: "0x" + this.parsedEntity.flags.toString(16),
            extraFields: extra && extra.debug
          });
          console.log("decoded LOCAL_FILE_HEADER:", JSON.stringify(debugObj, null, 2));
        }
        this._prepareOutStream(this.parsedEntity, entry2);
        this.emit("entry", entry2);
        this.state = states.FILE_DATA;
        return requiredLength;
      case states.CENTRAL_DIRECTORY_FILE_HEADER:
        this.parsedEntity = this._readCentralDirectoryEntry(chunk);
        this.state = states.CENTRAL_DIRECTORY_FILE_HEADER_SUFFIX;
        return requiredLength;
      case states.CENTRAL_DIRECTORY_FILE_HEADER_SUFFIX:
        var isUtf8 = (this.parsedEntity.flags & 2048) !== 0;
        var path2 = this._decodeString(chunk.slice(0, this.parsedEntity.fileNameLength), isUtf8);
        var extraDataBuffer = chunk.slice(this.parsedEntity.fileNameLength, this.parsedEntity.fileNameLength + this.parsedEntity.extraFieldLength);
        var extra = this._readExtraFields(extraDataBuffer);
        if (extra && extra.parsed && extra.parsed.path && !isUtf8) {
          path2 = extra.parsed.path;
        }
        this.parsedEntity.extra = extra.parsed;
        var isUnix = (this.parsedEntity.versionMadeBy & 65280) >> 8 === 3;
        var unixAttrs, isSymlink;
        if (isUnix) {
          unixAttrs = this.parsedEntity.externalFileAttributes >>> 16;
          var fileType = unixAttrs >>> 12;
          isSymlink = (fileType & 10) === 10;
        }
        if (this.options.debug) {
          const debugObj = Object.assign({}, this.parsedEntity, {
            path: path2,
            flags: "0x" + this.parsedEntity.flags.toString(16),
            unixAttrs: unixAttrs && "0" + unixAttrs.toString(8),
            isSymlink,
            extraFields: extra.debug
          });
          console.log("decoded CENTRAL_DIRECTORY_FILE_HEADER:", JSON.stringify(debugObj, null, 2));
        }
        this.state = states.START;
        return requiredLength;
      case states.CDIR64_END:
        this.parsedEntity = this._readEndOfCentralDirectory64(chunk);
        if (this.options.debug) {
          console.log("decoded CDIR64_END_RECORD:", this.parsedEntity);
        }
        this.state = states.CDIR64_END_DATA_SECTOR;
        return requiredLength;
      case states.CDIR64_END_DATA_SECTOR:
        this.state = states.START;
        return requiredLength;
      case states.CDIR64_LOCATOR:
        this.state = states.START;
        return requiredLength;
      case states.CENTRAL_DIRECTORY_END:
        this.parsedEntity = this._readEndOfCentralDirectory(chunk);
        if (this.options.debug) {
          console.log("decoded CENTRAL_DIRECTORY_END:", this.parsedEntity);
        }
        this.state = states.CENTRAL_DIRECTORY_END_COMMENT;
        return requiredLength;
      case states.CENTRAL_DIRECTORY_END_COMMENT:
        if (this.options.debug) {
          console.log("decoded CENTRAL_DIRECTORY_END_COMMENT:", chunk.slice(0, requiredLength).toString());
        }
        this.state = states.TRAILING_JUNK;
        return requiredLength;
      case states.ERROR:
        return chunk.length;
      // discard
      default:
        console.log("didn't handle state #", this.state, "discarding");
        return chunk.length;
    }
  };
  UnzipStream.prototype._prepareOutStream = function(vars2, entry2) {
    var self2 = this;
    var isDirectory = vars2.uncompressedSize === 0 && /[\/\\]$/.test(entry2.path);
    entry2.path = entry2.path.replace(/(?<=^|[/\\]+)[.][.]+(?=[/\\]+|$)/g, ".");
    entry2.type = isDirectory ? "Directory" : "File";
    entry2.isDirectory = isDirectory;
    var fileSizeKnown = !(vars2.flags & 8);
    if (fileSizeKnown) {
      entry2.size = vars2.uncompressedSize;
    }
    var isVersionSupported = vars2.versionsNeededToExtract <= 45;
    this.outStreamInfo = {
      stream: null,
      limit: fileSizeKnown ? vars2.compressedSize : -1,
      written: 0
    };
    if (!fileSizeKnown) {
      var pattern = new Buffer(4);
      pattern.writeUInt32LE(SIG_DATA_DESCRIPTOR, 0);
      var zip64Mode = vars2.extra.zip64Mode;
      var extraSize = zip64Mode ? 20 : 12;
      var searchPattern = {
        pattern,
        requiredExtraSize: extraSize
      };
      var matcherStream2 = new MatcherStream(searchPattern, function(matchedChunk, sizeSoFar) {
        var vars3 = self2._readDataDescriptor(matchedChunk, zip64Mode);
        var compressedSizeMatches = vars3.compressedSize === sizeSoFar;
        if (!zip64Mode && !compressedSizeMatches && sizeSoFar >= FOUR_GIGS) {
          var overflown = sizeSoFar - FOUR_GIGS;
          while (overflown >= 0) {
            compressedSizeMatches = vars3.compressedSize === overflown;
            if (compressedSizeMatches) break;
            overflown -= FOUR_GIGS;
          }
        }
        if (!compressedSizeMatches) {
          return;
        }
        self2.state = states.FILE_DATA_END;
        var sliceOffset = zip64Mode ? 24 : 16;
        if (self2.data.length > 0) {
          self2.data = Buffer.concat([matchedChunk.slice(sliceOffset), self2.data]);
        } else {
          self2.data = matchedChunk.slice(sliceOffset);
        }
        return true;
      });
      this.outStreamInfo.stream = matcherStream2;
    } else {
      this.outStreamInfo.stream = new stream.PassThrough();
    }
    var isEncrypted = vars2.flags & 1 || vars2.flags & 64;
    if (isEncrypted || !isVersionSupported) {
      var message = isEncrypted ? "Encrypted files are not supported!" : "Zip version " + Math.floor(vars2.versionsNeededToExtract / 10) + "." + vars2.versionsNeededToExtract % 10 + " is not supported";
      entry2.skip = true;
      setImmediate(() => {
        self2.emit("error", new Error(message));
      });
      this.outStreamInfo.stream.pipe(new Entry().autodrain());
      return;
    }
    var isCompressed = vars2.compressionMethod > 0;
    if (isCompressed) {
      var inflater = zlib.createInflateRaw();
      inflater.on("error", function(err) {
        self2.state = states.ERROR;
        self2.emit("error", err);
      });
      this.outStreamInfo.stream.pipe(inflater).pipe(entry2);
    } else {
      this.outStreamInfo.stream.pipe(entry2);
    }
    if (this._drainAllEntries) {
      entry2.autodrain();
    }
  };
  UnzipStream.prototype._readFile = function(data) {
    var vars2 = binary2.parse(data).word16lu("versionsNeededToExtract").word16lu("flags").word16lu("compressionMethod").word16lu("lastModifiedTime").word16lu("lastModifiedDate").word32lu("crc32").word32lu("compressedSize").word32lu("uncompressedSize").word16lu("fileNameLength").word16lu("extraFieldLength").vars;
    return vars2;
  };
  UnzipStream.prototype._readExtraFields = function(data) {
    var extra = {};
    var result = { parsed: extra };
    if (this.options.debug) {
      result.debug = [];
    }
    var index = 0;
    while (index < data.length) {
      var vars2 = binary2.parse(data).skip(index).word16lu("extraId").word16lu("extraSize").vars;
      index += 4;
      var fieldType = void 0;
      switch (vars2.extraId) {
        case 1:
          fieldType = "Zip64 extended information extra field";
          var z64vars = binary2.parse(data.slice(index, index + vars2.extraSize)).word64lu("uncompressedSize").word64lu("compressedSize").word64lu("offsetToLocalHeader").word32lu("diskStartNumber").vars;
          if (z64vars.uncompressedSize !== null) {
            extra.uncompressedSize = z64vars.uncompressedSize;
          }
          if (z64vars.compressedSize !== null) {
            extra.compressedSize = z64vars.compressedSize;
          }
          extra.zip64Mode = true;
          break;
        case 10:
          fieldType = "NTFS extra field";
          break;
        case 21589:
          fieldType = "extended timestamp";
          var timestampFields = data.readUInt8(index);
          var offset = 1;
          if (vars2.extraSize >= offset + 4 && timestampFields & 1) {
            extra.mtime = new Date(data.readUInt32LE(index + offset) * 1e3);
            offset += 4;
          }
          if (vars2.extraSize >= offset + 4 && timestampFields & 2) {
            extra.atime = new Date(data.readUInt32LE(index + offset) * 1e3);
            offset += 4;
          }
          if (vars2.extraSize >= offset + 4 && timestampFields & 4) {
            extra.ctime = new Date(data.readUInt32LE(index + offset) * 1e3);
          }
          break;
        case 28789:
          fieldType = "Info-ZIP Unicode Path Extra Field";
          var fieldVer = data.readUInt8(index);
          if (fieldVer === 1) {
            var offset = 1;
            data.readUInt32LE(index + offset);
            offset += 4;
            var pathBuffer = data.slice(index + offset);
            extra.path = pathBuffer.toString();
          }
          break;
        case 13:
        case 22613:
          fieldType = vars2.extraId === 13 ? "PKWARE Unix" : "Info-ZIP UNIX (type 1)";
          var offset = 0;
          if (vars2.extraSize >= 8) {
            var atime = new Date(data.readUInt32LE(index + offset) * 1e3);
            offset += 4;
            var mtime = new Date(data.readUInt32LE(index + offset) * 1e3);
            offset += 4;
            extra.atime = atime;
            extra.mtime = mtime;
            if (vars2.extraSize >= 12) {
              var uid = data.readUInt16LE(index + offset);
              offset += 2;
              var gid = data.readUInt16LE(index + offset);
              offset += 2;
              extra.uid = uid;
              extra.gid = gid;
            }
          }
          break;
        case 30805:
          fieldType = "Info-ZIP UNIX (type 2)";
          var offset = 0;
          if (vars2.extraSize >= 4) {
            var uid = data.readUInt16LE(index + offset);
            offset += 2;
            var gid = data.readUInt16LE(index + offset);
            offset += 2;
            extra.uid = uid;
            extra.gid = gid;
          }
          break;
        case 30837:
          fieldType = "Info-ZIP New Unix";
          var offset = 0;
          var extraVer = data.readUInt8(index);
          offset += 1;
          if (extraVer === 1) {
            var uidSize = data.readUInt8(index + offset);
            offset += 1;
            if (uidSize <= 6) {
              extra.uid = data.readUIntLE(index + offset, uidSize);
            }
            offset += uidSize;
            var gidSize = data.readUInt8(index + offset);
            offset += 1;
            if (gidSize <= 6) {
              extra.gid = data.readUIntLE(index + offset, gidSize);
            }
          }
          break;
        case 30062:
          fieldType = "ASi Unix";
          var offset = 0;
          if (vars2.extraSize >= 14) {
            data.readUInt32LE(index + offset);
            offset += 4;
            var mode = data.readUInt16LE(index + offset);
            offset += 2;
            data.readUInt32LE(index + offset);
            offset += 4;
            var uid = data.readUInt16LE(index + offset);
            offset += 2;
            var gid = data.readUInt16LE(index + offset);
            offset += 2;
            extra.mode = mode;
            extra.uid = uid;
            extra.gid = gid;
            if (vars2.extraSize > 14) {
              var start = index + offset;
              var end = index + vars2.extraSize - 14;
              var symlinkName = this._decodeString(data.slice(start, end));
              extra.symlink = symlinkName;
            }
          }
          break;
      }
      if (this.options.debug) {
        result.debug.push({
          extraId: "0x" + vars2.extraId.toString(16),
          description: fieldType,
          data: data.slice(index, index + vars2.extraSize).inspect()
        });
      }
      index += vars2.extraSize;
    }
    return result;
  };
  UnzipStream.prototype._readDataDescriptor = function(data, zip64Mode) {
    if (zip64Mode) {
      var vars2 = binary2.parse(data).word32lu("dataDescriptorSignature").word32lu("crc32").word64lu("compressedSize").word64lu("uncompressedSize").vars;
      return vars2;
    }
    var vars2 = binary2.parse(data).word32lu("dataDescriptorSignature").word32lu("crc32").word32lu("compressedSize").word32lu("uncompressedSize").vars;
    return vars2;
  };
  UnzipStream.prototype._readCentralDirectoryEntry = function(data) {
    var vars2 = binary2.parse(data).word16lu("versionMadeBy").word16lu("versionsNeededToExtract").word16lu("flags").word16lu("compressionMethod").word16lu("lastModifiedTime").word16lu("lastModifiedDate").word32lu("crc32").word32lu("compressedSize").word32lu("uncompressedSize").word16lu("fileNameLength").word16lu("extraFieldLength").word16lu("fileCommentLength").word16lu("diskNumber").word16lu("internalFileAttributes").word32lu("externalFileAttributes").word32lu("offsetToLocalFileHeader").vars;
    return vars2;
  };
  UnzipStream.prototype._readEndOfCentralDirectory64 = function(data) {
    var vars2 = binary2.parse(data).word64lu("centralDirectoryRecordSize").word16lu("versionMadeBy").word16lu("versionsNeededToExtract").word32lu("diskNumber").word32lu("diskNumberWithCentralDirectoryStart").word64lu("centralDirectoryEntries").word64lu("totalCentralDirectoryEntries").word64lu("sizeOfCentralDirectory").word64lu("offsetToStartOfCentralDirectory").vars;
    return vars2;
  };
  UnzipStream.prototype._readEndOfCentralDirectory = function(data) {
    var vars2 = binary2.parse(data).word16lu("diskNumber").word16lu("diskStart").word16lu("centralDirectoryEntries").word16lu("totalCentralDirectoryEntries").word32lu("sizeOfCentralDirectory").word32lu("offsetToStartOfCentralDirectory").word16lu("commentLength").vars;
    return vars2;
  };
  const cp437 = "\0☺☻♥♦♣♠•◘○◙♂♀♪♫☼►◄↕‼¶§▬↨↑↓→←∟↔▲▼ !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~⌂ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜ¢£¥₧ƒáíóúñÑªº¿⌐¬½¼¡«»░▒▓│┤╡╢╖╕╣║╗╝╜╛┐└┴┬├─┼╞╟╚╔╩╦╠═╬╧╨╤╥╙╘╒╓╫╪┘┌█▄▌▐▀αßΓπΣσµτΦΘΩδ∞φε∩≡±≥≤⌠⌡÷≈°∙·√ⁿ²■ ";
  UnzipStream.prototype._decodeString = function(buffer, isUtf8) {
    if (isUtf8) {
      return buffer.toString("utf8");
    }
    if (this.options.decodeString) {
      return this.options.decodeString(buffer);
    }
    let result = "";
    for (var i = 0; i < buffer.length; i++) {
      result += cp437[buffer[i]];
    }
    return result;
  };
  UnzipStream.prototype._parseOrOutput = function(encoding, cb) {
    var consume;
    while ((consume = this.processDataChunk(this.data)) > 0) {
      this.data = this.data.slice(consume);
      if (this.data.length === 0) break;
    }
    if (this.state === states.FILE_DATA) {
      if (this.outStreamInfo.limit >= 0) {
        var remaining = this.outStreamInfo.limit - this.outStreamInfo.written;
        var packet;
        if (remaining < this.data.length) {
          packet = this.data.slice(0, remaining);
          this.data = this.data.slice(remaining);
        } else {
          packet = this.data;
          this.data = new Buffer("");
        }
        this.outStreamInfo.written += packet.length;
        if (this.outStreamInfo.limit === this.outStreamInfo.written) {
          this.state = states.START;
          this.outStreamInfo.stream.end(packet, encoding, cb);
        } else {
          this.outStreamInfo.stream.write(packet, encoding, cb);
        }
      } else {
        var packet = this.data;
        this.data = new Buffer("");
        this.outStreamInfo.written += packet.length;
        var outputStream = this.outStreamInfo.stream;
        outputStream.write(packet, encoding, () => {
          if (this.state === states.FILE_DATA_END) {
            this.state = states.START;
            return outputStream.end(cb);
          }
          cb();
        });
      }
      return;
    }
    cb();
  };
  UnzipStream.prototype.drainAll = function() {
    this._drainAllEntries = true;
  };
  UnzipStream.prototype._transform = function(chunk, encoding, cb) {
    var self2 = this;
    if (self2.data.length > 0) {
      self2.data = Buffer.concat([self2.data, chunk]);
    } else {
      self2.data = chunk;
    }
    var startDataLength = self2.data.length;
    var done = function() {
      if (self2.data.length > 0 && self2.data.length < startDataLength) {
        startDataLength = self2.data.length;
        self2._parseOrOutput(encoding, done);
        return;
      }
      cb();
    };
    self2._parseOrOutput(encoding, done);
  };
  UnzipStream.prototype._flush = function(cb) {
    var self2 = this;
    if (self2.data.length > 0) {
      self2._parseOrOutput("buffer", function() {
        if (self2.data.length > 0) return setImmediate(function() {
          self2._flush(cb);
        });
        cb();
      });
      return;
    }
    if (self2.state === states.FILE_DATA) {
      return cb(new Error("Stream finished in an invalid state, uncompression failed"));
    }
    setImmediate(cb);
  };
  unzipStream = UnzipStream;
  return unzipStream;
}
var parserStream;
var hasRequiredParserStream;
function requireParserStream() {
  if (hasRequiredParserStream) return parserStream;
  hasRequiredParserStream = 1;
  var Transform = require$$0.Transform;
  var util = require$$1$1;
  var UnzipStream = requireUnzipStream();
  function ParserStream(opts) {
    if (!(this instanceof ParserStream)) {
      return new ParserStream(opts);
    }
    Transform.call(this, { readableObjectMode: true });
    this.opts = opts || {};
    this.unzipStream = new UnzipStream(this.opts);
    var self2 = this;
    this.unzipStream.on("entry", function(entry2) {
      self2.push(entry2);
    });
    this.unzipStream.on("error", function(error) {
      self2.emit("error", error);
    });
  }
  util.inherits(ParserStream, Transform);
  ParserStream.prototype._transform = function(chunk, encoding, cb) {
    this.unzipStream.write(chunk, encoding, cb);
  };
  ParserStream.prototype._flush = function(cb) {
    var self2 = this;
    this.unzipStream.end(function() {
      process.nextTick(function() {
        self2.emit("close");
      });
      cb();
    });
  };
  ParserStream.prototype.on = function(eventName, fn) {
    if (eventName === "entry") {
      return Transform.prototype.on.call(this, "data", fn);
    }
    return Transform.prototype.on.call(this, eventName, fn);
  };
  ParserStream.prototype.drainAll = function() {
    this.unzipStream.drainAll();
    return this.pipe(new Transform({ objectMode: true, transform: function(d, e, cb) {
      cb();
    } }));
  };
  parserStream = ParserStream;
  return parserStream;
}
var mkdirp;
var hasRequiredMkdirp;
function requireMkdirp() {
  if (hasRequiredMkdirp) return mkdirp;
  hasRequiredMkdirp = 1;
  var path$1 = path;
  var fs$1 = fs;
  var _0777 = parseInt("0777", 8);
  mkdirp = mkdirP.mkdirp = mkdirP.mkdirP = mkdirP;
  function mkdirP(p, opts, f, made) {
    if (typeof opts === "function") {
      f = opts;
      opts = {};
    } else if (!opts || typeof opts !== "object") {
      opts = { mode: opts };
    }
    var mode = opts.mode;
    var xfs = opts.fs || fs$1;
    if (mode === void 0) {
      mode = _0777;
    }
    if (!made) made = null;
    var cb = f || /* istanbul ignore next */
    function() {
    };
    p = path$1.resolve(p);
    xfs.mkdir(p, mode, function(er) {
      if (!er) {
        made = made || p;
        return cb(null, made);
      }
      switch (er.code) {
        case "ENOENT":
          if (path$1.dirname(p) === p) return cb(er);
          mkdirP(path$1.dirname(p), opts, function(er2, made2) {
            if (er2) cb(er2, made2);
            else mkdirP(p, opts, cb, made2);
          });
          break;
        // In the case of any other error, just see if there's a dir
        // there already.  If so, then hooray!  If not, then something
        // is borked.
        default:
          xfs.stat(p, function(er2, stat) {
            if (er2 || !stat.isDirectory()) cb(er, made);
            else cb(null, made);
          });
          break;
      }
    });
  }
  mkdirP.sync = function sync(p, opts, made) {
    if (!opts || typeof opts !== "object") {
      opts = { mode: opts };
    }
    var mode = opts.mode;
    var xfs = opts.fs || fs$1;
    if (mode === void 0) {
      mode = _0777;
    }
    if (!made) made = null;
    p = path$1.resolve(p);
    try {
      xfs.mkdirSync(p, mode);
      made = made || p;
    } catch (err0) {
      switch (err0.code) {
        case "ENOENT":
          made = sync(path$1.dirname(p), opts, made);
          sync(p, opts, made);
          break;
        // In the case of any other error, just see if there's a dir
        // there already.  If so, then hooray!  If not, then something
        // is borked.
        default:
          var stat;
          try {
            stat = xfs.statSync(p);
          } catch (err1) {
            throw err0;
          }
          if (!stat.isDirectory()) throw err0;
          break;
      }
    }
    return made;
  };
  return mkdirp;
}
var extract;
var hasRequiredExtract;
function requireExtract() {
  if (hasRequiredExtract) return extract;
  hasRequiredExtract = 1;
  var fs$1 = fs;
  var path$1 = path;
  var util = require$$1$1;
  var mkdirp2 = requireMkdirp();
  var Transform = require$$0.Transform;
  var UnzipStream = requireUnzipStream();
  function Extract(opts) {
    if (!(this instanceof Extract))
      return new Extract(opts);
    Transform.call(this);
    this.opts = opts || {};
    this.unzipStream = new UnzipStream(this.opts);
    this.unfinishedEntries = 0;
    this.afterFlushWait = false;
    this.createdDirectories = {};
    var self2 = this;
    this.unzipStream.on("entry", this._processEntry.bind(this));
    this.unzipStream.on("error", function(error) {
      self2.emit("error", error);
    });
  }
  util.inherits(Extract, Transform);
  Extract.prototype._transform = function(chunk, encoding, cb) {
    this.unzipStream.write(chunk, encoding, cb);
  };
  Extract.prototype._flush = function(cb) {
    var self2 = this;
    var allDone = function() {
      process.nextTick(function() {
        self2.emit("close");
      });
      cb();
    };
    this.unzipStream.end(function() {
      if (self2.unfinishedEntries > 0) {
        self2.afterFlushWait = true;
        return self2.on("await-finished", allDone);
      }
      allDone();
    });
  };
  Extract.prototype._processEntry = function(entry2) {
    var self2 = this;
    var destPath = path$1.join(this.opts.path, entry2.path);
    var directory = entry2.isDirectory ? destPath : path$1.dirname(destPath);
    this.unfinishedEntries++;
    var writeFileFn = function() {
      var pipedStream = fs$1.createWriteStream(destPath);
      pipedStream.on("close", function() {
        self2.unfinishedEntries--;
        self2._notifyAwaiter();
      });
      pipedStream.on("error", function(error) {
        self2.emit("error", error);
      });
      entry2.pipe(pipedStream);
    };
    if (this.createdDirectories[directory] || directory === ".") {
      return writeFileFn();
    }
    mkdirp2(directory, function(err) {
      if (err) return self2.emit("error", err);
      self2.createdDirectories[directory] = true;
      if (entry2.isDirectory) {
        self2.unfinishedEntries--;
        self2._notifyAwaiter();
        return;
      }
      writeFileFn();
    });
  };
  Extract.prototype._notifyAwaiter = function() {
    if (this.afterFlushWait && this.unfinishedEntries === 0) {
      this.emit("await-finished");
      this.afterFlushWait = false;
    }
  };
  extract = Extract;
  return extract;
}
var hasRequiredUnzip;
function requireUnzip() {
  if (hasRequiredUnzip) return unzip;
  hasRequiredUnzip = 1;
  unzip.Parse = requireParserStream();
  unzip.Extract = requireExtract();
  return unzip;
}
var unzipExports = requireUnzip();
var define_process_env_default$4 = {};
let currentConfig;
const terminalName = "daffodil-debugger";
function getCurrentConfig() {
  return currentConfig;
}
function setCurrentConfig(config) {
  currentConfig = config;
  return config;
}
function runCommand(command, params) {
  const vscodeError = (err) => {
    vscode__namespace.window.showInformationMessage(err);
  };
  if (!params)
    vscode__namespace.commands.executeCommand(command).then(void 0, vscodeError);
  else
    vscode__namespace.commands.executeCommand(command, params).then(void 0, vscodeError);
}
async function onDebugStartDisplay(viewsToCheck) {
  let config = getCurrentConfig();
  viewsToCheck.forEach(async (viewToCheck) => {
    switch (viewToCheck) {
      case "data-editor":
        if (config.openDataEditor) {
          runCommand("extension.data.edit", config.data);
        }
        break;
      case "infoset-view":
        if (config.openInfosetView) {
          runCommand("infoset.display");
        }
        break;
      case "infoset-diff-view":
        if (config.openInfosetDiffView) {
          runCommand("infoset.diff");
        }
        break;
    }
  });
}
function checkInfosetFileExtension(infosetOutput, infosetFormat) {
  if (!infosetOutput.path.endsWith(`.${infosetFormat}`)) {
    vscode__namespace.window.showWarningMessage(
      `The output path for the file extension doesn't end with the infoset output format type. The file extension will be updated to end with .${infosetFormat}`
    );
    let fileExtensionSearchResult = new RegExp("(\\.).*$").exec(infosetOutput.path)?.filter((fileExt) => fileExt !== ".")[0];
    infosetOutput.path = fileExtensionSearchResult !== void 0 ? infosetOutput.path.replace(
      fileExtensionSearchResult,
      `.${infosetFormat}`
    ) : infosetOutput.path = `${infosetOutput.path}.${infosetFormat}`;
  }
}
function checkSettingValue(target, defaults2) {
  if (typeof defaults2 !== "object" || defaults2 === null || Array.isArray(defaults2)) {
    return target === void 0 ? defaults2 : target;
  }
  if (typeof target !== "object" || target === null) {
    return defaults2;
  }
  const result = {};
  for (const key of Object.keys(defaults2)) {
    result[key] = checkSettingValue(
      target[key],
      defaults2[key]
    );
  }
  for (const key of Object.keys(target)) {
    if (!(key in result)) {
      result[key] = target[key];
    }
  }
  return result;
}
function getConfig(jsonArgs) {
  const launchConfigArgs = JSON.parse(
    JSON.stringify(jsonArgs)
  );
  const defaultConf2 = vscode__namespace.workspace.getConfiguration();
  const defaultValues = {
    schema: defaultConf2.get("schema", {
      path: "${command:AskForSchemaName}",
      rootName: null,
      rootNamespace: null
    }),
    data: defaultConf2.get("data", "${command:AskForDataName}"),
    debugServer: defaultConf2.get("debugServer", 4711),
    infosetFormat: "xml",
    infosetOutput: defaultConf2.get("infosetOutput", {
      type: "file",
      path: "${workspaceFolder}/target/infoset.xml"
    }),
    tdmlConfig: {
      ...{
        action: "generate",
        name: "Default Test Case",
        path: "${command:AskForValidatedTDMLPath}"
      },
      ...defaultConf2.get("tdmlConfig") || {}
    },
    stopOnEntry: defaultConf2.get("stopOnEntry", true),
    useExistingServer: defaultConf2.get("useExistingServer", false),
    trace: defaultConf2.get("trace", true),
    openDataEditor: defaultConf2.get("openDataEditor", false),
    openInfosetView: defaultConf2.get("openInfosetView", false),
    openInfosetDiffView: defaultConf2.get("openInfosetDiffView", false),
    daffodilDebugClasspath: defaultConf2.get("daffodilDebugClasspath", []),
    dataEditor: defaultConf2.get("dataEditor", {
      port: 9e3,
      logging: {
        level: "info",
        file: "${workspaceFolder}/dataEditor-${omegaEditPort}.log"
      }
    }),
    dfdlDebugger: defaultConf2.get("dfdlDebugger", {
      daffodilVersion: "3.11.0",
      timeout: "10s",
      logging: {
        level: "INFO",
        file: "${workspaceFolder}/daffodil-debugger.log"
      }
    })
  };
  for (const [key, defaults2] of Object.entries(defaultValues)) {
    launchConfigArgs[key] = checkSettingValue(launchConfigArgs[key], defaults2);
  }
  if (launchConfigArgs.infosetOutput?.type == "file") {
    checkInfosetFileExtension(
      launchConfigArgs.infosetOutput,
      launchConfigArgs.infosetFormat
    );
  }
  const args = jsonArgs;
  if (args.tdmlConfig?.action === "execute" && args.tdmlConfig?.name === void 0) {
    launchConfigArgs.tdmlConfig.name = void 0;
  }
  return JSON.parse(JSON.stringify(launchConfigArgs));
}
async function displayTerminalExitStatus(terminal) {
  vscode__namespace.window.onDidCloseTerminal((t) => {
    if (t.name === terminal.name && t.processId === terminal.processId) {
      t.show();
      vscode__namespace.window.showInformationMessage(
        `Terminal exited with status code: ${t.exitStatus?.code}`
      );
    }
  });
}
function osCheck(winOption, macLinOption) {
  return os__namespace.platform().toLowerCase().startsWith("win") ? winOption : macLinOption;
}
const delay = (ms) => new Promise((res) => setTimeout(res, ms));
const getTerminal = (hideTerminal, env, createTerminal) => {
  if (!createTerminal) {
    vscode__namespace.window.terminals.forEach((terminal2) => {
      if (terminal2.name.includes(terminalName)) terminal2.dispose();
    });
  }
  const terminal = vscode__namespace.window.createTerminal({
    name: terminalName,
    hideFromUser: hideTerminal,
    // Need to specify 'cmd' for windows as by default it will use powershell which causes issues with the envionment varaibles
    shellPath: osCheck("cmd", void 0)
  });
  for (var key in env) {
    if (key !== null && key !== void 0) {
      let workspaceFolder = vscode__namespace.workspace.workspaceFolders ? vscode__namespace.workspace.workspaceFolders[0].uri.fsPath : "";
      let exportVar = `${osCheck("set", "export")} "${key}=${env[key]}"`;
      if (exportVar.includes("${workspaceFolder}")) {
        exportVar = exportVar.replaceAll("${workspaceFolder}", workspaceFolder);
      }
      terminal.sendText(exportVar, true);
    }
  }
  return terminal;
};
async function runScript(scriptPath, scriptName, createTerminal, shellArgs2 = [], env = void 0, type = "", hideTerminal = false, port = void 0) {
  const scriptFullPath = path.join(scriptPath, "bin", scriptName);
  if (!fs__namespace.existsSync(scriptFullPath)) {
    vscode__namespace.window.showErrorMessage(
      `Script path ${scriptFullPath} does not exist`
    );
  } else {
    if (!os__namespace.platform().toLowerCase().startsWith("win")) {
      fs__namespace.chmodSync(scriptFullPath, 493);
    }
  }
  const terminal = getTerminal(hideTerminal, env, createTerminal);
  const fullPathToScript = path.join(scriptPath, "bin", scriptName).replace(" ", "\\ ");
  const debuggerRunCommand = `${fullPathToScript} ${shellArgs2.join(" ")}`;
  terminal.sendText(debuggerRunCommand);
  if (!hideTerminal) {
    terminal.show();
    await displayTerminalExitStatus(terminal);
  }
  if (type.includes("daffodil")) {
    await delay(5e3).then(() => {
    });
  } else {
    const wait_port = require("wait-port");
    await wait_port({ host: "127.0.0.1", port, output: "silent" });
  }
  return terminal;
}
function tmpFile(sid) {
  return `${os__namespace.tmpdir()}/infoset-${sid}.${getCurrentConfig().infosetFormat}`;
}
function ensureFile(path2) {
  if (!fs__namespace.existsSync(path2)) {
    fs__namespace.writeFileSync(path2, "");
  }
  return path2;
}
function substituteVSCodeEnvVariables(input, alternativeWorkspace) {
  const workspaceFolder = vscode__namespace.workspace.workspaceFolders?.[0]?.uri.fsPath || alternativeWorkspace || "";
  const homeDir = os__namespace.homedir();
  const variableMap = {
    "${workspaceFolder}": workspaceFolder,
    "${workspaceRoot}": workspaceFolder,
    "${userHome}": homeDir,
    "${file}": vscode__namespace.window.activeTextEditor?.document.uri.fsPath || "",
    "${relativeFile}": path.relative(
      workspaceFolder,
      vscode__namespace.window.activeTextEditor?.document.uri.fsPath || ""
    ),
    "${fileBasename}": path.basename(
      vscode__namespace.window.activeTextEditor?.document.uri.fsPath || ""
    ),
    "${fileDirname}": path.dirname(
      vscode__namespace.window.activeTextEditor?.document.uri.fsPath || ""
    ),
    "${fileExtname}": path.extname(
      vscode__namespace.window.activeTextEditor?.document.uri.fsPath || ""
    ),
    "${fileBasenameNoExtension}": path.basename(
      vscode__namespace.window.activeTextEditor?.document.uri.fsPath || "",
      path.extname(vscode__namespace.window.activeTextEditor?.document.uri.fsPath || "")
    ),
    "${cwd}": process.cwd()
  };
  Object.entries(define_process_env_default$4).forEach(([key, value]) => {
    if (value) {
      variableMap[`\${env:${key}}`] = value;
    }
  });
  return Object.entries(variableMap).reduce((result, [variable, value]) => {
    return result.replaceAll(variable, value);
  }, input);
}
function getTDMLTestCaseItems(path2) {
  if (!fs__namespace.existsSync(path2)) {
    return [];
  }
  const parser2 = new XMLParser({
    ignoreAttributes: false,
    removeNSPrefix: true
  });
  const fileData = fs__namespace.readFileSync(path2);
  const xml_obj = parser2.parse(fileData);
  const parserTestCaseObjs = xml_obj["testSuite"]?.["parserTestCase"];
  const testCaseArr = Array.isArray(parserTestCaseObjs) ? parserTestCaseObjs : parserTestCaseObjs ? [parserTestCaseObjs] : [];
  return testCaseArr.map((item) => item["@_name"]);
}
const displayModalError = async (message, ...items2) => vscode__namespace.window.showErrorMessage(message, { modal: true }, ...items2).then(
  void 0,
  () => vscode__namespace.window.showErrorMessage(message, { modal: false })
);
async function downloadAndExtract(title, url, targetDir) {
  await vscode__namespace.window.withProgress(
    {
      location: vscode__namespace.ProgressLocation.Notification,
      title: `Downloading ${title}...`,
      cancellable: false
    },
    async (progress) => {
      progress.report({ increment: 0, message: "Starting download..." });
      const res = await fetch(url);
      if (!res.ok || !res.body) {
        throw new Error(
          `Failed to download ${url}: ${res.status} ${res.statusText}`
        );
      }
      const totalBytes = Number(res.headers.get("content-length")) || 0;
      let downloaded = 0;
      let lastPercent = 0;
      const progressStream = new require$$0.Transform({
        transform(chunk, _encoding, callback) {
          downloaded += chunk.length;
          if (totalBytes > 0) {
            const percent = downloaded / totalBytes * 100;
            const increment = percent - lastPercent;
            lastPercent = percent;
            progress.report({
              increment,
              message: `${percent.toFixed(1)}%`
            });
          }
          callback(null, chunk);
        }
      });
      await fs__namespace.promises.mkdir(targetDir, { recursive: true });
      await promises.pipeline(
        res.body,
        progressStream,
        unzipExports.Extract({ path: targetDir })
      );
      progress.report({
        increment: 100 - lastPercent,
        message: "Extracting complete!"
      });
    }
  );
}
async function openInfosetFilePrompt() {
  let config = getCurrentConfig();
  if (config.infosetOutput.type === "file") {
    let rootPath2 = vscode__namespace.workspace.workspaceFolders ? vscode__namespace.workspace.workspaceFolders[0].uri.fsPath : vscode__namespace.Uri.parse("").fsPath;
    let infosetPath = config.infosetOutput.path.includes("${workspaceFolder}") ? config.infosetOutput.path.replace("${workspaceFolder}", rootPath2) : config.infosetOutput.path;
    let uri = vscode__namespace.Uri.file(infosetPath);
    if (fs__namespace.readFileSync(uri.fsPath).toString() !== "") {
      const action = await vscode__namespace.window.showInformationMessage(
        `Wrote infoset file to ${infosetPath}`,
        "Open",
        "Dismiss"
      );
      switch (action) {
        case "Open":
          let infoset = await vscode__namespace.workspace.openTextDocument(uri);
          await vscode__namespace.window.showTextDocument(infoset, {
            preview: false,
            viewColumn: vscode__namespace.ViewColumn.One
          });
          break;
      }
    }
  }
}
async function activate$8(ctx) {
  let sid;
  let doc;
  ctx.subscriptions.push(
    vscode__namespace.debug.onDidStartDebugSession((s) => {
      sid = s.id;
      onDebugStartDisplay(["infoset-view", "infoset-diff-view", "data-editor"]);
    })
  );
  ctx.subscriptions.push(
    vscode__namespace.debug.onDidTerminateDebugSession(async (s) => {
      if (sid !== void 0) {
        let filepath = tmpFile(sid);
        fs__namespace.rmSync(`${filepath}`, { force: true });
        fs__namespace.rmSync(`${filepath}.prev.xml`, { force: true });
      }
      sid = void 0;
      await openInfosetFilePrompt();
    })
  );
  ctx.subscriptions.push(
    vscode__namespace.workspace.registerTextDocumentContentProvider(
      "daffodil:infoset",
      fileInfosetProvider
    )
  );
  ctx.subscriptions.push(
    vscode__namespace.commands.registerCommand("infoset.display", async () => {
      if (sid !== void 0) {
        let filepath = ensureFile(tmpFile(sid));
        doc = await vscode__namespace.workspace.openTextDocument(filepath);
        await vscode__namespace.window.showTextDocument(doc, {
          viewColumn: vscode__namespace.ViewColumn.Two,
          preserveFocus: true,
          preview: false
        });
      }
    })
  );
  ctx.subscriptions.push(
    vscode__namespace.commands.registerCommand(
      "infoset.save",
      async (id, e) => {
        if (sid !== void 0) {
          let dest = await vscode__namespace.window.showInputBox({
            placeHolder: "Save infoset as:"
          });
          if (dest) {
            let rootPath2 = vscode__namespace.workspace.workspaceFolders ? vscode__namespace.workspace.workspaceFolders[0].uri.fsPath : vscode__namespace.Uri.parse("").fsPath;
            dest = path__namespace.join(rootPath2, dest);
            fs__namespace.copyFile(tmpFile(sid), dest, async () => {
              const choice = await vscode__namespace.window.showInformationMessage(
                `Wrote infoset to ${dest}`,
                "View",
                "Delete"
              );
              let uri = vscode.Uri.file(dest);
              switch (choice) {
                case "View":
                  let xml = await vscode__namespace.workspace.openTextDocument(uri);
                  await vscode__namespace.window.showTextDocument(xml, {
                    preview: false,
                    viewColumn: vscode__namespace.ViewColumn.Two
                  });
                  break;
                case "Delete":
                  fs__namespace.unlinkSync(dest);
                  break;
              }
            });
          }
        }
      }
    )
  );
  ctx.subscriptions.push(
    vscode__namespace.commands.registerCommand("infoset.diff", async () => {
      if (sid !== void 0) {
        let filepath = ensureFile(tmpFile(sid));
        let prev = ensureFile(`${filepath}.prev.xml`);
        vscode__namespace.commands.executeCommand(
          "vscode.diff",
          vscode.Uri.file(prev),
          vscode.Uri.file(filepath),
          "Previous ↔ Current",
          { preview: false, viewColumn: vscode__namespace.ViewColumn.Two }
        );
      }
    })
  );
}
const fileInfosetProvider = new class {
  provideTextDocumentContent(uri) {
    return fs__namespace.readFileSync(uri.path).toString();
  }
}();
function createScanner(text, ignoreTrivia = false) {
  const len = text.length;
  let pos = 0, value = "", tokenOffset = 0, token = 16, lineNumber = 0, lineStartOffset = 0, tokenLineStartOffset = 0, prevTokenLineStartOffset = 0, scanError = 0;
  function scanHexDigits(count, exact) {
    let digits = 0;
    let value2 = 0;
    while (digits < count || false) {
      let ch = text.charCodeAt(pos);
      if (ch >= 48 && ch <= 57) {
        value2 = value2 * 16 + ch - 48;
      } else if (ch >= 65 && ch <= 70) {
        value2 = value2 * 16 + ch - 65 + 10;
      } else if (ch >= 97 && ch <= 102) {
        value2 = value2 * 16 + ch - 97 + 10;
      } else {
        break;
      }
      pos++;
      digits++;
    }
    if (digits < count) {
      value2 = -1;
    }
    return value2;
  }
  function setPosition(newPosition) {
    pos = newPosition;
    value = "";
    tokenOffset = 0;
    token = 16;
    scanError = 0;
  }
  function scanNumber() {
    let start = pos;
    if (text.charCodeAt(pos) === 48) {
      pos++;
    } else {
      pos++;
      while (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
      }
    }
    if (pos < text.length && text.charCodeAt(pos) === 46) {
      pos++;
      if (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit(text.charCodeAt(pos))) {
          pos++;
        }
      } else {
        scanError = 3;
        return text.substring(start, pos);
      }
    }
    let end = pos;
    if (pos < text.length && (text.charCodeAt(pos) === 69 || text.charCodeAt(pos) === 101)) {
      pos++;
      if (pos < text.length && text.charCodeAt(pos) === 43 || text.charCodeAt(pos) === 45) {
        pos++;
      }
      if (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit(text.charCodeAt(pos))) {
          pos++;
        }
        end = pos;
      } else {
        scanError = 3;
      }
    }
    return text.substring(start, end);
  }
  function scanString() {
    let result = "", start = pos;
    while (true) {
      if (pos >= len) {
        result += text.substring(start, pos);
        scanError = 2;
        break;
      }
      const ch = text.charCodeAt(pos);
      if (ch === 34) {
        result += text.substring(start, pos);
        pos++;
        break;
      }
      if (ch === 92) {
        result += text.substring(start, pos);
        pos++;
        if (pos >= len) {
          scanError = 2;
          break;
        }
        const ch2 = text.charCodeAt(pos++);
        switch (ch2) {
          case 34:
            result += '"';
            break;
          case 92:
            result += "\\";
            break;
          case 47:
            result += "/";
            break;
          case 98:
            result += "\b";
            break;
          case 102:
            result += "\f";
            break;
          case 110:
            result += "\n";
            break;
          case 114:
            result += "\r";
            break;
          case 116:
            result += "	";
            break;
          case 117:
            const ch3 = scanHexDigits(4);
            if (ch3 >= 0) {
              result += String.fromCharCode(ch3);
            } else {
              scanError = 4;
            }
            break;
          default:
            scanError = 5;
        }
        start = pos;
        continue;
      }
      if (ch >= 0 && ch <= 31) {
        if (isLineBreak(ch)) {
          result += text.substring(start, pos);
          scanError = 2;
          break;
        } else {
          scanError = 6;
        }
      }
      pos++;
    }
    return result;
  }
  function scanNext() {
    value = "";
    scanError = 0;
    tokenOffset = pos;
    lineStartOffset = lineNumber;
    prevTokenLineStartOffset = tokenLineStartOffset;
    if (pos >= len) {
      tokenOffset = len;
      return token = 17;
    }
    let code = text.charCodeAt(pos);
    if (isWhiteSpace(code)) {
      do {
        pos++;
        value += String.fromCharCode(code);
        code = text.charCodeAt(pos);
      } while (isWhiteSpace(code));
      return token = 15;
    }
    if (isLineBreak(code)) {
      pos++;
      value += String.fromCharCode(code);
      if (code === 13 && text.charCodeAt(pos) === 10) {
        pos++;
        value += "\n";
      }
      lineNumber++;
      tokenLineStartOffset = pos;
      return token = 14;
    }
    switch (code) {
      // tokens: []{}:,
      case 123:
        pos++;
        return token = 1;
      case 125:
        pos++;
        return token = 2;
      case 91:
        pos++;
        return token = 3;
      case 93:
        pos++;
        return token = 4;
      case 58:
        pos++;
        return token = 6;
      case 44:
        pos++;
        return token = 5;
      // strings
      case 34:
        pos++;
        value = scanString();
        return token = 10;
      // comments
      case 47:
        const start = pos - 1;
        if (text.charCodeAt(pos + 1) === 47) {
          pos += 2;
          while (pos < len) {
            if (isLineBreak(text.charCodeAt(pos))) {
              break;
            }
            pos++;
          }
          value = text.substring(start, pos);
          return token = 12;
        }
        if (text.charCodeAt(pos + 1) === 42) {
          pos += 2;
          const safeLength = len - 1;
          let commentClosed = false;
          while (pos < safeLength) {
            const ch = text.charCodeAt(pos);
            if (ch === 42 && text.charCodeAt(pos + 1) === 47) {
              pos += 2;
              commentClosed = true;
              break;
            }
            pos++;
            if (isLineBreak(ch)) {
              if (ch === 13 && text.charCodeAt(pos) === 10) {
                pos++;
              }
              lineNumber++;
              tokenLineStartOffset = pos;
            }
          }
          if (!commentClosed) {
            pos++;
            scanError = 1;
          }
          value = text.substring(start, pos);
          return token = 13;
        }
        value += String.fromCharCode(code);
        pos++;
        return token = 16;
      // numbers
      case 45:
        value += String.fromCharCode(code);
        pos++;
        if (pos === len || !isDigit(text.charCodeAt(pos))) {
          return token = 16;
        }
      // found a minus, followed by a number so
      // we fall through to proceed with scanning
      // numbers
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        value += scanNumber();
        return token = 11;
      // literals and unknown symbols
      default:
        while (pos < len && isUnknownContentCharacter(code)) {
          pos++;
          code = text.charCodeAt(pos);
        }
        if (tokenOffset !== pos) {
          value = text.substring(tokenOffset, pos);
          switch (value) {
            case "true":
              return token = 8;
            case "false":
              return token = 9;
            case "null":
              return token = 7;
          }
          return token = 16;
        }
        value += String.fromCharCode(code);
        pos++;
        return token = 16;
    }
  }
  function isUnknownContentCharacter(code) {
    if (isWhiteSpace(code) || isLineBreak(code)) {
      return false;
    }
    switch (code) {
      case 125:
      case 93:
      case 123:
      case 91:
      case 34:
      case 58:
      case 44:
      case 47:
        return false;
    }
    return true;
  }
  function scanNextNonTrivia() {
    let result;
    do {
      result = scanNext();
    } while (result >= 12 && result <= 15);
    return result;
  }
  return {
    setPosition,
    getPosition: () => pos,
    scan: ignoreTrivia ? scanNextNonTrivia : scanNext,
    getToken: () => token,
    getTokenValue: () => value,
    getTokenOffset: () => tokenOffset,
    getTokenLength: () => pos - tokenOffset,
    getTokenStartLine: () => lineStartOffset,
    getTokenStartCharacter: () => tokenOffset - prevTokenLineStartOffset,
    getTokenError: () => scanError
  };
}
function isWhiteSpace(ch) {
  return ch === 32 || ch === 9;
}
function isLineBreak(ch) {
  return ch === 10 || ch === 13;
}
function isDigit(ch) {
  return ch >= 48 && ch <= 57;
}
var CharacterCodes;
(function(CharacterCodes2) {
  CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
  CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
  CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
  CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
  CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
  CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
  CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
  CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
  CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
  CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
  CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
  CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
  CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
  CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
  CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
  CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
  CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
  CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
  CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
  CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
  CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
  CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
  CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
  CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
  CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
  CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
  CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
  CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
  CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
  CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
  CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
  CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
  CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
  CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
  CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
  CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
  CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
  CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
  CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
  CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
  CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
  CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
  CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
  CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
  CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
  CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
  CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
  CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
  CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
  CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
  CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
  CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
  CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
  CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
  CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
  CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
  CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
  CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
  CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
  CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
  CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
  CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
  CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
  CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
  CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
  CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
  CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
  CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
  CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
  CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
  CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
  CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
  CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
  CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
  CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
  CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
  CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
  CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
  CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
  CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
})(CharacterCodes || (CharacterCodes = {}));
new Array(20).fill(0).map((_2, index) => {
  return " ".repeat(index);
});
const maxCachedValues = 200;
({
  " ": {
    "\n": new Array(maxCachedValues).fill(0).map((_2, index) => {
      return "\n" + " ".repeat(index);
    }),
    "\r": new Array(maxCachedValues).fill(0).map((_2, index) => {
      return "\r" + " ".repeat(index);
    }),
    "\r\n": new Array(maxCachedValues).fill(0).map((_2, index) => {
      return "\r\n" + " ".repeat(index);
    })
  },
  "	": {
    "\n": new Array(maxCachedValues).fill(0).map((_2, index) => {
      return "\n" + "	".repeat(index);
    }),
    "\r": new Array(maxCachedValues).fill(0).map((_2, index) => {
      return "\r" + "	".repeat(index);
    }),
    "\r\n": new Array(maxCachedValues).fill(0).map((_2, index) => {
      return "\r\n" + "	".repeat(index);
    })
  }
});
var ParseOptions;
(function(ParseOptions2) {
  ParseOptions2.DEFAULT = {
    allowTrailingComma: false
  };
})(ParseOptions || (ParseOptions = {}));
function parse$1(text, errors = [], options = ParseOptions.DEFAULT) {
  let currentProperty = null;
  let currentParent = [];
  const previousParents = [];
  function onValue(value) {
    if (Array.isArray(currentParent)) {
      currentParent.push(value);
    } else if (currentProperty !== null) {
      currentParent[currentProperty] = value;
    }
  }
  const visitor = {
    onObjectBegin: () => {
      const object = {};
      onValue(object);
      previousParents.push(currentParent);
      currentParent = object;
      currentProperty = null;
    },
    onObjectProperty: (name) => {
      currentProperty = name;
    },
    onObjectEnd: () => {
      currentParent = previousParents.pop();
    },
    onArrayBegin: () => {
      const array = [];
      onValue(array);
      previousParents.push(currentParent);
      currentParent = array;
      currentProperty = null;
    },
    onArrayEnd: () => {
      currentParent = previousParents.pop();
    },
    onLiteralValue: onValue,
    onError: (error, offset, length) => {
      errors.push({ error, offset, length });
    }
  };
  visit(text, visitor, options);
  return currentParent[0];
}
function visit(text, visitor, options = ParseOptions.DEFAULT) {
  const _scanner = createScanner(text, false);
  const _jsonPath = [];
  function toNoArgVisit(visitFunction) {
    return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter()) : () => true;
  }
  function toNoArgVisitWithPath(visitFunction) {
    return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter(), () => _jsonPath.slice()) : () => true;
  }
  function toOneArgVisit(visitFunction) {
    return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter()) : () => true;
  }
  function toOneArgVisitWithPath(visitFunction) {
    return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter(), () => _jsonPath.slice()) : () => true;
  }
  const onObjectBegin = toNoArgVisitWithPath(visitor.onObjectBegin), onObjectProperty = toOneArgVisitWithPath(visitor.onObjectProperty), onObjectEnd = toNoArgVisit(visitor.onObjectEnd), onArrayBegin = toNoArgVisitWithPath(visitor.onArrayBegin), onArrayEnd = toNoArgVisit(visitor.onArrayEnd), onLiteralValue = toOneArgVisitWithPath(visitor.onLiteralValue), onSeparator = toOneArgVisit(visitor.onSeparator), onComment = toNoArgVisit(visitor.onComment), onError = toOneArgVisit(visitor.onError);
  const disallowComments = options && options.disallowComments;
  const allowTrailingComma = options && options.allowTrailingComma;
  function scanNext() {
    while (true) {
      const token = _scanner.scan();
      switch (_scanner.getTokenError()) {
        case 4:
          handleError(
            14
            /* ParseErrorCode.InvalidUnicode */
          );
          break;
        case 5:
          handleError(
            15
            /* ParseErrorCode.InvalidEscapeCharacter */
          );
          break;
        case 3:
          handleError(
            13
            /* ParseErrorCode.UnexpectedEndOfNumber */
          );
          break;
        case 1:
          if (!disallowComments) {
            handleError(
              11
              /* ParseErrorCode.UnexpectedEndOfComment */
            );
          }
          break;
        case 2:
          handleError(
            12
            /* ParseErrorCode.UnexpectedEndOfString */
          );
          break;
        case 6:
          handleError(
            16
            /* ParseErrorCode.InvalidCharacter */
          );
          break;
      }
      switch (token) {
        case 12:
        case 13:
          if (disallowComments) {
            handleError(
              10
              /* ParseErrorCode.InvalidCommentToken */
            );
          } else {
            onComment();
          }
          break;
        case 16:
          handleError(
            1
            /* ParseErrorCode.InvalidSymbol */
          );
          break;
        case 15:
        case 14:
          break;
        default:
          return token;
      }
    }
  }
  function handleError(error, skipUntilAfter = [], skipUntil = []) {
    onError(error);
    if (skipUntilAfter.length + skipUntil.length > 0) {
      let token = _scanner.getToken();
      while (token !== 17) {
        if (skipUntilAfter.indexOf(token) !== -1) {
          scanNext();
          break;
        } else if (skipUntil.indexOf(token) !== -1) {
          break;
        }
        token = scanNext();
      }
    }
  }
  function parseString(isValue) {
    const value = _scanner.getTokenValue();
    if (isValue) {
      onLiteralValue(value);
    } else {
      onObjectProperty(value);
      _jsonPath.push(value);
    }
    scanNext();
    return true;
  }
  function parseLiteral() {
    switch (_scanner.getToken()) {
      case 11:
        const tokenValue = _scanner.getTokenValue();
        let value = Number(tokenValue);
        if (isNaN(value)) {
          handleError(
            2
            /* ParseErrorCode.InvalidNumberFormat */
          );
          value = 0;
        }
        onLiteralValue(value);
        break;
      case 7:
        onLiteralValue(null);
        break;
      case 8:
        onLiteralValue(true);
        break;
      case 9:
        onLiteralValue(false);
        break;
      default:
        return false;
    }
    scanNext();
    return true;
  }
  function parseProperty() {
    if (_scanner.getToken() !== 10) {
      handleError(3, [], [
        2,
        5
        /* SyntaxKind.CommaToken */
      ]);
      return false;
    }
    parseString(false);
    if (_scanner.getToken() === 6) {
      onSeparator(":");
      scanNext();
      if (!parseValue2()) {
        handleError(4, [], [
          2,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
    } else {
      handleError(5, [], [
        2,
        5
        /* SyntaxKind.CommaToken */
      ]);
    }
    _jsonPath.pop();
    return true;
  }
  function parseObject() {
    onObjectBegin();
    scanNext();
    let needsComma = false;
    while (_scanner.getToken() !== 2 && _scanner.getToken() !== 17) {
      if (_scanner.getToken() === 5) {
        if (!needsComma) {
          handleError(4, [], []);
        }
        onSeparator(",");
        scanNext();
        if (_scanner.getToken() === 2 && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError(6, [], []);
      }
      if (!parseProperty()) {
        handleError(4, [], [
          2,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
      needsComma = true;
    }
    onObjectEnd();
    if (_scanner.getToken() !== 2) {
      handleError(7, [
        2
        /* SyntaxKind.CloseBraceToken */
      ], []);
    } else {
      scanNext();
    }
    return true;
  }
  function parseArray() {
    onArrayBegin();
    scanNext();
    let isFirstElement = true;
    let needsComma = false;
    while (_scanner.getToken() !== 4 && _scanner.getToken() !== 17) {
      if (_scanner.getToken() === 5) {
        if (!needsComma) {
          handleError(4, [], []);
        }
        onSeparator(",");
        scanNext();
        if (_scanner.getToken() === 4 && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError(6, [], []);
      }
      if (isFirstElement) {
        _jsonPath.push(0);
        isFirstElement = false;
      } else {
        _jsonPath[_jsonPath.length - 1]++;
      }
      if (!parseValue2()) {
        handleError(4, [], [
          4,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
      needsComma = true;
    }
    onArrayEnd();
    if (!isFirstElement) {
      _jsonPath.pop();
    }
    if (_scanner.getToken() !== 4) {
      handleError(8, [
        4
        /* SyntaxKind.CloseBracketToken */
      ], []);
    } else {
      scanNext();
    }
    return true;
  }
  function parseValue2() {
    switch (_scanner.getToken()) {
      case 3:
        return parseArray();
      case 1:
        return parseObject();
      case 10:
        return parseString(true);
      default:
        return parseLiteral();
    }
  }
  scanNext();
  if (_scanner.getToken() === 17) {
    if (options.allowEmptyContent) {
      return true;
    }
    handleError(4, [], []);
    return false;
  }
  if (!parseValue2()) {
    handleError(4, [], []);
    return false;
  }
  if (_scanner.getToken() !== 17) {
    handleError(9, [], []);
  }
  return true;
}
var ScanError;
(function(ScanError2) {
  ScanError2[ScanError2["None"] = 0] = "None";
  ScanError2[ScanError2["UnexpectedEndOfComment"] = 1] = "UnexpectedEndOfComment";
  ScanError2[ScanError2["UnexpectedEndOfString"] = 2] = "UnexpectedEndOfString";
  ScanError2[ScanError2["UnexpectedEndOfNumber"] = 3] = "UnexpectedEndOfNumber";
  ScanError2[ScanError2["InvalidUnicode"] = 4] = "InvalidUnicode";
  ScanError2[ScanError2["InvalidEscapeCharacter"] = 5] = "InvalidEscapeCharacter";
  ScanError2[ScanError2["InvalidCharacter"] = 6] = "InvalidCharacter";
})(ScanError || (ScanError = {}));
var SyntaxKind;
(function(SyntaxKind2) {
  SyntaxKind2[SyntaxKind2["OpenBraceToken"] = 1] = "OpenBraceToken";
  SyntaxKind2[SyntaxKind2["CloseBraceToken"] = 2] = "CloseBraceToken";
  SyntaxKind2[SyntaxKind2["OpenBracketToken"] = 3] = "OpenBracketToken";
  SyntaxKind2[SyntaxKind2["CloseBracketToken"] = 4] = "CloseBracketToken";
  SyntaxKind2[SyntaxKind2["CommaToken"] = 5] = "CommaToken";
  SyntaxKind2[SyntaxKind2["ColonToken"] = 6] = "ColonToken";
  SyntaxKind2[SyntaxKind2["NullKeyword"] = 7] = "NullKeyword";
  SyntaxKind2[SyntaxKind2["TrueKeyword"] = 8] = "TrueKeyword";
  SyntaxKind2[SyntaxKind2["FalseKeyword"] = 9] = "FalseKeyword";
  SyntaxKind2[SyntaxKind2["StringLiteral"] = 10] = "StringLiteral";
  SyntaxKind2[SyntaxKind2["NumericLiteral"] = 11] = "NumericLiteral";
  SyntaxKind2[SyntaxKind2["LineCommentTrivia"] = 12] = "LineCommentTrivia";
  SyntaxKind2[SyntaxKind2["BlockCommentTrivia"] = 13] = "BlockCommentTrivia";
  SyntaxKind2[SyntaxKind2["LineBreakTrivia"] = 14] = "LineBreakTrivia";
  SyntaxKind2[SyntaxKind2["Trivia"] = 15] = "Trivia";
  SyntaxKind2[SyntaxKind2["Unknown"] = 16] = "Unknown";
  SyntaxKind2[SyntaxKind2["EOF"] = 17] = "EOF";
})(SyntaxKind || (SyntaxKind = {}));
const parse = parse$1;
var ParseErrorCode;
(function(ParseErrorCode2) {
  ParseErrorCode2[ParseErrorCode2["InvalidSymbol"] = 1] = "InvalidSymbol";
  ParseErrorCode2[ParseErrorCode2["InvalidNumberFormat"] = 2] = "InvalidNumberFormat";
  ParseErrorCode2[ParseErrorCode2["PropertyNameExpected"] = 3] = "PropertyNameExpected";
  ParseErrorCode2[ParseErrorCode2["ValueExpected"] = 4] = "ValueExpected";
  ParseErrorCode2[ParseErrorCode2["ColonExpected"] = 5] = "ColonExpected";
  ParseErrorCode2[ParseErrorCode2["CommaExpected"] = 6] = "CommaExpected";
  ParseErrorCode2[ParseErrorCode2["CloseBraceExpected"] = 7] = "CloseBraceExpected";
  ParseErrorCode2[ParseErrorCode2["CloseBracketExpected"] = 8] = "CloseBracketExpected";
  ParseErrorCode2[ParseErrorCode2["EndOfFileExpected"] = 9] = "EndOfFileExpected";
  ParseErrorCode2[ParseErrorCode2["InvalidCommentToken"] = 10] = "InvalidCommentToken";
  ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfComment"] = 11] = "UnexpectedEndOfComment";
  ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfString"] = 12] = "UnexpectedEndOfString";
  ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfNumber"] = 13] = "UnexpectedEndOfNumber";
  ParseErrorCode2[ParseErrorCode2["InvalidUnicode"] = 14] = "InvalidUnicode";
  ParseErrorCode2[ParseErrorCode2["InvalidEscapeCharacter"] = 15] = "InvalidEscapeCharacter";
  ParseErrorCode2[ParseErrorCode2["InvalidCharacter"] = 16] = "InvalidCharacter";
})(ParseErrorCode || (ParseErrorCode = {}));
let launchWizard;
const defaultConf = getConfig({
  name: "Wizard Config",
  request: "launch",
  type: "dfdl",
  schema: {
    path: "${command:AskForSchemaName}",
    rootName: "null",
    rootNamespace: "null"
  }
});
async function activate$7(ctx) {
  ctx.subscriptions.push(
    vscode__namespace.commands.registerCommand("launch.config", async () => {
      launchWizard = await createWizard(ctx);
    })
  );
}
function getAllowedLogLevels(toLower = false) {
  let logLevels = [];
  ["DEBUG", "INFO", "WARNING", "ERROR", "CRITICAL"].forEach((logLevel) => {
    logLevels.push(toLower ? logLevel.toLowerCase() : logLevel);
  });
  return logLevels;
}
function getConfigValues(data, configIndex) {
  if (data && configIndex !== -1) {
    let configs = data.configurations;
    var currentConfig2 = configs[configIndex];
    for (var key of Object.keys(defaultConf)) {
      if (!currentConfig2.hasOwnProperty(key)) {
        currentConfig2[key] = defaultConf[key];
      }
      if (defaultConf[key] instanceof Object) {
        for (var nestedKey of Object.keys(defaultConf[key])) {
          if (!currentConfig2[key].hasOwnProperty(nestedKey)) {
            currentConfig2[key][nestedKey] = defaultConf[key][nestedKey];
          }
        }
      }
    }
    return currentConfig2;
  } else {
    return defaultConf;
  }
}
async function createUpdateConfigFile(data, updateOrCreate) {
  let rootPath2 = vscode__namespace.workspace.workspaceFolders ? vscode__namespace.workspace.workspaceFolders[0].uri.fsPath : vscode__namespace.Uri.parse("").fsPath;
  if (!fs__namespace.existsSync(`${rootPath2}/.vscode`)) {
    fs__namespace.mkdirSync(`${rootPath2}/.vscode`);
  }
  const launchPath = osCheck(
    `/${rootPath2}/.vscode/launch.json`,
    `${rootPath2}/.vscode/launch.json`
  );
  if (!fs__namespace.existsSync(`${rootPath2}/.vscode/launch.json`)) {
    fs__namespace.writeFileSync(`${rootPath2}/.vscode/launch.json`, data);
    vscode__namespace.window.showTextDocument(vscode__namespace.Uri.parse(launchPath));
    return;
  }
  let newConf = JSON.parse(data).configurations[0];
  let fileData = parse(
    fs__namespace.readFileSync(`${rootPath2}/.vscode/launch.json`).toString()
  );
  if (updateOrCreate.toLowerCase() === "create") {
    let alreadyExists = false;
    fileData.configurations.forEach((element) => {
      if (element.name === newConf.name) {
        alreadyExists = true;
      }
    });
    if (alreadyExists) {
      vscode__namespace.window.showWarningMessage(
        "The conf trying to be saved already exists in the launch.json"
      );
      return;
    }
    fileData.configurations.push(newConf);
    fs__namespace.writeFileSync(
      `${rootPath2}/.vscode/launch.json`,
      JSON.stringify(fileData, null, 4)
    );
  } else if (updateOrCreate.toLowerCase() === "update") {
    let configIndex = -1;
    for (let i = 0; i < fileData.configurations.length; i++) {
      if (fileData.configurations[i].name === newConf.name) {
        configIndex = i;
        break;
      }
    }
    if (configIndex !== -1) {
      fileData.configurations[configIndex] = newConf;
      fs__namespace.writeFileSync(
        `${rootPath2}/.vscode/launch.json`,
        JSON.stringify(fileData, null, 4)
      );
    } else {
      vscode__namespace.window.showErrorMessage("Invalid Config Selected!");
    }
  }
  vscode__namespace.window.showTextDocument(vscode__namespace.Uri.parse(launchPath));
}
async function copyConfig(data) {
  let rootPath2 = vscode__namespace.workspace.workspaceFolders ? vscode__namespace.workspace.workspaceFolders[0].uri.fsPath : vscode__namespace.Uri.parse("").fsPath;
  if (!fs__namespace.existsSync(`${rootPath2}/.vscode`)) {
    fs__namespace.mkdirSync(`${rootPath2}/.vscode`);
  }
  if (!fs__namespace.existsSync(`${rootPath2}/.vscode/launch.json`)) {
    fs__namespace.writeFileSync(`${rootPath2}/.vscode/launch.json`, data);
    return;
  }
  let newConf = JSON.parse(data).configurations[0];
  let fileData = parse(
    fs__namespace.readFileSync(`${rootPath2}/.vscode/launch.json`).toString()
  );
  fileData.configurations.forEach((element) => {
    if (element.name === newConf.name) {
      if (newConf.name.endsWith("Copy")) {
        newConf.name = `${newConf.name} 1`;
      } else if (new RegExp("Copy.*$").test(newConf.name)) {
        let items2 = newConf.name.split(" ");
        let count = parseInt(items2[items2.length - 1]);
        newConf.name = `${items2.slice(0, -1).join(" ")} ${count + 1}`;
      } else {
        newConf.name = `${newConf.name} Copy`;
      }
    }
  });
  fileData.configurations.push(newConf);
  fs__namespace.writeFileSync(
    `${rootPath2}/.vscode/launch.json`,
    JSON.stringify(fileData, null, 4)
  );
  vscode__namespace.window.showInformationMessage("Launch Configuration Copied!");
  await reloadLaunchWizardUI(fileData, newConf);
}
async function reloadLaunchWizardUI(fileData, newConf) {
  if (launchWizard !== void 0) {
    let panel = launchWizard.getPanel();
    let index = void 0;
    fileData.configurations.forEach((conf, i) => {
      if (conf.name == newConf.name) {
        index = i;
      }
    });
    panel.webview.html = launchWizard.getWebViewContent(index);
  }
}
async function updateWebViewConfigValues(configIndex) {
  let rootPath2 = vscode__namespace.workspace.workspaceFolders ? vscode__namespace.workspace.workspaceFolders[0].uri.fsPath : vscode__namespace.Uri.parse("").fsPath;
  let fileData = configIndex === -1 ? null : parse(
    fs__namespace.readFileSync(`${rootPath2}/.vscode/launch.json`).toString()
  );
  return getConfigValues(fileData, configIndex);
}
async function openFilePicker(description, selectFiles = true, selectFolders = true) {
  let rootPath2 = vscode__namespace.workspace.workspaceFolders ? vscode__namespace.workspace.workspaceFolders[0].uri.fsPath : vscode__namespace.Uri.file("").fsPath;
  let chosenFile = await vscode__namespace.window.showOpenDialog({
    canSelectMany: true,
    openLabel: description,
    canSelectFiles: selectFiles,
    canSelectFolders: selectFolders,
    title: description
  }).then(async (fileUri) => {
    return fileUri && fileUri[0] ? fileUri[0].fsPath : "";
  });
  if (chosenFile.includes(rootPath2)) {
    let regExp = new RegExp(rootPath2, "g");
    chosenFile = chosenFile.replace(regExp, "${workspaceFolder}");
  }
  return chosenFile;
}
async function createWizard(ctx) {
  let launchWiz = new LaunchWizard(ctx);
  let panel = launchWiz.getPanel();
  panel.webview.html = launchWiz.getWebViewContent();
  panel.webview.onDidReceiveMessage(
    async (message) => {
      switch (message.command) {
        case "saveConfig":
          await createUpdateConfigFile(message.data, message.updateOrCreate);
          panel.dispose();
          return;
        case "copyConfig":
          await copyConfig(message.data);
          return;
        case "updateConfigValue":
          var configValues = await updateWebViewConfigValues(
            message.configIndex
          );
          panel.webview.postMessage({
            command: "updateConfValues",
            configValues
          });
          return;
        case "openFilePicker":
          let result = await openFilePicker(
            message.description,
            message.selectFiles,
            message.selectFolders
          );
          if (result !== "") {
            let duplicateCount = 0;
            if (message.id === "daffodilDebugClasspath") {
              duplicateCount = message.extraData["daffodilDebugClasspath"].some(
                (cp) => cp === result
              );
            }
            var command = duplicateCount > 0 ? `${message.id} Value has already been used` : `${message.id}Update`;
            if (duplicateCount > 0) {
              vscode__namespace.window.showWarningMessage("Selected path already added");
            }
            panel.webview.postMessage({
              command,
              value: result
            });
          }
          return;
      }
    },
    void 0,
    ctx.subscriptions
  );
  return launchWiz;
}
class LaunchWizard {
  constructor(ctx) {
    this.panel = void 0;
    this.extensionUri = vscode__namespace.Uri.parse("");
    this.ctx = ctx;
    if (vscode__namespace.workspace.workspaceFolders) {
      this.extensionUri = vscode__namespace.workspace.workspaceFolders[0].uri;
    }
  }
  // Method to create/get the webview panel
  getPanel() {
    if (!this.panel) {
      this.panel = vscode__namespace.window.createWebviewPanel(
        "launchWizard",
        "Launch Config Wizard",
        vscode__namespace.ViewColumn.Active,
        {
          enableScripts: true,
          retainContextWhenHidden: true,
          localResourceRoots: [
            vscode__namespace.Uri.parse(this.ctx.asAbsolutePath("./src/launchWizard"))
          ]
        }
      );
      this.panel.onDidDispose(
        () => {
          this.panel = void 0;
        },
        null,
        this.ctx.subscriptions
      );
    }
    return this.panel;
  }
  // Method for creating web view option that allow our custom script to run
  getWebViewOptions(extensionUri) {
    return {
      enableScripts: true,
      localResourceRoots: [
        vscode__namespace.Uri.parse(this.ctx.asAbsolutePath("./src/launchWizard"))
      ]
    };
  }
  // Method to set html for the data editor
  getWebViewContent(selectedConfigNumber = void 0) {
    const scriptUri = vscode__namespace.Uri.parse(
      this.ctx.asAbsolutePath("./src/launchWizard/script.js")
    );
    const styleUri = vscode__namespace.Uri.parse(
      this.ctx.asAbsolutePath("./src/styles/styles.css")
    );
    const scriptData = fs__namespace.readFileSync(scriptUri.fsPath);
    const styleData = fs__namespace.readFileSync(styleUri.fsPath);
    const nonce = this.getNonce();
    let rootPath2 = vscode__namespace.workspace.workspaceFolders ? vscode__namespace.workspace.workspaceFolders[0].uri.fsPath : vscode__namespace.Uri.parse("").fsPath;
    let configSelect = "";
    let newConfig = !fs__namespace.existsSync(`${rootPath2}/.vscode/launch.json`);
    let configIndex = selectedConfigNumber ? selectedConfigNumber : fs__namespace.existsSync(`${rootPath2}/.vscode/launch.json`) ? 0 : -1;
    let fileData = JSON.parse("{}");
    if (fs__namespace.existsSync(`${rootPath2}/.vscode/launch.json`)) {
      fileData = parse(
        fs__namespace.readFileSync(`${rootPath2}/.vscode/launch.json`).toString()
      );
      fileData.configurations.forEach((element, i) => {
        const selectedText2 = i == configIndex ? 'selected="selected"' : "";
        configSelect += `<option ${selectedText2} value="${element.name}">${element.name}</option>`;
      });
    }
    let selectedText = !fs__namespace.existsSync(`${rootPath2}/.vscode/launch.json`) ? 'selected="selected"' : "";
    configSelect += `<option ${selectedText} value="New Config">New Config</option>`;
    let defaultValues = getConfigValues(fileData, configIndex);
    let nameVisOrHiddenStyle = newConfig ? "margin-top: 10px; visibility: visible;" : "visibility: hidden;";
    let copyConfigVisOrHiddenStyle = newConfig ? "visibility: hidden;" : "visibility: visible;";
    let openDataEditor = defaultValues.openDataEditor ? "checked" : "";
    let openInfosetDiffView = defaultValues.openInfosetDiffView ? "checked" : "";
    let openInfosetView = defaultValues.openInfosetView ? "checked" : "";
    let stopOnEntry = defaultValues.stopOnEntry ? "checked" : "";
    let trace = defaultValues.trace ? "checked" : "";
    let useExistingServer = defaultValues.useExistingServer ? "checked" : "";
    let daffodilDebugClasspathList = '<ul id="daffodilDebugClasspathTable" style="list-style: none; padding-left: 20px;">';
    if (defaultValues.daffodilDebugClasspath) {
      let itemArray = defaultValues.daffodilDebugClasspath;
      for (let i = 0; i < itemArray.length; i++) {
        daffodilDebugClasspathList += `
          <li style="margin-left: -5px;" onclick="removeDebugClasspathItem(this)">
            <p id="debug-classpath-li-${itemArray[i]}" class="debug-classpath-item">
              <button id="remove-debug-classpath-li-${itemArray[i]}" class="minus-button" type="button">-</button>
              ${itemArray[i]}
            </p>
          </li>`;
      }
    }
    daffodilDebugClasspathList += "</ul>";
    let infosetFormatSelect = "";
    let infosetFormatTypes = ["xml", "json"];
    let infosetFormat = defaultValues.infosetFormat;
    infosetFormatTypes.forEach((type) => {
      if (type === infosetFormat) {
        infosetFormatSelect += `<option selected value="${type}">${type}</option>`;
      } else {
        infosetFormatSelect += `<option value="${type}">${type}</option>`;
      }
    });
    let infosetOutputTypeSelect = "";
    let infosetOutputTypes = ["none", "console", "file"];
    let infosetOutputType = defaultValues.infosetOutput["type"];
    let infosetOutputPath = defaultValues.infosetOutput["path"];
    let infosetPathVisOrHiddenStyle = infosetOutputType === "file" ? "margin-top: 10px; visibility: visible;" : "visibility: hidden;";
    infosetOutputTypes.forEach((type) => {
      if (type === infosetOutputType) {
        infosetOutputTypeSelect += `<option selected value="${type}">${type}</option>`;
      } else {
        infosetOutputTypeSelect += `<option value="${type}">${type}</option>`;
      }
    });
    const TDML_EXECUTE_ACTION = "execute";
    const TDML_NONE_ACTION = "none";
    const TDML_GENERATE_ACTION = "generate";
    let tdmlActionSelect = TDML_NONE_ACTION;
    let tdmlActions = [
      TDML_NONE_ACTION,
      TDML_GENERATE_ACTION,
      TDML_EXECUTE_ACTION
    ];
    let tdmlAction = "tdmlConfig" in defaultValues ? defaultValues.tdmlConfig["action"] : null;
    let tdmlName = "tdmlConfig" in defaultValues && defaultValues.tdmlConfig["name"] ? defaultValues.tdmlConfig["name"] : "";
    let tdmlPath = "tdmlConfig" in defaultValues && defaultValues.tdmlConfig["path"] ? defaultValues.tdmlConfig["path"] : "";
    let tdmlNameDesVisOrHiddenStyle = tdmlAction !== null && tdmlAction !== TDML_NONE_ACTION ? "margin-top: 10px; visibility: visible;" : "width: 0px; height: 0px; visibility: hidden";
    let tdmlPathVisOrHiddenStyle = tdmlAction === TDML_EXECUTE_ACTION ? "margin-top: 10px; visibility: visible;" : "width: 0px; height: 0px; visibility: hidden";
    tdmlActions.forEach((action) => {
      if (action === tdmlAction) {
        tdmlActionSelect += `<option selected value="${action}">${action}</option>`;
      } else {
        tdmlActionSelect += `<option value="${action}">${action}</option>`;
      }
    });
    let dfdlDebugger = defaultValues.dfdlDebugger;
    let debuggerLogLevelSelect = "";
    let debuggerLogLevelTypes = getAllowedLogLevels();
    let debuggerLogLevel = dfdlDebugger.logging.level;
    debuggerLogLevelTypes.forEach((type) => {
      if (type === debuggerLogLevel) {
        debuggerLogLevelSelect += `<option selected value="${type}">${type}</option>`;
      } else {
        debuggerLogLevelSelect += `<option value="${type}">${type}</option>`;
      }
    });
    let dataEditor = defaultValues.dataEditor;
    let dataEditorLogLevelSelect = "";
    let dataEditorLogLevelTypes = getAllowedLogLevels(true);
    let dataEditorLogLevel = dataEditor.logging.level;
    dataEditorLogLevelTypes.forEach((type) => {
      if (type === dataEditorLogLevel) {
        dataEditorLogLevelSelect += `<option selected value="${type}">${type}</option>`;
      } else {
        dataEditorLogLevelSelect += `<option value="${type}">${type}</option>`;
      }
    });
    return `
  <!DOCTYPE html>
  <html lang="en">
    <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width," initial-scale=1.0">
      <title>Launch Config Wizard</title>
    </head>
    <body>
      <style>
        .container {
          display: block;
          position: relative;
          margin: 0px;
          margin-top: -10px;
          padding-left: 35px;
          margin-bottom: 25px;
          cursor: pointer;
          font-size: 14px;
          font-style: italic;
          -webkit-user-select: none;
          -moz-user-select: none;
          -ms-user-select: none;
          user-select: none;
        }      
        ${styleData}
      </style>
      <script nonce="${nonce}">
        ${scriptData}
      <\/script>
      <h2 style="color: inherit;">Daffodil Debugger Config Settings</h2>

      <div id="configSelectionDropDown" class="setting-div">
        <p>Launch Config:</p>
        <p class="setting-description">Launch config to be updated in the launch.json. 'New Config' will allow for a new one to be made.</p>
        <p style="margin-top: 5px;" class="setting-description">
          <select onChange="updateSelectedConfig()" class="file-input" style="width: 200px;" id="configSelected">
            ${configSelect}
          </select>
          <button
            id="copyLaunchConfigButton"
            style="${copyConfigVisOrHiddenStyle}"
            class="copy-config-button"
            type="button"
            onclick="copyConfig()"
          >Copy Config</button>
        </p>


        <p style="${nameVisOrHiddenStyle}" id="nameLabel" class="setting-description">
          New Config Name: <input class="file-input" value="${defaultValues.name}" id="name"/>
        </p>
      </div>

      <div id="schemaDiv" class="setting-div">
        <p>Main Schema File:</p>
        <p class="setting-description">Absolute path to the DFDL schema file.</p>
        <input class="file-input" value="${defaultValues.schema.path}" id="schema"/>
        <button id="schemaBrowse" class="browse-button" type="button" onclick="filePicker('schema', 'Select DFDL schema to debug')">Browse</button>
      </div>

      <div id="dataDiv" class="setting-div">
        <p>Input Data File:</p>
        <p class="setting-description">Absolute path to the input data file.</p>
        <input class="file-input" value="${defaultValues.data}" id="data"/>
        <button id="dataBrowse" class="browse-button" type="button" onclick="filePicker('data', 'Select input data file to debug')">Browse</button>
      </div>

      <div id="rootNameDiv" class="setting-div">
        <p>Root Element Name:</p>
        <p class="setting-description">Name of the root element.</p>
        <input class="file-input" value="${defaultValues.schema.rootName}" id="rootName"/>
      </div>

      <div id="rootNamespaceDiv" class="setting-div">
        <p>Root Element Namespace:</p>
        <p class="setting-description">Namespace of the root element.</p>
        <input class="file-input" value="${defaultValues.schema.rootNamespace}" id="rootNamespace"/>
      </div>

      <div id="dfdlDebuggerDiv" class="setting-div">
        <p>Daffodil Debugger Settings:</p>

        <p class="setting-description">Port debug server running on.</p>
        <input class="file-input" value="${defaultValues.debugServer}" id="debugServer"/>

        <p id="dfdlDaffodilVersionLabel" style="margin-top: 10px;" class="setting-description">Version (Daffodil Version):</p>
        <input class="file-input" value="${dfdlDebugger.daffodilVersion}" id="dfdlDaffodilVersion">

        <p id="dfdlDebuggerTimeoutLabel" style="margin-top: 10px;" class="setting-description">Timeout (should end with s, m or h):</p>
        <input class="file-input" value="${dfdlDebugger.timeout}" id="dfdlDebuggerTimeout">

        <p id="dfdlDebuggerLogFileLabel" style="margin-top: 10px;" class="setting-description">Log File:</p>
        <input class="file-input" value="${dfdlDebugger.logging.file}" id="dfdlDebuggerLogFile">
        
        <p id="dfdlDebuggerLogLevelLabel" style="margin-top: 10px;" class="setting-description">Log Level:</p>
        <select class="file-input" style="width: 200px;" id="dfdlDebuggerLogLevel">
          ${debuggerLogLevelSelect}
        </select>
      </div>

      <div id="useExistingServerDiv" class="setting-div" onclick="check('useExistingServer')">
        <p>Use Existing Server:</p>
        <label class="container">Enable connection to running DAP Server.
          <input type="checkbox" id="useExistingServer" ${useExistingServer}>
          <span class="checkmark"></span>
        </label>
      </div>

      <div id="stopOnEntryDiv" class="setting-div" onclick="check('stopOnEntry')">
        <p>Stop On Entry:</p>
        <label class="container">Automatically stop after launch.
          <input type="checkbox" id="stopOnEntry" ${stopOnEntry}>
          <span class="checkmark"></span>
        </label>
      </div>

      <div id="traceDiv" class="setting-div" onclick="check('trace')">
        <p>Trace:</p>
        <label class="container">Enable logging of the Debug Adapter Protocol.
          <input type="checkbox" id="trace" ${trace}>
          <span class="checkmark"></span>
        </label>
      </div>

      <div id="daffodilDebugClasspathDiv" class="setting-div">
        <p>Daffodil Debugger Classpath:</p>
        <p class="setting-description">Additional classpaths to be added to the debugger:</p>

        ${daffodilDebugClasspathList}

        <p style="margin-left: 5px">
          <button id="daffodilDebugClasspathAddFolders" class="browse-button" type="button" onclick="filePicker('daffodilDebugClasspath', 'Select folder(s) with desired jars')">Add Folder(s)</button>
          <button id="daffodilDebugClasspathAddFiles" class="browse-button" type="button" onclick="filePicker('daffodilDebugClasspath', 'Select jar file(s)')">Add JAR File(s)</button>
        </p>
      </div>

      <div id="infosetFormatDiv" class="setting-div">
        <p>Infoset Format:</p>
        <p class="setting-description">Desired format of infoset ('xml' | 'json')</p>
        <select class="file-input" style="width: 200px;" id="infosetFormat">
          ${infosetFormatSelect}
        </select>
      </div>

      <div id="infosetOutputTypeDiv" class="setting-div">
        <p>Infoset Output Type:</p>
        <p class="setting-description">Destination for final Infoset (file | 'console' | 'none')</p>
        <select onChange="updateInfosetOutputType()" class="file-input" style="width: 200px;" id="infosetOutputType">
          ${infosetOutputTypeSelect}
        </select>

        <p id="infosetOutputFilePathLabel" style="${infosetPathVisOrHiddenStyle}" class="setting-description">
          Output Infoset Path: <input class="file-input" value="${infosetOutputPath}" id="infosetOutputFilePath"/>
        </p>
      </div>

      <div id="openDataEditorDiv" class="setting-div" onclick="check('openDataEditor')">
        <p>Open Data Editor:</p>
        <label class="container">Open data editor on debug start.
          <input type="checkbox" id="openDataEditor" ${openDataEditor}>
          <span class="checkmark"></span>
        </label>
      </div>

      <div id="openInfosetDiffViewDiv" class="setting-div" onclick="check('openInfosetDiffView')">
        <p>Open Infoset Diff View:</p>
        <label class="container">Open infoset diff on debug start.
          <input type="checkbox" id="openInfosetDiffView" ${openInfosetDiffView}>
          <span class="checkmark"></span>
        </label>
      </div>

      <div id="openInfosetViewDiv" class="setting-div" onclick="check('openInfosetView')">
        <p>Open Infoset View:</p>
        <label class="container">Open infoset view on debug start.
          <input type="checkbox" id="openInfosetView" ${openInfosetView}>
          <span class="checkmark"></span>
        </label>
      </div>

      <div id="tdmlActionDiv" class="setting-div">
        <p>TDML Action:</p>
        <p class="setting-description">TDML Action (${TDML_NONE_ACTION} | ${TDML_GENERATE_ACTION} | ${TDML_EXECUTE_ACTION})</p>
        <select onChange="updateTDMLAction()" class="file-input" style="width: 200px;" id="tdmlAction">
          ${tdmlActionSelect}
        </select>

        <p id="tdmlNameLabel" style="${tdmlNameDesVisOrHiddenStyle}" class="setting-description">TDML Name:</p>
        <input style="${tdmlNameDesVisOrHiddenStyle}" class="file-input" value="${tdmlName}" id="tdmlName">

        <p id="tdmlPathLabel" style="${tdmlPathVisOrHiddenStyle}" class="setting-description">TDML File Path:</p>
        <input style="${tdmlPathVisOrHiddenStyle}" class="file-input" value="${tdmlPath}" id="tdmlPath">
      </div>

      <div id="dataEditorDiv" class="setting-div">
        <p>Data Editor Settings:</p>
        
        <p id="dataEditorPortLabel" class="setting-description">omega-edit Port:</p>
        <input class="file-input" value="${dataEditor.port}" id="dataEditorPort">

        <p id="dataEditorLogFileLabel" style="margin-top: 10px;" class="setting-description">Log File:</p>
        <input class="file-input" value="${dataEditor.logging.file}" id="dataEditorLogFile">
        
        <p id="dataEditorLogLevelLabel" style="margin-top: 10px;" class="setting-description">Log Level:</p>
        <select class="file-input" style="width: 200px;" id="dataEditorLogLevel">
          ${dataEditorLogLevelSelect}
        </select>
      </div>

      <br/>
      <button class="save-button" type="button" onclick="save()">Save</button>
    </body>
  </html>`;
  }
  // Method to get nonce, helps with running custom script
  getNonce() {
    let text = "";
    const possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (let i = 0; i < 32; i++) {
      text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
  }
}
var CharLevelState = /* @__PURE__ */ ((CharLevelState2) => {
  CharLevelState2[CharLevelState2["init"] = 0] = "init";
  CharLevelState2[CharLevelState2["lB"] = 1] = "lB";
  CharLevelState2[CharLevelState2["rB"] = 2] = "rB";
  CharLevelState2[CharLevelState2["lC"] = 3] = "lC";
  CharLevelState2[CharLevelState2["rC"] = 4] = "rC";
  CharLevelState2[CharLevelState2["lSq"] = 5] = "lSq";
  CharLevelState2[CharLevelState2["rSq"] = 6] = "rSq";
  CharLevelState2[CharLevelState2["lDq"] = 7] = "lDq";
  CharLevelState2[CharLevelState2["rDq"] = 8] = "rDq";
  CharLevelState2[CharLevelState2["lBr"] = 9] = "lBr";
  CharLevelState2[CharLevelState2["rBr"] = 10] = "rBr";
  CharLevelState2[CharLevelState2["lPr"] = 11] = "lPr";
  CharLevelState2[CharLevelState2["rPr"] = 12] = "rPr";
  CharLevelState2[CharLevelState2["lWs"] = 13] = "lWs";
  CharLevelState2[CharLevelState2["escSq"] = 14] = "escSq";
  CharLevelState2[CharLevelState2["escDq"] = 15] = "escDq";
  CharLevelState2[CharLevelState2["sep"] = 16] = "sep";
  CharLevelState2[CharLevelState2["lUri"] = 17] = "lUri";
  CharLevelState2[CharLevelState2["rUri"] = 18] = "rUri";
  CharLevelState2[CharLevelState2["lNl"] = 19] = "lNl";
  CharLevelState2[CharLevelState2["rNl"] = 20] = "rNl";
  CharLevelState2[CharLevelState2["dSep"] = 21] = "dSep";
  CharLevelState2[CharLevelState2["lVar"] = 22] = "lVar";
  CharLevelState2[CharLevelState2["exp"] = 23] = "exp";
  CharLevelState2[CharLevelState2["lName"] = 24] = "lName";
  CharLevelState2[CharLevelState2["lAttr"] = 25] = "lAttr";
  CharLevelState2[CharLevelState2["dSep2"] = 26] = "dSep2";
  CharLevelState2[CharLevelState2["lEnt"] = 27] = "lEnt";
  CharLevelState2[CharLevelState2["rEnt"] = 28] = "rEnt";
  CharLevelState2[CharLevelState2["lSqEnt"] = 29] = "lSqEnt";
  CharLevelState2[CharLevelState2["rSqEnt"] = 30] = "rSqEnt";
  CharLevelState2[CharLevelState2["lDqEnt"] = 31] = "lDqEnt";
  CharLevelState2[CharLevelState2["rDqEnt"] = 32] = "rDqEnt";
  CharLevelState2[CharLevelState2["lLiteralSqEnt"] = 33] = "lLiteralSqEnt";
  CharLevelState2[CharLevelState2["rLiteralSqEnt"] = 34] = "rLiteralSqEnt";
  CharLevelState2[CharLevelState2["lLiteralDqEnt"] = 35] = "lLiteralDqEnt";
  CharLevelState2[CharLevelState2["rLiteralDqEnt"] = 36] = "rLiteralDqEnt";
  CharLevelState2[CharLevelState2["dot"] = 37] = "dot";
  return CharLevelState2;
})(CharLevelState || {});
var TokenLevelState = /* @__PURE__ */ ((TokenLevelState2) => {
  TokenLevelState2[TokenLevelState2["attributeNameTest"] = 0] = "attributeNameTest";
  TokenLevelState2[TokenLevelState2["comment"] = 1] = "comment";
  TokenLevelState2[TokenLevelState2["number"] = 2] = "number";
  TokenLevelState2[TokenLevelState2["Unset"] = 3] = "Unset";
  TokenLevelState2[TokenLevelState2["operator"] = 4] = "operator";
  TokenLevelState2[TokenLevelState2["variable"] = 5] = "variable";
  TokenLevelState2[TokenLevelState2["Whitespace"] = 6] = "Whitespace";
  TokenLevelState2[TokenLevelState2["string"] = 7] = "string";
  TokenLevelState2[TokenLevelState2["uriLiteral"] = 8] = "uriLiteral";
  TokenLevelState2[TokenLevelState2["nodeType"] = 9] = "nodeType";
  TokenLevelState2[TokenLevelState2["simpleType"] = 10] = "simpleType";
  TokenLevelState2[TokenLevelState2["axisName"] = 11] = "axisName";
  TokenLevelState2[TokenLevelState2["nodeNameTest"] = 12] = "nodeNameTest";
  TokenLevelState2[TokenLevelState2["functionNameTest"] = 13] = "functionNameTest";
  TokenLevelState2[TokenLevelState2["complexExpression"] = 14] = "complexExpression";
  TokenLevelState2[TokenLevelState2["function"] = 15] = "function";
  TokenLevelState2[TokenLevelState2["entityRef"] = 16] = "entityRef";
  TokenLevelState2[TokenLevelState2["anonymousFunction"] = 17] = "anonymousFunction";
  TokenLevelState2[TokenLevelState2["mapKey"] = 18] = "mapKey";
  return TokenLevelState2;
})(TokenLevelState || {});
var ExitCondition = /* @__PURE__ */ ((ExitCondition2) => {
  ExitCondition2[ExitCondition2["None"] = 0] = "None";
  ExitCondition2[ExitCondition2["SingleQuote"] = 1] = "SingleQuote";
  ExitCondition2[ExitCondition2["DoubleQuote"] = 2] = "DoubleQuote";
  ExitCondition2[ExitCondition2["CurlyBrace"] = 3] = "CurlyBrace";
  return ExitCondition2;
})(ExitCondition || {});
class Data {
  static {
    this.separators = [
      "!",
      "*",
      "+",
      ",",
      "-",
      ".",
      "/",
      ":",
      "<",
      "=",
      ">",
      "?",
      "|",
      "%"
    ];
  }
  static {
    this.doubleSeps = [
      "!=",
      "*:",
      "..",
      "//",
      "::",
      ":=",
      "->",
      "<<",
      "<=",
      "=>",
      ">=",
      ">>",
      "||",
      "!!",
      "??"
    ];
  }
  static {
    this.anySeps = [
      "=",
      ":",
      ".",
      "/",
      "=",
      "<",
      ">",
      "|",
      "!",
      "*",
      "+",
      ",",
      "-",
      ".",
      "?",
      "["
    ];
  }
  static {
    this.triggerWords = [
      "and",
      "andAlso",
      "array",
      "as",
      "div",
      "else",
      "eq",
      "except",
      "ge",
      "gt",
      "idiv",
      "if",
      "in",
      "intersect",
      "is",
      "le",
      "lt",
      "mod",
      "ne",
      "of",
      "or",
      "orElse",
      "otherwise",
      "return",
      "satisfies",
      "then",
      "to",
      "union",
      "&lt;",
      "&gt;"
    ];
  }
  static {
    this.axes = [
      "ancestor",
      "ancestor-or-self",
      "attribute",
      "child",
      "descendant",
      "descendant-or-self",
      "following",
      "following-sibling",
      "namespace",
      "parent",
      "preceding",
      "preceding-sibling",
      "self"
    ];
  }
  static {
    this.cAxes = [
      "ancestor",
      "ancestor-or-self",
      "descendant",
      "descendant-or-self",
      "following",
      "following-sibling",
      "parent",
      "preceding",
      "preceding-sibling",
      "self"
    ];
  }
  static {
    this.nodeTypes = [
      "attribute",
      "comment",
      "document-node",
      "element",
      "empty-sequence",
      "item",
      "namespace-node",
      "node",
      "processing-instruction",
      "schema-attribute",
      "schema-element",
      "text"
    ];
  }
  static {
    this.nodeTypesBrackets = Data.nodeTypes.map((t) => t + "()");
  }
  static {
    this.cNodeTypes = [
      "attribute",
      "comment",
      "element",
      "item",
      "namespace-node",
      "node",
      "processing-instruction",
      "text"
    ];
  }
  static {
    this.keywords = [
      "and",
      "andAlso",
      "array",
      "as",
      "div",
      "else",
      "eq",
      "except",
      "function",
      "ge",
      "gt",
      "idiv",
      "if",
      "in",
      "intersect",
      "is",
      "le",
      "lt",
      "map",
      "mod",
      "ne",
      "of",
      "or",
      "orElse",
      "otherwise",
      "return",
      "satisfies",
      "then",
      "to",
      "treat",
      "union",
      "&lt;",
      "&gt;"
    ];
  }
  static {
    this.rangeVars = ["every", "for", "let", "member", "some", "return"];
  }
  static {
    this.firstParts = ["cast", "castable", "instance", "treat"];
  }
  static {
    this.secondParts = ["as", "of"];
  }
  static {
    this.nonFunctionConditional = ["if", "then", "else"];
  }
  static {
    this.nonFunctionTypes = [
      "map",
      "array",
      "function",
      "enum",
      "union",
      "record"
    ];
  }
  static {
    this.nonFunctionTypesBrackets = Data.nonFunctionTypes.map(
      (t) => t + "(*)"
    );
  }
  static setAsOperatorIfKeyword(token) {
    if (token.value === "return" || token.value === "satisfies" || token.value === "in" || Data.nonFunctionConditional.indexOf(token.value) > -1) {
      token.tokenType = 14;
    } else if (Data.keywords.indexOf(token.value) > -1) {
      token.tokenType = 4;
    } else ;
  }
  static isPart2andMatchesPart1(part1Token, part2Token) {
    let p1 = part1Token.value;
    let p2 = part2Token.value;
    let isPart2;
    let matchesPart1;
    switch (p2) {
      case "else":
        isPart2 = true;
        matchesPart1 = p1 === "then";
        break;
      case ",":
        matchesPart1 = p1 === "in" || p1 === ":=";
        isPart2 = p1 === "then";
        break;
      default:
        isPart2 = false;
        matchesPart1 = false;
        break;
    }
    return [isPart2, matchesPart1];
  }
}
class XPathLexer {
  constructor() {
    this.debug = false;
    this.timerOn = false;
    this.entityRefOn = true;
    this.documentText = "";
    this.documentTokens = [];
    this.latestRealToken = null;
    this.lineNumber = 0;
    this.wsCharNumber = 0;
    this.tokenCharNumber = 0;
    this.wsNewLine = false;
    this.deferWsNewLine = false;
  }
  reset() {
    this.documentText = "";
    this.documentTokens = [];
    this.attributeNameTests = void 0;
    this.elementNameTests = void 0;
    this.latestRealToken = null;
    this.lineNumber = 0;
    this.wsCharNumber = 0;
    this.tokenCharNumber = 0;
    this.wsNewLine = false;
    this.deferWsNewLine = false;
  }
  static getTextmateTypeLegend() {
    let textmateTypes = [];
    let keyCount = Object.keys(TokenLevelState).length / 2;
    for (let i = 0; i < keyCount; i++) {
      textmateTypes.push(TokenLevelState[i]);
    }
    return textmateTypes;
  }
  static isPartOperator(firstPart, secondPart) {
    let result = false;
    switch (firstPart) {
      case "cast":
      case "castable":
      case "treat":
        result = secondPart === "as";
        break;
      case "instance":
        result = secondPart === "of";
        break;
    }
    return result;
  }
  calcNewState(isFirstChar, nesting, char, nextChar, existing) {
    let rv;
    let firstCharOfToken = true;
    switch (existing) {
      case 19:
        let charCode = char.charCodeAt(0);
        let nextCharCode = nextChar ? nextChar.charCodeAt(0) : -1;
        if (XPathLexer.isDigit(charCode) || char === ".") {
          rv = existing;
        } else if (char === "e" || char === "E") {
          if (nextChar === "-" || nextChar === "+" || XPathLexer.isDigit(nextCharCode)) {
            rv = 23;
          } else {
            rv = existing;
          }
        } else {
          ({ rv, nesting } = this.testChar(
            existing,
            firstCharOfToken,
            char,
            nextChar,
            nesting
          ));
        }
        break;
      case 23:
        rv = 19;
        break;
      case 32:
        rv = existing;
        switch (nesting) {
          case 0:
          case 2:
            nesting++;
            break;
          case 1:
            if (char === "u" && nextChar === "o") {
              nesting++;
            } else {
              nesting = 0;
              rv = 31;
            }
            break;
          case 3:
            if (char === "t") {
              nesting++;
            } else {
              rv = 31;
              nesting = 0;
            }
            break;
          case 4:
            if (char === ";") {
              rv = 8;
            } else {
              rv = 31;
            }
            nesting = 0;
            break;
        }
        break;
      case 30:
        rv = existing;
        switch (nesting) {
          case 0:
          case 2:
            nesting++;
            break;
          case 1:
            if (char === "p" && nextChar === "o") {
              nesting++;
            } else {
              nesting = 0;
              rv = 29;
            }
            break;
          case 3:
            if (char === "s") {
              nesting++;
            } else {
              rv = 29;
              nesting = 0;
            }
            break;
          case 4:
            if (char === ";") {
              rv = 6;
            } else {
              rv = 29;
            }
            nesting = 0;
            break;
        }
        break;
      case 13:
        if (char === " " || char === "	") {
          rv = existing;
          this.wsCharNumber++;
        } else if (char === "\n") {
          rv = existing;
          this.wsCharNumber = 0;
          this.wsNewLine = true;
          this.lineNumber++;
        } else {
          ({ rv, nesting } = this.testChar(
            existing,
            firstCharOfToken,
            char,
            nextChar,
            nesting
          ));
        }
        break;
      case 24:
      case 22:
      case 25:
        if (char === "-" || char === "." || char === ":" && !(nextChar === ":" || nextChar === "*" || nextChar === " " || nextChar === "\n" || nextChar === "\r" || nextChar === "	")) {
          rv = existing;
        } else {
          ({ rv, nesting } = this.testChar(
            existing,
            isFirstChar,
            char,
            nextChar,
            nesting
          ));
        }
        break;
      case 21:
        rv = 26;
        break;
      case 17:
        rv = char === "}" ? 18 : existing;
        break;
      case 29:
        rv = char === "&" && nextChar === "a" ? 30 : existing;
        break;
      case 31:
        rv = char === "&" && nextChar === "q" ? 32 : existing;
        break;
      case 5:
      case 34:
        if (char === "'") {
          if (nextChar === "'") {
            rv = 14;
          } else {
            rv = 6;
          }
        } else if (char === "&") {
          rv = 33;
        } else {
          rv = 5;
        }
        break;
      case 33:
        if (char === "'") {
          if (nextChar === "'") {
            rv = 14;
          } else {
            rv = 6;
          }
        } else if (char === ";") {
          rv = 34;
        } else {
          rv = existing;
        }
        break;
      case 14:
        rv = 5;
        break;
      case 15:
        rv = 7;
        break;
      case 7:
      case 36:
        if (char === '"') {
          if (nextChar === '"') {
            rv = 15;
          } else {
            rv = 8;
          }
        } else if (char === "&") {
          rv = 35;
        } else {
          rv = 7;
        }
        break;
      case 35:
        if (char === '"') {
          if (nextChar === '"') {
            rv = 15;
          } else {
            rv = 8;
          }
        } else if (char === ";") {
          rv = 36;
        } else {
          rv = existing;
        }
        break;
      case 3:
        if (char === ":" && nextChar === ")") {
          rv = nesting === 1 ? 4 : existing;
          nesting--;
        } else if (char === "(" && nextChar === ":") {
          rv = existing;
          nesting++;
        } else {
          rv = existing;
        }
        break;
      case 27:
        rv = char === ";" ? 28 : existing;
        break;
      default:
        ({ rv, nesting } = this.testChar(
          existing,
          isFirstChar,
          char,
          nextChar,
          nesting
        ));
    }
    return [rv, nesting];
  }
  analyse(xpathArg, exitCondition, position) {
    if (this.timerOn) {
      console.time("xplexer.analyse");
    }
    this.latestRealToken = null;
    this.lineNumber = position.line;
    this.wsCharNumber = 0;
    this.tokenCharNumber = position.startCharacter;
    this.wsNewLine = false;
    this.deferWsNewLine = false;
    let xpath = xpathArg.length === 0 ? this.documentText : xpathArg;
    let currentState = [0, 0];
    let currentChar = "";
    let tokenChars = [];
    if (exitCondition === 0) {
      this.documentTokens.length = 0;
    }
    let result = this.documentTokens;
    let nestedTokenStack = [];
    let poppedContext = null;
    if (xpath.length === 0) {
      return [];
    }
    for (let i = position.documentOffset; i < xpath.length + 1; i++) {
      let nextChar = xpath.charAt(i);
      let [currentLabelState, nestingState] = currentState;
      let nextState;
      let isFirstTokenChar = tokenChars.length === 0;
      if (currentChar) {
        let exitAnalysis = false;
        switch (exitCondition) {
          case 0:
            exitAnalysis = false;
            break;
          case 3:
            if (currentLabelState !== 7 && currentLabelState !== 5 && currentLabelState !== 3 && currentChar === "}") {
              let isNestedOk = false;
              for (var x = 0; x < nestedTokenStack.length; x++) {
                if (nestedTokenStack[x].value === "{") {
                  isNestedOk = true;
                  break;
                }
              }
              exitAnalysis = !isNestedOk;
            }
            break;
          case 2:
            exitAnalysis = currentChar === '"';
            break;
          case 1:
            exitAnalysis = currentChar === "'";
            break;
        }
        if (exitAnalysis) {
          this.update(poppedContext, result, tokenChars, currentLabelState);
          if (result.length > 0) {
            let lastToken = result[result.length - 1];
            if (lastToken.tokenType === 7) {
              XPathLexer.checkExitStringLiteralEnd(lastToken, result);
            } else if (lastToken.tokenType === 16) {
              if (result.length > 1) {
                const nextLastToken = result[result.length - 2];
                if (nextLastToken.tokenType === 7) {
                  if (!lastToken.value.endsWith("&quot;") && !lastToken.value.startsWith("&apos;")) {
                    lastToken["error"] = 21;
                  }
                }
              }
            }
          }
          position.line = this.lineNumber;
          position.startCharacter = this.tokenCharNumber;
          position.documentOffset = i;
          return result;
        }
        nextState = this.calcNewState(
          isFirstTokenChar,
          nestingState,
          currentChar,
          nextChar,
          currentLabelState
        );
        let [nextLabelState] = nextState;
        if (nextLabelState === currentLabelState && !this.unChangedStateSignificant(currentLabelState) || currentLabelState === 23 && nextLabelState === 19) {
          if (currentChar === "\n" && (currentLabelState === 5 || currentLabelState === 7 || currentLabelState === 3 || currentLabelState === 29 || currentLabelState === 31)) {
            this.update(poppedContext, result, tokenChars, currentLabelState);
            this.lineNumber++;
            this.tokenCharNumber = 0;
          } else {
            tokenChars.push(currentChar);
          }
        } else {
          switch (nextLabelState) {
            case 19:
            case 22:
            case 24:
            case 27:
            case 33:
            case 35:
              this.update(poppedContext, result, tokenChars, currentLabelState);
              tokenChars = [];
              tokenChars.push(currentChar);
              break;
            case 23:
            case 30:
            case 32:
              tokenChars.push(currentChar);
              break;
            case 21:
              this.update(poppedContext, result, tokenChars, currentLabelState);
              let bothChars = currentChar + nextChar;
              this.updateResult(
                poppedContext,
                result,
                new BasicToken(bothChars, nextLabelState)
              );
              break;
            case 26:
              break;
            case 16:
            case 37:
              this.update(poppedContext, result, tokenChars, currentLabelState);
              this.updateResult(
                poppedContext,
                result,
                new BasicToken(currentChar, nextLabelState)
              );
              break;
            case 14:
            case 15:
              tokenChars.push(currentChar);
              break;
            case 4:
              tokenChars.push(":)");
              this.update(poppedContext, result, tokenChars, currentLabelState);
              break;
            case 1:
            case 9:
            case 11:
              this.update(poppedContext, result, tokenChars, currentLabelState);
              let currentToken;
              currentToken = new FlattenedToken(
                currentChar,
                nextLabelState,
                this.latestRealToken
              );
              this.updateResult(poppedContext, result, currentToken);
              nestedTokenStack.push(currentToken);
              this.latestRealToken = null;
              break;
            case 2:
            case 10:
            case 12:
              if (currentLabelState !== 4) {
                let prevToken = new BasicToken(
                  tokenChars.join(""),
                  currentLabelState
                );
                this.updateResult(poppedContext, result, prevToken);
                let newToken = new BasicToken(
                  currentChar,
                  nextLabelState
                );
                this.updateResult(poppedContext, result, newToken);
                if (nestedTokenStack.length > 0) {
                  if (XPathLexer.closeMatchesOpen(
                    nextLabelState,
                    nestedTokenStack
                  )) {
                    poppedContext = nestedTokenStack.pop()?.context;
                  } else {
                    newToken["error"] = 22;
                  }
                } else {
                  newToken["error"] = 22;
                }
                tokenChars = [];
              }
              break;
            case 28:
              tokenChars.push(currentChar);
              let ent = tokenChars.join("");
              if (ent === "&quot;") {
                nextState = [31, 0];
              } else if (ent === "&apos;") {
                nextState = [29, 0];
              } else {
                let entToken = new BasicToken(
                  ent,
                  24
                  /* lName */
                );
                this.updateResult(poppedContext, result, entToken);
                tokenChars.length = 0;
              }
              break;
            case 6:
            case 8:
            case 18:
            case 34:
            case 36:
              tokenChars.push(currentChar);
              this.update(poppedContext, result, tokenChars, currentLabelState);
              break;
            case 5:
            case 7:
            case 3:
            case 13:
            case 17:
              if (currentLabelState !== 14 && currentLabelState !== 15) {
                this.update(
                  poppedContext,
                  result,
                  tokenChars,
                  currentLabelState
                );
              }
              tokenChars.push(currentChar);
              break;
            default:
              if (currentLabelState === 4) {
                tokenChars = [];
              } else if (currentLabelState === 13) {
                this.update(
                  poppedContext,
                  result,
                  tokenChars,
                  currentLabelState
                );
                tokenChars.push(currentChar);
              } else {
                tokenChars.push(currentChar);
              }
              break;
          }
        }
        if (!nextChar && tokenChars.length > 0) {
          this.update(poppedContext, result, tokenChars, nextLabelState);
        }
        currentState = nextState;
      }
      currentChar = nextChar;
    }
    if (this.timerOn) {
      console.timeEnd("xplexer.analyse");
    }
    return result;
  }
  static checkExitStringLiteralEnd(lastToken, result) {
    let followsEntityRef = false;
    let followsString = false;
    if (result.length > 1) {
      const nextLastToken = result[result.length - 2];
      followsEntityRef = nextLastToken.tokenType === 16;
      followsString = nextLastToken.tokenType === 7;
    }
    if (followsEntityRef) {
      let lastChar = lastToken.value.charAt(lastToken.value.length - 1);
      const lastCharIsSingleQuote = lastChar === "'";
      if (lastChar !== '"' && !lastCharIsSingleQuote && !lastToken.value.endsWith("&quot;") && !lastToken.value.startsWith("&apos;")) {
        lastToken["error"] = 21;
      } else if (lastChar === '"' || lastChar === "'" && lastToken.length > 1) {
        const mod2Chars = [...lastToken.value].filter((l) => l === lastChar).length % 2;
        if (mod2Chars === 0) {
          lastToken["error"] = 21;
        }
      }
    } else if (!followsString) {
      this.checkStringLiteralEnd(lastToken);
    }
  }
  static checkStringLiteralEnd(lastToken) {
    let lastChar = lastToken.value.charAt(lastToken.value.length - 1);
    let firstChar = lastToken.value.charAt(0);
    if (!(lastChar === firstChar && lastToken.value.length > 1 || lastToken.value.length > 6 && lastToken.value.startsWith("&quot;") && lastToken.value.endsWith("&quot;") || lastToken.value.startsWith("&apos;") && lastToken.value.endsWith("&apos;"))) {
      lastToken["error"] = 21;
    }
  }
  static closeMatchesOpen(close, stack) {
    let open = stack[stack.length - 1].charType;
    let result = false;
    switch (close) {
      case 2:
        result = open === 1;
        break;
      case 10:
        result = open === 9;
        break;
      case 12:
        result = open === 11;
    }
    return result;
  }
  update(poppedContext, result, tokenChars, charState) {
    if (tokenChars.length > 0) {
      this.updateResult(
        poppedContext,
        result,
        new BasicToken(tokenChars.join(""), charState)
      );
    }
    tokenChars.length = 0;
  }
  unChangedStateSignificant(charState) {
    let result = false;
    switch (charState) {
      case 1:
      case 9:
      case 11:
      case 2:
      case 10:
      case 12:
      case 16:
      case 37:
        result = true;
    }
    return result;
  }
  updateResult(poppedContext, result, newToken) {
    this.latestRealToken;
    let state = newToken.charType;
    let newTokenValue = newToken.value;
    if (newTokenValue !== "") {
      newToken.length = newTokenValue.length;
      newToken.line = this.lineNumber;
      newToken.startCharacter = this.tokenCharNumber;
      if (newToken.tokenType === 12) {
        if (newTokenValue.includes("#")) {
          newToken.tokenType = 13;
        }
      }
      let isWhitespace = newToken.charType === 13;
      if (this.deferWsNewLine) {
        if (isWhitespace) {
          this.lineNumber++;
          newToken.line = this.lineNumber;
          this.tokenCharNumber = this.wsCharNumber;
        } else {
          this.tokenCharNumber = 0;
          this.lineNumber++;
          this.wsNewLine = true;
        }
        this.deferWsNewLine = false;
      } else if (this.wsNewLine) {
        if (isWhitespace) {
          this.tokenCharNumber = this.wsCharNumber;
        } else {
          this.tokenCharNumber += newTokenValue.length;
        }
        this.wsNewLine = false;
      } else {
        this.tokenCharNumber += newTokenValue.length;
      }
      if (!isWhitespace) {
        this.wsCharNumber = 0;
      }
      if (!isWhitespace) {
        result.push(newToken);
      }
      let prevToken = this.latestRealToken;
      this.setLabelForLastTokenOnly(prevToken, newToken);
      this.setLabelsUsingCurrentToken(poppedContext, prevToken, newToken);
      if (prevToken && !isWhitespace && this.elementNameTests && this.attributeNameTests) {
        if (prevToken.tokenType === 12) {
          if (this.elementNameTests.indexOf(prevToken.value) < 0) {
            this.elementNameTests.push(prevToken.value);
          }
        } else if (prevToken.tokenType === 0) {
          if (this.attributeNameTests.indexOf(prevToken.value) < 0) {
            this.attributeNameTests.push(prevToken.value);
          }
        }
      }
      if (!(state === 3 || state === 13)) {
        this.latestRealToken = newToken;
      }
    }
  }
  /*    private conditionallyPopStack(stack: Token[], token: Token) {
        if (stack.length > 0) {
            let [isPart2, matchesPart1] = Data.isPart2andMatchesPart1(stack[stack.length - 1], token);
            const initStackVal = stack.length > 0 ? stack[stack.length - 1].value : '';
            if ((initStackVal === 'return' || initStackVal === 'satisfies') && token.value === ',') {
                stack.pop();
                let validStackValue : any = null;
                let init = true;
                while (stack.length > 0) {
                    if (init) {
                        init = false;
                        let v = stack[stack.length - 1].value;
                        if (v === ':=' || v === 'in') {
                            validStackValue = v;
                            stack.pop();
                        }
                    } else if (stack[stack.length - 1].value === validStackValue) {
                        stack.pop();
                    } else {
                        break;
                    }
                }
            } else if (isPart2) { if (matchesPart1) { stack.pop(); } else token['error'] = ErrorType.XPathUnexpected; }
        }
    } */
  updateTokenBeforeBrackets(prevToken) {
    if (prevToken.tokenType === 12) {
      if (Data.nodeTypes.indexOf(prevToken.value) > -1) {
        prevToken.tokenType = 9;
      } else if (Data.nonFunctionConditional.indexOf(prevToken.value) > -1) {
        prevToken.tokenType = 14;
      } else if (prevToken.value === "function") {
        prevToken.tokenType = 17;
      } else if (prevToken.value === "map" || prevToken.value === "array") {
        prevToken.tokenType = 10;
      } else {
        prevToken.tokenType = 15;
      }
    } else if (prevToken.tokenType === 10 && Data.nodeTypes.indexOf(prevToken.value) > -1) {
      prevToken.tokenType = 9;
    }
  }
  setLabelForLastTokenOnly(prevToken, currentToken) {
    let currentState = currentToken.charType;
    if (prevToken) {
      if (prevToken.charType === 24) {
        switch (currentState) {
          case 22:
            if (Data.rangeVars.indexOf(prevToken.value) > -1) {
              prevToken.tokenType = 14;
            }
            break;
          case 1:
            this.updateTokenBeforeBrackets(prevToken);
            break;
          case 21:
            if (currentToken.value === "::") {
              if (Data.axes.indexOf(prevToken.value) < 0) {
                prevToken["error"] = 1;
              }
              prevToken.tokenType = 11;
            } else if (currentToken.value === "()") {
              this.updateTokenBeforeBrackets(prevToken);
            } else if (currentToken.value === "{}" && (prevToken.value === "map" || prevToken.value === "array")) {
              prevToken.tokenType = 4;
            }
            break;
          case 9:
            if (prevToken.value === "map" || prevToken.value === "array") {
              prevToken.tokenType = 4;
            }
            break;
          case 24:
            if (currentToken.value === "member" && prevToken.value === "for") {
              prevToken.tokenType = 14;
            }
            break;
        }
      } else if (currentState === 16 && prevToken.tokenType === 7 && currentToken.value === ":") {
        prevToken.tokenType = 18;
      } else if ((currentState === 1 || currentState === 9) && prevToken.charType === 21 && prevToken.value === "->") {
        prevToken.tokenType = 17;
      }
    }
  }
  setLabelsUsingCurrentToken(poppedContext, prevToken, currentToken) {
    if (!prevToken) {
      prevToken = new BasicToken(
        ",",
        16
        /* sep */
      );
      prevToken.tokenType = 4;
    }
    let currentValue = currentToken.value;
    switch (currentToken.charType) {
      case 24:
        switch (prevToken.charType) {
          case 24:
            if (Data.secondParts.indexOf(currentValue) > -1 && XPathLexer.isPartOperator(prevToken.value, currentValue)) {
              prevToken.tokenType = 4;
              currentToken.tokenType = 4;
            } else if (XPathLexer.isTokenTypeEqual(
              prevToken,
              4
              /* operator */
            )) {
              if (prevToken.value === "as" || prevToken.value === "of") {
                currentToken.tokenType = 10;
              } else if (prevToken.value === "&gt;" && currentToken.value === "&gt;") {
                currentToken.tokenType = 4;
              } else if (prevToken.value === "&lt;" && (currentToken.value === "&lt;" || currentToken.value === "&gt;")) {
                currentToken.tokenType = 4;
              }
            } else if (prevToken.tokenType === 12 || prevToken.tokenType === 13 || XPathLexer.isTokenTypeAType(prevToken)) {
              Data.setAsOperatorIfKeyword(currentToken);
            }
            break;
          case 2:
          case 10:
          case 12:
          case 25:
          case 19:
          case 22:
          case 5:
          case 7:
          case 34:
          case 36:
          case 32:
          case 30:
          case 37:
            Data.setAsOperatorIfKeyword(currentToken);
            break;
          case 21:
            if (prevToken.value === "()" || prevToken.value === ".." || prevToken.value === "[]" || prevToken.value === "{}") {
              Data.setAsOperatorIfKeyword(currentToken);
            }
            break;
          default:
            if (XPathLexer.isTokenTypeUnset(prevToken) && Data.keywords.indexOf(currentValue) > -1) {
              currentToken.tokenType = 4;
            } else if (XPathLexer.isCharTypeEqual(
              prevToken,
              21
              /* dSep */
            ) && prevToken.value === "()" && Data.keywords.indexOf(currentValue) > -1) {
              currentToken.tokenType = 4;
            } else if (XPathLexer.isTokenTypeEqual(
              prevToken,
              4
              /* operator */
            ) && (prevToken.value === "as" || prevToken.value === "of")) {
              currentToken.tokenType = 10;
            }
            break;
        }
        break;
      case 16:
        let prevTokenT = prevToken.tokenType;
        let isStar = currentToken.value === "*";
        if (isStar && (prevTokenT === 0 || prevTokenT === 8 || prevTokenT === 4 && prevToken.value === "?" || prevTokenT === 9 && prevToken.value === "()")) {
          currentToken.charType = 24;
          currentToken.tokenType = 9;
        } else {
          let possOccurrentIndicator = currentToken.value === "?" || currentToken.value === "+" || isStar;
          if (possOccurrentIndicator) {
            if (prevTokenT === 10 && prevToken.length > 1) {
              currentToken.charType = 24;
              currentToken.tokenType = 10;
            } else if (prevTokenT === 4 && prevToken.value === ")" || prevToken.value === "]") {
              if (poppedContext && poppedContext.tokenType === 10) {
                currentToken.charType = 24;
                currentToken.tokenType = 9;
              }
            } else if (isStar && (prevTokenT === 4 || prevTokenT === 14)) {
              if (prevTokenT === 4 && prevToken.charType === 21 && prevToken.value === "()") ;
              else {
                currentToken.charType = 24;
                currentToken.tokenType = 9;
              }
            }
          }
        }
        break;
      case 21:
        if (currentToken.value === ":*" || currentToken.value === "..") {
          currentToken.charType = 24;
          currentToken.tokenType = 9;
        } else if (currentToken.value === "()" && prevToken.tokenType === 9) {
          currentToken.charType = 24;
          currentToken.tokenType = 9;
        }
        break;
    }
  }
  testChar(existingState, isFirstChar, char, nextChar, nesting) {
    let rv;
    if (isFirstChar && char === "Q" && nextChar === "{") {
      rv = 17;
      return { rv, nesting };
    }
    switch (char) {
      case "(":
        if (nextChar === ":") {
          rv = 3;
          nesting++;
        } else if (nextChar == ")") {
          rv = 21;
        } else {
          rv = 1;
        }
        break;
      case "{":
        if (nextChar === "}") {
          rv = 21;
        } else {
          rv = 9;
        }
        break;
      case "[":
        if (nextChar === "]") {
          rv = 21;
        } else {
          rv = 11;
        }
        break;
      case ")":
        rv = 2;
        break;
      case "]":
        rv = 12;
        break;
      case "}":
        rv = 10;
        break;
      case "'":
        rv = 5;
        break;
      case '"':
        rv = 7;
        break;
      case " ":
      case "	":
        rv = 13;
        this.wsCharNumber++;
        break;
      case "\r":
        rv = 13;
        break;
      case "\n":
        this.deferWsNewLine = true;
        rv = 13;
        break;
      case "+":
        rv = 16;
        break;
      case "&":
        rv = this.entityRefOn ? 27 : existingState;
        break;
      default:
        let doubleChar = char + nextChar;
        if (nextChar && Data.doubleSeps.indexOf(doubleChar) > -1) {
          rv = 21;
          break;
        } else if (Data.separators.indexOf(char) > -1) {
          let isDot = char === ".";
          if (isDot && !!nextChar && XPathLexer.isDigit(nextChar.charCodeAt(0))) {
            rv = 19;
          } else if (isDot) {
            rv = 37;
          } else {
            rv = 16;
          }
        } else if (isFirstChar) {
          let charCode = char.charCodeAt(0);
          let nextCharCode = nextChar ? nextChar.charCodeAt(0) : -1;
          if (charCode === 46) {
            if (nextCharCode === 46) {
              rv = 21;
            } else {
              rv = XPathLexer.isDigit(nextCharCode) ? 19 : 37;
            }
          } else if (XPathLexer.isDigit(charCode)) {
            rv = 19;
          } else if (char === "$") {
            rv = 22;
          } else if (char === "@") {
            rv = 25;
          } else {
            rv = 24;
          }
        } else {
          rv = existingState;
        }
    }
    return { rv, nesting };
  }
  static isDigit(charCode) {
    return charCode > 47 && charCode < 58;
  }
  static isCharTypeEqual(token, type2) {
    return token ? token.charType === type2 : false;
  }
  static isTokenTypeEqual(token, type2) {
    return token.tokenType === type2;
  }
  static isTokenTypeAType(token) {
    return token.tokenType === 10 || token.tokenType === 9;
  }
  static isTokenTypeUnset(token) {
    return token.tokenType.valueOf() === 3 .valueOf();
  }
}
var ErrorType = /* @__PURE__ */ ((ErrorType2) => {
  ErrorType2[ErrorType2["None"] = 0] = "None";
  ErrorType2[ErrorType2["AxisName"] = 1] = "AxisName";
  ErrorType2[ErrorType2["DuplicateVarName"] = 2] = "DuplicateVarName";
  ErrorType2[ErrorType2["DuplicateFnName"] = 3] = "DuplicateFnName";
  ErrorType2[ErrorType2["DuplicateParameterName"] = 4] = "DuplicateParameterName";
  ErrorType2[ErrorType2["DuplicateTemplateName"] = 5] = "DuplicateTemplateName";
  ErrorType2[ErrorType2["DuplicateAccumulatorName"] = 6] = "DuplicateAccumulatorName";
  ErrorType2[ErrorType2["ElementNesting"] = 7] = "ElementNesting";
  ErrorType2[ErrorType2["XPathTypeName"] = 8] = "XPathTypeName";
  ErrorType2[ErrorType2["AccumulatorNameUnresolved"] = 9] = "AccumulatorNameUnresolved";
  ErrorType2[ErrorType2["XPathName"] = 10] = "XPathName";
  ErrorType2[ErrorType2["EntityName"] = 11] = "EntityName";
  ErrorType2[ErrorType2["XPathFunction"] = 12] = "XPathFunction";
  ErrorType2[ErrorType2["XPathFunctionNamespace"] = 13] = "XPathFunctionNamespace";
  ErrorType2[ErrorType2["XPathFunctionUnexpected"] = 14] = "XPathFunctionUnexpected";
  ErrorType2[ErrorType2["XPathOperatorUnexpected"] = 15] = "XPathOperatorUnexpected";
  ErrorType2[ErrorType2["XPathPrefix"] = 16] = "XPathPrefix";
  ErrorType2[ErrorType2["XPathKeyword"] = 17] = "XPathKeyword";
  ErrorType2[ErrorType2["XPathExpectedComplex"] = 18] = "XPathExpectedComplex";
  ErrorType2[ErrorType2["XPathUnexpected"] = 19] = "XPathUnexpected";
  ErrorType2[ErrorType2["XPathAwaiting"] = 20] = "XPathAwaiting";
  ErrorType2[ErrorType2["XPathStringLiteral"] = 21] = "XPathStringLiteral";
  ErrorType2[ErrorType2["BracketNesting"] = 22] = "BracketNesting";
  ErrorType2[ErrorType2["ExpectedElseAfterThen"] = 23] = "ExpectedElseAfterThen";
  ErrorType2[ErrorType2["ExpectedDollarAfterComma"] = 24] = "ExpectedDollarAfterComma";
  ErrorType2[ErrorType2["XSLTKeyUnresolved"] = 25] = "XSLTKeyUnresolved";
  return ErrorType2;
})(ErrorType || {});
class BasicToken {
  constructor(value, type) {
    this.line = 0;
    this.startCharacter = 0;
    this.length = 0;
    this.value = value;
    this.charType = type;
    switch (type) {
      case 13:
        this.tokenType = 6;
        break;
      case 24:
        this.tokenType = 12;
        break;
      case 21:
        this.tokenType = value === ":=" ? 14 : 4;
        break;
      case 37:
        this.tokenType = 9;
        break;
      case 16:
      case 1:
      case 9:
      case 11:
      case 2:
      case 10:
      case 12:
        this.tokenType = 4;
        break;
      case 25:
        this.tokenType = 0;
        break;
      case 19:
        this.tokenType = 2;
        break;
      case 22:
        this.tokenType = 5;
        break;
      case 5:
      case 7:
      case 29:
      case 31:
      case 32:
      case 30:
      case 34:
      case 36:
        this.tokenType = 7;
        break;
      case 17:
        this.tokenType = 8;
        break;
      case 3:
        this.tokenType = 1;
        break;
      case 33:
      case 35:
        this.tokenType = 16;
        break;
      default:
        this.tokenType = 3;
        break;
    }
  }
}
class FlattenedToken {
  constructor(value, type, context) {
    this.line = 0;
    this.startCharacter = 0;
    this.length = 0;
    this.value = value;
    this.charType = type;
    this.tokenType = 4;
    this.context = context;
  }
}
var XSLTokenLevelState = /* @__PURE__ */ ((XSLTokenLevelState2) => {
  XSLTokenLevelState2[XSLTokenLevelState2["attributeName"] = 0] = "attributeName";
  XSLTokenLevelState2[XSLTokenLevelState2["attributeEquals"] = 1] = "attributeEquals";
  XSLTokenLevelState2[XSLTokenLevelState2["attributeValue"] = 2] = "attributeValue";
  XSLTokenLevelState2[XSLTokenLevelState2["xmlnsName"] = 3] = "xmlnsName";
  XSLTokenLevelState2[XSLTokenLevelState2["dtd"] = 4] = "dtd";
  XSLTokenLevelState2[XSLTokenLevelState2["dtdEnd"] = 5] = "dtdEnd";
  XSLTokenLevelState2[XSLTokenLevelState2["elementName"] = 6] = "elementName";
  XSLTokenLevelState2[XSLTokenLevelState2["elementValue"] = 7] = "elementValue";
  XSLTokenLevelState2[XSLTokenLevelState2["processingInstrName"] = 8] = "processingInstrName";
  XSLTokenLevelState2[XSLTokenLevelState2["processingInstrValue"] = 9] = "processingInstrValue";
  XSLTokenLevelState2[XSLTokenLevelState2["entityRef"] = 10] = "entityRef";
  XSLTokenLevelState2[XSLTokenLevelState2["xmlComment"] = 11] = "xmlComment";
  XSLTokenLevelState2[XSLTokenLevelState2["xmlPunctuation"] = 12] = "xmlPunctuation";
  XSLTokenLevelState2[XSLTokenLevelState2["xslElementName"] = 13] = "xslElementName";
  XSLTokenLevelState2[XSLTokenLevelState2["xmlText"] = 14] = "xmlText";
  return XSLTokenLevelState2;
})(XSLTokenLevelState || {});
class XslLexer {
  constructor(languageConfiguration) {
    this.debug = false;
    this.flatten = false;
    this.timerOn = false;
    this.provideCharLevelState = false;
    this.globalInstructionData = [];
    this.globalModeData = [];
    this.lineNumber = 0;
    this.charCount = 0;
    this.lineCharCount = 0;
    this.commentCharCount = 0;
    this.cdataCharCount = 0;
    this.entityContext = 0;
    this.skipTokenChar = false;
    this.nativeTvtAttributes = [];
    this.genericTvtAttributes = [];
    this.nativePrefixLength = 0;
    this.dtdNesting = 0;
    this.nonNativeAvts = false;
    this.nonNativeAvts = languageConfiguration.nonNativeAvts;
    this.nativePrefixLength = languageConfiguration.nativePrefix.length === 0 ? 0 : languageConfiguration.nativePrefix.length + 1;
    this.languageConfiguration = languageConfiguration;
    this.languageConfiguration.tvtAttributes.forEach((tvtAttribute) => {
      this.nativeTvtAttributes.push(
        this.languageConfiguration.nativePrefix + ":" + tvtAttribute
      );
    });
    this.genericTvtAttributes = this.languageConfiguration.tvtAttributes;
  }
  static {
    this.xpathLegend = XPathLexer.getTextmateTypeLegend();
  }
  static {
    this.xpathLegendLength = XslLexer.xpathLegend.length;
  }
  static getTextmateTypeLegend() {
    let textmateTypes = this.xpathLegend.slice(0);
    let keyCount = Object.keys(XSLTokenLevelState).length / 2;
    for (let i = 0; i < keyCount; i++) {
      textmateTypes.push(XSLTokenLevelState[i]);
    }
    return textmateTypes;
  }
  static getXsltStartTokenNumber() {
    return this.xpathLegend.length;
  }
  isWhitespace(isCurrentCharNewLine, char) {
    return isCurrentCharNewLine || char === " " || char == "	" || char === "\r";
  }
  isAvtAtt(name) {
    return this.languageConfiguration.avtAtts ? this.languageConfiguration.avtAtts.indexOf(name) > -1 : false;
  }
  isExpressionAtt(name) {
    return this.languageConfiguration.expressionAtts ? this.languageConfiguration.expressionAtts.indexOf(name) > -1 : false;
  }
  calcNewState(isCurrentCharNewLine, char, nextChar, existing) {
    let rc = existing;
    switch (existing) {
      case 26:
        rc = 27;
        break;
      case 27:
        rc = 28;
        break;
      case 28:
        if (char === ">") {
          rc = 29;
        }
        break;
      case 6:
        rc = 7;
        break;
      case 7:
        rc = 8;
        break;
      case 8:
        if (this.isWhitespace(isCurrentCharNewLine, char)) {
          rc = 9;
        } else if (char === "?" && nextChar === ">") {
          rc = 12;
          this.skipTokenChar = true;
        }
        break;
      case 9:
        if (this.isWhitespace(isCurrentCharNewLine, char)) ;
        else if (char === "?" && nextChar === ">") {
          rc = 11;
          this.skipTokenChar = true;
        } else {
          rc = 10;
        }
        break;
      case 10:
        if (char === "?" && nextChar === ">") {
          rc = 11;
          this.skipTokenChar = true;
        }
        break;
      case 11:
      case 12:
      case 31:
      case 30:
        if (this.skipTokenChar) {
          this.skipTokenChar = false;
        } else {
          rc = this.testChar(char, nextChar, false);
        }
        break;
      case 4:
        if (this.commentCharCount === 0) {
          this.commentCharCount++;
        } else if (this.commentCharCount === 1) {
          if (char === "-" && nextChar === "-") {
            this.commentCharCount++;
          }
        } else if (this.commentCharCount === 2) {
          this.commentCharCount++;
        } else if (this.commentCharCount === 3) {
          if (char === ">") {
            rc = 5;
          }
          this.commentCharCount = 4;
        }
        break;
      case 23:
        if (char === "[" && nextChar === "C") {
          this.cdataCharCount = 0;
          rc = 13;
        } else if (char === "-" && nextChar === "-") {
          rc = 4;
          this.commentCharCount = 0;
        } else if (char === ">") {
          this.dtdNesting--;
          if (this.dtdNesting < 0) {
            this.dtdNesting = 0;
            rc = 24;
          }
        } else if (char === "<") {
          this.dtdNesting++;
        }
        break;
      case 13:
        switch (this.cdataCharCount) {
          case 0:
          // [C  of <![CDATA[ already checked
          case 2:
          // DA already checked
          case 4:
            this.cdataCharCount++;
            break;
          case 1:
            if (char === "D" && nextChar === "A") {
              this.cdataCharCount++;
            } else {
              rc = 0;
            }
            break;
          case 3:
            if (char === "T" && nextChar === "A") {
              this.cdataCharCount++;
            } else {
              rc = 0;
            }
            break;
          case 5:
            if (char === "[") {
              this.cdataCharCount = 0;
              rc = 14;
            } else {
              rc = 0;
            }
            break;
        }
        break;
      case 14:
      case 17:
        if (char === "]" && nextChar === "]") {
          this.cdataCharCount = 0;
          rc = 15;
        } else if (char === "{") {
          if (nextChar === "{") {
            rc = 45;
          } else {
            rc = 43;
          }
        }
        break;
      // otherwise continue awaiting ]]>
      case 15:
        if (this.cdataCharCount === 0) {
          this.cdataCharCount++;
        } else if (char === ">") {
          this.cdataCharCount = 0;
          rc = 16;
        } else {
          this.cdataCharCount = 0;
          rc = 0;
        }
        break;
      case 1:
        if (char === ">") {
          rc = 2;
        } else {
          rc = 32;
        }
        break;
      // element name started
      case 32:
        if (this.isWhitespace(isCurrentCharNewLine, char)) {
          rc = 46;
        } else if (char === ">") {
          rc = 3;
        } else if (char === "/" && nextChar === ">") {
          rc = 30;
          this.skipTokenChar = true;
        }
        break;
      // whitespace after element name (or after att-value)
      case 46:
      case 21:
      case 22:
      case 20:
        if (this.isWhitespace(isCurrentCharNewLine, char)) {
          if (existing !== 46) {
            rc = 20;
          }
        } else if (char === ">") {
          rc = 2;
        } else if (char === "/" && nextChar === ">") {
          rc = 31;
          this.skipTokenChar = true;
        } else {
          rc = 34;
        }
        break;
      // attribute name started
      case 34:
        if (this.isWhitespace(isCurrentCharNewLine, char)) {
          rc = 47;
        } else if (char === "=") {
          rc = 50;
        } else {
          const charState = this.testAttNameChar(char, nextChar);
          if (charState !== 53) {
            rc = charState;
          }
        }
        break;
      // whitespace after attribute name
      case 47:
        if (char === "=") {
          rc = 50;
        } else if (!this.isWhitespace(isCurrentCharNewLine, char)) {
          rc = 48;
        }
        break;
      // '=' char after attribute name or
      // whitespace after attname and '=' char
      case 50:
      case 49:
        if (this.isWhitespace(isCurrentCharNewLine, char)) {
          rc = 49;
        } else if (char === '"') {
          rc = 19;
        } else if (char === "'") {
          rc = 18;
        } else {
          rc = 48;
        }
        break;
      case 19:
        if (char === '"') {
          rc = 22;
        } else if (char === "{") {
          if (nextChar === "{") {
            rc = 40;
          } else {
            rc = 39;
          }
        } else if (char === "&") {
          rc = 51;
          this.entityContext = 1;
        } else {
          const charState = this.testAttValueChar(char, nextChar);
          if (charState !== 53) {
            rc = charState;
          }
        }
        break;
      case 18:
        if (char === "'") {
          rc = 21;
        } else if (char === "{") {
          if (nextChar === "{") {
            rc = 41;
          } else {
            rc = 38;
          }
        } else if (char === "&") {
          rc = 51;
          this.entityContext = 2;
        } else {
          const charState = this.testAttValueChar(char, nextChar);
          if (charState !== 53) {
            rc = charState;
          }
        }
        break;
      case 40:
        rc = 19;
        break;
      case 41:
        rc = 18;
        break;
      case 44:
        rc = 0;
        break;
      case 45:
        rc = 17;
        break;
      case 51:
        if (char === ";") {
          rc = 52;
        } else if (this.isWhitespace(isCurrentCharNewLine, char)) {
          rc = this.testChar(char, nextChar, false);
        }
        break;
      case 53:
        rc = this.testChar(char, nextChar, true);
        break;
      default:
        rc = this.testChar(char, nextChar, false);
    }
    return rc;
  }
  testAttNameChar(char, nextChar) {
    let rc;
    switch (char) {
      case "<":
        switch (nextChar) {
          case "?":
            rc = 6;
            break;
          case "!":
            rc = 23;
            break;
          case "/":
            rc = 26;
            break;
          default:
            rc = 1;
        }
        break;
      case "{":
        if (nextChar === "{") {
          rc = 44;
        } else {
          rc = 42;
        }
        break;
      case "&":
        rc = 51;
        this.entityContext = 0;
        break;
      case "/":
      case ">":
        rc = 48;
        break;
      default:
        rc = 53;
        break;
    }
    return rc;
  }
  testAttValueChar(char, nextChar) {
    let rc;
    switch (char) {
      case "<":
        switch (nextChar) {
          case "?":
            rc = 6;
            break;
          case "!":
            rc = 23;
            break;
          case "/":
            rc = 26;
            break;
          default:
            rc = 1;
        }
        break;
      case "/":
        rc = nextChar === ">" ? 48 : 53;
        break;
      default:
        rc = 53;
        break;
    }
    return rc;
  }
  testChar(char, nextChar, isText) {
    let rc;
    switch (char) {
      case " ":
      case "	":
      case "\r":
        if (isText) {
          rc = 53;
        } else {
          rc = 25;
        }
        break;
      case "\n":
        rc = 25;
        break;
      case "<":
        switch (nextChar) {
          case "?":
            rc = 6;
            break;
          case "!":
            rc = 23;
            break;
          case "/":
            rc = 26;
            break;
          default:
            rc = 1;
        }
        break;
      case "{":
        if (nextChar === "{") {
          rc = 44;
        } else {
          rc = 42;
        }
        break;
      case "&":
        rc = 51;
        this.entityContext = 0;
        break;
      default:
        rc = 53;
        break;
    }
    return rc;
  }
  analyse(xsl, keepNameTests) {
    if (this.timerOn) {
      console.time("xslLexer.analyse");
    }
    this.globalInstructionData.length = 0;
    this.globalModeData.length = 0;
    this.lineNumber = 0;
    this.lineCharCount = -1;
    this.charCount = -1;
    if (keepNameTests) {
      this.attributeNameTests = [];
      this.elementNameTests = [];
    } else {
      this.attributeNameTests = void 0;
      this.elementNameTests = void 0;
    }
    let currentState = 0;
    let currentChar = "";
    let tokenChars = [];
    let result = [];
    let attName = "";
    let avtExit = false;
    let xpLexer = new XPathLexer();
    xpLexer.elementNameTests = this.elementNameTests;
    xpLexer.attributeNameTests = this.attributeNameTests;
    xpLexer.documentText = xsl;
    xpLexer.documentTokens = result;
    xpLexer.debug = this.debug;
    xpLexer.timerOn = this.timerOn;
    let xslLength = xsl.length;
    let storeToken = false;
    let isNativeElement = false;
    let tagGlobalInstructionType = 14;
    let tagInstructionNameAdded = false;
    let tagMatchToken = null;
    let contextGlobalInstructionType = 14;
    let isXPathAttribute = false;
    let isExpandTextAttribute = false;
    let isGlobalInstructionName = false;
    let isGlobalInstructionMode = false;
    let isGlobalParameterName = false;
    let isGlobalUsePackageVersion = false;
    let isGlobalInstructionMatch = false;
    let expandTextValue = false;
    let xmlElementStack = [];
    let tokenStartChar = -1;
    let attributeNameTokenAdded = false;
    let collectParamName = false;
    let xpathEnded = false;
    if (this.debug) {
      console.log("xsl:\n" + xsl);
    }
    if (xslLength === 0) {
      return [];
    }
    while (this.charCount < xslLength) {
      this.charCount++;
      this.lineCharCount++;
      let nextState = 0;
      let nextChar = xsl.charAt(this.charCount);
      const isLastChar = this.charCount === xslLength;
      const resultLengthAtLastChar = isLastChar ? result.length : -1;
      if (currentChar) {
        let isCurrentCharNewLIne = currentChar === "\n";
        nextState = this.calcNewState(
          isCurrentCharNewLIne,
          currentChar,
          nextChar,
          currentState
        );
        if (nextState === currentState) {
          if (isCurrentCharNewLIne || isLastChar) {
            let addToken = null;
            switch (nextState) {
              case 10:
                addToken = 9;
                this.addNewTokenToResult(
                  tokenStartChar,
                  addToken,
                  result,
                  nextState
                );
                break;
              case 4:
                addToken = 11;
                tokenStartChar = tokenStartChar === 0 ? tokenStartChar : tokenStartChar - 2;
                break;
              case 19:
              case 18:
                addToken = 2;
                break;
              case 23:
                addToken = 4;
                break;
            }
            if (addToken !== null) {
              this.addNewTokenToResult(
                tokenStartChar,
                addToken,
                result,
                nextState
              );
              tokenStartChar = 0;
            } else if (isLastChar) {
              let alreadyDone = result.length > 0 && result[result.length - 1].startCharacter === tokenStartChar;
              if (!alreadyDone) {
                this.addNewTokenToResult(
                  tokenStartChar,
                  14,
                  result,
                  nextState
                );
              }
            }
          } else if (storeToken) {
            tokenChars.push(currentChar);
          }
        } else {
          if (currentState === 53) {
            if (nextState === 44) {
              this.addCharTokenToResult(
                tokenStartChar,
                this.lineCharCount - tokenStartChar,
                14,
                result,
                currentState
              );
            } else {
              this.addCharTokenToResult(
                tokenStartChar,
                this.lineCharCount - 1 - tokenStartChar,
                14,
                result,
                currentState
              );
            }
          } else if (currentState === 44) {
            this.addCharTokenToResult(
              tokenStartChar,
              2,
              14,
              result,
              currentState
            );
          }
          if (currentState === 51 && nextState !== 52) {
            this.addNewTokenToResult(
              tokenStartChar,
              10,
              result,
              nextState
            );
            switch (this.entityContext) {
              case 0:
                nextState = 0;
                break;
              case 2:
                nextState = 18;
                break;
              case 1:
                nextState = 19;
                break;
            }
          }
          switch (nextState) {
            case 1:
              this.addCharTokenToResult(
                this.lineCharCount - 1,
                1,
                12,
                result,
                nextState
              );
              break;
            case 28:
            case 32:
              expandTextValue = null;
              if (tokenChars.length < 5) {
                tokenChars.push(currentChar);
                storeToken = true;
              } else {
                storeToken = false;
              }
              break;
            case 3:
              expandTextValue = this.addToElementStack(
                expandTextValue,
                xmlElementStack
              );
            // cascade, so no-break intentional
            case 46:
            case 30:
            case 29:
              let isCloseTag = nextState === 29;
              let isRootChildStartTag = !isCloseTag && xmlElementStack.length === 1;
              let elementProperties = this.getElementProperties(
                tokenChars,
                isRootChildStartTag
              );
              isNativeElement = elementProperties.isNative;
              tagGlobalInstructionType = elementProperties.instructionType;
              tagInstructionNameAdded = false;
              tagMatchToken = null;
              collectParamName = false;
              if (xmlElementStack.length === 0 && tokenChars.length > 5) {
                tagGlobalInstructionType = 13;
              }
              if (xmlElementStack.length === 1) {
                contextGlobalInstructionType = tagGlobalInstructionType;
              } else if (xmlElementStack.length === 2 && (contextGlobalInstructionType === 2 || contextGlobalInstructionType === 7) && isNativeElement && elementProperties.nativeName === "param") {
                collectParamName = true;
              }
              if (isCloseTag) {
                if (xmlElementStack.length > 0) {
                  xmlElementStack.pop();
                }
              }
              storeToken = false;
              tokenChars = [];
              let newTokenType = isNativeElement ? 13 : 6;
              this.addNewTokenToResult(
                tokenStartChar,
                newTokenType,
                result,
                nextState
              );
              if (nextState !== 46) {
                let punctuationLength = nextState === 29 || nextState === 3 ? 1 : 2;
                this.addCharTokenToResult(
                  this.lineCharCount - 1,
                  punctuationLength,
                  12,
                  result,
                  nextState
                );
              }
              break;
            case 24:
              this.addCharTokenToResult(
                tokenStartChar,
                this.lineCharCount - tokenStartChar,
                5,
                result,
                currentState
              );
              break;
            case 9:
              this.addNewTokenToResult(
                tokenStartChar,
                8,
                result,
                nextState
              );
              break;
            case 11:
              this.addNewTokenToResult(
                tokenStartChar,
                9,
                result,
                currentState
              );
              this.addCharTokenToResult(
                this.lineCharCount - 1,
                2,
                12,
                result,
                nextState
              );
              break;
            case 12:
              this.addNewTokenToResult(
                tokenStartChar,
                8,
                result,
                currentState
              );
              this.addCharTokenToResult(
                this.lineCharCount - 1,
                2,
                12,
                result,
                nextState
              );
              break;
            case 5:
              let startChar = tokenStartChar > 0 ? tokenStartChar - 2 : 0;
              this.addNewTokenToResult(
                startChar,
                11,
                result,
                nextState
              );
              break;
            case 47:
            case 48:
              storeToken = false;
              this.addNewTokenToResult(
                tokenStartChar,
                0,
                result,
                nextState
              );
              attributeNameTokenAdded = true;
              break;
            case 34:
              tokenChars.push(currentChar);
              storeToken = true;
              attributeNameTokenAdded = false;
              break;
            case 50:
              let isXMLNSattribute = false;
              isGlobalInstructionName = false;
              isGlobalInstructionMode = false;
              isGlobalParameterName = false;
              isGlobalInstructionMatch = false;
              isGlobalUsePackageVersion = false;
              attName = tokenChars.join("");
              let attributeNameToken = 0;
              if (isNativeElement) {
                if (attName === "saxon:options") {
                  isXPathAttribute = true;
                } else if (this.genericTvtAttributes.indexOf(attName) > -1) {
                  isXPathAttribute = false;
                  isExpandTextAttribute = true;
                } else if (attName.startsWith("xmlns")) {
                  isExpandTextAttribute = false;
                  isXMLNSattribute = true;
                  attributeNameToken = 3;
                } else if (tagGlobalInstructionType === 13 && attName === "version") ;
                else if (tagGlobalInstructionType !== 14 && attName === "name") {
                  isExpandTextAttribute = false;
                  isGlobalInstructionName = true;
                } else if (tagGlobalInstructionType === 7 && attName === "mode" || tagGlobalInstructionType === 3 && attName === "name") {
                  isExpandTextAttribute = false;
                  isGlobalInstructionMode = true;
                } else if (tagGlobalInstructionType === 7 && attName === "match") {
                  isExpandTextAttribute = false;
                  isGlobalInstructionMatch = true;
                  isXPathAttribute = true;
                } else if (collectParamName && attName === "name") {
                  isGlobalParameterName = true;
                } else if (contextGlobalInstructionType === 11 && attName === "package-version") {
                  isExpandTextAttribute = false;
                  isGlobalUsePackageVersion = true;
                } else {
                  isExpandTextAttribute = false;
                  isXPathAttribute = this.isExpressionAtt(attName);
                }
              } else {
                if (this.nativeTvtAttributes.indexOf(attName) > -1) {
                  isExpandTextAttribute = true;
                } else if (attName.startsWith("xmlns")) {
                  isExpandTextAttribute = false;
                  isXMLNSattribute = true;
                  attributeNameToken = 3;
                } else {
                  isExpandTextAttribute = false;
                }
              }
              if (!attributeNameTokenAdded) {
                this.addNewTokenToResult(
                  tokenStartChar,
                  attributeNameToken,
                  result,
                  nextState
                );
              } else if (isXMLNSattribute) {
                result[result.length - 1].tokenType = attributeNameToken;
              }
              this.addCharTokenToResult(
                this.lineCharCount - 1,
                1,
                1,
                result,
                nextState
              );
              tokenChars = [];
              storeToken = false;
              break;
            case 2:
              if (tagGlobalInstructionType === 7 && !tagInstructionNameAdded && tagMatchToken) {
                this.globalInstructionData.push({
                  type: 8,
                  name: `${tagMatchToken.value}#${this.globalInstructionData.length}`,
                  token: tagMatchToken,
                  idNumber: 0
                });
              }
              expandTextValue = this.addToElementStack(
                expandTextValue,
                xmlElementStack
              );
              this.addCharTokenToResult(
                this.lineCharCount - 1,
                1,
                12,
                result,
                nextState
              );
              storeToken = false;
              tokenChars = [];
              break;
            case 26:
            case 6:
              this.addCharTokenToResult(
                this.lineCharCount - 1,
                2,
                12,
                result,
                nextState
              );
              break;
            case 31:
              this.addCharTokenToResult(
                this.lineCharCount - 1,
                2,
                12,
                result,
                nextState
              );
              break;
            case 27:
              break;
            case 21:
            case 22:
            case 40:
            case 41:
              if (isExpandTextAttribute) {
                let attValue = tokenChars.join("");
                expandTextValue = attValue === "yes" || attValue === "true" || attValue === "1";
              }
              if (xpathEnded) {
                tokenStartChar++;
                xpathEnded = false;
              }
              let newToken = this.addNewTokenToResult(
                tokenStartChar,
                2,
                result,
                nextState
              );
              if (isGlobalInstructionName || isGlobalInstructionMode) {
                let attValue = tokenChars.join("");
                let newTokenCopy = Object.assign({}, newToken);
                let globalType = isGlobalInstructionMode ? 3 : tagGlobalInstructionType;
                let targetGlobal;
                if (isGlobalInstructionMode) {
                  targetGlobal = this.globalModeData;
                } else {
                  targetGlobal = this.globalInstructionData;
                  tagInstructionNameAdded = true;
                }
                const idNumber = globalType === 0 ? result.length : 0;
                targetGlobal.push({
                  type: globalType,
                  name: attValue,
                  token: newTokenCopy,
                  idNumber
                });
              } else if (isGlobalParameterName) {
                let attValue = tokenChars.join("");
                if (this.globalInstructionData.length > 0) {
                  let gd = this.globalInstructionData[this.globalInstructionData.length - 1];
                  if (gd.memberNames) {
                    if (gd.memberNames.indexOf(attValue) > -1) {
                      newToken["error"] = ErrorType.DuplicateParameterName;
                      newToken.value = attValue;
                    }
                    gd.memberNames.push(attValue);
                    gd.memberTokens?.push({ ...newToken });
                  } else {
                    gd["memberNames"] = [attValue];
                    gd["memberTokens"] = [{ ...newToken }];
                  }
                  gd.idNumber++;
                }
              } else if (isGlobalUsePackageVersion) {
                let attValue = tokenChars.join("");
                if (this.globalInstructionData.length > 0) {
                  let gd = this.globalInstructionData[this.globalInstructionData.length - 1];
                  gd["version"] = attValue;
                }
              } else if (isGlobalInstructionMatch) {
                let attValue = tokenChars.join("");
                tagMatchToken = newToken;
                tagMatchToken.value = attValue;
              } else ;
              tokenChars = [];
              storeToken = false;
              break;
            case 18:
            case 19:
              if (contextGlobalInstructionType === 2 || contextGlobalInstructionType === 7 || contextGlobalInstructionType === 11 || tagGlobalInstructionType === 13) {
                storeToken = true;
              }
              if (isExpandTextAttribute || isGlobalInstructionName || isGlobalInstructionMode) {
                storeToken = true;
              } else if (isXPathAttribute) {
                this.addCharTokenToResult(
                  this.lineCharCount - 1,
                  1,
                  2,
                  result,
                  nextState
                );
                let p = {
                  line: this.lineNumber,
                  startCharacter: this.lineCharCount,
                  documentOffset: this.charCount
                };
                let exit2;
                if (nextState === 18) {
                  exit2 = ExitCondition.SingleQuote;
                } else {
                  exit2 = ExitCondition.DoubleQuote;
                }
                xpLexer.analyse("", exit2, p);
                this.updateNames(result);
                this.lineNumber = p.line;
                let newCharCount = p.documentOffset - 1;
                if (newCharCount > this.charCount) {
                  this.charCount = newCharCount;
                }
                xpathEnded = true;
                this.lineCharCount = p.startCharacter;
                nextChar = xsl.charAt(this.charCount);
                isXPathAttribute = false;
              }
              break;
            case 38:
            case 39:
              let exit;
              if (isNativeElement) {
                if (exit = attName.startsWith("_")) {
                  exit = ExitCondition.CurlyBrace;
                } else {
                  exit = this.isAvtAtt(attName) ? ExitCondition.CurlyBrace : ExitCondition.None;
                }
              } else if (this.nonNativeAvts) {
                exit = ExitCondition.CurlyBrace;
              } else {
                exit = ExitCondition.None;
              }
              if (exit !== ExitCondition.None) {
                this.addNewTokenToResult(
                  tokenStartChar,
                  2,
                  result,
                  nextState
                );
                let p = {
                  line: this.lineNumber,
                  startCharacter: this.lineCharCount,
                  documentOffset: this.charCount
                };
                xpLexer.analyse("", exit, p);
                this.updateNames(result);
                this.lineNumber = p.line;
                let newCharCount = p.documentOffset - 1;
                if (newCharCount > this.charCount) {
                  this.charCount = newCharCount;
                }
                this.lineCharCount = p.startCharacter;
                nextChar = xsl.charAt(this.charCount);
                avtExit = true;
              }
              nextState = nextState === 38 ? 18 : 19;
              break;
            case 42:
              this.addCharTokenToResult(
                this.lineCharCount - 1,
                1,
                14,
                result,
                currentState
              );
            case 43:
              let useTvt = xmlElementStack.length > 0 && xmlElementStack[xmlElementStack.length - 1].expandText;
              if (useTvt) {
                let p = {
                  line: this.lineNumber,
                  startCharacter: this.lineCharCount,
                  documentOffset: this.charCount
                };
                xpLexer.analyse("", ExitCondition.CurlyBrace, p);
                this.updateNames(result);
                this.lineNumber = p.line;
                let newCharCount = p.documentOffset - 1;
                if (newCharCount > this.charCount) {
                  this.charCount = newCharCount;
                }
                this.lineCharCount = p.startCharacter;
                nextChar = xsl.charAt(this.charCount);
                if (nextState === 43) {
                  nextState = 17;
                } else {
                  nextState = 0;
                }
              } else if (nextState === 43) {
                nextState = 17;
              }
              break;
            case 51:
              if (this.entityContext !== 0) {
                this.addCharTokenToResult(
                  tokenStartChar,
                  this.lineCharCount - 1 - tokenStartChar,
                  2,
                  result,
                  nextState
                );
              }
              break;
            case 52:
              this.addCharTokenToResult(
                tokenStartChar,
                this.lineCharCount - tokenStartChar,
                10,
                result,
                nextState
              );
              switch (this.entityContext) {
                case 0:
                  nextState = 0;
                  break;
                case 2:
                  nextState = 18;
                  avtExit = true;
                  break;
                case 1:
                  nextState = 19;
                  avtExit = true;
                  break;
              }
              break;
            case 14:
              this.addCharTokenToResult(
                tokenStartChar - 2,
                9,
                12,
                result,
                nextState
              );
              break;
            case 16:
              this.addCharTokenToResult(
                tokenStartChar,
                3,
                12,
                result,
                nextState
              );
              break;
          }
          tokenStartChar = this.lineCharCount > 0 ? this.lineCharCount - 1 : 0;
          if (avtExit) {
            avtExit = false;
            tokenStartChar++;
          }
          this.lineNumber;
        }
        if (isCurrentCharNewLIne) {
          tokenStartChar = 0;
          this.lineNumber++;
          this.lineCharCount = 0;
        }
        currentState = nextState;
      }
      currentChar = nextChar;
      if (isLastChar && resultLengthAtLastChar === result.length && !(nextState === 25 || nextState === 49)) {
        let alreadyDone = result.length > 0 && result[result.length - 1].startCharacter === tokenStartChar;
        if (!alreadyDone) {
          this.addCharTokenToResult(
            tokenStartChar,
            this.lineCharCount - tokenStartChar,
            14,
            result,
            currentState
          );
        }
      }
    }
    if (this.timerOn) {
      console.timeEnd("xslLexer.analyse");
    }
    this.globalInstructionData = this.globalInstructionData.concat(
      this.globalModeData
    );
    return result;
  }
  updateNames(result) {
    if (this.elementNameTests && this.attributeNameTests && result.length > 0) {
      let prevToken = result[result.length - 1];
      if (prevToken.tokenType === TokenLevelState.nodeNameTest) {
        if (this.elementNameTests.indexOf(prevToken.value) < 0) {
          this.elementNameTests.push(prevToken.value);
        }
      } else if (prevToken.tokenType === TokenLevelState.attributeNameTest) {
        if (this.attributeNameTests.indexOf(prevToken.value) < 0) {
          this.attributeNameTests.push(prevToken.value);
        }
      }
    }
  }
  addNewTokenToResult(tokenStartChar, newTokenType, result, charLevelState) {
    let tokenLength = this.lineCharCount - 1 - tokenStartChar;
    let localTokenStartChar = tokenStartChar;
    if (newTokenType === 11 || newTokenType === 2) {
      tokenLength++;
    }
    let tkn = {
      line: this.lineNumber,
      length: tokenLength,
      startCharacter: localTokenStartChar,
      value: "",
      tokenType: newTokenType + XslLexer.xpathLegendLength
    };
    if (this.provideCharLevelState) {
      tkn["charType"] = charLevelState;
    }
    result.push(tkn);
    return tkn;
  }
  addCharTokenToResult(tokenStartChar, tokenLength, newTokenType, result, charLevelState) {
    let tkn = {
      line: this.lineNumber,
      length: tokenLength,
      startCharacter: tokenStartChar,
      value: "",
      tokenType: newTokenType + XslLexer.xpathLegendLength
    };
    if (this.provideCharLevelState) {
      tkn["charType"] = charLevelState;
    }
    result.push(tkn);
  }
  addToElementStack(expandTextValue, xmlElementStack) {
    if (expandTextValue === null) {
      if (xmlElementStack.length > 0) {
        expandTextValue = xmlElementStack[xmlElementStack.length - 1].expandText;
      } else {
        expandTextValue = false;
      }
    }
    xmlElementStack.push({ expandText: expandTextValue });
    return expandTextValue;
  }
  getElementProperties(tokenChars, isRootChild) {
    let elementName = tokenChars.join("");
    let isNative = this.nativePrefixLength === 0 && elementName.indexOf(":") === -1 || tokenChars.length > this.nativePrefixLength && elementName.startsWith(this.languageConfiguration.nativePrefix + ":");
    let instructionType = 14;
    let nativeName = "";
    if (isNative) {
      nativeName = elementName.substring(this.nativePrefixLength);
      if (isRootChild) {
        switch (nativeName) {
          case "variable":
            instructionType = 0;
            break;
          case "param":
            instructionType = 1;
            break;
          case "function":
            instructionType = 2;
            break;
          case "template":
            instructionType = 7;
            break;
          case "key":
            instructionType = 6;
            break;
          case "import":
            instructionType = 10;
            break;
          case "include":
            instructionType = 9;
            break;
          case "accumulator":
            instructionType = 4;
            break;
          case "mode":
            instructionType = 3;
            break;
          case "attribute-set":
            instructionType = 5;
            break;
          case "use-package":
            instructionType = 11;
            break;
        }
      }
    }
    return {
      isNative,
      instructionType,
      nativeName
    };
  }
  // class ends
}
var GlobalInstructionType = /* @__PURE__ */ ((GlobalInstructionType2) => {
  GlobalInstructionType2[GlobalInstructionType2["Variable"] = 0] = "Variable";
  GlobalInstructionType2[GlobalInstructionType2["Parameter"] = 1] = "Parameter";
  GlobalInstructionType2[GlobalInstructionType2["Function"] = 2] = "Function";
  GlobalInstructionType2[GlobalInstructionType2["Mode"] = 3] = "Mode";
  GlobalInstructionType2[GlobalInstructionType2["Accumulator"] = 4] = "Accumulator";
  GlobalInstructionType2[GlobalInstructionType2["AttributeSet"] = 5] = "AttributeSet";
  GlobalInstructionType2[GlobalInstructionType2["Key"] = 6] = "Key";
  GlobalInstructionType2[GlobalInstructionType2["Template"] = 7] = "Template";
  GlobalInstructionType2[GlobalInstructionType2["TemplateMatch"] = 8] = "TemplateMatch";
  GlobalInstructionType2[GlobalInstructionType2["Include"] = 9] = "Include";
  GlobalInstructionType2[GlobalInstructionType2["Import"] = 10] = "Import";
  GlobalInstructionType2[GlobalInstructionType2["UsePackage"] = 11] = "UsePackage";
  GlobalInstructionType2[GlobalInstructionType2["RootXMLNS"] = 12] = "RootXMLNS";
  GlobalInstructionType2[GlobalInstructionType2["RootXSLT"] = 13] = "RootXSLT";
  GlobalInstructionType2[GlobalInstructionType2["Unknown"] = 14] = "Unknown";
  return GlobalInstructionType2;
})(GlobalInstructionType || {});
var XSLTnamespaces = /* @__PURE__ */ ((XSLTnamespaces2) => {
  XSLTnamespaces2[XSLTnamespaces2["NotDefined"] = 0] = "NotDefined";
  XSLTnamespaces2[XSLTnamespaces2["Array"] = 1] = "Array";
  XSLTnamespaces2[XSLTnamespaces2["ExpathArchive"] = 2] = "ExpathArchive";
  XSLTnamespaces2[XSLTnamespaces2["ExpathBinary"] = 3] = "ExpathBinary";
  XSLTnamespaces2[XSLTnamespaces2["ExpathFile"] = 4] = "ExpathFile";
  XSLTnamespaces2[XSLTnamespaces2["Exslt"] = 5] = "Exslt";
  XSLTnamespaces2[XSLTnamespaces2["ExsltMath"] = 6] = "ExsltMath";
  XSLTnamespaces2[XSLTnamespaces2["ExsltRegex"] = 7] = "ExsltRegex";
  XSLTnamespaces2[XSLTnamespaces2["ExsltSets"] = 8] = "ExsltSets";
  XSLTnamespaces2[XSLTnamespaces2["ExsltStrings"] = 9] = "ExsltStrings";
  XSLTnamespaces2[XSLTnamespaces2["Map"] = 10] = "Map";
  XSLTnamespaces2[XSLTnamespaces2["Math"] = 11] = "Math";
  XSLTnamespaces2[XSLTnamespaces2["Saxon"] = 12] = "Saxon";
  XSLTnamespaces2[XSLTnamespaces2["SQL"] = 13] = "SQL";
  XSLTnamespaces2[XSLTnamespaces2["XMLSchema"] = 14] = "XMLSchema";
  XSLTnamespaces2[XSLTnamespaces2["XPath"] = 15] = "XPath";
  XSLTnamespaces2[XSLTnamespaces2["XSLT"] = 16] = "XSLT";
  XSLTnamespaces2[XSLTnamespaces2["IXSL"] = 17] = "IXSL";
  XSLTnamespaces2[XSLTnamespaces2["dfdl"] = 18] = "dfdl";
  return XSLTnamespaces2;
})(XSLTnamespaces || {});
class FunctionData {
  static {
    this.xpath = [
      "count#1",
      "QName#2",
      "abs#1",
      "analyze-string#2",
      "analyze-string#3",
      "apply#2",
      "available-environment-variables#0",
      "avg#1",
      "base-uri#0",
      "base-uri#1",
      "boolean#1",
      "ceiling#1",
      "codepoint-equal#2",
      "codepoints-to-string#1",
      "collation-key#1",
      "collation-key#2",
      "collection#0",
      "collection#1",
      "compare#2",
      "compare#3",
      "concat#2",
      "concat#3",
      "contains#2",
      "contains#3",
      "contains-token#2",
      "contains-token#3",
      "current-date#0",
      "current-dateTime#0",
      "current-time#0",
      "starts-with#2",
      "starts-with#3",
      "static-base-uri#0",
      "string#0",
      "string#1",
      "string-join#1",
      "string-join#2",
      "string-length#0",
      "string-length#1",
      "string-to-codepoints#1",
      "subsequence#2",
      "subsequence#3",
      "substring#2",
      "substring#3",
      "substring-after#2",
      "substring-after#3",
      "substring-before#2",
      "substring-before#3",
      "sum#1",
      "sum#2",
      "data#0",
      "data#1",
      "dateTime#2",
      "day-from-date#1",
      "day-from-dateTime#1",
      "days-from-duration#1",
      "deep-equal#2",
      "deep-equal#3",
      "default-collation#0",
      "default-language#0",
      "distinct-values#1",
      "distinct-values#2",
      "doc#1",
      "doc-available#1",
      "document-uri#0",
      "document-uri#1",
      "element-with-id#1",
      "element-with-id#2",
      "empty#1",
      "encode-for-uri#1",
      "ends-with#2",
      "ends-with#3",
      "environment-variable#1",
      "error#0",
      "error#1",
      "error#2",
      "error#3",
      "escape-html-uri#1",
      "exactly-one#1",
      "exists#1",
      "false#0",
      "filter#2",
      "floor#1",
      "fold-left#3",
      "fold-right#3",
      "for-each#2",
      "for-each-pair#3",
      "format-date#2",
      "format-date#5",
      "format-dateTime#2",
      "format-dateTime#5",
      "format-integer#2",
      "format-integer#3",
      "format-number#2",
      "format-number#3",
      "format-time#2",
      "format-time#5",
      "function-arity#1",
      "function-lookup#2",
      "function-name#1",
      "generate-id#0",
      "generate-id#1",
      "has-children#0",
      "has-children#1",
      "head#1",
      "hours-from-dateTime#1",
      "hours-from-duration#1",
      "hours-from-time#1",
      "id#1",
      "id#2",
      "idref#1",
      "idref#2",
      "implicit-timezone#0",
      "in-scope-prefixes#1",
      "index-of#2",
      "index-of#3",
      "innermost#1",
      "insert-before#3",
      "iri-to-uri#1",
      "json-doc#1",
      "json-doc#2",
      "json-to-xml#1",
      "json-to-xml#2",
      "lang#1",
      "lang#2",
      "last#0",
      "load-xquery-module#1",
      "load-xquery-module#2",
      "local-name#0",
      "local-name#1",
      "local-name-from-QName#1",
      "lower-case#1",
      "matches#2",
      "matches#3",
      "max#1",
      "max#2",
      "min#1",
      "min#2",
      "name#0",
      "name#1",
      "namespace-uri#0",
      "namespace-uri#1",
      "namespace-uri-for-prefix#2",
      "namespace-uri-from-QName#1",
      "nilled#0",
      "nilled#1",
      "node-name#0",
      "node-name#1",
      "normalize-space#0",
      "normalize-space#1",
      "normalize-unicode#1",
      "normalize-unicode#2",
      "not#1",
      "number#0",
      "number#1",
      "one-or-more#1",
      "outermost#1",
      "parse-ietf-date#1",
      "parse-json#1",
      "parse-json#2",
      "parse-xml#1",
      "parse-xml-fragment#1",
      "path#0",
      "path#1",
      "position#0",
      "prefix-from-QName#1",
      "remove#2",
      "replace#3",
      "replace#4",
      "resolve-QName#2",
      "resolve-uri#1",
      "resolve-uri#2",
      "reverse#1",
      "root#0",
      "root#1",
      "round#1",
      "round#2",
      "minutes-from-dateTime#1",
      "minutes-from-duration#1",
      "minutes-from-time#1",
      "month-from-date#1",
      "month-from-dateTime#1",
      "months-from-duration#1",
      "round-half-to-even#1",
      "round-half-to-even#2",
      "seconds-from-dateTime#1",
      "seconds-from-duration#1",
      "seconds-from-time#1",
      "serialize#1",
      "serialize#2",
      "sort#1",
      "sort#2",
      "sort#3",
      "tail#1",
      "timezone-from-date#1",
      "timezone-from-dateTime#1",
      "timezone-from-time#1",
      "adjust-date-to-timezone#1",
      "adjust-date-to-timezone#2",
      "adjust-dateTime-to-timezone#1",
      "adjust-dateTime-to-timezone#2",
      "adjust-time-to-timezone#1",
      "adjust-time-to-timezone#2",
      "tokenize#1",
      "tokenize#2",
      "tokenize#3",
      "trace#1",
      "trace#2",
      "transform#1",
      "translate#3",
      "true#0",
      "unordered#1",
      "unparsed-text#1",
      "unparsed-text#2",
      "unparsed-text-available#1",
      "unparsed-text-available#2",
      "unparsed-text-lines#1",
      "unparsed-text-lines#2",
      "upper-case#1",
      "uri-collection#0",
      "uri-collection#1",
      "xml-to-json#1",
      "xml-to-json#2",
      "year-from-date#1",
      "year-from-dateTime#1",
      "years-from-duration#1",
      "random-number-generator#0",
      "random-number-generator#1",
      "zero-or-one#1",
      "accumulator-after#1",
      "accumulator-before#1",
      "available-system-properties#0",
      "copy-of#0",
      "copy-of#1",
      "current#0",
      "current-group#0",
      "current-grouping-key#0",
      "current-merge-group#0",
      "current-merge-group#1",
      "current-merge-key#0",
      "current-output-uri#0",
      "document#1",
      "document#2",
      "element-available#1",
      "function-available#1",
      "function-available#2",
      "key#2",
      "key#3",
      "permute#1",
      "next#0",
      "regex-group#1",
      "snapshot#0",
      "snapshot#1",
      "stream-available#1",
      "system-property#1",
      "type-available#1",
      "unparsed-entity-public-id#1",
      "unparsed-entity-public-id#2",
      "unparsed-entity-uri#1",
      "unparsed-entity-uri#2"
    ];
  }
  static {
    this.xpath40 = [
      "all#2",
      "characters#1",
      "highest#1",
      "highest#2",
      "highest#3",
      "identity#1",
      "in-scope-namespace#1",
      "index-where#2",
      "is-NAN#1",
      "items-after#2",
      "items-before#2",
      "items-from#2",
      "items-until#2",
      "lowest#1",
      "lowest#2",
      "lowest#3",
      "parcel#1",
      "parts#1",
      "range#0",
      "slice#4",
      "some#2",
      "unparcel#1"
    ].concat(FunctionData.xpath);
  }
  static {
    this.array = [
      "append#2",
      "filter#2",
      "flatten#1",
      "fold-left#3",
      "fold-right#3",
      "for-each#2",
      "for-each-pair#3",
      "get#2",
      "head#1",
      "insert-before#3",
      "join#1",
      "put#3",
      "remove#2",
      "reverse#1",
      "size#1",
      "sort#1",
      "sort#2",
      "sort#3",
      "subarray#2",
      "subarray#3",
      "tail#1"
    ];
  }
  static {
    this.array40 = ["members#1", "of#1"].concat(
      FunctionData.array
    );
  }
  static {
    this.map = [
      "contains#2",
      "entry#2",
      "find#2",
      "for-each#2",
      "get#2",
      "keys#1",
      "merge#1",
      "merge#2",
      "put#3",
      "remove#2",
      "size#1"
    ];
  }
  static {
    this.map40 = ["entries#1"].concat(FunctionData.map);
  }
  static {
    this.ixsl = [
      "apply#2",
      "call#3",
      "contains#2",
      "eval#1",
      "event#0",
      "get#2",
      "location#0",
      "page#0",
      "query-params#0",
      "source#2",
      "style#0",
      "style#1",
      "window#0"
    ];
  }
  static {
    this.math = [
      "acos#1",
      "asin#1",
      "atan#1",
      "atan2#2",
      "cos#1",
      "exp#1",
      "exp10#1",
      "log#1",
      "log10#1",
      "pi#0",
      "pow#2",
      "sin#1",
      "sqrt#1",
      "tan#1"
    ];
  }
  static {
    this.schema = [
      "string#1",
      "boolean#1",
      "integer#1",
      "int#1",
      "decimal#1",
      "float#1",
      "double#1",
      "duration#1",
      "dateTime#1",
      "time#1",
      "date#1",
      "gYearMonth#1",
      "gYear#1",
      "gMonthDay#1",
      "gDay#1",
      "gMonth#1",
      "hexBinary#1",
      "base64Binary#1",
      "anyURI#1",
      "QName#1",
      "normalizedString#1",
      "token#1",
      "language#1",
      "NMTOKEN#1",
      "Name#1",
      "NCName#1",
      "ID#1",
      "IDREF#1",
      "ENTITY#1",
      "nonPositiveInteger#1",
      "negativeInteger#1",
      "long#1",
      "short#1",
      "byte#1",
      "nonNegativeInteger#1",
      "unsignedLong#1",
      "unsignedInt#1",
      "unsignedShort#1",
      "unsignedByte#1",
      "positiveInteger#1",
      "yearMonthDuration#1",
      "dayTimeDuration#1",
      "untypedAtomic#1",
      "dateTimeStamp#1"
    ];
  }
  static {
    this.dfdl = [
      "dfdl:contentLength#2",
      "dfdl:valueLength#2",
      "dfdl:testBit#2",
      "dfdl:setBits#8",
      "dfdl:occursIndex#0",
      "dfdl:checkConstraints#1",
      "dfdl:encodeDFDLEntities#1",
      "dfdl:decodeDFDLEntities#1",
      "dfdl:containsDFDLEntities#1",
      "dfdl:timeZoneFromDateTime#1",
      "dfdl:timeZoneFromDate#1",
      "dfdl:timeZoneFromTime#1",
      "dfdl:checkRangeInclusive#3",
      "dfdl:checkRangeExclusive#3"
    ].concat(FunctionData.xpath);
  }
  static unionSimpleTypes() {
    const baseSimpleTypes = FunctionData.schema.map(
      (t) => "xs:" + t.substring(0, t.length - 2)
    );
    baseSimpleTypes.push("xs:numeric");
    return baseSimpleTypes;
  }
  static {
    this.simpleTypes = FunctionData.unionSimpleTypes();
  }
  static {
    this.namespaces = /* @__PURE__ */ new Map([
      [
        "http://www.w3.org/2005/xpath-functions/array",
        1
        /* Array */
      ],
      [
        "http://expath.org/ns/archive",
        2
        /* ExpathArchive */
      ],
      [
        "http://expath.org/ns/binary",
        3
        /* ExpathBinary */
      ],
      [
        "http://expath.org/ns/file",
        4
        /* ExpathFile */
      ],
      [
        "http://www.w3.org/2005/xpath-functions/map",
        10
        /* Map */
      ],
      [
        "http://www.w3.org/2005/xpath-functions/math",
        11
        /* Math */
      ],
      [
        "http://saxon.sf.net/",
        12
        /* Saxon */
      ],
      [
        "http://saxon.sf.net/sql",
        13
        /* SQL */
      ],
      [
        "http://www.w3.org/2001/XMLSchema",
        14
        /* XMLSchema */
      ],
      [
        "http://www.w3.org/2005/xpath-functions",
        15
        /* XPath */
      ],
      [
        "http://www.w3.org/1999/XSL/Transform",
        16
        /* XSLT */
      ],
      [
        "http://saxonica.com/ns/interactiveXSLT",
        17
        /* IXSL */
      ],
      [
        "http://exslt.org/common",
        5
        /* Exslt */
      ],
      [
        "http://exslt.org/math",
        6
        /* ExsltMath */
      ],
      [
        "http://exslt.org/regular-expressions",
        7
        /* ExsltRegex */
      ],
      [
        "http://exslt.org/sets",
        8
        /* ExsltSets */
      ],
      [
        "http://exslt.org/strings",
        9
        /* ExsltStrings */
      ]
    ]);
  }
  static {
    this.ixslEventName = [
      "ixsl:onafterprint",
      "ixsl:onbeforeprint",
      "ixsl:onbeforeunload",
      "ixsl:onerror",
      "ixsl:onhashchange",
      "ixsl:onload",
      "ixsl:onmessage",
      "ixsl:onoffline",
      "ixsl:ononline",
      "ixsl:onpagehide",
      "ixsl:onpageshow",
      "ixsl:onpopstate",
      "ixsl:onresize",
      "ixsl:onstorage",
      "ixsl:onunload",
      "ixsl:onblur",
      "ixsl:onchange",
      "ixsl:oncontextmenu",
      "ixsl:onfocus",
      "ixsl:oninput",
      "ixsl:oninvalid",
      "ixsl:onreset",
      "ixsl:onsearch",
      "ixsl:onselect",
      "ixsl:onsubmit",
      "ixsl:onkeydown",
      "ixsl:onkeypress",
      "ixsl:onkeyup",
      "ixsl:onclick",
      "ixsl:ondblclick",
      "ixsl:onmousedown",
      "ixsl:onmousemove",
      "ixsl:onmouseout",
      "ixsl:onmouseover",
      "ixsl:onmouseup",
      "ixsl:onmousewheel",
      "ixsl:onwheel",
      "ixsl:ondrag",
      "ixsl:ondragend",
      "ixsl:ondragenter",
      "ixsl:ondragleave",
      "ixsl:ondragover",
      "ixsl:ondragstart",
      "ixsl:ondrop",
      "ixsl:onscroll",
      "ixsl:oncopy",
      "ixsl:oncut",
      "ixsl:onpaste",
      "ixsl:onabort",
      "ixsl:oncanplay",
      "ixsl:oncanplaythrough",
      "ixsl:oncuechange",
      "ixsl:ondurationchange",
      "ixsl:onemptied",
      "ixsl:onended",
      "ixsl:onerror",
      "ixsl:onloadeddata",
      "ixsl:onloadedmetadata",
      "ixsl:onloadstart",
      "ixsl:onpause",
      "ixsl:onplay",
      "ixsl:onplaying",
      "ixsl:onprogress",
      "ixsl:onratechange",
      "ixsl:onseeked",
      "ixsl:onseeking",
      "ixsl:onstalled",
      "ixsl:onsuspend",
      "ixsl:ontimeupdate",
      "ixsl:onvolumechange",
      "ixsl:onwaiting"
    ];
  }
}
class XsltTokenDiagnostics {
  static {
    this.xsltStartTokenNumber = XslLexer.getXsltStartTokenNumber();
  }
  static {
    this.xsltCatchVariables = [
      "err:code",
      "err:description",
      "err:value",
      "err:module",
      "err:line-number",
      "err:column-number"
    ];
  }
  static {
    this.xslInclude = "xsl:include";
  }
  static {
    this.xslImport = "xsl:import";
  }
  static {
    this.xmlChars = ["lt", "gt", "quot", "apos", "amp"];
  }
  static {
    this.xslFunction = "xsl:function";
  }
  static {
    this.xslNameAtt = "name";
  }
  static {
    this.xslModeAtt = "mode";
  }
  static {
    this.useAttSet = "use-attribute-sets";
  }
  static {
    this.xslUseAttSet = "xsl:use-attribute-sets";
  }
  static {
    this.excludePrefixes = "exclude-result-prefixes";
  }
  static {
    this.xslExcludePrefixes = "xsl:exclude-result-prefixes";
  }
  static {
    this.brackets = [
      CharLevelState.lB,
      CharLevelState.lBr,
      CharLevelState.lPr,
      CharLevelState.rB,
      CharLevelState.rBr,
      CharLevelState.rPr
    ];
  }
  static isBracket(charState) {
    return XsltTokenDiagnostics.brackets.indexOf(charState) !== -1;
  }
  static {
    this.nameStartCharRgx = new RegExp(
      /[A-Z]|_|[a-z]|[\u00C0-\u00D6]|[\u00D8-\u00F6]|[\u00F8-\u02FF]|[\u0370-\u037D]|[\u037F-\u1FFF]|[\u200C-\u200D]|[\u2070-\u218F]|[\u2C00-\u2FEF]|[\u3001-\uD7FF]|[\uF900-\uFDCF]|[\uFDF0-\uFFFD]/
    );
  }
  static {
    this.nameCharRgx = new RegExp(
      /-|\.|[0-9]|\u00B7|[\u0300-\u036F]|[\u203F-\u2040]|[A-Z]|_|[a-z]|[\u00C0-\u00D6]|[\u00D8-\u00F6]|[\u00F8-\u02FF]|[\u0370-\u037D]|[\u037F-\u1FFF]|[\u200C-\u200D]|[\u2070-\u218F]|[\u2C00-\u2FEF]|[\u3001-\uD7FF]|[\uF900-\uFDCF]|[\uFDF0-\uFFFD]/
    );
  }
  static validateName(name, type, xmlnsPrefixes, elementStack, expectedAttributes) {
    let valid2 = 0;
    if (name.trim().length === 0) {
      return 2;
    }
    if (type === 0 || type === 2) {
      if (name === "xml:space" || name === "xml:lang" || name === "xml:base" || name === "xml:id") {
        return 0;
      }
    }
    let nameParts = name.split(":");
    if (nameParts.length > 2) {
      return 2;
    } else {
      if (nameParts.length === 2) {
        let prefix = nameParts[0];
        if (type === 1) {
          const expectedNames = elementStack && elementStack.length > 0 ? elementStack[elementStack.length - 1].expectedChildElements : ["xsl:transform", "xsl:stylesheet", "xsl:package"];
          if (prefix === "xsl" || prefix === "ixsl") {
            if (expectedNames.length === 0 && elementStack) {
              const withinNextIteration = elementStack[elementStack.length - 1].symbolName === "xsl:next-iteration";
              valid2 = name === "xsl:with-param" && withinNextIteration ? 0 : 3;
            } else {
              valid2 = expectedNames.indexOf(name) > -1 ? 0 : 3;
              if (valid2 !== 0 && (name === "xsl:next-iteration" || name === "xsl:break")) {
                const withinIterarator = elementStack?.find(
                  (item) => item.symbolName === "xsl:iterate"
                );
                if (withinIterarator) {
                  valid2 = 0;
                }
              }
            }
            return valid2;
          } else {
            valid2 = xmlnsPrefixes.indexOf(prefix) > -1 ? 0 : 1;
          }
        } else if (prefix === "xsl" && type === 2) ;
        else {
          valid2 = xmlnsPrefixes.indexOf(prefix) > -1 ? 0 : 1;
        }
      } else if ((type === 2 || type === 0) && expectedAttributes) {
        valid2 = expectedAttributes.indexOf(name) > -1 ? 0 : 4;
        return valid2;
      }
      if (valid2 === 0) {
        nameParts.forEach((namePart) => {
          if (valid2 === 0) {
            let charsOK = true;
            let firstChar = true;
            let charExists = false;
            for (let s of namePart) {
              if (firstChar) {
                firstChar = false;
                charExists = true;
                charsOK = XsltTokenDiagnostics.nameStartCharRgx.test(s);
                if (!charsOK) {
                  break;
                }
              } else {
                charsOK = XsltTokenDiagnostics.nameCharRgx.test(s);
                if (!charsOK) {
                  break;
                }
              }
            }
            valid2 = charExists && charsOK ? 0 : 2;
          }
        });
      }
    }
    return valid2;
  }
  static validateSimpleName(name) {
    let valid2 = false;
    const nameParts = name.split(":");
    if (nameParts.length > 2) {
      return false;
    }
    nameParts.forEach((namePart) => {
      let charsOK = true;
      let firstChar = true;
      let charExists = false;
      for (let s of namePart) {
        if (firstChar) {
          firstChar = false;
          charExists = true;
          charsOK = XsltTokenDiagnostics.nameStartCharRgx.test(s);
          if (!charsOK) {
            break;
          }
        } else {
          charsOK = XsltTokenDiagnostics.nameCharRgx.test(s);
          if (!charsOK) {
            break;
          }
        }
      }
      valid2 = charExists && charsOK;
    });
    return valid2;
  }
  static {
    this.calculateDiagnostics = (document2, allTokens, globalInstructionData, importedInstructionData, symbols, globalVariables, xmlNamespaces) => {
      let inScopeVariablesList = [];
      let xpathVariableCurrentlyBeingDefined;
      let elementStack = [];
      let inScopeXPathVariablesList = [];
      let anonymousFunctionParamList = [];
      let xpathStack = [];
      let preXPathVariable = false;
      let anonymousFunctionParams = false;
      let xsltVariableDeclarations = [];
      let unresolvedXsltVariableReferences = [];
      let prevToken = null;
      let includeOrImport = false;
      let problemTokens = [];
      let topLevelSymbols = symbols;
      let lastTokenIndex = allTokens.length - 1;
      let inheritedPrefixes = xmlNamespaces;
      let globalVariableData = [];
      let checkedGlobalVarNames = [];
      let checkedGlobalFnNames = [];
      let importedGlobalVarNames = globalVariables;
      let incrementFunctionArity = false;
      let xsltPrefixesToURIs = /* @__PURE__ */ new Map();
      let dtdEnded = false;
      let namedTemplates = /* @__PURE__ */ new Map();
      let globalModes = ["#current", "#default"];
      let globalKeys = [];
      let globalAccumulatorNames = [];
      let globalAttributeSetNames = [];
      let ifThenStack = [];
      globalInstructionData.forEach((instruction) => {
        switch (instruction.type) {
          case GlobalInstructionType.Variable:
          case GlobalInstructionType.Parameter:
            if (checkedGlobalVarNames.indexOf(instruction.name) < 0) {
              checkedGlobalVarNames.push(instruction.name);
            } else {
              instruction.token["error"] = ErrorType.DuplicateVarName;
              instruction.token.value = instruction.name;
              problemTokens.push(instruction.token);
            }
            globalVariableData.push({
              token: instruction.token,
              name: instruction.name
            });
            xsltVariableDeclarations.push(instruction.token);
            break;
          case GlobalInstructionType.Function:
            let functionNameWithArity = instruction.name + "#" + instruction.idNumber;
            if (checkedGlobalFnNames.indexOf(functionNameWithArity) < 0) {
              checkedGlobalFnNames.push(functionNameWithArity);
            } else {
              instruction.token["error"] = ErrorType.DuplicateFnName;
              instruction.token.value = functionNameWithArity;
              problemTokens.push(instruction.token);
            }
            break;
          case GlobalInstructionType.Template:
            if (namedTemplates.get(instruction.name)) {
              instruction.token["error"] = ErrorType.DuplicateTemplateName;
              instruction.token.value = instruction.name;
              problemTokens.push(instruction.token);
            } else {
              let members = instruction.memberNames ? instruction.memberNames : [];
              namedTemplates.set(instruction.name, members);
            }
            break;
          case GlobalInstructionType.Mode:
            let modes = instruction.name.split(/\s+/);
            globalModes = globalModes.concat(modes);
            break;
          case GlobalInstructionType.Key:
            globalKeys.push(instruction.name);
            break;
          case GlobalInstructionType.Accumulator:
            if (globalAccumulatorNames.indexOf(instruction.name) < 0) {
              globalAccumulatorNames.push(instruction.name);
            } else {
              instruction.token["error"] = ErrorType.DuplicateAccumulatorName;
              instruction.token.value = instruction.name;
              problemTokens.push(instruction.token);
            }
            break;
          case GlobalInstructionType.AttributeSet:
            globalAttributeSetNames.push(instruction.name);
            break;
          case GlobalInstructionType.RootXMLNS:
            inheritedPrefixes.push(instruction.name);
            break;
        }
      });
      importedInstructionData.forEach((instruction) => {
        switch (instruction.type) {
          case GlobalInstructionType.Variable:
          case GlobalInstructionType.Parameter:
            if (checkedGlobalVarNames.indexOf(instruction.name) < 0) {
              checkedGlobalVarNames.push(instruction.name);
              importedGlobalVarNames.push(instruction.name);
            }
            break;
          case GlobalInstructionType.Function:
            let functionNameWithArity = instruction.name + "#" + instruction.idNumber;
            if (checkedGlobalFnNames.indexOf(functionNameWithArity) < 0) {
              checkedGlobalFnNames.push(functionNameWithArity);
            }
            break;
          case GlobalInstructionType.Template:
            let members = instruction.memberNames ? instruction.memberNames : [];
            namedTemplates.set(instruction.name, members);
            break;
          case GlobalInstructionType.Mode:
            let modes = instruction.name.split(/\s+/);
            globalModes = globalModes.concat(modes);
            break;
          case GlobalInstructionType.Key:
            globalKeys.push(instruction.name);
            break;
          case GlobalInstructionType.Accumulator:
            globalAccumulatorNames.push(instruction.name);
            break;
          case GlobalInstructionType.AttributeSet:
            globalAttributeSetNames.push(instruction.name);
            break;
        }
      });
      xsltPrefixesToURIs.set("array", XSLTnamespaces.Array);
      xsltPrefixesToURIs.set("map", XSLTnamespaces.Map);
      xsltPrefixesToURIs.set("math", XSLTnamespaces.Map);
      xsltPrefixesToURIs.set("xs", XSLTnamespaces.XMLSchema);
      xsltPrefixesToURIs.set("fn", XSLTnamespaces.XPath);
      xsltPrefixesToURIs.set("xsl", XSLTnamespaces.XSLT);
      xsltPrefixesToURIs.set("ixsl", XSLTnamespaces.IXSL);
      xsltPrefixesToURIs.set("dfdl", XSLTnamespaces.dfdl);
      inheritedPrefixes = inheritedPrefixes.concat([
        "array",
        "map",
        "math",
        "xs",
        "fn",
        "xsl",
        "ixsl",
        "dfdl"
      ]);
      allTokens.forEach((token, index) => {
        let xpathCharType = token.charType;
        let xpathTokenType = token.tokenType;
        if (xpathStack.length > 0) {
          const tv = xpathStack[xpathStack.length - 1].token.value;
          if (prevToken?.charType === CharLevelState.sep && prevToken.value === "," && (tv === "for" || tv === "let" || tv === "every")) {
            if (xpathTokenType !== TokenLevelState.variable) {
              token["error"] = ErrorType.ExpectedDollarAfterComma;
              problemTokens.push(token);
            }
          }
        }
        switch (xpathTokenType) {
          case TokenLevelState.string:
            if (token.error) {
              problemTokens.push(token);
            }
            XsltTokenDiagnostics.checkTokenIsExpected(
              prevToken,
              token,
              problemTokens
            );
            if (xpathStack.length > 0) {
              let xp = xpathStack[xpathStack.length - 1];
              if (xp.functionArity === 0 && (xp.function?.value === "key" || xp.function?.value.startsWith("accumulator-"))) {
                let keyVal = token.value.substring(1, token.value.length - 1);
                if (xp.function.value === "key") {
                  if (globalKeys.indexOf(keyVal) < 0) {
                    token["error"] = ErrorType.XSLTKeyUnresolved;
                    problemTokens.push(token);
                  }
                } else if (globalAccumulatorNames.indexOf(keyVal) < 0) {
                  token["error"] = ErrorType.AccumulatorNameUnresolved;
                  problemTokens.push(token);
                }
              }
            }
            break;
          case TokenLevelState.axisName:
            if (token.error) {
              problemTokens.push(token);
            }
            XsltTokenDiagnostics.checkTokenIsExpected(
              prevToken,
              token,
              problemTokens
            );
            break;
          case TokenLevelState.variable:
            if (preXPathVariable && !xpathVariableCurrentlyBeingDefined || anonymousFunctionParams) {
              let fullVariableName = token.value;
              let currentVariable = {
                token,
                name: fullVariableName.substring(1)
              };
              if (anonymousFunctionParams) {
                anonymousFunctionParamList.push(currentVariable);
                xsltVariableDeclarations.push(token);
              } else {
                inScopeXPathVariablesList.push(currentVariable);
                xpathVariableCurrentlyBeingDefined = true;
                xsltVariableDeclarations.push(token);
              }
            } else {
              let prefixEnd = token.value.indexOf(":");
              if (prefixEnd !== -1) {
                let prefix = token.value.substring(1, prefixEnd);
                if (inheritedPrefixes.indexOf(prefix) === -1) {
                  token["error"] = ErrorType.XPathPrefix;
                  problemTokens.push(token);
                }
              }
              let globalVarName = null;
              let unResolvedToken = XsltTokenDiagnostics.resolveXPathVariableReference(
                globalVarName,
                document2,
                importedGlobalVarNames,
                token,
                xpathVariableCurrentlyBeingDefined,
                inScopeXPathVariablesList,
                xpathStack,
                inScopeVariablesList,
                elementStack,
                xmlNamespaces
              );
              if (unResolvedToken !== null) {
                unresolvedXsltVariableReferences.push(unResolvedToken);
              }
              XsltTokenDiagnostics.checkTokenIsExpected(
                prevToken,
                token,
                problemTokens
              );
            }
            break;
          case TokenLevelState.complexExpression:
            let valueText = token.value;
            switch (valueText) {
              case "if":
                ifThenStack.push(token);
                break;
              case "every":
              case "for":
              case "let":
              case "some":
                if (allTokens.length > index + 2) {
                  const opToken = allTokens[index + 2];
                  const expectedOp = valueText === "let" ? ":=" : "in";
                  if (opToken.value !== expectedOp) {
                    opToken["error"] = ErrorType.XPathExpectedComplex;
                    problemTokens.push(opToken);
                  }
                }
                if (index > 0) {
                  XsltTokenDiagnostics.checkTokenIsExpected(
                    prevToken,
                    allTokens[index - 1],
                    problemTokens,
                    TokenLevelState.Unset
                  );
                }
                preXPathVariable = true;
                xpathVariableCurrentlyBeingDefined = false;
                xpathStack.push({
                  token,
                  variables: inScopeXPathVariablesList.slice(),
                  preXPathVariable,
                  xpathVariableCurrentlyBeingDefined,
                  isRangeVar: true
                });
                break;
              case "then":
                if (ifThenStack.length > 0) {
                  ifThenStack.pop();
                } else {
                  token.error = ErrorType.XPathUnexpected;
                  problemTokens.push(token);
                }
                xpathStack.push({
                  token,
                  variables: inScopeXPathVariablesList.slice(),
                  preXPathVariable,
                  xpathVariableCurrentlyBeingDefined
                });
                inScopeXPathVariablesList = [];
                break;
              case "return":
              case "satisfies":
              case "else":
                let tokenValBeforeDelete = xpathStack.length > 0 ? xpathStack[xpathStack.length - 1].token.value : "";
                if (xpathStack.length > 1) {
                  let deleteCount = 0;
                  for (let i = xpathStack.length - 1; i > -1; i--) {
                    const sv2 = xpathStack[i].token.value;
                    if (sv2 === "return" || sv2 === "else" || sv2 === "satisfies") {
                      deleteCount++;
                    } else {
                      break;
                    }
                  }
                  if (deleteCount > 0) {
                    xpathStack.splice(xpathStack.length - deleteCount);
                  }
                }
                if (xpathStack.length > 0) {
                  let peekedStack = xpathStack[xpathStack.length - 1];
                  if (peekedStack) {
                    if (valueText === "else") {
                      preXPathVariable = peekedStack.preXPathVariable;
                    } else {
                      preXPathVariable = false;
                    }
                    xpathVariableCurrentlyBeingDefined = peekedStack.xpathVariableCurrentlyBeingDefined;
                    let matchingToken = XsltTokenDiagnostics.getMatchingToken(
                      peekedStack.token.value
                    );
                    if (!token.error && matchingToken !== token.value) {
                      token["error"] = ErrorType.BracketNesting;
                      problemTokens.push(token);
                    } else {
                      peekedStack.token = token;
                    }
                  } else {
                    inScopeXPathVariablesList = [];
                    preXPathVariable = false;
                    xpathVariableCurrentlyBeingDefined = false;
                  }
                } else if (tokenValBeforeDelete !== "") {
                  let matchingToken = XsltTokenDiagnostics.getMatchingToken(tokenValBeforeDelete);
                  if (!token.error && matchingToken !== token.value) {
                    token["error"] = ErrorType.BracketNesting;
                    problemTokens.push(token);
                  }
                }
                break;
            }
            break;
          case TokenLevelState.mapKey:
            if (!(prevToken && prevToken.tokenType === TokenLevelState.operator && (prevToken.value === "," || prevToken.value === "{"))) {
              token["error"] = ErrorType.XPathUnexpected;
              problemTokens.push(token);
            }
            break;
          case TokenLevelState.operator:
            let isXPathError = false;
            let tv = token.value;
            let stackItem = xpathStack.length > 0 ? xpathStack[xpathStack.length - 1] : void 0;
            const sv = stackItem?.token.value;
            const tokenIsComma = tv === ",";
            const popStackLaterForComma = sv && tokenIsComma && (sv === "return" || sv === "else" || sv === "satisfies");
            if (popStackLaterForComma && xpathStack.length > 1) {
              stackItem = xpathStack[xpathStack.length - 2];
            }
            if (stackItem && stackItem.curlyBraceType === 1) {
              if (tokenIsComma) {
                if (stackItem.awaitingMapKey) {
                  isXPathError = true;
                } else {
                  stackItem.awaitingMapKey = true;
                }
              } else if (tv === "}" && stackItem.awaitingMapKey) {
                isXPathError = true;
              }
            }
            if (prevToken?.tokenType === TokenLevelState.complexExpression) {
              let currCharType = token.charType;
              if (currCharType === CharLevelState.rB || currCharType === CharLevelState.rBr || currCharType === CharLevelState.rPr) {
                if (prevToken.value === "return" || prevToken.value === "satisfies" || prevToken.value === "else" || prevToken.value === "then") {
                  prevToken["error"] = ErrorType.XPathAwaiting;
                  problemTokens.push(prevToken);
                }
              } else if (tokenIsComma) {
                prevToken["error"] = ErrorType.XPathAwaiting;
                problemTokens.push(prevToken);
              }
            } else if (prevToken?.tokenType === TokenLevelState.uriLiteral) {
              token["error"] = ErrorType.XPathUnexpected;
              problemTokens.push(token);
            } else if (prevToken && tv !== "/" && prevToken.value !== "/" && !prevToken.error) {
              let currCharType = token.charType;
              let nextToken = index + 1 < allTokens.length ? allTokens[index + 1] : void 0;
              if (tv === ":") {
                if (stackItem && stackItem.curlyBraceType === 1) {
                  if (stackItem.awaitingMapKey) {
                    stackItem.awaitingMapKey = false;
                  } else {
                    isXPathError = true;
                  }
                } else if (prevToken.tokenType === TokenLevelState.nodeNameTest || prevToken.tokenType === TokenLevelState.attributeNameTest) {
                  isXPathError = !(prevToken.startCharacter + prevToken.length === token.startCharacter && nextToken?.value === "*");
                } else {
                  isXPathError = true;
                }
              }
              if (tv === "map" || tv === "array") {
                XsltTokenDiagnostics.checkTokenIsExpected(
                  prevToken,
                  token,
                  problemTokens,
                  TokenLevelState.function
                );
              } else if ((tv === "+" || tv === "-") && nextToken && nextToken.tokenType !== TokenLevelState.string) ;
              else if (prevToken.tokenType === TokenLevelState.operator) {
                let prevCharType = prevToken.charType;
                let pv = prevToken.value;
                switch (currCharType) {
                  case CharLevelState.rB:
                  case CharLevelState.rBr:
                  case CharLevelState.rPr:
                    if (!XsltTokenDiagnostics.isBracket(prevCharType)) {
                      if (!(prevToken.charType === CharLevelState.sep && pv === "?" && tv === ")" || prevToken.charType === CharLevelState.dSep && (pv === "{}" || pv === "()" || pv === "[]"))) {
                        isXPathError = true;
                      }
                    }
                    break;
                  case CharLevelState.dSep:
                    if (prevCharType === CharLevelState.rB || prevCharType === CharLevelState.rPr || prevCharType === CharLevelState.rBr || prevCharType === CharLevelState.dSep && (pv === "()" || pv === "[]" || pv === "{}")) {
                      isXPathError = tv === "*:";
                    } else if (tv === "*:" || tv === "//") ;
                    else if (!(tv === "{}" && (pv === "map" || pv === "array") || tv === "()" || tv === "[]")) {
                      isXPathError = true;
                    }
                    break;
                  case CharLevelState.lB:
                  case CharLevelState.lBr:
                  case CharLevelState.lPr:
                    break;
                  default:
                    switch (prevCharType) {
                      case CharLevelState.rB:
                      case CharLevelState.rBr:
                      case CharLevelState.rPr:
                        break;
                      case CharLevelState.dSep:
                        if (!(pv === "()" || pv === "{}" || pv === "[]")) {
                          isXPathError = true;
                        }
                        break;
                      default:
                        if (pv === "&gt;" && tv === "&gt;" || pv === "&lt;" && (tv === "&lt;" || tv === "&gt;")) ;
                        else if (tv === "as") {
                          isXPathError = pv !== "castable" && pv !== "cast" && pv !== "treat";
                        } else if (tv === "of") {
                          isXPathError = pv !== "instance";
                        } else if (!(pv === "?" && (tv === "," || tv === ")") || tv === "?" && (pv === "(" || pv === ")" || pv === ",") || pv === "!" && tv === "?" || pv === "[" && tv === "?")) {
                          isXPathError = true;
                        }
                        break;
                    }
                }
              }
              if (isXPathError) {
                token["error"] = ErrorType.XPathUnexpected;
                problemTokens.push(token);
              }
            }
            let functionToken = null;
            switch (xpathCharType) {
              case CharLevelState.lBr:
                let curlyBraceType = 0;
                if (prevToken && prevToken.tokenType === TokenLevelState.operator) {
                  if (prevToken.value === "map") {
                    curlyBraceType = 1;
                  } else if (prevToken.value === "array") {
                    curlyBraceType = 2;
                  }
                }
                const stackItem2 = {
                  token,
                  variables: inScopeXPathVariablesList,
                  preXPathVariable,
                  xpathVariableCurrentlyBeingDefined,
                  curlyBraceType
                };
                if (curlyBraceType === 1) {
                  stackItem2.awaitingMapKey = true;
                }
                xpathStack.push(stackItem2);
                if (anonymousFunctionParams) {
                  inScopeXPathVariablesList = anonymousFunctionParamList;
                  anonymousFunctionParamList = [];
                  anonymousFunctionParams = false;
                } else {
                  inScopeXPathVariablesList = [];
                }
                preXPathVariable = false;
                xpathVariableCurrentlyBeingDefined = false;
                break;
              case CharLevelState.lB:
                if (!anonymousFunctionParams && prevToken?.tokenType !== TokenLevelState.nodeType) {
                  anonymousFunctionParams = prevToken?.tokenType === TokenLevelState.anonymousFunction;
                }
                if (prevToken?.tokenType === TokenLevelState.function) {
                  functionToken = prevToken;
                } else if (prevToken?.tokenType === TokenLevelState.variable) {
                  incrementFunctionArity = false;
                }
              // intentionally no-break;
              case CharLevelState.lPr:
                let xpathItem = {
                  token,
                  variables: inScopeXPathVariablesList,
                  preXPathVariable,
                  xpathVariableCurrentlyBeingDefined
                };
                if (functionToken) {
                  xpathItem.function = functionToken;
                  if (incrementFunctionArity) {
                    xpathItem.functionArity = 1;
                    incrementFunctionArity = false;
                  } else {
                    xpathItem.functionArity = 0;
                  }
                }
                xpathStack.push(xpathItem);
                preXPathVariable = false;
                inScopeXPathVariablesList = [];
                xpathVariableCurrentlyBeingDefined = false;
                break;
              case CharLevelState.rB:
              case CharLevelState.rPr:
              case CharLevelState.rBr:
                if (xpathStack.length > 1) {
                  let deleteCount = 0;
                  for (let i = xpathStack.length - 1; i > -1; i--) {
                    const sv2 = xpathStack[i].token.value;
                    if (sv2 === "return" || sv2 === "else" || sv2 === "satisfies") {
                      deleteCount++;
                    } else {
                      break;
                    }
                  }
                  if (deleteCount > 0) {
                    xpathStack.splice(xpathStack.length - deleteCount);
                  }
                }
                if (xpathStack.length > 0) {
                  let poppedData = xpathStack.pop();
                  if (poppedData) {
                    if (poppedData.token.value === "then") {
                      poppedData.token["error"] = ErrorType.BracketNesting;
                      problemTokens.push(poppedData.token);
                    }
                    inScopeXPathVariablesList = poppedData.variables;
                    preXPathVariable = poppedData.preXPathVariable;
                    xpathVariableCurrentlyBeingDefined = poppedData.xpathVariableCurrentlyBeingDefined;
                    if (poppedData.function && poppedData.functionArity !== void 0) {
                      if (prevToken?.charType !== CharLevelState.lB) {
                        if (poppedData.functionArity !== void 0) {
                          poppedData.functionArity++;
                        }
                      }
                      let { isValid: isValid2, qFunctionName: qFunctionName2, fErrorType: fErrorType2 } = XsltTokenDiagnostics.isValidFunctionName(
                        inheritedPrefixes,
                        xsltPrefixesToURIs,
                        poppedData.function,
                        checkedGlobalFnNames,
                        poppedData.functionArity
                      );
                      if (!isValid2) {
                        poppedData.function["error"] = fErrorType2;
                        poppedData.function["value"] = qFunctionName2;
                        problemTokens.push(poppedData.function);
                      }
                    }
                  } else {
                    inScopeXPathVariablesList = [];
                    preXPathVariable = false;
                    xpathVariableCurrentlyBeingDefined = false;
                  }
                }
                if (token.error && !isXPathError) {
                  problemTokens.push(token);
                }
                break;
              case CharLevelState.sep:
                if (token.value === ",") {
                  if (xpathStack.length > 0) {
                    let xp = xpathStack[xpathStack.length - 1];
                    if (xp.functionArity !== void 0) {
                      xp.functionArity++;
                    }
                    if (xp.isRangeVar) {
                      preXPathVariable = xp.preXPathVariable;
                    }
                    let nonBracketedThen = -1;
                    for (let i = xpathStack.length - 1; i > -1; i--) {
                      const xpathItem2 = xpathStack[i].token;
                      const val = xpathItem2.value;
                      if (!(val === "return" || val === "else" || val === "satisfies" || val === "then")) {
                        break;
                      } else if (val === "then") {
                        nonBracketedThen = i;
                      }
                    }
                    if (nonBracketedThen > -1) {
                      token["error"] = ErrorType.ExpectedElseAfterThen;
                      problemTokens.push(token);
                    }
                    const sv2 = xp.token.value;
                    if (sv2 === "return" || sv2 === "else" || sv2 === "satisfies") {
                      let poppedData = xpathStack.pop();
                      if (poppedData) {
                        inScopeXPathVariablesList = poppedData.variables;
                        if (sv2 === "else") {
                          preXPathVariable = poppedData.preXPathVariable;
                        } else {
                          preXPathVariable = false;
                        }
                        xpathVariableCurrentlyBeingDefined = false;
                      }
                    }
                  }
                  xpathVariableCurrentlyBeingDefined = false;
                }
                break;
              case CharLevelState.dSep:
                const isEmptyBracketsToken = token.value === "()";
                if (isEmptyBracketsToken && prevToken?.tokenType === TokenLevelState.function) {
                  const fnArity = incrementFunctionArity ? 1 : 0;
                  incrementFunctionArity = false;
                  let { isValid: isValid2, qFunctionName: qFunctionName2, fErrorType: fErrorType2 } = XsltTokenDiagnostics.isValidFunctionName(
                    inheritedPrefixes,
                    xsltPrefixesToURIs,
                    prevToken,
                    checkedGlobalFnNames,
                    fnArity
                  );
                  if (!isValid2) {
                    prevToken["error"] = fErrorType2;
                    prevToken["value"] = qFunctionName2;
                    problemTokens.push(prevToken);
                    prevToken.tokenType = TokenLevelState.Unset;
                  }
                } else if (isEmptyBracketsToken && prevToken?.tokenType === TokenLevelState.variable) {
                  incrementFunctionArity = false;
                } else if (token.value === "=>") {
                  incrementFunctionArity = true;
                }
                break;
            }
            break;
          case TokenLevelState.nodeType:
            if (token.value === ":*" && prevToken && !prevToken.error) {
              let pfx = prevToken.tokenType === TokenLevelState.attributeNameTest ? prevToken.value.substring(1) : prevToken.value;
              if (inheritedPrefixes.indexOf(pfx) === -1 && pfx !== "xml") {
                prevToken["error"] = ErrorType.XPathPrefix;
                problemTokens.push(prevToken);
              }
            }
            break;
          case TokenLevelState.attributeNameTest:
          case TokenLevelState.nodeNameTest:
            if (token.error) {
              problemTokens.push(token);
            } else {
              let tokenValue;
              let validationType;
              let skipValidation = false;
              if (xpathTokenType === TokenLevelState.nodeNameTest) {
                tokenValue = token.value;
                validationType = 3;
              } else {
                tokenValue = token.value.substr(1);
                validationType = 0;
                skipValidation = token.value === "@xml";
                if (!skipValidation && token.value === "@") {
                  let nextToken = allTokens.length > index + 1 ? allTokens[index + 1] : null;
                  skipValidation = nextToken ? token.value === "@" && (nextToken.value === "*" || nextToken.value === "*:") : false;
                }
              }
              if (!skipValidation) {
                let validateResult = XsltTokenDiagnostics.validateName(
                  tokenValue,
                  validationType,
                  inheritedPrefixes
                );
                if (validateResult !== 0) {
                  token["error"] = validateResult === 2 ? ErrorType.XPathName : ErrorType.XPathPrefix;
                  token["value"] = token.value;
                  problemTokens.push(token);
                }
              }
            }
            XsltTokenDiagnostics.checkTokenIsExpected(
              prevToken,
              token,
              problemTokens
            );
            break;
          case TokenLevelState.functionNameTest:
            let { isValid, qFunctionName, fErrorType } = XsltTokenDiagnostics.isValidFunctionName(
              inheritedPrefixes,
              xsltPrefixesToURIs,
              token,
              checkedGlobalFnNames
            );
            if (!isValid) {
              token["error"] = fErrorType;
              token["value"] = qFunctionName;
              problemTokens.push(token);
            }
            break;
          case TokenLevelState.function:
          case TokenLevelState.number:
            XsltTokenDiagnostics.checkTokenIsExpected(
              prevToken,
              token,
              problemTokens
            );
            break;
          case TokenLevelState.simpleType:
            let tValue = token.value;
            let tParts = tValue.split(":");
            let isValidType = false;
            if (tValue === "*" || tValue === "?" || tValue === "+") {
              isValidType = true;
            } else if (tParts.length === 1) {
              let nextToken = allTokens.length > index + 1 ? allTokens[index + 1] : null;
              if (nextToken && (nextToken.charType === CharLevelState.lB || nextToken.charType === CharLevelState.dSep && nextToken.value === "()")) {
                isValidType = Data.nodeTypes.indexOf(tParts[0]) > -1;
                if (!isValidType) {
                  isValidType = Data.nonFunctionTypes.indexOf(tParts[0]) > -1;
                }
              }
            } else if (tParts.length === 2) {
              let nsType = xsltPrefixesToURIs.get(tParts[0]);
              if (nsType !== void 0) {
                if (nsType === XSLTnamespaces.XMLSchema) {
                  if (tParts[1] === "numeric") {
                    isValidType = true;
                  } else {
                    isValidType = FunctionData.schema.indexOf(tParts[1] + "#1") > -1;
                  }
                }
              }
            }
            if (!isValidType) {
              token["error"] = ErrorType.XPathTypeName;
              problemTokens.push(token);
            }
            break;
          case TokenLevelState.entityRef:
            if (token.error) {
              problemTokens.push(token);
            } else {
              let validationResult, entityName;
              ({ validationResult, entityName } = XsltTokenDiagnostics.validateEntityRef(
                token.value,
                dtdEnded,
                inheritedPrefixes
              ));
              if (validationResult !== 0) {
                token["error"] = ErrorType.EntityName;
                token["value"] = entityName;
                problemTokens.push(token);
              }
            }
            break;
        }
        if (index === lastTokenIndex && !token.error) {
          if (token.tokenType === TokenLevelState.operator) {
            XsltTokenDiagnostics.checkFinalXPathToken(
              token,
              allTokens,
              index,
              problemTokens
            );
          }
          if (xpathStack.length > 0 && !token.error) {
            let disallowedStackItem;
            for (let index2 = xpathStack.length - 1; index2 > -1; index2--) {
              const trailingToken = xpathStack[index2].token;
              const tv = trailingToken.value;
              const allowedToken = tv === "return" || tv === "else" || tv === "satisfies";
              if (!allowedToken) {
                disallowedStackItem = trailingToken;
                break;
              }
            }
            if (disallowedStackItem) {
              disallowedStackItem["error"] = ErrorType.BracketNesting;
              problemTokens.push(disallowedStackItem);
            }
          }
          if (token.tokenType === TokenLevelState.string && !token.error) {
            XPathLexer.checkStringLiteralEnd(token);
            if (token.error) {
              problemTokens.push(token);
            }
          }
        }
        prevToken = token.tokenType === TokenLevelState.comment ? prevToken : token;
        if (index === lastTokenIndex) {
          if (token.tokenType === TokenLevelState.complexExpression) {
            token["error"] = ErrorType.XPathAwaiting;
            problemTokens.push(token);
          }
          if (elementStack.length > 0) {
            let usedtoken = false;
            while (elementStack.length > 0) {
              let poppedData = elementStack.pop();
              let endToken;
              if (poppedData) {
                if (usedtoken) {
                  endToken = token;
                  endToken.length = endToken.length - 1;
                } else {
                  endToken = token;
                  usedtoken = true;
                }
                let errorToken = Object.assign({}, poppedData.identifierToken);
                errorToken["error"] = ErrorType.ElementNesting;
                problemTokens.push(errorToken);
                let symbol = XsltTokenDiagnostics.createSymbolFromElementTokens(
                  poppedData.symbolName,
                  poppedData.symbolID,
                  poppedData.identifierToken,
                  endToken
                );
                if (symbol !== null) {
                  if (elementStack.length > 0) {
                    elementStack[elementStack.length - 1].childSymbols.push(
                      symbol
                    );
                  } else {
                    topLevelSymbols.push(symbol);
                  }
                }
              }
            }
          }
        }
      });
      let variableRefDiagnostics = XsltTokenDiagnostics.getDiagnosticsFromUnusedVariableTokens(
        xsltVariableDeclarations,
        unresolvedXsltVariableReferences,
        includeOrImport
      );
      let allDiagnostics = XsltTokenDiagnostics.appendDiagnosticsFromProblemTokens(
        variableRefDiagnostics,
        problemTokens
      );
      return allDiagnostics;
    };
  }
  static checkFinalXPathToken(prevToken, allTokens, index, problemTokens) {
    let isValid = false;
    switch (prevToken.charType) {
      case CharLevelState.rB:
      case CharLevelState.rBr:
      case CharLevelState.rPr:
        isValid = true;
        break;
      case CharLevelState.dSep:
        isValid = prevToken.value === "()" || prevToken.value === "[]" || prevToken.value === "{}";
        break;
      default:
        if (prevToken.value === "%") {
          isValid = true;
        } else if (prevToken.value === "/" || prevToken.value === ".") {
          let prevToken2 = allTokens[index - 2];
          let tokenBeforePrevWasXSLT = prevToken2.tokenType >= XsltTokenDiagnostics.xsltStartTokenNumber;
          isValid = tokenBeforePrevWasXSLT || prevToken2.tokenType === TokenLevelState.operator && prevToken2.charType !== CharLevelState.rB && prevToken2.charType !== CharLevelState.rBr && prevToken2.charType !== CharLevelState.rPr;
        }
        break;
    }
    if (!isValid) {
      prevToken["error"] = ErrorType.XPathOperatorUnexpected;
      problemTokens.push(prevToken);
    }
  }
  static validateEntityRef(entityName, dtdEnded, inheritedPrefixes) {
    let validationResult = 0;
    if (entityName.length > 2 && entityName.endsWith(";")) {
      entityName = entityName.substring(1, entityName.length - 1);
      if (entityName.length > 1 && entityName.charAt(0) === "#") {
        let validNumber;
        if (entityName.charAt(1).toLocaleLowerCase() === "x") {
          validNumber = /^#[Xx][0-9a-fA-F]+$/.test(entityName);
        } else {
          validNumber = /^#[0-9]+$/.test(entityName);
        }
        validationResult = validNumber ? 0 : 2;
      } else if (!dtdEnded) {
        let isXmlChar = XsltTokenDiagnostics.xmlChars.indexOf(entityName) > -1;
        validationResult = isXmlChar ? 0 : 2;
      } else {
        validationResult = XsltTokenDiagnostics.validateName(
          entityName,
          4,
          inheritedPrefixes
        );
      }
    } else {
      validationResult = 2;
    }
    return { validationResult, entityName };
  }
  static checkTokenIsExpected(prevToken, token, problemTokens, overridType) {
    if (token.error) {
      return;
    }
    let tokenType = overridType ? overridType : token.tokenType;
    let errorSingleSeparators;
    if (tokenType === TokenLevelState.number) {
      errorSingleSeparators = ["|"];
    } else if (tokenType === TokenLevelState.string) {
      errorSingleSeparators = ["|", "+", "-", "*"];
    } else {
      errorSingleSeparators = [];
    }
    let errDoubleSeparators;
    if (tokenType === TokenLevelState.nodeNameTest) {
      errDoubleSeparators = ["{}", "[]", "()"];
    } else if (tokenType === TokenLevelState.number || tokenType === TokenLevelState.string) {
      errDoubleSeparators = ["{}", "[]", "()", "*:", "::", "//"];
    } else {
      errDoubleSeparators = ["{}", "[]", "()", "*:", "::"];
    }
    if (prevToken) {
      let isXPathError = false;
      if (prevToken.tokenType === TokenLevelState.complexExpression || prevToken.tokenType === TokenLevelState.entityRef) ;
      else if (prevToken.tokenType === TokenLevelState.uriLiteral && tokenType !== TokenLevelState.nodeNameTest) {
        isXPathError = true;
      } else if (prevToken.tokenType === TokenLevelState.operator) {
        if (prevToken.charType === CharLevelState.rB || prevToken.charType === CharLevelState.rPr || prevToken.charType === CharLevelState.rPr) {
          isXPathError = true;
        } else if (prevToken.charType === CharLevelState.dSep) {
          if (errDoubleSeparators.indexOf(prevToken.value) !== -1) {
            isXPathError = true;
          }
        } else if (prevToken.charType === CharLevelState.sep) {
          if (errorSingleSeparators.indexOf(prevToken.value) !== -1) {
            isXPathError = true;
          }
        }
      } else if (tokenType === TokenLevelState.nodeNameTest && prevToken.tokenType === TokenLevelState.uriLiteral) ;
      else if (tokenType === TokenLevelState.string && prevToken.tokenType === TokenLevelState.string) {
        const currentTokenFirstChar = token.value.charAt(0);
        if (currentTokenFirstChar === '"' || currentTokenFirstChar === "'") {
          isXPathError = true;
        }
      } else {
        isXPathError = true;
      }
      if (isXPathError) {
        let errType = tokenType === TokenLevelState.function ? ErrorType.XPathFunctionUnexpected : ErrorType.XPathUnexpected;
        token.error = errType;
        problemTokens.push(token);
      }
    }
  }
  static isValidFunctionName(xmlnsPrefixes, xmlnsData, token, checkedGlobalFnNames, arity) {
    let tokenValue;
    if (arity === void 0) {
      let parts = token.value.split("#");
      arity = Number.parseInt(parts[1]);
      tokenValue = parts[0];
    } else {
      tokenValue = token.value;
    }
    let qFunctionName = tokenValue + "#" + arity;
    let fNameParts = qFunctionName.split(":");
    let isValid = false;
    let fErrorType = ErrorType.XPathFunction;
    if (fNameParts.length === 1) {
      if (tokenValue === "concat" || tokenValue === "codepoints-to-string") {
        isValid = arity > 0;
      } else {
        isValid = FunctionData.xpath.indexOf(fNameParts[0]) > -1;
      }
    } else {
      let xsltType = xmlnsData.get(fNameParts[0]);
      if (xmlnsPrefixes.indexOf(fNameParts[0]) < 0) {
        fErrorType = ErrorType.XPathFunctionNamespace;
        isValid = false;
      } else if (xsltType === XSLTnamespaces.NotDefined || xsltType === void 0) {
        isValid = checkedGlobalFnNames.indexOf(qFunctionName) > -1;
      } else {
        switch (xsltType) {
          case XSLTnamespaces.XPath:
            isValid = FunctionData.xpath.indexOf(fNameParts[1]) > -1;
            break;
          case XSLTnamespaces.Array:
            isValid = FunctionData.array.indexOf(fNameParts[1]) > -1;
            break;
          case XSLTnamespaces.Map:
            isValid = FunctionData.map.indexOf(fNameParts[1]) > -1;
            break;
          case XSLTnamespaces.Math:
            isValid = FunctionData.math.indexOf(fNameParts[1]) > -1;
            break;
          case XSLTnamespaces.XMLSchema:
            isValid = FunctionData.schema.indexOf(fNameParts[1]) > -1;
            break;
          case XSLTnamespaces.IXSL:
            isValid = FunctionData.ixsl.indexOf(fNameParts[1]) > -1;
            break;
          case XSLTnamespaces.Saxon:
          case XSLTnamespaces.ExpathArchive:
          case XSLTnamespaces.ExpathBinary:
          case XSLTnamespaces.ExpathFile:
          case XSLTnamespaces.Exslt:
          case XSLTnamespaces.ExsltMath:
          case XSLTnamespaces.ExsltRegex:
          case XSLTnamespaces.ExsltSets:
          case XSLTnamespaces.ExsltStrings:
            isValid = true;
            break;
          case XSLTnamespaces.dfdl:
            isValid = true;
            break;
        }
      }
    }
    fErrorType = isValid ? ErrorType.None : fErrorType;
    return { isValid, qFunctionName, fErrorType };
  }
  static getTextForToken(lineNumber, token, document2) {
    let start = token.startCharacter;
    if (start < 0) {
      console.error(
        "ERROR: Found illegal token for document: " + document2.fileName
      );
      console.error(
        "token.startCharacter less than zero: " + token.startCharacter
      );
      console.error(token);
      start = 0;
    }
    let startPos = new vscode__namespace.Position(lineNumber, start);
    let endPos = new vscode__namespace.Position(lineNumber, start + token.length);
    const currentLine = document2.lineAt(lineNumber);
    let valueRange = currentLine.range.with(startPos, endPos);
    let valueText = document2.getText(valueRange);
    return valueText;
  }
  static resolveXPathVariableReference(globalVarName, document2, importedVariables, token, xpathVariableCurrentlyBeingDefined, inScopeXPathVariablesList, xpathStack, inScopeVariablesList, elementStack, xmlNamespaces) {
    let fullVarName = XsltTokenDiagnostics.getTextForToken(
      token.line,
      token,
      document2
    );
    let varName = fullVarName.startsWith("$") ? fullVarName.substring(1) : fullVarName.substring(1, fullVarName.length - 1);
    let result = null;
    let globalVariable = null;
    let resolved = this.resolveVariableName(
      inScopeXPathVariablesList,
      varName,
      xpathVariableCurrentlyBeingDefined,
      globalVariable
    );
    if (!resolved) {
      resolved = this.resolveStackVariableName(xpathStack, varName);
    }
    if (!resolved) {
      resolved = this.resolveVariableName(
        inScopeVariablesList,
        varName,
        false,
        globalVariable
      );
    }
    if (!resolved) {
      if (elementStack.length === 1 && globalVarName === varName) ;
      else {
        resolved = this.resolveStackVariableName(elementStack, varName);
      }
    }
    let importedResolved = false;
    if (!resolved) {
      importedResolved = globalVarName !== varName && importedVariables.indexOf(varName) > -1;
    }
    if (!resolved && !importedResolved && varName.includes(":")) {
      let splits = varName.split(":");
      resolved = xmlNamespaces.includes(splits[0]) ? token : void 0;
    }
    if (!resolved && !importedResolved) {
      result = token;
    }
    return result;
  }
  static createSymbolFromElementTokens(name, id, fullStartToken, fullEndToken, innerToken) {
    let kind;
    if (name.trim().length === 0) {
      return null;
    }
    switch (fullStartToken.tagType) {
      case 2:
        kind = vscode__namespace.SymbolKind.Enum;
        break;
      case 0:
        switch (name) {
          case "xsl:package":
          case "xsl:stylesheet":
          case "xsl:transform":
            kind = vscode__namespace.SymbolKind.Package;
            break;
          case "xsl:function":
            kind = vscode__namespace.SymbolKind.Function;
            break;
          case "xsl:template":
            kind = vscode__namespace.SymbolKind.Interface;
            break;
          case "xsl:if":
          case "xsl:when":
          case "xsl:otherwise":
            kind = vscode__namespace.SymbolKind.Namespace;
            break;
          case "xsl:key":
            kind = vscode__namespace.SymbolKind.Key;
            break;
          case "xsl:sequence":
            kind = vscode__namespace.SymbolKind.Module;
            break;
          case "xsl:value-of":
          case "xsl:text":
            kind = vscode__namespace.SymbolKind.String;
            break;
          case "xsl:for-each":
          case "xsl:for-each-group":
          case "xsl:apply-templates":
          case "xsl:iterate":
            kind = vscode__namespace.SymbolKind.EnumMember;
            break;
          case "xsl:import":
          case "xsl:include":
            kind = vscode__namespace.SymbolKind.File;
            break;
          case "xsl:choose":
            kind = vscode__namespace.SymbolKind.TypeParameter;
            break;
          default:
            kind = vscode__namespace.SymbolKind.Object;
            break;
        }
        break;
      case 1:
        kind = vscode__namespace.SymbolKind.Object;
        break;
      default:
        kind = vscode__namespace.SymbolKind.Null;
        break;
    }
    let startCharPos = fullStartToken.startCharacter > 0 ? fullStartToken.startCharacter - 1 : 0;
    let startPos = new vscode__namespace.Position(fullStartToken.line, startCharPos);
    let endPos = new vscode__namespace.Position(
      fullEndToken.line,
      fullEndToken.startCharacter + fullEndToken.length + 1
    );
    let innerStartPos;
    let innerEndPos;
    if (innerToken) {
      innerStartPos = new vscode__namespace.Position(
        innerToken.line,
        innerToken.startCharacter
      );
      innerEndPos = new vscode__namespace.Position(
        innerToken.line,
        innerToken.startCharacter + innerToken.length
      );
    } else {
      innerStartPos = new vscode__namespace.Position(
        fullStartToken.line,
        fullStartToken.startCharacter
      );
      innerEndPos = new vscode__namespace.Position(
        fullEndToken.line,
        fullStartToken.startCharacter + fullStartToken.length
      );
    }
    let fullRange = new vscode__namespace.Range(startPos, endPos);
    let innerRange = new vscode__namespace.Range(innerStartPos, innerEndPos);
    if (!fullRange.contains(innerRange)) {
      innerStartPos = new vscode__namespace.Position(
        fullStartToken.line,
        fullStartToken.startCharacter
      );
      innerEndPos = new vscode__namespace.Position(
        fullStartToken.line,
        fullStartToken.startCharacter + fullStartToken.length
      );
      innerRange = new vscode__namespace.Range(innerStartPos, innerEndPos);
    }
    let detail = "";
    let fullSymbolName = id.length > 0 ? name + " › " + id : name;
    if (fullRange.contains(innerRange)) {
      return new vscode__namespace.DocumentSymbol(
        fullSymbolName,
        detail,
        kind,
        fullRange,
        innerRange
      );
    } else {
      return null;
    }
  }
  static resolveVariableName(variableList, varName, xpathVariableCurrentlyBeingDefined, globalXsltVariable) {
    let decrementedLength = variableList.length - 1;
    let globalVariableName = globalXsltVariable?.name;
    let defnData = void 0;
    for (let i = decrementedLength; i > -1; i--) {
      let data = variableList[i];
      if (xpathVariableCurrentlyBeingDefined && i === decrementedLength) ;
      else if (data.name === varName && globalVariableName !== data.name) {
        defnData = data;
        data.token["referenced"] = true;
        break;
      }
    }
    return defnData?.token;
  }
  static resolveStackVariableName(elementStack, varName) {
    let resolvedDefnToken;
    let globalXsltVariable = null;
    for (let i = elementStack.length - 1; i > -1; i--) {
      let inheritedVariables = elementStack[i].variables;
      let xpathBeingDefinedInit = elementStack[i].xpathVariableCurrentlyBeingDefined;
      let xpathBeingDefined = !(xpathBeingDefinedInit === void 0 || xpathBeingDefinedInit === false);
      if (i === 1) {
        let elementData = elementStack[i];
        let currentVar = elementData.currentVariable;
        if (currentVar) {
          globalXsltVariable = currentVar;
        }
      }
      resolvedDefnToken = this.resolveVariableName(
        inheritedVariables,
        varName,
        xpathBeingDefined,
        globalXsltVariable
      );
      if (resolvedDefnToken) {
        break;
      }
    }
    return resolvedDefnToken;
  }
  static getDiagnosticsFromUnusedVariableTokens(unusedVariableTokens, unresolvedVariableTokens, includeOrImport) {
    let result = [];
    for (let token of unusedVariableTokens) {
      if (token.referenced === void 0) {
        result.push(this.createUnusedVarDiagnostic(token));
      }
    }
    for (let token of unresolvedVariableTokens) {
      result.push(this.createUnresolvedVarDiagnostic(token, includeOrImport));
    }
    return result;
  }
  static appendDiagnosticsFromProblemTokens(variableRefDiagnostics, tokens) {
    tokens.forEach((token) => {
      let line = token.line;
      let endChar = token.startCharacter + token.length;
      let tokenValue = token.value;
      let msg;
      let errCode = 0;
      let diagnosticMetadata = [];
      let severity = vscode__namespace.DiagnosticSeverity.Error;
      switch (token.error) {
        case ErrorType.AxisName:
          msg = `XPath: Invalid axis name: '${tokenValue}`;
          break;
        case ErrorType.BracketNesting:
          let matchingChar = XsltTokenDiagnostics.getMatchingSymbol(tokenValue);
          msg = matchingChar.length === 0 ? `XPath: No match found for '${tokenValue}'` : `'${tokenValue}' has no matching '${matchingChar}'`;
          diagnosticMetadata = [vscode__namespace.DiagnosticTag.Unnecessary];
          break;
        case ErrorType.ElementNesting:
          msg = `XML: Start tag '${tokenValue}' has no matching close tag`;
          break;
        case ErrorType.ExpectedElseAfterThen:
          msg = `XML: Expected 'else' but found '${tokenValue}'`;
          break;
        case ErrorType.ExpectedDollarAfterComma:
          msg = `XML: Expected '$' but found '${tokenValue}'`;
          break;
        case ErrorType.EntityName:
          msg = `XML: Invalid entity name '${tokenValue}'`;
          break;
        case ErrorType.XPathKeyword:
          msg = `XPath: Found: '${tokenValue}' expected keyword or operator`;
          break;
        case ErrorType.DuplicateParameterName:
          msg = `XSLT: Duplicate parameter name: '${tokenValue}'`;
          break;
        case ErrorType.XSLTKeyUnresolved:
          msg = `XSLT: xsl:key declaration with name '${tokenValue}' not found`;
          break;
        case ErrorType.AccumulatorNameUnresolved:
          msg = `XSLT: xsl:accumulator with name '${tokenValue}' not found`;
          break;
        case ErrorType.XPathUnexpected:
          msg = `XPath: Expression context - unexpected token here: ${tokenValue} `;
          break;
        case ErrorType.XPathFunctionUnexpected:
          msg = `XPath: Unexpected function after expression: '${tokenValue}()' `;
          break;
        case ErrorType.XPathName:
          msg = `XPath: Invalid name: '${tokenValue}'`;
          break;
        case ErrorType.XPathOperatorUnexpected:
          msg = `XPath: Operator unexpected at this position: '${tokenValue}'`;
          break;
        case ErrorType.XPathAwaiting:
          msg = `XPath: Expected expression following: '${tokenValue}'`;
          break;
        case ErrorType.XPathStringLiteral:
          msg = `String literal not terminated properly: ${tokenValue}`;
          break;
        case ErrorType.XPathFunction:
          let parts = tokenValue.split("#");
          msg = `XPath: Function: '${parts[0]}' with ${parts[1]} arguments not found`;
          break;
        case ErrorType.XPathTypeName:
          msg = `XPath: Invalid type: '${tokenValue}'`;
          break;
        case ErrorType.XPathFunctionNamespace:
          let partsNs = tokenValue.split("#");
          msg = `XPath: Undeclared prefix in function: '${partsNs[0]}'`;
          break;
        case ErrorType.XPathExpectedComplex:
          const expected = tokenValue === ":=" ? "in" : ":=";
          msg = `XPath: '${tokenValue}' is invalid here, expected  '${expected}'`;
          break;
        case ErrorType.XPathPrefix:
          msg = `XPath: Undeclared prefix in name: '${tokenValue}'`;
          break;
        case ErrorType.DuplicateVarName:
          msg = `XSLT: Duplicate global variable/parameter name: '${tokenValue}'`;
          break;
        case ErrorType.DuplicateFnName:
          msg = `XSLT: Duplicate function name and arity: '${tokenValue}'`;
          break;
        case ErrorType.DuplicateTemplateName:
          msg = `XSLT: Duplicate xsl:template name '${tokenValue}'`;
          break;
        case ErrorType.DuplicateAccumulatorName:
          msg = `XSLT: Duplicate xsl:accumulator name '${tokenValue}'`;
          break;
        default:
          msg = "Unexepected Error";
          break;
      }
      if (token.startCharacter > -1 && endChar > -1) {
        variableRefDiagnostics.push({
          code: errCode,
          message: msg,
          range: new vscode__namespace.Range(
            new vscode__namespace.Position(line, token.startCharacter),
            new vscode__namespace.Position(line, endChar)
          ),
          severity,
          tags: diagnosticMetadata,
          source: ""
        });
      }
    });
    return variableRefDiagnostics;
  }
  static getMatchingSymbol(text) {
    let r = "";
    switch (text) {
      case "(":
        r = ")";
        break;
      case "[":
        r = "]";
        break;
      case "{":
        r = "}";
        break;
      case ")":
        r = "(";
        break;
      case "]":
        r = "[";
        break;
      case "}":
        r = "{";
        break;
      case "if":
        r = "then";
        break;
      case "then":
        r = "else";
        break;
      case "let":
      case "for":
        r = "return";
        break;
      case "every":
      case "some":
        r = "satisfies";
        break;
      case "else":
        r = "then";
        break;
      default:
        r = "";
        break;
    }
    return r;
  }
  static getMatchingToken(text) {
    let r = "";
    switch (text) {
      case "let":
      case "for":
        r = "return";
        break;
      case "every":
      case "some":
        r = "satisfies";
        break;
      case "then":
        r = "else";
    }
    return r;
  }
  static createUnusedVarDiagnostic(token) {
    let line = token.line;
    let endChar = token.startCharacter + token.length;
    return {
      code: "",
      message: "variable is unused",
      range: new vscode__namespace.Range(
        new vscode__namespace.Position(line, token.startCharacter),
        new vscode__namespace.Position(line, endChar)
      ),
      severity: vscode__namespace.DiagnosticSeverity.Hint,
      tags: [vscode__namespace.DiagnosticTag.Unnecessary],
      source: ""
    };
  }
  static createUnresolvedVarDiagnostic(token, includeOrImport) {
    let line = token.line;
    let endChar = token.startCharacter + token.length;
    if (includeOrImport) {
      return {
        code: "",
        message: `XPath: The variable/parameter: ${token.value} cannot be resolved here, but it may be defined in an external module.`,
        range: new vscode__namespace.Range(
          new vscode__namespace.Position(line, token.startCharacter),
          new vscode__namespace.Position(line, endChar)
        ),
        severity: vscode__namespace.DiagnosticSeverity.Warning
      };
    } else {
      return {
        code: "",
        message: `XPath: The variable/parameter ${token.value} cannot be resolved`,
        range: new vscode__namespace.Range(
          new vscode__namespace.Position(line, token.startCharacter),
          new vscode__namespace.Position(line, endChar)
        ),
        severity: vscode__namespace.DiagnosticSeverity.Error
      };
    }
  }
}
class XPathDocumentChangeHandler {
  async onDocumentChange(e) {
    let activeChange = e.contentChanges[0];
    if (!activeChange) {
      return;
    }
    let doTrigger = false;
    const docText = e.document.getText();
    let precededByWS = false;
    let followsSeparator = false;
    const pos = activeChange.rangeOffset - 1;
    let wsEndPos = -1;
    let keywordPos = -1;
    let keyword;
    let separatorChar;
    const char = activeChange.text;
    let charIsWs = char === " " || char === "	" || char === "\n";
    for (let x = pos; x > -1; x--) {
      const char2 = docText.charAt(x);
      if (char2 === " " || char2 === "	" || char2 === "\n") {
        precededByWS = true;
        if (keywordPos !== -1) {
          break;
        }
      } else if (Data.anySeps.indexOf(char2) !== -1) {
        followsSeparator = true;
        separatorChar = char2;
        break;
      } else if (charIsWs) {
        if (wsEndPos === -1) {
          wsEndPos = x + 1;
        }
        keywordPos = x;
      } else {
        break;
      }
    }
    keyword = keywordPos !== -1 ? docText.substring(keywordPos, wsEndPos) : void 0;
    if (charIsWs) {
      doTrigger = followsSeparator || keyword !== void 0 && Data.triggerWords.indexOf(keyword) !== -1;
    } else if (char === "$" || char === "/" || char === "[" || char === "?" || char === "@") {
      doTrigger = true;
    } else if (followsSeparator && char === ":" && separatorChar === ":") {
      doTrigger = true;
    } else {
      doTrigger = precededByWS && followsSeparator;
    }
    if (doTrigger) {
      setTimeout(() => {
        vscode__namespace.commands.executeCommand("editor.action.triggerSuggest");
      }, 10);
      return;
    }
  }
}
class DocumentChangeHandler {
  constructor() {
    this.onDidChangeRegistration = null;
    this.xmlDocumentRegistered = false;
    this.xpathDocumentChangeHanlder = null;
    this.registerXMLEditor = (editor) => {
      if (editor) {
        this.registerXMLDocument(editor);
      }
    };
    this.registerXMLDocument = (editor) => {
      const document2 = editor.document;
      let isXPathDocument = document2.languageId === "dfdl";
      if (this.xmlDocumentRegistered && !isXPathDocument && this.onDidChangeRegistration) {
        this.onDidChangeRegistration.dispose();
        this.xmlDocumentRegistered = false;
      }
      if (isXPathDocument && !this.xmlDocumentRegistered) {
        this.xmlDocumentRegistered = true;
        this.onDidChangeRegistration = vscode__namespace.workspace.onDidChangeTextDocument(
          (e) => this.getXPathDocumentChangeHandler().onDocumentChange(e)
        );
      }
    };
  }
  static {
    this.lastActiveXMLEditor = null;
  }
  static {
    this.lastActiveXMLNonXSLEditor = null;
  }
  static {
    this.lastXMLDocumentGlobalData = [];
  }
  getXPathDocumentChangeHandler() {
    if (this.xpathDocumentChangeHanlder === null) {
      this.xpathDocumentChangeHanlder = new XPathDocumentChangeHandler();
    }
    return this.xpathDocumentChangeHanlder;
  }
}
const tokenModifiers = /* @__PURE__ */ new Map();
const startList = [];
const endList = [];
const legend = (function() {
  const tokenTypesLegend = XslLexer.getTextmateTypeLegend();
  const tokenModifiersLegend = [
    "declaration",
    "documentation",
    "member",
    "static",
    "abstract",
    "deprecated",
    "modification",
    "async"
  ];
  tokenModifiersLegend.forEach(
    (tokenModifier, index) => tokenModifiers.set(tokenModifier, index)
  );
  return new vscode__namespace.SemanticTokensLegend(tokenTypesLegend, tokenModifiersLegend);
})();
class XPathSemanticTokensProvider {
  constructor(collection) {
    this.xpLexer = new XPathLexer();
    this.diagnosticList = new Array();
    this.collection = collection;
  }
  async provideDocumentSemanticTokens(document2, token) {
    this.xpLexer.documentTokens = [];
    let [variables, namespaces] = this.findAllVariablesandNamespaces(document2.getText());
    let tokens = [];
    const tokenPositions = this.findAllXPath(document2.getText());
    for (let i = 0; i < tokenPositions.length; i++) {
      const line = tokenPositions[i][0];
      const startCharacter = tokenPositions[i][1];
      const documentOffset = tokenPositions[i][2];
      const lexPositions = {
        line,
        startCharacter,
        documentOffset
      };
      let start = new vscode__namespace.Position(line, startCharacter);
      let tmpTokens = this.xpLexer.analyse(
        document2.getText(),
        ExitCondition.CurlyBrace,
        lexPositions
      );
      let end = new vscode__namespace.Position(
        lexPositions.line,
        lexPositions.startCharacter
      );
      startList.push(start);
      endList.push(end);
      tokens = tokens.concat(tmpTokens);
      setTimeout(
        () => this.reportProblems(tmpTokens, document2, variables, namespaces),
        0
      );
      this.xpLexer.reset();
    }
    const builder2 = new vscode__namespace.SemanticTokensBuilder();
    tokens.forEach((token2) => {
      builder2.push(
        token2.line,
        token2.startCharacter,
        token2.length,
        token2.tokenType,
        0
      );
    });
    this.diagnosticList = new Array();
    return builder2.build();
  }
  // Identify all sections in the full document that should be treated as XPath
  findAllXPath(document2) {
    let tokensFound = [];
    let charCount = 0;
    const lines = document2.split("\n");
    const xPathRegex = /(\w+)=("|')(?=\{)/;
    let isComment = false;
    for (let i = 0; i < lines.length; i++) {
      let xPathMatch = lines[i].match(xPathRegex);
      if (!isComment && lines[i].includes("<!--")) {
        isComment = true;
      }
      if (isComment) {
        let closeIndex = lines[i].search("-->");
        if (closeIndex !== -1) {
          isComment = false;
          if (xPathMatch) {
            if (closeIndex > lines[i].search(xPathMatch[0])) {
              xPathMatch = null;
            }
          }
        } else {
          xPathMatch = null;
        }
      }
      if (xPathMatch) {
        const lineOffset = lines[i].search(xPathMatch[0]) + xPathMatch[0].length + 1;
        tokensFound.push([
          i,
          (xPathMatch.index || 0) + xPathMatch[0].length + 1,
          charCount + lineOffset
        ]);
      }
      charCount += lines[i].length + 1;
    }
    return tokensFound;
  }
  // Find the names of all variables in the file
  findAllVariablesandNamespaces(document2) {
    if (document2 === void 0) {
      return [[], []];
    }
    const lines = document2.split(os.EOL);
    const variableRegex = /(dfdl:defineVariable.*name=\")(.*?)\"/;
    const variables = [
      "dfdl:encoding",
      "dfdl:byteOrder",
      "dfdl:binaryFloatRep",
      "dfdl:outputNewLine"
    ];
    const namespaceRegex = /xmlns:(.*?)=\"/g;
    const namespaces = [];
    for (let i = 0; i < lines.length; i++) {
      const variableMatch = lines[i].match(variableRegex);
      if (variableMatch) {
        variables.push(variableMatch[2]);
      }
      let namespaceMatch = null;
      do {
        namespaceMatch = namespaceRegex.exec(lines[i]);
        if (namespaceMatch) {
          namespaces.push(namespaceMatch[1]);
        }
      } while (namespaceMatch);
    }
    return [variables, namespaces];
  }
  // This function will produce the error/warning list for vscode
  reportProblems(allTokens, document2, variables, namespaces) {
    let diagnostics = XsltTokenDiagnostics.calculateDiagnostics(
      document2,
      allTokens,
      DocumentChangeHandler.lastXMLDocumentGlobalData,
      [],
      [],
      variables,
      namespaces
    );
    diagnostics.forEach((diag) => {
      this.diagnosticList.push(diag);
    });
    if (this.diagnosticList.length > 0) {
      this.collection.set(document2.uri, this.diagnosticList);
    } else {
      this.collection.clear();
    }
  }
}
function isXPath(position) {
  for (let i = 0; i < startList.length; i++) {
    if (position.isBeforeOrEqual(endList[i]) && position.isAfterOrEqual(startList[i]))
      return true;
  }
  return false;
}
function activate$6(context) {
  const docChangeHandler = new DocumentChangeHandler();
  let activeEditor = vscode__namespace.window.activeTextEditor;
  if (activeEditor) {
    docChangeHandler.registerXMLEditor(activeEditor);
  }
  const xpathDiagnosticsCollection = vscode__namespace.languages.createDiagnosticCollection("dfdl");
  context.subscriptions.push(
    vscode__namespace.languages.registerDocumentSemanticTokensProvider(
      { language: "dfdl" },
      new XPathSemanticTokensProvider(xpathDiagnosticsCollection),
      legend
    )
  );
}
var sax$1 = {};
var hasRequiredSax$1;
function requireSax$1() {
  if (hasRequiredSax$1) return sax$1;
  hasRequiredSax$1 = 1;
  (function(exports2) {
    (function(sax2) {
      sax2.parser = function(strict, opt) {
        return new SAXParser(strict, opt);
      };
      sax2.SAXParser = SAXParser;
      sax2.SAXStream = SAXStream;
      sax2.createStream = createStream;
      sax2.MAX_BUFFER_LENGTH = 64 * 1024;
      var buffers2 = [
        "comment",
        "sgmlDecl",
        "textNode",
        "tagName",
        "doctype",
        "procInstName",
        "procInstBody",
        "entity",
        "attribName",
        "attribValue",
        "cdata",
        "script"
      ];
      sax2.EVENTS = [
        "text",
        "processinginstruction",
        "sgmldeclaration",
        "doctype",
        "comment",
        "opentagstart",
        "attribute",
        "opentag",
        "closetag",
        "opencdata",
        "cdata",
        "closecdata",
        "error",
        "end",
        "ready",
        "script",
        "opennamespace",
        "closenamespace"
      ];
      function SAXParser(strict, opt) {
        if (!(this instanceof SAXParser)) {
          return new SAXParser(strict, opt);
        }
        var parser2 = this;
        clearBuffers(parser2);
        parser2.q = parser2.c = "";
        parser2.bufferCheckPosition = sax2.MAX_BUFFER_LENGTH;
        parser2.opt = opt || {};
        parser2.opt.lowercase = parser2.opt.lowercase || parser2.opt.lowercasetags;
        parser2.looseCase = parser2.opt.lowercase ? "toLowerCase" : "toUpperCase";
        parser2.tags = [];
        parser2.closed = parser2.closedRoot = parser2.sawRoot = false;
        parser2.tag = parser2.error = null;
        parser2.strict = !!strict;
        parser2.noscript = !!(strict || parser2.opt.noscript);
        parser2.state = S.BEGIN;
        parser2.strictEntities = parser2.opt.strictEntities;
        parser2.ENTITIES = parser2.strictEntities ? Object.create(sax2.XML_ENTITIES) : Object.create(sax2.ENTITIES);
        parser2.attribList = [];
        if (parser2.opt.xmlns) {
          parser2.ns = Object.create(rootNS);
        }
        if (parser2.opt.unquotedAttributeValues === void 0) {
          parser2.opt.unquotedAttributeValues = !strict;
        }
        parser2.trackPosition = parser2.opt.position !== false;
        if (parser2.trackPosition) {
          parser2.position = parser2.line = parser2.column = 0;
        }
        emit(parser2, "onready");
      }
      if (!Object.create) {
        Object.create = function(o) {
          function F() {
          }
          F.prototype = o;
          var newf = new F();
          return newf;
        };
      }
      if (!Object.keys) {
        Object.keys = function(o) {
          var a = [];
          for (var i in o) if (o.hasOwnProperty(i)) a.push(i);
          return a;
        };
      }
      function checkBufferLength(parser2) {
        var maxAllowed = Math.max(sax2.MAX_BUFFER_LENGTH, 10);
        var maxActual = 0;
        for (var i = 0, l = buffers2.length; i < l; i++) {
          var len = parser2[buffers2[i]].length;
          if (len > maxAllowed) {
            switch (buffers2[i]) {
              case "textNode":
                closeText(parser2);
                break;
              case "cdata":
                emitNode(parser2, "oncdata", parser2.cdata);
                parser2.cdata = "";
                break;
              case "script":
                emitNode(parser2, "onscript", parser2.script);
                parser2.script = "";
                break;
              default:
                error(parser2, "Max buffer length exceeded: " + buffers2[i]);
            }
          }
          maxActual = Math.max(maxActual, len);
        }
        var m = sax2.MAX_BUFFER_LENGTH - maxActual;
        parser2.bufferCheckPosition = m + parser2.position;
      }
      function clearBuffers(parser2) {
        for (var i = 0, l = buffers2.length; i < l; i++) {
          parser2[buffers2[i]] = "";
        }
      }
      function flushBuffers(parser2) {
        closeText(parser2);
        if (parser2.cdata !== "") {
          emitNode(parser2, "oncdata", parser2.cdata);
          parser2.cdata = "";
        }
        if (parser2.script !== "") {
          emitNode(parser2, "onscript", parser2.script);
          parser2.script = "";
        }
      }
      SAXParser.prototype = {
        end: function() {
          end(this);
        },
        write,
        resume: function() {
          this.error = null;
          return this;
        },
        close: function() {
          return this.write(null);
        },
        flush: function() {
          flushBuffers(this);
        }
      };
      var Stream;
      try {
        Stream = require("stream").Stream;
      } catch (ex) {
        Stream = function() {
        };
      }
      if (!Stream) Stream = function() {
      };
      var streamWraps = sax2.EVENTS.filter(function(ev) {
        return ev !== "error" && ev !== "end";
      });
      function createStream(strict, opt) {
        return new SAXStream(strict, opt);
      }
      function SAXStream(strict, opt) {
        if (!(this instanceof SAXStream)) {
          return new SAXStream(strict, opt);
        }
        Stream.apply(this);
        this._parser = new SAXParser(strict, opt);
        this.writable = true;
        this.readable = true;
        var me = this;
        this._parser.onend = function() {
          me.emit("end");
        };
        this._parser.onerror = function(er) {
          me.emit("error", er);
          me._parser.error = null;
        };
        this._decoder = null;
        streamWraps.forEach(function(ev) {
          Object.defineProperty(me, "on" + ev, {
            get: function() {
              return me._parser["on" + ev];
            },
            set: function(h) {
              if (!h) {
                me.removeAllListeners(ev);
                me._parser["on" + ev] = h;
                return h;
              }
              me.on(ev, h);
            },
            enumerable: true,
            configurable: false
          });
        });
      }
      SAXStream.prototype = Object.create(Stream.prototype, {
        constructor: {
          value: SAXStream
        }
      });
      SAXStream.prototype.write = function(data) {
        if (typeof Buffer === "function" && typeof Buffer.isBuffer === "function" && Buffer.isBuffer(data)) {
          if (!this._decoder) {
            var SD = require$$1$2.StringDecoder;
            this._decoder = new SD("utf8");
          }
          data = this._decoder.write(data);
        }
        this._parser.write(data.toString());
        this.emit("data", data);
        return true;
      };
      SAXStream.prototype.end = function(chunk) {
        if (chunk && chunk.length) {
          this.write(chunk);
        }
        this._parser.end();
        return true;
      };
      SAXStream.prototype.on = function(ev, handler) {
        var me = this;
        if (!me._parser["on" + ev] && streamWraps.indexOf(ev) !== -1) {
          me._parser["on" + ev] = function() {
            var args = arguments.length === 1 ? [arguments[0]] : Array.apply(null, arguments);
            args.splice(0, 0, ev);
            me.emit.apply(me, args);
          };
        }
        return Stream.prototype.on.call(me, ev, handler);
      };
      var CDATA = "[CDATA[";
      var DOCTYPE = "DOCTYPE";
      var XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
      var XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
      var rootNS = { xml: XML_NAMESPACE, xmlns: XMLNS_NAMESPACE };
      var nameStart = /[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;
      var nameBody = /[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/;
      var entityStart = /[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;
      var entityBody = /[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040.\d-]/;
      function isWhitespace(c) {
        return c === " " || c === "\n" || c === "\r" || c === "	";
      }
      function isQuote(c) {
        return c === '"' || c === "'";
      }
      function isAttribEnd(c) {
        return c === ">" || isWhitespace(c);
      }
      function isMatch(regex, c) {
        return regex.test(c);
      }
      function notMatch(regex, c) {
        return !isMatch(regex, c);
      }
      var S = 0;
      sax2.STATE = {
        BEGIN: S++,
        // leading byte order mark or whitespace
        BEGIN_WHITESPACE: S++,
        // leading whitespace
        TEXT: S++,
        // general stuff
        TEXT_ENTITY: S++,
        // &amp and such.
        OPEN_WAKA: S++,
        // <
        SGML_DECL: S++,
        // <!BLARG
        SGML_DECL_QUOTED: S++,
        // <!BLARG foo "bar
        DOCTYPE: S++,
        // <!DOCTYPE
        DOCTYPE_QUOTED: S++,
        // <!DOCTYPE "//blah
        DOCTYPE_DTD: S++,
        // <!DOCTYPE "//blah" [ ...
        DOCTYPE_DTD_QUOTED: S++,
        // <!DOCTYPE "//blah" [ "foo
        COMMENT_STARTING: S++,
        // <!-
        COMMENT: S++,
        // <!--
        COMMENT_ENDING: S++,
        // <!-- blah -
        COMMENT_ENDED: S++,
        // <!-- blah --
        CDATA: S++,
        // <![CDATA[ something
        CDATA_ENDING: S++,
        // ]
        CDATA_ENDING_2: S++,
        // ]]
        PROC_INST: S++,
        // <?hi
        PROC_INST_BODY: S++,
        // <?hi there
        PROC_INST_ENDING: S++,
        // <?hi "there" ?
        OPEN_TAG: S++,
        // <strong
        OPEN_TAG_SLASH: S++,
        // <strong /
        ATTRIB: S++,
        // <a
        ATTRIB_NAME: S++,
        // <a foo
        ATTRIB_NAME_SAW_WHITE: S++,
        // <a foo _
        ATTRIB_VALUE: S++,
        // <a foo=
        ATTRIB_VALUE_QUOTED: S++,
        // <a foo="bar
        ATTRIB_VALUE_CLOSED: S++,
        // <a foo="bar"
        ATTRIB_VALUE_UNQUOTED: S++,
        // <a foo=bar
        ATTRIB_VALUE_ENTITY_Q: S++,
        // <foo bar="&quot;"
        ATTRIB_VALUE_ENTITY_U: S++,
        // <foo bar=&quot
        CLOSE_TAG: S++,
        // </a
        CLOSE_TAG_SAW_WHITE: S++,
        // </a   >
        SCRIPT: S++,
        // <script> ...
        SCRIPT_ENDING: S++
        // <script> ... <
      };
      sax2.XML_ENTITIES = {
        "amp": "&",
        "gt": ">",
        "lt": "<",
        "quot": '"',
        "apos": "'"
      };
      sax2.ENTITIES = {
        "amp": "&",
        "gt": ">",
        "lt": "<",
        "quot": '"',
        "apos": "'",
        "AElig": 198,
        "Aacute": 193,
        "Acirc": 194,
        "Agrave": 192,
        "Aring": 197,
        "Atilde": 195,
        "Auml": 196,
        "Ccedil": 199,
        "ETH": 208,
        "Eacute": 201,
        "Ecirc": 202,
        "Egrave": 200,
        "Euml": 203,
        "Iacute": 205,
        "Icirc": 206,
        "Igrave": 204,
        "Iuml": 207,
        "Ntilde": 209,
        "Oacute": 211,
        "Ocirc": 212,
        "Ograve": 210,
        "Oslash": 216,
        "Otilde": 213,
        "Ouml": 214,
        "THORN": 222,
        "Uacute": 218,
        "Ucirc": 219,
        "Ugrave": 217,
        "Uuml": 220,
        "Yacute": 221,
        "aacute": 225,
        "acirc": 226,
        "aelig": 230,
        "agrave": 224,
        "aring": 229,
        "atilde": 227,
        "auml": 228,
        "ccedil": 231,
        "eacute": 233,
        "ecirc": 234,
        "egrave": 232,
        "eth": 240,
        "euml": 235,
        "iacute": 237,
        "icirc": 238,
        "igrave": 236,
        "iuml": 239,
        "ntilde": 241,
        "oacute": 243,
        "ocirc": 244,
        "ograve": 242,
        "oslash": 248,
        "otilde": 245,
        "ouml": 246,
        "szlig": 223,
        "thorn": 254,
        "uacute": 250,
        "ucirc": 251,
        "ugrave": 249,
        "uuml": 252,
        "yacute": 253,
        "yuml": 255,
        "copy": 169,
        "reg": 174,
        "nbsp": 160,
        "iexcl": 161,
        "cent": 162,
        "pound": 163,
        "curren": 164,
        "yen": 165,
        "brvbar": 166,
        "sect": 167,
        "uml": 168,
        "ordf": 170,
        "laquo": 171,
        "not": 172,
        "shy": 173,
        "macr": 175,
        "deg": 176,
        "plusmn": 177,
        "sup1": 185,
        "sup2": 178,
        "sup3": 179,
        "acute": 180,
        "micro": 181,
        "para": 182,
        "middot": 183,
        "cedil": 184,
        "ordm": 186,
        "raquo": 187,
        "frac14": 188,
        "frac12": 189,
        "frac34": 190,
        "iquest": 191,
        "times": 215,
        "divide": 247,
        "OElig": 338,
        "oelig": 339,
        "Scaron": 352,
        "scaron": 353,
        "Yuml": 376,
        "fnof": 402,
        "circ": 710,
        "tilde": 732,
        "Alpha": 913,
        "Beta": 914,
        "Gamma": 915,
        "Delta": 916,
        "Epsilon": 917,
        "Zeta": 918,
        "Eta": 919,
        "Theta": 920,
        "Iota": 921,
        "Kappa": 922,
        "Lambda": 923,
        "Mu": 924,
        "Nu": 925,
        "Xi": 926,
        "Omicron": 927,
        "Pi": 928,
        "Rho": 929,
        "Sigma": 931,
        "Tau": 932,
        "Upsilon": 933,
        "Phi": 934,
        "Chi": 935,
        "Psi": 936,
        "Omega": 937,
        "alpha": 945,
        "beta": 946,
        "gamma": 947,
        "delta": 948,
        "epsilon": 949,
        "zeta": 950,
        "eta": 951,
        "theta": 952,
        "iota": 953,
        "kappa": 954,
        "lambda": 955,
        "mu": 956,
        "nu": 957,
        "xi": 958,
        "omicron": 959,
        "pi": 960,
        "rho": 961,
        "sigmaf": 962,
        "sigma": 963,
        "tau": 964,
        "upsilon": 965,
        "phi": 966,
        "chi": 967,
        "psi": 968,
        "omega": 969,
        "thetasym": 977,
        "upsih": 978,
        "piv": 982,
        "ensp": 8194,
        "emsp": 8195,
        "thinsp": 8201,
        "zwnj": 8204,
        "zwj": 8205,
        "lrm": 8206,
        "rlm": 8207,
        "ndash": 8211,
        "mdash": 8212,
        "lsquo": 8216,
        "rsquo": 8217,
        "sbquo": 8218,
        "ldquo": 8220,
        "rdquo": 8221,
        "bdquo": 8222,
        "dagger": 8224,
        "Dagger": 8225,
        "bull": 8226,
        "hellip": 8230,
        "permil": 8240,
        "prime": 8242,
        "Prime": 8243,
        "lsaquo": 8249,
        "rsaquo": 8250,
        "oline": 8254,
        "frasl": 8260,
        "euro": 8364,
        "image": 8465,
        "weierp": 8472,
        "real": 8476,
        "trade": 8482,
        "alefsym": 8501,
        "larr": 8592,
        "uarr": 8593,
        "rarr": 8594,
        "darr": 8595,
        "harr": 8596,
        "crarr": 8629,
        "lArr": 8656,
        "uArr": 8657,
        "rArr": 8658,
        "dArr": 8659,
        "hArr": 8660,
        "forall": 8704,
        "part": 8706,
        "exist": 8707,
        "empty": 8709,
        "nabla": 8711,
        "isin": 8712,
        "notin": 8713,
        "ni": 8715,
        "prod": 8719,
        "sum": 8721,
        "minus": 8722,
        "lowast": 8727,
        "radic": 8730,
        "prop": 8733,
        "infin": 8734,
        "ang": 8736,
        "and": 8743,
        "or": 8744,
        "cap": 8745,
        "cup": 8746,
        "int": 8747,
        "there4": 8756,
        "sim": 8764,
        "cong": 8773,
        "asymp": 8776,
        "ne": 8800,
        "equiv": 8801,
        "le": 8804,
        "ge": 8805,
        "sub": 8834,
        "sup": 8835,
        "nsub": 8836,
        "sube": 8838,
        "supe": 8839,
        "oplus": 8853,
        "otimes": 8855,
        "perp": 8869,
        "sdot": 8901,
        "lceil": 8968,
        "rceil": 8969,
        "lfloor": 8970,
        "rfloor": 8971,
        "lang": 9001,
        "rang": 9002,
        "loz": 9674,
        "spades": 9824,
        "clubs": 9827,
        "hearts": 9829,
        "diams": 9830
      };
      Object.keys(sax2.ENTITIES).forEach(function(key) {
        var e = sax2.ENTITIES[key];
        var s2 = typeof e === "number" ? String.fromCharCode(e) : e;
        sax2.ENTITIES[key] = s2;
      });
      for (var s in sax2.STATE) {
        sax2.STATE[sax2.STATE[s]] = s;
      }
      S = sax2.STATE;
      function emit(parser2, event, data) {
        parser2[event] && parser2[event](data);
      }
      function emitNode(parser2, nodeType, data) {
        if (parser2.textNode) closeText(parser2);
        emit(parser2, nodeType, data);
      }
      function closeText(parser2) {
        parser2.textNode = textopts(parser2.opt, parser2.textNode);
        if (parser2.textNode) emit(parser2, "ontext", parser2.textNode);
        parser2.textNode = "";
      }
      function textopts(opt, text) {
        if (opt.trim) text = text.trim();
        if (opt.normalize) text = text.replace(/\s+/g, " ");
        return text;
      }
      function error(parser2, er) {
        closeText(parser2);
        if (parser2.trackPosition) {
          er += "\nLine: " + parser2.line + "\nColumn: " + parser2.column + "\nChar: " + parser2.c;
        }
        er = new Error(er);
        parser2.error = er;
        emit(parser2, "onerror", er);
        return parser2;
      }
      function end(parser2) {
        if (parser2.sawRoot && !parser2.closedRoot) strictFail(parser2, "Unclosed root tag");
        if (parser2.state !== S.BEGIN && parser2.state !== S.BEGIN_WHITESPACE && parser2.state !== S.TEXT) {
          error(parser2, "Unexpected end");
        }
        closeText(parser2);
        parser2.c = "";
        parser2.closed = true;
        emit(parser2, "onend");
        SAXParser.call(parser2, parser2.strict, parser2.opt);
        return parser2;
      }
      function strictFail(parser2, message) {
        if (typeof parser2 !== "object" || !(parser2 instanceof SAXParser)) {
          throw new Error("bad call to strictFail");
        }
        if (parser2.strict) {
          error(parser2, message);
        }
      }
      function newTag(parser2) {
        if (!parser2.strict) parser2.tagName = parser2.tagName[parser2.looseCase]();
        var parent = parser2.tags[parser2.tags.length - 1] || parser2;
        var tag = parser2.tag = { name: parser2.tagName, attributes: {} };
        if (parser2.opt.xmlns) {
          tag.ns = parent.ns;
        }
        parser2.attribList.length = 0;
        emitNode(parser2, "onopentagstart", tag);
      }
      function qname(name, attribute) {
        var i = name.indexOf(":");
        var qualName = i < 0 ? ["", name] : name.split(":");
        var prefix = qualName[0];
        var local = qualName[1];
        if (attribute && name === "xmlns") {
          prefix = "xmlns";
          local = "";
        }
        return { prefix, local };
      }
      function attrib(parser2) {
        if (!parser2.strict) {
          parser2.attribName = parser2.attribName[parser2.looseCase]();
        }
        if (parser2.attribList.indexOf(parser2.attribName) !== -1 || parser2.tag.attributes.hasOwnProperty(parser2.attribName)) {
          parser2.attribName = parser2.attribValue = "";
          return;
        }
        if (parser2.opt.xmlns) {
          var qn = qname(parser2.attribName, true);
          var prefix = qn.prefix;
          var local = qn.local;
          if (prefix === "xmlns") {
            if (local === "xml" && parser2.attribValue !== XML_NAMESPACE) {
              strictFail(
                parser2,
                "xml: prefix must be bound to " + XML_NAMESPACE + "\nActual: " + parser2.attribValue
              );
            } else if (local === "xmlns" && parser2.attribValue !== XMLNS_NAMESPACE) {
              strictFail(
                parser2,
                "xmlns: prefix must be bound to " + XMLNS_NAMESPACE + "\nActual: " + parser2.attribValue
              );
            } else {
              var tag = parser2.tag;
              var parent = parser2.tags[parser2.tags.length - 1] || parser2;
              if (tag.ns === parent.ns) {
                tag.ns = Object.create(parent.ns);
              }
              tag.ns[local] = parser2.attribValue;
            }
          }
          parser2.attribList.push([parser2.attribName, parser2.attribValue]);
        } else {
          parser2.tag.attributes[parser2.attribName] = parser2.attribValue;
          emitNode(parser2, "onattribute", {
            name: parser2.attribName,
            value: parser2.attribValue
          });
        }
        parser2.attribName = parser2.attribValue = "";
      }
      function openTag(parser2, selfClosing) {
        if (parser2.opt.xmlns) {
          var tag = parser2.tag;
          var qn = qname(parser2.tagName);
          tag.prefix = qn.prefix;
          tag.local = qn.local;
          tag.uri = tag.ns[qn.prefix] || "";
          if (tag.prefix && !tag.uri) {
            strictFail(parser2, "Unbound namespace prefix: " + JSON.stringify(parser2.tagName));
            tag.uri = qn.prefix;
          }
          var parent = parser2.tags[parser2.tags.length - 1] || parser2;
          if (tag.ns && parent.ns !== tag.ns) {
            Object.keys(tag.ns).forEach(function(p) {
              emitNode(parser2, "onopennamespace", {
                prefix: p,
                uri: tag.ns[p]
              });
            });
          }
          for (var i = 0, l = parser2.attribList.length; i < l; i++) {
            var nv = parser2.attribList[i];
            var name = nv[0];
            var value = nv[1];
            var qualName = qname(name, true);
            var prefix = qualName.prefix;
            var local = qualName.local;
            var uri = prefix === "" ? "" : tag.ns[prefix] || "";
            var a = {
              name,
              value,
              prefix,
              local,
              uri
            };
            if (prefix && prefix !== "xmlns" && !uri) {
              strictFail(parser2, "Unbound namespace prefix: " + JSON.stringify(prefix));
              a.uri = prefix;
            }
            parser2.tag.attributes[name] = a;
            emitNode(parser2, "onattribute", a);
          }
          parser2.attribList.length = 0;
        }
        parser2.tag.isSelfClosing = !!selfClosing;
        parser2.sawRoot = true;
        parser2.tags.push(parser2.tag);
        emitNode(parser2, "onopentag", parser2.tag);
        if (!selfClosing) {
          if (!parser2.noscript && parser2.tagName.toLowerCase() === "script") {
            parser2.state = S.SCRIPT;
          } else {
            parser2.state = S.TEXT;
          }
          parser2.tag = null;
          parser2.tagName = "";
        }
        parser2.attribName = parser2.attribValue = "";
        parser2.attribList.length = 0;
      }
      function closeTag(parser2) {
        if (!parser2.tagName) {
          strictFail(parser2, "Weird empty close tag.");
          parser2.textNode += "</>";
          parser2.state = S.TEXT;
          return;
        }
        if (parser2.script) {
          if (parser2.tagName !== "script") {
            parser2.script += "</" + parser2.tagName + ">";
            parser2.tagName = "";
            parser2.state = S.SCRIPT;
            return;
          }
          emitNode(parser2, "onscript", parser2.script);
          parser2.script = "";
        }
        var t = parser2.tags.length;
        var tagName = parser2.tagName;
        if (!parser2.strict) {
          tagName = tagName[parser2.looseCase]();
        }
        var closeTo = tagName;
        while (t--) {
          var close = parser2.tags[t];
          if (close.name !== closeTo) {
            strictFail(parser2, "Unexpected close tag");
          } else {
            break;
          }
        }
        if (t < 0) {
          strictFail(parser2, "Unmatched closing tag: " + parser2.tagName);
          parser2.textNode += "</" + parser2.tagName + ">";
          parser2.state = S.TEXT;
          return;
        }
        parser2.tagName = tagName;
        var s2 = parser2.tags.length;
        while (s2-- > t) {
          var tag = parser2.tag = parser2.tags.pop();
          parser2.tagName = parser2.tag.name;
          emitNode(parser2, "onclosetag", parser2.tagName);
          var x = {};
          for (var i in tag.ns) {
            x[i] = tag.ns[i];
          }
          var parent = parser2.tags[parser2.tags.length - 1] || parser2;
          if (parser2.opt.xmlns && tag.ns !== parent.ns) {
            Object.keys(tag.ns).forEach(function(p) {
              var n = tag.ns[p];
              emitNode(parser2, "onclosenamespace", { prefix: p, uri: n });
            });
          }
        }
        if (t === 0) parser2.closedRoot = true;
        parser2.tagName = parser2.attribValue = parser2.attribName = "";
        parser2.attribList.length = 0;
        parser2.state = S.TEXT;
      }
      function parseEntity(parser2) {
        var entity = parser2.entity;
        var entityLC = entity.toLowerCase();
        var num;
        var numStr = "";
        if (parser2.ENTITIES[entity]) {
          return parser2.ENTITIES[entity];
        }
        if (parser2.ENTITIES[entityLC]) {
          return parser2.ENTITIES[entityLC];
        }
        entity = entityLC;
        if (entity.charAt(0) === "#") {
          if (entity.charAt(1) === "x") {
            entity = entity.slice(2);
            num = parseInt(entity, 16);
            numStr = num.toString(16);
          } else {
            entity = entity.slice(1);
            num = parseInt(entity, 10);
            numStr = num.toString(10);
          }
        }
        entity = entity.replace(/^0+/, "");
        if (isNaN(num) || numStr.toLowerCase() !== entity) {
          strictFail(parser2, "Invalid character entity");
          return "&" + parser2.entity + ";";
        }
        return String.fromCodePoint(num);
      }
      function beginWhiteSpace(parser2, c) {
        if (c === "<") {
          parser2.state = S.OPEN_WAKA;
          parser2.startTagPosition = parser2.position;
        } else if (!isWhitespace(c)) {
          strictFail(parser2, "Non-whitespace before first tag.");
          parser2.textNode = c;
          parser2.state = S.TEXT;
        }
      }
      function charAt(chunk, i) {
        var result = "";
        if (i < chunk.length) {
          result = chunk.charAt(i);
        }
        return result;
      }
      function write(chunk) {
        var parser2 = this;
        if (this.error) {
          throw this.error;
        }
        if (parser2.closed) {
          return error(
            parser2,
            "Cannot write after close. Assign an onready handler."
          );
        }
        if (chunk === null) {
          return end(parser2);
        }
        if (typeof chunk === "object") {
          chunk = chunk.toString();
        }
        var i = 0;
        var c = "";
        while (true) {
          c = charAt(chunk, i++);
          parser2.c = c;
          if (!c) {
            break;
          }
          if (parser2.trackPosition) {
            parser2.position++;
            if (c === "\n") {
              parser2.line++;
              parser2.column = 0;
            } else {
              parser2.column++;
            }
          }
          switch (parser2.state) {
            case S.BEGIN:
              parser2.state = S.BEGIN_WHITESPACE;
              if (c === "\uFEFF") {
                continue;
              }
              beginWhiteSpace(parser2, c);
              continue;
            case S.BEGIN_WHITESPACE:
              beginWhiteSpace(parser2, c);
              continue;
            case S.TEXT:
              if (parser2.sawRoot && !parser2.closedRoot) {
                var starti = i - 1;
                while (c && c !== "<" && c !== "&") {
                  c = charAt(chunk, i++);
                  if (c && parser2.trackPosition) {
                    parser2.position++;
                    if (c === "\n") {
                      parser2.line++;
                      parser2.column = 0;
                    } else {
                      parser2.column++;
                    }
                  }
                }
                parser2.textNode += chunk.substring(starti, i - 1);
              }
              if (c === "<" && !(parser2.sawRoot && parser2.closedRoot && !parser2.strict)) {
                parser2.state = S.OPEN_WAKA;
                parser2.startTagPosition = parser2.position;
              } else {
                if (!isWhitespace(c) && (!parser2.sawRoot || parser2.closedRoot)) {
                  strictFail(parser2, "Text data outside of root node.");
                }
                if (c === "&") {
                  parser2.state = S.TEXT_ENTITY;
                } else {
                  parser2.textNode += c;
                }
              }
              continue;
            case S.SCRIPT:
              if (c === "<") {
                parser2.state = S.SCRIPT_ENDING;
              } else {
                parser2.script += c;
              }
              continue;
            case S.SCRIPT_ENDING:
              if (c === "/") {
                parser2.state = S.CLOSE_TAG;
              } else {
                parser2.script += "<" + c;
                parser2.state = S.SCRIPT;
              }
              continue;
            case S.OPEN_WAKA:
              if (c === "!") {
                parser2.state = S.SGML_DECL;
                parser2.sgmlDecl = "";
              } else if (isWhitespace(c)) ;
              else if (isMatch(nameStart, c)) {
                parser2.state = S.OPEN_TAG;
                parser2.tagName = c;
              } else if (c === "/") {
                parser2.state = S.CLOSE_TAG;
                parser2.tagName = "";
              } else if (c === "?") {
                parser2.state = S.PROC_INST;
                parser2.procInstName = parser2.procInstBody = "";
              } else {
                strictFail(parser2, "Unencoded <");
                if (parser2.startTagPosition + 1 < parser2.position) {
                  var pad = parser2.position - parser2.startTagPosition;
                  c = new Array(pad).join(" ") + c;
                }
                parser2.textNode += "<" + c;
                parser2.state = S.TEXT;
              }
              continue;
            case S.SGML_DECL:
              if (parser2.sgmlDecl + c === "--") {
                parser2.state = S.COMMENT;
                parser2.comment = "";
                parser2.sgmlDecl = "";
                continue;
              }
              if (parser2.doctype && parser2.doctype !== true && parser2.sgmlDecl) {
                parser2.state = S.DOCTYPE_DTD;
                parser2.doctype += "<!" + parser2.sgmlDecl + c;
                parser2.sgmlDecl = "";
              } else if ((parser2.sgmlDecl + c).toUpperCase() === CDATA) {
                emitNode(parser2, "onopencdata");
                parser2.state = S.CDATA;
                parser2.sgmlDecl = "";
                parser2.cdata = "";
              } else if ((parser2.sgmlDecl + c).toUpperCase() === DOCTYPE) {
                parser2.state = S.DOCTYPE;
                if (parser2.doctype || parser2.sawRoot) {
                  strictFail(
                    parser2,
                    "Inappropriately located doctype declaration"
                  );
                }
                parser2.doctype = "";
                parser2.sgmlDecl = "";
              } else if (c === ">") {
                emitNode(parser2, "onsgmldeclaration", parser2.sgmlDecl);
                parser2.sgmlDecl = "";
                parser2.state = S.TEXT;
              } else if (isQuote(c)) {
                parser2.state = S.SGML_DECL_QUOTED;
                parser2.sgmlDecl += c;
              } else {
                parser2.sgmlDecl += c;
              }
              continue;
            case S.SGML_DECL_QUOTED:
              if (c === parser2.q) {
                parser2.state = S.SGML_DECL;
                parser2.q = "";
              }
              parser2.sgmlDecl += c;
              continue;
            case S.DOCTYPE:
              if (c === ">") {
                parser2.state = S.TEXT;
                emitNode(parser2, "ondoctype", parser2.doctype);
                parser2.doctype = true;
              } else {
                parser2.doctype += c;
                if (c === "[") {
                  parser2.state = S.DOCTYPE_DTD;
                } else if (isQuote(c)) {
                  parser2.state = S.DOCTYPE_QUOTED;
                  parser2.q = c;
                }
              }
              continue;
            case S.DOCTYPE_QUOTED:
              parser2.doctype += c;
              if (c === parser2.q) {
                parser2.q = "";
                parser2.state = S.DOCTYPE;
              }
              continue;
            case S.DOCTYPE_DTD:
              if (c === "]") {
                parser2.doctype += c;
                parser2.state = S.DOCTYPE;
              } else if (c === "<") {
                parser2.state = S.OPEN_WAKA;
                parser2.startTagPosition = parser2.position;
              } else if (isQuote(c)) {
                parser2.doctype += c;
                parser2.state = S.DOCTYPE_DTD_QUOTED;
                parser2.q = c;
              } else {
                parser2.doctype += c;
              }
              continue;
            case S.DOCTYPE_DTD_QUOTED:
              parser2.doctype += c;
              if (c === parser2.q) {
                parser2.state = S.DOCTYPE_DTD;
                parser2.q = "";
              }
              continue;
            case S.COMMENT:
              if (c === "-") {
                parser2.state = S.COMMENT_ENDING;
              } else {
                parser2.comment += c;
              }
              continue;
            case S.COMMENT_ENDING:
              if (c === "-") {
                parser2.state = S.COMMENT_ENDED;
                parser2.comment = textopts(parser2.opt, parser2.comment);
                if (parser2.comment) {
                  emitNode(parser2, "oncomment", parser2.comment);
                }
                parser2.comment = "";
              } else {
                parser2.comment += "-" + c;
                parser2.state = S.COMMENT;
              }
              continue;
            case S.COMMENT_ENDED:
              if (c !== ">") {
                strictFail(parser2, "Malformed comment");
                parser2.comment += "--" + c;
                parser2.state = S.COMMENT;
              } else if (parser2.doctype && parser2.doctype !== true) {
                parser2.state = S.DOCTYPE_DTD;
              } else {
                parser2.state = S.TEXT;
              }
              continue;
            case S.CDATA:
              if (c === "]") {
                parser2.state = S.CDATA_ENDING;
              } else {
                parser2.cdata += c;
              }
              continue;
            case S.CDATA_ENDING:
              if (c === "]") {
                parser2.state = S.CDATA_ENDING_2;
              } else {
                parser2.cdata += "]" + c;
                parser2.state = S.CDATA;
              }
              continue;
            case S.CDATA_ENDING_2:
              if (c === ">") {
                if (parser2.cdata) {
                  emitNode(parser2, "oncdata", parser2.cdata);
                }
                emitNode(parser2, "onclosecdata");
                parser2.cdata = "";
                parser2.state = S.TEXT;
              } else if (c === "]") {
                parser2.cdata += "]";
              } else {
                parser2.cdata += "]]" + c;
                parser2.state = S.CDATA;
              }
              continue;
            case S.PROC_INST:
              if (c === "?") {
                parser2.state = S.PROC_INST_ENDING;
              } else if (isWhitespace(c)) {
                parser2.state = S.PROC_INST_BODY;
              } else {
                parser2.procInstName += c;
              }
              continue;
            case S.PROC_INST_BODY:
              if (!parser2.procInstBody && isWhitespace(c)) {
                continue;
              } else if (c === "?") {
                parser2.state = S.PROC_INST_ENDING;
              } else {
                parser2.procInstBody += c;
              }
              continue;
            case S.PROC_INST_ENDING:
              if (c === ">") {
                emitNode(parser2, "onprocessinginstruction", {
                  name: parser2.procInstName,
                  body: parser2.procInstBody
                });
                parser2.procInstName = parser2.procInstBody = "";
                parser2.state = S.TEXT;
              } else {
                parser2.procInstBody += "?" + c;
                parser2.state = S.PROC_INST_BODY;
              }
              continue;
            case S.OPEN_TAG:
              if (isMatch(nameBody, c)) {
                parser2.tagName += c;
              } else {
                newTag(parser2);
                if (c === ">") {
                  openTag(parser2);
                } else if (c === "/") {
                  parser2.state = S.OPEN_TAG_SLASH;
                } else {
                  if (!isWhitespace(c)) {
                    strictFail(parser2, "Invalid character in tag name");
                  }
                  parser2.state = S.ATTRIB;
                }
              }
              continue;
            case S.OPEN_TAG_SLASH:
              if (c === ">") {
                openTag(parser2, true);
                closeTag(parser2);
              } else {
                strictFail(parser2, "Forward-slash in opening tag not followed by >");
                parser2.state = S.ATTRIB;
              }
              continue;
            case S.ATTRIB:
              if (isWhitespace(c)) {
                continue;
              } else if (c === ">") {
                openTag(parser2);
              } else if (c === "/") {
                parser2.state = S.OPEN_TAG_SLASH;
              } else if (isMatch(nameStart, c)) {
                parser2.attribName = c;
                parser2.attribValue = "";
                parser2.state = S.ATTRIB_NAME;
              } else {
                strictFail(parser2, "Invalid attribute name");
              }
              continue;
            case S.ATTRIB_NAME:
              if (c === "=") {
                parser2.state = S.ATTRIB_VALUE;
              } else if (c === ">") {
                strictFail(parser2, "Attribute without value");
                parser2.attribValue = parser2.attribName;
                attrib(parser2);
                openTag(parser2);
              } else if (isWhitespace(c)) {
                parser2.state = S.ATTRIB_NAME_SAW_WHITE;
              } else if (isMatch(nameBody, c)) {
                parser2.attribName += c;
              } else {
                strictFail(parser2, "Invalid attribute name");
              }
              continue;
            case S.ATTRIB_NAME_SAW_WHITE:
              if (c === "=") {
                parser2.state = S.ATTRIB_VALUE;
              } else if (isWhitespace(c)) {
                continue;
              } else {
                strictFail(parser2, "Attribute without value");
                parser2.tag.attributes[parser2.attribName] = "";
                parser2.attribValue = "";
                emitNode(parser2, "onattribute", {
                  name: parser2.attribName,
                  value: ""
                });
                parser2.attribName = "";
                if (c === ">") {
                  openTag(parser2);
                } else if (isMatch(nameStart, c)) {
                  parser2.attribName = c;
                  parser2.state = S.ATTRIB_NAME;
                } else {
                  strictFail(parser2, "Invalid attribute name");
                  parser2.state = S.ATTRIB;
                }
              }
              continue;
            case S.ATTRIB_VALUE:
              if (isWhitespace(c)) {
                continue;
              } else if (isQuote(c)) {
                parser2.q = c;
                parser2.state = S.ATTRIB_VALUE_QUOTED;
              } else {
                if (!parser2.opt.unquotedAttributeValues) {
                  error(parser2, "Unquoted attribute value");
                }
                parser2.state = S.ATTRIB_VALUE_UNQUOTED;
                parser2.attribValue = c;
              }
              continue;
            case S.ATTRIB_VALUE_QUOTED:
              if (c !== parser2.q) {
                if (c === "&") {
                  parser2.state = S.ATTRIB_VALUE_ENTITY_Q;
                } else {
                  parser2.attribValue += c;
                }
                continue;
              }
              attrib(parser2);
              parser2.q = "";
              parser2.state = S.ATTRIB_VALUE_CLOSED;
              continue;
            case S.ATTRIB_VALUE_CLOSED:
              if (isWhitespace(c)) {
                parser2.state = S.ATTRIB;
              } else if (c === ">") {
                openTag(parser2);
              } else if (c === "/") {
                parser2.state = S.OPEN_TAG_SLASH;
              } else if (isMatch(nameStart, c)) {
                strictFail(parser2, "No whitespace between attributes");
                parser2.attribName = c;
                parser2.attribValue = "";
                parser2.state = S.ATTRIB_NAME;
              } else {
                strictFail(parser2, "Invalid attribute name");
              }
              continue;
            case S.ATTRIB_VALUE_UNQUOTED:
              if (!isAttribEnd(c)) {
                if (c === "&") {
                  parser2.state = S.ATTRIB_VALUE_ENTITY_U;
                } else {
                  parser2.attribValue += c;
                }
                continue;
              }
              attrib(parser2);
              if (c === ">") {
                openTag(parser2);
              } else {
                parser2.state = S.ATTRIB;
              }
              continue;
            case S.CLOSE_TAG:
              if (!parser2.tagName) {
                if (isWhitespace(c)) {
                  continue;
                } else if (notMatch(nameStart, c)) {
                  if (parser2.script) {
                    parser2.script += "</" + c;
                    parser2.state = S.SCRIPT;
                  } else {
                    strictFail(parser2, "Invalid tagname in closing tag.");
                  }
                } else {
                  parser2.tagName = c;
                }
              } else if (c === ">") {
                closeTag(parser2);
              } else if (isMatch(nameBody, c)) {
                parser2.tagName += c;
              } else if (parser2.script) {
                parser2.script += "</" + parser2.tagName;
                parser2.tagName = "";
                parser2.state = S.SCRIPT;
              } else {
                if (!isWhitespace(c)) {
                  strictFail(parser2, "Invalid tagname in closing tag");
                }
                parser2.state = S.CLOSE_TAG_SAW_WHITE;
              }
              continue;
            case S.CLOSE_TAG_SAW_WHITE:
              if (isWhitespace(c)) {
                continue;
              }
              if (c === ">") {
                closeTag(parser2);
              } else {
                strictFail(parser2, "Invalid characters in closing tag");
              }
              continue;
            case S.TEXT_ENTITY:
            case S.ATTRIB_VALUE_ENTITY_Q:
            case S.ATTRIB_VALUE_ENTITY_U:
              var returnState;
              var buffer;
              switch (parser2.state) {
                case S.TEXT_ENTITY:
                  returnState = S.TEXT;
                  buffer = "textNode";
                  break;
                case S.ATTRIB_VALUE_ENTITY_Q:
                  returnState = S.ATTRIB_VALUE_QUOTED;
                  buffer = "attribValue";
                  break;
                case S.ATTRIB_VALUE_ENTITY_U:
                  returnState = S.ATTRIB_VALUE_UNQUOTED;
                  buffer = "attribValue";
                  break;
              }
              if (c === ";") {
                var parsedEntity = parseEntity(parser2);
                if (parser2.opt.unparsedEntities && !Object.values(sax2.XML_ENTITIES).includes(parsedEntity)) {
                  parser2.entity = "";
                  parser2.state = returnState;
                  parser2.write(parsedEntity);
                } else {
                  parser2[buffer] += parsedEntity;
                  parser2.entity = "";
                  parser2.state = returnState;
                }
              } else if (isMatch(parser2.entity.length ? entityBody : entityStart, c)) {
                parser2.entity += c;
              } else {
                strictFail(parser2, "Invalid character in entity name");
                parser2[buffer] += "&" + parser2.entity + c;
                parser2.entity = "";
                parser2.state = returnState;
              }
              continue;
            default: {
              throw new Error(parser2, "Unknown state: " + parser2.state);
            }
          }
        }
        if (parser2.position >= parser2.bufferCheckPosition) {
          checkBufferLength(parser2);
        }
        return parser2;
      }
      /*! http://mths.be/fromcodepoint v0.1.0 by @mathias */
      if (!String.fromCodePoint) {
        (function() {
          var stringFromCharCode = String.fromCharCode;
          var floor = Math.floor;
          var fromCodePoint = function() {
            var MAX_SIZE = 16384;
            var codeUnits = [];
            var highSurrogate;
            var lowSurrogate;
            var index = -1;
            var length = arguments.length;
            if (!length) {
              return "";
            }
            var result = "";
            while (++index < length) {
              var codePoint = Number(arguments[index]);
              if (!isFinite(codePoint) || // `NaN`, `+Infinity`, or `-Infinity`
              codePoint < 0 || // not a valid Unicode code point
              codePoint > 1114111 || // not a valid Unicode code point
              floor(codePoint) !== codePoint) {
                throw RangeError("Invalid code point: " + codePoint);
              }
              if (codePoint <= 65535) {
                codeUnits.push(codePoint);
              } else {
                codePoint -= 65536;
                highSurrogate = (codePoint >> 10) + 55296;
                lowSurrogate = codePoint % 1024 + 56320;
                codeUnits.push(highSurrogate, lowSurrogate);
              }
              if (index + 1 === length || codeUnits.length > MAX_SIZE) {
                result += stringFromCharCode.apply(null, codeUnits);
                codeUnits.length = 0;
              }
            }
            return result;
          };
          if (Object.defineProperty) {
            Object.defineProperty(String, "fromCodePoint", {
              value: fromCodePoint,
              configurable: true,
              writable: true
            });
          } else {
            String.fromCodePoint = fromCodePoint;
          }
        })();
      }
    })(exports2);
  })(sax$1);
  return sax$1;
}
var arrayHelper;
var hasRequiredArrayHelper;
function requireArrayHelper() {
  if (hasRequiredArrayHelper) return arrayHelper;
  hasRequiredArrayHelper = 1;
  arrayHelper = {
    isArray: function(value) {
      if (Array.isArray) {
        return Array.isArray(value);
      }
      return Object.prototype.toString.call(value) === "[object Array]";
    }
  };
  return arrayHelper;
}
var optionsHelper;
var hasRequiredOptionsHelper;
function requireOptionsHelper() {
  if (hasRequiredOptionsHelper) return optionsHelper;
  hasRequiredOptionsHelper = 1;
  var isArray = requireArrayHelper().isArray;
  optionsHelper = {
    copyOptions: function(options) {
      var key, copy = {};
      for (key in options) {
        if (options.hasOwnProperty(key)) {
          copy[key] = options[key];
        }
      }
      return copy;
    },
    ensureFlagExists: function(item, options) {
      if (!(item in options) || typeof options[item] !== "boolean") {
        options[item] = false;
      }
    },
    ensureSpacesExists: function(options) {
      if (!("spaces" in options) || typeof options.spaces !== "number" && typeof options.spaces !== "string") {
        options.spaces = 0;
      }
    },
    ensureAlwaysArrayExists: function(options) {
      if (!("alwaysArray" in options) || typeof options.alwaysArray !== "boolean" && !isArray(options.alwaysArray)) {
        options.alwaysArray = false;
      }
    },
    ensureKeyExists: function(key, options) {
      if (!(key + "Key" in options) || typeof options[key + "Key"] !== "string") {
        options[key + "Key"] = options.compact ? "_" + key : key;
      }
    },
    checkFnExists: function(key, options) {
      return key + "Fn" in options;
    }
  };
  return optionsHelper;
}
var xml2js$1;
var hasRequiredXml2js$1;
function requireXml2js$1() {
  if (hasRequiredXml2js$1) return xml2js$1;
  hasRequiredXml2js$1 = 1;
  var sax2 = requireSax$1();
  var helper = requireOptionsHelper();
  var isArray = requireArrayHelper().isArray;
  var options;
  var currentElement;
  function validateOptions(userOptions) {
    options = helper.copyOptions(userOptions);
    helper.ensureFlagExists("ignoreDeclaration", options);
    helper.ensureFlagExists("ignoreInstruction", options);
    helper.ensureFlagExists("ignoreAttributes", options);
    helper.ensureFlagExists("ignoreText", options);
    helper.ensureFlagExists("ignoreComment", options);
    helper.ensureFlagExists("ignoreCdata", options);
    helper.ensureFlagExists("ignoreDoctype", options);
    helper.ensureFlagExists("compact", options);
    helper.ensureFlagExists("alwaysChildren", options);
    helper.ensureFlagExists("addParent", options);
    helper.ensureFlagExists("trim", options);
    helper.ensureFlagExists("nativeType", options);
    helper.ensureFlagExists("nativeTypeAttributes", options);
    helper.ensureFlagExists("sanitize", options);
    helper.ensureFlagExists("instructionHasAttributes", options);
    helper.ensureFlagExists("captureSpacesBetweenElements", options);
    helper.ensureAlwaysArrayExists(options);
    helper.ensureKeyExists("declaration", options);
    helper.ensureKeyExists("instruction", options);
    helper.ensureKeyExists("attributes", options);
    helper.ensureKeyExists("text", options);
    helper.ensureKeyExists("comment", options);
    helper.ensureKeyExists("cdata", options);
    helper.ensureKeyExists("doctype", options);
    helper.ensureKeyExists("type", options);
    helper.ensureKeyExists("name", options);
    helper.ensureKeyExists("elements", options);
    helper.ensureKeyExists("parent", options);
    helper.checkFnExists("doctype", options);
    helper.checkFnExists("instruction", options);
    helper.checkFnExists("cdata", options);
    helper.checkFnExists("comment", options);
    helper.checkFnExists("text", options);
    helper.checkFnExists("instructionName", options);
    helper.checkFnExists("elementName", options);
    helper.checkFnExists("attributeName", options);
    helper.checkFnExists("attributeValue", options);
    helper.checkFnExists("attributes", options);
    return options;
  }
  function nativeType(value) {
    var nValue = Number(value);
    if (!isNaN(nValue)) {
      return nValue;
    }
    var bValue = value.toLowerCase();
    if (bValue === "true") {
      return true;
    } else if (bValue === "false") {
      return false;
    }
    return value;
  }
  function addField(type, value) {
    var key;
    if (options.compact) {
      if (!currentElement[options[type + "Key"]] && (isArray(options.alwaysArray) ? options.alwaysArray.indexOf(options[type + "Key"]) !== -1 : options.alwaysArray)) {
        currentElement[options[type + "Key"]] = [];
      }
      if (currentElement[options[type + "Key"]] && !isArray(currentElement[options[type + "Key"]])) {
        currentElement[options[type + "Key"]] = [currentElement[options[type + "Key"]]];
      }
      if (type + "Fn" in options && typeof value === "string") {
        value = options[type + "Fn"](value, currentElement);
      }
      if (type === "instruction" && ("instructionFn" in options || "instructionNameFn" in options)) {
        for (key in value) {
          if (value.hasOwnProperty(key)) {
            if ("instructionFn" in options) {
              value[key] = options.instructionFn(value[key], key, currentElement);
            } else {
              var temp = value[key];
              delete value[key];
              value[options.instructionNameFn(key, temp, currentElement)] = temp;
            }
          }
        }
      }
      if (isArray(currentElement[options[type + "Key"]])) {
        currentElement[options[type + "Key"]].push(value);
      } else {
        currentElement[options[type + "Key"]] = value;
      }
    } else {
      if (!currentElement[options.elementsKey]) {
        currentElement[options.elementsKey] = [];
      }
      var element = {};
      element[options.typeKey] = type;
      if (type === "instruction") {
        for (key in value) {
          if (value.hasOwnProperty(key)) {
            break;
          }
        }
        element[options.nameKey] = "instructionNameFn" in options ? options.instructionNameFn(key, value, currentElement) : key;
        if (options.instructionHasAttributes) {
          element[options.attributesKey] = value[key][options.attributesKey];
          if ("instructionFn" in options) {
            element[options.attributesKey] = options.instructionFn(element[options.attributesKey], key, currentElement);
          }
        } else {
          if ("instructionFn" in options) {
            value[key] = options.instructionFn(value[key], key, currentElement);
          }
          element[options.instructionKey] = value[key];
        }
      } else {
        if (type + "Fn" in options) {
          value = options[type + "Fn"](value, currentElement);
        }
        element[options[type + "Key"]] = value;
      }
      if (options.addParent) {
        element[options.parentKey] = currentElement;
      }
      currentElement[options.elementsKey].push(element);
    }
  }
  function manipulateAttributes(attributes) {
    if ("attributesFn" in options && attributes) {
      attributes = options.attributesFn(attributes, currentElement);
    }
    if ((options.trim || "attributeValueFn" in options || "attributeNameFn" in options || options.nativeTypeAttributes) && attributes) {
      var key;
      for (key in attributes) {
        if (attributes.hasOwnProperty(key)) {
          if (options.trim) attributes[key] = attributes[key].trim();
          if (options.nativeTypeAttributes) {
            attributes[key] = nativeType(attributes[key]);
          }
          if ("attributeValueFn" in options) attributes[key] = options.attributeValueFn(attributes[key], key, currentElement);
          if ("attributeNameFn" in options) {
            var temp = attributes[key];
            delete attributes[key];
            attributes[options.attributeNameFn(key, attributes[key], currentElement)] = temp;
          }
        }
      }
    }
    return attributes;
  }
  function onInstruction(instruction) {
    var attributes = {};
    if (instruction.body && (instruction.name.toLowerCase() === "xml" || options.instructionHasAttributes)) {
      var attrsRegExp = /([\w:-]+)\s*=\s*(?:"([^"]*)"|'([^']*)'|(\w+))\s*/g;
      var match;
      while ((match = attrsRegExp.exec(instruction.body)) !== null) {
        attributes[match[1]] = match[2] || match[3] || match[4];
      }
      attributes = manipulateAttributes(attributes);
    }
    if (instruction.name.toLowerCase() === "xml") {
      if (options.ignoreDeclaration) {
        return;
      }
      currentElement[options.declarationKey] = {};
      if (Object.keys(attributes).length) {
        currentElement[options.declarationKey][options.attributesKey] = attributes;
      }
      if (options.addParent) {
        currentElement[options.declarationKey][options.parentKey] = currentElement;
      }
    } else {
      if (options.ignoreInstruction) {
        return;
      }
      if (options.trim) {
        instruction.body = instruction.body.trim();
      }
      var value = {};
      if (options.instructionHasAttributes && Object.keys(attributes).length) {
        value[instruction.name] = {};
        value[instruction.name][options.attributesKey] = attributes;
      } else {
        value[instruction.name] = instruction.body;
      }
      addField("instruction", value);
    }
  }
  function onStartElement(name, attributes) {
    var element;
    if (typeof name === "object") {
      attributes = name.attributes;
      name = name.name;
    }
    attributes = manipulateAttributes(attributes);
    if ("elementNameFn" in options) {
      name = options.elementNameFn(name, currentElement);
    }
    if (options.compact) {
      element = {};
      if (!options.ignoreAttributes && attributes && Object.keys(attributes).length) {
        element[options.attributesKey] = {};
        var key;
        for (key in attributes) {
          if (attributes.hasOwnProperty(key)) {
            element[options.attributesKey][key] = attributes[key];
          }
        }
      }
      if (!(name in currentElement) && (isArray(options.alwaysArray) ? options.alwaysArray.indexOf(name) !== -1 : options.alwaysArray)) {
        currentElement[name] = [];
      }
      if (currentElement[name] && !isArray(currentElement[name])) {
        currentElement[name] = [currentElement[name]];
      }
      if (isArray(currentElement[name])) {
        currentElement[name].push(element);
      } else {
        currentElement[name] = element;
      }
    } else {
      if (!currentElement[options.elementsKey]) {
        currentElement[options.elementsKey] = [];
      }
      element = {};
      element[options.typeKey] = "element";
      element[options.nameKey] = name;
      if (!options.ignoreAttributes && attributes && Object.keys(attributes).length) {
        element[options.attributesKey] = attributes;
      }
      if (options.alwaysChildren) {
        element[options.elementsKey] = [];
      }
      currentElement[options.elementsKey].push(element);
    }
    element[options.parentKey] = currentElement;
    currentElement = element;
  }
  function onText(text) {
    if (options.ignoreText) {
      return;
    }
    if (!text.trim() && !options.captureSpacesBetweenElements) {
      return;
    }
    if (options.trim) {
      text = text.trim();
    }
    if (options.nativeType) {
      text = nativeType(text);
    }
    if (options.sanitize) {
      text = text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
    }
    addField("text", text);
  }
  function onComment(comment) {
    if (options.ignoreComment) {
      return;
    }
    if (options.trim) {
      comment = comment.trim();
    }
    addField("comment", comment);
  }
  function onEndElement(name) {
    var parentElement = currentElement[options.parentKey];
    if (!options.addParent) {
      delete currentElement[options.parentKey];
    }
    currentElement = parentElement;
  }
  function onCdata(cdata) {
    if (options.ignoreCdata) {
      return;
    }
    if (options.trim) {
      cdata = cdata.trim();
    }
    addField("cdata", cdata);
  }
  function onDoctype(doctype) {
    if (options.ignoreDoctype) {
      return;
    }
    doctype = doctype.replace(/^ /, "");
    if (options.trim) {
      doctype = doctype.trim();
    }
    addField("doctype", doctype);
  }
  function onError(error) {
    error.note = error;
  }
  xml2js$1 = function(xml, userOptions) {
    var parser2 = sax2.parser(true, {});
    var result = {};
    currentElement = result;
    options = validateOptions(userOptions);
    {
      parser2.opt = { strictEntities: true };
      parser2.onopentag = onStartElement;
      parser2.ontext = onText;
      parser2.oncomment = onComment;
      parser2.onclosetag = onEndElement;
      parser2.onerror = onError;
      parser2.oncdata = onCdata;
      parser2.ondoctype = onDoctype;
      parser2.onprocessinginstruction = onInstruction;
    }
    {
      parser2.write(xml).close();
    }
    if (result[options.elementsKey]) {
      var temp = result[options.elementsKey];
      delete result[options.elementsKey];
      result[options.elementsKey] = temp;
      delete result.text;
    }
    return result;
  };
  return xml2js$1;
}
var xml2json;
var hasRequiredXml2json;
function requireXml2json() {
  if (hasRequiredXml2json) return xml2json;
  hasRequiredXml2json = 1;
  var helper = requireOptionsHelper();
  var xml2js2 = requireXml2js$1();
  function validateOptions(userOptions) {
    var options = helper.copyOptions(userOptions);
    helper.ensureSpacesExists(options);
    return options;
  }
  xml2json = function(xml, userOptions) {
    var options, js, json, parentKey;
    options = validateOptions(userOptions);
    js = xml2js2(xml, options);
    parentKey = "compact" in options && options.compact ? "_parent" : "parent";
    if ("addParent" in options && options.addParent) {
      json = JSON.stringify(js, function(k, v) {
        return k === parentKey ? "_" : v;
      }, options.spaces);
    } else {
      json = JSON.stringify(js, null, options.spaces);
    }
    return json.replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029");
  };
  return xml2json;
}
var js2xml;
var hasRequiredJs2xml;
function requireJs2xml() {
  if (hasRequiredJs2xml) return js2xml;
  hasRequiredJs2xml = 1;
  var helper = requireOptionsHelper();
  var isArray = requireArrayHelper().isArray;
  var currentElement, currentElementName;
  function validateOptions(userOptions) {
    var options = helper.copyOptions(userOptions);
    helper.ensureFlagExists("ignoreDeclaration", options);
    helper.ensureFlagExists("ignoreInstruction", options);
    helper.ensureFlagExists("ignoreAttributes", options);
    helper.ensureFlagExists("ignoreText", options);
    helper.ensureFlagExists("ignoreComment", options);
    helper.ensureFlagExists("ignoreCdata", options);
    helper.ensureFlagExists("ignoreDoctype", options);
    helper.ensureFlagExists("compact", options);
    helper.ensureFlagExists("indentText", options);
    helper.ensureFlagExists("indentCdata", options);
    helper.ensureFlagExists("indentAttributes", options);
    helper.ensureFlagExists("indentInstruction", options);
    helper.ensureFlagExists("fullTagEmptyElement", options);
    helper.ensureFlagExists("noQuotesForNativeAttributes", options);
    helper.ensureSpacesExists(options);
    if (typeof options.spaces === "number") {
      options.spaces = Array(options.spaces + 1).join(" ");
    }
    helper.ensureKeyExists("declaration", options);
    helper.ensureKeyExists("instruction", options);
    helper.ensureKeyExists("attributes", options);
    helper.ensureKeyExists("text", options);
    helper.ensureKeyExists("comment", options);
    helper.ensureKeyExists("cdata", options);
    helper.ensureKeyExists("doctype", options);
    helper.ensureKeyExists("type", options);
    helper.ensureKeyExists("name", options);
    helper.ensureKeyExists("elements", options);
    helper.checkFnExists("doctype", options);
    helper.checkFnExists("instruction", options);
    helper.checkFnExists("cdata", options);
    helper.checkFnExists("comment", options);
    helper.checkFnExists("text", options);
    helper.checkFnExists("instructionName", options);
    helper.checkFnExists("elementName", options);
    helper.checkFnExists("attributeName", options);
    helper.checkFnExists("attributeValue", options);
    helper.checkFnExists("attributes", options);
    helper.checkFnExists("fullTagEmptyElement", options);
    return options;
  }
  function writeIndentation(options, depth, firstLine) {
    return (!firstLine && options.spaces ? "\n" : "") + Array(depth + 1).join(options.spaces);
  }
  function writeAttributes(attributes, options, depth) {
    if (options.ignoreAttributes) {
      return "";
    }
    if ("attributesFn" in options) {
      attributes = options.attributesFn(attributes, currentElementName, currentElement);
    }
    var key, attr, attrName, quote, result = [];
    for (key in attributes) {
      if (attributes.hasOwnProperty(key) && attributes[key] !== null && attributes[key] !== void 0) {
        quote = options.noQuotesForNativeAttributes && typeof attributes[key] !== "string" ? "" : '"';
        attr = "" + attributes[key];
        attr = attr.replace(/"/g, "&quot;");
        attrName = "attributeNameFn" in options ? options.attributeNameFn(key, attr, currentElementName, currentElement) : key;
        result.push(options.spaces && options.indentAttributes ? writeIndentation(options, depth + 1, false) : " ");
        result.push(attrName + "=" + quote + ("attributeValueFn" in options ? options.attributeValueFn(attr, key, currentElementName, currentElement) : attr) + quote);
      }
    }
    if (attributes && Object.keys(attributes).length && options.spaces && options.indentAttributes) {
      result.push(writeIndentation(options, depth, false));
    }
    return result.join("");
  }
  function writeDeclaration(declaration, options, depth) {
    currentElement = declaration;
    currentElementName = "xml";
    return options.ignoreDeclaration ? "" : "<?xml" + writeAttributes(declaration[options.attributesKey], options, depth) + "?>";
  }
  function writeInstruction(instruction, options, depth) {
    if (options.ignoreInstruction) {
      return "";
    }
    var key;
    for (key in instruction) {
      if (instruction.hasOwnProperty(key)) {
        break;
      }
    }
    var instructionName = "instructionNameFn" in options ? options.instructionNameFn(key, instruction[key], currentElementName, currentElement) : key;
    if (typeof instruction[key] === "object") {
      currentElement = instruction;
      currentElementName = instructionName;
      return "<?" + instructionName + writeAttributes(instruction[key][options.attributesKey], options, depth) + "?>";
    } else {
      var instructionValue = instruction[key] ? instruction[key] : "";
      if ("instructionFn" in options) instructionValue = options.instructionFn(instructionValue, key, currentElementName, currentElement);
      return "<?" + instructionName + (instructionValue ? " " + instructionValue : "") + "?>";
    }
  }
  function writeComment(comment, options) {
    return options.ignoreComment ? "" : "<!--" + ("commentFn" in options ? options.commentFn(comment, currentElementName, currentElement) : comment) + "-->";
  }
  function writeCdata(cdata, options) {
    return options.ignoreCdata ? "" : "<![CDATA[" + ("cdataFn" in options ? options.cdataFn(cdata, currentElementName, currentElement) : cdata.replace("]]>", "]]]]><![CDATA[>")) + "]]>";
  }
  function writeDoctype(doctype, options) {
    return options.ignoreDoctype ? "" : "<!DOCTYPE " + ("doctypeFn" in options ? options.doctypeFn(doctype, currentElementName, currentElement) : doctype) + ">";
  }
  function writeText(text, options) {
    if (options.ignoreText) return "";
    text = "" + text;
    text = text.replace(/&amp;/g, "&");
    text = text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
    return "textFn" in options ? options.textFn(text, currentElementName, currentElement) : text;
  }
  function hasContent(element, options) {
    var i;
    if (element.elements && element.elements.length) {
      for (i = 0; i < element.elements.length; ++i) {
        switch (element.elements[i][options.typeKey]) {
          case "text":
            if (options.indentText) {
              return true;
            }
            break;
          // skip to next key
          case "cdata":
            if (options.indentCdata) {
              return true;
            }
            break;
          // skip to next key
          case "instruction":
            if (options.indentInstruction) {
              return true;
            }
            break;
          // skip to next key
          case "doctype":
          case "comment":
          case "element":
            return true;
          default:
            return true;
        }
      }
    }
    return false;
  }
  function writeElement(element, options, depth) {
    currentElement = element;
    currentElementName = element.name;
    var xml = [], elementName = "elementNameFn" in options ? options.elementNameFn(element.name, element) : element.name;
    xml.push("<" + elementName);
    if (element[options.attributesKey]) {
      xml.push(writeAttributes(element[options.attributesKey], options, depth));
    }
    var withClosingTag = element[options.elementsKey] && element[options.elementsKey].length || element[options.attributesKey] && element[options.attributesKey]["xml:space"] === "preserve";
    if (!withClosingTag) {
      if ("fullTagEmptyElementFn" in options) {
        withClosingTag = options.fullTagEmptyElementFn(element.name, element);
      } else {
        withClosingTag = options.fullTagEmptyElement;
      }
    }
    if (withClosingTag) {
      xml.push(">");
      if (element[options.elementsKey] && element[options.elementsKey].length) {
        xml.push(writeElements(element[options.elementsKey], options, depth + 1));
        currentElement = element;
        currentElementName = element.name;
      }
      xml.push(options.spaces && hasContent(element, options) ? "\n" + Array(depth + 1).join(options.spaces) : "");
      xml.push("</" + elementName + ">");
    } else {
      xml.push("/>");
    }
    return xml.join("");
  }
  function writeElements(elements, options, depth, firstLine) {
    return elements.reduce(function(xml, element) {
      var indent = writeIndentation(options, depth, firstLine && !xml);
      switch (element.type) {
        case "element":
          return xml + indent + writeElement(element, options, depth);
        case "comment":
          return xml + indent + writeComment(element[options.commentKey], options);
        case "doctype":
          return xml + indent + writeDoctype(element[options.doctypeKey], options);
        case "cdata":
          return xml + (options.indentCdata ? indent : "") + writeCdata(element[options.cdataKey], options);
        case "text":
          return xml + (options.indentText ? indent : "") + writeText(element[options.textKey], options);
        case "instruction":
          var instruction = {};
          instruction[element[options.nameKey]] = element[options.attributesKey] ? element : element[options.instructionKey];
          return xml + (options.indentInstruction ? indent : "") + writeInstruction(instruction, options, depth);
      }
    }, "");
  }
  function hasContentCompact(element, options, anyContent) {
    var key;
    for (key in element) {
      if (element.hasOwnProperty(key)) {
        switch (key) {
          case options.parentKey:
          case options.attributesKey:
            break;
          // skip to next key
          case options.textKey:
            if (options.indentText || anyContent) {
              return true;
            }
            break;
          // skip to next key
          case options.cdataKey:
            if (options.indentCdata || anyContent) {
              return true;
            }
            break;
          // skip to next key
          case options.instructionKey:
            if (options.indentInstruction || anyContent) {
              return true;
            }
            break;
          // skip to next key
          case options.doctypeKey:
          case options.commentKey:
            return true;
          default:
            return true;
        }
      }
    }
    return false;
  }
  function writeElementCompact(element, name, options, depth, indent) {
    currentElement = element;
    currentElementName = name;
    var elementName = "elementNameFn" in options ? options.elementNameFn(name, element) : name;
    if (typeof element === "undefined" || element === null || element === "") {
      return "fullTagEmptyElementFn" in options && options.fullTagEmptyElementFn(name, element) || options.fullTagEmptyElement ? "<" + elementName + "></" + elementName + ">" : "<" + elementName + "/>";
    }
    var xml = [];
    if (name) {
      xml.push("<" + elementName);
      if (typeof element !== "object") {
        xml.push(">" + writeText(element, options) + "</" + elementName + ">");
        return xml.join("");
      }
      if (element[options.attributesKey]) {
        xml.push(writeAttributes(element[options.attributesKey], options, depth));
      }
      var withClosingTag = hasContentCompact(element, options, true) || element[options.attributesKey] && element[options.attributesKey]["xml:space"] === "preserve";
      if (!withClosingTag) {
        if ("fullTagEmptyElementFn" in options) {
          withClosingTag = options.fullTagEmptyElementFn(name, element);
        } else {
          withClosingTag = options.fullTagEmptyElement;
        }
      }
      if (withClosingTag) {
        xml.push(">");
      } else {
        xml.push("/>");
        return xml.join("");
      }
    }
    xml.push(writeElementsCompact(element, options, depth + 1, false));
    currentElement = element;
    currentElementName = name;
    if (name) {
      xml.push((indent ? writeIndentation(options, depth, false) : "") + "</" + elementName + ">");
    }
    return xml.join("");
  }
  function writeElementsCompact(element, options, depth, firstLine) {
    var i, key, nodes, xml = [];
    for (key in element) {
      if (element.hasOwnProperty(key)) {
        nodes = isArray(element[key]) ? element[key] : [element[key]];
        for (i = 0; i < nodes.length; ++i) {
          switch (key) {
            case options.declarationKey:
              xml.push(writeDeclaration(nodes[i], options, depth));
              break;
            case options.instructionKey:
              xml.push((options.indentInstruction ? writeIndentation(options, depth, firstLine) : "") + writeInstruction(nodes[i], options, depth));
              break;
            case options.attributesKey:
            case options.parentKey:
              break;
            // skip
            case options.textKey:
              xml.push((options.indentText ? writeIndentation(options, depth, firstLine) : "") + writeText(nodes[i], options));
              break;
            case options.cdataKey:
              xml.push((options.indentCdata ? writeIndentation(options, depth, firstLine) : "") + writeCdata(nodes[i], options));
              break;
            case options.doctypeKey:
              xml.push(writeIndentation(options, depth, firstLine) + writeDoctype(nodes[i], options));
              break;
            case options.commentKey:
              xml.push(writeIndentation(options, depth, firstLine) + writeComment(nodes[i], options));
              break;
            default:
              xml.push(writeIndentation(options, depth, firstLine) + writeElementCompact(nodes[i], key, options, depth, hasContentCompact(nodes[i], options)));
          }
          firstLine = firstLine && !xml.length;
        }
      }
    }
    return xml.join("");
  }
  js2xml = function(js, options) {
    options = validateOptions(options);
    var xml = [];
    currentElement = js;
    currentElementName = "_root_";
    if (options.compact) {
      xml.push(writeElementsCompact(js, options, 0, true));
    } else {
      if (js[options.declarationKey]) {
        xml.push(writeDeclaration(js[options.declarationKey], options, 0));
      }
      if (js[options.elementsKey] && js[options.elementsKey].length) {
        xml.push(writeElements(js[options.elementsKey], options, 0, !xml.length));
      }
    }
    return xml.join("");
  };
  return js2xml;
}
var json2xml;
var hasRequiredJson2xml;
function requireJson2xml() {
  if (hasRequiredJson2xml) return json2xml;
  hasRequiredJson2xml = 1;
  var js2xml2 = requireJs2xml();
  json2xml = function(json, options) {
    if (json instanceof Buffer) {
      json = json.toString();
    }
    var js = null;
    if (typeof json === "string") {
      try {
        js = JSON.parse(json);
      } catch (e) {
        throw new Error("The JSON structure is invalid");
      }
    } else {
      js = json;
    }
    return js2xml2(js, options);
  };
  return json2xml;
}
var lib$1;
var hasRequiredLib$1;
function requireLib$1() {
  if (hasRequiredLib$1) return lib$1;
  hasRequiredLib$1 = 1;
  var xml2js2 = requireXml2js$1();
  var xml2json2 = requireXml2json();
  var js2xml2 = requireJs2xml();
  var json2xml2 = requireJson2xml();
  lib$1 = {
    xml2js: xml2js2,
    xml2json: xml2json2,
    js2xml: js2xml2,
    json2xml: json2xml2
  };
  return lib$1;
}
var libExports = requireLib$1();
const schemaPrefixRegEx = new RegExp("</?(|[^ ]+:)schema");
const items = [
  "element",
  "sequence",
  "choice",
  "group",
  "simpleType",
  "complexType",
  "annotation",
  "appinfo",
  "assert",
  "discriminator",
  "defineFormat",
  "format",
  "newVariableInstance",
  "defineVariable",
  "setVariable",
  "defineEscapeScheme",
  "escapeScheme",
  "dfdl:element",
  "dfdl:sequence",
  "dfdl:simpleType",
  "restriction",
  "schema",
  "xml version",
  "include",
  "import"
];
class XmlItem {
  constructor() {
    this._itemName = "none";
    this._itemNS = "none";
    this._itemAttributes = [];
  }
  get itemName() {
    return this._itemName;
  }
  set itemName(name) {
    this._itemName = name;
  }
  get itemNS() {
    return this._itemNS;
  }
  set itemNS(nameSpace) {
    this._itemNS = nameSpace;
  }
  set itemAttributes(attributeNames) {
    this._itemAttributes = attributeNames;
  }
  get itemAttributes() {
    return this._itemAttributes;
  }
}
function getItems() {
  return items;
}
function getSchemaNsPrefix(document2) {
  const pos = new vscode__namespace.Position(0, 0);
  return getNsPrefix(document2, pos);
}
const defaultXsdNsPrefix = "";
const dfdlDefaultPrefix = "dfdl:";
function insertSnippet(snippetString, backpos) {
  vscode__namespace.window.activeTextEditor?.insertSnippet(
    new vscode__namespace.SnippetString(snippetString),
    backpos
  );
}
function lineCount(document2, position, tag) {
  let lineNum = position.line;
  let lineCount2 = 0;
  let nsPrefix = getNsPrefix(document2, position);
  while (lineNum !== 0) {
    --lineNum;
    ++lineCount2;
    const triggerText = document2.lineAt(lineNum).text;
    if (triggerText.includes("<" + nsPrefix + tag) && !triggerText.includes("</" + nsPrefix + tag) && !triggerText.includes("/>")) {
      return lineCount2;
    }
  }
  return lineCount2;
}
function nearestOpen(document2, position) {
  let xmlItem = new XmlItem();
  if (document2.lineCount === 1 && position.character === 0) {
    return xmlItem;
  }
  const nsPrefix = getNsPrefix(document2, position);
  for (let i = 0; i < items.length; ++i) {
    let [isTagOpen, isDfdlNs, attributeNames] = checkTagOpen(
      document2,
      position,
      nsPrefix,
      items[i]
    );
    if (isTagOpen) {
      if (isDfdlNs) {
        xmlItem.itemNS = "dfdl:";
      } else {
        xmlItem.itemNS = nsPrefix;
      }
      xmlItem.itemName = items[i];
      xmlItem.itemAttributes = attributeNames;
      return xmlItem;
    }
  }
  return xmlItem;
}
function nearestTag(document2, position, nsPrefix, startLine, startPos) {
  const triggerLine = position.line;
  let lineNum = startLine;
  const triggerText = document2.lineAt(triggerLine).text;
  const itemsOnLine = getItemsOnLineCount(document2.lineAt(lineNum).text);
  let tagPos = triggerText.indexOf("<");
  let endPos = triggerText.lastIndexOf(">");
  if (itemsOnLine > 1 && startPos !== tagPos && startPos < endPos && endPos != startPos) {
    let textBeforeTrigger = triggerText.substring(0, startPos);
    let prevTagPos = 0;
    while (prevTagPos > -1) {
      prevTagPos = textBeforeTrigger.lastIndexOf("<");
      let tag = textBeforeTrigger.substring(prevTagPos);
      if (!textBeforeTrigger.includes("</") && !textBeforeTrigger.includes("/>")) {
        for (let i = 0; i < items.length; ++i) {
          if (tag.includes("<" + nsPrefix + items[i])) {
            return [items[i], startLine, prevTagPos];
          }
        }
      }
      textBeforeTrigger = textBeforeTrigger.substring(0, prevTagPos);
    }
  } else {
    if (startLine === triggerLine && (tagPos === startPos || triggerText.trim() === "")) {
      --lineNum;
    }
    while (lineNum > -1 && lineNum < document2.lineCount) {
      let currentText = document2.lineAt(lineNum).text;
      if (getItemsOnLineCount(currentText) < 2) {
        if (!currentText.includes("/>")) {
          for (let i = 0; i < items.length; ++i) {
            nsPrefix = getNsPrefix(document2, position);
            if (!currentText.includes("</") && (currentText.includes("<" + nsPrefix + items[i]) || lineNum === 0 && currentText.includes(items[i]))) {
              tagPos = currentText.lastIndexOf("<");
              return [items[i], lineNum, tagPos];
            }
            if (currentText.includes("<" + nsPrefix + items[i]) && currentText.includes("</" + nsPrefix + items[i]) && position.character > currentText.indexOf(">") && position.character <= currentText.indexOf("</")) {
              tagPos = currentText.lastIndexOf("<");
              return [items[i], lineNum, tagPos];
            }
          }
        }
      }
      --lineNum;
    }
  }
  return ["none", 0, 0];
}
function checkTagOpen(document2, position, nsPrefix, tag) {
  let triggerLine = position.line;
  let triggerText = document2.lineAt(triggerLine).text;
  let itemsOnLine = getItemsOnLineCount(triggerText);
  let isMultiLineTag = false;
  let isDfdlPrefix = false;
  let origTriggerLine = triggerLine;
  let compareText = triggerText;
  let compareLine = triggerLine;
  let attributeNames = [];
  const triggerPos = position.character;
  while (itemsOnLine < 2 && !triggerText.trim().startsWith("<")) {
    triggerText = document2.lineAt(--triggerLine).text;
  }
  let tagPos = triggerText.lastIndexOf("<" + nsPrefix + tag);
  if (tagPos < 0) {
    tagPos = triggerText.lastIndexOf("<dfdl:" + tag);
    if (tagPos > 0) {
      isDfdlPrefix = true;
      nsPrefix = "dfdl:";
    }
  }
  if (itemsOnLine < 2 && !document2.lineAt(triggerLine + 1).text.trim().startsWith("<") && triggerText.trim().startsWith("<" + nsPrefix + tag) && triggerText.indexOf(">", tagPos) < 0) {
    isMultiLineTag = true;
  }
  if (!isMultiLineTag) {
    const nextTagPos = triggerText.indexOf("<", tagPos + 1);
    let tagEndPos = triggerText.indexOf(">", tagPos);
    if (tagPos > -1 && itemsOnLine >= 1) {
      if (triggerPos > tagPos && (triggerPos <= tagEndPos && (nextTagPos > tagEndPos || nextTagPos === -1) || tagEndPos === -1)) {
        attributeNames = getAttributeNames(document2, position, nsPrefix, tag);
        return [true, isDfdlPrefix, attributeNames];
      }
    }
    while (compareText.trim() === "") {
      compareText = document2.lineAt(--compareLine).text;
    }
    tagPos = triggerText.indexOf("<" + nsPrefix + tag);
    if (tagPos < 0) {
      tagPos = triggerText.lastIndexOf("<dfdl:" + tag);
      if (tagPos > 0) {
        isDfdlPrefix = true;
        nsPrefix = "dfdl:";
      }
    }
    if (itemsOnLine < 2 && tagPos > -1) {
      if (triggerText !== compareText) {
        tagEndPos = compareText.indexOf(">");
      }
      if (triggerPos > tagPos && triggerPos <= tagEndPos && triggerLine === position.line || compareLine == position.line && triggerPos <= tagEndPos && triggerPos > tagPos || position.line < origTriggerLine) {
        attributeNames = getAttributeNames(document2, position, nsPrefix, tag);
        return [true, isDfdlPrefix, attributeNames];
      }
    }
  }
  if (!isMultiLineTag || tagPos === -1) {
    return [false, isDfdlPrefix, attributeNames];
  }
  return checkMultiLineTag(
    document2,
    position,
    itemsOnLine,
    nsPrefix,
    tagPos,
    triggerLine,
    tag
  );
}
function getItemPrefix(item, nsPrefix) {
  let itemPrefix = nsPrefix;
  if (item === "assert" || item === "discriminator" || item === "defineFormat" || item === "format" || item.includes("Variable") || item.includes("scape")) {
    itemPrefix = "dfdl:";
  }
  if (item === "xml version") {
    itemPrefix = "?";
  }
  if (item === "dfdl:element" || item === "dfdl:sequence" || item === "dfdl:simpleType" || item === "dfdl:format") {
    itemPrefix = "";
  }
  return itemPrefix;
}
function checkMultiLineTag(document2, position, itemsOnLine, nsPrefix, tagPos, tagLine, tag, isDfdlTag = false) {
  if (nsPrefix === "dfdl:") {
    isDfdlTag = true;
  }
  let attributeNames = [];
  if (itemsOnLine > 1) {
    return [false, isDfdlTag, attributeNames];
  }
  let triggerLine = position.line;
  let currentLine = position.line;
  let openTagLine = position.line;
  let closeTagLine = position.line;
  let origText = document2.lineAt(currentLine).text;
  while (origText.trim() === "") {
    origText = document2.lineAt(--currentLine).text;
  }
  if ((position.character > origText.indexOf("</") || position.line > currentLine) && (origText.includes("</" + nsPrefix + tag) || origText.includes("/>"))) {
    return [false, isDfdlTag, attributeNames];
  }
  let currentText = origText;
  while ((currentText.trim() === "" || !currentText.includes("<" + nsPrefix + tag)) && openTagLine > 0) {
    --openTagLine;
    currentText = document2.lineAt(openTagLine).text;
  }
  if (currentText.includes("<" + nsPrefix + tag)) {
    let multiLineText = currentText.trim();
    let closeText = document2.lineAt(openTagLine).text;
    closeTagLine = openTagLine;
    while ((closeText.trim() === "" || !closeText.includes(">")) && closeTagLine < document2.lineCount) {
      ++closeTagLine;
      closeText = document2.lineAt(closeTagLine).text;
      multiLineText += " " + closeText.trim();
    }
    if (closeText.includes(">")) {
      multiLineText += closeText.trim();
    }
    currentText = multiLineText;
    if (currentText.includes("<" + nsPrefix + tag) && currentText.includes(">") && closeTagLine >= triggerLine) {
      attributeNames = getAttributeNames(document2, position, nsPrefix, tag);
      return [true, isDfdlTag, attributeNames];
    }
  }
  return [false, isDfdlTag, attributeNames];
}
function getNsPrefix(document2, position) {
  let initialLineNum = position.line;
  let lineNum = 0;
  while (initialLineNum !== 0 && lineNum <= initialLineNum) {
    const lineText = document2.lineAt(lineNum).text;
    let text = lineText.match(schemaPrefixRegEx);
    if (text != null) {
      return text[1];
    }
    ++lineNum;
  }
  return defaultXsdNsPrefix;
}
function getAttributeNames(document2, position, nsPrefix, tag) {
  let currentLine = position.line;
  let openTagLine = position.line;
  let closeTagLine = position.line;
  let currentText = document2.lineAt(currentLine).text;
  let closeText = currentText;
  if (currentText.trim().startsWith("<" + nsPrefix + tag) && !currentText.endsWith(">") && !document2.lineAt(currentLine + 1).text.trim().startsWith("<")) {
    while ((currentText.trim() === "" || !currentText.includes("<" + nsPrefix + tag)) && openTagLine > -1) {
      --openTagLine;
      currentText = document2.lineAt(openTagLine).text;
    }
    let multiLineText = currentText.trim();
    closeTagLine = openTagLine;
    closeText = document2.lineAt(openTagLine).text;
    while ((closeText.trim() === "" || !closeText.includes(">")) && closeTagLine < document2.lineCount) {
      ++closeTagLine;
      closeText = document2.lineAt(closeTagLine).text;
      multiLineText += " " + closeText.trim();
    }
    currentText = multiLineText;
  }
  let attributeNames = [];
  if (currentText.includes(">")) {
    const xmljs = libExports.xml2js(currentText, {});
    const attributes = xmljs.elements?.[0].attributes;
    if (attributes) {
      const attributeSet = new Set(Object.keys(attributes));
      attributeNames = [...attributeSet];
      return attributeNames;
    }
  }
  return attributeNames;
}
function getItemsOnLineCount(triggerText) {
  let itemsOnLine = 0;
  let nextPos = 0;
  let result = 0;
  if (triggerText.includes("schema") && !triggerText.includes("schemaLocation")) {
    itemsOnLine = 1;
    return itemsOnLine;
  }
  while (result != -1 && triggerText.includes("<")) {
    result = triggerText.indexOf("<", nextPos);
    if (result > -1) {
      let endPos = triggerText.indexOf(">", nextPos);
      if (endPos === -1) {
        ++itemsOnLine;
        break;
      }
      let testForCloseTag = triggerText.substring(nextPos, endPos);
      if (!testForCloseTag.includes("</") && !testForCloseTag.includes("<!--") && !testForCloseTag.includes("-->") && !testForCloseTag.includes("<[") && !testForCloseTag.includes("<![")) {
        ++itemsOnLine;
      }
      result = nextPos;
      nextPos = endPos + 1;
    }
  }
  return itemsOnLine;
}
function isInXPath(document2, position) {
  return isXPath(position);
}
function isNotTriggerChar(document2, position, triggerChar) {
  const triggerText = document2.lineAt(position.line).text;
  const triggerPos = position.character;
  const trigChar = triggerText.substring(triggerPos - 1, triggerPos);
  if (trigChar != triggerChar) {
    return true;
  } else {
    return false;
  }
}
function isTagEndTrigger(trigChar) {
  if (trigChar == "/" || trigChar == ">") {
    return true;
  } else {
    return false;
  }
}
function cursorAfterEquals(document2, position) {
  const triggerText = document2.lineAt(position.line).text;
  const triggerPos = position.character;
  const textBeforeTrigger = triggerText.substring(0, triggerPos);
  let currentPos = -1;
  if ((currentPos = textBeforeTrigger.lastIndexOf("=")) === -1) {
    return false;
  }
  if (triggerPos === currentPos + 1) {
    return true;
  }
  return false;
}
function cursorWithinQuotes(document2, position) {
  const quoteChar = ["'", '"'];
  let startLine = position.line;
  for (let i = 0; i < quoteChar.length; ++i) {
    let currentText = document2.lineAt(startLine).text;
    if (currentText.includes("<") && !currentText.includes("'") && !currentText.includes('"')) {
      return false;
    }
    if (currentText.includes(quoteChar[i])) {
      let textBeforeTrigger = currentText.substring(0, position.character);
      if (currentText.indexOf("=" + quoteChar[i]) > position.character && textBeforeTrigger.trim() == "") {
        return false;
      }
      let quoteStartLine = startLine;
      let quoteStartPos = -1;
      let equalStartPos = -1;
      while ((equalStartPos = textBeforeTrigger.lastIndexOf("=" + quoteChar[i])) === -1) {
        if (textBeforeTrigger.indexOf("<") !== -1) {
          break;
        }
        textBeforeTrigger = document2.lineAt(--quoteStartLine).text;
      }
      quoteStartPos = equalStartPos + 1;
      let quoteEndLine = quoteStartLine;
      let quoteEndPos = -1;
      if (quoteStartPos > -1) {
        while (quoteEndLine < document2.lineCount && (quoteEndPos = currentText.indexOf(
          quoteChar[i],
          quoteStartPos + 1
        )) === -1) {
          currentText = document2.lineAt(++quoteEndLine).text;
        }
        if (quoteEndPos > -1 && currentText.indexOf("=", quoteStartPos - 1) === quoteStartPos - 1) {
          if (position.line > quoteStartLine && position.line < quoteEndLine || quoteEndLine === quoteStartLine && position.character > quoteStartPos && position.character <= quoteEndPos || position.line === quoteStartLine && position.character > quoteStartPos && position.line < quoteEndLine || position.line === quoteEndLine && position.character <= quoteEndPos && position.line > quoteStartLine) {
            return true;
          }
        }
      }
    }
  }
  return false;
}
function cursorWithinBraces(document2, position) {
  let startLine = position.line;
  let currentText = document2.lineAt(startLine).text;
  let braceStartLine = startLine;
  let braceStartPos = -1;
  while (braceStartLine > 0 && (braceStartPos = currentText.indexOf("{")) === -1) {
    currentText = document2.lineAt(--braceStartLine).text;
  }
  let braceEndLine = braceStartLine;
  let braceEndPos = -1;
  if (braceStartPos > -1) {
    while (braceEndLine < document2.lineCount && (braceEndPos = currentText.indexOf("}")) === -1) {
      currentText = document2.lineAt(++braceEndLine).text;
    }
    if (braceEndPos > -1) {
      if (position.line > braceStartLine && position.line < braceEndLine || braceEndLine === braceStartLine && position.character > braceStartPos && position.character <= braceEndPos || position.line === braceStartLine && position.character > braceStartPos && position.line < braceEndLine || position.line === braceEndLine && position.character <= braceEndPos && position.line > braceStartLine) {
        return true;
      }
    }
  }
  return false;
}
function checkBraceOpen(document2, position) {
  let lineNum = position.line;
  let triggerText = document2.lineAt(lineNum).text;
  if (triggerText.includes("{")) {
    while (!triggerText.includes("}") && lineNum < document2.lineCount) {
      triggerText = document2.lineAt(++lineNum).text;
    }
    if (!triggerText.includes("}")) {
      return true;
    }
  }
  if (triggerText.includes("}")) {
    while (!triggerText.includes("{") && lineNum > 0) {
      triggerText = document2.lineAt(--lineNum).text;
    }
    if (!triggerText.includes("{")) {
      return true;
    }
  }
  return false;
}
function createCompletionItem(e, preVal, nsPrefix) {
  const completionItem = new vscode__namespace.CompletionItem(e.item);
  const noPreVals = [
    "dfdl:choiceBranchKey=",
    "dfdl:representation",
    "dfdl:choiceDispatchKey=",
    "dfdl:simpleType",
    "dfdl:element",
    "restriction"
  ];
  if (preVal !== "" && !noPreVals.includes(e.item)) {
    completionItem.insertText = new vscode__namespace.SnippetString(
      preVal + e.snippetString
    );
  } else {
    completionItem.insertText = new vscode__namespace.SnippetString(e.snippetString);
  }
  if (e.markdownString) {
    completionItem.documentation = new vscode__namespace.MarkdownString(e.markdownString);
  }
  return completionItem;
}
function checkMissingCloseTag(document2, position, nsPrefix) {
  const triggerLine = position.line;
  const triggerPos = position.character;
  const triggerText = document2.lineAt(triggerLine).text;
  const itemsOnLine = getItemsOnLineCount(triggerText);
  const origPrefix = nsPrefix;
  const items2 = getItems();
  for (let i = 0; i < items2.length; ++i) {
    const textBeforeTrigger = triggerText.substring(0, triggerPos);
    nsPrefix = getItemPrefix(items2[i], origPrefix);
    let tagPos = triggerText.lastIndexOf("<" + nsPrefix + items2[i]);
    if (tagPos < 0) {
      tagPos = triggerText.lastIndexOf("<dfdl:" + items2[i]);
      if (tagPos > 0) {
        nsPrefix = "dfdl:";
      }
    }
    if (itemsOnLine > 1) {
      if (textBeforeTrigger.lastIndexOf("<" + nsPrefix + items2[i]) > -1) {
        let gt1res = getItemsForLineGT1(
          triggerText,
          triggerPos,
          nsPrefix,
          items2,
          i
        );
        if (gt1res != "none") {
          return gt1res;
        }
      }
    }
    if (itemsOnLine < 2) {
      let lt2res = getItemsForLineLT2(
        document2,
        triggerText,
        triggerLine,
        nsPrefix,
        items2,
        i
      );
      if (lt2res != "none") {
        return lt2res;
      }
    }
  }
  return "none";
}
function cursorInsideCloseTag(document2, position) {
  const triggerText = document2.lineAt(position.line).text;
  const triggerPos = position.character;
  const closeTagStart = triggerText.lastIndexOf("</");
  const closeTagEnd = triggerText.lastIndexOf(">");
  if (triggerPos > closeTagStart && triggerPos <= closeTagEnd && closeTagStart !== -1) {
    return true;
  }
  return false;
}
function getCloseTag(document2, position, nsPrefix, tag, startLine, startPos) {
  let lineNum = startLine;
  let tagOpen = startPos;
  const triggerLine = position.line;
  const triggerPos = position.character;
  const triggerText = document2.lineAt(startLine).text;
  const itemsOnLine = getItemsOnLineCount(document2.lineAt(lineNum).text);
  let endPos = triggerText.lastIndexOf(">");
  nsPrefix = getItemPrefix(tag, nsPrefix);
  if (itemsOnLine === 1) {
    if (cursorInsideCloseTag(document2, position))
      return ["none", lineNum, startPos];
  }
  if (itemsOnLine > 1 && startPos < endPos) {
    while (tagOpen > -1 && tagOpen <= triggerPos) {
      tagOpen = triggerText.indexOf("<", tagOpen);
      let tagClose = triggerText.indexOf(">", tagOpen);
      let tagPart = triggerText.substring(tagOpen, tagClose);
      if (tagPart.includes(tag) && (tagPart.includes("</") || tagPart.includes("/>"))) {
        return [tag, startLine, tagOpen];
      }
      tagOpen = tagClose + 1;
    }
  } else {
    let nestedTagCount = 0;
    let endPos2 = triggerText.indexOf(">", startPos);
    if (triggerText.includes("?xml version")) {
      return [tag, 0, 0];
    }
    if ((triggerText.includes("</") || triggerText.includes("/>")) && triggerText.includes(tag) && endPos2 > -1 && itemsOnLine < 2) {
      return [tag, startLine, startPos];
    }
    while (lineNum > -1 && lineNum < document2.lineCount) {
      let currentText = document2.lineAt(lineNum).text;
      let isMultiLineTag = false;
      if (currentText.includes("<!--")) {
        while (!currentText.includes("-->")) {
          currentText = document2.lineAt(++lineNum).text;
        }
        currentText = document2.lineAt(++lineNum).text;
      }
      startPos = currentText.indexOf("<");
      if (getItemsOnLineCount(currentText) < 2) {
        if (currentText.includes("<" + nsPrefix + tag) && currentText.endsWith(">")) {
          while (!currentText.includes("</" + nsPrefix + tag)) {
            currentText = document2.lineAt(++lineNum).text;
            if (getItemsOnLineCount(currentText) > 1) {
              currentText = document2.lineAt(++lineNum).text;
            }
            if (currentText.includes("<" + nsPrefix + tag)) {
              ++nestedTagCount;
              while (!currentText.includes(">")) {
                currentText = document2.lineAt(++lineNum).text;
              }
              if (currentText.includes("/>")) {
                --nestedTagCount;
              }
            }
            if (currentText.includes("</" + nsPrefix + tag) && nestedTagCount > 0) {
              --nestedTagCount;
              currentText = "";
            }
          }
        }
        if (currentText.includes("<" + nsPrefix + tag) && !currentText.includes(">")) {
          isMultiLineTag = true;
          while (!currentText.includes(">")) {
            currentText = document2.lineAt(++lineNum).text;
          }
          if (!currentText.includes("/>")) {
            while (!currentText.includes("</" + nsPrefix + tag)) {
              currentText = document2.lineAt(++lineNum).text;
            }
          }
        }
        if (currentText.includes("</" + nsPrefix + tag) && nestedTagCount === 0 || currentText.includes("/>") && isMultiLineTag) {
          if (isMultiLineTag) {
            startPos = triggerPos;
          }
          if (lineNum == triggerLine && currentText.indexOf(">", triggerPos) === -1) {
            return ["none", lineNum, startPos];
          }
          return [tag, lineNum, startPos];
        }
      }
      ++lineNum;
    }
  }
  return ["none", 0, 0];
}
function getItemsForLineGT1(triggerText, triggerPos, nsPrefix, items2, i) {
  let openTagArray = [];
  let closeTagArray = [];
  let [nextCloseCharPos, nextOpenTagPos] = [0, 0];
  while ((nextOpenTagPos = triggerText.indexOf(
    "<" + nsPrefix + items2[i],
    nextOpenTagPos
  )) > -1) {
    openTagArray.push(nextOpenTagPos);
    if ((nextCloseCharPos = triggerText.indexOf(">", nextOpenTagPos)) > -1) {
      if (triggerText.substring(nextCloseCharPos - 1, nextCloseCharPos + 1) === "/>") {
        openTagArray.splice(-1, 1);
      }
      nextOpenTagPos = nextOpenTagPos + 1;
    }
  }
  while ((nextCloseCharPos = triggerText.indexOf(
    "</" + nsPrefix + items2[i],
    nextCloseCharPos
  )) > -1) {
    closeTagArray.push(nextCloseCharPos);
    nextCloseCharPos = nextCloseCharPos + 1;
  }
  if (openTagArray.length > closeTagArray.length) {
    return items2[i];
  }
  return "none";
}
function getItemsForLineLT2(document2, triggerText, triggerLine, nsPrefix, items2, i) {
  let [currentText, currentLine] = [triggerText, triggerLine];
  let [lineBefore, lineAfter, testLine] = [
    triggerLine,
    triggerLine,
    triggerLine
  ];
  let openTagArray = [];
  let closeTagArray = [];
  nsPrefix = getItemPrefix(items2[i], nsPrefix);
  while (currentText.indexOf("<" + nsPrefix + items2[i]) === -1 && currentLine > -1) {
    --currentLine;
    if (currentLine > -1) {
      currentText = document2.lineAt(currentLine).text;
    }
    if (getItemsOnLineCount(currentText) > 1) {
      --currentLine;
    }
  }
  if (currentText.indexOf("<" + nsPrefix + items2[i]) > -1) {
    while (lineBefore > -1) {
      currentText = document2.lineAt(lineBefore).text;
      if (getItemsOnLineCount(currentText) < 2) {
        if (currentText.indexOf("<" + nsPrefix + items2[i]) > -1) {
          openTagArray.push(lineBefore);
          let testText = currentText;
          if (!testText.includes(">")) {
            testLine = lineBefore;
            while (!testText.includes(">")) {
              testText = document2.lineAt(++testLine).text;
              if (testText.indexOf("<" + nsPrefix + items2[i]) > -1)
                openTagArray.push(testLine);
            }
          }
          if (testText.indexOf("/>") > -1 || testText.includes("xml version") || currentText.indexOf("</" + nsPrefix + items2[i]) > -1) {
            openTagArray.splice(openTagArray.length - 1, 1);
          }
        }
        if (currentText.indexOf("</" + nsPrefix + items2[i]) > -1) {
          closeTagArray.push(lineBefore);
        }
      }
      --lineBefore;
    }
    ++lineAfter;
    while (lineAfter < document2.lineCount) {
      currentText = document2.lineAt(lineAfter).text;
      if (getItemsOnLineCount(currentText) < 2) {
        if (currentText.indexOf("<" + nsPrefix + items2[i]) > -1) {
          openTagArray.push(lineAfter);
          while (!currentText.includes(">")) {
            currentText = document2.lineAt(++lineAfter).text;
          }
          if (currentText.indexOf("/>") > -1) {
            openTagArray.splice(openTagArray.length - 1, 1);
          }
        }
        if (currentText.indexOf("</" + nsPrefix + items2[i]) > -1) {
          closeTagArray.push(lineAfter);
        }
      }
      ++lineAfter;
    }
    if (openTagArray.length > closeTagArray.length) {
      return items2[i];
    }
  }
  return "none";
}
const elementCompletion = (definedVariables, nsPrefix) => {
  return {
    items: [
      {
        item: "xml version",
        snippetString: '<?xml version="1.0" encoding="UTF-8"?>\n$0'
      },
      {
        item: nsPrefix + "schema",
        snippetString: '<${1|\0,xs:,xsd:|}$2schema xmlns:xs="http://www.w3.org/2001/xmlSchema"\n		xmlns:dfdl="http://www.ogf.org/dfdl/dfdl-1.0/"\n		xmlns:daf="urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018:ext"\n		xmlns:fn="http:/www.w3.org/2005/xpath-functions"\nelementFormDefault="unqualified"$0'
      },
      {
        item: nsPrefix + "element",
        snippetString: "<" + nsPrefix + "element$0",
        markdownString: "Defines an xs element"
      },
      {
        item: nsPrefix + "element name",
        snippetString: "<" + nsPrefix + 'element name="$1"$0',
        markdownString: "Defines an xs element"
      },
      {
        item: nsPrefix + "element ref",
        snippetString: "<" + nsPrefix + 'element ref="$1"$0',
        markdownString: "Defines a reference to a declared element"
      },
      {
        item: nsPrefix + "group",
        snippetString: "<" + nsPrefix + 'group "$1">\n	$0\n</' + nsPrefix + "group>",
        markdownString: "Defines a named model group to be reused later"
      },
      {
        item: nsPrefix + "group name",
        snippetString: "<" + nsPrefix + 'group name = "$1">\n	$0\n</' + nsPrefix + "group>",
        markdownString: "Defines a named model group to be reused later"
      },
      {
        item: nsPrefix + "group ref",
        snippetString: "<" + nsPrefix + 'group ref="$1"$0',
        markdownString: "Defines a reference to a group declaration"
      },
      {
        item: "dfdl:assert",
        snippetString: "<dfdl:assert $0",
        markdownString: "Used to assert truths about a DFDL model"
      },
      {
        item: "dfdl:discriminator",
        snippetString: "<dfdl:discriminator $0",
        markdownString: "Used during parsing to resolve points or uncertainity, remove ambiguity during speculative parsing, improve diagnostic behavior"
      },
      {
        item: "dfdl:format",
        snippetString: "<dfdl:format $0",
        markdownString: "Defines the physical data format properties for multiple DFDL schema constructs"
      },
      {
        item: nsPrefix + "annotation",
        snippetString: "<" + nsPrefix + "annotation>\n	$0\n</" + nsPrefix + "annotation>"
      },
      {
        item: nsPrefix + "appinfo",
        snippetString: "<" + nsPrefix + 'appinfo source="http://www.ogf.org/dfdl/">\n	$0\n</' + nsPrefix + "appinfo>"
      },
      {
        item: nsPrefix + "complexType",
        snippetString: "<" + nsPrefix + "complexType>\n	$0\n</" + nsPrefix + "complexType>",
        markdownString: "Defines a complex type definition"
      },
      {
        item: nsPrefix + "complexType name",
        snippetString: "<" + nsPrefix + 'complexType name="$1">\n	$0\n</' + nsPrefix + "complexType>",
        markdownString: "Defines a complex type definition"
      },
      {
        item: nsPrefix + "simpleType",
        snippetString: "<" + nsPrefix + "simpleType$1>\n	$0\n</" + nsPrefix + "simpleType>",
        markdownString: "Defines a simple type definition"
      },
      {
        item: nsPrefix + "simpleType name",
        snippetString: "<" + nsPrefix + 'simpleType name="$1"$0',
        markdownString: "Defines simple type definition"
      },
      {
        item: nsPrefix + "sequence",
        snippetString: "<" + nsPrefix + "sequence",
        markdownString: "Specifies that the child elements must appear in a sequence"
      },
      {
        item: nsPrefix + "choice",
        snippetString: "<" + nsPrefix + "choice",
        markdownString: "Define group of mutually exclusive elements that resolve points of uncertainty that cannot be resolved by speculative parsing"
      },
      {
        item: "dfdl:newVariableInstance",
        snippetString: '<dfdl:newVariableInstance ref="$1"$0',
        markdownString: "Defines the name, type, and optional default value for the variable"
      },
      {
        item: "dfdl:defineVariable",
        snippetString: '<dfdl:defineVariable "$1"$0',
        markdownString: "Defines the name, type, and optionally default value for the variable."
      },
      {
        item: "dfdl:defineVariable name",
        snippetString: '<dfdl:defineVariable name="$1"$0',
        markdownString: "Defines the name, type, and optionally default value for the variable."
      },
      {
        item: "dfdl:setVariable",
        snippetString: '<dfdl:setVariable ref="${1|' + definedVariables + '"|}, value="$2"$0',
        markdownString: "Sets the value of a variable whose declaration is in scope"
      },
      {
        item: "dfdl:defineFormat",
        snippetString: '<dfdl:defineFormat name="$1">\n	$2\n</dfdl:defineFormat>$0',
        markdownString: "Defines a named reusable format definition"
      },
      {
        item: "dfdl:defineEscapeScheme",
        snippetString: "<dfdl:defineEscapeScheme name=$1 >\n	$0</dfdl:defineEscapeScheme>",
        markdownString: "Defines a named, reusable escapeScheme"
      },
      {
        item: "dfdl:escapeScheme",
        snippetString: "<dfdl:escapeScheme $0",
        markdownString: "Allows a common set of properties to be defined that can be reused"
      },
      {
        item: "dfdl:simpleType",
        snippetString: "<dfdl:simpleType $1/>$0",
        markdownString: "Defines the physical data format properties of an xs:simpleType"
      },
      {
        item: "dfdl:element",
        snippetString: "<dfdl:element $1/>$0",
        markdownString: "Defines the physical data format properties of an xs:element"
      },
      {
        item: "dfdl:sequence",
        snippetString: "<dfdl:sequence $1/>$0",
        markdownString: "Defines the physical data format properties of an xs:sequence group"
      },
      {
        item: "dfdl:group",
        snippetString: "<dfdl:group $1/>$0",
        markdownString: "Defines the physical data format properties of an xs:group reference"
      },
      {
        item: "dfdl:choice",
        snippetString: "<dfdl:choice $1/>$0",
        markdownString: "Defines the physical data format properties of an xs:choice group"
      },
      {
        item: "dfdl:property",
        snippetString: '<dfdl:property name="$1">\n	$2\n</dfdl:property>$0',
        markdownString: "Used in the syntax of format annotations"
      },
      {
        item: "restriction",
        // use the "xs:" prefix for primitive types to differentiate them from custom simple types
        snippetString: "<" + nsPrefix + 'restriction base="${1|xs:string,xs:decimal,xs:float,xs:double,xs:integer,xs:nonNegativeInteger,xs:int,xs:unsignedInt,xs:short,xs:unsignedShort,xs:long,xs:unsignedLong,xs:byte,xs:unsignedByte,xs:hexBinary,xs:boolean|}"$0',
        markdownString: "Specify the base type the element is restricted to"
      },
      {
        item: "minInclusive",
        snippetString: "<" + nsPrefix + 'minInclusive value="$1"/>$0',
        markdownString: "Used to check the validity of an element"
      },
      {
        item: "minExclusive",
        snippetString: "<" + nsPrefix + 'minExclusive value="$1"/>$0',
        markdownString: "Used to check the validity of an element"
      },
      {
        item: "maxInclusive",
        snippetString: "<" + nsPrefix + 'maxInclusive value="$1"/>$0',
        markdownString: "Used to check the validity of an element"
      },
      {
        item: "maxExclusive",
        snippetString: "<" + nsPrefix + 'maxExclusive value="$1"/>$0',
        markdownString: "Used to check the validity of an element"
      },
      {
        item: "pattern",
        snippetString: "<" + nsPrefix + 'pattern value="$1"/>$0',
        markdownString: "Used to derive new simple types by specifying a regular expression against which values of the type are compared"
      },
      {
        item: "totalDigits",
        snippetString: "<" + nsPrefix + 'totalDigits value="$1"/>$0',
        markdownString: "Indicates the maximum allowed value for the number of digits"
      },
      {
        item: "fractionDigits",
        snippetString: "<" + nsPrefix + 'fractionDigits value="$1"/>$0',
        markdownString: "Indicates the maximum number of digits in the fractional part"
      },
      {
        item: "enumeration",
        snippetString: "<" + nsPrefix + 'enumeration value="$1"/>$0',
        markdownString: "Used to restrict a datatype to a finite set of values"
      },
      {
        item: nsPrefix + "include",
        snippetString: "<" + nsPrefix + 'include "$1"/>$0',
        markdownString: "Used to add all the components of an included schema"
      },
      {
        item: "documentation",
        snippetString: "<" + nsPrefix + "documentation>\n	$1\n</documentation>$0"
      },
      {
        item: nsPrefix + "import",
        snippetString: "<" + nsPrefix + 'import "$1"/>$0',
        markdownString: "Used to add all the components of an included schema"
      },
      {
        item: "<[CDATA[]]>",
        snippetString: "<[CDATA[$1]]>$0",
        markdownString: ""
      },
      {
        item: "<![CDATA[]]>",
        snippetString: "<![CDATA[$1]]>$0",
        markdownString: ""
      },
      {
        item: "{}",
        snippetString: "{$1}$0",
        markdownString: ""
      }
    ]
  };
};
function getElementCompletionProvider(dfdlFormatString) {
  return vscode__namespace.languages.registerCompletionItemProvider(
    "dfdl",
    {
      provideCompletionItems(document2, position, token, context) {
        const triggerChar = context.triggerCharacter;
        if (!checkBraceOpen(document2, position) && !cursorWithinBraces(document2, position) && !cursorWithinQuotes(document2, position) && !cursorAfterEquals(document2, position) && !isInXPath(document2, position) && !isTagEndTrigger(triggerChar)) {
          let nsPrefix = getNsPrefix(document2, position);
          let [triggerLine, triggerPos] = [position.line, position.character];
          let triggerText = document2.lineAt(triggerLine).text;
          let itemsOnLine = getItemsOnLineCount(triggerText);
          let nearestOpenItem = nearestOpen(document2, position);
          if (nearestOpenItem.itemNS != "none") {
            nsPrefix = nearestOpenItem.itemNS;
          }
          let lastCloseSymbol = triggerText.lastIndexOf(">");
          let firstOpenSymbol = triggerText.indexOf("<");
          let missingCloseTag = checkMissingCloseTag(
            document2,
            position,
            nsPrefix
          );
          if (!nearestOpenItem.itemName.includes("none") && missingCloseTag == "none") {
            return void 0;
          }
          if (missingCloseTag === "none" && itemsOnLine > 1 && (triggerPos === lastCloseSymbol + 1 || triggerPos === firstOpenSymbol)) {
            return void 0;
          }
          let definedVariables = getDefinedVariables(document2);
          let [tagNearestTrigger, tagPosition] = getTagNearestTrigger(
            document2,
            position,
            triggerText,
            triggerLine,
            triggerPos,
            itemsOnLine,
            nsPrefix
          );
          return nearestOpenTagChildElements(
            document2,
            position,
            tagNearestTrigger,
            tagPosition,
            definedVariables,
            nsPrefix
          );
        }
      }
    },
    "\n"
  );
}
function getElementCompletionItems(itemsToUse, preVal = "", definedVariables = "", nsPrefix) {
  let compItems = [];
  elementCompletion(definedVariables, nsPrefix).items.forEach((e) => {
    for (let i = 0; i < itemsToUse.length; ++i) {
      if (e.item.includes(itemsToUse[i])) {
        if (e.item.includes("dfdl:") && itemsToUse[i].includes("dfdl:") || !e.item.includes("dfdl")) {
          const completionItem = createCompletionItem(e, preVal);
          compItems.push(completionItem);
        }
      }
    }
  });
  return compItems;
}
function getDefinedVariables(document2) {
  let additionalTypes = "";
  let lineNum = 0;
  let itemCnt = 0;
  const lineCount2 = document2.lineCount;
  while (lineNum !== lineCount2) {
    const triggerText = document2.lineAt(lineNum).text.substring(0, document2.lineAt(lineNum).range.end.character);
    if (triggerText.includes("dfdl:defineVariable name=")) {
      let startPos = triggerText.indexOf('"', 0);
      let endPos = triggerText.indexOf('"', startPos + 1);
      let newType = triggerText.substring(startPos + 1, endPos);
      additionalTypes = itemCnt === 0 ? newType : String(additionalTypes + "," + newType);
      ++itemCnt;
    }
    ++lineNum;
  }
  return additionalTypes;
}
function nearestOpenTagChildElements(document2, position, tagNearestTrigger, tagPosition, definedVariables, nsPrefix) {
  switch (tagNearestTrigger) {
    case "element":
      return getElementCompletionItems(
        ["complexType", "simpleType", "annotation"],
        "",
        definedVariables,
        nsPrefix
      );
    case "sequence":
      return getElementCompletionItems(
        ["element", "sequence", "choice", "annotation"],
        "",
        "",
        nsPrefix
      );
    case "choice":
      return getElementCompletionItems(
        ["element", "sequence", "group", "annotation"],
        "",
        "",
        nsPrefix
      );
    case "group":
      return getElementCompletionItems(
        ["sequence", "annotation"],
        "",
        "",
        nsPrefix
      );
    case "complexType":
      return getElementCompletionItems(
        ["sequence", "group", "choice", "annotation"],
        "",
        "",
        nsPrefix
      );
    case "simpleType":
      return getElementCompletionItems(
        ["annotation", "restriction"],
        "",
        "",
        nsPrefix
      );
    case "annotation":
      return getElementCompletionItems(["appinfo"], "", "", nsPrefix);
    case "appinfo":
      let triggerText = document2.lineAt(tagPosition.line).text;
      let iCount = getItemsOnLineCount(triggerText);
      const newPosition = iCount < 2 ? new vscode__namespace.Position(tagPosition.line - 1, tagPosition.character) : tagPosition;
      let [pElement, pPosition] = getAnnotationParent(
        document2,
        newPosition,
        nsPrefix
      );
      let attributeNames = getAttributeNames(
        document2,
        pPosition,
        nsPrefix,
        pElement
      );
      switch (pElement) {
        case "schema":
          return getElementCompletionItems(
            [
              "dfdl:defineFormat",
              "dfdl:defineVariable",
              "dfdl:defineEscapeScheme",
              "dfdl:format"
            ],
            "",
            "",
            nsPrefix
          );
        case "element":
          return getElementCompletionItems(
            [
              "dfdl:assert",
              "dfdl:discriminator",
              "dfdl:element",
              "dfdl:property"
            ],
            "",
            "",
            nsPrefix
          );
        case "sequence":
          return getElementCompletionItems(
            [
              "dfdl:assert",
              "dfdl:discriminator",
              "dfdl:setVariable",
              "dfdl:newVariableInstance",
              "dfdl:sequence"
            ],
            "",
            "",
            nsPrefix
          );
        case "choice":
          return getElementCompletionItems(
            [
              "dfdl:assert",
              "dfdl:choice",
              "dfdl:discriminator",
              "dfdl:newVariableInstance",
              "dfdl:setVariable"
            ],
            "",
            "",
            nsPrefix
          );
        case "group":
          if (attributeNames.includes("ref")) {
            return getElementCompletionItems(
              [
                "dfdl:assert",
                "dfdl:group",
                "dfdl:discriminator",
                "dfdl:newVariableInstance",
                "dfdl:setVariable"
              ],
              "",
              "",
              nsPrefix
            );
          } else {
            return getElementCompletionItems(
              [
                "dfdl:assert",
                "dfdl:group",
                "dfdl:discriminator",
                "dfdl:setVariable"
              ],
              "",
              "",
              nsPrefix
            );
          }
        case "simpleType":
          return getElementCompletionItems(
            [
              "dfdl:assert",
              "dfdl:discriminator",
              "dfdl:setVariable",
              "dfdl:simpleType",
              "dfdl:property"
            ],
            "",
            "",
            nsPrefix
          );
        default:
          return void 0;
      }
    case "assert":
      return getElementCompletionItems(["CDATA", "{}"], "", "", nsPrefix);
    case "discriminator":
      return getElementCompletionItems(["CDATA", "{}"], "", "", nsPrefix);
    case "defineFormat":
      return getElementCompletionItems(["dfdl:format"], "", "", nsPrefix);
    case "defineEscapeScheme":
      return getElementCompletionItems(["dfdl:escapeScheme"], "", "", nsPrefix);
    case "format":
      return getElementCompletionItems(["dfdl:property"], "", "", nsPrefix);
    case "include":
      return getElementCompletionItems([""], "", "", nsPrefix);
    case "import":
      return getElementCompletionItems([""], "", "", nsPrefix);
    case "schema":
      return getElementCompletionItems(
        [
          "sequence",
          "element",
          "choice",
          "group",
          "complexType",
          "simpleType",
          "annotation",
          "include",
          "import",
          "defineVariable"
        ],
        "",
        "",
        nsPrefix
      );
    case "xml version":
      return getElementCompletionItems(["schema"], "", "", "");
    case "emptySchema":
      return getElementCompletionItems(["xml version"], "", "", "");
    default:
      return void 0;
  }
}
function getAnnotationParent(document2, tagPosition, nsPrefix) {
  let pElementText = document2.lineAt(tagPosition.line).text;
  let iCount = getItemsOnLineCount(pElementText);
  let pElement = "";
  let pPosition = tagPosition;
  let [nElement, newPosition] = getTagNearestTrigger(
    document2,
    tagPosition,
    pElementText,
    tagPosition.line,
    tagPosition.character,
    iCount,
    nsPrefix
  );
  pElement = nElement;
  if (pElement === "annotation") {
    if (iCount < 2) {
      newPosition = new vscode__namespace.Position(
        newPosition.line - 1,
        newPosition.character
      );
    }
    pElementText = document2.lineAt(newPosition.line).text;
    let [nElement2, nPosition] = getTagNearestTrigger(
      document2,
      newPosition,
      pElementText,
      newPosition.line,
      newPosition.character,
      iCount,
      nsPrefix
    );
    pElement = nElement2;
    pPosition = nPosition;
  }
  return [pElement, pPosition];
}
function getTagNearestTrigger(document2, position, triggerText, triggerLine, triggerPos, itemsOnLine, nsPrefix) {
  let [startLine, startPos] = [triggerLine, triggerPos];
  let tagNearestTrigger = "none";
  if (itemsOnLine === 0 && document2.lineCount === 1 && position.character === 0) {
    return ["emptySchema", position];
  }
  while (true) {
    let [foundTag, foundLine, foundPos] = nearestTag(
      document2,
      position,
      nsPrefix,
      startLine,
      startPos
    );
    if (itemsOnLine > 1) {
      const afterTriggerText = triggerText.substring(triggerPos);
      const afterTriggerPos = afterTriggerText.indexOf("<") + triggerPos;
      const beforeTriggerText = triggerText.substring(0, triggerPos);
      const lastOpenTagBeforeTriggerPos = beforeTriggerText.lastIndexOf("<");
      const beforeTriggerPos = beforeTriggerText.lastIndexOf(">");
      const beforeTriggerTag = beforeTriggerText.substring(
        lastOpenTagBeforeTriggerPos
      );
      if (triggerPos === afterTriggerPos && triggerPos === beforeTriggerPos + 1 && !beforeTriggerTag.startsWith("</")) {
        tagNearestTrigger = foundTag;
        return [tagNearestTrigger, new vscode__namespace.Position(foundLine, foundPos)];
      }
    }
    startLine = foundLine;
    let [endTag, endTagLine, endTagPos] = getCloseTag(
      document2,
      position,
      nsPrefix,
      foundTag,
      foundLine,
      foundPos
    );
    if (itemsOnLine > 1 && foundLine === triggerLine) {
      if (foundTag === endTag && endTagPos >= triggerPos) {
        tagNearestTrigger = foundTag;
        return [tagNearestTrigger, new vscode__namespace.Position(foundLine, foundPos)];
      }
      if (endTag === "none") {
        startLine = foundLine - 1;
      } else {
        startPos = foundPos - 1;
      }
    }
    if (itemsOnLine < 2) {
      if (foundTag === endTag && endTagLine >= triggerLine || endTag === "xml version") {
        tagNearestTrigger = foundTag;
        return [tagNearestTrigger, new vscode__namespace.Position(foundLine, foundPos)];
      }
      startLine = foundLine - 1;
    }
  }
}
const attributeCompletion = (additionalItems, nsPrefix, dfdlPrefix, spacingChar, afterChar) => {
  return {
    // Array of completion item objects, each representing a DFDL/XSD attribute with its snippet and documentation
    items: [
      // === XSD Core Attributes ===
      // These are fundamental XML Schema attributes used for element definition and reference
      {
        item: "name",
        snippetString: spacingChar + 'name="$1"$0' + afterChar,
        markdownString: "specifies the name of this item"
      },
      {
        item: "ref",
        snippetString: spacingChar + 'ref="$1"$0' + afterChar,
        markdownString: "Refers to the name of a defined item"
      },
      {
        item: "default",
        snippetString: spacingChar + 'default="$1"$0' + afterChar,
        markdownString: "Value automatically assigned to an element in this schema"
      },
      {
        item: "fixed",
        snippetString: spacingChar + 'fixed="$1"$0' + afterChar,
        markdownString: "Specifies the exact value of an element in this schema"
      },
      {
        item: "minOccurs",
        snippetString: spacingChar + 'minOccurs="${1|0,1|}"$0' + afterChar,
        markdownString: "Minimum number of times element will occur"
      },
      {
        item: "maxOccurs",
        snippetString: spacingChar + 'maxOccurs="${1|0,1,unbounded|}"$0' + afterChar,
        markdownString: "Maximum number of times element will occur"
      },
      {
        item: "nillable",
        snippetString: spacingChar + 'nillable="${true|false|}"$0' + afterChar,
        markdownString: "Allows for the concept of an element having no value"
      },
      // === DFDL Occurrence Control Properties ===
      // These properties control how many times an element occurs in the data stream
      {
        item: "type",
        snippetString: spacingChar + 'type="${1|xs:string,xs:decimal,xs:float,xs:double,xs:integer,xs:nonNegativeInteger,xs:int,xs:unsignedInt,xs:short,xs:unsignedShort,xs:long,xs:unsignedLong,xs:byte,xs:unsignedByte,xs:hexBinary,xs:boolean' + additionalItems + '|}"$0' + afterChar,
        markdownString: "The name of a built in data type, or the name of a simpleType or complexType element defined in this schema"
      },
      {
        item: "base",
        snippetString: spacingChar + 'type="${1|xs:string,xs:decimal,xs:float,xs:double,xs:integer,xs:nonNegativeInteger,xs:int,xs:unsignedInt,xs:short,xs:unsignedShort,xs:long,xs:unsignedLong,xs:byte,xs:unsignedByte,xs:hexBinary,xs:boolean' + additionalItems + '|}"$0' + afterChar,
        markdownString: "The name of a built in data type, or the name of a simpleType or complexType element defined in this schema"
      },
      {
        item: "dfdl:occursCount",
        snippetString: spacingChar + dfdlPrefix + 'occursCount="$1"$0' + afterChar,
        markdownString: "dfdl:occursCount property takes an expression which commonly looks in the Infoset via an expression, to obtain the count from another element."
      },
      {
        item: "dfdl:occursCountKind",
        snippetString: spacingChar + dfdlPrefix + 'occursCountKind="${1|expression,fixed,implicit,parsed,stopValue|}"$0' + afterChar,
        markdownString: "Specifies how the actual number of occurrences is to be established"
      },
      {
        item: "dfdl:occursStopValue",
        snippetString: spacingChar + dfdlPrefix + 'occursStopValue="$1"$0' + afterChar,
        markdownString: "A whitespace separated list of logical values that specify the alternative logical stop values for the element"
      },
      // === DFDL Byte and Bit Order Properties ===
      // Control the ordering of bytes and bits in binary data
      {
        item: "dfdl:byteOrder",
        snippetString: spacingChar + dfdlPrefix + 'byteOrder="${1|bigEndian,littleEndian|}"$0' + afterChar,
        markdownString: "This property applies to all Number, Calendar (date and time), and Boolean types with representation binary"
      },
      {
        item: "dfdl:bitOrder",
        snippetString: spacingChar + dfdlPrefix + 'bitOrder="${1|mostSignificantBitFirst,leastSignificantBitFirst|}"$0' + afterChar,
        markdownString: "Determines the specific bits of any grammar region"
      },
      // === DFDL Length Properties ===
      // Define how the length of an element is determined and represented
      {
        item: "dfdl:length",
        snippetString: spacingChar + dfdlPrefix + 'length="$1"$0',
        markdownString: "length can be an expression that resolves to an unsigned integer, or a literal unsigned integer" + afterChar
      },
      {
        item: "dfdl:lengthKind",
        snippetString: spacingChar + dfdlPrefix + 'lengthKind="${1|delimited,fixed,explicit,implicit,prefixed,pattern,endOfParent|}"$0' + afterChar,
        markdownString: "lengthKind can be delimited, fixed, explicit, implicit, prefixed,pattern, or endOfParent"
      },
      {
        item: "dfdl:prefixIncludesPrefixLength",
        snippetString: spacingChar + dfdlPrefix + 'prefixIncludesPrefixLength="${1|yes,no|}"$0' + afterChar,
        markdownString: "Specifies whether the length given by a prefix includes the length of the prefix as well as the length of the content region"
      },
      {
        item: "dfdl:prefixLengthType",
        snippetString: spacingChar + dfdlPrefix + 'prefixLengthType="$1"$0' + afterChar,
        markdownString: "Name of a simple type derived from xs:integer or any subtype of it."
      },
      // === DFDL Encoding Properties ===
      // Control character encoding and text handling
      {
        item: "dfdl:utf16Width",
        snippetString: spacingChar + dfdlPrefix + 'utf16Width="${1|fixed,variable|}"$0' + afterChar,
        markdownString: "Specifies whether the encoding UTF-16 is treated as a fixed or variable width encoding"
      },
      {
        item: "dfdl:encoding",
        snippetString: spacingChar + dfdlPrefix + 'encoding="${1|US-ASCII,ASCII,UTF-8,UTF-16,UTF-16BE,UTF-16LE,ISO-8859-1|}"$0' + afterChar,
        markdownString: "This property can be computed by way of an expression which returns an appropriate string value"
      },
      {
        item: "dfdl:encodingErrorPolicy",
        snippetString: spacingChar + dfdlPrefix + 'encodingErrorPolicy="${1|error,replace|}"$0' + afterChar,
        markdownString: "This property provides control of how decoding and encoding errors are handled when converting the data to text, or text to data"
      },
      // === DFDL Nil/Null Value Properties ===
      // Handle nil (null) values in data streams
      {
        item: "dfdl:nilKind",
        snippetString: spacingChar + dfdlPrefix + 'nilKind="${1|literalCharacter,literalValue,logicalValue|}"$0' + afterChar,
        markdownString: "Specifies how dfdl:<nilValue> is interpreted to represent the nil value in the data stream"
      },
      {
        item: "dfdl:nilValue",
        snippetString: spacingChar + dfdlPrefix + 'nilValue="$1"$0' + afterChar,
        markdownString: "Used to provide a logical value that is used to indicate the data is nilled"
      },
      {
        item: "dfdl:nilValueDelimiterPolicy",
        snippetString: spacingChar + dfdlPrefix + 'nilValueDelimiterPolicy="${1|initiator,terminator,both,none|}"$0' + afterChar,
        markdownString: "Controls whether matching one of the nil values also involves matching the initiator or terminator specified by the element"
      },
      {
        item: "dfdl:useNilForDefault",
        snippetString: spacingChar + dfdlPrefix + 'useNilForDefault="${1|yes,no|}"$0' + afterChar,
        markdownString: "Controls whether to set the Infoset item [nilled] boolean member, or to use the XSD default or fixed properties to obtain a data value"
      },
      // === DFDL Alignment and Positioning Properties ===
      // Control byte/bit alignment and skip regions
      {
        item: "dfdl:alignment",
        snippetString: spacingChar + dfdlPrefix + 'alignment="${1|1,2,implicit|}"$0' + afterChar,
        markdownString: "Alignment required for the beginning of the item.\nCan be non-negative integer or 'implicit'."
      },
      {
        item: "dfdl:lengthUnits",
        snippetString: spacingChar + dfdlPrefix + 'lengthUnits="${1|bits,bytes,characters|}"$0' + afterChar,
        markdownString: "lengthUnits can be specified as bits, bytes, or characters"
      },
      {
        item: "dfdl:lengthPattern",
        snippetString: spacingChar + dfdlPrefix + 'lengthPattern="$1"$0' + afterChar,
        markdownString: "lengthPattern takes a regular expression which is used to scan the data stream for matching data"
      },
      {
        item: "dfdl:inputValueCalc",
        snippetString: spacingChar + dfdlPrefix + 'inputValueCalc="{$1}"$0' + afterChar,
        markdownString: "An expression that calculates the value of the element when parsing"
      },
      {
        item: "dfdl:outputValueCalc",
        snippetString: spacingChar + dfdlPrefix + 'outputValueCalc="{$1}"$0' + afterChar,
        markdownString: "An expression that calculates the value of the current element when unparsing"
      },
      {
        item: "dfdl:alignmentUnits",
        snippetString: spacingChar + dfdlPrefix + 'alignmentUnits="${1|bits,bytes|}"$0' + afterChar,
        markdownString: "Scales the alignment.\nCan only be used when alignment is bits or bytes.\nValid values are 'bits or 'bytes'."
      },
      {
        item: "dfdl:leadingSkip",
        snippetString: spacingChar + dfdlPrefix + 'leadingSkip="0$1"$0' + afterChar,
        markdownString: "A non-negative number of bytes or bits to skip before alignment is applied"
      },
      {
        item: "dfdl:trailingSkip",
        snippetString: spacingChar + dfdlPrefix + 'trailingSkip="0$1"$0' + afterChar,
        markdownString: "A non-negative number of bytes or bits to skip after the element,"
      },
      // === DFDL Output Control Properties ===
      // Control unparsing behavior and output formatting
      {
        item: "dfdl:outputNewLine",
        snippetString: spacingChar + dfdlPrefix + 'outputNewLine="${1|%CR;,%LF;,%CR;%LF;,%NEL;,%LS;|}"$0' + afterChar,
        markdownString: "Specifies the character or characters that are used to replace the %NL; character class entity during unparse"
      },
      // === DFDL Choice and Branching Properties ===
      // Control xs:choice element behavior and direct/dispatch choices
      {
        item: "dfdl:choiceBranchKey",
        snippetString: spacingChar + dfdlPrefix + 'choiceBranchKey="$1"$0' + afterChar,
        markdownString: "List of DFDL String Literals"
      },
      {
        item: "dfdl:choiceDispatchKey",
        snippetString: spacingChar + dfdlPrefix + 'choiceDispatchKey="$1"$0' + afterChar,
        markdownString: "The expression must evaluate to a string, the string must match one of the dfdl:choiceBranchKey property values of one of the branches of the choice"
      },
      {
        item: "dfdl:choiceLengthKind",
        snippetString: spacingChar + dfdlPrefix + 'choiceLengthKind="${1|explicit,implicit|}"$0' + afterChar,
        markdownString: "Determines whether the branches of the choice are always filled (explicit) to the fixed-length specified by dfdl:choiceLength or not filled (implicit)"
      },
      {
        item: "dfdl:choiceLength",
        snippetString: spacingChar + dfdlPrefix + 'choiceLength="$1"$0' + afterChar,
        markdownString: "Specifies the length of the choice in bytes, only used when dfdl:choiceLengthKind is explicit"
      },
      // === DFDL Representation Properties ===
      // Control whether data is represented as text or binary
      {
        item: "dfdl:representation",
        snippetString: spacingChar + dfdlPrefix + 'representation="${1|binary,text|}"$0' + afterChar,
        markdownString: "Identifies the physical representation of the element as text or binary"
      },
      // === DFDL Text String Properties ===
      // Properties specific to text representation of string data
      {
        item: "dfdl:textStringJustification",
        snippetString: spacingChar + dfdlPrefix + 'textStringJustification="${1|left,right,center|}"$0' + afterChar,
        markdownString: "Specifies the string justification"
      },
      {
        item: "dfdl:textStringPadCharacter",
        snippetString: spacingChar + dfdlPrefix + 'textStringPadCharacter="$1"$0' + afterChar,
        markdownString: "Specifies the string justification"
      },
      {
        item: "dfdl:truncateSpecifiedLengthString",
        snippetString: spacingChar + dfdlPrefix + 'truncateSpecifiedLengthString="${1|no,yes|}"$0' + afterChar,
        markdownString: "This property provides the means to express an error, or the strings can be truncated to fit when the strings in an Infoset being unparsed do not fit within those specified lengths"
      },
      // === DFDL Text Number Properties ===
      // Properties for parsing and unparsing numeric data in text representation
      {
        item: "dfdl:textStandardZeroRep",
        snippetString: spacingChar + dfdlPrefix + 'textStandardZeroRep="0"$0' + afterChar,
        markdownString: "Specifies the whitespace separated list of alternative DFDL String Literals that are equivalent to zero "
      },
      {
        item: "dfdl:textStandardInfinityRep",
        snippetString: spacingChar + dfdlPrefix + 'textStandardInfinityRep="Inf"$0' + afterChar,
        markdownString: "The value used to represent infinity."
      },
      {
        item: "dfdl:textStandardExponentRep",
        snippetString: spacingChar + dfdlPrefix + 'textStandardExponentRep="E"$0' + afterChar,
        markdownString: "Defines the actual character(s) that appear in the data as the exponent indicator"
      },
      {
        item: "dfdl:textStandardNaNRep",
        snippetString: spacingChar + dfdlPrefix + 'textStandardNaNRep="NaN"$0' + afterChar,
        markdownString: "Specifies the value used to represent NaN "
      },
      {
        item: "dfdl:textNumberPattern",
        snippetString: spacingChar + dfdlPrefix + 'textNumberPattern="#,##0.###;-#,##0.###"$0' + afterChar,
        markdownString: "Indicates whether an xs:decimal element is signed"
      },
      {
        item: "dfdl:decimalSigned",
        snippetString: spacingChar + dfdlPrefix + 'decimalSigned="${1|yes,no|}"$0' + afterChar,
        markdownString: "Represented as standard characters in the character set encoding or represented as a zoned decimal in the character set encoding"
      },
      {
        item: "dfdl:textNumberRep",
        snippetString: spacingChar + dfdlPrefix + 'textNumberRep="${1|standard,zoned|}"$0' + afterChar,
        markdownString: "Represented as standard characters in the character set encoding or represented as a zoned decimal in the character set encoding"
      },
      {
        item: "dfdl:textNumberJustification",
        snippetString: spacingChar + dfdlPrefix + 'textNumberJustification=${1|left,right,center|}"$0' + afterChar,
        markdownString: "Controls how the data is padded or trimmed on parsing and unparsing"
      },
      {
        item: "dfdl:textNumberPadCharacter",
        snippetString: spacingChar + dfdlPrefix + 'textNumberPadCharacter="$1"$0' + afterChar,
        markdownString: "The value that is used when padding or trimming number elements"
      },
      {
        item: "dfdl:textNumberRoundingMode",
        snippetString: spacingChar + dfdlPrefix + 'textNumberRoundingMode="${1|roundCeiling,roundFloor,roundDown,roundUp,roundHalfEven,roundHalfDown,roundHalfUp,roundUnnecessary|}"$0' + afterChar,
        markdownString: "Specifies how rounding occurs during unparsing"
      },
      {
        item: "dfdl:textNumberRoundingIncrement",
        snippetString: spacingChar + dfdlPrefix + 'textNumberRoundingIncrement="0"$0' + afterChar,
        markdownString: "Specifies the rounding increment to use during unparsing"
      },
      {
        item: "dfdl:textNumberRounding",
        snippetString: spacingChar + dfdlPrefix + 'textNumberRounding="${1|explicit,pattern|}"$0' + afterChar,
        markdownString: "Specifies how rounding is controlled during unparsing"
      },
      {
        item: "dfdl:textNumberCheckPolicy",
        snippetString: spacingChar + dfdlPrefix + 'textNumberCheckPolicy="${1|lax,strict|}"$0' + afterChar,
        markdownString: "Indicates how lenient to be when parsing against the dfdl:textNumberPattern"
      },
      {
        item: "dfdl:textOutputMinLength",
        snippetString: spacingChar + dfdlPrefix + 'textOutputMinLength="0"$0' + afterChar,
        markdownString: "Specifies the minimum content length during unparsing for simple types that do not allow the XSD minLength facet to be specified"
      },
      {
        item: "dfdl:textStandardDecimalSeparator",
        snippetString: spacingChar + 'dfdl:textStandardDecimalSeparator=","$0' + afterChar,
        markdownString: "Defines a whitespace separated list of single characters that appear (individually) in the data as the decimal separator"
      },
      {
        item: "dfdl:textStandardGroupingSeparator",
        snippetString: spacingChar + 'dfdl:textStandardGroupingSeparator=","$0' + afterChar,
        markdownString: "Specifies the single character that can appear in the data as the grouping separator"
      },
      {
        item: "dfdl:textPadKind",
        snippetString: spacingChar + dfdlPrefix + 'textPadKind="${1|none,padChar|}"$0' + afterChar,
        markdownString: "Indicates whether to pad the data value on unparsing"
      },
      {
        item: "dfdl:textStandardBase",
        snippetString: spacingChar + dfdlPrefix + 'textStandardBase="${1|2,8,10,16|}"$0' + afterChar,
        markdownString: "Indicates the number base"
      },
      {
        item: "dfdl:textZonedSignStyle",
        snippetString: spacingChar + dfdlPrefix + 'textZonedSignStyle="$1"$0' + afterChar,
        markdownString: "Specifies the code points that are used to modify the sign nibble of the byte containing the sign"
      },
      {
        item: "dfdl:textTrimKind",
        snippetString: spacingChar + dfdlPrefix + 'textTrimKind="${1|none,padChar|}"$0' + afterChar,
        markdownString: "Indicates whether to trim data on parsing"
      },
      // === DFDL Text Boolean Properties ===
      // Properties for text representation of boolean values
      {
        item: "dfdl:textBooleanTrueRep",
        snippetString: spacingChar + dfdlPrefix + 'textBooleanTrueRep="$1"$0' + afterChar,
        markdownString: "A whitespace separated list of representations to be used for true"
      },
      {
        item: "dfdl:textBooleanFalseRep",
        snippetString: spacingChar + dfdlPrefix + 'textBooleanFalseRep="$1"$0' + afterChar,
        markdownString: "A whitespace separated list of representations to be used for false"
      },
      {
        item: "dfdl:textBooleanJustification",
        snippetString: spacingChar + dfdlPrefix + 'textBooleanJustification="${1|left,right,center|}"$0' + afterChar,
        markdownString: "Controls how the data is padded or trimmed on parsing and unparsing"
      },
      {
        item: "dfdl:textBooleanPadCharacter",
        snippetString: spacingChar + dfdlPrefix + 'textBooleanPadCharacter="$1"$0' + afterChar,
        markdownString: "The value that is used when padding or trimming boolean elements"
      },
      // === DFDL Sequence Properties ===
      // Properties for xs:sequence groups controlling ordering and separators
      {
        item: "dfdl:sequenceKind",
        snippetString: spacingChar + dfdlPrefix + 'SequenceKind ="${1|ordered,unordered|}"$0' + afterChar,
        markdownString: "Defines whether the items are expected in the same order that they appear in the schema or in any order"
      },
      {
        item: "dfdl:separator",
        snippetString: spacingChar + dfdlPrefix + 'separator="$1"$0' + afterChar,
        markdownString: "Specifies a whitespace separated list of alternative DFDL String Literals that are the possible separators for the sequence"
      },
      {
        item: "dfdl:separatorPosition",
        snippetString: spacingChar + dfdlPrefix + 'separatorPosition="${1|infix,postfix,prefix|}"$0' + afterChar,
        markdownString: "specifies where the separator occurs between the elements"
      },
      {
        item: "dfdl:separatorSuppressionPolicy",
        snippetString: spacingChar + dfdlPrefix + 'separatorSuppressionPolicy="${1|anyEmpty,never,trailingEmpty,trailingEmptyStrict|}"$0' + afterChar,
        markdownString: "Controls the circumstances when separators are expected in the data when parsing, or generated when unparsing"
      },
      // === DFDL Delimiter Properties ===
      // Properties for initiators and terminators marking element boundaries
      {
        item: "dfdl:terminator",
        snippetString: spacingChar + dfdlPrefix + 'terminator="$1"$0' + afterChar,
        markdownString: "charater or bytes found in the input stream that designate termination of an element"
      },
      {
        item: "dfdl:initiator",
        snippetString: spacingChar + dfdlPrefix + 'initiator="$1"$0' + afterChar,
        markdownString: "Specifies an ordered whitespace separated list of alternative DFDL String Literals one of which marks the beginning of the element or group of elements "
      },
      {
        item: "dfdl:initiatedContent",
        snippetString: spacingChar + dfdlPrefix + 'initiatedContent="${1|yes,no|}"$0' + afterChar,
        markdownString: "yes indicates all branches of a choice are initiated\nno indicates the branch dfdl:initator property may be ste to empty string"
      },
      {
        item: "dfdl:documentFinalTerminatorCanBeMissing" + afterChar,
        snippetString: spacingChar + dfdlPrefix + 'documentFinalTerminatorCanBeMissing="${1|yes,no|}"$0',
        markdownString: "Specifies whether the final line can be missing"
      },
      // === DFDL Empty Element Properties ===
      // Control behavior when elements have no content
      {
        item: "dfdl:emptyValueDelimiterPolicy",
        snippetString: spacingChar + dfdlPrefix + 'emptyValueDelimiterPolicy="${1|initiator,terminator,both,none|}"$0' + afterChar,
        markdownString: "Indicates which of initiator, terminator, both, or neither must be present when an element in the data stream is empty."
      },
      {
        item: "dfdl:emptyElementParsePolicy",
        snippetString: spacingChar + dfdlPrefix + 'emptyElementParsePolicy="${1|treatAsAbsent,treatAsEmpty|}"$0' + afterChar,
        markdownString: "Indicates which of initiator, terminator, both, or neither must be present when an element in the data stream is empty."
      },
      // === DFDL Miscellaneous Properties ===
      // Additional properties for special features
      {
        item: "dfdl:textBidi",
        snippetString: spacingChar + dfdlPrefix + 'textBidi="${1|no,yes|}"$0' + afterChar,
        markdownString: "This property exists in anticipation of future DFDL features that enable bidirectional text processing"
      },
      {
        item: "dfdl:hiddenGroupRef",
        snippetString: spacingChar + 'dfdl:hiddenGroupRef="$1"$0' + afterChar,
        markdownString: "Reference to a global model group definition"
      },
      {
        item: "dfdl:fillByte",
        snippetString: spacingChar + dfdlPrefix + 'fillByte="$1"$0' + afterChar,
        markdownString: "A single byte specified as a DFDL byte value entity or a single character, used on unparsing to fill empty space"
      },
      {
        item: "dfdl:ignoreCase",
        snippetString: spacingChar + dfdlPrefix + 'ignoreCase="${1|no,yes|}"$0' + afterChar,
        markdownString: "Whether mixed case data is accepted when matching delimiters and data values on input"
      },
      // === DFDL Binary Number Properties ===
      // Properties for binary representation of numeric values
      {
        item: "dfdl:binaryNumberRep",
        snippetString: spacingChar + dfdlPrefix + 'binaryNumberRep="${1|binary,packed,bcd,ibm4690Packed|}"$0' + afterChar,
        markdownString: "binary,packed,bcd, or ibm4690Packed"
      },
      {
        item: "dfdl:floating",
        snippetString: spacingChar + dfdlPrefix + 'floating="${1|no,yes|}"$0' + afterChar,
        markdownString: "yes or no"
      },
      {
        item: "dfdl:binaryFloatRep",
        snippetString: spacingChar + dfdlPrefix + 'binaryFloatRep="${1|ieee,ibm390Hex|}"$0' + afterChar,
        markdownString: "ieee or ibm390Hex"
      },
      {
        item: "dfdl:binaryDecimalVirtualPoint",
        snippetString: spacingChar + dfdlPrefix + 'binaryDecimalVirtualPoint="$1"$0' + afterChar,
        markdownString: "An integer that represents the position of an implied decimal point within a number"
      },
      {
        item: "dfdl:binaryPackedSignCodes",
        snippetString: spacingChar + dfdlPrefix + 'binaryPackedSignCodes="$1"$0' + afterChar,
        markdownString: "A whitespace separated string giving the hex sign nibbles to use for a positive value, a negative value, an unsigned value, and zero"
      },
      {
        item: "dfdl:binaryNumberCheckPolicy",
        snippetString: spacingChar + dfdlPrefix + 'binaryNumberCheckPolicy="${1|strict,lax|}"$0' + afterChar,
        markdownString: "Indicates how lenient to be when parsing binary numbers"
      },
      // === DFDL Binary Boolean Properties ===
      // Properties for binary representation of boolean values
      {
        item: "dfdl:binaryBooleanTrueRep",
        snippetString: spacingChar + dfdlPrefix + 'binaryBooleanTrueRep="$1"$0' + afterChar,
        markdownString: "A binary xs:unsignedInt gives the representation for true"
      },
      {
        item: "dfdl:binaryBooleanFalseRep",
        snippetString: spacingChar + dfdlPrefix + 'binaryBooleanFalseRep="$1"$0' + afterChar,
        markdownString: "A binary xs:unsignedInt gives the representation for false"
      },
      // === DFDL Calendar/Date-Time Properties ===
      // Properties for parsing and unparsing date/time data
      {
        item: "dfdl:calendarPattern",
        snippetString: spacingChar + dfdlPrefix + 'calendarPattern="$1"$0' + afterChar,
        markdownString: "Defines the ICU pattern that describes the format of the calendar. The pattern defines where the year, month, day, hour, minute, second, fractional second and time zone components appear"
      },
      {
        item: "dfdl:calendarPatternKind",
        snippetString: spacingChar + dfdlPrefix + 'calendarPatternKind="${1|explicit,implicit|}"$0' + afterChar,
        markdownString: "The pattern is given by dfdl:calendarPattern explicit or the pattern is derived from the XML schema date/time type (implicit)"
      },
      {
        item: "dfdl:calendarCheckPolicy",
        snippetString: spacingChar + dfdlPrefix + 'calendarCheckPolicy="${1|strict,lax|}"$0' + afterChar,
        markdownString: "Indicates how lenient to be when parsing against the pattern"
      },
      {
        item: "dfdl:calendarTimeZone",
        snippetString: spacingChar + dfdlPrefix + 'calendarTimeZone="$1"$0' + afterChar,
        markdownString: "Provides the time zone that is assumed if no time zone explicitly occurs in the data"
      },
      {
        item: "dfdl:calendarObserveDST",
        snippetString: spacingChar + dfdlPrefix + 'calendarObserveDST="${1|yes,no|}"$0' + afterChar,
        markdownString: "Whether the time zone given in dfdl:calendarTimeZone observes daylight savings time"
      },
      {
        item: "dfdl:calendarFirstDayOfWeek",
        snippetString: spacingChar + dfdlPrefix + 'calendarFirstDayOfWeek="${1|Monday,Sunday|}"$0' + afterChar,
        markdownString: "The day of the week upon which a new week is considered to start"
      },
      {
        item: "dfdl:calendarDaysInFirstWeek",
        snippetString: spacingChar + dfdlPrefix + 'calendarDaysInFirstWeek="${1|1,2,3,4,5,6,7|}"$0' + afterChar,
        markdownString: "Specify the number of days of the new year that must fall within the first week"
      },
      {
        item: "dfdl:calendarCenturyStart",
        snippetString: spacingChar + dfdlPrefix + 'calendarCenturyStart="$1"$0' + afterChar,
        markdownString: "specifies the two digits that start a 100-year window that contains the current year"
      },
      {
        item: "dfdl:calendarLanguage",
        snippetString: spacingChar + dfdlPrefix + 'calendarLanguage="$1"$0' + afterChar,
        markdownString: "The language that is used when the pattern produces a presentation in text"
      },
      {
        item: "dfdl:textCalendarJustification",
        snippetString: spacingChar + dfdlPrefix + 'textCalendarJustification="${1|left,right,center|}"$0' + afterChar,
        markdownString: "Controls how the data is padded or trimmed on parsing and unparsing"
      },
      {
        item: "dfdl:textCalendarPadCharacter",
        snippetString: spacingChar + dfdlPrefix + 'textCalendarPadCharacter="$1"$0' + afterChar,
        markdownString: "The value that is used when padding or trimming calendar elements. The value can be a single character or a single byte"
      },
      {
        item: "dfdl:binaryCalendarRep",
        snippetString: spacingChar + dfdlPrefix + 'binaryCalendarRep="${1|packed,bcd,ibm4690Packed,binarySeconds,binaryMilliseconds|}"$0' + afterChar,
        markdownString: "Valid values are packed, bcd, ibm4690Packed, binarySeconds, binaryMilliseconds"
      },
      {
        item: "dfdl:binaryCalendarEpoch",
        snippetString: spacingChar + dfdlPrefix + 'binaryCalendarEpoch="$1"$0' + afterChar,
        markdownString: "The epoch from which to calculate dates and times. Used when dfdl:binaryCalendarRep is binarySeconds or binaryMilliseconds"
      },
      // === DFDL Escape Scheme Properties ===
      // Properties for defining and using escape mechanisms
      {
        item: "dfdl:escapeSchemeRef",
        snippetString: spacingChar + dfdlPrefix + 'escapeSchemeRef="$1"$0' + afterChar,
        markdownString: "Refers to a named escape scheme definition via its qualified name"
      },
      {
        item: "dfdl:escapeKind",
        snippetString: spacingChar + dfdlPrefix + 'escapeKind="${1|escapeCharacter,escapeBlock|}"$0' + afterChar,
        markdownString: "The type of escape mechanism defined in the escape scheme"
      },
      {
        item: "dfdl:escapeCharacter",
        snippetString: spacingChar + dfdlPrefix + 'escapeCharacter="$1"$0' + afterChar,
        markdownString: "Specifies one character that escapes the subsequent character"
      },
      {
        item: "dfdl:escapeBlockStart",
        snippetString: dfdlPrefix + 'escapeBlockStart="$1"$0',
        markdownString: "The string of characters that denotes the beginning of a sequence of characters escaped by a pair of escape strings" + afterChar
      },
      {
        item: "dfdl:escapeBlockEnd",
        snippetString: spacingChar + dfdlPrefix + 'escapeBlockEnd="$1"$0',
        markdownString: "The string of characters that denotes the end of a sequence of characters escaped by a pair of escape strings" + afterChar
      },
      {
        item: "dfdl:escapeEscapeCharacter",
        snippetString: spacingChar + dfdlPrefix + 'escapeEscapeCharacter="$1"$0',
        markdownString: "Specifies one character that escapes an immediately following dfdl:escapeCharacter" + afterChar
      },
      {
        item: "dfdl:extraEscapedCharacters",
        snippetString: spacingChar + dfdlPrefix + 'extraEscapedCharacters="$1"$0',
        markdownString: "A whitespace separated list of single characters that must be escaped in addition to the in-scope delimiters" + afterChar
      },
      {
        item: "dfdl:generateEscapeBlock",
        snippetString: spacingChar + dfdlPrefix + 'generateEscapeBlock="${1|always,whenNeeded|}"$0' + afterChar,
        markdownString: "The type of escape mechanism defined in the escape scheme"
      },
      {
        item: "dfdl:escapeCharacterPolicy",
        snippetString: spacingChar + dfdlPrefix + 'escapeCharacterPolicy="${1|all,delimiters|}"$0' + afterChar,
        markdownString: "The type of escape mechanism defined in the escape scheme"
      },
      // === DFDL Assert and Discriminator Properties ===
      // Properties for assertions and discriminators used in validation and disambiguation
      {
        item: "testKind",
        snippetString: spacingChar + 'testKind="${1|expression,pattern|}"$0' + afterChar,
        markdownString: "Specifies whether a DFDL expression or DFDL regular expression pattern is used in the dfdl:assert"
      },
      {
        item: "test",
        snippetString: spacingChar + dfdlPrefix + 'test="{$1}"$0' + afterChar,
        markdownString: "A DFDL expression that evaluates to true or false."
      },
      {
        item: "testPattern",
        snippetString: spacingChar + 'testPattern="$1"$0' + afterChar,
        markdownString: "A DFDL regular expression that is applied against the data stream"
      },
      {
        item: "message",
        snippetString: spacingChar + 'message="$1"$0' + afterChar,
        markdownString: "Defines text for use in an error message"
      },
      {
        item: "failureType",
        snippetString: spacingChar + 'failureType="${1|processingError,recoverableError|}"$0' + afterChar,
        markdownString: "Specifies the type of failure that occurs when the dfdl:assert is unsuccessful"
      },
      // === XSD Schema Organization Attributes ===
      // Attributes for schema imports and includes
      {
        item: "schemaLocation",
        snippetString: spacingChar + 'schemaLocation="$1"$0' + afterChar,
        markdownString: "Specifies the location of the schema"
      },
      {
        item: "namespace",
        snippetString: spacingChar + 'namespace="$1"$0' + afterChar,
        markdownString: "User defined identifier for the imported schemaLocation"
      }
    ]
  };
};
function getCompletionItems(itemsToUse, preVal = "", additionalItems = "", nsPrefix, dfdlPrefix, spacingChar, afterChar) {
  let compItems = [];
  attributeCompletion(
    additionalItems,
    nsPrefix,
    dfdlPrefix,
    spacingChar,
    afterChar
  ).items.forEach((e) => {
    if (itemsToUse.includes(e.item)) {
      const completionItem = createCompletionItem(e, preVal);
      compItems.push(completionItem);
    }
  });
  return compItems;
}
function getPotentialAttributeText(position, document2) {
  let lowerLineBound = position.line;
  let upperLineBound = position.line;
  if (lowerLineBound > 0) {
    lowerLineBound--;
  }
  while (lowerLineBound > 0 && // Make sure we aren't going to negative line indexes
  document2.lineAt(lowerLineBound).text.indexOf("<") == -1) {
    lowerLineBound--;
  }
  if (upperLineBound != document2.lineCount - 1) {
    upperLineBound++;
  }
  while (upperLineBound != document2.lineCount - 1 && document2.lineAt(upperLineBound).text.indexOf("<") == -1) {
    upperLineBound++;
  }
  let joinedStr = "";
  let cursorIndexInStr = -1;
  for (let currLineIndex = lowerLineBound; currLineIndex <= upperLineBound; currLineIndex++) {
    const currLine = document2.lineAt(currLineIndex).text;
    if (currLineIndex == position.line) {
      cursorIndexInStr = joinedStr.length + position.character + -1;
    }
    joinedStr += currLine + "\n";
  }
  return [joinedStr, cursorIndexInStr];
}
function prunedDuplicateAttributes(originalAttributeSuggestions, position, document2, nsPrefix) {
  if (originalAttributeSuggestions == void 0 || originalAttributeSuggestions.length == 0) {
    return originalAttributeSuggestions;
  }
  const relevantJoinedLinesOfTextItems = getPotentialAttributeText(
    position,
    document2
  );
  const textIndex = 0;
  const cursorPosIndex = 1;
  const relevantDocText = relevantJoinedLinesOfTextItems[textIndex];
  let indexLowerBound = relevantJoinedLinesOfTextItems[cursorPosIndex];
  let indexUpperBound = indexLowerBound + 1;
  while (indexLowerBound >= 1 && relevantDocText[indexLowerBound] != "<") {
    indexLowerBound--;
  }
  while (indexUpperBound < relevantDocText.length && !(relevantDocText[indexUpperBound] == "<" || relevantDocText[indexUpperBound] == ">")) {
    indexUpperBound++;
  }
  const fullXMLElementText = relevantDocText[indexUpperBound - 1] != ">" ? `${relevantDocText.substring(indexLowerBound, indexUpperBound)}>` : relevantDocText.substring(indexLowerBound, indexUpperBound);
  const xmlRep = libExports.xml2js(fullXMLElementText, {});
  const attributes = xmlRep.elements?.[0].attributes;
  if (attributes) {
    const removeDFDLPrefix = nsPrefix === "dfdl:";
    const attributeSet = new Set(Object.keys(attributes));
    return originalAttributeSuggestions.filter((suggestionItem) => {
      const SuggestionLabel = suggestionItem.label.toString();
      return !attributeSet.has(
        removeDFDLPrefix && SuggestionLabel.startsWith("dfdl:") ? SuggestionLabel.substring("dfdl:".length) : SuggestionLabel
      );
    });
  }
  return originalAttributeSuggestions;
}
function getAttributeCompletionProvider() {
  return vscode__namespace.languages.registerCompletionItemProvider(
    { language: "dfdl" },
    {
      provideCompletionItems(document2, position) {
        const triggerText = document2.lineAt(position).text.substring(0, position.character);
        const charBeforeTrigger = triggerText.charAt(position.character - 1);
        const charAfterTrigger = triggerText.charAt(position.character);
        let xmlItem = new XmlItem();
        xmlItem = nearestOpen(document2, position);
        let nearestOpenItem = xmlItem.itemName;
        let itemsOnLine = getItemsOnLineCount(triggerText);
        const nsPrefix = xmlItem.itemNS;
        const attributeNames = xmlItem.itemAttributes;
        let additionalItems = getDefinedTypes(
          document2,
          getSchemaNsPrefix(document2)
        );
        if (isInXPath(document2, position)) return void 0;
        if (checkBraceOpen(document2, position) || cursorWithinBraces(document2, position) || cursorWithinQuotes(document2, position) || cursorAfterEquals(document2, position) || nearestOpenItem.includes("none")) {
          return void 0;
        }
        let preVal = !triggerText.includes("<" + nsPrefix + nearestOpenItem) && lineCount(document2, position, nearestOpenItem) === 1 && itemsOnLine < 2 ? "	" : "";
        const fullAttrCompletionList = checkNearestOpenItem(
          nearestOpenItem,
          attributeNames,
          triggerText,
          nsPrefix,
          preVal,
          additionalItems,
          charBeforeTrigger,
          charAfterTrigger
        );
        return prunedDuplicateAttributes(
          fullAttrCompletionList,
          position,
          document2,
          nsPrefix
        );
      }
    },
    " ",
    "\n"
    // triggered whenever a newline is typed
  );
}
function getDefinedTypes(document2, nsPrefix) {
  let additionalTypes = "";
  let lineNum = 0;
  const lineCount2 = document2.lineCount;
  while (lineNum !== lineCount2) {
    const triggerText = document2.lineAt(lineNum).text.substring(0, document2.lineAt(lineNum).range.end.character);
    if (triggerText.includes(nsPrefix + "simpleType name=") || triggerText.includes(nsPrefix + "complexType name=")) {
      let startPos = triggerText.indexOf('"', 0);
      let endPos = triggerText.indexOf('"', startPos + 1);
      let newType = triggerText.substring(startPos + 1, endPos);
      additionalTypes = String(additionalTypes + "," + newType);
    }
    ++lineNum;
  }
  return additionalTypes;
}
function checkNearestOpenItem(nearestOpenItem, attributeNames, triggerText, nsPrefix, preVal, additionalItems, charBeforeTrigger, charAfterTrigger) {
  const spacingChar = charBeforeTrigger !== " " && charBeforeTrigger !== "\n" && charBeforeTrigger !== "	" ? " " : "";
  const afterChar = charAfterTrigger !== " " && charAfterTrigger !== "\n" && charAfterTrigger !== "	" ? " " : "";
  const dfdlPrefix = nsPrefix === "dfdl:" ? "" : dfdlDefaultPrefix;
  switch (nearestOpenItem) {
    case "element":
      return getCompletionItems(
        [
          "name",
          "maxOccurs",
          "minOccurs",
          "nillable",
          "ref",
          "type",
          "default",
          "fixed",
          "dfdl:occursCount",
          "dfdl:bitOrder",
          "dfdl:byteOrder",
          "dfdl:encoding",
          "dfdl:utf16Width",
          "dfdl:encodingErrorPolicy",
          "dfdl:alignment",
          "dfdl:alignmentUnits",
          "dfdl:fillbyte",
          "dfdl:leadingSkip",
          "dfdl:trailingSkip",
          "dfdl:initiator",
          "dfdl:terminator",
          "dfdl:emptyValueDelimiterPolicy",
          "dfdl:outputNewLine",
          "dfdl:emptyElementParsePolicy",
          "dfdl:lengthKind",
          "dfdl:lengthUnits",
          "dfdl:length",
          "dfdl:prefixIncludesPrefixLength",
          "dfdl:prefixLengthType",
          "dfdl:lengthPattern",
          "dfdl:representation",
          "dfdl:textPadKind",
          "dfdl:textTrimKind",
          "dfdl:textOutputMinLength",
          "dfdl:escapeSchemeRef",
          "dfdl:textBidi",
          "dfdl:textStringustification",
          "dfdl:textStringPadChar",
          "dfdl:truncateSpecifiedLengthString",
          "dfdl:decimalSigned",
          "dfdl:textNumberRep",
          "dfdl:textNumberJustification",
          "dfdl:textNumberPadCharacter",
          "dfdl:textNumberPattern",
          "dfdl:textnumberRounding",
          "dfdl:textNumberRoundingMode",
          "dfdl:textNumberRoundingIncrement",
          "dfdl:textNumberCheckPolicy",
          "dfdl:textStandardDecimalSeparator",
          "dfdl:textStandardGroupingSeparator",
          "dfdl:textStandardExponentRep",
          "dfdl:textStandardInfinityRep",
          "dfdl:textStandardNaNRep",
          "dfdl:textStandardZeroRep",
          "dfdl:textStandardBase",
          "dfdl:textZonedSignStyle",
          "dfdl:binaryNumberRep",
          "dfdl:binaryDecimalVirtualPoint",
          "dfdl:binaryPakedSignCodes",
          "dfdl:binaryNumberCheckPolicy",
          "dfdl:binaryFloatRep",
          "dfdl:textBooleanTrueRep",
          "dfdl:textBooleanFalseRep",
          "dfdl:textBooleanJustification",
          "dfdl:textBooleanPadChar",
          "dfdl:binaryBooleanTrueRep",
          "dfdl:binaryBooleanFalseRep",
          "dfdl:calendarPattern",
          "dfdl:calendarPatternKind",
          "dfdl:calendarCheckPolicy",
          "dfdl:calendarTimeZone",
          "dfdl:calendarObserveDST",
          "dfdl:calendarFirstDayOfWeek",
          "dfdl:calendarDaysInFirstWeek",
          "dfdl:calendarCenturyStart",
          "dfdl:calendarLanguage",
          "dfdl:textCalendarJustification",
          "dfdl:textCalendarPadCharacter",
          "dfdl:binaryCalendarRep",
          "dfdl:binaryCalendarEpoch",
          "dfdl:nillKind",
          "dfdl:nilValue",
          "dfdl:nilValueDelimiterPolicy",
          "dfdl:useNilValueForDefault",
          "dfdl:floating",
          "dfdl:choiceBranchKey",
          "dfdl:occursCountKind",
          "dfdl:occursCount",
          "dfdl:inputValueCalc",
          "dfdl:outputValueCalc"
        ],
        preVal,
        additionalItems,
        nsPrefix,
        dfdlPrefix,
        spacingChar,
        afterChar
      );
    case "sequence":
      return getCompletionItems(
        [
          "dfdl:hiddenGroupRef",
          "dfdl:sequenceKind",
          "dfdl:separator",
          "dfdl:separatorPosition",
          "dfdl:separatorSuppressionPolicy"
        ],
        preVal,
        "",
        nsPrefix,
        dfdlPrefix,
        spacingChar,
        afterChar
      );
    case "choice":
      return getCompletionItems(
        [
          "dfdl:choiceLengthKind",
          "dfdl:choiceLength",
          "dfdl:initiatedContent",
          "dfdl:choiceDispatchKey",
          "dfdl:choiceBranchKey"
        ],
        "",
        "",
        nsPrefix,
        dfdlPrefix,
        spacingChar,
        afterChar
      );
    case "group":
      return getCompletionItems(
        [
          "ref",
          "name",
          "dfdl:separator",
          "dfdl:separatorPosition",
          "dfdl:separatorSuppressionPolicy"
        ],
        "",
        "",
        nsPrefix,
        dfdlPrefix,
        spacingChar,
        afterChar
      );
    case "simpleType":
      return getCompletionItems(
        [
          "dfdl:binaryNumberRep",
          "dfdl:length",
          "dfdl:lengthKind",
          "dfdl:representation",
          "dfdl:binaryBooleanTrueRep",
          "dfdl:binaryBooleanFalseRep"
        ],
        "",
        "",
        nsPrefix,
        dfdlPrefix,
        spacingChar,
        afterChar
      );
    case "include":
      return getCompletionItems(
        ["schemaLocation"],
        "",
        "",
        nsPrefix,
        "",
        spacingChar,
        afterChar
      );
    case "import":
      return getCompletionItems(
        ["schemaLocation", "namespace"],
        "",
        "",
        nsPrefix,
        "",
        spacingChar,
        afterChar
      );
    case "assert":
      return getCompletionItems(
        ["testKind", "test", "testPattern", "message", "failureType"],
        "",
        "",
        nsPrefix,
        "",
        spacingChar,
        afterChar
      );
    case "discriminator":
      return getCompletionItems(
        ["testKind", "test", "testPattern", "message"],
        "",
        "",
        nsPrefix,
        "",
        spacingChar,
        afterChar
      );
    case "restriction":
      return getCompletionItems(
        ["base"],
        "",
        "",
        nsPrefix,
        "",
        spacingChar,
        afterChar
      );
    case "format":
      return getCompletionItems(
        [
          "ref",
          "dfdl:byteOrder",
          "dfdl:bitOrder",
          "dfdl:binaryNumberRep",
          "dfdl:binaryFloatRep",
          "dfdl:binaryDecimalVirtualPoint",
          "dfdl:binaryPackedSignCodes",
          "dfdl:binaryNumberCheckPolicy",
          "dfdl:encoding",
          "dfdl:encodingErrorPolicy",
          "dfdl:initiator",
          "dfdl:length",
          "dfdl:lengthKind",
          "dfdl:lengthUnits",
          "dfdl:utf16Width",
          "dfdl:nilKind",
          "dfdl:nilValue",
          "dfdl:nilValueDelimiterPolicy",
          "dfdl:useNilForDefault",
          "dfdl:lengthPattern",
          "dfdl:outputNewLine",
          "dfdl:separator",
          "dfdl:separatorPosition",
          "dfdl:separatorSuppressionPolicy",
          "dfdl:terminator",
          "dfdl:occursCountKind",
          "dfdl:decimalSigned",
          "dfdl:textStandardZeroRep",
          "dfdl:textStandardInfinityRep",
          "dfdl:textStandardExponentRep",
          "dfdl:textStandardNaNRep",
          "dfdl:textNumberPattern",
          "dfdl:textNumberRep",
          "dfdl:textNumberJustification",
          "dfdl:textNumberRoundingIncrement",
          "dfdl:textNumberRoundingMode",
          "dfdl:textNumberRounding",
          "dfdl:textNumberCheckPolicy",
          "dfdl:textOutputMinLength",
          "dfdl:textPolicyOutputMinLength",
          "dfdl:textStandardDecimalSeparator",
          "dfdl:textStandardGroupingSeparator",
          "dfdl:textStringJustification",
          "dfdl:textStringPadCharacter",
          "dfdl:textPadKind",
          "dfdl:textStandardBase",
          "dfdl:textZonedSignStyle",
          "dfdl:textTrimKind",
          "dfdl:leadingSkip",
          "dfdl:trailingSkip",
          "dfdl:truncateSpecifiedLengthString",
          "dfdl:sequenceKind",
          "dfdl:textBidi",
          "dfdl:choiceLengthKind",
          "dfdl:choiceLength",
          "dfdl:fillByte",
          "dfdl:ignoreCase",
          "dfdl:initiatedContent",
          "dfdl:floating",
          "dfdl:inputValueCalc",
          "dfdl:outputValueCalc",
          "dfdl:alignment",
          "dfdl:alignmentUnits",
          "dfdl:representation",
          "dfdl:calendarPattern",
          "dfdl:calendarPatternKind",
          "dfdl:calendarCheckPolicy",
          "dfdl:calendarTimeZone",
          "dfdl:calendarObserveDST",
          "dfdl:calendarFirstDayOfWeek",
          "dfdl:calendarDaysInFirstWeek",
          "dfdl:calendarCenturyStart",
          "dfdl:calendarLanguage",
          "dfdl:documentFinalTerminatorCanBeMissing",
          "dfdl:emptyValueDelimiterPolicy",
          "dfdl:emptyElementParsePolicy",
          "dfdl:prefixIncludesPrefixLength",
          "dfdl:prefixLengthType",
          "dfdl:escapeSchemeRef",
          "dfdl:escapeKind",
          "dfdl:escapeBlockStart",
          "dfdl:escapeBlockEnd",
          "dfdl:escapeEscapeCharacter",
          "dfdl:extraEscapeCharacters",
          "dfdl:generateEscapeBlock",
          "dfdl:escapeCharacterPolicy",
          "dfdl:textBooleanTrueRep",
          "dfdl:textBooleanFalseRep",
          "dfdl:textCalendarJustification",
          "dfdl:textCalendarPadCharacter",
          "dfdl:binaryCalaendarRep",
          "dfdl:binaryCalendarEpoch"
        ],
        "",
        "",
        nsPrefix,
        "",
        spacingChar,
        afterChar
      );
    case "escapeScheme":
      return getCompletionItems(
        [
          "dfdl:escapeKind",
          "dfdl:escapeCharacter",
          "dfdl:escapeBlockStart",
          "dfdl:escapeBlockEnd",
          "dfdl:escapeEscapeCharacter",
          "dfdl:extraEscapedCharacters",
          "dfdl:generateEscapeBlock",
          "dfdl:escapeCharacterPolicy"
        ],
        "",
        "",
        nsPrefix,
        "",
        spacingChar,
        afterChar
      );
    case "defineVariable":
      return getDefineVariableCompletionItems(
        preVal,
        additionalItems,
        nsPrefix,
        spacingChar,
        afterChar
      );
    case "newVariableInstance":
      return getDefineVariableCompletionItems(
        preVal,
        additionalItems,
        nsPrefix,
        spacingChar,
        afterChar
      );
    case "setVariable":
      const xmlValue = new vscode__namespace.CompletionItem("value");
      xmlValue.insertText = new vscode__namespace.SnippetString('value="$1"$0');
      xmlValue.documentation = new vscode__namespace.MarkdownString("");
      return void 0;
    default:
      return void 0;
  }
}
function getDefineVariableCompletionItems(preVal, additionalItems, nsPrefix, spacingChar, afterChar) {
  let xmlItems = [
    {
      item: "external",
      snippetString: spacingChar + preVal + 'external="${1|true,false|}"$0' + afterChar
    },
    {
      item: "defaultValue",
      snippetString: spacingChar + preVal + 'defaultValue="0$1"$0' + afterChar
    }
  ];
  let compItems = [];
  xmlItems.forEach((e) => {
    const completionItem = new vscode__namespace.CompletionItem(e.item);
    completionItem.insertText = new vscode__namespace.SnippetString(e.snippetString);
    compItems.push(completionItem);
  });
  return compItems;
}
function getCloseElementProvider() {
  return vscode__namespace.languages.registerCompletionItemProvider(
    "dfdl",
    {
      async provideCompletionItems(document2, position) {
        let triggerChar = ">";
        if (checkBraceOpen(document2, position) || cursorWithinBraces(document2, position) || cursorWithinQuotes(document2, position) || cursorAfterEquals(document2, position) || isInXPath(document2, position) || isNotTriggerChar(document2, position, triggerChar)) {
          return void 0;
        }
        let backpos = position.with(position.line, position.character);
        position.with(position.line, position.character);
        if (position.character > 0) {
          backpos = position.with(position.line, position.character - 1);
        }
        if (position.character > 2) {
          position.with(position.line, position.character - 3);
        }
        let nsPrefix = getNsPrefix(document2, position);
        const origPrefix = nsPrefix;
        const nearestTagNotClosed = checkMissingCloseTag(
          document2,
          position,
          nsPrefix
        );
        nsPrefix = getItemPrefix(nearestTagNotClosed, origPrefix);
        const triggerText = document2.lineAt(position).text.substring(0, position.character);
        let itemsOnLine = getItemsOnLineCount(triggerText);
        if (nearestTagNotClosed.includes("none")) {
          return void 0;
        }
        let range2 = new vscode__namespace.Range(position, position);
        if (triggerText.endsWith(">") && itemsOnLine < 2 || triggerText.endsWith(">>") && itemsOnLine > 1 || triggerText.endsWith(".=>") && itemsOnLine === 0) {
          range2 = new vscode__namespace.Range(backpos, position);
          await vscode__namespace.window.activeTextEditor?.edit((editBuilder) => {
            editBuilder.replace(range2, "");
          });
          checkItemsOnLine$1(
            document2,
            position,
            range2,
            itemsOnLine,
            triggerText,
            nsPrefix,
            nearestTagNotClosed,
            backpos
          );
        }
        return void 0;
      }
    },
    ">"
    // triggered whenever a '>' is typed
  );
}
function checkItemsOnLine$1(document2, position, range2, itemsOnLine, triggerText, nsPrefix, nearestTagNotClosed, backpos, backpos3) {
  if (itemsOnLine == 0 && !triggerText.includes("</") && !triggerText.includes("/>")) {
    if (triggerText.trim() === ">") {
      insertSnippet("</" + nsPrefix + nearestTagNotClosed + ">", backpos);
    } else {
      switch (nearestTagNotClosed) {
        case "schema":
          if (triggerText.endsWith(">>")) {
            insertSnippet(
              "\n	$0\n</" + nsPrefix + nearestTagNotClosed + ">",
              backpos
            );
          } else {
            insertSnippet(
              ">\n	$0\n</" + nsPrefix + nearestTagNotClosed + ">",
              backpos
            );
          }
          break;
        default:
          if (triggerText.endsWith(">>")) {
            insertSnippet(
              "</" + nsPrefix + nearestTagNotClosed + ">$0",
              backpos
            );
          } else {
            insertSnippet(
              ">$1</" + nsPrefix + nearestTagNotClosed + ">",
              backpos
            );
          }
          break;
      }
    }
  }
  if (itemsOnLine === 1 && !triggerText.includes("</") && !triggerText.includes("/>")) {
    checkNearestTagNotClosed(
      document2,
      position,
      range2,
      nearestTagNotClosed,
      backpos,
      nsPrefix
    );
  }
  if (itemsOnLine > 1) {
    checkTriggerText(triggerText, nsPrefix, backpos, nearestTagNotClosed);
  }
}
function checkNearestTagNotClosed(document2, position, range2, nearestTagNotClosed, backpos, nsPrefix) {
  const triggerText = document2.lineAt(position.line).text;
  switch (nearestTagNotClosed) {
    case "defineVariable":
    case "setVariable":
      insertSnippet(">\n</" + nsPrefix + nearestTagNotClosed + ">$0", backpos);
      break;
    case "assert":
    case "discriminator":
      if (triggerText.endsWith(">")) {
        insertSnippet("$1</" + nsPrefix + nearestTagNotClosed + ">", backpos);
      } else {
        insertSnippet(">$1</" + nsPrefix + nearestTagNotClosed + ">$0", backpos);
      }
      break;
    default:
      if (triggerText.trim() === "") {
        insertSnippet("</" + nsPrefix + nearestTagNotClosed + ">", backpos);
      } else {
        insertSnippet(
          ">\n	$0\n</" + nsPrefix + nearestTagNotClosed + ">",
          backpos
        );
      }
      break;
  }
}
function checkTriggerText(triggerText, nsPrefix, backpos, nearestTagNotClosed) {
  if (triggerText.includes("<" + nsPrefix + nearestTagNotClosed)) {
    let tagPos = triggerText.lastIndexOf("<" + nsPrefix + nearestTagNotClosed);
    let tagEndPos = triggerText.indexOf(">", tagPos);
    if (tagPos != -1 && !triggerText.substring(tagEndPos - 1, 2).includes("/>") && !triggerText.substring(tagEndPos).includes("</" + nsPrefix + nearestTagNotClosed)) {
      if (triggerText.endsWith(">>")) {
        insertSnippet("</" + nsPrefix + nearestTagNotClosed + ">$0", backpos);
      } else {
        insertSnippet("></" + nsPrefix + nearestTagNotClosed + ">$0", backpos);
      }
    }
  }
}
const noChoiceAttributes = [
  "name",
  "ref",
  "occursCount",
  "length",
  "prefixLengthType",
  "nilValue",
  "lengthPattern",
  "inputValueCalc",
  "outputValueCalc",
  "hiddenGroupRef",
  "choiceBranchKey",
  "textOutputMinLength",
  "textStandardDecimalSeparator",
  "textStandardGroupingSeparator",
  "textZonedSignStyle",
  "textNumberRoundingIncrement",
  "textBooleanTrueRep",
  "textBooleanFalseRep",
  "textBooleanJustification",
  "textBooleanPadCharacter",
  "separator",
  "terminator",
  "choiceLength",
  "fillByte",
  "initiator",
  "choiceDispatchKey",
  "binaryDecimalVirtualPoint",
  "binaryPackedSignCodes",
  "binaryBooleantrueRep",
  "binaryBooleanFalseRep",
  "calendarPattern",
  "calendarTimeZone",
  "calendarCenturyStart",
  "calendarLanguage",
  "escapeSchemeRef",
  "escapeCharacter",
  "escapeBlockStart",
  "escapeBlockEnd",
  "escapeEscapeCharacter",
  "extraEscapedCharacters",
  "test",
  "testPattern",
  "message",
  "source",
  "schemaLocation",
  "targetNamespace",
  "namespace"
];
function getAttributeValueCompletionProvider() {
  return vscode__namespace.languages.registerCompletionItemProvider(
    "dfdl",
    {
      async provideCompletionItems(document2, position) {
        if (checkBraceOpen(document2, position) || cursorWithinBraces(document2, position) || !cursorWithinQuotes(document2, position)) {
          return void 0;
        }
        const schemaPosition = new vscode__namespace.Position(0, 0);
        const nsPrefix = getNsPrefix(document2, schemaPosition);
        let additionalItems = getDefinedTypes(document2, nsPrefix);
        let [attributeName, startPos, endPos] = getAttributeDetails(
          document2,
          position
        );
        if (attributeName !== "none" && !attributeName.includes("xmlns:")) {
          let getAttributeValues = function(attributeName2) {
            const attributeItems = [];
            attributeCompletion(
              additionalItems,
              "",
              "dfdl",
              "",
              ""
            ).items.forEach((r) => attributeItems.push(r));
            const foundItem = attributeItems.find(
              (attributeItem) => attributeItem.item.includes(attributeName2)
            );
            if (foundItem?.item.includes(attributeName2)) {
              let parts = foundItem.snippetString.split("=");
              let snippet = parts.slice(1).toString();
              if (snippet != null) {
                return insertSnippet(snippet, startPosition);
              } else {
                return void 0;
              }
            }
          };
          let replaceValue = "";
          if (startPos === endPos) {
            replaceValue = " ";
          }
          if (attributeName.includes(":")) {
            attributeName = attributeName.substring(
              attributeName.indexOf(":") + 1
            );
          }
          if (noChoiceAttributes.includes(attributeName)) {
            return void 0;
          }
          let startPosition = position.with(position.line, startPos);
          let endPosition = position.with(position.line, endPos + 1);
          let range2 = new vscode__namespace.Range(startPosition, endPosition);
          await vscode__namespace.window.activeTextEditor?.edit((editBuilder) => {
            editBuilder.replace(range2, replaceValue);
          });
          getAttributeValues(attributeName);
        }
        return void 0;
      }
    },
    " "
    // triggered whenever a space is typed
  );
}
function getAttributeDetails(document2, position) {
  const quoteChar = ["'", '"'];
  const triggerLine = position.line;
  const triggerPos = position.character;
  let currentLine = triggerLine;
  let currentPos = triggerPos;
  let endPos = -1;
  let currentText = document2.lineAt(currentLine).text;
  let textBeforeTrigger = currentText.substring(0, triggerPos);
  let attributeName = "none";
  let attributeStartPos = 0;
  while (!currentText.includes("'") && !currentText.includes('"') && !currentText.includes("=") && !currentText.includes("<") && !currentText.includes(">") && currentLine > 0 && currentLine < document2.lineCount) {
    currentText = document2.lineAt(--currentLine).text;
  }
  if (currentLine === 0 || currentLine === document2.lineCount) {
    return ["none", 0, 0];
  }
  if ((currentPos = textBeforeTrigger.lastIndexOf("=")) !== -1) {
    if (triggerPos === currentPos + 1) {
      attributeStartPos = textBeforeTrigger.lastIndexOf(" ") + 1;
      attributeName = textBeforeTrigger.substring(attributeStartPos, currentPos);
      return [attributeName, currentPos + 1, currentPos + 1];
    }
  }
  for (let i = 0; i < quoteChar.length; ++i) {
    if (currentText.includes(quoteChar[i])) {
      if (currentLine === triggerLine) {
        currentPos = textBeforeTrigger.lastIndexOf(quoteChar[i]);
        if (currentPos < triggerPos && textBeforeTrigger.lastIndexOf("=") === currentPos - 1) {
          textBeforeTrigger = textBeforeTrigger.substring(
            0,
            textBeforeTrigger.lastIndexOf("=")
          );
          endPos = currentText.indexOf(quoteChar[i], currentPos + 1);
          attributeStartPos = textBeforeTrigger.lastIndexOf(" ");
          attributeName = textBeforeTrigger.substring(attributeStartPos + 1, currentPos - 1).trim();
        }
      }
    }
    if (attributeName !== "none") {
      break;
    }
  }
  return [attributeName, currentPos, endPos];
}
function getCloseElementSlashProvider() {
  return vscode__namespace.languages.registerCompletionItemProvider(
    "dfdl",
    {
      async provideCompletionItems(document2, position) {
        let backpos = new vscode__namespace.Position(position.line, position.character - 1);
        let nsPrefix = getNsPrefix(document2, position);
        let triggerText = document2.lineAt(position.line).text;
        let tagPos = triggerText.lastIndexOf("<" + nsPrefix + ":");
        triggerText.lastIndexOf("," + nsPrefix + ":");
        if (tagPos < 0) {
          tagPos = triggerText.lastIndexOf("<dfdl:");
          if (tagPos > 0) {
            nsPrefix = "dfdl:";
          }
        }
        triggerText = document2.lineAt(position).text.substring(0, position.character);
        let nearestTagNotClosed = checkMissingCloseTag(
          document2,
          position,
          nsPrefix
        );
        const itemsOnLine = getItemsOnLineCount(triggerText);
        const triggerChar = "/";
        if (checkBraceOpen(document2, position) || cursorWithinBraces(document2, position) || cursorWithinQuotes(document2, position) || cursorAfterEquals(document2, position) || isInXPath(document2, position) || isNotTriggerChar(document2, position, triggerChar)) {
          return void 0;
        }
        if (!(nearestTagNotClosed == "none")) {
          let range2 = new vscode__namespace.Range(backpos, position);
          await vscode__namespace.window.activeTextEditor?.edit((editBuilder) => {
            editBuilder.replace(range2, "");
          });
        }
        if (triggerText.endsWith("/")) {
          checkItemsOnLine(
            document2,
            position,
            itemsOnLine,
            nearestTagNotClosed,
            backpos,
            nsPrefix,
            triggerText
          );
        }
      }
    },
    "/"
    // triggered whenever a '/' is typed
  );
}
function checkItemsOnLine(document2, position, itemsOnLine, nearestTagNotClosed, backpos, nsPrefix, triggerText) {
  nsPrefix = getItemPrefix(nearestTagNotClosed, nsPrefix);
  if (!(nearestTagNotClosed == "none") && (itemsOnLine == 1 || itemsOnLine == 0)) {
    if (nearestTagNotClosed.includes("defineVariable") || nearestTagNotClosed.includes("setVariable")) {
      insertSnippet("/>\n", backpos);
    } else {
      insertSnippet("/>$0", backpos);
    }
  }
  if (itemsOnLine > 1) {
    if (triggerText.endsWith("/") && triggerText.includes("<" + nsPrefix + nearestTagNotClosed)) {
      let tagPos = triggerText.lastIndexOf("<" + nsPrefix + nearestTagNotClosed);
      let tagEndPos = triggerText.indexOf(">", tagPos);
      if (tagPos != -1 && !triggerText.substring(tagEndPos - 1, 2).includes("/>") && triggerText.substring(backpos.character - 1, backpos.character).includes(">") && !triggerText.substring(tagEndPos).includes("</" + nsPrefix + nearestTagNotClosed)) {
        insertSnippet("</" + nsPrefix + nearestTagNotClosed + ">$0", backpos);
      } else {
        insertSnippet("/>$0", backpos);
      }
    }
  }
}
function getAttributeHoverProvider() {
  return vscode__namespace.languages.registerHoverProvider("dfdl", {
    provideHover(document2, position, token) {
      const range2 = document2.getWordRangeAtPosition(position);
      if (!range2) {
        return void 0;
      }
      let hoverItem = document2.getText(range2);
      const attributeItems = [];
      attributeCompletion("", "", "dfdl", "", "").items.forEach(
        (r) => attributeItems.push(r)
      );
      let foundItem = attributeItems.find(
        (attributeItem) => attributeItem.item === hoverItem
      );
      if (foundItem == void 0) {
        hoverItem = "dfdl:" + hoverItem;
        foundItem = attributeItems.find(
          (attributeItem) => attributeItem.item === hoverItem
        );
      }
      if (foundItem?.item === hoverItem) {
        return new vscode__namespace.Hover(foundItem.markdownString);
      }
    }
  });
}
function activate$5(context) {
  fs__namespace.readFileSync(
    context.asAbsolutePath(
      "./src/language/providers/intellisense/DFDLGeneralFormat.dfdl.xsd"
    )
  ).toLocaleString();
  context.subscriptions.push(
    getElementCompletionProvider(),
    getAttributeCompletionProvider(),
    getAttributeValueCompletionProvider(),
    getCloseElementProvider(),
    getCloseElementSlashProvider(),
    getAttributeHoverProvider()
  );
}
var out = { exports: {} };
var hasRequiredOut;
function requireOut() {
  if (hasRequiredOut) return out.exports;
  hasRequiredOut = 1;
  var define_process_env_default = {};
  /*! For license information please see index.js.LICENSE.txt */
  function pinoWebpackAbsolutePath(e) {
    try {
      return require("path").join(__dirname, e);
    } catch (t) {
      return new Function("p", "return new URL(p, import.meta.url).pathname")(e);
    }
  }
  globalThis.__bundlerPathsOverrides = { "pino/file": pinoWebpackAbsolutePath("./pino-file.js"), "pino-worker": pinoWebpackAbsolutePath("./pino-worker.js"), "thread-stream-worker": pinoWebpackAbsolutePath("./thread-stream-worker.js") }, (() => {
    var __webpack_modules__ = { 50: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.getDefaultRootsData = t.CIPHER_SUITES = void 0;
      const n = r(9896);
      t.CIPHER_SUITES = define_process_env_default.GRPC_SSL_CIPHER_SUITES;
      const i = define_process_env_default.GRPC_DEFAULT_SSL_ROOTS_FILE_PATH;
      let o = null;
      t.getDefaultRootsData = function() {
        return i ? (null === o && (o = n.readFileSync(i)), o) : null;
      };
    }, 77: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.getSubchannelPool = t.SubchannelPool = void 0;
      const n = r(8575), i = r(9554), o = r(9939), s = r(5129), a = r(2658);
      class l {
        constructor() {
          this.pool = /* @__PURE__ */ Object.create(null), this.cleanupTimer = null;
        }
        unrefUnusedSubchannels() {
          let e2 = true;
          for (const t2 in this.pool) {
            const r2 = this.pool[t2].filter((e3) => !e3.subchannel.unrefIfOneRef());
            r2.length > 0 && (e2 = false), this.pool[t2] = r2;
          }
          e2 && null !== this.cleanupTimer && (clearInterval(this.cleanupTimer), this.cleanupTimer = null);
        }
        ensureCleanupTask() {
          var e2, t2;
          null === this.cleanupTimer && (this.cleanupTimer = setInterval(() => {
            this.unrefUnusedSubchannels();
          }, 1e4), null === (t2 = (e2 = this.cleanupTimer).unref) || void 0 === t2 || t2.call(e2));
        }
        getOrCreateSubchannel(e2, t2, r2, l2) {
          this.ensureCleanupTask();
          const c2 = (0, s.uriToString)(e2);
          if (c2 in this.pool) {
            const e3 = this.pool[c2];
            for (const i2 of e3) if ((0, o.subchannelAddressEqual)(t2, i2.subchannelAddress) && (0, n.channelOptionsEqual)(r2, i2.channelArguments) && l2._equals(i2.channelCredentials)) return i2.subchannel;
          }
          const u = new i.Subchannel(e2, t2, r2, l2, new a.Http2SubchannelConnector(e2));
          return c2 in this.pool || (this.pool[c2] = []), this.pool[c2].push({ subchannelAddress: t2, channelArguments: r2, channelCredentials: l2, subchannel: u }), u.ref(), u;
        }
      }
      t.SubchannelPool = l;
      const c = new l();
      t.getSubchannelPool = function(e2) {
        return e2 ? c : new l();
      };
    }, 78: (e) => {
      const t = /([()\][%!^"`<>&|;, *?])/g;
      e.exports.command = function(e2) {
        return e2.replace(t, "^$1");
      }, e.exports.argument = function(e2, r) {
        return e2 = (e2 = `"${e2 = (e2 = (e2 = `${e2}`).replace(/(?=(\\+?)?)\1"/g, '$1$1\\"')).replace(/(?=(\\+?)?)\1$/, "$1$1")}"`).replace(t, "^$1"), r && (e2 = e2.replace(t, "^$1")), e2;
      };
    }, 124: (e, t, r) => {
      t.formatArgs = function(t2) {
        if (t2[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + t2[0] + (this.useColors ? "%c " : " ") + "+" + e.exports.humanize(this.diff), !this.useColors) return;
        const r2 = "color: " + this.color;
        t2.splice(1, 0, r2, "color: inherit");
        let n2 = 0, i = 0;
        t2[0].replace(/%[a-zA-Z%]/g, (e2) => {
          "%%" !== e2 && (n2++, "%c" === e2 && (i = n2));
        }), t2.splice(i, 0, r2);
      }, t.save = function(e2) {
        try {
          e2 ? t.storage.setItem("debug", e2) : t.storage.removeItem("debug");
        } catch (e3) {
        }
      }, t.load = function() {
        let e2;
        try {
          e2 = t.storage.getItem("debug") || t.storage.getItem("DEBUG");
        } catch (e3) {
        }
        return !e2 && "undefined" != typeof process && "env" in process && (e2 = define_process_env_default.DEBUG), e2;
      }, t.useColors = function() {
        if ("undefined" != typeof window && window.process && ("renderer" === window.process.type || window.process.__nwjs)) return true;
        if ("undefined" != typeof navigator && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) return false;
        let e2;
        return "undefined" != typeof document && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || "undefined" != typeof window && window.console && (window.console.firebug || window.console.exception && window.console.table) || "undefined" != typeof navigator && navigator.userAgent && (e2 = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(e2[1], 10) >= 31 || "undefined" != typeof navigator && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
      }, t.storage = (function() {
        try {
          return localStorage;
        } catch (e2) {
        }
      })(), t.destroy = /* @__PURE__ */ (() => {
        let e2 = false;
        return () => {
          e2 || (e2 = true, console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."));
        };
      })(), t.colors = ["#0000CC", "#0000FF", "#0033CC", "#0033FF", "#0066CC", "#0066FF", "#0099CC", "#0099FF", "#00CC00", "#00CC33", "#00CC66", "#00CC99", "#00CCCC", "#00CCFF", "#3300CC", "#3300FF", "#3333CC", "#3333FF", "#3366CC", "#3366FF", "#3399CC", "#3399FF", "#33CC00", "#33CC33", "#33CC66", "#33CC99", "#33CCCC", "#33CCFF", "#6600CC", "#6600FF", "#6633CC", "#6633FF", "#66CC00", "#66CC33", "#9900CC", "#9900FF", "#9933CC", "#9933FF", "#99CC00", "#99CC33", "#CC0000", "#CC0033", "#CC0066", "#CC0099", "#CC00CC", "#CC00FF", "#CC3300", "#CC3333", "#CC3366", "#CC3399", "#CC33CC", "#CC33FF", "#CC6600", "#CC6633", "#CC9900", "#CC9933", "#CCCC00", "#CCCC33", "#FF0000", "#FF0033", "#FF0066", "#FF0099", "#FF00CC", "#FF00FF", "#FF3300", "#FF3333", "#FF3366", "#FF3399", "#FF33CC", "#FF33FF", "#FF6600", "#FF6633", "#FF9900", "#FF9933", "#FFCC00", "#FFCC33"], t.log = console.debug || console.log || (() => {
      }), e.exports = r(7891)(t);
      const { formatters: n } = e.exports;
      n.j = function(e2) {
        try {
          return JSON.stringify(e2);
        } catch (e3) {
          return "[UnexpectedJSONParseError]: " + e3.message;
        }
      };
    }, 159: (e) => {
      e.exports = JSON.parse('{"nested":{"google":{"nested":{"protobuf":{"nested":{"Type":{"fields":{"name":{"type":"string","id":1},"fields":{"rule":"repeated","type":"Field","id":2},"oneofs":{"rule":"repeated","type":"string","id":3},"options":{"rule":"repeated","type":"Option","id":4},"sourceContext":{"type":"SourceContext","id":5},"syntax":{"type":"Syntax","id":6}}},"Field":{"fields":{"kind":{"type":"Kind","id":1},"cardinality":{"type":"Cardinality","id":2},"number":{"type":"int32","id":3},"name":{"type":"string","id":4},"typeUrl":{"type":"string","id":6},"oneofIndex":{"type":"int32","id":7},"packed":{"type":"bool","id":8},"options":{"rule":"repeated","type":"Option","id":9},"jsonName":{"type":"string","id":10},"defaultValue":{"type":"string","id":11}},"nested":{"Kind":{"values":{"TYPE_UNKNOWN":0,"TYPE_DOUBLE":1,"TYPE_FLOAT":2,"TYPE_INT64":3,"TYPE_UINT64":4,"TYPE_INT32":5,"TYPE_FIXED64":6,"TYPE_FIXED32":7,"TYPE_BOOL":8,"TYPE_STRING":9,"TYPE_GROUP":10,"TYPE_MESSAGE":11,"TYPE_BYTES":12,"TYPE_UINT32":13,"TYPE_ENUM":14,"TYPE_SFIXED32":15,"TYPE_SFIXED64":16,"TYPE_SINT32":17,"TYPE_SINT64":18}},"Cardinality":{"values":{"CARDINALITY_UNKNOWN":0,"CARDINALITY_OPTIONAL":1,"CARDINALITY_REQUIRED":2,"CARDINALITY_REPEATED":3}}}},"Enum":{"fields":{"name":{"type":"string","id":1},"enumvalue":{"rule":"repeated","type":"EnumValue","id":2},"options":{"rule":"repeated","type":"Option","id":3},"sourceContext":{"type":"SourceContext","id":4},"syntax":{"type":"Syntax","id":5}}},"EnumValue":{"fields":{"name":{"type":"string","id":1},"number":{"type":"int32","id":2},"options":{"rule":"repeated","type":"Option","id":3}}},"Option":{"fields":{"name":{"type":"string","id":1},"value":{"type":"Any","id":2}}},"Syntax":{"values":{"SYNTAX_PROTO2":0,"SYNTAX_PROTO3":1}},"Any":{"fields":{"type_url":{"type":"string","id":1},"value":{"type":"bytes","id":2}}},"SourceContext":{"fields":{"fileName":{"type":"string","id":1}}}}}}}}}');
    }, 177: (e, t, r) => {
      e.exports = o;
      var n = r(3808), i = r(3768)("fs");
      function o(e2, t2, r2) {
        return "function" == typeof t2 ? (r2 = t2, t2 = {}) : t2 || (t2 = {}), r2 ? !t2.xhr && i && i.readFile ? i.readFile(e2, function(n2, i2) {
          return n2 && "undefined" != typeof XMLHttpRequest ? o.xhr(e2, t2, r2) : n2 ? r2(n2) : r2(null, t2.binary ? i2 : i2.toString("utf8"));
        }) : o.xhr(e2, t2, r2) : n(o, this, e2, t2);
      }
      o.xhr = function(e2, t2, r2) {
        var n2 = new XMLHttpRequest();
        n2.onreadystatechange = function() {
          if (4 === n2.readyState) {
            if (0 !== n2.status && 200 !== n2.status) return r2(Error("status " + n2.status));
            if (t2.binary) {
              var e3 = n2.response;
              if (!e3) {
                e3 = [];
                for (var i2 = 0; i2 < n2.responseText.length; ++i2) e3.push(255 & n2.responseText.charCodeAt(i2));
              }
              return r2(null, "undefined" != typeof Uint8Array ? new Uint8Array(e3) : e3);
            }
            return r2(null, n2.responseText);
          }
        }, t2.binary && ("overrideMimeType" in n2 && n2.overrideMimeType("text/plain; charset=x-user-defined"), n2.responseType = "arraybuffer"), n2.open("GET", e2), n2.send();
      };
    }, 181: (e) => {
      e.exports = require$$1$3;
    }, 206: (e) => {
      class t extends Error {
        constructor(e2) {
          super(e2), Error.captureStackTrace(this, this.constructor), this.name = "ConnectionError";
        }
      }
      e.exports = t;
    }, 230: (e, t, r) => {
      const n = r(5672);
      e.exports = (e2 = "") => {
        const t2 = e2.match(n);
        if (!t2) return null;
        const [r2, i] = t2[0].replace(/#! ?/, "").split(" "), o = r2.split("/").pop();
        return "env" === o ? i : i ? `${o} ${i}` : o;
      };
    }, 288: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.InternalChannel = void 0;
      const n = r(7015), i = r(6344), o = r(77), s = r(4129), a = r(9074), l = r(6754), c = r(9424), u = r(3120), d = r(4169), p = r(4398), h = r(5956), f = r(5129), g = r(5172), m = r(1668), y = r(8694), v = r(5431), b = r(7273), S = r(8605), w = r(4808), C = r(7930), _2 = r(2828), E = /* @__PURE__ */ new Map();
      class R extends _2.BaseSubchannelWrapper {
        constructor(e2, t2) {
          super(e2), this.channel = t2, this.refCount = 0, this.subchannelStateListener = (e3, r2, n2, i2) => {
            t2.throttleKeepalive(i2);
          }, e2.addConnectivityStateListener(this.subchannelStateListener);
        }
        ref() {
          this.child.ref(), this.refCount += 1;
        }
        unref() {
          this.child.unref(), this.refCount -= 1, this.refCount <= 0 && (this.child.removeConnectivityStateListener(this.subchannelStateListener), this.channel.removeWrappedSubchannel(this));
        }
      }
      class T {
        pick(e2) {
          return { pickResultType: s.PickResultType.DROP, status: { code: l.Status.UNAVAILABLE, details: "Channel closed before call started", metadata: new a.Metadata() }, subchannel: null, onCallStarted: null, onCallEnded: null };
        }
      }
      t.InternalChannel = class {
        constructor(e2, t2, r2) {
          var a2, y2, v2, b2, S2, _22, T2, O;
          if (this.credentials = t2, this.options = r2, this.connectivityState = g.ConnectivityState.IDLE, this.currentPicker = new s.UnavailablePicker(), this.configSelectionQueue = [], this.pickQueue = [], this.connectivityStateWatchers = [], this.configSelector = null, this.currentResolutionError = null, this.wrappedSubchannels = /* @__PURE__ */ new Set(), this.callCount = 0, this.idleTimer = null, this.channelzEnabled = true, this.callTracker = new m.ChannelzCallTracker(), this.childrenTracker = new m.ChannelzChildrenTracker(), this.randomChannelId = Math.floor(Math.random() * Number.MAX_SAFE_INTEGER), "string" != typeof e2) throw new TypeError("Channel target must be a string");
          if (!(t2 instanceof n.ChannelCredentials)) throw new TypeError("Channel credentials must be a ChannelCredentials object");
          if (r2 && "object" != typeof r2) throw new TypeError("Channel options must be an object");
          this.originalTarget = e2;
          const I = (0, f.parseUri)(e2);
          if (null === I) throw new Error(`Could not parse target name "${e2}"`);
          const M = (0, d.mapUriDefaultScheme)(I);
          if (null === M) throw new Error(`Could not find a default scheme for target name "${e2}"`);
          this.callRefTimer = setInterval(() => {
          }, 2147483647), null === (y2 = (a2 = this.callRefTimer).unref) || void 0 === y2 || y2.call(a2), 0 === this.options["grpc.enable_channelz"] && (this.channelzEnabled = false), this.channelzTrace = new m.ChannelzTrace(), this.channelzRef = (0, m.registerChannelzChannel)(e2, () => this.getChannelzInfo(), this.channelzEnabled), this.channelzEnabled && this.channelzTrace.addTrace("CT_INFO", "Channel created"), this.options["grpc.default_authority"] ? this.defaultAuthority = this.options["grpc.default_authority"] : this.defaultAuthority = (0, d.getDefaultAuthority)(M);
          const k = (0, h.mapProxyName)(M, r2);
          this.target = k.target, this.options = Object.assign({}, this.options, k.extraOptions), this.subchannelPool = (0, o.getSubchannelPool)(0 === (null !== (v2 = r2["grpc.use_local_subchannel_pool"]) && void 0 !== v2 ? v2 : 0)), this.retryBufferTracker = new C.MessageBufferTracker(null !== (b2 = r2["grpc.retry_buffer_size"]) && void 0 !== b2 ? b2 : 16777216, null !== (S2 = r2["grpc.per_rpc_retry_buffer_size"]) && void 0 !== S2 ? S2 : 1048576), this.keepaliveTime = null !== (_22 = r2["grpc.keepalive_time_ms"]) && void 0 !== _22 ? _22 : -1, this.idleTimeoutMs = Math.max(null !== (T2 = r2["grpc.client_idle_timeout_ms"]) && void 0 !== T2 ? T2 : 18e5, 1e3);
          const D = { createSubchannel: (e3, t3, r3) => {
            const n2 = this.subchannelPool.getOrCreateSubchannel(this.target, e3, Object.assign({}, this.options, t3), null != r3 ? r3 : this.credentials);
            n2.throttleKeepalive(this.keepaliveTime), this.channelzEnabled && this.channelzTrace.addTrace("CT_INFO", "Created subchannel or used existing subchannel", n2.getChannelzRef());
            const i2 = new R(n2, this);
            return this.wrappedSubchannels.add(i2), i2;
          }, updateState: (e3, t3) => {
            this.currentPicker = t3;
            const r3 = this.pickQueue.slice();
            this.pickQueue = [], r3.length > 0 && this.callRefTimerUnref();
            for (const e4 of r3) e4.doPick();
            this.updateState(e3);
          }, requestReresolution: () => {
            throw new Error("Resolving load balancer should never call requestReresolution");
          }, addChannelzChild: (e3) => {
            this.channelzEnabled && this.childrenTracker.refChild(e3);
          }, removeChannelzChild: (e3) => {
            this.channelzEnabled && this.childrenTracker.unrefChild(e3);
          } };
          this.resolvingLoadBalancer = new i.ResolvingLoadBalancer(this.target, D, t2, r2, (e3, t3) => {
            e3.retryThrottling ? E.set(this.getTarget(), new C.RetryThrottler(e3.retryThrottling.maxTokens, e3.retryThrottling.tokenRatio, E.get(this.getTarget()))) : E.delete(this.getTarget()), this.channelzEnabled && this.channelzTrace.addTrace("CT_INFO", "Address resolution succeeded"), this.configSelector = t3, this.currentResolutionError = null, process.nextTick(() => {
              const e4 = this.configSelectionQueue;
              this.configSelectionQueue = [], e4.length > 0 && this.callRefTimerUnref();
              for (const t4 of e4) t4.getConfig();
            });
          }, (e3) => {
            this.channelzEnabled && this.channelzTrace.addTrace("CT_WARNING", "Address resolution failed with code " + e3.code + ' and details "' + e3.details + '"'), this.configSelectionQueue.length > 0 && this.trace("Name resolution failed with calls queued for config selection"), null === this.configSelector && (this.currentResolutionError = Object.assign(Object.assign({}, (0, w.restrictControlPlaneStatusCode)(e3.code, e3.details)), { metadata: e3.metadata }));
            const t3 = this.configSelectionQueue;
            this.configSelectionQueue = [], t3.length > 0 && this.callRefTimerUnref();
            for (const r3 of t3) r3.reportResolverError(e3);
          }), this.filterStackFactory = new c.FilterStackFactory([new u.CompressionFilterFactory(this, this.options)]), this.trace("Channel constructed with options " + JSON.stringify(r2, void 0, 2));
          const P = new Error();
          (0, p.isTracerEnabled)("channel_stacktrace") && (0, p.trace)(l.LogVerbosity.DEBUG, "channel_stacktrace", "(" + this.channelzRef.id + ") Channel constructed \n" + (null === (O = P.stack) || void 0 === O ? void 0 : O.substring(P.stack.indexOf("\n") + 1))), this.lastActivityTimestamp = /* @__PURE__ */ new Date();
        }
        getChannelzInfo() {
          return { target: this.originalTarget, state: this.connectivityState, trace: this.channelzTrace, callTracker: this.callTracker, children: this.childrenTracker.getChildLists() };
        }
        trace(e2, t2) {
          (0, p.trace)(null != t2 ? t2 : l.LogVerbosity.DEBUG, "channel", "(" + this.channelzRef.id + ") " + (0, f.uriToString)(this.target) + " " + e2);
        }
        callRefTimerRef() {
          var e2, t2, r2, n2;
          (null === (t2 = (e2 = this.callRefTimer).hasRef) || void 0 === t2 ? void 0 : t2.call(e2)) || (this.trace("callRefTimer.ref | configSelectionQueue.length=" + this.configSelectionQueue.length + " pickQueue.length=" + this.pickQueue.length), null === (n2 = (r2 = this.callRefTimer).ref) || void 0 === n2 || n2.call(r2));
        }
        callRefTimerUnref() {
          var e2, t2;
          this.callRefTimer.hasRef && !this.callRefTimer.hasRef() || (this.trace("callRefTimer.unref | configSelectionQueue.length=" + this.configSelectionQueue.length + " pickQueue.length=" + this.pickQueue.length), null === (t2 = (e2 = this.callRefTimer).unref) || void 0 === t2 || t2.call(e2));
        }
        removeConnectivityStateWatcher(e2) {
          const t2 = this.connectivityStateWatchers.findIndex((t3) => t3 === e2);
          t2 >= 0 && this.connectivityStateWatchers.splice(t2, 1);
        }
        updateState(e2) {
          (0, p.trace)(l.LogVerbosity.DEBUG, "connectivity_state", "(" + this.channelzRef.id + ") " + (0, f.uriToString)(this.target) + " " + g.ConnectivityState[this.connectivityState] + " -> " + g.ConnectivityState[e2]), this.channelzEnabled && this.channelzTrace.addTrace("CT_INFO", "Connectivity state change to " + g.ConnectivityState[e2]), this.connectivityState = e2;
          const t2 = this.connectivityStateWatchers.slice();
          for (const r2 of t2) e2 !== r2.currentState && (r2.timer && clearTimeout(r2.timer), this.removeConnectivityStateWatcher(r2), r2.callback());
          e2 !== g.ConnectivityState.TRANSIENT_FAILURE && (this.currentResolutionError = null);
        }
        throttleKeepalive(e2) {
          if (e2 > this.keepaliveTime) {
            this.keepaliveTime = e2;
            for (const t2 of this.wrappedSubchannels) t2.throttleKeepalive(e2);
          }
        }
        removeWrappedSubchannel(e2) {
          this.wrappedSubchannels.delete(e2);
        }
        doPick(e2, t2) {
          return this.currentPicker.pick({ metadata: e2, extraPickInfo: t2 });
        }
        queueCallForPick(e2) {
          this.pickQueue.push(e2), this.callRefTimerRef();
        }
        getConfig(e2, t2) {
          return this.connectivityState !== g.ConnectivityState.SHUTDOWN && this.resolvingLoadBalancer.exitIdle(), this.configSelector ? { type: "SUCCESS", config: this.configSelector(e2, t2, this.randomChannelId) } : this.currentResolutionError ? { type: "ERROR", error: this.currentResolutionError } : { type: "NONE" };
        }
        queueCallForConfig(e2) {
          this.configSelectionQueue.push(e2), this.callRefTimerRef();
        }
        enterIdle() {
          this.resolvingLoadBalancer.destroy(), this.updateState(g.ConnectivityState.IDLE), this.currentPicker = new s.QueuePicker(this.resolvingLoadBalancer), this.idleTimer && (clearTimeout(this.idleTimer), this.idleTimer = null);
        }
        startIdleTimeout(e2) {
          var t2, r2;
          this.idleTimer = setTimeout(() => {
            if (this.callCount > 0) return void this.startIdleTimeout(this.idleTimeoutMs);
            const e3 = (/* @__PURE__ */ new Date()).valueOf() - this.lastActivityTimestamp.valueOf();
            e3 >= this.idleTimeoutMs ? (this.trace("Idle timer triggered after " + this.idleTimeoutMs + "ms of inactivity"), this.enterIdle()) : this.startIdleTimeout(this.idleTimeoutMs - e3);
          }, e2), null === (r2 = (t2 = this.idleTimer).unref) || void 0 === r2 || r2.call(t2);
        }
        maybeStartIdleTimer() {
          this.connectivityState === g.ConnectivityState.SHUTDOWN || this.idleTimer || this.startIdleTimeout(this.idleTimeoutMs);
        }
        onCallStart() {
          this.channelzEnabled && this.callTracker.addCallStarted(), this.callCount += 1;
        }
        onCallEnd(e2) {
          this.channelzEnabled && (e2.code === l.Status.OK ? this.callTracker.addCallSucceeded() : this.callTracker.addCallFailed()), this.callCount -= 1, this.lastActivityTimestamp = /* @__PURE__ */ new Date(), this.maybeStartIdleTimer();
        }
        createLoadBalancingCall(e2, t2, r2, n2, i2) {
          const o2 = (0, S.getNextCallNumber)();
          return this.trace("createLoadBalancingCall [" + o2 + '] method="' + t2 + '"'), new y.LoadBalancingCall(this, e2, t2, r2, n2, i2, o2);
        }
        createRetryingCall(e2, t2, r2, n2, i2) {
          const o2 = (0, S.getNextCallNumber)();
          return this.trace("createRetryingCall [" + o2 + '] method="' + t2 + '"'), new C.RetryingCall(this, e2, t2, r2, n2, i2, o2, this.retryBufferTracker, E.get(this.getTarget()));
        }
        createInnerCall(e2, t2, r2, n2, i2) {
          return 0 === this.options["grpc.enable_retries"] ? this.createLoadBalancingCall(e2, t2, r2, n2, i2) : this.createRetryingCall(e2, t2, r2, n2, i2);
        }
        createResolvingCall(e2, t2, r2, n2, i2) {
          const o2 = (0, S.getNextCallNumber)();
          this.trace("createResolvingCall [" + o2 + '] method="' + e2 + '", deadline=' + (0, v.deadlineToString)(t2));
          const s2 = { deadline: t2, flags: null != i2 ? i2 : l.Propagate.DEFAULTS, host: null != r2 ? r2 : this.defaultAuthority, parentCall: n2 }, a2 = new b.ResolvingCall(this, e2, s2, this.filterStackFactory.clone(), this.credentials._getCallCredentials(), o2);
          return this.onCallStart(), a2.addStatusWatcher((e3) => {
            this.onCallEnd(e3);
          }), a2;
        }
        close() {
          this.resolvingLoadBalancer.destroy(), this.updateState(g.ConnectivityState.SHUTDOWN), this.currentPicker = new T();
          for (const e2 of this.configSelectionQueue) e2.cancelWithStatus(l.Status.UNAVAILABLE, "Channel closed before call started");
          this.configSelectionQueue = [];
          for (const e2 of this.pickQueue) e2.cancelWithStatus(l.Status.UNAVAILABLE, "Channel closed before call started");
          this.pickQueue = [], clearInterval(this.callRefTimer), this.idleTimer && clearTimeout(this.idleTimer), this.channelzEnabled && (0, m.unregisterChannelzRef)(this.channelzRef), this.subchannelPool.unrefUnusedSubchannels();
        }
        getTarget() {
          return (0, f.uriToString)(this.target);
        }
        getConnectivityState(e2) {
          const t2 = this.connectivityState;
          return e2 && (this.resolvingLoadBalancer.exitIdle(), this.lastActivityTimestamp = /* @__PURE__ */ new Date(), this.maybeStartIdleTimer()), t2;
        }
        watchConnectivityState(e2, t2, r2) {
          if (this.connectivityState === g.ConnectivityState.SHUTDOWN) throw new Error("Channel has been shut down");
          let n2 = null;
          if (t2 !== 1 / 0) {
            const e3 = t2 instanceof Date ? t2 : new Date(t2), o2 = /* @__PURE__ */ new Date();
            if (t2 === -1 / 0 || e3 <= o2) return void process.nextTick(r2, new Error("Deadline passed without connectivity state change"));
            n2 = setTimeout(() => {
              this.removeConnectivityStateWatcher(i2), r2(new Error("Deadline passed without connectivity state change"));
            }, e3.getTime() - o2.getTime());
          }
          const i2 = { currentState: e2, callback: r2, timer: n2 };
          this.connectivityStateWatchers.push(i2);
        }
        getChannelzRef() {
          return this.channelzRef;
        }
        createCall(e2, t2, r2, n2, i2) {
          if ("string" != typeof e2) throw new TypeError("Channel#createCall: method must be a string");
          if (!("number" == typeof t2 || t2 instanceof Date)) throw new TypeError("Channel#createCall: deadline must be a number or Date");
          if (this.connectivityState === g.ConnectivityState.SHUTDOWN) throw new Error("Channel has been shut down");
          return this.createResolvingCall(e2, t2, r2, n2, i2);
        }
        getOptions() {
          return this.options;
        }
      };
    }, 350: (e) => {
      e.exports = d;
      var t = /[\s{}=;:[\],'"()<>]/g, r = /(?:"([^"\\]*(?:\\.[^"\\]*)*)")/g, n = /(?:'([^'\\]*(?:\\.[^'\\]*)*)')/g, i = /^ *[*/]+ */, o = /^\s*\*?\/*/, s = /\n/g, a = /\s/, l = /\\(.?)/g, c = { 0: "\0", r: "\r", n: "\n", t: "	" };
      function u(e2) {
        return e2.replace(l, function(e3, t2) {
          switch (t2) {
            case "\\":
            case "":
              return t2;
            default:
              return c[t2] || "";
          }
        });
      }
      function d(e2, l2) {
        e2 = e2.toString();
        var c2 = 0, d2 = e2.length, p = 1, h = 0, f = {}, g = [], m = null;
        function y(e3) {
          return Error("illegal " + e3 + " (line " + p + ")");
        }
        function v(t2) {
          return e2.charAt(t2);
        }
        function b(t2, r2, n2) {
          var a2, c3 = { type: e2.charAt(t2++), lineEmpty: false, leading: n2 }, u2 = t2 - (l2 ? 2 : 3);
          do {
            if (--u2 < 0 || "\n" === (a2 = e2.charAt(u2))) {
              c3.lineEmpty = true;
              break;
            }
          } while (" " === a2 || "	" === a2);
          for (var d3 = e2.substring(t2, r2).split(s), g2 = 0; g2 < d3.length; ++g2) d3[g2] = d3[g2].replace(l2 ? o : i, "").trim();
          c3.text = d3.join("\n").trim(), f[p] = c3, h = p;
        }
        function S(t2) {
          var r2 = w(t2), n2 = e2.substring(t2, r2);
          return /^\s*\/\//.test(n2);
        }
        function w(e3) {
          for (var t2 = e3; t2 < d2 && "\n" !== v(t2); ) t2++;
          return t2;
        }
        function C() {
          if (g.length > 0) return g.shift();
          if (m) return (function() {
            var t2 = "'" === m ? n : r;
            t2.lastIndex = c2 - 1;
            var i3 = t2.exec(e2);
            if (!i3) throw y("string");
            return c2 = t2.lastIndex, _2(m), m = null, u(i3[1]);
          })();
          var i2, o2, s2, h2, f2, C2 = 0 === c2;
          do {
            if (c2 === d2) return null;
            for (i2 = false; a.test(s2 = v(c2)); ) if ("\n" === s2 && (C2 = true, ++p), ++c2 === d2) return null;
            if ("/" === v(c2)) {
              if (++c2 === d2) throw y("comment");
              if ("/" === v(c2)) if (l2) {
                if (h2 = c2, f2 = false, S(c2 - 1)) {
                  f2 = true;
                  do {
                    if ((c2 = w(c2)) === d2) break;
                    if (c2++, !C2) break;
                  } while (S(c2));
                } else c2 = Math.min(d2, w(c2) + 1);
                f2 && (b(h2, c2, C2), C2 = true), p++, i2 = true;
              } else {
                for (f2 = "/" === v(h2 = c2 + 1); "\n" !== v(++c2); ) if (c2 === d2) return null;
                ++c2, f2 && (b(h2, c2 - 1, C2), C2 = true), ++p, i2 = true;
              }
              else {
                if ("*" !== (s2 = v(c2))) return "/";
                h2 = c2 + 1, f2 = l2 || "*" === v(h2);
                do {
                  if ("\n" === s2 && ++p, ++c2 === d2) throw y("comment");
                  o2 = s2, s2 = v(c2);
                } while ("*" !== o2 || "/" !== s2);
                ++c2, f2 && (b(h2, c2 - 2, C2), C2 = true), i2 = true;
              }
            }
          } while (i2);
          var E2 = c2;
          if (t.lastIndex = 0, !t.test(v(E2++))) for (; E2 < d2 && !t.test(v(E2)); ) ++E2;
          var R = e2.substring(c2, c2 = E2);
          return '"' !== R && "'" !== R || (m = R), R;
        }
        function _2(e3) {
          g.push(e3);
        }
        function E() {
          if (!g.length) {
            var e3 = C();
            if (null === e3) return null;
            _2(e3);
          }
          return g[0];
        }
        return Object.defineProperty({ next: C, peek: E, push: _2, skip: function(e3, t2) {
          var r2 = E();
          if (r2 === e3) return C(), true;
          if (!t2) throw y("token '" + r2 + "', '" + e3 + "' expected");
          return false;
        }, cmnt: function(e3) {
          var t2, r2 = null;
          return void 0 === e3 ? (t2 = f[p - 1], delete f[p - 1], t2 && (l2 || "*" === t2.type || t2.lineEmpty) && (r2 = t2.leading ? t2.text : null)) : (h < e3 && E(), t2 = f[e3], delete f[e3], !t2 || t2.lineEmpty || !l2 && "/" !== t2.type || (r2 = t2.leading ? null : t2.text)), r2;
        } }, "line", { get: function() {
          return p;
        } });
      }
      d.unescape = u;
    }, 570: (e) => {
      e.exports = JSON.parse('{"nested":{"google":{"nested":{"protobuf":{"options":{"go_package":"google.golang.org/protobuf/types/descriptorpb","java_package":"com.google.protobuf","java_outer_classname":"DescriptorProtos","csharp_namespace":"Google.Protobuf.Reflection","objc_class_prefix":"GPB","cc_enable_arenas":true,"optimize_for":"SPEED"},"nested":{"FileDescriptorSet":{"edition":"proto2","fields":{"file":{"rule":"repeated","type":"FileDescriptorProto","id":1}},"extensions":[[536000000,536000000]]},"Edition":{"edition":"proto2","values":{"EDITION_UNKNOWN":0,"EDITION_LEGACY":900,"EDITION_PROTO2":998,"EDITION_PROTO3":999,"EDITION_2023":1000,"EDITION_2024":1001,"EDITION_1_TEST_ONLY":1,"EDITION_2_TEST_ONLY":2,"EDITION_99997_TEST_ONLY":99997,"EDITION_99998_TEST_ONLY":99998,"EDITION_99999_TEST_ONLY":99999,"EDITION_MAX":2147483647}},"FileDescriptorProto":{"edition":"proto2","fields":{"name":{"type":"string","id":1},"package":{"type":"string","id":2},"dependency":{"rule":"repeated","type":"string","id":3},"publicDependency":{"rule":"repeated","type":"int32","id":10},"weakDependency":{"rule":"repeated","type":"int32","id":11},"optionDependency":{"rule":"repeated","type":"string","id":15},"messageType":{"rule":"repeated","type":"DescriptorProto","id":4},"enumType":{"rule":"repeated","type":"EnumDescriptorProto","id":5},"service":{"rule":"repeated","type":"ServiceDescriptorProto","id":6},"extension":{"rule":"repeated","type":"FieldDescriptorProto","id":7},"options":{"type":"FileOptions","id":8},"sourceCodeInfo":{"type":"SourceCodeInfo","id":9},"syntax":{"type":"string","id":12},"edition":{"type":"Edition","id":14}}},"DescriptorProto":{"edition":"proto2","fields":{"name":{"type":"string","id":1},"field":{"rule":"repeated","type":"FieldDescriptorProto","id":2},"extension":{"rule":"repeated","type":"FieldDescriptorProto","id":6},"nestedType":{"rule":"repeated","type":"DescriptorProto","id":3},"enumType":{"rule":"repeated","type":"EnumDescriptorProto","id":4},"extensionRange":{"rule":"repeated","type":"ExtensionRange","id":5},"oneofDecl":{"rule":"repeated","type":"OneofDescriptorProto","id":8},"options":{"type":"MessageOptions","id":7},"reservedRange":{"rule":"repeated","type":"ReservedRange","id":9},"reservedName":{"rule":"repeated","type":"string","id":10},"visibility":{"type":"SymbolVisibility","id":11}},"nested":{"ExtensionRange":{"fields":{"start":{"type":"int32","id":1},"end":{"type":"int32","id":2},"options":{"type":"ExtensionRangeOptions","id":3}}},"ReservedRange":{"fields":{"start":{"type":"int32","id":1},"end":{"type":"int32","id":2}}}}},"ExtensionRangeOptions":{"edition":"proto2","fields":{"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999},"declaration":{"rule":"repeated","type":"Declaration","id":2,"options":{"retention":"RETENTION_SOURCE"}},"features":{"type":"FeatureSet","id":50},"verification":{"type":"VerificationState","id":3,"options":{"default":"UNVERIFIED","retention":"RETENTION_SOURCE"}}},"extensions":[[1000,536870911]],"nested":{"Declaration":{"fields":{"number":{"type":"int32","id":1},"fullName":{"type":"string","id":2},"type":{"type":"string","id":3},"reserved":{"type":"bool","id":5},"repeated":{"type":"bool","id":6}},"reserved":[[4,4]]},"VerificationState":{"values":{"DECLARATION":0,"UNVERIFIED":1}}}},"FieldDescriptorProto":{"edition":"proto2","fields":{"name":{"type":"string","id":1},"number":{"type":"int32","id":3},"label":{"type":"Label","id":4},"type":{"type":"Type","id":5},"typeName":{"type":"string","id":6},"extendee":{"type":"string","id":2},"defaultValue":{"type":"string","id":7},"oneofIndex":{"type":"int32","id":9},"jsonName":{"type":"string","id":10},"options":{"type":"FieldOptions","id":8},"proto3Optional":{"type":"bool","id":17}},"nested":{"Type":{"values":{"TYPE_DOUBLE":1,"TYPE_FLOAT":2,"TYPE_INT64":3,"TYPE_UINT64":4,"TYPE_INT32":5,"TYPE_FIXED64":6,"TYPE_FIXED32":7,"TYPE_BOOL":8,"TYPE_STRING":9,"TYPE_GROUP":10,"TYPE_MESSAGE":11,"TYPE_BYTES":12,"TYPE_UINT32":13,"TYPE_ENUM":14,"TYPE_SFIXED32":15,"TYPE_SFIXED64":16,"TYPE_SINT32":17,"TYPE_SINT64":18}},"Label":{"values":{"LABEL_OPTIONAL":1,"LABEL_REPEATED":3,"LABEL_REQUIRED":2}}}},"OneofDescriptorProto":{"edition":"proto2","fields":{"name":{"type":"string","id":1},"options":{"type":"OneofOptions","id":2}}},"EnumDescriptorProto":{"edition":"proto2","fields":{"name":{"type":"string","id":1},"value":{"rule":"repeated","type":"EnumValueDescriptorProto","id":2},"options":{"type":"EnumOptions","id":3},"reservedRange":{"rule":"repeated","type":"EnumReservedRange","id":4},"reservedName":{"rule":"repeated","type":"string","id":5},"visibility":{"type":"SymbolVisibility","id":6}},"nested":{"EnumReservedRange":{"fields":{"start":{"type":"int32","id":1},"end":{"type":"int32","id":2}}}}},"EnumValueDescriptorProto":{"edition":"proto2","fields":{"name":{"type":"string","id":1},"number":{"type":"int32","id":2},"options":{"type":"EnumValueOptions","id":3}}},"ServiceDescriptorProto":{"edition":"proto2","fields":{"name":{"type":"string","id":1},"method":{"rule":"repeated","type":"MethodDescriptorProto","id":2},"options":{"type":"ServiceOptions","id":3}}},"MethodDescriptorProto":{"edition":"proto2","fields":{"name":{"type":"string","id":1},"inputType":{"type":"string","id":2},"outputType":{"type":"string","id":3},"options":{"type":"MethodOptions","id":4},"clientStreaming":{"type":"bool","id":5},"serverStreaming":{"type":"bool","id":6}}},"FileOptions":{"edition":"proto2","fields":{"javaPackage":{"type":"string","id":1},"javaOuterClassname":{"type":"string","id":8},"javaMultipleFiles":{"type":"bool","id":10},"javaGenerateEqualsAndHash":{"type":"bool","id":20,"options":{"deprecated":true}},"javaStringCheckUtf8":{"type":"bool","id":27},"optimizeFor":{"type":"OptimizeMode","id":9,"options":{"default":"SPEED"}},"goPackage":{"type":"string","id":11},"ccGenericServices":{"type":"bool","id":16},"javaGenericServices":{"type":"bool","id":17},"pyGenericServices":{"type":"bool","id":18},"deprecated":{"type":"bool","id":23},"ccEnableArenas":{"type":"bool","id":31,"options":{"default":true}},"objcClassPrefix":{"type":"string","id":36},"csharpNamespace":{"type":"string","id":37},"swiftPrefix":{"type":"string","id":39},"phpClassPrefix":{"type":"string","id":40},"phpNamespace":{"type":"string","id":41},"phpMetadataNamespace":{"type":"string","id":44},"rubyPackage":{"type":"string","id":45},"features":{"type":"FeatureSet","id":50},"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999}},"extensions":[[1000,536870911]],"reserved":[[42,42],"php_generic_services",[38,38]],"nested":{"OptimizeMode":{"values":{"SPEED":1,"CODE_SIZE":2,"LITE_RUNTIME":3}}}},"MessageOptions":{"edition":"proto2","fields":{"messageSetWireFormat":{"type":"bool","id":1},"noStandardDescriptorAccessor":{"type":"bool","id":2},"deprecated":{"type":"bool","id":3},"mapEntry":{"type":"bool","id":7},"deprecatedLegacyJsonFieldConflicts":{"type":"bool","id":11,"options":{"deprecated":true}},"features":{"type":"FeatureSet","id":12},"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999}},"extensions":[[1000,536870911]],"reserved":[[4,4],[5,5],[6,6],[8,8],[9,9]]},"FieldOptions":{"edition":"proto2","fields":{"ctype":{"type":"CType","id":1,"options":{"default":"STRING"}},"packed":{"type":"bool","id":2},"jstype":{"type":"JSType","id":6,"options":{"default":"JS_NORMAL"}},"lazy":{"type":"bool","id":5},"unverifiedLazy":{"type":"bool","id":15},"deprecated":{"type":"bool","id":3},"weak":{"type":"bool","id":10,"options":{"deprecated":true}},"debugRedact":{"type":"bool","id":16},"retention":{"type":"OptionRetention","id":17},"targets":{"rule":"repeated","type":"OptionTargetType","id":19},"editionDefaults":{"rule":"repeated","type":"EditionDefault","id":20},"features":{"type":"FeatureSet","id":21},"featureSupport":{"type":"FeatureSupport","id":22},"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999}},"extensions":[[1000,536870911]],"reserved":[[4,4],[18,18]],"nested":{"CType":{"values":{"STRING":0,"CORD":1,"STRING_PIECE":2}},"JSType":{"values":{"JS_NORMAL":0,"JS_STRING":1,"JS_NUMBER":2}},"OptionRetention":{"values":{"RETENTION_UNKNOWN":0,"RETENTION_RUNTIME":1,"RETENTION_SOURCE":2}},"OptionTargetType":{"values":{"TARGET_TYPE_UNKNOWN":0,"TARGET_TYPE_FILE":1,"TARGET_TYPE_EXTENSION_RANGE":2,"TARGET_TYPE_MESSAGE":3,"TARGET_TYPE_FIELD":4,"TARGET_TYPE_ONEOF":5,"TARGET_TYPE_ENUM":6,"TARGET_TYPE_ENUM_ENTRY":7,"TARGET_TYPE_SERVICE":8,"TARGET_TYPE_METHOD":9}},"EditionDefault":{"fields":{"edition":{"type":"Edition","id":3},"value":{"type":"string","id":2}}},"FeatureSupport":{"fields":{"editionIntroduced":{"type":"Edition","id":1},"editionDeprecated":{"type":"Edition","id":2},"deprecationWarning":{"type":"string","id":3},"editionRemoved":{"type":"Edition","id":4}}}}},"OneofOptions":{"edition":"proto2","fields":{"features":{"type":"FeatureSet","id":1},"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999}},"extensions":[[1000,536870911]]},"EnumOptions":{"edition":"proto2","fields":{"allowAlias":{"type":"bool","id":2},"deprecated":{"type":"bool","id":3},"deprecatedLegacyJsonFieldConflicts":{"type":"bool","id":6,"options":{"deprecated":true}},"features":{"type":"FeatureSet","id":7},"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999}},"extensions":[[1000,536870911]],"reserved":[[5,5]]},"EnumValueOptions":{"edition":"proto2","fields":{"deprecated":{"type":"bool","id":1},"features":{"type":"FeatureSet","id":2},"debugRedact":{"type":"bool","id":3},"featureSupport":{"type":"FieldOptions.FeatureSupport","id":4},"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999}},"extensions":[[1000,536870911]]},"ServiceOptions":{"edition":"proto2","fields":{"features":{"type":"FeatureSet","id":34},"deprecated":{"type":"bool","id":33},"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999}},"extensions":[[1000,536870911]]},"MethodOptions":{"edition":"proto2","fields":{"deprecated":{"type":"bool","id":33},"idempotencyLevel":{"type":"IdempotencyLevel","id":34,"options":{"default":"IDEMPOTENCY_UNKNOWN"}},"features":{"type":"FeatureSet","id":35},"uninterpretedOption":{"rule":"repeated","type":"UninterpretedOption","id":999}},"extensions":[[1000,536870911]],"nested":{"IdempotencyLevel":{"values":{"IDEMPOTENCY_UNKNOWN":0,"NO_SIDE_EFFECTS":1,"IDEMPOTENT":2}}}},"UninterpretedOption":{"edition":"proto2","fields":{"name":{"rule":"repeated","type":"NamePart","id":2},"identifierValue":{"type":"string","id":3},"positiveIntValue":{"type":"uint64","id":4},"negativeIntValue":{"type":"int64","id":5},"doubleValue":{"type":"double","id":6},"stringValue":{"type":"bytes","id":7},"aggregateValue":{"type":"string","id":8}},"nested":{"NamePart":{"fields":{"namePart":{"rule":"required","type":"string","id":1},"isExtension":{"rule":"required","type":"bool","id":2}}}}},"FeatureSet":{"edition":"proto2","fields":{"fieldPresence":{"type":"FieldPresence","id":1,"options":{"retention":"RETENTION_RUNTIME","targets":"TARGET_TYPE_FILE","feature_support.edition_introduced":"EDITION_2023","edition_defaults.edition":"EDITION_2023","edition_defaults.value":"EXPLICIT"}},"enumType":{"type":"EnumType","id":2,"options":{"retention":"RETENTION_RUNTIME","targets":"TARGET_TYPE_FILE","feature_support.edition_introduced":"EDITION_2023","edition_defaults.edition":"EDITION_PROTO3","edition_defaults.value":"OPEN"}},"repeatedFieldEncoding":{"type":"RepeatedFieldEncoding","id":3,"options":{"retention":"RETENTION_RUNTIME","targets":"TARGET_TYPE_FILE","feature_support.edition_introduced":"EDITION_2023","edition_defaults.edition":"EDITION_PROTO3","edition_defaults.value":"PACKED"}},"utf8Validation":{"type":"Utf8Validation","id":4,"options":{"retention":"RETENTION_RUNTIME","targets":"TARGET_TYPE_FILE","feature_support.edition_introduced":"EDITION_2023","edition_defaults.edition":"EDITION_PROTO3","edition_defaults.value":"VERIFY"}},"messageEncoding":{"type":"MessageEncoding","id":5,"options":{"retention":"RETENTION_RUNTIME","targets":"TARGET_TYPE_FILE","feature_support.edition_introduced":"EDITION_2023","edition_defaults.edition":"EDITION_LEGACY","edition_defaults.value":"LENGTH_PREFIXED"}},"jsonFormat":{"type":"JsonFormat","id":6,"options":{"retention":"RETENTION_RUNTIME","targets":"TARGET_TYPE_FILE","feature_support.edition_introduced":"EDITION_2023","edition_defaults.edition":"EDITION_PROTO3","edition_defaults.value":"ALLOW"}},"enforceNamingStyle":{"type":"EnforceNamingStyle","id":7,"options":{"retention":"RETENTION_SOURCE","targets":"TARGET_TYPE_METHOD","feature_support.edition_introduced":"EDITION_2024","edition_defaults.edition":"EDITION_2024","edition_defaults.value":"STYLE2024"}},"defaultSymbolVisibility":{"type":"VisibilityFeature.DefaultSymbolVisibility","id":8,"options":{"retention":"RETENTION_SOURCE","targets":"TARGET_TYPE_FILE","feature_support.edition_introduced":"EDITION_2024","edition_defaults.edition":"EDITION_2024","edition_defaults.value":"EXPORT_TOP_LEVEL"}}},"extensions":[[1000,9994],[9995,9999],[10000,10000]],"reserved":[[999,999]],"nested":{"FieldPresence":{"values":{"FIELD_PRESENCE_UNKNOWN":0,"EXPLICIT":1,"IMPLICIT":2,"LEGACY_REQUIRED":3}},"EnumType":{"values":{"ENUM_TYPE_UNKNOWN":0,"OPEN":1,"CLOSED":2}},"RepeatedFieldEncoding":{"values":{"REPEATED_FIELD_ENCODING_UNKNOWN":0,"PACKED":1,"EXPANDED":2}},"Utf8Validation":{"values":{"UTF8_VALIDATION_UNKNOWN":0,"VERIFY":2,"NONE":3}},"MessageEncoding":{"values":{"MESSAGE_ENCODING_UNKNOWN":0,"LENGTH_PREFIXED":1,"DELIMITED":2}},"JsonFormat":{"values":{"JSON_FORMAT_UNKNOWN":0,"ALLOW":1,"LEGACY_BEST_EFFORT":2}},"EnforceNamingStyle":{"values":{"ENFORCE_NAMING_STYLE_UNKNOWN":0,"STYLE2024":1,"STYLE_LEGACY":2}},"VisibilityFeature":{"fields":{},"reserved":[[1,536870911]],"nested":{"DefaultSymbolVisibility":{"values":{"DEFAULT_SYMBOL_VISIBILITY_UNKNOWN":0,"EXPORT_ALL":1,"EXPORT_TOP_LEVEL":2,"LOCAL_ALL":3,"STRICT":4}}}}}},"FeatureSetDefaults":{"edition":"proto2","fields":{"defaults":{"rule":"repeated","type":"FeatureSetEditionDefault","id":1},"minimumEdition":{"type":"Edition","id":4},"maximumEdition":{"type":"Edition","id":5}},"nested":{"FeatureSetEditionDefault":{"fields":{"edition":{"type":"Edition","id":3},"overridableFeatures":{"type":"FeatureSet","id":4},"fixedFeatures":{"type":"FeatureSet","id":5}},"reserved":[[1,1],[2,2],"features"]}}},"SourceCodeInfo":{"edition":"proto2","fields":{"location":{"rule":"repeated","type":"Location","id":1}},"extensions":[[536000000,536000000]],"nested":{"Location":{"fields":{"path":{"rule":"repeated","type":"int32","id":1,"options":{"packed":true}},"span":{"rule":"repeated","type":"int32","id":2,"options":{"packed":true}},"leadingComments":{"type":"string","id":3},"trailingComments":{"type":"string","id":4},"leadingDetachedComments":{"rule":"repeated","type":"string","id":6}}}}},"GeneratedCodeInfo":{"edition":"proto2","fields":{"annotation":{"rule":"repeated","type":"Annotation","id":1}},"nested":{"Annotation":{"fields":{"path":{"rule":"repeated","type":"int32","id":1,"options":{"packed":true}},"sourceFile":{"type":"string","id":2},"begin":{"type":"int32","id":3},"end":{"type":"int32","id":4},"semantic":{"type":"Semantic","id":5}},"nested":{"Semantic":{"values":{"NONE":0,"SET":1,"ALIAS":2}}}}}},"SymbolVisibility":{"edition":"proto2","values":{"VISIBILITY_UNSET":0,"VISIBILITY_LOCAL":1,"VISIBILITY_EXPORT":2}}}}}}}}');
    }, 626: (e) => {
      function t(e2, t2) {
        return t2;
      }
      e.exports = function() {
        const e2 = Error.prepareStackTrace;
        Error.prepareStackTrace = t;
        const r = new Error().stack;
        if (Error.prepareStackTrace = e2, !Array.isArray(r)) return;
        const n = r.slice(2), i = [];
        for (const e3 of n) e3 && i.push(e3.getFileName());
        return i;
      };
    }, 647: function(e, t, r) {
      var n = this && this.__awaiter || function(e2, t2, r2, n2) {
        return new (r2 || (r2 = Promise))(function(i2, o2) {
          function s2(e3) {
            try {
              l2(n2.next(e3));
            } catch (e4) {
              o2(e4);
            }
          }
          function a2(e3) {
            try {
              l2(n2.throw(e3));
            } catch (e4) {
              o2(e4);
            }
          }
          function l2(e3) {
            var t3;
            e3.done ? i2(e3.value) : (t3 = e3.value, t3 instanceof r2 ? t3 : new r2(function(e4) {
              e4(t3);
            })).then(s2, a2);
          }
          l2((n2 = n2.apply(e2, t2 || [])).next());
        });
      };
      Object.defineProperty(t, "__esModule", { value: true }), t.EditOperationType = t.EditStats = t.ChangeKind = void 0, t.del = d, t.insert = p, t.overwrite = h, t.replace = f, t.editOptimizer = g, t.editSimple = function(e2, t2, r2, i2, o2) {
        return n(this, void 0, void 0, function* () {
          const n2 = g(r2, i2, t2);
          let s2 = 0;
          if (n2) {
            1 < n2.length && (yield (0, a.beginSessionTransaction)(e2));
            for (let t3 = 0; t3 < n2.length; ++t3) s2 = yield f(e2, n2[t3].offset, n2[t3].remove_bytes_count, n2[t3].replacement, o2);
            1 < n2.length && (yield (0, a.endSessionTransaction)(e2));
          }
          return Promise.resolve(s2);
        });
      }, t.undo = function(e2, t2) {
        return n(this, void 0, void 0, function* () {
          const r2 = (0, s.getLogger)(), n2 = new i.ObjectId().setId(e2);
          r2.debug({ fn: "undo", rqst: n2.toObject() });
          const a2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            a2.undoLastChange(n2, (n3, o2) => {
              if (n3) return t2 && ++t2.error_count, r2.error({ fn: "undo", err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(new Error("undo failed: " + n3));
              const s2 = o2.getSerial();
              return 0 === s2 ? (t2 && ++t2.error_count, r2.error({ fn: "undo", err: { resp: o2.toObject() } }), i2(new Error("undo failed"))) : (t2 && ++t2.undo_count, r2.debug({ fn: "undo", resp: o2.toObject() }), e3(s2));
            });
          });
        });
      }, t.redo = function(e2, t2) {
        return n(this, void 0, void 0, function* () {
          const r2 = (0, s.getLogger)(), n2 = new i.ObjectId().setId(e2);
          r2.debug({ fn: "redo", rqst: n2.toObject() });
          const a2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            a2.redoLastUndo(n2, (n3, o2) => {
              if (n3) return t2 && ++t2.error_count, r2.error({ fn: "redo", err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(new Error("redo failed: " + n3));
              const s2 = o2.getSerial();
              return 0 === s2 ? (t2 && ++t2.error_count, r2.error({ fn: "redo", err: { resp: o2.toObject() } }), i2(new Error("redo failed"))) : (t2 && ++t2.redo_count, r2.debug({ fn: "redo", resp: o2.toObject() }), e3(s2));
            });
          });
        });
      }, t.clear = function(e2, t2) {
        return n(this, void 0, void 0, function* () {
          const r2 = (0, s.getLogger)(), n2 = new i.ObjectId().setId(e2);
          r2.debug({ fn: "clear", rqst: n2.toObject() });
          const a2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            a2.clearChanges(n2, (o2, s2) => o2 ? (t2 && ++t2.error_count, r2.error({ fn: "clear", rqst: n2.toObject(), err: { msg: o2.message, details: o2.details, code: o2.code, stack: o2.stack } }), i2(new Error("clear failed: " + o2))) : (t2 && ++t2.clear_count, r2.debug({ fn: "clear", resp: s2.toObject() }), e3(s2.getId())));
          });
        });
      }, t.getLastChange = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, s.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "getLastChange", rqst: r2.toObject() });
          const n2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            n2.getLastChange(r2, (r3, n3) => r3 ? (t2.error({ fn: "getLastChange", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), i2(new Error("getLastChange failed: " + r3))) : (t2.debug({ fn: "getLastChange", resp: n3.toObject() }), e3(n3)));
          });
        });
      }, t.getLastUndo = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, s.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "getLastUndo", rqst: r2.toObject() });
          const n2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            n2.getLastUndo(r2, (r3, n3) => r3 ? (t2.error({ fn: "getLastUndo", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), i2(new Error("getLastUndo failed: " + r3))) : (t2.debug({ fn: "getLastUndo", resp: n3.toObject() }), e3(n3)));
          });
        });
      }, t.getChangeCount = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, s.getLogger)(), r2 = new i.CountRequest().setSessionId(e2).setKindList([i.CountKind.COUNT_CHANGES]);
          t2.debug({ fn: "getChangeCount", rqst: r2.toObject() });
          const n2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            n2.getCount(r2, (r3, n3) => r3 ? (t2.error({ fn: "getChangeCount", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), i2(new Error("getChangeCount failed: " + r3))) : (t2.debug({ fn: "getChangeCount", resp: n3.toObject() }), e3(n3.getCountsList()[0].getCount())));
          });
        });
      }, t.getUndoCount = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, s.getLogger)(), r2 = new i.CountRequest().setSessionId(e2).setKindList([i.CountKind.COUNT_UNDOS]);
          t2.debug({ fn: "getUndoCount", rqst: r2.toObject() });
          const n2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            n2.getCount(r2, (r3, n3) => r3 ? (t2.error({ fn: "getUndoCount", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), i2(new Error("getUndoCount failed: " + r3))) : (t2.debug({ fn: "getUndoCount", resp: n3.toObject() }), e3(n3.getCountsList()[0].getCount())));
          });
        });
      }, t.getChangeTransactionCount = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, s.getLogger)(), r2 = new i.CountRequest().setSessionId(e2).setKindList([i.CountKind.COUNT_CHANGE_TRANSACTIONS]);
          t2.debug({ fn: "getChangeTransactionCount", rqst: r2.toObject() });
          const n2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            n2.getCount(r2, (r3, n3) => r3 ? (t2.error({ fn: "getChangeTransactionCount", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), i2(new Error("getChangeTransactionCount failed: " + r3))) : (t2.debug({ fn: "getChangeTransactionCount", resp: n3.toObject() }), e3(n3.getCountsList()[0].getCount())));
          });
        });
      }, t.getUndoTransactionCount = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, s.getLogger)(), r2 = new i.CountRequest().setSessionId(e2).setKindList([i.CountKind.COUNT_UNDO_TRANSACTIONS]);
          t2.debug({ fn: "getUndoTransactionCount", rqst: r2.toObject() });
          const n2 = yield (0, o.getClient)();
          return new Promise((e3, i2) => {
            n2.getCount(r2, (r3, n3) => r3 ? (t2.error({ fn: "getUndoTransactionCount", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), i2(new Error("getUndoTransactionCount failed: " + r3))) : (t2.debug({ fn: "getUndoTransactionCount", resp: n3.toObject() }), e3(n3.getCountsList()[0].getCount())));
          });
        });
      }, t.concatUint8Arrays = m, t.removeCommonSuffix = y, t.editOperations = v, t.edit = function(e2, t2, r2, i2, o2) {
        return n(this, void 0, void 0, function* () {
          const n2 = v(r2, i2, t2);
          let s2 = 0;
          if (n2) {
            1 < n2.length && (yield (0, a.beginSessionTransaction)(e2), yield (0, l.pauseViewportEvents)(e2));
            for (let t3 = 0; t3 < n2.length; ++t3) switch (n2[t3].type) {
              case c.Insert:
                s2 = yield p(e2, n2[t3].start, n2[t3].data, o2);
                break;
              case c.Delete:
                s2 = yield d(e2, n2[t3].start, n2[t3].length, o2);
                break;
              case c.Overwrite:
                s2 = yield h(e2, n2[t3].start, n2[t3].data, o2);
                break;
              default:
                throw new Error("Unknown edit operation type");
            }
            1 < n2.length && (yield (0, l.resumeViewportEvents)(e2), yield (0, a.endSessionTransaction)(e2), yield (0, a.notifyChangedViewports)(e2));
          }
          return Promise.resolve(s2);
        });
      };
      const i = r(8039), o = r(7248), s = r(8943), a = r(1687), l = r(3197);
      var c, u = r(8039);
      function d(e2, t2, r2, a2) {
        return n(this, void 0, void 0, function* () {
          const n2 = (0, s.getLogger)(), l2 = new i.ChangeRequest().setSessionId(e2).setKind(i.ChangeKind.CHANGE_DELETE).setOffset(t2).setLength(r2);
          n2.debug({ fn: "del", rqst: l2.toObject() });
          const c2 = yield (0, o.getClient)();
          return new Promise((e3, t3) => {
            c2.submitChange(l2, (r3, i2) => {
              if (r3) return a2 && ++a2.error_count, n2.error({ fn: "del", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3(new Error("del failed: " + r3));
              const o2 = i2.getSerial();
              return 0 === o2 ? (a2 && ++a2.error_count, n2.error({ fn: "del", err: { resp: i2.toObject() } }), t3(new Error("del failed"))) : (a2 && ++a2.delete_count, n2.debug({ fn: "del", resp: i2.toObject() }), e3(o2));
            });
          });
        });
      }
      function p(e2, t2, r2, a2) {
        return n(this, void 0, void 0, function* () {
          const n2 = (0, s.getLogger)(), l2 = new i.ChangeRequest().setSessionId(e2).setKind(i.ChangeKind.CHANGE_INSERT).setOffset(t2).setData(r2).setLength(r2.length);
          n2.debug({ fn: "insert", rqst: l2.toObject() });
          const c2 = yield (0, o.getClient)();
          return new Promise((e3, t3) => {
            c2.submitChange(l2, (r3, i2) => {
              if (r3) return a2 && ++a2.error_count, n2.error({ fn: "insert", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3(new Error("insert failed: " + r3));
              const o2 = i2.getSerial();
              return 0 === o2 ? (a2 && ++a2.error_count, n2.error({ fn: "insert", err: { resp: i2.toObject() } }), t3(new Error("insert failed"))) : (a2 && ++a2.insert_count, n2.debug({ fn: "insert", resp: i2.toObject() }), e3(o2));
            });
          });
        });
      }
      function h(e2, t2, r2, a2) {
        return n(this, void 0, void 0, function* () {
          const n2 = (0, s.getLogger)(), l2 = new i.ChangeRequest().setSessionId(e2).setKind(i.ChangeKind.CHANGE_OVERWRITE).setOffset(t2).setData(r2).setLength(r2.length);
          n2.debug({ fn: "overwrite", rqst: l2.toObject() });
          const c2 = yield (0, o.getClient)();
          return new Promise((e3, t3) => {
            c2.submitChange(l2, (r3, i2) => {
              if (r3) return a2 && ++a2.error_count, n2.error({ fn: "overwrite", err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3(new Error("overwrite failed: " + r3));
              const o2 = i2.getSerial();
              return 0 === o2 ? (a2 && ++a2.error_count, n2.error({ fn: "overwrite", err: { resp: i2.toObject() } }), t3(new Error("overwrite failed"))) : (a2 && ++a2.overwrite_count, n2.debug({ fn: "overwrite", resp: i2.toObject() }), e3(o2));
            });
          });
        });
      }
      function f(e2, t2, r2, i2, o2) {
        return 0 === r2 ? p(e2, t2, i2, o2) : 0 === i2.length ? d(e2, t2, r2, o2) : i2.length === r2 ? h(e2, t2, i2, o2) : new Promise((s2) => n(this, void 0, void 0, function* () {
          yield (0, a.beginSessionTransaction)(e2), yield d(e2, t2, r2, o2);
          const n2 = yield p(e2, t2, i2, o2);
          yield (0, a.endSessionTransaction)(e2), s2(n2);
        }));
      }
      function g(e2, t2, r2 = 0) {
        let n2 = 0, i2 = 0;
        for (; n2 < e2.length && n2 < t2.length && e2[n2] === t2[n2]; ) ++n2;
        if (n2 === e2.length && n2 === t2.length) return null;
        for (; i2 < e2.length - n2 && i2 < t2.length - n2 && e2[e2.length - 1 - i2] === t2[t2.length - 1 - i2]; ) ++i2;
        return [{ offset: r2 + n2, remove_bytes_count: e2.length - n2 - i2, replacement: t2.slice(n2, t2.length - i2) }];
      }
      function m(e2, t2) {
        const r2 = new Uint8Array(e2.length + t2.length);
        return r2.set(e2), r2.set(t2, e2.length), r2;
      }
      function y(e2, t2) {
        let r2 = e2.length - 1, n2 = t2.length - 1;
        for (; r2 >= 0 && n2 >= 0 && e2[r2] === t2[n2]; ) r2--, n2--;
        return [e2.subarray(0, r2 + 1), t2.subarray(0, n2 + 1)];
      }
      function v(e2, t2, r2 = 0) {
        var n2, i2, o2, s2, a2, l2, u2;
        if (0 === e2.length) return 0 === t2.length ? [] : [{ type: c.Insert, start: r2, data: t2 }];
        if (0 === t2.length) return [{ type: c.Delete, start: r2, length: e2.length }];
        [e2, t2] = y(e2, t2);
        const d2 = e2.length, p2 = t2.length, h2 = Math.max(d2, p2), f2 = [];
        let g2;
        for (let n3 = 0; n3 < h2; n3++) {
          if (!(n3 < d2 && n3 < p2)) {
            if (n3 < d2) {
              const e3 = g2 && g2.type === c.Delete ? g2.start : n3;
              f2.push({ type: c.Delete, start: r2 + e3, length: d2 - e3 }), g2 = f2[f2.length - 1];
              break;
            }
            f2.push({ type: c.Insert, start: r2 + n3, data: t2.subarray(n3) }), g2 = f2[f2.length - 1];
            break;
          }
          e2[n3] !== t2[n3] && (g2 && g2.type === c.Overwrite && g2.start + g2.data.length === n3 ? g2.data = m(g2.data, new Uint8Array([t2[n3]])) : (f2.push({ type: c.Overwrite, start: r2 + n3, data: new Uint8Array([t2[n3]]) }), g2 = f2[f2.length - 1]));
        }
        for (let e3 = 0; e3 < f2.length - 1; e3++) {
          const t3 = f2[e3], r3 = f2[e3 + 1];
          t3.type === r3.type && t3.start + (null !== (n2 = t3.length) && void 0 !== n2 ? n2 : t3.data.length) === r3.start ? (t3.type === c.Overwrite ? (t3.data = m(t3.data, r3.data), t3.length = void 0) : t3.length = (null !== (i2 = t3.length) && void 0 !== i2 ? i2 : t3.data.length) + (null !== (o2 = r3.length) && void 0 !== o2 ? o2 : r3.data.length), f2.splice(e3 + 1, 1), e3--) : t3.type === c.Delete && r3.type === c.Delete && t3.start + (null !== (s2 = t3.length) && void 0 !== s2 ? s2 : 0) === r3.start ? (t3.length = (null !== (a2 = t3.length) && void 0 !== a2 ? a2 : 0) + r3.length, f2.splice(e3 + 1, 1), e3--) : t3.type === c.Insert && r3.type === c.Insert && t3.start + (null !== (u2 = null === (l2 = t3.data) || void 0 === l2 ? void 0 : l2.length) && void 0 !== u2 ? u2 : 0) === r3.start && (t3.data = m(t3.data, r3.data), f2.splice(e3 + 1, 1), e3--);
        }
        return f2;
      }
      Object.defineProperty(t, "ChangeKind", { enumerable: true, get: function() {
        return u.ChangeKind;
      } }), t.EditStats = class {
        constructor() {
          this.delete_count = 0, this.insert_count = 0, this.overwrite_count = 0, this.undo_count = 0, this.redo_count = 0, this.clear_count = 0, this.error_count = 0;
        }
        reset() {
          this.delete_count = 0, this.insert_count = 0, this.overwrite_count = 0, this.undo_count = 0, this.redo_count = 0, this.clear_count = 0, this.error_count = 0;
        }
      }, (function(e2) {
        e2.Delete = "delete", e2.Insert = "insert", e2.Overwrite = "overwrite";
      })(c || (t.EditOperationType = c = {}));
    }, 802: (e, t, r) => {
      const n = r(9246);
      function i(e2, t2) {
        return function(r2) {
          return t2(e2(r2));
        };
      }
      function o(e2, t2) {
        const r2 = [t2[e2].parent, e2];
        let o2 = n[t2[e2].parent][e2], s = t2[e2].parent;
        for (; t2[s].parent; ) r2.unshift(t2[s].parent), o2 = i(n[t2[s].parent][s], o2), s = t2[s].parent;
        return o2.conversion = r2, o2;
      }
      e.exports = function(e2) {
        const t2 = (function(e3) {
          const t3 = (function() {
            const e4 = {}, t4 = Object.keys(n);
            for (let r4 = t4.length, n2 = 0; n2 < r4; n2++) e4[t4[n2]] = { distance: -1, parent: null };
            return e4;
          })(), r3 = [e3];
          for (t3[e3].distance = 0; r3.length; ) {
            const e4 = r3.pop(), i3 = Object.keys(n[e4]);
            for (let n2 = i3.length, o2 = 0; o2 < n2; o2++) {
              const n3 = i3[o2], s = t3[n3];
              -1 === s.distance && (s.distance = t3[e4].distance + 1, s.parent = e4, r3.unshift(n3));
            }
          }
          return t3;
        })(e2), r2 = {}, i2 = Object.keys(t2);
        for (let e3 = i2.length, n2 = 0; n2 < e3; n2++) {
          const e4 = i2[n2];
          null !== t2[e4].parent && (r2[e4] = o(e4, t2));
        }
        return r2;
      };
    }, 857: (e) => {
      e.exports = os;
    }, 932: (e) => {
      e.exports = require$$3$2;
    }, 952: (e, t, r) => {
      const n = r(8895), { redactFmtSym: i, wildcardFirstSym: o } = r(7960), s = /[^.[\]]+|\[([^[\]]*?)\]/g, a = "[Redacted]", l = false;
      e.exports = function(e2, t2) {
        const { paths: r2, censor: c, remove: u } = (function(e3) {
          if (Array.isArray(e3)) return { paths: e3, censor: a };
          let { paths: t3, censor: r3 = a, remove: n2 } = e3;
          if (false === Array.isArray(t3)) throw Error("pino – redact must contain an array of strings");
          return true === n2 && (r3 = void 0), { paths: t3, censor: r3, remove: n2 };
        })(e2), d = r2.reduce((e3, t3) => {
          s.lastIndex = 0;
          const r3 = s.exec(t3), n2 = s.exec(t3);
          let i2 = void 0 !== r3[1] ? r3[1].replace(/^(?:"|'|`)(.*)(?:"|'|`)$/, "$1") : r3[0];
          if ("*" === i2 && (i2 = o), null === n2) return e3[i2] = null, e3;
          if (null === e3[i2]) return e3;
          const { index: a2 } = n2, l2 = `${t3.substr(a2, t3.length - 1)}`;
          return e3[i2] = e3[i2] || [], i2 !== o && 0 === e3[i2].length && e3[i2].push(...e3[o] || []), i2 === o && Object.keys(e3).forEach(function(t4) {
            e3[t4] && e3[t4].push(l2);
          }), e3[i2].push(l2), e3;
        }, {}), p = { [i]: n({ paths: r2, censor: c, serialize: t2, strict: l, remove: u }) };
        return [...Object.keys(d), ...Object.getOwnPropertySymbols(d)].reduce((e3, r3) => {
          if (null === d[r3]) e3[r3] = (e4) => ((...e5) => t2("function" == typeof c ? c(...e5) : c))(e4, [r3]);
          else {
            const i2 = "function" == typeof c ? (e4, t3) => c(e4, [r3, ...t3]) : c;
            e3[r3] = n({ paths: d[r3], censor: i2, serialize: t2, strict: l, remove: u });
          }
          return e3;
        }, p);
      };
    }, 995: (e) => {
      const t = "win32" === process.platform;
      function r(e2, t2) {
        return Object.assign(new Error(`${t2} ${e2.command} ENOENT`), { code: "ENOENT", errno: "ENOENT", syscall: `${t2} ${e2.command}`, path: e2.command, spawnargs: e2.args });
      }
      function n(e2, n2) {
        return t && 1 === e2 && !n2.file ? r(n2.original, "spawn") : null;
      }
      e.exports = { hookChildProcess: function(e2, r2) {
        if (!t) return;
        const i = e2.emit;
        e2.emit = function(t2, o) {
          if ("exit" === t2) {
            const t3 = n(o, r2);
            if (t3) return i.call(e2, "error", t3);
          }
          return i.apply(e2, arguments);
        };
      }, verifyENOENT: n, verifyENOENTSync: function(e2, n2) {
        return t && 1 === e2 && !n2.file ? r(n2.original, "spawnSync") : null;
      }, notFoundError: r };
    }, 1021: (e, t, r) => {
      const n = r(9896), i = r(4434), o = r(9023).inherits, s = r(6928), a = r(9817), l = r(2613), c = 100, u = Buffer.allocUnsafe(0), d = "buffer", p = "utf8", [h, f] = (process.versions.node || "0.0").split(".").map(Number), g = h >= 22 && f >= 7;
      function m(e2, t2) {
        function r2(r3, n2) {
          if (r3) return t2._reopening = false, t2._writing = false, t2._opening = false, void (t2.sync ? process.nextTick(() => {
            t2.listenerCount("error") > 0 && t2.emit("error", r3);
          }) : t2.emit("error", r3));
          const i3 = t2._reopening;
          t2.fd = n2, t2.file = e2, t2._reopening = false, t2._opening = false, t2._writing = false, t2.sync ? process.nextTick(() => t2.emit("ready")) : t2.emit("ready"), t2.destroyed || (!t2._writing && t2._len > t2.minLength || t2._flushPending ? t2._actualWrite() : i3 && process.nextTick(() => t2.emit("drain")));
        }
        t2._opening = true, t2._writing = true, t2._asyncDrainScheduled = false;
        const i2 = t2.append ? "a" : "w", o2 = t2.mode;
        if (t2.sync) try {
          t2.mkdir && n.mkdirSync(s.dirname(e2), { recursive: true }), r2(null, n.openSync(e2, i2, o2));
        } catch (e3) {
          throw r2(e3), e3;
        }
        else t2.mkdir ? n.mkdir(s.dirname(e2), { recursive: true }, (t3) => {
          if (t3) return r2(t3);
          n.open(e2, i2, o2, r2);
        }) : n.open(e2, i2, o2, r2);
      }
      function y(e2) {
        if (!(this instanceof y)) return new y(e2);
        let t2, r2, { fd: i2, dest: o2, minLength: s2, maxLength: l2, maxWrite: h2, periodicFlush: f2, sync: g2, append: S2 = true, mkdir: _22, retryEAGAIN: D, fsync: P, contentMode: F, mode: x } = e2 || {};
        if (i2 = i2 || o2, this._len = 0, this.fd = -1, this._bufs = [], this._lens = [], this._writing = false, this._ending = false, this._reopening = false, this._asyncDrainScheduled = false, this._flushPending = false, this._hwm = Math.max(s2 || 0, 16387), this.file = null, this.destroyed = false, this.minLength = s2 || 0, this.maxLength = l2 || 0, this.maxWrite = h2 || 16384, this._periodicFlush = f2 || 0, this._periodicFlushTimer = void 0, this.sync = g2 || false, this.writable = true, this._fsync = P || false, this.append = S2 || false, this.mode = x, this.retryEAGAIN = D || (() => true), this.mkdir = _22 || false, F === d) this._writingBuf = u, this.write = C, this.flush = R, this.flushSync = O, this._actualWrite = M, t2 = () => n.writeSync(this.fd, this._writingBuf), r2 = () => n.write(this.fd, this._writingBuf, this.release);
        else {
          if (void 0 !== F && F !== p) throw new Error(`SonicBoom supports "${p}" and "${d}", but passed ${F}`);
          this._writingBuf = "", this.write = w, this.flush = E, this.flushSync = T, this._actualWrite = I, t2 = () => n.writeSync(this.fd, this._writingBuf, "utf8"), r2 = () => n.write(this.fd, this._writingBuf, "utf8", this.release);
        }
        if ("number" == typeof i2) this.fd = i2, process.nextTick(() => this.emit("ready"));
        else {
          if ("string" != typeof i2) throw new Error("SonicBoom supports only file descriptors and files");
          m(i2, this);
        }
        if (this.minLength >= this.maxWrite) throw new Error(`minLength should be smaller than maxWrite (${this.maxWrite})`);
        this.release = (e3, i3) => {
          if (e3) {
            if ("EAGAIN" !== e3.code && "EBUSY" !== e3.code || !this.retryEAGAIN(e3, this._writingBuf.length, this._len - this._writingBuf.length)) this._writing = false, this.emit("error", e3);
            else if (this.sync) try {
              a(c), this.release(void 0, 0);
            } catch (e4) {
              this.release(e4);
            }
            else setTimeout(r2, c);
            return;
          }
          this.emit("write", i3);
          const o3 = v(this._writingBuf, this._len, i3);
          if (this._len = o3.len, this._writingBuf = o3.writingBuf, this._writingBuf.length) {
            if (!this.sync) return void r2();
            try {
              do {
                const e4 = t2(), r3 = v(this._writingBuf, this._len, e4);
                this._len = r3.len, this._writingBuf = r3.writingBuf;
              } while (this._writingBuf.length);
            } catch (e4) {
              return void this.release(e4);
            }
          }
          this._fsync && n.fsyncSync(this.fd);
          const s3 = this._len;
          this._reopening ? (this._writing = false, this._reopening = false, this.reopen()) : s3 > this.minLength ? this._actualWrite() : this._ending ? s3 > 0 ? this._actualWrite() : (this._writing = false, k(this)) : (this._writing = false, this.sync ? this._asyncDrainScheduled || (this._asyncDrainScheduled = true, process.nextTick(b, this)) : this.emit("drain"));
        }, this.on("newListener", function(e3) {
          "drain" === e3 && (this._asyncDrainScheduled = false);
        }), 0 !== this._periodicFlush && (this._periodicFlushTimer = setInterval(() => this.flush(null), this._periodicFlush), this._periodicFlushTimer.unref());
      }
      function v(e2, t2, r2) {
        return "string" == typeof e2 && Buffer.byteLength(e2) !== r2 && (r2 = Buffer.from(e2).subarray(0, r2).toString().length), t2 = Math.max(t2 - r2, 0), { writingBuf: e2 = e2.slice(r2), len: t2 };
      }
      function b(e2) {
        e2.listenerCount("drain") > 0 && (e2._asyncDrainScheduled = false, e2.emit("drain"));
      }
      function S(e2, t2) {
        return 0 === e2.length ? u : 1 === e2.length ? e2[0] : Buffer.concat(e2, t2);
      }
      function w(e2) {
        if (this.destroyed) throw new Error("SonicBoom destroyed");
        const t2 = this._len + e2.length, r2 = this._bufs;
        return this.maxLength && t2 > this.maxLength ? (this.emit("drop", e2), this._len < this._hwm) : (0 === r2.length || r2[r2.length - 1].length + e2.length > this.maxWrite ? r2.push("" + e2) : r2[r2.length - 1] += e2, this._len = t2, !this._writing && this._len >= this.minLength && this._actualWrite(), this._len < this._hwm);
      }
      function C(e2) {
        if (this.destroyed) throw new Error("SonicBoom destroyed");
        const t2 = this._len + e2.length, r2 = this._bufs, n2 = this._lens;
        return this.maxLength && t2 > this.maxLength ? (this.emit("drop", e2), this._len < this._hwm) : (0 === r2.length || n2[n2.length - 1] + e2.length > this.maxWrite ? (r2.push([e2]), n2.push(e2.length)) : (r2[r2.length - 1].push(e2), n2[n2.length - 1] += e2.length), this._len = t2, !this._writing && this._len >= this.minLength && this._actualWrite(), this._len < this._hwm);
      }
      function _2(e2) {
        this._flushPending = true;
        const t2 = () => {
          if (this._fsync) this._flushPending = false, e2();
          else try {
            n.fsync(this.fd, (t3) => {
              this._flushPending = false, e2(t3);
            });
          } catch (t3) {
            e2(t3);
          }
          this.off("error", r2);
        }, r2 = (r3) => {
          this._flushPending = false, e2(r3), this.off("drain", t2);
        };
        this.once("drain", t2), this.once("error", r2);
      }
      function E(e2) {
        if (null != e2 && "function" != typeof e2) throw new Error("flush cb must be a function");
        if (this.destroyed) {
          const t2 = new Error("SonicBoom destroyed");
          if (e2) return void e2(t2);
          throw t2;
        }
        this.minLength <= 0 ? e2?.() : (e2 && _2.call(this, e2), this._writing || (0 === this._bufs.length && this._bufs.push(""), this._actualWrite()));
      }
      function R(e2) {
        if (null != e2 && "function" != typeof e2) throw new Error("flush cb must be a function");
        if (this.destroyed) {
          const t2 = new Error("SonicBoom destroyed");
          if (e2) return void e2(t2);
          throw t2;
        }
        this.minLength <= 0 ? e2?.() : (e2 && _2.call(this, e2), this._writing || (0 === this._bufs.length && (this._bufs.push([]), this._lens.push(0)), this._actualWrite()));
      }
      function T() {
        if (this.destroyed) throw new Error("SonicBoom destroyed");
        if (this.fd < 0) throw new Error("sonic boom is not ready yet");
        !this._writing && this._writingBuf.length > 0 && (this._bufs.unshift(this._writingBuf), this._writingBuf = "");
        let e2 = "";
        for (; this._bufs.length || e2; ) {
          e2.length <= 0 && (e2 = this._bufs[0]);
          try {
            const t2 = n.writeSync(this.fd, e2, "utf8"), r2 = v(e2, this._len, t2);
            e2 = r2.writingBuf, this._len = r2.len, e2.length <= 0 && this._bufs.shift();
          } catch (t2) {
            if (("EAGAIN" === t2.code || "EBUSY" === t2.code) && !this.retryEAGAIN(t2, e2.length, this._len - e2.length)) throw t2;
            a(c);
          }
        }
        try {
          n.fsyncSync(this.fd);
        } catch {
        }
      }
      function O() {
        if (this.destroyed) throw new Error("SonicBoom destroyed");
        if (this.fd < 0) throw new Error("sonic boom is not ready yet");
        !this._writing && this._writingBuf.length > 0 && (this._bufs.unshift([this._writingBuf]), this._writingBuf = u);
        let e2 = u;
        for (; this._bufs.length || e2.length; ) {
          e2.length <= 0 && (e2 = S(this._bufs[0], this._lens[0]));
          try {
            const t2 = n.writeSync(this.fd, e2);
            e2 = e2.subarray(t2), this._len = Math.max(this._len - t2, 0), e2.length <= 0 && (this._bufs.shift(), this._lens.shift());
          } catch (t2) {
            if (("EAGAIN" === t2.code || "EBUSY" === t2.code) && !this.retryEAGAIN(t2, e2.length, this._len - e2.length)) throw t2;
            a(c);
          }
        }
      }
      function I() {
        const e2 = this.release;
        if (this._writing = true, this._writingBuf = this._writingBuf || this._bufs.shift() || "", this.sync) try {
          e2(null, n.writeSync(this.fd, this._writingBuf, "utf8"));
        } catch (t2) {
          e2(t2);
        }
        else n.write(this.fd, this._writingBuf, "utf8", e2);
      }
      function M() {
        const e2 = this.release;
        if (this._writing = true, this._writingBuf = this._writingBuf.length ? this._writingBuf : S(this._bufs.shift(), this._lens.shift()), this.sync) try {
          e2(null, n.writeSync(this.fd, this._writingBuf));
        } catch (t2) {
          e2(t2);
        }
        else g && (this._writingBuf = Buffer.from(this._writingBuf)), n.write(this.fd, this._writingBuf, e2);
      }
      function k(e2) {
        if (-1 !== e2.fd) {
          void 0 !== e2._periodicFlushTimer && clearInterval(e2._periodicFlushTimer), e2.destroyed = true, e2._bufs = [], e2._lens = [], l("number" == typeof e2.fd, "sonic.fd must be a number, got " + typeof e2.fd);
          try {
            n.fsync(e2.fd, function() {
              1 !== e2.fd && 2 !== e2.fd ? n.close(e2.fd, t2) : t2();
            });
          } catch {
          }
        } else e2.once("ready", k.bind(null, e2));
        function t2(t3) {
          t3 ? e2.emit("error", t3) : (e2._ending && !e2._writing && e2.emit("finish"), e2.emit("close"));
        }
      }
      o(y, i), y.prototype.reopen = function(e2) {
        if (this.destroyed) throw new Error("SonicBoom destroyed");
        if (this._opening) return void this.once("ready", () => {
          this.reopen(e2);
        });
        if (this._ending) return;
        if (!this.file) throw new Error("Unable to reopen a file descriptor, you must pass a file to SonicBoom");
        if (e2 && (this.file = e2), this._reopening = true, this._writing) return;
        const t2 = this.fd;
        this.once("ready", () => {
          t2 !== this.fd && n.close(t2, (e3) => {
            if (e3) return this.emit("error", e3);
          });
        }), m(this.file, this);
      }, y.prototype.end = function() {
        if (this.destroyed) throw new Error("SonicBoom destroyed");
        this._opening ? this.once("ready", () => {
          this.end();
        }) : this._ending || (this._ending = true, this._writing || (this._len > 0 && this.fd >= 0 ? this._actualWrite() : k(this)));
      }, y.prototype.destroy = function() {
        this.destroyed || k(this);
      }, y.SonicBoom = y, y.default = y, e.exports = y;
    }, 1051: (e, t) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.parseDuration = t.isDuration = t.durationToMs = t.msToDuration = void 0, t.msToDuration = function(e2) {
        return { seconds: e2 / 1e3 | 0, nanos: e2 % 1e3 * 1e6 | 0 };
      }, t.durationToMs = function(e2) {
        return 1e3 * e2.seconds + e2.nanos / 1e6 | 0;
      }, t.isDuration = function(e2) {
        return "number" == typeof e2.seconds && "number" == typeof e2.nanos;
      };
      const r = /^(\d+)(?:\.(\d+))?s$/;
      t.parseDuration = function(e2) {
        const t2 = e2.match(r);
        return t2 ? { seconds: Number.parseInt(t2[1], 10), nanos: t2[2] ? Number.parseInt(t2[2].padEnd(9, "0"), 10) : 0 } : null;
      };
    }, 1080: (e, t) => {
      var r = t, n = r.isAbsolute = function(e2) {
        return /^(?:\/|\w+:)/.test(e2);
      }, i = r.normalize = function(e2) {
        var t2 = (e2 = e2.replace(/\\/g, "/").replace(/\/{2,}/g, "/")).split("/"), r2 = n(e2), i2 = "";
        r2 && (i2 = t2.shift() + "/");
        for (var o = 0; o < t2.length; ) ".." === t2[o] ? o > 0 && ".." !== t2[o - 1] ? t2.splice(--o, 2) : r2 ? t2.splice(o, 1) : ++o : "." === t2[o] ? t2.splice(o, 1) : ++o;
        return i2 + t2.join("/");
      };
      r.resolve = function(e2, t2, r2) {
        return r2 || (t2 = i(t2)), n(t2) ? t2 : (r2 || (e2 = i(e2)), (e2 = e2.replace(/(?:\/|^)[^/]+$/, "")).length ? i(e2 + "/" + t2) : t2);
      };
    }, 1092: (e, t, r) => {
      const n = r(5317), i = r(8147), o = r(995);
      function s(e2, t2, r2) {
        const s2 = i(e2, t2, r2), a = n.spawn(s2.command, s2.args, s2.options);
        return o.hookChildProcess(a, s2), a;
      }
      e.exports = s, e.exports.spawn = s, e.exports.sync = function(e2, t2, r2) {
        const s2 = i(e2, t2, r2), a = n.spawnSync(s2.command, s2.args, s2.options);
        return a.error = a.error || o.verifyENOENTSync(a.status, s2), a;
      }, e.exports._parse = i, e.exports._enoent = o;
    }, 1145: (e, t) => {
      const { hasOwnProperty: r } = Object.prototype, n = p();
      n.configure = p, n.stringify = n, n.default = n, t.stringify = n, t.configure = p, e.exports = n;
      const i = /[\u0000-\u001f\u0022\u005c\ud800-\udfff]/;
      function o(e2) {
        return e2.length < 5e3 && !i.test(e2) ? `"${e2}"` : JSON.stringify(e2);
      }
      function s(e2, t2) {
        if (e2.length > 200 || t2) return e2.sort(t2);
        for (let t3 = 1; t3 < e2.length; t3++) {
          const r2 = e2[t3];
          let n2 = t3;
          for (; 0 !== n2 && e2[n2 - 1] > r2; ) e2[n2] = e2[n2 - 1], n2--;
          e2[n2] = r2;
        }
        return e2;
      }
      const a = Object.getOwnPropertyDescriptor(Object.getPrototypeOf(Object.getPrototypeOf(new Int8Array())), Symbol.toStringTag).get;
      function l(e2) {
        return void 0 !== a.call(e2) && 0 !== e2.length;
      }
      function c(e2, t2, r2) {
        e2.length < r2 && (r2 = e2.length);
        const n2 = "," === t2 ? "" : " ";
        let i2 = `"0":${n2}${e2[0]}`;
        for (let o2 = 1; o2 < r2; o2++) i2 += `${t2}"${o2}":${n2}${e2[o2]}`;
        return i2;
      }
      function u(e2, t2) {
        let n2;
        if (r.call(e2, t2)) {
          if (n2 = e2[t2], "number" != typeof n2) throw new TypeError(`The "${t2}" argument must be of type number`);
          if (!Number.isInteger(n2)) throw new TypeError(`The "${t2}" argument must be an integer`);
          if (n2 < 1) throw new RangeError(`The "${t2}" argument must be >= 1`);
        }
        return void 0 === n2 ? 1 / 0 : n2;
      }
      function d(e2) {
        return 1 === e2 ? "1 item" : `${e2} items`;
      }
      function p(e2) {
        const t2 = (function(e3) {
          if (r.call(e3, "strict")) {
            const t3 = e3.strict;
            if ("boolean" != typeof t3) throw new TypeError('The "strict" argument must be of type boolean');
            if (t3) return (e4) => {
              let t4 = "Object can not safely be stringified. Received type " + typeof e4;
              throw "function" != typeof e4 && (t4 += ` (${e4.toString()})`), new Error(t4);
            };
          }
        })(e2 = { ...e2 });
        t2 && (void 0 === e2.bigint && (e2.bigint = false), "circularValue" in e2 || (e2.circularValue = Error));
        const n2 = (function(e3) {
          if (r.call(e3, "circularValue")) {
            const t3 = e3.circularValue;
            if ("string" == typeof t3) return `"${t3}"`;
            if (null == t3) return t3;
            if (t3 === Error || t3 === TypeError) return { toString() {
              throw new TypeError("Converting circular structure to JSON");
            } };
            throw new TypeError('The "circularValue" argument must be of type string or the value null or undefined');
          }
          return '"[Circular]"';
        })(e2), i2 = (function(e3, t3) {
          let n3;
          if (r.call(e3, t3) && (n3 = e3[t3], "boolean" != typeof n3)) throw new TypeError(`The "${t3}" argument must be of type boolean`);
          return void 0 === n3 || n3;
        })(e2, "bigint"), a2 = (function(e3) {
          let t3;
          if (r.call(e3, "deterministic") && (t3 = e3.deterministic, "boolean" != typeof t3 && "function" != typeof t3)) throw new TypeError('The "deterministic" argument must be of type boolean or comparator function');
          return void 0 === t3 || t3;
        })(e2), p2 = "function" == typeof a2 ? a2 : void 0, h = u(e2, "maximumDepth"), f = u(e2, "maximumBreadth");
        function g(e3, r2, c2, u2, m2, y2) {
          let v2 = r2[e3];
          switch ("object" == typeof v2 && null !== v2 && "function" == typeof v2.toJSON && (v2 = v2.toJSON(e3)), v2 = u2.call(r2, e3, v2), typeof v2) {
            case "string":
              return o(v2);
            case "object": {
              if (null === v2) return "null";
              if (-1 !== c2.indexOf(v2)) return n2;
              let e4 = "", t3 = ",";
              const r3 = y2;
              if (Array.isArray(v2)) {
                if (0 === v2.length) return "[]";
                if (h < c2.length + 1) return '"[Array]"';
                c2.push(v2), "" !== m2 && (e4 += `
${y2 += m2}`, t3 = `,
${y2}`);
                const n3 = Math.min(v2.length, f);
                let i4 = 0;
                for (; i4 < n3 - 1; i4++) {
                  const r4 = g(String(i4), v2, c2, u2, m2, y2);
                  e4 += void 0 !== r4 ? r4 : "null", e4 += t3;
                }
                const o2 = g(String(i4), v2, c2, u2, m2, y2);
                return e4 += void 0 !== o2 ? o2 : "null", v2.length - 1 > f && (e4 += `${t3}"... ${d(v2.length - f - 1)} not stringified"`), "" !== m2 && (e4 += `
${r3}`), c2.pop(), `[${e4}]`;
              }
              let i3 = Object.keys(v2);
              const b = i3.length;
              if (0 === b) return "{}";
              if (h < c2.length + 1) return '"[Object]"';
              let S = "", w = "";
              "" !== m2 && (t3 = `,
${y2 += m2}`, S = " ");
              const C = Math.min(b, f);
              a2 && !l(v2) && (i3 = s(i3, p2)), c2.push(v2);
              for (let r4 = 0; r4 < C; r4++) {
                const n3 = i3[r4], s2 = g(n3, v2, c2, u2, m2, y2);
                void 0 !== s2 && (e4 += `${w}${o(n3)}:${S}${s2}`, w = t3);
              }
              return b > f && (e4 += `${w}"...":${S}"${d(b - f)} not stringified"`, w = t3), "" !== m2 && w.length > 1 && (e4 = `
${y2}${e4}
${r3}`), c2.pop(), `{${e4}}`;
            }
            case "number":
              return isFinite(v2) ? String(v2) : t2 ? t2(v2) : "null";
            case "boolean":
              return true === v2 ? "true" : "false";
            case "undefined":
              return;
            case "bigint":
              if (i2) return String(v2);
            default:
              return t2 ? t2(v2) : void 0;
          }
        }
        function m(e3, r2, s2, a3, l2, c2) {
          switch ("object" == typeof r2 && null !== r2 && "function" == typeof r2.toJSON && (r2 = r2.toJSON(e3)), typeof r2) {
            case "string":
              return o(r2);
            case "object": {
              if (null === r2) return "null";
              if (-1 !== s2.indexOf(r2)) return n2;
              const e4 = c2;
              let t3 = "", i3 = ",";
              if (Array.isArray(r2)) {
                if (0 === r2.length) return "[]";
                if (h < s2.length + 1) return '"[Array]"';
                s2.push(r2), "" !== l2 && (t3 += `
${c2 += l2}`, i3 = `,
${c2}`);
                const n3 = Math.min(r2.length, f);
                let o2 = 0;
                for (; o2 < n3 - 1; o2++) {
                  const e5 = m(String(o2), r2[o2], s2, a3, l2, c2);
                  t3 += void 0 !== e5 ? e5 : "null", t3 += i3;
                }
                const u3 = m(String(o2), r2[o2], s2, a3, l2, c2);
                return t3 += void 0 !== u3 ? u3 : "null", r2.length - 1 > f && (t3 += `${i3}"... ${d(r2.length - f - 1)} not stringified"`), "" !== l2 && (t3 += `
${e4}`), s2.pop(), `[${t3}]`;
              }
              s2.push(r2);
              let u2 = "";
              "" !== l2 && (i3 = `,
${c2 += l2}`, u2 = " ");
              let p3 = "";
              for (const e5 of a3) {
                const n3 = m(e5, r2[e5], s2, a3, l2, c2);
                void 0 !== n3 && (t3 += `${p3}${o(e5)}:${u2}${n3}`, p3 = i3);
              }
              return "" !== l2 && p3.length > 1 && (t3 = `
${c2}${t3}
${e4}`), s2.pop(), `{${t3}}`;
            }
            case "number":
              return isFinite(r2) ? String(r2) : t2 ? t2(r2) : "null";
            case "boolean":
              return true === r2 ? "true" : "false";
            case "undefined":
              return;
            case "bigint":
              if (i2) return String(r2);
            default:
              return t2 ? t2(r2) : void 0;
          }
        }
        function y(e3, r2, u2, g2, m2) {
          switch (typeof r2) {
            case "string":
              return o(r2);
            case "object": {
              if (null === r2) return "null";
              if ("function" == typeof r2.toJSON) {
                if ("object" != typeof (r2 = r2.toJSON(e3))) return y(e3, r2, u2, g2, m2);
                if (null === r2) return "null";
              }
              if (-1 !== u2.indexOf(r2)) return n2;
              const t3 = m2;
              if (Array.isArray(r2)) {
                if (0 === r2.length) return "[]";
                if (h < u2.length + 1) return '"[Array]"';
                u2.push(r2);
                let e4 = `
${m2 += g2}`;
                const n3 = `,
${m2}`, i4 = Math.min(r2.length, f);
                let o2 = 0;
                for (; o2 < i4 - 1; o2++) {
                  const t4 = y(String(o2), r2[o2], u2, g2, m2);
                  e4 += void 0 !== t4 ? t4 : "null", e4 += n3;
                }
                const s2 = y(String(o2), r2[o2], u2, g2, m2);
                return e4 += void 0 !== s2 ? s2 : "null", r2.length - 1 > f && (e4 += `${n3}"... ${d(r2.length - f - 1)} not stringified"`), e4 += `
${t3}`, u2.pop(), `[${e4}]`;
              }
              let i3 = Object.keys(r2);
              const v2 = i3.length;
              if (0 === v2) return "{}";
              if (h < u2.length + 1) return '"[Object]"';
              const b = `,
${m2 += g2}`;
              let S = "", w = "", C = Math.min(v2, f);
              l(r2) && (S += c(r2, b, f), i3 = i3.slice(r2.length), C -= r2.length, w = b), a2 && (i3 = s(i3, p2)), u2.push(r2);
              for (let e4 = 0; e4 < C; e4++) {
                const t4 = i3[e4], n3 = y(t4, r2[t4], u2, g2, m2);
                void 0 !== n3 && (S += `${w}${o(t4)}: ${n3}`, w = b);
              }
              return v2 > f && (S += `${w}"...": "${d(v2 - f)} not stringified"`, w = b), "" !== w && (S = `
${m2}${S}
${t3}`), u2.pop(), `{${S}}`;
            }
            case "number":
              return isFinite(r2) ? String(r2) : t2 ? t2(r2) : "null";
            case "boolean":
              return true === r2 ? "true" : "false";
            case "undefined":
              return;
            case "bigint":
              if (i2) return String(r2);
            default:
              return t2 ? t2(r2) : void 0;
          }
        }
        function v(e3, r2, u2) {
          switch (typeof r2) {
            case "string":
              return o(r2);
            case "object": {
              if (null === r2) return "null";
              if ("function" == typeof r2.toJSON) {
                if ("object" != typeof (r2 = r2.toJSON(e3))) return v(e3, r2, u2);
                if (null === r2) return "null";
              }
              if (-1 !== u2.indexOf(r2)) return n2;
              let t3 = "";
              const i3 = void 0 !== r2.length;
              if (i3 && Array.isArray(r2)) {
                if (0 === r2.length) return "[]";
                if (h < u2.length + 1) return '"[Array]"';
                u2.push(r2);
                const e4 = Math.min(r2.length, f);
                let n3 = 0;
                for (; n3 < e4 - 1; n3++) {
                  const e5 = v(String(n3), r2[n3], u2);
                  t3 += void 0 !== e5 ? e5 : "null", t3 += ",";
                }
                const i4 = v(String(n3), r2[n3], u2);
                return t3 += void 0 !== i4 ? i4 : "null", r2.length - 1 > f && (t3 += `,"... ${d(r2.length - f - 1)} not stringified"`), u2.pop(), `[${t3}]`;
              }
              let g2 = Object.keys(r2);
              const m2 = g2.length;
              if (0 === m2) return "{}";
              if (h < u2.length + 1) return '"[Object]"';
              let y2 = "", b = Math.min(m2, f);
              i3 && l(r2) && (t3 += c(r2, ",", f), g2 = g2.slice(r2.length), b -= r2.length, y2 = ","), a2 && (g2 = s(g2, p2)), u2.push(r2);
              for (let e4 = 0; e4 < b; e4++) {
                const n3 = g2[e4], i4 = v(n3, r2[n3], u2);
                void 0 !== i4 && (t3 += `${y2}${o(n3)}:${i4}`, y2 = ",");
              }
              return m2 > f && (t3 += `${y2}"...":"${d(m2 - f)} not stringified"`), u2.pop(), `{${t3}}`;
            }
            case "number":
              return isFinite(r2) ? String(r2) : t2 ? t2(r2) : "null";
            case "boolean":
              return true === r2 ? "true" : "false";
            case "undefined":
              return;
            case "bigint":
              if (i2) return String(r2);
            default:
              return t2 ? t2(r2) : void 0;
          }
        }
        return function(e3, t3, r2) {
          if (arguments.length > 1) {
            let n3 = "";
            if ("number" == typeof r2 ? n3 = " ".repeat(Math.min(r2, 10)) : "string" == typeof r2 && (n3 = r2.slice(0, 10)), null != t3) {
              if ("function" == typeof t3) return g("", { "": e3 }, [], t3, n3, "");
              if (Array.isArray(t3)) return m("", e3, [], (function(e4) {
                const t4 = /* @__PURE__ */ new Set();
                for (const r3 of e4) "string" != typeof r3 && "number" != typeof r3 || t4.add(String(r3));
                return t4;
              })(t3), n3, "");
            }
            if (0 !== n3.length) return y("", e3, [], n3, "");
          }
          return v("", e3, []);
        };
      }
    }, 1173: (e) => {
      class t extends Error {
        constructor(e2) {
          super(e2), Error.captureStackTrace(this, this.constructor), this.name = "ValidationError";
        }
      }
      e.exports = t;
    }, 1311: (e, t, r) => {
      e.exports = v;
      var n = r(4060);
      ((v.prototype = Object.create(n.prototype)).constructor = v).className = "Type";
      var i = r(8118), o = r(7166), s = r(4243), a = r(4341), l = r(3712), c = r(9348), u = r(3963), d = r(3108), p = r(8723), h = r(7471), f = r(4455), g = r(3777), m = r(5931), y = r(1359);
      function v(e2, t2) {
        n.call(this, e2, t2), this.fields = {}, this.oneofs = void 0, this.extensions = void 0, this.reserved = void 0, this.group = void 0, this._fieldsById = null, this._fieldsArray = null, this._oneofsArray = null, this._ctor = null;
      }
      function b(e2) {
        return e2._fieldsById = e2._fieldsArray = e2._oneofsArray = null, delete e2.encode, delete e2.decode, delete e2.verify, e2;
      }
      Object.defineProperties(v.prototype, { fieldsById: { get: function() {
        if (this._fieldsById) return this._fieldsById;
        this._fieldsById = {};
        for (var e2 = Object.keys(this.fields), t2 = 0; t2 < e2.length; ++t2) {
          var r2 = this.fields[e2[t2]], n2 = r2.id;
          if (this._fieldsById[n2]) throw Error("duplicate id " + n2 + " in " + this);
          this._fieldsById[n2] = r2;
        }
        return this._fieldsById;
      } }, fieldsArray: { get: function() {
        return this._fieldsArray || (this._fieldsArray = p.toArray(this.fields));
      } }, oneofsArray: { get: function() {
        return this._oneofsArray || (this._oneofsArray = p.toArray(this.oneofs));
      } }, ctor: { get: function() {
        return this._ctor || (this.ctor = v.generateConstructor(this)());
      }, set: function(e2) {
        var t2 = e2.prototype;
        t2 instanceof c || ((e2.prototype = new c()).constructor = e2, p.merge(e2.prototype, t2)), e2.$type = e2.prototype.$type = this, p.merge(e2, c, true), this._ctor = e2;
        for (var r2 = 0; r2 < this.fieldsArray.length; ++r2) this._fieldsArray[r2].resolve();
        var n2 = {};
        for (r2 = 0; r2 < this.oneofsArray.length; ++r2) n2[this._oneofsArray[r2].resolve().name] = { get: p.oneOfGetter(this._oneofsArray[r2].oneof), set: p.oneOfSetter(this._oneofsArray[r2].oneof) };
        r2 && Object.defineProperties(e2.prototype, n2);
      } } }), v.generateConstructor = function(e2) {
        for (var t2, r2 = p.codegen(["p"], e2.name), n2 = 0; n2 < e2.fieldsArray.length; ++n2) (t2 = e2._fieldsArray[n2]).map ? r2("this%s={}", p.safeProp(t2.name)) : t2.repeated && r2("this%s=[]", p.safeProp(t2.name));
        return r2("if(p)for(var ks=Object.keys(p),i=0;i<ks.length;++i)if(p[ks[i]]!=null)")("this[ks[i]]=p[ks[i]]");
      }, v.fromJSON = function(e2, t2) {
        var r2 = new v(e2, t2.options);
        r2.extensions = t2.extensions, r2.reserved = t2.reserved;
        for (var c2 = Object.keys(t2.fields), u2 = 0; u2 < c2.length; ++u2) r2.add((void 0 !== t2.fields[c2[u2]].keyType ? a.fromJSON : s.fromJSON)(c2[u2], t2.fields[c2[u2]]));
        if (t2.oneofs) for (c2 = Object.keys(t2.oneofs), u2 = 0; u2 < c2.length; ++u2) r2.add(o.fromJSON(c2[u2], t2.oneofs[c2[u2]]));
        if (t2.nested) for (c2 = Object.keys(t2.nested), u2 = 0; u2 < c2.length; ++u2) {
          var d2 = t2.nested[c2[u2]];
          r2.add((void 0 !== d2.id ? s.fromJSON : void 0 !== d2.fields ? v.fromJSON : void 0 !== d2.values ? i.fromJSON : void 0 !== d2.methods ? l.fromJSON : n.fromJSON)(c2[u2], d2));
        }
        return t2.extensions && t2.extensions.length && (r2.extensions = t2.extensions), t2.reserved && t2.reserved.length && (r2.reserved = t2.reserved), t2.group && (r2.group = true), t2.comment && (r2.comment = t2.comment), t2.edition && (r2._edition = t2.edition), r2._defaultEdition = "proto3", r2;
      }, v.prototype.toJSON = function(e2) {
        var t2 = n.prototype.toJSON.call(this, e2), r2 = !!e2 && Boolean(e2.keepComments);
        return p.toObject(["edition", this._editionToJSON(), "options", t2 && t2.options || void 0, "oneofs", n.arrayToJSON(this.oneofsArray, e2), "fields", n.arrayToJSON(this.fieldsArray.filter(function(e3) {
          return !e3.declaringField;
        }), e2) || {}, "extensions", this.extensions && this.extensions.length ? this.extensions : void 0, "reserved", this.reserved && this.reserved.length ? this.reserved : void 0, "group", this.group || void 0, "nested", t2 && t2.nested || void 0, "comment", r2 ? this.comment : void 0]);
      }, v.prototype.resolveAll = function() {
        if (!this._needsRecursiveResolve) return this;
        n.prototype.resolveAll.call(this);
        var e2 = this.oneofsArray;
        for (r2 = 0; r2 < e2.length; ) e2[r2++].resolve();
        for (var t2 = this.fieldsArray, r2 = 0; r2 < t2.length; ) t2[r2++].resolve();
        return this;
      }, v.prototype._resolveFeaturesRecursive = function(e2) {
        return this._needsRecursiveFeatureResolution ? (e2 = this._edition || e2, n.prototype._resolveFeaturesRecursive.call(this, e2), this.oneofsArray.forEach((t2) => {
          t2._resolveFeatures(e2);
        }), this.fieldsArray.forEach((t2) => {
          t2._resolveFeatures(e2);
        }), this) : this;
      }, v.prototype.get = function(e2) {
        return this.fields[e2] || this.oneofs && this.oneofs[e2] || this.nested && this.nested[e2] || null;
      }, v.prototype.add = function(e2) {
        if (this.get(e2.name)) throw Error("duplicate name '" + e2.name + "' in " + this);
        if (e2 instanceof s && void 0 === e2.extend) {
          if (this._fieldsById ? this._fieldsById[e2.id] : this.fieldsById[e2.id]) throw Error("duplicate id " + e2.id + " in " + this);
          if (this.isReservedId(e2.id)) throw Error("id " + e2.id + " is reserved in " + this);
          if (this.isReservedName(e2.name)) throw Error("name '" + e2.name + "' is reserved in " + this);
          return e2.parent && e2.parent.remove(e2), this.fields[e2.name] = e2, e2.message = this, e2.onAdd(this), b(this);
        }
        return e2 instanceof o ? (this.oneofs || (this.oneofs = {}), this.oneofs[e2.name] = e2, e2.onAdd(this), b(this)) : n.prototype.add.call(this, e2);
      }, v.prototype.remove = function(e2) {
        if (e2 instanceof s && void 0 === e2.extend) {
          if (!this.fields || this.fields[e2.name] !== e2) throw Error(e2 + " is not a member of " + this);
          return delete this.fields[e2.name], e2.parent = null, e2.onRemove(this), b(this);
        }
        if (e2 instanceof o) {
          if (!this.oneofs || this.oneofs[e2.name] !== e2) throw Error(e2 + " is not a member of " + this);
          return delete this.oneofs[e2.name], e2.parent = null, e2.onRemove(this), b(this);
        }
        return n.prototype.remove.call(this, e2);
      }, v.prototype.isReservedId = function(e2) {
        return n.isReservedId(this.reserved, e2);
      }, v.prototype.isReservedName = function(e2) {
        return n.isReservedName(this.reserved, e2);
      }, v.prototype.create = function(e2) {
        return new this.ctor(e2);
      }, v.prototype.setup = function() {
        for (var e2 = this.fullName, t2 = [], r2 = 0; r2 < this.fieldsArray.length; ++r2) t2.push(this._fieldsArray[r2].resolve().resolvedType);
        this.encode = h(this)({ Writer: d, types: t2, util: p }), this.decode = f(this)({ Reader: u, types: t2, util: p }), this.verify = g(this)({ types: t2, util: p }), this.fromObject = m.fromObject(this)({ types: t2, util: p }), this.toObject = m.toObject(this)({ types: t2, util: p });
        var n2 = y[e2];
        if (n2) {
          var i2 = Object.create(this);
          i2.fromObject = this.fromObject, this.fromObject = n2.fromObject.bind(i2), i2.toObject = this.toObject, this.toObject = n2.toObject.bind(i2);
        }
        return this;
      }, v.prototype.encode = function(e2, t2) {
        return this.setup().encode(e2, t2);
      }, v.prototype.encodeDelimited = function(e2, t2) {
        return this.encode(e2, t2 && t2.len ? t2.fork() : t2).ldelim();
      }, v.prototype.decode = function(e2, t2) {
        return this.setup().decode(e2, t2);
      }, v.prototype.decodeDelimited = function(e2) {
        return e2 instanceof u || (e2 = u.create(e2)), this.decode(e2, e2.uint32());
      }, v.prototype.verify = function(e2) {
        return this.setup().verify(e2);
      }, v.prototype.fromObject = function(e2) {
        return this.setup().fromObject(e2);
      }, v.prototype.toObject = function(e2, t2) {
        return this.setup().toObject(e2, t2);
      }, v.d = function(e2) {
        return function(t2) {
          p.decorateType(t2, e2);
        };
      };
    }, 1359: (e, t, r) => {
      var n = t, i = r(9348);
      n[".google.protobuf.Any"] = { fromObject: function(e2) {
        if (e2 && e2["@type"]) {
          var t2 = e2["@type"].substring(e2["@type"].lastIndexOf("/") + 1), r2 = this.lookup(t2);
          if (r2) {
            var n2 = "." === e2["@type"].charAt(0) ? e2["@type"].slice(1) : e2["@type"];
            return -1 === n2.indexOf("/") && (n2 = "/" + n2), this.create({ type_url: n2, value: r2.encode(r2.fromObject(e2)).finish() });
          }
        }
        return this.fromObject(e2);
      }, toObject: function(e2, t2) {
        var r2 = "", n2 = "";
        if (t2 && t2.json && e2.type_url && e2.value) {
          n2 = e2.type_url.substring(e2.type_url.lastIndexOf("/") + 1), r2 = e2.type_url.substring(0, e2.type_url.lastIndexOf("/") + 1);
          var o = this.lookup(n2);
          o && (e2 = o.decode(e2.value));
        }
        if (!(e2 instanceof this.ctor) && e2 instanceof i) {
          var s = e2.$type.toObject(e2, t2);
          return "" === r2 && (r2 = "type.googleapis.com/"), n2 = r2 + ("." === e2.$type.fullName[0] ? e2.$type.fullName.slice(1) : e2.$type.fullName), s["@type"] = n2, s;
        }
        return this.toObject(e2, t2);
      } };
    }, 1446: (e, t, r) => {
      var n = r(5298);
      e.exports = t = n.descriptor = n.Root.fromJSON(r(570)).lookup(".google.protobuf");
      var i = n.Namespace, o = n.Root, s = n.Enum, a = n.Type, l = n.Field, c = n.MapField, u = n.OneOf, d = n.Service, p = n.Method;
      function h(e2, r2, n2) {
        var c2 = t.FileDescriptorProto.create({ name: e2.filename || (e2.fullName.substring(1).replace(/\./g, "_") || "root") + ".proto" });
        !(function(e3, r3) {
          if (e3) if ("proto2" === e3 || "proto3" === e3) r3.syntax = e3;
          else {
            if (r3.syntax = "editions", "2023" !== e3) throw new Error("Unsupported edition " + e3);
            r3.edition = t.Edition.EDITION_2023;
          }
        })(n2, c2), e2 instanceof o || (c2.package = e2.fullName.substring(1));
        for (var u2, p2 = 0; p2 < e2.nestedArray.length; ++p2) (u2 = e2._nestedArray[p2]) instanceof a ? c2.messageType.push(u2.toDescriptor(n2)) : u2 instanceof s ? c2.enumType.push(u2.toDescriptor()) : u2 instanceof l ? c2.extension.push(u2.toDescriptor(n2)) : u2 instanceof d ? c2.service.push(u2.toDescriptor()) : u2 instanceof i && h(u2, r2, n2);
        c2.options = E(e2.options, t.FileOptions), c2.messageType.length + c2.enumType.length + c2.extension.length + c2.service.length && r2.push(c2);
      }
      o.fromDescriptor = function(e2) {
        "number" == typeof e2.length && (e2 = t.FileDescriptorSet.decode(e2));
        var r2 = new o();
        if (e2.file) for (var n2, i2, c2, u2 = 0; u2 < e2.file.length; ++u2) {
          i2 = r2, (n2 = e2.file[u2]).package && n2.package.length && (i2 = r2.define(n2.package));
          var p2 = O(n2);
          if (n2.name && n2.name.length && r2.files.push(i2.filename = n2.name), n2.messageType) for (c2 = 0; c2 < n2.messageType.length; ++c2) i2.add(a.fromDescriptor(n2.messageType[c2], p2));
          if (n2.enumType) for (c2 = 0; c2 < n2.enumType.length; ++c2) i2.add(s.fromDescriptor(n2.enumType[c2], p2));
          if (n2.extension) for (c2 = 0; c2 < n2.extension.length; ++c2) i2.add(l.fromDescriptor(n2.extension[c2], p2));
          if (n2.service) for (c2 = 0; c2 < n2.service.length; ++c2) i2.add(d.fromDescriptor(n2.service[c2], p2));
          var h2 = C(n2.options, t.FileOptions);
          if (h2) {
            var f2 = Object.keys(h2);
            for (c2 = 0; c2 < f2.length; ++c2) i2.setOption(f2[c2], h2[f2[c2]]);
          }
        }
        return r2.resolveAll();
      }, o.prototype.toDescriptor = function(e2) {
        var r2 = t.FileDescriptorSet.create();
        return h(this, r2.file, e2), r2;
      };
      var f = 0;
      a.fromDescriptor = function(e2, r2, n2) {
        "number" == typeof e2.length && (e2 = t.DescriptorProto.decode(e2));
        var i2, o2 = new a(e2.name.length ? e2.name : "Type" + f++, C(e2.options, t.MessageOptions));
        if (n2 || (o2._edition = r2), e2.oneofDecl) for (i2 = 0; i2 < e2.oneofDecl.length; ++i2) o2.add(u.fromDescriptor(e2.oneofDecl[i2]));
        if (e2.field) for (i2 = 0; i2 < e2.field.length; ++i2) {
          var c2 = l.fromDescriptor(e2.field[i2], r2, true);
          o2.add(c2), e2.field[i2].hasOwnProperty("oneofIndex") && o2.oneofsArray[e2.field[i2].oneofIndex].add(c2);
        }
        if (e2.extension) for (i2 = 0; i2 < e2.extension.length; ++i2) o2.add(l.fromDescriptor(e2.extension[i2], r2, true));
        if (e2.nestedType) for (i2 = 0; i2 < e2.nestedType.length; ++i2) o2.add(a.fromDescriptor(e2.nestedType[i2], r2, true)), e2.nestedType[i2].options && e2.nestedType[i2].options.mapEntry && o2.setOption("map_entry", true);
        if (e2.enumType) for (i2 = 0; i2 < e2.enumType.length; ++i2) o2.add(s.fromDescriptor(e2.enumType[i2], r2, true));
        if (e2.extensionRange && e2.extensionRange.length) for (o2.extensions = [], i2 = 0; i2 < e2.extensionRange.length; ++i2) o2.extensions.push([e2.extensionRange[i2].start, e2.extensionRange[i2].end]);
        if (e2.reservedRange && e2.reservedRange.length || e2.reservedName && e2.reservedName.length) {
          if (o2.reserved = [], e2.reservedRange) for (i2 = 0; i2 < e2.reservedRange.length; ++i2) o2.reserved.push([e2.reservedRange[i2].start, e2.reservedRange[i2].end]);
          if (e2.reservedName) for (i2 = 0; i2 < e2.reservedName.length; ++i2) o2.reserved.push(e2.reservedName[i2]);
        }
        return o2;
      }, a.prototype.toDescriptor = function(e2) {
        var r2, n2 = t.DescriptorProto.create({ name: this.name });
        for (r2 = 0; r2 < this.fieldsArray.length; ++r2) {
          var i2;
          if (n2.field.push(i2 = this._fieldsArray[r2].toDescriptor(e2)), this._fieldsArray[r2] instanceof c) {
            var o2 = S(this._fieldsArray[r2].keyType, this._fieldsArray[r2].resolvedKeyType, false), u2 = S(this._fieldsArray[r2].type, this._fieldsArray[r2].resolvedType, false), d2 = 11 === u2 || 14 === u2 ? this._fieldsArray[r2].resolvedType && R(this.parent, this._fieldsArray[r2].resolvedType) || this._fieldsArray[r2].type : void 0;
            n2.nestedType.push(t.DescriptorProto.create({ name: i2.typeName, field: [t.FieldDescriptorProto.create({ name: "key", number: 1, label: 1, type: o2 }), t.FieldDescriptorProto.create({ name: "value", number: 2, label: 1, type: u2, typeName: d2 })], options: t.MessageOptions.create({ mapEntry: true }) }));
          }
        }
        for (r2 = 0; r2 < this.oneofsArray.length; ++r2) n2.oneofDecl.push(this._oneofsArray[r2].toDescriptor());
        for (r2 = 0; r2 < this.nestedArray.length; ++r2) this._nestedArray[r2] instanceof l ? n2.field.push(this._nestedArray[r2].toDescriptor(e2)) : this._nestedArray[r2] instanceof a ? n2.nestedType.push(this._nestedArray[r2].toDescriptor(e2)) : this._nestedArray[r2] instanceof s && n2.enumType.push(this._nestedArray[r2].toDescriptor());
        if (this.extensions) for (r2 = 0; r2 < this.extensions.length; ++r2) n2.extensionRange.push(t.DescriptorProto.ExtensionRange.create({ start: this.extensions[r2][0], end: this.extensions[r2][1] }));
        if (this.reserved) for (r2 = 0; r2 < this.reserved.length; ++r2) "string" == typeof this.reserved[r2] ? n2.reservedName.push(this.reserved[r2]) : n2.reservedRange.push(t.DescriptorProto.ReservedRange.create({ start: this.reserved[r2][0], end: this.reserved[r2][1] }));
        return n2.options = E(this.options, t.MessageOptions), n2;
      };
      var g = /^(?![eE])[0-9]*(?:\.[0-9]*)?(?:[eE][+-]?[0-9]+)?$/;
      l.fromDescriptor = function(e2, r2, n2) {
        if ("number" == typeof e2.length && (e2 = t.DescriptorProto.decode(e2)), "number" != typeof e2.number) throw Error("missing field id");
        var i2, o2;
        switch (i2 = e2.typeName && e2.typeName.length ? e2.typeName : (function(e3) {
          switch (e3) {
            case 1:
              return "double";
            case 2:
              return "float";
            case 3:
              return "int64";
            case 4:
              return "uint64";
            case 5:
              return "int32";
            case 6:
              return "fixed64";
            case 7:
              return "fixed32";
            case 8:
              return "bool";
            case 9:
              return "string";
            case 12:
              return "bytes";
            case 13:
              return "uint32";
            case 15:
              return "sfixed32";
            case 16:
              return "sfixed64";
            case 17:
              return "sint32";
            case 18:
              return "sint64";
          }
          throw Error("illegal type: " + e3);
        })(e2.type), e2.label) {
          case 1:
            o2 = void 0;
            break;
          case 2:
            o2 = "required";
            break;
          case 3:
            o2 = "repeated";
            break;
          default:
            throw Error("illegal label: " + e2.label);
        }
        var s2 = e2.extendee;
        void 0 !== e2.extendee && (s2 = s2.length ? s2 : void 0);
        var a2 = new l(e2.name.length ? e2.name : "field" + e2.number, e2.number, i2, o2, s2);
        if (n2 || (a2._edition = r2), a2.options = C(e2.options, t.FieldOptions), e2.proto3_optional && (a2.options.proto3_optional = true), e2.defaultValue && e2.defaultValue.length) {
          var c2 = e2.defaultValue;
          switch (c2) {
            case "true":
            case "TRUE":
              c2 = true;
              break;
            case "false":
            case "FALSE":
              c2 = false;
              break;
            default:
              g.exec(c2) && (c2 = parseInt(c2));
          }
          a2.setOption("default", c2);
        }
        return (function(e3) {
          switch (e3) {
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
            case 8:
            case 13:
            case 14:
            case 15:
            case 16:
            case 17:
            case 18:
              return true;
          }
          return false;
        })(e2.type) && ("proto3" === r2 ? e2.options && !e2.options.packed && a2.setOption("packed", false) : r2 && "proto2" !== r2 || !e2.options || !e2.options.packed || a2.setOption("packed", true)), a2;
      }, l.prototype.toDescriptor = function(e2) {
        var r2 = t.FieldDescriptorProto.create({ name: this.name, number: this.id });
        if (this.map) r2.type = 11, r2.typeName = n.util.ucFirst(this.name), r2.label = 3;
        else {
          switch (r2.type = S(this.type, this.resolve().resolvedType, this.delimited)) {
            case 10:
            case 11:
            case 14:
              r2.typeName = this.resolvedType ? R(this.parent, this.resolvedType) : this.type;
          }
          "repeated" === this.rule ? r2.label = 3 : this.required && "proto2" === e2 ? r2.label = 2 : r2.label = 1;
        }
        if (r2.extendee = this.extensionField ? this.extensionField.parent.fullName : this.extend, this.partOf && (r2.oneofIndex = this.parent.oneofsArray.indexOf(this.partOf)) < 0) throw Error("missing oneof");
        return this.options && (r2.options = E(this.options, t.FieldOptions), null != this.options.default && (r2.defaultValue = String(this.options.default)), this.options.proto3_optional && (r2.proto3_optional = true)), "proto3" === e2 ? this.packed || ((r2.options || (r2.options = t.FieldOptions.create())).packed = false) : e2 && "proto2" !== e2 || !this.packed || ((r2.options || (r2.options = t.FieldOptions.create())).packed = true), r2;
      };
      var m = 0;
      s.fromDescriptor = function(e2, r2, n2) {
        "number" == typeof e2.length && (e2 = t.EnumDescriptorProto.decode(e2));
        var i2 = {};
        if (e2.value) for (var o2 = 0; o2 < e2.value.length; ++o2) {
          var a2 = e2.value[o2].name, l2 = e2.value[o2].number || 0;
          i2[a2 && a2.length ? a2 : "NAME" + l2] = l2;
        }
        var c2 = new s(e2.name && e2.name.length ? e2.name : "Enum" + m++, i2, C(e2.options, t.EnumOptions));
        return n2 || (c2._edition = r2), c2;
      }, s.prototype.toDescriptor = function() {
        for (var e2 = [], r2 = 0, n2 = Object.keys(this.values); r2 < n2.length; ++r2) e2.push(t.EnumValueDescriptorProto.create({ name: n2[r2], number: this.values[n2[r2]] }));
        return t.EnumDescriptorProto.create({ name: this.name, value: e2, options: E(this.options, t.EnumOptions) });
      };
      var y = 0;
      u.fromDescriptor = function(e2) {
        return "number" == typeof e2.length && (e2 = t.OneofDescriptorProto.decode(e2)), new u(e2.name && e2.name.length ? e2.name : "oneof" + y++);
      }, u.prototype.toDescriptor = function() {
        return t.OneofDescriptorProto.create({ name: this.name });
      };
      var v = 0;
      d.fromDescriptor = function(e2, r2, n2) {
        "number" == typeof e2.length && (e2 = t.ServiceDescriptorProto.decode(e2));
        var i2 = new d(e2.name && e2.name.length ? e2.name : "Service" + v++, C(e2.options, t.ServiceOptions));
        if (n2 || (i2._edition = r2), e2.method) for (var o2 = 0; o2 < e2.method.length; ++o2) i2.add(p.fromDescriptor(e2.method[o2]));
        return i2;
      }, d.prototype.toDescriptor = function() {
        for (var e2 = [], r2 = 0; r2 < this.methodsArray.length; ++r2) e2.push(this._methodsArray[r2].toDescriptor());
        return t.ServiceDescriptorProto.create({ name: this.name, method: e2, options: E(this.options, t.ServiceOptions) });
      };
      var b = 0;
      function S(e2, t2, r2) {
        switch (e2) {
          case "double":
            return 1;
          case "float":
            return 2;
          case "int64":
            return 3;
          case "uint64":
            return 4;
          case "int32":
            return 5;
          case "fixed64":
            return 6;
          case "fixed32":
            return 7;
          case "bool":
            return 8;
          case "string":
            return 9;
          case "bytes":
            return 12;
          case "uint32":
            return 13;
          case "sfixed32":
            return 15;
          case "sfixed64":
            return 16;
          case "sint32":
            return 17;
          case "sint64":
            return 18;
        }
        if (t2 instanceof s) return 14;
        if (t2 instanceof a) return r2 ? 10 : 11;
        throw Error("illegal type: " + e2);
      }
      function w(e2, t2) {
        for (var r2, n2, i2 = {}, o2 = 0; o2 < t2.fieldsArray.length; ++o2) if ("uninterpretedOption" !== (n2 = (r2 = t2._fieldsArray[o2]).name) && Object.prototype.hasOwnProperty.call(e2, n2)) {
          var l2 = T(n2);
          r2.resolvedType instanceof a ? i2[l2] = w(e2[n2], r2.resolvedType) : r2.resolvedType instanceof s ? i2[l2] = r2.resolvedType.valuesById[e2[n2]] : i2[l2] = e2[n2];
        }
        return i2;
      }
      function C(e2, t2) {
        if (e2) return w(t2.toObject(e2), t2);
      }
      function _2(e2, t2) {
        for (var r2 = {}, i2 = Object.keys(e2), o2 = 0; o2 < i2.length; ++o2) {
          var s2 = i2[o2], l2 = n.util.camelCase(s2);
          if (Object.prototype.hasOwnProperty.call(t2.fields, l2)) {
            var c2 = t2.fields[l2];
            c2.resolvedType instanceof a ? r2[l2] = _2(e2[s2], c2.resolvedType) : r2[l2] = e2[s2], c2.repeated && !Array.isArray(r2[l2]) && (r2[l2] = [r2[l2]]);
          }
        }
        return r2;
      }
      function E(e2, t2) {
        if (e2) return t2.fromObject(_2(e2, t2));
      }
      function R(e2, t2) {
        var r2 = e2.fullName.split("."), n2 = t2.fullName.split("."), s2 = 0, a2 = 0, l2 = n2.length - 1;
        if (!(e2 instanceof o) && t2 instanceof i) for (; s2 < r2.length && a2 < l2 && r2[s2] === n2[a2]; ) {
          var c2 = t2.lookup(r2[s2++], true);
          if (null !== c2 && c2 !== t2) break;
          ++a2;
        }
        else for (; s2 < r2.length && a2 < l2 && r2[s2] === n2[a2]; ++s2, ++a2) ;
        return n2.slice(a2).join(".");
      }
      function T(e2) {
        return e2.substring(0, 1) + e2.substring(1).replace(/([A-Z])(?=[a-z]|$)/g, function(e3, t2) {
          return "_" + t2.toLowerCase();
        });
      }
      function O(e2) {
        if ("editions" === e2.syntax) {
          if (e2.edition === t.Edition.EDITION_2023) return "2023";
          throw new Error("Unsupported edition " + e2.edition);
        }
        return "proto3" === e2.syntax ? "proto3" : "proto2";
      }
      p.fromDescriptor = function(e2) {
        return "number" == typeof e2.length && (e2 = t.MethodDescriptorProto.decode(e2)), new p(e2.name && e2.name.length ? e2.name : "Method" + b++, "rpc", e2.inputType, e2.outputType, Boolean(e2.clientStreaming), Boolean(e2.serverStreaming), C(e2.options, t.MethodOptions));
      }, p.prototype.toDescriptor = function() {
        return t.MethodDescriptorProto.create({ name: this.name, inputType: this.resolvedRequestType ? this.resolvedRequestType.fullName : this.requestType, outputType: this.resolvedResponseType ? this.resolvedResponseType.fullName : this.responseType, clientStreaming: this.requestStream, serverStreaming: this.responseStream, options: E(this.options, t.MethodOptions) });
      };
    }, 1511: (e) => {
      const t = { exit: [], beforeExit: [] }, r = { exit: function() {
        o("exit");
      }, beforeExit: function() {
        o("beforeExit");
      } };
      let n;
      function i(e2) {
        t[e2].length > 0 || (process.removeListener(e2, r[e2]), 0 === t.exit.length && 0 === t.beforeExit.length && (n = void 0));
      }
      function o(e2) {
        for (const r2 of t[e2]) {
          const t2 = r2.deref(), n2 = r2.fn;
          void 0 !== t2 && n2(t2, e2);
        }
        t[e2] = [];
      }
      function s(e2) {
        for (const r2 of ["exit", "beforeExit"]) {
          const n2 = t[r2].indexOf(e2);
          t[r2].splice(n2, n2 + 1), i(r2);
        }
      }
      function a(e2, i2, o2) {
        if (void 0 === i2) throw new Error("the object can't be undefined");
        !(function(e3) {
          t[e3].length > 0 || process.on(e3, r[e3]);
        })(e2);
        const a2 = new WeakRef(i2);
        a2.fn = o2, void 0 === n && (n = new FinalizationRegistry(s)), n.register(i2, a2), t[e2].push(a2);
      }
      e.exports = { register: function(e2, t2) {
        a("exit", e2, t2);
      }, registerBeforeExit: function(e2, t2) {
        a("beforeExit", e2, t2);
      }, unregister: function(e2) {
        if (void 0 !== n) {
          n.unregister(e2);
          for (const r2 of ["exit", "beforeExit"]) t[r2] = t[r2].filter((t2) => {
            const r3 = t2.deref();
            return r3 && r3 !== e2;
          }), i(r2);
        }
      } };
    }, 1565: (e, t, r) => {
      e.exports = function e2(t2) {
        if (!o(t2)) return t2;
        t2[l] = void 0;
        const r2 = Object.create(s);
        r2.type = "[object Function]" === c.call(t2.constructor) ? t2.constructor.name : t2.name, r2.message = n(t2), r2.stack = i(t2), Array.isArray(t2.errors) && (r2.aggregateErrors = t2.errors.map((t3) => e2(t3)));
        for (const n2 in t2) if (void 0 === r2[n2]) {
          const i2 = t2[n2];
          o(i2) ? "cause" === n2 || Object.prototype.hasOwnProperty.call(i2, l) || (r2[n2] = e2(i2)) : r2[n2] = i2;
        }
        return delete t2[l], r2.raw = t2, r2;
      };
      const { messageWithCauses: n, stackWithCauses: i, isErrorLike: o } = r(6014), { pinoErrProto: s, pinoErrorSymbols: a } = r(9565), { seen: l } = a, { toString: c } = Object.prototype;
    }, 1604: (e, t, r) => {
      e.exports = i;
      var n = r(5099);
      function i(e2, t2, r2) {
        if ("function" != typeof e2) throw TypeError("rpcImpl must be a function");
        n.EventEmitter.call(this), this.rpcImpl = e2, this.requestDelimited = Boolean(t2), this.responseDelimited = Boolean(r2);
      }
      (i.prototype = Object.create(n.EventEmitter.prototype)).constructor = i, i.prototype.rpcCall = function e2(t2, r2, i2, o, s) {
        if (!o) throw TypeError("request must be specified");
        var a = this;
        if (!s) return n.asPromise(e2, a, t2, r2, i2, o);
        if (a.rpcImpl) try {
          return a.rpcImpl(t2, r2[a.requestDelimited ? "encodeDelimited" : "encode"](o).finish(), function(e3, r3) {
            if (e3) return a.emit("error", e3, t2), s(e3);
            if (null !== r3) {
              if (!(r3 instanceof i2)) try {
                r3 = i2[a.responseDelimited ? "decodeDelimited" : "decode"](r3);
              } catch (e4) {
                return a.emit("error", e4, t2), s(e4);
              }
              return a.emit("data", r3, t2), s(null, r3);
            }
            a.end(true);
          });
        } catch (e3) {
          return a.emit("error", e3, t2), void setTimeout(function() {
            s(e3);
          }, 0);
        }
        else setTimeout(function() {
          s(Error("already ended"));
        }, 0);
      }, i.prototype.end = function(e2) {
        return this.rpcImpl && (e2 || this.rpcImpl(null, null, null), this.rpcImpl = null, this.emit("end").off()), this;
      };
    }, 1668: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.setup = t.getChannelzServiceDefinition = t.getChannelzHandlers = t.unregisterChannelzRef = t.registerChannelzSocket = t.registerChannelzServer = t.registerChannelzSubchannel = t.registerChannelzChannel = t.ChannelzCallTrackerStub = t.ChannelzCallTracker = t.ChannelzChildrenTrackerStub = t.ChannelzChildrenTracker = t.ChannelzTrace = t.ChannelzTraceStub = void 0;
      const n = r(9278), i = r(7054), o = r(5172), s = r(6754), a = r(9939), l = r(7200), c = r(1717);
      function u(e2) {
        return { channel_id: e2.id, name: e2.name };
      }
      function d(e2) {
        return { subchannel_id: e2.id, name: e2.name };
      }
      function p(e2) {
        return { socket_id: e2.id, name: e2.name };
      }
      t.ChannelzTraceStub = class {
        constructor() {
          this.events = [], this.creationTimestamp = /* @__PURE__ */ new Date(), this.eventsLogged = 0;
        }
        addTrace() {
        }
        getTraceMessage() {
          return { creation_timestamp: S(this.creationTimestamp), num_events_logged: this.eventsLogged, events: [] };
        }
      }, t.ChannelzTrace = class {
        constructor() {
          this.events = [], this.eventsLogged = 0, this.creationTimestamp = /* @__PURE__ */ new Date();
        }
        addTrace(e2, t2, r2) {
          const n2 = /* @__PURE__ */ new Date();
          this.events.push({ description: t2, severity: e2, timestamp: n2, childChannel: "channel" === (null == r2 ? void 0 : r2.kind) ? r2 : void 0, childSubchannel: "subchannel" === (null == r2 ? void 0 : r2.kind) ? r2 : void 0 }), this.events.length >= 64 && (this.events = this.events.slice(32)), this.eventsLogged += 1;
        }
        getTraceMessage() {
          return { creation_timestamp: S(this.creationTimestamp), num_events_logged: this.eventsLogged, events: this.events.map((e2) => ({ description: e2.description, severity: e2.severity, timestamp: S(e2.timestamp), channel_ref: e2.childChannel ? u(e2.childChannel) : null, subchannel_ref: e2.childSubchannel ? d(e2.childSubchannel) : null })) };
        }
      };
      class h {
        constructor() {
          this.channelChildren = new i.OrderedMap(), this.subchannelChildren = new i.OrderedMap(), this.socketChildren = new i.OrderedMap(), this.trackerMap = { channel: this.channelChildren, subchannel: this.subchannelChildren, socket: this.socketChildren };
        }
        refChild(e2) {
          const t2 = this.trackerMap[e2.kind], r2 = t2.find(e2.id);
          r2.equals(t2.end()) ? t2.setElement(e2.id, { ref: e2, count: 1 }, r2) : r2.pointer[1].count += 1;
        }
        unrefChild(e2) {
          const t2 = this.trackerMap[e2.kind], r2 = t2.getElementByKey(e2.id);
          void 0 !== r2 && (r2.count -= 1, 0 === r2.count && t2.eraseElementByKey(e2.id));
        }
        getChildLists() {
          return { channels: this.channelChildren, subchannels: this.subchannelChildren, sockets: this.socketChildren };
        }
      }
      t.ChannelzChildrenTracker = h, t.ChannelzChildrenTrackerStub = class extends h {
        refChild() {
        }
        unrefChild() {
        }
      };
      class f {
        constructor() {
          this.callsStarted = 0, this.callsSucceeded = 0, this.callsFailed = 0, this.lastCallStartedTimestamp = null;
        }
        addCallStarted() {
          this.callsStarted += 1, this.lastCallStartedTimestamp = /* @__PURE__ */ new Date();
        }
        addCallSucceeded() {
          this.callsSucceeded += 1;
        }
        addCallFailed() {
          this.callsFailed += 1;
        }
      }
      t.ChannelzCallTracker = f, t.ChannelzCallTrackerStub = class extends f {
        addCallStarted() {
        }
        addCallSucceeded() {
        }
        addCallFailed() {
        }
      };
      const g = { channel: new i.OrderedMap(), subchannel: new i.OrderedMap(), server: new i.OrderedMap(), socket: new i.OrderedMap() }, m = (e2) => {
        let t2 = 1;
        const r2 = g[e2];
        return (n2, i2, o2) => {
          const s2 = t2++, a2 = { id: s2, name: n2, kind: e2 };
          return o2 && r2.setElement(s2, { ref: a2, getInfo: i2 }), a2;
        };
      };
      function y(e2) {
        if ("" === e2) return [];
        const t2 = e2.split(":").map((e3) => (function(e4) {
          const t3 = Number.parseInt(e4, 16);
          return [t3 / 256 | 0, t3 % 256];
        })(e3));
        return [].concat(...t2);
      }
      function v(e2) {
        if ((0, n.isIPv4)(e2)) return Buffer.from(Uint8Array.from(e2.split(".").map((e3) => Number.parseInt(e3))));
        if ((0, n.isIPv6)(e2)) {
          let t2, r2;
          const n2 = e2.indexOf("::");
          -1 === n2 ? (t2 = e2, r2 = "") : (t2 = e2.substring(0, n2), r2 = e2.substring(n2 + 2));
          const i2 = Buffer.from(y(t2)), o2 = Buffer.from(y(r2)), s2 = Buffer.alloc(16 - i2.length - o2.length, 0);
          return Buffer.concat([i2, s2, o2]);
        }
        return null;
      }
      function b(e2) {
        switch (e2) {
          case o.ConnectivityState.CONNECTING:
            return { state: "CONNECTING" };
          case o.ConnectivityState.IDLE:
            return { state: "IDLE" };
          case o.ConnectivityState.READY:
            return { state: "READY" };
          case o.ConnectivityState.SHUTDOWN:
            return { state: "SHUTDOWN" };
          case o.ConnectivityState.TRANSIENT_FAILURE:
            return { state: "TRANSIENT_FAILURE" };
          default:
            return { state: "UNKNOWN" };
        }
      }
      function S(e2) {
        if (!e2) return null;
        const t2 = e2.getTime();
        return { seconds: t2 / 1e3 | 0, nanos: t2 % 1e3 * 1e6 };
      }
      function w(e2) {
        const t2 = e2.getInfo(), r2 = [], n2 = [];
        return t2.children.channels.forEach((e3) => {
          r2.push(u(e3[1].ref));
        }), t2.children.subchannels.forEach((e3) => {
          n2.push(d(e3[1].ref));
        }), { ref: u(e2.ref), data: { target: t2.target, state: b(t2.state), calls_started: t2.callTracker.callsStarted, calls_succeeded: t2.callTracker.callsSucceeded, calls_failed: t2.callTracker.callsFailed, last_call_started_timestamp: S(t2.callTracker.lastCallStartedTimestamp), trace: t2.trace.getTraceMessage() }, channel_ref: r2, subchannel_ref: n2 };
      }
      function C(e2, t2) {
        const r2 = parseInt(e2.request.channel_id, 10), n2 = g.channel.getElementByKey(r2);
        void 0 !== n2 ? t2(null, { channel: w(n2) }) : t2({ code: s.Status.NOT_FOUND, details: "No channel data found for id " + r2 });
      }
      function _2(e2, t2) {
        const r2 = parseInt(e2.request.max_results, 10) || 100, n2 = [], i2 = parseInt(e2.request.start_channel_id, 10), o2 = g.channel;
        let s2;
        for (s2 = o2.lowerBound(i2); !s2.equals(o2.end()) && n2.length < r2; s2 = s2.next()) n2.push(w(s2.pointer[1]));
        t2(null, { channel: n2, end: s2.equals(o2.end()) });
      }
      function E(e2) {
        const t2 = e2.getInfo(), r2 = [];
        return t2.listenerChildren.sockets.forEach((e3) => {
          r2.push(p(e3[1].ref));
        }), { ref: (n2 = e2.ref, { server_id: n2.id }), data: { calls_started: t2.callTracker.callsStarted, calls_succeeded: t2.callTracker.callsSucceeded, calls_failed: t2.callTracker.callsFailed, last_call_started_timestamp: S(t2.callTracker.lastCallStartedTimestamp), trace: t2.trace.getTraceMessage() }, listen_socket: r2 };
        var n2;
      }
      function R(e2, t2) {
        const r2 = parseInt(e2.request.server_id, 10), n2 = g.server.getElementByKey(r2);
        void 0 !== n2 ? t2(null, { server: E(n2) }) : t2({ code: s.Status.NOT_FOUND, details: "No server data found for id " + r2 });
      }
      function T(e2, t2) {
        const r2 = parseInt(e2.request.max_results, 10) || 100, n2 = parseInt(e2.request.start_server_id, 10), i2 = g.server, o2 = [];
        let s2;
        for (s2 = i2.lowerBound(n2); !s2.equals(i2.end()) && o2.length < r2; s2 = s2.next()) o2.push(E(s2.pointer[1]));
        t2(null, { server: o2, end: s2.equals(i2.end()) });
      }
      function O(e2, t2) {
        const r2 = parseInt(e2.request.subchannel_id, 10), n2 = g.subchannel.getElementByKey(r2);
        if (void 0 === n2) return void t2({ code: s.Status.NOT_FOUND, details: "No subchannel data found for id " + r2 });
        const i2 = n2.getInfo(), o2 = [];
        i2.children.sockets.forEach((e3) => {
          o2.push(p(e3[1].ref));
        }), t2(null, { subchannel: { ref: d(n2.ref), data: { target: i2.target, state: b(i2.state), calls_started: i2.callTracker.callsStarted, calls_succeeded: i2.callTracker.callsSucceeded, calls_failed: i2.callTracker.callsFailed, last_call_started_timestamp: S(i2.callTracker.lastCallStartedTimestamp), trace: i2.trace.getTraceMessage() }, socket_ref: o2 } });
      }
      function I(e2) {
        var t2;
        return (0, a.isTcpSubchannelAddress)(e2) ? { address: "tcpip_address", tcpip_address: { ip_address: null !== (t2 = v(e2.host)) && void 0 !== t2 ? t2 : void 0, port: e2.port } } : { address: "uds_address", uds_address: { filename: e2.path } };
      }
      function M(e2, t2) {
        var r2, n2, i2, o2, a2;
        const l2 = parseInt(e2.request.socket_id, 10), c2 = g.socket.getElementByKey(l2);
        if (void 0 === c2) return void t2({ code: s.Status.NOT_FOUND, details: "No socket data found for id " + l2 });
        const u2 = c2.getInfo(), d2 = u2.security ? { model: "tls", tls: { cipher_suite: u2.security.cipherSuiteStandardName ? "standard_name" : "other_name", standard_name: null !== (r2 = u2.security.cipherSuiteStandardName) && void 0 !== r2 ? r2 : void 0, other_name: null !== (n2 = u2.security.cipherSuiteOtherName) && void 0 !== n2 ? n2 : void 0, local_certificate: null !== (i2 = u2.security.localCertificate) && void 0 !== i2 ? i2 : void 0, remote_certificate: null !== (o2 = u2.security.remoteCertificate) && void 0 !== o2 ? o2 : void 0 } } : null;
        t2(null, { socket: { ref: p(c2.ref), local: u2.localAddress ? I(u2.localAddress) : null, remote: u2.remoteAddress ? I(u2.remoteAddress) : null, remote_name: null !== (a2 = u2.remoteName) && void 0 !== a2 ? a2 : void 0, security: d2, data: { keep_alives_sent: u2.keepAlivesSent, streams_started: u2.streamsStarted, streams_succeeded: u2.streamsSucceeded, streams_failed: u2.streamsFailed, last_local_stream_created_timestamp: S(u2.lastLocalStreamCreatedTimestamp), last_remote_stream_created_timestamp: S(u2.lastRemoteStreamCreatedTimestamp), messages_received: u2.messagesReceived, messages_sent: u2.messagesSent, last_message_received_timestamp: S(u2.lastMessageReceivedTimestamp), last_message_sent_timestamp: S(u2.lastMessageSentTimestamp), local_flow_control_window: u2.localFlowControlWindow ? { value: u2.localFlowControlWindow } : null, remote_flow_control_window: u2.remoteFlowControlWindow ? { value: u2.remoteFlowControlWindow } : null } } });
      }
      function k(e2, t2) {
        const r2 = parseInt(e2.request.server_id, 10), n2 = g.server.getElementByKey(r2);
        if (void 0 === n2) return void t2({ code: s.Status.NOT_FOUND, details: "No server data found for id " + r2 });
        const i2 = parseInt(e2.request.start_socket_id, 10), o2 = parseInt(e2.request.max_results, 10) || 100, a2 = n2.getInfo().sessionChildren.sockets, l2 = [];
        let c2;
        for (c2 = a2.lowerBound(i2); !c2.equals(a2.end()) && l2.length < o2; c2 = c2.next()) l2.push(p(c2.pointer[1].ref));
        t2(null, { socket_ref: l2, end: c2.equals(a2.end()) });
      }
      function D() {
        return { GetChannel: C, GetTopChannels: _2, GetServer: R, GetServers: T, GetSubchannel: O, GetSocket: M, GetServerSockets: k };
      }
      t.registerChannelzChannel = m("channel"), t.registerChannelzSubchannel = m("subchannel"), t.registerChannelzServer = m("server"), t.registerChannelzSocket = m("socket"), t.unregisterChannelzRef = function(e2) {
        g[e2.kind].eraseElementByKey(e2.id);
      }, t.getChannelzHandlers = D;
      let P = null;
      function F() {
        if (P) return P;
        const e2 = (0, r(8115).Yi)("channelz.proto", { keepCase: true, longs: String, enums: String, defaults: true, oneofs: true, includeDirs: [`${__dirname}/../../proto`] }), t2 = (0, c.loadPackageDefinition)(e2);
        return P = t2.grpc.channelz.v1.Channelz.service, P;
      }
      t.getChannelzServiceDefinition = F, t.setup = function() {
        (0, l.registerAdminService)(F, D);
      };
    }, 1672: (e, t, r) => {
      var n = e.exports = r(8054);
      n.build = "full", n.tokenize = r(350), n.parse = r(4340), n.common = r(9650), n.Root._configure(n.Type, n.parse, n.common);
    }, 1687: function(e, t, r) {
      var n = this && this.__awaiter || function(e2, t2, r2, n2) {
        return new (r2 || (r2 = Promise))(function(i2, o2) {
          function s2(e3) {
            try {
              l2(n2.next(e3));
            } catch (e4) {
              o2(e4);
            }
          }
          function a2(e3) {
            try {
              l2(n2.throw(e3));
            } catch (e4) {
              o2(e4);
            }
          }
          function l2(e3) {
            var t3;
            e3.done ? i2(e3.value) : (t3 = e3.value, t3 instanceof r2 ? t3 : new r2(function(e4) {
              e4(t3);
            })).then(s2, a2);
          }
          l2((n2 = n2.apply(e2, t2 || [])).next());
        });
      };
      Object.defineProperty(t, "__esModule", { value: true }), t.PROFILE_DOS_EOL = t.SaveStatus = void 0, t.createSession = function() {
        return n(this, arguments, void 0, function* (e2 = "", t2 = "", r2 = "") {
          const n2 = (0, a.getLogger)();
          let o2 = new i.CreateSessionRequest();
          t2.length > 0 && o2.setSessionIdDesired(t2), e2.length > 0 && o2.setFilePath(e2), r2.length > 0 && o2.setCheckpointDirectory(r2), n2.debug({ fn: "createSession", rqst: o2.toObject() });
          const l2 = yield (0, s.getClient)();
          return new Promise((e3, t3) => {
            l2.createSession(o2, (r3, i2) => r3 ? (n2.error({ fn: "createSession", rqst: o2.toObject(), err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3("createSession error: " + r3.message)) : (n2.debug({ fn: "createSession", resp: i2.toObject() }), e3(i2)));
          });
        });
      }, t.destroySession = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, a.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "destroySession", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.destroySession(r2, (n3, o2) => n3 ? (t2.error({ fn: "destroySession", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2("destroySession error: " + n3.message)) : (t2.debug({ fn: "destroySession", resp: o2.toObject() }), e3(o2.getId())));
          });
        });
      }, t.saveSession = function(e2, t2) {
        return n(this, arguments, void 0, function* (e3, t3, r2 = i.IOFlags.IO_FLG_NONE, n2 = 0, o2 = 0) {
          const l2 = (0, a.getLogger)(), c2 = new i.SaveSessionRequest().setSessionId(e3).setFilePath(t3).setIoFlags(r2).setOffset(n2).setLength(o2);
          l2.debug({ fn: "saveSession", rqst: c2.toObject() });
          const u2 = yield (0, s.getClient)();
          return new Promise((e4, t4) => {
            u2.saveSession(c2, (r3, n3) => r3 ? (l2.error({ fn: "saveSession", rqst: c2.toObject(), err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t4("saveSession error: " + r3.message)) : (l2.debug({ fn: "saveSession", resp: n3.toObject() }), e4(n3)));
          });
        });
      }, t.getComputedFileSize = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, a.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "getComputedFileSize", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.getComputedFileSize(r2, (n3, o2) => n3 ? (t2.error({ fn: "getComputedFileSize", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2("getComputedFileSize error: " + n3.message)) : (t2.debug({ fn: "getComputedFileSize", resp: o2.toObject() }), e3(o2.getComputedFileSize())));
          });
        });
      }, t.getCounts = function(e2, t2) {
        return n(this, void 0, void 0, function* () {
          const r2 = (0, a.getLogger)(), n2 = new i.CountRequest().setSessionId(e2).setKindList(t2);
          r2.debug({ fn: "getCounts", rqst: n2.toObject() });
          const o2 = yield (0, s.getClient)();
          return new Promise((e3, t3) => {
            o2.getCount(n2, (i2, o3) => i2 ? (r2.error({ fn: "getCounts", rqst: n2.toObject(), err: { msg: i2.message, details: i2.details, code: i2.code, stack: i2.stack } }), t3("getCounts error: " + i2.message)) : (r2.debug({ fn: "getCounts", resp: o3.toObject() }), e3(o3.getCountsList())));
          });
        });
      }, t.pauseSessionChanges = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, a.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "pauseSessionChanges", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.pauseSessionChanges(r2, (n3, o2) => n3 ? (t2.error({ fn: "pauseSessionChanges", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2("pauseSessionChanges error: " + n3.message)) : (t2.debug({ fn: "pauseSessionChanges", resp: o2.toObject() }), e3(o2.getId())));
          });
        });
      }, t.beginSessionTransaction = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, a.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "beginSessionTransaction", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.sessionBeginTransaction(r2, (n3, o2) => n3 ? (t2.error({ fn: "beginSessionTransaction", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2("beginSessionTransaction error: " + n3.message)) : (t2.debug({ fn: "beginSessionTransaction", resp: o2.toObject() }), e3(o2.getId())));
          });
        });
      }, t.endSessionTransaction = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, a.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "endSessionTransaction", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.sessionEndTransaction(r2, (n3, o2) => n3 ? (t2.error({ fn: "endSessionTransaction", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2("endSessionTransaction error: " + n3.message)) : (t2.debug({ fn: "endSessionTransaction", resp: o2.toObject() }), e3(o2.getId())));
          });
        });
      }, t.resumeSessionChanges = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, a.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "resumeSessionChanges", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.resumeSessionChanges(r2, (n3, o2) => n3 ? (t2.error({ fn: "resumeSessionChanges", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2("resumeSessionChanges error: " + n3.message)) : (t2.debug({ fn: "resumeSessionChanges", resp: o2.toObject() }), e3(o2.getId())));
          });
        });
      }, t.unsubscribeSession = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, a.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "unsubscribeSession", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.unsubscribeToSessionEvents(r2, (n3, o2) => n3 ? (t2.error({ fn: "unsubscribeSession", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2("unsubscribeSession error: " + n3.message)) : (t2.debug({ fn: "unsubscribeSession", resp: o2.toObject() }), e3(o2.getId()))).on("error", (e4) => {
              if (!e4.message.includes("Call cancelled")) throw e4;
            });
          });
        });
      }, t.getSegment = function(e2, t2, r2) {
        return n(this, void 0, void 0, function* () {
          const n2 = (0, a.getLogger)(), o2 = new i.SegmentRequest().setSessionId(e2).setOffset(t2).setLength(r2);
          n2.debug({ fn: "getSegment", rqst: o2.toObject() });
          const l2 = yield (0, s.getClient)();
          return new Promise((e3, t3) => {
            l2.getSegment(o2, (r3, i2) => r3 ? (n2.error({ fn: "getSegment", rqst: o2.toObject(), err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3("getSegment error: " + r3.message)) : (n2.debug({ fn: "getSegment", resp: i2.toObject() }), e3(i2.getData_asU8())));
          });
        });
      }, t.getSessionCount = function() {
        return n(this, void 0, void 0, function* () {
          const e2 = (0, a.getLogger)();
          e2.debug({ fn: "getSessionCount" });
          const t2 = yield (0, s.getClient)();
          return new Promise((r2, n2) => {
            t2.getSessionCount(new o.Empty(), (t3, i2) => t3 ? (e2.error({ fn: "getSessionCount", err: { msg: t3.message, details: t3.details, code: t3.code, stack: t3.stack } }), n2("getSessionCount error: " + t3.message)) : (e2.debug({ fn: "getSessionCount", resp: i2.toObject() }), r2(i2.getCount())));
          });
        });
      }, t.notifyChangedViewports = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, a.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "notifyChangedViewports", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.notifyChangedViewports(r2, (n3, o2) => n3 ? (t2.error({ fn: "notifyChangedViewports", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2("notifyChangedViewports error: " + n3.message)) : (t2.debug({ fn: "notifyChangedViewports", resp: o2.toObject() }), e3(o2.getResponse())));
          });
        });
      }, t.profileSession = function(e2) {
        return n(this, arguments, void 0, function* (e3, t2 = 0, r2 = 0) {
          const n2 = (0, a.getLogger)(), o2 = new i.SegmentRequest().setSessionId(e3).setOffset(t2).setLength(r2);
          n2.debug({ fn: "profileSession", rqst: o2.toObject() });
          const l2 = yield (0, s.getClient)();
          return new Promise((e4, t3) => {
            l2.getByteFrequencyProfile(o2, (r3, i2) => r3 ? (n2.error({ fn: "profileSession", rqst: o2.toObject(), err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3("profileSession error: " + r3.message)) : (n2.debug({ fn: "profileSession", resp: i2.toObject() }), e4(i2.getFrequencyList())));
          });
        });
      }, t.numAscii = function(e2) {
        return e2.slice(0, 128).reduce((e3, t2) => e3 + t2, 0);
      }, t.getByteOrderMark = function(e2) {
        return n(this, arguments, void 0, function* (e3, t2 = 0) {
          const r2 = (0, a.getLogger)(), n2 = new i.SegmentRequest().setSessionId(e3).setOffset(t2).setLength(4);
          r2.debug({ fn: "getByteOrderMark", rqst: n2.toObject() });
          const o2 = yield (0, s.getClient)();
          return new Promise((e4, t3) => {
            o2.getByteOrderMark(n2, (i2, o3) => {
              i2 && (r2.error({ fn: "getByteOrderMark", rqst: n2.toObject(), err: { msg: i2.message, details: i2.details, code: i2.code, stack: i2.stack } }), t3("getByteOrderMark error: " + i2.message)), r2.debug({ fn: "getByteOrderMark", resp: o3.toObject() }), e4(o3);
            });
          });
        });
      }, t.getContentType = function(e2, t2, r2) {
        return n(this, void 0, void 0, function* () {
          const n2 = (0, a.getLogger)(), o2 = new i.SegmentRequest().setSessionId(e2).setOffset(t2).setLength(r2);
          n2.debug({ fn: "getContentType", rqst: o2.toObject() });
          const l2 = yield (0, s.getClient)();
          return new Promise((e3, t3) => {
            l2.getContentType(o2, (r3, i2) => {
              r3 && (n2.error({ fn: "getContentType", rqst: o2.toObject(), err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3("getContentType error: " + r3.message)), n2.debug({ fn: "getContentType", resp: i2.toObject() }), e3(i2);
            });
          });
        });
      }, t.getLanguage = function(e2, t2, r2, o2) {
        return n(this, void 0, void 0, function* () {
          const n2 = (0, a.getLogger)(), l2 = new i.TextRequest().setSessionId(e2).setOffset(t2).setLength(r2).setByteOrderMark(o2);
          n2.debug({ fn: "getLanguage", rqst: l2.toObject() });
          const c2 = yield (0, s.getClient)();
          return new Promise((e3, t3) => {
            c2.getLanguage(l2, (r3, i2) => {
              r3 && (n2.error({ fn: "getLanguage", rqst: l2.toObject(), err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3("getLanguage error: " + r3.message)), n2.debug({ fn: "getLanguage", resp: i2.toObject() }), e3(i2);
            });
          });
        });
      }, t.countCharacters = function(e2) {
        return n(this, arguments, void 0, function* (e3, t2 = 0, r2 = 0, n2 = "none") {
          const o2 = (0, a.getLogger)(), l2 = new i.TextRequest().setSessionId(e3).setOffset(t2).setLength(r2).setByteOrderMark(n2);
          o2.debug({ fn: "countCharacters", rqst: l2.toObject() });
          const c2 = yield (0, s.getClient)();
          return new Promise((e4, t3) => {
            c2.getCharacterCounts(l2, (r3, n3) => r3 ? (o2.error({ fn: "countCharacters", rqst: l2.toObject(), err: { msg: r3.message, details: r3.details, code: r3.code, stack: r3.stack } }), t3("countCharacters error: " + r3.message)) : (o2.debug({ fn: "countCharacters", resp: n3.toObject() }), e4(n3)));
          });
        });
      }, t.searchSession = u, t.replaceSession = function(e2, t2, r2) {
        return n(this, arguments, void 0, function* (e3, t3, r3, n2 = false, i2 = false, o2 = 0, s2 = 0, a2 = 0, c2 = true, d = false, p) {
          const h = yield u(e3, t3, n2, i2, o2, s2, a2), f = "string" == typeof t3 ? Buffer.from(t3) : t3, g = "string" == typeof r3 ? Buffer.from(r3) : r3;
          if (c2) if (d) for (let t4 = 0; t4 < h.length; ++t4) yield (0, l.overwrite)(e3, h[t4], g, p);
          else {
            const t4 = g.length - f.length;
            for (let r4 = 0; r4 < h.length; ++r4) yield (0, l.editSimple)(e3, t4 * r4 + h[r4], f, g, p);
          }
          else if (d) for (let t4 = h.length - 1; t4 >= 0; --t4) yield (0, l.overwrite)(e3, h[t4], g, p);
          else for (let t4 = h.length - 1; t4 >= 0; --t4) yield (0, l.editSimple)(e3, h[t4], f, g, p);
          return h.length;
        });
      }, t.replaceOneSession = function(e2, t2, r2) {
        return n(this, arguments, void 0, function* (e3, t3, r3, n2 = false, i2 = false, o2 = 0, s2 = 0, a2 = false, c2) {
          const d = "string" == typeof t3 ? Buffer.from(t3) : t3, p = "string" == typeof r3 ? Buffer.from(r3) : r3, h = yield u(e3, d, n2, i2, o2, s2, 1);
          return h.length > 0 ? (a2 ? yield (0, l.overwrite)(e3, h[0], p, c2) : yield (0, l.editSimple)(e3, h[0], d, p, c2), h[0] + p.length) : -1;
        });
      };
      const i = r(8039), o = r(9291), s = r(7248), a = r(8943), l = r(647);
      var c;
      function u(e2, t2) {
        return n(this, arguments, void 0, function* (e3, t3, r2 = false, n2 = false, o2 = 0, l2 = 0, c2 = 0) {
          const u2 = (0, a.getLogger)();
          if (0 === t3.length) return u2.warn({ fn: "searchSession", err: { msg: "empty pattern given" } }), [];
          let d = new i.SearchRequest().setSessionId(e3).setPattern("string" == typeof t3 ? Buffer.from(t3) : t3).setIsCaseInsensitive(r2).setIsReverse(n2).setOffset(o2);
          l2 > 0 && d.setLength(l2), c2 > 0 && d.setLimit(c2), u2.debug({ fn: "searchSession", rqst: d.toObject() });
          const p = yield (0, s.getClient)();
          return new Promise((e4, t4) => {
            p.searchSession(d, (r3, n3) => r3 ? t4("searchSession error: " + r3.message) : (u2.debug({ fn: "searchSession", resp: n3.toObject() }), e4(n3.getMatchOffsetList())));
          });
        });
      }
      !(function(e2) {
        e2[e2.SUCCESS = 0] = "SUCCESS", e2[e2.MODIFIED = -100] = "MODIFIED";
      })(c || (t.SaveStatus = c = {})), t.PROFILE_DOS_EOL = 256;
    }, 1717: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.loadPackageDefinition = t.makeClientConstructor = void 0;
      const n = r(7e3), i = { unary: n.Client.prototype.makeUnaryRequest, server_stream: n.Client.prototype.makeServerStreamRequest, client_stream: n.Client.prototype.makeClientStreamRequest, bidi: n.Client.prototype.makeBidiStreamRequest };
      function o(e2) {
        return ["__proto__", "prototype", "constructor"].includes(e2);
      }
      function s(e2, t2, r2) {
        class s2 extends n.Client {
        }
        return Object.keys(e2).forEach((t3) => {
          if (o(t3)) return;
          const r3 = e2[t3];
          let n2;
          if ("string" == typeof t3 && "$" === t3.charAt(0)) throw new Error("Method names cannot start with $");
          n2 = r3.requestStream ? r3.responseStream ? "bidi" : "client_stream" : r3.responseStream ? "server_stream" : "unary";
          const a2 = r3.requestSerialize, l = r3.responseDeserialize, c = /* @__PURE__ */ (function(e3, t4, r4, n3) {
            return function(...i2) {
              return e3.call(this, t4, r4, n3, ...i2);
            };
          })(i[n2], r3.path, a2, l);
          s2.prototype[t3] = c, Object.assign(s2.prototype[t3], r3), r3.originalName && !o(r3.originalName) && (s2.prototype[r3.originalName] = s2.prototype[t3]);
        }), s2.service = e2, s2.serviceName = t2, s2;
      }
      function a(e2) {
        return "format" in e2;
      }
      t.makeClientConstructor = s, t.loadPackageDefinition = function(e2) {
        const t2 = {};
        for (const r2 in e2) if (Object.prototype.hasOwnProperty.call(e2, r2)) {
          const n2 = e2[r2], i2 = r2.split(".");
          if (i2.some((e3) => o(e3))) continue;
          const l = i2[i2.length - 1];
          let c = t2;
          for (const e3 of i2.slice(0, -1)) c[e3] || (c[e3] = {}), c = c[e3];
          a(n2) ? c[l] = n2 : c[l] = s(n2, l);
        }
        return t2;
      };
    }, 1727: (e) => {
      function t(e2) {
        return "undefined" != typeof Float32Array ? (function() {
          var t2 = new Float32Array([-0]), r2 = new Uint8Array(t2.buffer), n2 = 128 === r2[3];
          function i2(e3, n3, i3) {
            t2[0] = e3, n3[i3] = r2[0], n3[i3 + 1] = r2[1], n3[i3 + 2] = r2[2], n3[i3 + 3] = r2[3];
          }
          function o2(e3, n3, i3) {
            t2[0] = e3, n3[i3] = r2[3], n3[i3 + 1] = r2[2], n3[i3 + 2] = r2[1], n3[i3 + 3] = r2[0];
          }
          function s(e3, n3) {
            return r2[0] = e3[n3], r2[1] = e3[n3 + 1], r2[2] = e3[n3 + 2], r2[3] = e3[n3 + 3], t2[0];
          }
          function a(e3, n3) {
            return r2[3] = e3[n3], r2[2] = e3[n3 + 1], r2[1] = e3[n3 + 2], r2[0] = e3[n3 + 3], t2[0];
          }
          e2.writeFloatLE = n2 ? i2 : o2, e2.writeFloatBE = n2 ? o2 : i2, e2.readFloatLE = n2 ? s : a, e2.readFloatBE = n2 ? a : s;
        })() : (function() {
          function t2(e3, t3, r2, n2) {
            var i2 = t3 < 0 ? 1 : 0;
            if (i2 && (t3 = -t3), 0 === t3) e3(1 / t3 > 0 ? 0 : 2147483648, r2, n2);
            else if (isNaN(t3)) e3(2143289344, r2, n2);
            else if (t3 > 34028234663852886e22) e3((i2 << 31 | 2139095040) >>> 0, r2, n2);
            else if (t3 < 11754943508222875e-54) e3((i2 << 31 | Math.round(t3 / 1401298464324817e-60)) >>> 0, r2, n2);
            else {
              var o2 = Math.floor(Math.log(t3) / Math.LN2);
              e3((i2 << 31 | o2 + 127 << 23 | 8388607 & Math.round(t3 * Math.pow(2, -o2) * 8388608)) >>> 0, r2, n2);
            }
          }
          function s(e3, t3, r2) {
            var n2 = e3(t3, r2), i2 = 2 * (n2 >> 31) + 1, o2 = n2 >>> 23 & 255, s2 = 8388607 & n2;
            return 255 === o2 ? s2 ? NaN : i2 * (1 / 0) : 0 === o2 ? 1401298464324817e-60 * i2 * s2 : i2 * Math.pow(2, o2 - 150) * (s2 + 8388608);
          }
          e2.writeFloatLE = t2.bind(null, r), e2.writeFloatBE = t2.bind(null, n), e2.readFloatLE = s.bind(null, i), e2.readFloatBE = s.bind(null, o);
        })(), "undefined" != typeof Float64Array ? (function() {
          var t2 = new Float64Array([-0]), r2 = new Uint8Array(t2.buffer), n2 = 128 === r2[7];
          function i2(e3, n3, i3) {
            t2[0] = e3, n3[i3] = r2[0], n3[i3 + 1] = r2[1], n3[i3 + 2] = r2[2], n3[i3 + 3] = r2[3], n3[i3 + 4] = r2[4], n3[i3 + 5] = r2[5], n3[i3 + 6] = r2[6], n3[i3 + 7] = r2[7];
          }
          function o2(e3, n3, i3) {
            t2[0] = e3, n3[i3] = r2[7], n3[i3 + 1] = r2[6], n3[i3 + 2] = r2[5], n3[i3 + 3] = r2[4], n3[i3 + 4] = r2[3], n3[i3 + 5] = r2[2], n3[i3 + 6] = r2[1], n3[i3 + 7] = r2[0];
          }
          function s(e3, n3) {
            return r2[0] = e3[n3], r2[1] = e3[n3 + 1], r2[2] = e3[n3 + 2], r2[3] = e3[n3 + 3], r2[4] = e3[n3 + 4], r2[5] = e3[n3 + 5], r2[6] = e3[n3 + 6], r2[7] = e3[n3 + 7], t2[0];
          }
          function a(e3, n3) {
            return r2[7] = e3[n3], r2[6] = e3[n3 + 1], r2[5] = e3[n3 + 2], r2[4] = e3[n3 + 3], r2[3] = e3[n3 + 4], r2[2] = e3[n3 + 5], r2[1] = e3[n3 + 6], r2[0] = e3[n3 + 7], t2[0];
          }
          e2.writeDoubleLE = n2 ? i2 : o2, e2.writeDoubleBE = n2 ? o2 : i2, e2.readDoubleLE = n2 ? s : a, e2.readDoubleBE = n2 ? a : s;
        })() : (function() {
          function t2(e3, t3, r2, n2, i2, o2) {
            var s2 = n2 < 0 ? 1 : 0;
            if (s2 && (n2 = -n2), 0 === n2) e3(0, i2, o2 + t3), e3(1 / n2 > 0 ? 0 : 2147483648, i2, o2 + r2);
            else if (isNaN(n2)) e3(0, i2, o2 + t3), e3(2146959360, i2, o2 + r2);
            else if (n2 > 17976931348623157e292) e3(0, i2, o2 + t3), e3((s2 << 31 | 2146435072) >>> 0, i2, o2 + r2);
            else {
              var a;
              if (n2 < 22250738585072014e-324) e3((a = n2 / 5e-324) >>> 0, i2, o2 + t3), e3((s2 << 31 | a / 4294967296) >>> 0, i2, o2 + r2);
              else {
                var l = Math.floor(Math.log(n2) / Math.LN2);
                1024 === l && (l = 1023), e3(4503599627370496 * (a = n2 * Math.pow(2, -l)) >>> 0, i2, o2 + t3), e3((s2 << 31 | l + 1023 << 20 | 1048576 * a & 1048575) >>> 0, i2, o2 + r2);
              }
            }
          }
          function s(e3, t3, r2, n2, i2) {
            var o2 = e3(n2, i2 + t3), s2 = e3(n2, i2 + r2), a = 2 * (s2 >> 31) + 1, l = s2 >>> 20 & 2047, c = 4294967296 * (1048575 & s2) + o2;
            return 2047 === l ? c ? NaN : a * (1 / 0) : 0 === l ? 5e-324 * a * c : a * Math.pow(2, l - 1075) * (c + 4503599627370496);
          }
          e2.writeDoubleLE = t2.bind(null, r, 0, 4), e2.writeDoubleBE = t2.bind(null, n, 4, 0), e2.readDoubleLE = s.bind(null, i, 0, 4), e2.readDoubleBE = s.bind(null, o, 4, 0);
        })(), e2;
      }
      function r(e2, t2, r2) {
        t2[r2] = 255 & e2, t2[r2 + 1] = e2 >>> 8 & 255, t2[r2 + 2] = e2 >>> 16 & 255, t2[r2 + 3] = e2 >>> 24;
      }
      function n(e2, t2, r2) {
        t2[r2] = e2 >>> 24, t2[r2 + 1] = e2 >>> 16 & 255, t2[r2 + 2] = e2 >>> 8 & 255, t2[r2 + 3] = 255 & e2;
      }
      function i(e2, t2) {
        return (e2[t2] | e2[t2 + 1] << 8 | e2[t2 + 2] << 16 | e2[t2 + 3] << 24) >>> 0;
      }
      function o(e2, t2) {
        return (e2[t2] << 24 | e2[t2 + 1] << 16 | e2[t2 + 2] << 8 | e2[t2 + 3]) >>> 0;
      }
      e.exports = t(t);
    }, 1840: (e) => {
      const t = 1000000000n, r = 1000000n * BigInt(Date.now()), n = process.hrtime.bigint();
      e.exports = { nullTime: () => "", epochTime: () => `,"time":${Date.now()}`, unixTime: () => `,"time":${Math.round(Date.now() / 1e3)}`, isoTime: () => `,"time":"${new Date(Date.now()).toISOString()}"`, isoTimeNano: () => {
        const e2 = process.hrtime.bigint() - n, i = r + e2, o = i % t, s = Number(i / t * 1000n + o / 1000000n), a = new Date(s);
        return `,"time":"${a.getUTCFullYear()}-${(a.getUTCMonth() + 1).toString().padStart(2, "0")}-${a.getUTCDate().toString().padStart(2, "0")}T${a.getUTCHours().toString().padStart(2, "0")}:${a.getUTCMinutes().toString().padStart(2, "0")}:${a.getUTCSeconds().toString().padStart(2, "0")}.${o.toString().padStart(9, "0")}Z"`;
      } };
    }, 1934: (e, t, r) => {
      (() => {
        var t2 = { 317: (e2) => {
          e2.exports = r(5317);
        }, 783: function(e2, t3, r2) {
          var n2 = this && this.__awaiter || function(e3, t4, r3, n3) {
            return new (r3 || (r3 = Promise))(function(i3, o2) {
              function s2(e4) {
                try {
                  l2(n3.next(e4));
                } catch (e5) {
                  o2(e5);
                }
              }
              function a2(e4) {
                try {
                  l2(n3.throw(e4));
                } catch (e5) {
                  o2(e5);
                }
              }
              function l2(e4) {
                var t5;
                e4.done ? i3(e4.value) : (t5 = e4.value, t5 instanceof r3 ? t5 : new r3(function(e5) {
                  e5(t5);
                })).then(s2, a2);
              }
              l2((n3 = n3.apply(e3, t4 || [])).next());
            });
          };
          Object.defineProperty(t3, "__esModule", { value: true }), t3.runServer = function(e3) {
            return n2(this, arguments, void 0, function* (e4, t4 = "127.0.0.1", r3, l2) {
              const u = [`--interface=${t4}`, `--port=${e4}`];
              return r3 && u.push(`--pidfile=${r3}`), l2 && o.existsSync(l2) && u.push(`-Dlogback.configurationFile=${l2}`), yield (function(e5) {
                return n2(this, void 0, void 0, function* () {
                  var t5;
                  const r4 = a.join(c(a.resolve(__dirname)), "win32" !== s.platform() || (null === (t5 = define_process_env_default.SHELL) || void 0 === t5 ? void 0 : t5.includes("bash")) ? "omega-edit-grpc-server" : "omega-edit-grpc-server.bat");
                  o.chmodSync(r4, "755");
                  const n3 = (0, i2.spawn)(r4, e5, { cwd: a.dirname(r4), detached: true, shell: s.platform().startsWith("win"), stdio: ["ignore", "ignore", "ignore"], windowsHide: true });
                  return n3.on("error", (e6) => {
                    if (!e6.message.includes("Call cancelled")) throw e6;
                  }), n3;
                });
              })(u);
            });
          };
          const i2 = r2(317), o = r2(896), s = r2(857), a = r2(928), l = (e3) => {
            const t4 = "node_modules/@omega-edit/server", r3 = [a.join(e3, t4, "bin"), a.join(e3, t4, "out", "bin")];
            for (const e4 of r3) if (o.existsSync(e4)) return a.resolve(e4);
            return c(a.join(e3, ".."));
          }, c = (e3) => e3.endsWith("node_modules") ? l(e3.replace("node_modules", "")) : o.readdirSync(e3).includes("node_modules") ? l(e3) : c(a.join(e3, ".."));
        }, 857: (e2) => {
          e2.exports = r(857);
        }, 896: (e2) => {
          e2.exports = r(9896);
        }, 928: (e2) => {
          e2.exports = r(6928);
        } }, n = {}, i = (function e2(r2) {
          var i2 = n[r2];
          if (void 0 !== i2) return i2.exports;
          var o = n[r2] = { exports: {} };
          return t2[r2].call(o.exports, o, o.exports, e2), o.exports;
        })(783);
        e.exports = i;
      })();
    }, 2018: (e) => {
      e.exports = require$$4;
    }, 2149: (e) => {
      function t() {
        this._listeners = {};
      }
      e.exports = t, t.prototype.on = function(e2, t2, r) {
        return (this._listeners[e2] || (this._listeners[e2] = [])).push({ fn: t2, ctx: r || this }), this;
      }, t.prototype.off = function(e2, t2) {
        if (void 0 === e2) this._listeners = {};
        else if (void 0 === t2) this._listeners[e2] = [];
        else for (var r = this._listeners[e2], n = 0; n < r.length; ) r[n].fn === t2 ? r.splice(n, 1) : ++n;
        return this;
      }, t.prototype.emit = function(e2) {
        var t2 = this._listeners[e2];
        if (t2) {
          for (var r = [], n = 1; n < arguments.length; ) r.push(arguments[n++]);
          for (n = 0; n < t2.length; ) t2[n].fn.apply(t2[n++].ctx, r);
        }
        return this;
      };
    }, 2173: (e, t) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.InterceptingListenerImpl = t.isInterceptingListener = void 0, t.isInterceptingListener = function(e2) {
        return void 0 !== e2.onReceiveMetadata && 1 === e2.onReceiveMetadata.length;
      }, t.InterceptingListenerImpl = class {
        constructor(e2, t2) {
          this.listener = e2, this.nextListener = t2, this.processingMetadata = false, this.hasPendingMessage = false, this.processingMessage = false, this.pendingStatus = null;
        }
        processPendingMessage() {
          this.hasPendingMessage && (this.nextListener.onReceiveMessage(this.pendingMessage), this.pendingMessage = null, this.hasPendingMessage = false);
        }
        processPendingStatus() {
          this.pendingStatus && this.nextListener.onReceiveStatus(this.pendingStatus);
        }
        onReceiveMetadata(e2) {
          this.processingMetadata = true, this.listener.onReceiveMetadata(e2, (e3) => {
            this.processingMetadata = false, this.nextListener.onReceiveMetadata(e3), this.processPendingMessage(), this.processPendingStatus();
          });
        }
        onReceiveMessage(e2) {
          this.processingMessage = true, this.listener.onReceiveMessage(e2, (e3) => {
            this.processingMessage = false, this.processingMetadata ? (this.pendingMessage = e3, this.hasPendingMessage = true) : (this.nextListener.onReceiveMessage(e3), this.processPendingStatus());
          });
        }
        onReceiveStatus(e2) {
          this.listener.onReceiveStatus(e2, (e3) => {
            this.processingMetadata || this.processingMessage ? this.pendingStatus = e3 : this.nextListener.onReceiveStatus(e3);
          });
        }
      };
    }, 2175: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.experimental = t.ServerInterceptingCall = t.ResponderBuilder = t.ServerListenerBuilder = t.addAdminServicesToServer = t.getChannelzHandlers = t.getChannelzServiceDefinition = t.InterceptorConfigurationError = t.InterceptingCall = t.RequesterBuilder = t.ListenerBuilder = t.StatusBuilder = t.getClientChannel = t.ServerCredentials = t.Server = t.setLogVerbosity = t.setLogger = t.load = t.loadObject = t.CallCredentials = t.ChannelCredentials = t.waitForClientReady = t.closeClient = t.Channel = t.makeGenericClientConstructor = t.makeClientConstructor = t.loadPackageDefinition = t.Client = t.compressionAlgorithms = t.propagate = t.connectivityState = t.status = t.logVerbosity = t.Metadata = t.credentials = void 0;
      const n = r(9792);
      Object.defineProperty(t, "CallCredentials", { enumerable: true, get: function() {
        return n.CallCredentials;
      } });
      const i = r(9292);
      Object.defineProperty(t, "Channel", { enumerable: true, get: function() {
        return i.ChannelImplementation;
      } });
      const o = r(3388);
      Object.defineProperty(t, "compressionAlgorithms", { enumerable: true, get: function() {
        return o.CompressionAlgorithms;
      } });
      const s = r(5172);
      Object.defineProperty(t, "connectivityState", { enumerable: true, get: function() {
        return s.ConnectivityState;
      } });
      const a = r(7015);
      Object.defineProperty(t, "ChannelCredentials", { enumerable: true, get: function() {
        return a.ChannelCredentials;
      } });
      const l = r(7e3);
      Object.defineProperty(t, "Client", { enumerable: true, get: function() {
        return l.Client;
      } });
      const c = r(6754);
      Object.defineProperty(t, "logVerbosity", { enumerable: true, get: function() {
        return c.LogVerbosity;
      } }), Object.defineProperty(t, "status", { enumerable: true, get: function() {
        return c.Status;
      } }), Object.defineProperty(t, "propagate", { enumerable: true, get: function() {
        return c.Propagate;
      } });
      const u = r(4398), d = r(1717);
      Object.defineProperty(t, "loadPackageDefinition", { enumerable: true, get: function() {
        return d.loadPackageDefinition;
      } }), Object.defineProperty(t, "makeClientConstructor", { enumerable: true, get: function() {
        return d.makeClientConstructor;
      } }), Object.defineProperty(t, "makeGenericClientConstructor", { enumerable: true, get: function() {
        return d.makeClientConstructor;
      } });
      const p = r(9074);
      Object.defineProperty(t, "Metadata", { enumerable: true, get: function() {
        return p.Metadata;
      } });
      const h = r(8460);
      Object.defineProperty(t, "Server", { enumerable: true, get: function() {
        return h.Server;
      } });
      const f = r(3191);
      Object.defineProperty(t, "ServerCredentials", { enumerable: true, get: function() {
        return f.ServerCredentials;
      } });
      const g = r(6931);
      Object.defineProperty(t, "StatusBuilder", { enumerable: true, get: function() {
        return g.StatusBuilder;
      } }), t.credentials = { combineChannelCredentials: (e2, ...t2) => t2.reduce((e3, t3) => e3.compose(t3), e2), combineCallCredentials: (e2, ...t2) => t2.reduce((e3, t3) => e3.compose(t3), e2), createInsecure: a.ChannelCredentials.createInsecure, createSsl: a.ChannelCredentials.createSsl, createFromSecureContext: a.ChannelCredentials.createFromSecureContext, createFromMetadataGenerator: n.CallCredentials.createFromMetadataGenerator, createFromGoogleCredential: n.CallCredentials.createFromGoogleCredential, createEmpty: n.CallCredentials.createEmpty }, t.closeClient = (e2) => e2.close(), t.waitForClientReady = (e2, t2, r2) => e2.waitForReady(t2, r2), t.loadObject = (e2, t2) => {
        throw new Error("Not available in this library. Use @grpc/proto-loader and loadPackageDefinition instead");
      }, t.load = (e2, t2, r2) => {
        throw new Error("Not available in this library. Use @grpc/proto-loader and loadPackageDefinition instead");
      }, t.setLogger = (e2) => {
        u.setLogger(e2);
      }, t.setLogVerbosity = (e2) => {
        u.setLoggerVerbosity(e2);
      }, t.getClientChannel = (e2) => l.Client.prototype.getChannel.call(e2);
      var m = r(5989);
      Object.defineProperty(t, "ListenerBuilder", { enumerable: true, get: function() {
        return m.ListenerBuilder;
      } }), Object.defineProperty(t, "RequesterBuilder", { enumerable: true, get: function() {
        return m.RequesterBuilder;
      } }), Object.defineProperty(t, "InterceptingCall", { enumerable: true, get: function() {
        return m.InterceptingCall;
      } }), Object.defineProperty(t, "InterceptorConfigurationError", { enumerable: true, get: function() {
        return m.InterceptorConfigurationError;
      } });
      var y = r(1668);
      Object.defineProperty(t, "getChannelzServiceDefinition", { enumerable: true, get: function() {
        return y.getChannelzServiceDefinition;
      } }), Object.defineProperty(t, "getChannelzHandlers", { enumerable: true, get: function() {
        return y.getChannelzHandlers;
      } });
      var v = r(7200);
      Object.defineProperty(t, "addAdminServicesToServer", { enumerable: true, get: function() {
        return v.addAdminServicesToServer;
      } });
      var b = r(9449);
      Object.defineProperty(t, "ServerListenerBuilder", { enumerable: true, get: function() {
        return b.ServerListenerBuilder;
      } }), Object.defineProperty(t, "ResponderBuilder", { enumerable: true, get: function() {
        return b.ResponderBuilder;
      } }), Object.defineProperty(t, "ServerInterceptingCall", { enumerable: true, get: function() {
        return b.ServerInterceptingCall;
      } });
      const S = r(3037);
      t.experimental = S;
      const w = r(7439), C = r(4714), _2 = r(7951), E = r(6509), R = r(7994), T = r(7121), O = r(1668);
      w.setup(), C.setup(), _2.setup(), E.setup(), R.setup(), T.setup(), O.setup();
    }, 2195: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.Http2SubchannelCall = void 0;
      const n = r(5675), i = r(857), o = r(6754), s = r(9074), a = r(3982), l = r(4398), c = r(6754);
      function u(e2) {
        const t2 = `Received HTTP status code ${e2}`;
        let r2;
        switch (e2) {
          case 400:
            r2 = o.Status.INTERNAL;
            break;
          case 401:
            r2 = o.Status.UNAUTHENTICATED;
            break;
          case 403:
            r2 = o.Status.PERMISSION_DENIED;
            break;
          case 404:
            r2 = o.Status.UNIMPLEMENTED;
            break;
          case 429:
          case 502:
          case 503:
          case 504:
            r2 = o.Status.UNAVAILABLE;
            break;
          default:
            r2 = o.Status.UNKNOWN;
        }
        return { code: r2, details: t2, metadata: new s.Metadata() };
      }
      t.Http2SubchannelCall = class {
        constructor(e2, t2, r2, l2, c2) {
          var d;
          this.http2Stream = e2, this.callEventTracker = t2, this.listener = r2, this.transport = l2, this.callId = c2, this.isReadFilterPending = false, this.isPushPending = false, this.canPush = false, this.readsClosed = false, this.statusOutput = false, this.unpushedReadMessages = [], this.finalStatus = null, this.internalError = null, this.serverEndedCall = false;
          const p = null !== (d = l2.getOptions()["grpc.max_receive_message_length"]) && void 0 !== d ? d : o.DEFAULT_MAX_RECEIVE_MESSAGE_LENGTH;
          this.decoder = new a.StreamDecoder(p), e2.on("response", (e3, t3) => {
            let r3 = "";
            for (const t4 of Object.keys(e3)) r3 += "		" + t4 + ": " + e3[t4] + "\n";
            if (this.trace("Received server headers:\n" + r3), this.httpStatusCode = e3[":status"], t3 & n.constants.NGHTTP2_FLAG_END_STREAM) this.handleTrailers(e3);
            else {
              let t4;
              try {
                t4 = s.Metadata.fromHttp2Headers(e3);
              } catch (e4) {
                return void this.endCall({ code: o.Status.UNKNOWN, details: e4.message, metadata: new s.Metadata() });
              }
              this.listener.onReceiveMetadata(t4);
            }
          }), e2.on("trailers", (e3) => {
            this.handleTrailers(e3);
          }), e2.on("data", (e3) => {
            if (this.statusOutput) return;
            let t3;
            this.trace("receive HTTP/2 data frame of length " + e3.length);
            try {
              t3 = this.decoder.write(e3);
            } catch (e4) {
              return void this.cancelWithStatus(o.Status.RESOURCE_EXHAUSTED, e4.message);
            }
            for (const e4 of t3) this.trace("parsed message of length " + e4.length), this.callEventTracker.addMessageReceived(), this.tryPush(e4);
          }), e2.on("end", () => {
            this.readsClosed = true, this.maybeOutputStatus();
          }), e2.on("close", () => {
            this.serverEndedCall = true, process.nextTick(() => {
              var t3;
              if (this.trace("HTTP/2 stream closed with code " + e2.rstCode), (null === (t3 = this.finalStatus) || void 0 === t3 ? void 0 : t3.code) === o.Status.OK) return;
              let r3, i2 = "";
              switch (e2.rstCode) {
                case n.constants.NGHTTP2_NO_ERROR:
                  if (null !== this.finalStatus) return;
                  if (this.httpStatusCode && 200 !== this.httpStatusCode) {
                    const e3 = u(this.httpStatusCode);
                    r3 = e3.code, i2 = e3.details;
                  } else r3 = o.Status.INTERNAL, i2 = `Received RST_STREAM with code ${e2.rstCode} (Call ended without gRPC status)`;
                  break;
                case n.constants.NGHTTP2_REFUSED_STREAM:
                  r3 = o.Status.UNAVAILABLE, i2 = "Stream refused by server";
                  break;
                case n.constants.NGHTTP2_CANCEL:
                  r3 = o.Status.CANCELLED, i2 = "Call cancelled";
                  break;
                case n.constants.NGHTTP2_ENHANCE_YOUR_CALM:
                  r3 = o.Status.RESOURCE_EXHAUSTED, i2 = "Bandwidth exhausted or memory limit exceeded";
                  break;
                case n.constants.NGHTTP2_INADEQUATE_SECURITY:
                  r3 = o.Status.PERMISSION_DENIED, i2 = "Protocol not secure enough";
                  break;
                case n.constants.NGHTTP2_INTERNAL_ERROR:
                  r3 = o.Status.INTERNAL, null === this.internalError ? i2 = `Received RST_STREAM with code ${e2.rstCode} (Internal server error)` : "ECONNRESET" === this.internalError.code || "ETIMEDOUT" === this.internalError.code ? (r3 = o.Status.UNAVAILABLE, i2 = this.internalError.message) : i2 = `Received RST_STREAM with code ${e2.rstCode} triggered by internal client error: ${this.internalError.message}`;
                  break;
                default:
                  r3 = o.Status.INTERNAL, i2 = `Received RST_STREAM with code ${e2.rstCode}`;
              }
              this.endCall({ code: r3, details: i2, metadata: new s.Metadata(), rstCode: e2.rstCode });
            });
          }), e2.on("error", (e3) => {
            "ERR_HTTP2_STREAM_ERROR" !== e3.code && (this.trace("Node error event: message=" + e3.message + " code=" + e3.code + " errno=" + (function(e4) {
              for (const [t3, r3] of Object.entries(i.constants.errno)) if (r3 === e4) return t3;
              return "Unknown system error " + e4;
            })(e3.errno) + " syscall=" + e3.syscall), this.internalError = e3), this.callEventTracker.onStreamEnd(false);
          });
        }
        getDeadlineInfo() {
          return [`remote_addr=${this.getPeer()}`];
        }
        onDisconnect() {
          this.endCall({ code: o.Status.UNAVAILABLE, details: "Connection dropped", metadata: new s.Metadata() });
        }
        outputStatus() {
          this.statusOutput || (this.statusOutput = true, this.trace("ended with status: code=" + this.finalStatus.code + ' details="' + this.finalStatus.details + '"'), this.callEventTracker.onCallEnd(this.finalStatus), process.nextTick(() => {
            this.listener.onReceiveStatus(this.finalStatus);
          }), this.http2Stream.resume());
        }
        trace(e2) {
          l.trace(c.LogVerbosity.DEBUG, "subchannel_call", "[" + this.callId + "] " + e2);
        }
        endCall(e2) {
          null !== this.finalStatus && this.finalStatus.code !== o.Status.OK || (this.finalStatus = e2, this.maybeOutputStatus()), this.destroyHttp2Stream();
        }
        maybeOutputStatus() {
          null !== this.finalStatus && (this.finalStatus.code !== o.Status.OK || this.readsClosed && 0 === this.unpushedReadMessages.length && !this.isReadFilterPending && !this.isPushPending) && this.outputStatus();
        }
        push(e2) {
          this.trace("pushing to reader message of length " + (e2 instanceof Buffer ? e2.length : null)), this.canPush = false, this.isPushPending = true, process.nextTick(() => {
            this.isPushPending = false, this.statusOutput || (this.listener.onReceiveMessage(e2), this.maybeOutputStatus());
          });
        }
        tryPush(e2) {
          this.canPush ? (this.http2Stream.pause(), this.push(e2)) : (this.trace("unpushedReadMessages.push message of length " + e2.length), this.unpushedReadMessages.push(e2));
        }
        handleTrailers(e2) {
          this.serverEndedCall = true, this.callEventTracker.onStreamEnd(true);
          let t2, r2 = "";
          for (const t3 of Object.keys(e2)) r2 += "		" + t3 + ": " + e2[t3] + "\n";
          this.trace("Received server trailers:\n" + r2);
          try {
            t2 = s.Metadata.fromHttp2Headers(e2);
          } catch (e3) {
            t2 = new s.Metadata();
          }
          const n2 = t2.getMap();
          let i2;
          if ("string" == typeof n2["grpc-status"]) {
            const e3 = Number(n2["grpc-status"]);
            this.trace("received status code " + e3 + " from server"), t2.remove("grpc-status");
            let r3 = "";
            if ("string" == typeof n2["grpc-message"]) {
              try {
                r3 = decodeURI(n2["grpc-message"]);
              } catch (e4) {
                r3 = n2["grpc-message"];
              }
              t2.remove("grpc-message"), this.trace('received status details string "' + r3 + '" from server');
            }
            i2 = { code: e3, details: r3, metadata: t2 };
          } else this.httpStatusCode ? (i2 = u(this.httpStatusCode), i2.metadata = t2) : i2 = { code: o.Status.UNKNOWN, details: "No status information received", metadata: t2 };
          this.endCall(i2);
        }
        destroyHttp2Stream() {
          var e2;
          if (!this.http2Stream.destroyed) if (this.serverEndedCall) this.http2Stream.end();
          else {
            let t2;
            t2 = (null === (e2 = this.finalStatus) || void 0 === e2 ? void 0 : e2.code) === o.Status.OK ? n.constants.NGHTTP2_NO_ERROR : n.constants.NGHTTP2_CANCEL, this.trace("close http2 stream with code " + t2), this.http2Stream.close(t2);
          }
        }
        cancelWithStatus(e2, t2) {
          this.trace("cancelWithStatus code: " + e2 + ' details: "' + t2 + '"'), this.endCall({ code: e2, details: t2, metadata: new s.Metadata() });
        }
        getStatus() {
          return this.finalStatus;
        }
        getPeer() {
          return this.transport.getPeerName();
        }
        getCallNumber() {
          return this.callId;
        }
        startRead() {
          if (null !== this.finalStatus && this.finalStatus.code !== o.Status.OK) return this.readsClosed = true, void this.maybeOutputStatus();
          if (this.canPush = true, this.unpushedReadMessages.length > 0) {
            const e2 = this.unpushedReadMessages.shift();
            return void this.push(e2);
          }
          this.http2Stream.resume();
        }
        sendMessageWithContext(e2, t2) {
          this.trace("write() called with message of length " + t2.length);
          const r2 = (t3) => {
            process.nextTick(() => {
              var r3;
              let n2 = o.Status.UNAVAILABLE;
              "ERR_STREAM_WRITE_AFTER_END" === (null == t3 ? void 0 : t3.code) && (n2 = o.Status.INTERNAL), t3 && this.cancelWithStatus(n2, `Write error: ${t3.message}`), null === (r3 = e2.callback) || void 0 === r3 || r3.call(e2);
            });
          };
          this.trace("sending data chunk of length " + t2.length), this.callEventTracker.addMessageSent();
          try {
            this.http2Stream.write(t2, r2);
          } catch (e3) {
            this.endCall({ code: o.Status.UNAVAILABLE, details: `Write failed with error ${e3.message}`, metadata: new s.Metadata() });
          }
        }
        halfClose() {
          this.trace("end() called"), this.trace("calling end() on HTTP/2 stream"), this.http2Stream.end();
        }
      };
    }, 2203: (e) => {
      e.exports = require$$0;
    }, 2250: (e) => {
      e.exports = require$$6;
    }, 2461: (e) => {
      e.exports = function(e2, t, r) {
        var n = r || 8192, i = n >>> 1, o = null, s = n;
        return function(r2) {
          if (r2 < 1 || r2 > i) return e2(r2);
          s + r2 > n && (o = e2(n), s = 0);
          var a = t.call(o, s, s += r2);
          return 7 & s && (s = 1 + (7 | s)), a;
        };
      };
    }, 2533: (e, t, r) => {
      e.exports = o;
      var n = r(3108);
      (o.prototype = Object.create(n.prototype)).constructor = o;
      var i = r(5099);
      function o() {
        n.call(this);
      }
      function s(e2, t2, r2) {
        e2.length < 40 ? i.utf8.write(e2, t2, r2) : t2.utf8Write ? t2.utf8Write(e2, r2) : t2.write(e2, r2);
      }
      o._configure = function() {
        o.alloc = i._Buffer_allocUnsafe, o.writeBytesBuffer = i.Buffer && i.Buffer.prototype instanceof Uint8Array && "set" === i.Buffer.prototype.set.name ? function(e2, t2, r2) {
          t2.set(e2, r2);
        } : function(e2, t2, r2) {
          if (e2.copy) e2.copy(t2, r2, 0, e2.length);
          else for (var n2 = 0; n2 < e2.length; ) t2[r2++] = e2[n2++];
        };
      }, o.prototype.bytes = function(e2) {
        i.isString(e2) && (e2 = i._Buffer_from(e2, "base64"));
        var t2 = e2.length >>> 0;
        return this.uint32(t2), t2 && this._push(o.writeBytesBuffer, t2, e2), this;
      }, o.prototype.string = function(e2) {
        var t2 = i.Buffer.byteLength(e2);
        return this.uint32(t2), t2 && this._push(s, t2, e2), this;
      }, o._configure();
    }, 2534: (e, t, r) => {
      const n = r(3053), i = r(3930), { mapHttpRequest: o, mapHttpResponse: s } = r(8989), a = r(1021), l = r(1511), { lsCacheSym: c, chindingsSym: u, writeSym: d, serializersSym: p, formatOptsSym: h, endSym: f, stringifiersSym: g, stringifySym: m, stringifySafeSym: y, wildcardFirstSym: v, nestedKeySym: b, formattersSym: S, messageKeySym: w, errorKeySym: C, nestedKeyStrSym: _2, msgPrefixSym: E } = r(7960), { isMainThread: R } = r(8167), T = r(3964), O = n.tracingChannel("pino_asJson");
      function I() {
      }
      function M(e2) {
        let t2 = "", r2 = 0, n2 = false, i2 = 255;
        const o2 = e2.length;
        if (o2 > 100) return JSON.stringify(e2);
        for (var s2 = 0; s2 < o2 && i2 >= 32; s2++) i2 = e2.charCodeAt(s2), 34 !== i2 && 92 !== i2 || (t2 += e2.slice(r2, s2) + "\\", r2 = s2, n2 = true);
        return n2 ? t2 += e2.slice(r2) : t2 = e2, i2 < 32 ? JSON.stringify(e2) : '"' + t2 + '"';
      }
      function k(e2, t2, r2, n2) {
        const i2 = this[m], o2 = this[y], s2 = this[g], a2 = this[f], l2 = this[u], d2 = this[p], h2 = this[S], E2 = this[w], R2 = this[C];
        let T2, O2 = this[c][r2] + n2;
        O2 += l2, h2.log && (e2 = h2.log(e2));
        const I2 = s2[v];
        let k2 = "";
        for (const t3 in e2) if (T2 = e2[t3], Object.prototype.hasOwnProperty.call(e2, t3) && void 0 !== T2) {
          d2[t3] ? T2 = d2[t3](T2) : t3 === R2 && d2.err && (T2 = d2.err(T2));
          const e3 = s2[t3] || I2;
          switch (typeof T2) {
            case "undefined":
            case "function":
              continue;
            case "number":
              false === Number.isFinite(T2) && (T2 = null);
            case "boolean":
              e3 && (T2 = e3(T2));
              break;
            case "string":
              T2 = (e3 || M)(T2);
              break;
            default:
              T2 = (e3 || i2)(T2, o2);
          }
          if (void 0 === T2) continue;
          k2 += "," + M(t3) + ":" + T2;
        }
        let D2 = "";
        if (void 0 !== t2) {
          T2 = d2[E2] ? d2[E2](t2) : t2;
          const e3 = s2[E2] || I2;
          switch (typeof T2) {
            case "function":
              break;
            case "number":
              false === Number.isFinite(T2) && (T2 = null);
            case "boolean":
              e3 && (T2 = e3(T2)), D2 = ',"' + E2 + '":' + T2;
              break;
            case "string":
              T2 = (e3 || M)(T2), D2 = ',"' + E2 + '":' + T2;
              break;
            default:
              T2 = (e3 || i2)(T2, o2), D2 = ',"' + E2 + '":' + T2;
          }
        }
        return this[b] && k2 ? O2 + this[_2] + k2.slice(1) + "}" + D2 + a2 : O2 + k2 + D2 + a2;
      }
      function D(e2) {
        const t2 = new a(e2);
        return t2.on("error", function e3(r2) {
          if ("EPIPE" === r2.code) return t2.write = I, t2.end = I, t2.flushSync = I, void (t2.destroy = I);
          t2.removeListener("error", e3), t2.emit("error", r2);
        }), !e2.sync && R && (l.register(t2, P), t2.on("close", function() {
          l.unregister(t2);
        })), t2;
      }
      function P(e2, t2) {
        e2.destroyed || ("beforeExit" === t2 ? (e2.flush(), e2.on("drain", function() {
          e2.end();
        })) : e2.flushSync());
      }
      e.exports = { noop: I, buildSafeSonicBoom: D, asChindings: function(e2, t2) {
        let r2, n2 = e2[u];
        const i2 = e2[m], o2 = e2[y], s2 = e2[g], a2 = s2[v], l2 = e2[p];
        t2 = (0, e2[S].bindings)(t2);
        for (const e3 in t2) if (r2 = t2[e3], true === ((e3.length < 5 || "level" !== e3 && "serializers" !== e3 && "formatters" !== e3 && "customLevels" !== e3) && t2.hasOwnProperty(e3) && void 0 !== r2)) {
          if (r2 = l2[e3] ? l2[e3](r2) : r2, r2 = (s2[e3] || a2 || i2)(r2, o2), void 0 === r2) continue;
          n2 += ',"' + e3 + '":' + r2;
        }
        return n2;
      }, asJson: function(e2, t2, r2, n2) {
        if (false === O.hasSubscribers) return k.call(this, e2, t2, r2, n2);
        const i2 = { instance: this, arguments };
        return O.traceSync(k, i2, this, e2, t2, r2, n2);
      }, genLog: function(e2, t2) {
        return t2 ? function(...n2) {
          t2.call(this, n2, r2, e2);
        } : r2;
        function r2(t3, ...r3) {
          if ("object" == typeof t3) {
            let n2, a2 = t3;
            null !== t3 && (t3.method && t3.headers && t3.socket ? t3 = o(t3) : "function" == typeof t3.setHeader && (t3 = s(t3))), null === a2 && 0 === r3.length ? n2 = [null] : (a2 = r3.shift(), n2 = r3), "string" == typeof this[E] && null != a2 && (a2 = this[E] + a2), this[d](t3, i(a2, n2, this[h]), e2);
          } else {
            let n2 = void 0 === t3 ? r3.shift() : t3;
            "string" == typeof this[E] && null != n2 && (n2 = this[E] + n2), this[d](null, i(n2, r3, this[h]), e2);
          }
        }
      }, createArgsNormalizer: function(e2) {
        return function(t2, r2, n2 = {}, i2) {
          if ("string" == typeof n2) i2 = D({ dest: n2 }), n2 = {};
          else if ("string" == typeof i2) {
            if (n2 && n2.transport) throw Error("only one of option.transport or stream can be specified");
            i2 = D({ dest: i2 });
          } else if (n2 instanceof a || n2.writable || n2._writableState) i2 = n2, n2 = {};
          else if (n2.transport) {
            if (n2.transport instanceof a || n2.transport.writable || n2.transport._writableState) throw Error("option.transport do not allow stream, please pass to option directly. e.g. pino(transport)");
            if (n2.transport.targets && n2.transport.targets.length && n2.formatters && "function" == typeof n2.formatters.level) throw Error("option.transport.targets do not allow custom level formatters");
            let e3;
            n2.customLevels && (e3 = n2.useOnlyCustomLevels ? n2.customLevels : Object.assign({}, n2.levels, n2.customLevels)), i2 = T({ caller: r2, ...n2.transport, levels: e3 });
          }
          if ((n2 = Object.assign({}, e2, n2)).serializers = Object.assign({}, e2.serializers, n2.serializers), n2.formatters = Object.assign({}, e2.formatters, n2.formatters), n2.prettyPrint) throw new Error("prettyPrint option is no longer supported, see the pino-pretty package (https://github.com/pinojs/pino-pretty)");
          const { enabled: o2, onChild: s2 } = n2;
          return false === o2 && (n2.level = "silent"), s2 || (n2.onChild = I), i2 || (i2 = (function(e3) {
            return e3.write !== e3.constructor.prototype.write;
          })(process.stdout) ? process.stdout : D({ fd: process.stdout.fd || 1 })), { opts: n2, stream: i2 };
        };
      }, stringify: function(e2, t2) {
        try {
          return JSON.stringify(e2);
        } catch (r2) {
          try {
            return (t2 || this[y])(e2);
          } catch (e3) {
            return '"[unable to serialize, circular reference is too complex to analyze]"';
          }
        }
      }, buildFormatters: function(e2, t2, r2) {
        return { level: e2, bindings: t2, log: r2 };
      }, normalizeDestFileDescriptor: function(e2) {
        const t2 = Number(e2);
        return "string" == typeof e2 && Number.isFinite(t2) ? t2 : void 0 === e2 ? 1 : e2;
      } };
    }, 2613: (e) => {
      e.exports = assert;
    }, 2658: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.Http2SubchannelConnector = void 0;
      const n = r(5675), i = r(4756), o = r(1668), s = r(6754), a = r(5956), l = r(4398), c = r(4169), u = r(9939), d = r(5129), p = r(9278), h = r(2195), f = r(8605), g = "transport", m = r(7126).rE, { HTTP2_HEADER_AUTHORITY: y, HTTP2_HEADER_CONTENT_TYPE: v, HTTP2_HEADER_METHOD: b, HTTP2_HEADER_PATH: S, HTTP2_HEADER_TE: w, HTTP2_HEADER_USER_AGENT: C } = n.constants, _2 = Buffer.from("too_many_pings", "ascii");
      class E {
        constructor(e2, t2, r2, i2) {
          this.session = e2, this.options = r2, this.remoteName = i2, this.keepaliveTimer = null, this.pendingSendKeepalivePing = false, this.activeCalls = /* @__PURE__ */ new Set(), this.disconnectListeners = [], this.disconnectHandled = false, this.channelzEnabled = true, this.keepalivesSent = 0, this.messagesSent = 0, this.messagesReceived = 0, this.lastMessageSentTimestamp = null, this.lastMessageReceivedTimestamp = null, this.subchannelAddressString = (0, u.subchannelAddressToString)(t2), 0 === r2["grpc.enable_channelz"] ? (this.channelzEnabled = false, this.streamTracker = new o.ChannelzCallTrackerStub()) : this.streamTracker = new o.ChannelzCallTracker(), this.channelzRef = (0, o.registerChannelzSocket)(this.subchannelAddressString, () => this.getChannelzInfo(), this.channelzEnabled), this.userAgent = [r2["grpc.primary_user_agent"], `grpc-node-js/${m}`, r2["grpc.secondary_user_agent"]].filter((e3) => e3).join(" "), this.keepaliveTimeMs = "grpc.keepalive_time_ms" in r2 ? r2["grpc.keepalive_time_ms"] : -1, this.keepaliveTimeoutMs = "grpc.keepalive_timeout_ms" in r2 ? r2["grpc.keepalive_timeout_ms"] : 2e4, this.keepaliveWithoutCalls = "grpc.keepalive_permit_without_calls" in r2 && 1 === r2["grpc.keepalive_permit_without_calls"], e2.once("close", () => {
            this.trace("session closed"), this.handleDisconnect();
          }), e2.once("goaway", (e3, t3, r3) => {
            let i3 = false;
            e3 === n.constants.NGHTTP2_ENHANCE_YOUR_CALM && r3 && r3.equals(_2) && (i3 = true), this.trace("connection closed by GOAWAY with code " + e3 + " and data " + (null == r3 ? void 0 : r3.toString())), this.reportDisconnectToOwner(i3);
          }), e2.once("error", (e3) => {
            this.trace("connection closed with error " + e3.message), this.handleDisconnect();
          }), l.isTracerEnabled(g) && (e2.on("remoteSettings", (t3) => {
            this.trace("new settings received" + (this.session !== e2 ? " on the old connection" : "") + ": " + JSON.stringify(t3));
          }), e2.on("localSettings", (t3) => {
            this.trace("local settings acknowledged by remote" + (this.session !== e2 ? " on the old connection" : "") + ": " + JSON.stringify(t3));
          })), this.keepaliveWithoutCalls && this.maybeStartKeepalivePingTimer();
        }
        getChannelzInfo() {
          var e2, t2, r2;
          const n2 = this.session.socket, i2 = n2.remoteAddress ? (0, u.stringToSubchannelAddress)(n2.remoteAddress, n2.remotePort) : null, o2 = n2.localAddress ? (0, u.stringToSubchannelAddress)(n2.localAddress, n2.localPort) : null;
          let s2;
          if (this.session.encrypted) {
            const t3 = n2, r3 = t3.getCipher(), i3 = t3.getCertificate(), o3 = t3.getPeerCertificate();
            s2 = { cipherSuiteStandardName: null !== (e2 = r3.standardName) && void 0 !== e2 ? e2 : null, cipherSuiteOtherName: r3.standardName ? null : r3.name, localCertificate: i3 && "raw" in i3 ? i3.raw : null, remoteCertificate: o3 && "raw" in o3 ? o3.raw : null };
          } else s2 = null;
          return { remoteAddress: i2, localAddress: o2, security: s2, remoteName: this.remoteName, streamsStarted: this.streamTracker.callsStarted, streamsSucceeded: this.streamTracker.callsSucceeded, streamsFailed: this.streamTracker.callsFailed, messagesSent: this.messagesSent, messagesReceived: this.messagesReceived, keepAlivesSent: this.keepalivesSent, lastLocalStreamCreatedTimestamp: this.streamTracker.lastCallStartedTimestamp, lastRemoteStreamCreatedTimestamp: null, lastMessageSentTimestamp: this.lastMessageSentTimestamp, lastMessageReceivedTimestamp: this.lastMessageReceivedTimestamp, localFlowControlWindow: null !== (t2 = this.session.state.localWindowSize) && void 0 !== t2 ? t2 : null, remoteFlowControlWindow: null !== (r2 = this.session.state.remoteWindowSize) && void 0 !== r2 ? r2 : null };
        }
        trace(e2) {
          l.trace(s.LogVerbosity.DEBUG, g, "(" + this.channelzRef.id + ") " + this.subchannelAddressString + " " + e2);
        }
        keepaliveTrace(e2) {
          l.trace(s.LogVerbosity.DEBUG, "keepalive", "(" + this.channelzRef.id + ") " + this.subchannelAddressString + " " + e2);
        }
        flowControlTrace(e2) {
          l.trace(s.LogVerbosity.DEBUG, "transport_flowctrl", "(" + this.channelzRef.id + ") " + this.subchannelAddressString + " " + e2);
        }
        internalsTrace(e2) {
          l.trace(s.LogVerbosity.DEBUG, "transport_internals", "(" + this.channelzRef.id + ") " + this.subchannelAddressString + " " + e2);
        }
        reportDisconnectToOwner(e2) {
          this.disconnectHandled || (this.disconnectHandled = true, this.disconnectListeners.forEach((t2) => t2(e2)));
        }
        handleDisconnect() {
          this.disconnectHandled || (this.clearKeepaliveTimeout(), this.reportDisconnectToOwner(false), setImmediate(() => {
            for (const e2 of this.activeCalls) e2.onDisconnect();
            this.session.destroy();
          }));
        }
        addDisconnectListener(e2) {
          this.disconnectListeners.push(e2);
        }
        canSendPing() {
          return !this.session.destroyed && this.keepaliveTimeMs > 0 && (this.keepaliveWithoutCalls || this.activeCalls.size > 0);
        }
        maybeSendPing() {
          var e2, t2;
          if (!this.canSendPing()) return void (this.pendingSendKeepalivePing = true);
          if (this.keepaliveTimer) return void console.error("keepaliveTimeout is not null");
          this.channelzEnabled && (this.keepalivesSent += 1), this.keepaliveTrace("Sending ping with timeout " + this.keepaliveTimeoutMs + "ms"), this.keepaliveTimer = setTimeout(() => {
            this.keepaliveTimer = null, this.keepaliveTrace("Ping timeout passed without response"), this.handleDisconnect();
          }, this.keepaliveTimeoutMs), null === (t2 = (e2 = this.keepaliveTimer).unref) || void 0 === t2 || t2.call(e2);
          let r2 = "";
          try {
            this.session.ping((e3, t3, r3) => {
              this.clearKeepaliveTimeout(), e3 ? (this.keepaliveTrace("Ping failed with error " + e3.message), this.handleDisconnect()) : (this.keepaliveTrace("Received ping response"), this.maybeStartKeepalivePingTimer());
            }) || (r2 = "Ping returned false");
          } catch (e3) {
            r2 = (e3 instanceof Error ? e3.message : "") || "Unknown error";
          }
          r2 && (this.keepaliveTrace("Ping send failed: " + r2), this.handleDisconnect());
        }
        maybeStartKeepalivePingTimer() {
          var e2, t2;
          this.canSendPing() && (this.pendingSendKeepalivePing ? (this.pendingSendKeepalivePing = false, this.maybeSendPing()) : this.keepaliveTimer || (this.keepaliveTrace("Starting keepalive timer for " + this.keepaliveTimeMs + "ms"), this.keepaliveTimer = setTimeout(() => {
            this.keepaliveTimer = null, this.maybeSendPing();
          }, this.keepaliveTimeMs), null === (t2 = (e2 = this.keepaliveTimer).unref) || void 0 === t2 || t2.call(e2)));
        }
        clearKeepaliveTimeout() {
          this.keepaliveTimer && (clearTimeout(this.keepaliveTimer), this.keepaliveTimer = null);
        }
        removeActiveCall(e2) {
          this.activeCalls.delete(e2), 0 === this.activeCalls.size && this.session.unref();
        }
        addActiveCall(e2) {
          this.activeCalls.add(e2), 1 === this.activeCalls.size && (this.session.ref(), this.keepaliveWithoutCalls || this.maybeStartKeepalivePingTimer());
        }
        createCall(e2, t2, r2, n2, i2) {
          const o2 = e2.toHttp2Headers();
          let s2, a2, l2;
          o2[y] = t2, o2[C] = this.userAgent, o2[v] = "application/grpc", o2[b] = "POST", o2[S] = r2, o2[w] = "trailers";
          try {
            s2 = this.session.request(o2);
          } catch (e3) {
            throw this.handleDisconnect(), e3;
          }
          return this.flowControlTrace("local window size: " + this.session.state.localWindowSize + " remote window size: " + this.session.state.remoteWindowSize), this.internalsTrace("session.closed=" + this.session.closed + " session.destroyed=" + this.session.destroyed + " session.socket.destroyed=" + this.session.socket.destroyed), this.channelzEnabled ? (this.streamTracker.addCallStarted(), a2 = { addMessageSent: () => {
            var e3;
            this.messagesSent += 1, this.lastMessageSentTimestamp = /* @__PURE__ */ new Date(), null === (e3 = i2.addMessageSent) || void 0 === e3 || e3.call(i2);
          }, addMessageReceived: () => {
            var e3;
            this.messagesReceived += 1, this.lastMessageReceivedTimestamp = /* @__PURE__ */ new Date(), null === (e3 = i2.addMessageReceived) || void 0 === e3 || e3.call(i2);
          }, onCallEnd: (e3) => {
            var t3;
            null === (t3 = i2.onCallEnd) || void 0 === t3 || t3.call(i2, e3), this.removeActiveCall(l2);
          }, onStreamEnd: (e3) => {
            var t3;
            e3 ? this.streamTracker.addCallSucceeded() : this.streamTracker.addCallFailed(), null === (t3 = i2.onStreamEnd) || void 0 === t3 || t3.call(i2, e3);
          } }) : a2 = { addMessageSent: () => {
            var e3;
            null === (e3 = i2.addMessageSent) || void 0 === e3 || e3.call(i2);
          }, addMessageReceived: () => {
            var e3;
            null === (e3 = i2.addMessageReceived) || void 0 === e3 || e3.call(i2);
          }, onCallEnd: (e3) => {
            var t3;
            null === (t3 = i2.onCallEnd) || void 0 === t3 || t3.call(i2, e3), this.removeActiveCall(l2);
          }, onStreamEnd: (e3) => {
            var t3;
            null === (t3 = i2.onStreamEnd) || void 0 === t3 || t3.call(i2, e3);
          } }, l2 = new h.Http2SubchannelCall(s2, a2, n2, this, (0, f.getNextCallNumber)()), this.addActiveCall(l2), l2;
        }
        getChannelzRef() {
          return this.channelzRef;
        }
        getPeerName() {
          return this.subchannelAddressString;
        }
        getOptions() {
          return this.options;
        }
        shutdown() {
          this.session.close(), (0, o.unregisterChannelzRef)(this.channelzRef);
        }
      }
      t.Http2SubchannelConnector = class {
        constructor(e2) {
          this.channelTarget = e2, this.session = null, this.isShutdown = false;
        }
        trace(e2) {
          l.trace(s.LogVerbosity.DEBUG, g, (0, d.uriToString)(this.channelTarget) + " " + e2);
        }
        createSession(e2, t2, r2, o2) {
          return this.isShutdown ? Promise.reject() : new Promise((s2, a2) => {
            var l2, h2, f2, g2;
            let m2;
            o2.realTarget ? (m2 = (0, d.uriToString)(o2.realTarget), this.trace("creating HTTP/2 session through proxy to " + (0, d.uriToString)(o2.realTarget))) : (m2 = null, this.trace("creating HTTP/2 session to " + (0, u.subchannelAddressToString)(e2)));
            const y2 = (0, c.getDefaultAuthority)(null !== (l2 = o2.realTarget) && void 0 !== l2 ? l2 : this.channelTarget);
            let v2 = t2._getConnectionOptions();
            if (!v2) return void a2("Credentials not loaded");
            v2.maxSendHeaderBlockLength = Number.MAX_SAFE_INTEGER, v2.maxSessionMemory = "grpc-node.max_session_memory" in r2 ? r2["grpc-node.max_session_memory"] : Number.MAX_SAFE_INTEGER;
            let b2 = "http://";
            if ("secureContext" in v2) {
              if (b2 = "https://", r2["grpc.ssl_target_name_override"]) {
                const e3 = r2["grpc.ssl_target_name_override"], t3 = null !== (h2 = v2.checkServerIdentity) && void 0 !== h2 ? h2 : i.checkServerIdentity;
                v2.checkServerIdentity = (r3, n2) => t3(e3, n2), v2.servername = e3;
              } else {
                const e3 = null !== (g2 = null === (f2 = (0, d.splitHostPort)(y2)) || void 0 === f2 ? void 0 : f2.host) && void 0 !== g2 ? g2 : "localhost";
                v2.servername = e3;
              }
              o2.socket && (v2.createConnection = (e3, t3) => o2.socket);
            } else v2.createConnection = (t3, r3) => o2.socket ? o2.socket : p.connect(e2);
            v2 = Object.assign(Object.assign(Object.assign({}, v2), e2), { enableTrace: 1 === r2["grpc-node.tls_enable_trace"] });
            const S2 = n.connect(b2 + y2, v2);
            this.session = S2;
            let w2 = "Failed to connect", C2 = false;
            S2.unref(), S2.once("connect", () => {
              S2.removeAllListeners(), s2(new E(S2, e2, r2, m2)), this.session = null;
            }), S2.once("close", () => {
              this.session = null, setImmediate(() => {
                C2 || (C2 = true, a2(`${w2} (${(/* @__PURE__ */ new Date()).toISOString()})`));
              });
            }), S2.once("error", (e3) => {
              w2 = e3.message, this.trace("connection failed with error " + w2), C2 || (C2 = true, a2(`${w2} (${(/* @__PURE__ */ new Date()).toISOString()})`));
            });
          });
        }
        connect(e2, t2, r2) {
          var n2, o2, s2;
          if (this.isShutdown) return Promise.reject();
          const l2 = t2._getConnectionOptions();
          if (!l2) return Promise.reject("Credentials not loaded");
          if ("secureContext" in l2) {
            if (l2.ALPNProtocols = ["h2"], r2["grpc.ssl_target_name_override"]) {
              const e3 = r2["grpc.ssl_target_name_override"], t3 = null !== (n2 = l2.checkServerIdentity) && void 0 !== n2 ? n2 : i.checkServerIdentity;
              l2.checkServerIdentity = (r3, n3) => t3(e3, n3), l2.servername = e3;
            } else if ("grpc.http_connect_target" in r2) {
              const e3 = (0, c.getDefaultAuthority)(null !== (o2 = (0, d.parseUri)(r2["grpc.http_connect_target"])) && void 0 !== o2 ? o2 : { path: "localhost" }), t3 = (0, d.splitHostPort)(e3);
              l2.servername = null !== (s2 = null == t3 ? void 0 : t3.host) && void 0 !== s2 ? s2 : e3;
            }
            r2["grpc-node.tls_enable_trace"] && (l2.enableTrace = true);
          }
          return (0, a.getProxiedConnection)(e2, r2, l2).then((n3) => this.createSession(e2, t2, r2, n3));
        }
        shutdown() {
          var e2;
          this.isShutdown = true, null === (e2 = this.session) || void 0 === e2 || e2.close(), this.session = null;
        }
      };
    }, 2777: (e, t, r) => {
      e.exports = o;
      var n = r(3963);
      (o.prototype = Object.create(n.prototype)).constructor = o;
      var i = r(5099);
      function o(e2) {
        n.call(this, e2);
      }
      o._configure = function() {
        i.Buffer && (o.prototype._slice = i.Buffer.prototype.slice);
      }, o.prototype.string = function() {
        var e2 = this.uint32();
        return this.buf.utf8Slice ? this.buf.utf8Slice(this.pos, this.pos = Math.min(this.pos + e2, this.len)) : this.buf.toString("utf-8", this.pos, this.pos = Math.min(this.pos + e2, this.len));
      }, o._configure();
    }, 2828: (e, t) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.BaseSubchannelWrapper = void 0, t.BaseSubchannelWrapper = class {
        constructor(e2) {
          this.child = e2, this.healthy = true, this.healthListeners = /* @__PURE__ */ new Set(), e2.addHealthStateWatcher((e3) => {
            this.healthy && this.updateHealthListeners();
          });
        }
        updateHealthListeners() {
          for (const e2 of this.healthListeners) e2(this.isHealthy());
        }
        getConnectivityState() {
          return this.child.getConnectivityState();
        }
        addConnectivityStateListener(e2) {
          this.child.addConnectivityStateListener(e2);
        }
        removeConnectivityStateListener(e2) {
          this.child.removeConnectivityStateListener(e2);
        }
        startConnecting() {
          this.child.startConnecting();
        }
        getAddress() {
          return this.child.getAddress();
        }
        throttleKeepalive(e2) {
          this.child.throttleKeepalive(e2);
        }
        ref() {
          this.child.ref();
        }
        unref() {
          this.child.unref();
        }
        getChannelzRef() {
          return this.child.getChannelzRef();
        }
        isHealthy() {
          return this.healthy && this.child.isHealthy();
        }
        addHealthStateWatcher(e2) {
          this.healthListeners.add(e2);
        }
        removeHealthStateWatcher(e2) {
          this.healthListeners.delete(e2);
        }
        setHealthy(e2) {
          e2 !== this.healthy && (this.healthy = e2, this.child.isHealthy() && this.updateHealthListeners());
        }
        getRealSubchannel() {
          return this.child.getRealSubchannel();
        }
        realSubchannelEquals(e2) {
          return this.getRealSubchannel() === e2.getRealSubchannel();
        }
      };
    }, 2900: (e) => {
      e.exports = { version: "10.0.0" };
    }, 2911: (e, t, r) => {
      const n = r(9743), i = r(5630);
      e.exports = { silent: i, dots: n };
    }, 3037: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.createCertificateProviderChannelCredentials = t.FileWatcherCertificateProvider = t.createCertificateProviderServerCredentials = t.createServerCredentialsWithInterceptors = t.BaseSubchannelWrapper = t.registerAdminService = t.FilterStackFactory = t.BaseFilter = t.PickResultType = t.QueuePicker = t.UnavailablePicker = t.ChildLoadBalancerHandler = t.EndpointMap = t.endpointHasAddress = t.endpointToString = t.subchannelAddressToString = t.LeafLoadBalancer = t.isLoadBalancerNameRegistered = t.parseLoadBalancingConfig = t.selectLbConfigFromList = t.registerLoadBalancerType = t.createChildChannelControlHelper = t.BackoffTimeout = t.parseDuration = t.durationToMs = t.splitHostPort = t.uriToString = t.createResolver = t.registerResolver = t.log = t.trace = void 0;
      var n = r(4398);
      Object.defineProperty(t, "trace", { enumerable: true, get: function() {
        return n.trace;
      } }), Object.defineProperty(t, "log", { enumerable: true, get: function() {
        return n.log;
      } });
      var i = r(4169);
      Object.defineProperty(t, "registerResolver", { enumerable: true, get: function() {
        return i.registerResolver;
      } }), Object.defineProperty(t, "createResolver", { enumerable: true, get: function() {
        return i.createResolver;
      } });
      var o = r(5129);
      Object.defineProperty(t, "uriToString", { enumerable: true, get: function() {
        return o.uriToString;
      } }), Object.defineProperty(t, "splitHostPort", { enumerable: true, get: function() {
        return o.splitHostPort;
      } });
      var s = r(1051);
      Object.defineProperty(t, "durationToMs", { enumerable: true, get: function() {
        return s.durationToMs;
      } }), Object.defineProperty(t, "parseDuration", { enumerable: true, get: function() {
        return s.parseDuration;
      } });
      var a = r(7313);
      Object.defineProperty(t, "BackoffTimeout", { enumerable: true, get: function() {
        return a.BackoffTimeout;
      } });
      var l = r(9982);
      Object.defineProperty(t, "createChildChannelControlHelper", { enumerable: true, get: function() {
        return l.createChildChannelControlHelper;
      } }), Object.defineProperty(t, "registerLoadBalancerType", { enumerable: true, get: function() {
        return l.registerLoadBalancerType;
      } }), Object.defineProperty(t, "selectLbConfigFromList", { enumerable: true, get: function() {
        return l.selectLbConfigFromList;
      } }), Object.defineProperty(t, "parseLoadBalancingConfig", { enumerable: true, get: function() {
        return l.parseLoadBalancingConfig;
      } }), Object.defineProperty(t, "isLoadBalancerNameRegistered", { enumerable: true, get: function() {
        return l.isLoadBalancerNameRegistered;
      } });
      var c = r(6509);
      Object.defineProperty(t, "LeafLoadBalancer", { enumerable: true, get: function() {
        return c.LeafLoadBalancer;
      } });
      var u = r(9939);
      Object.defineProperty(t, "subchannelAddressToString", { enumerable: true, get: function() {
        return u.subchannelAddressToString;
      } }), Object.defineProperty(t, "endpointToString", { enumerable: true, get: function() {
        return u.endpointToString;
      } }), Object.defineProperty(t, "endpointHasAddress", { enumerable: true, get: function() {
        return u.endpointHasAddress;
      } }), Object.defineProperty(t, "EndpointMap", { enumerable: true, get: function() {
        return u.EndpointMap;
      } });
      var d = r(6100);
      Object.defineProperty(t, "ChildLoadBalancerHandler", { enumerable: true, get: function() {
        return d.ChildLoadBalancerHandler;
      } });
      var p = r(4129);
      Object.defineProperty(t, "UnavailablePicker", { enumerable: true, get: function() {
        return p.UnavailablePicker;
      } }), Object.defineProperty(t, "QueuePicker", { enumerable: true, get: function() {
        return p.QueuePicker;
      } }), Object.defineProperty(t, "PickResultType", { enumerable: true, get: function() {
        return p.PickResultType;
      } });
      var h = r(7665);
      Object.defineProperty(t, "BaseFilter", { enumerable: true, get: function() {
        return h.BaseFilter;
      } });
      var f = r(9424);
      Object.defineProperty(t, "FilterStackFactory", { enumerable: true, get: function() {
        return f.FilterStackFactory;
      } });
      var g = r(7200);
      Object.defineProperty(t, "registerAdminService", { enumerable: true, get: function() {
        return g.registerAdminService;
      } });
      var m = r(2828);
      Object.defineProperty(t, "BaseSubchannelWrapper", { enumerable: true, get: function() {
        return m.BaseSubchannelWrapper;
      } });
      var y = r(3191);
      Object.defineProperty(t, "createServerCredentialsWithInterceptors", { enumerable: true, get: function() {
        return y.createServerCredentialsWithInterceptors;
      } }), Object.defineProperty(t, "createCertificateProviderServerCredentials", { enumerable: true, get: function() {
        return y.createCertificateProviderServerCredentials;
      } });
      var v = r(4652);
      Object.defineProperty(t, "FileWatcherCertificateProvider", { enumerable: true, get: function() {
        return v.FileWatcherCertificateProvider;
      } });
      var b = r(7015);
      Object.defineProperty(t, "createCertificateProviderChannelCredentials", { enumerable: true, get: function() {
        return b.createCertificateProviderChannelCredentials;
      } });
    }, 3053: (e) => {
      e.exports = require$$8;
    }, 3106: (e) => {
      e.exports = require$$3$1;
    }, 3108: (e, t, r) => {
      e.exports = d;
      var n, i = r(5099), o = i.LongBits, s = i.base64, a = i.utf8;
      function l(e2, t2, r2) {
        this.fn = e2, this.len = t2, this.next = void 0, this.val = r2;
      }
      function c() {
      }
      function u(e2) {
        this.head = e2.head, this.tail = e2.tail, this.len = e2.len, this.next = e2.states;
      }
      function d() {
        this.len = 0, this.head = new l(c, 0, 0), this.tail = this.head, this.states = null;
      }
      var p = function() {
        return i.Buffer ? function() {
          return (d.create = function() {
            return new n();
          })();
        } : function() {
          return new d();
        };
      };
      function h(e2, t2, r2) {
        t2[r2] = 255 & e2;
      }
      function f(e2, t2) {
        this.len = e2, this.next = void 0, this.val = t2;
      }
      function g(e2, t2, r2) {
        for (; e2.hi; ) t2[r2++] = 127 & e2.lo | 128, e2.lo = (e2.lo >>> 7 | e2.hi << 25) >>> 0, e2.hi >>>= 7;
        for (; e2.lo > 127; ) t2[r2++] = 127 & e2.lo | 128, e2.lo = e2.lo >>> 7;
        t2[r2++] = e2.lo;
      }
      function m(e2, t2, r2) {
        t2[r2] = 255 & e2, t2[r2 + 1] = e2 >>> 8 & 255, t2[r2 + 2] = e2 >>> 16 & 255, t2[r2 + 3] = e2 >>> 24;
      }
      d.create = p(), d.alloc = function(e2) {
        return new i.Array(e2);
      }, i.Array !== Array && (d.alloc = i.pool(d.alloc, i.Array.prototype.subarray)), d.prototype._push = function(e2, t2, r2) {
        return this.tail = this.tail.next = new l(e2, t2, r2), this.len += t2, this;
      }, f.prototype = Object.create(l.prototype), f.prototype.fn = function(e2, t2, r2) {
        for (; e2 > 127; ) t2[r2++] = 127 & e2 | 128, e2 >>>= 7;
        t2[r2] = e2;
      }, d.prototype.uint32 = function(e2) {
        return this.len += (this.tail = this.tail.next = new f((e2 >>>= 0) < 128 ? 1 : e2 < 16384 ? 2 : e2 < 2097152 ? 3 : e2 < 268435456 ? 4 : 5, e2)).len, this;
      }, d.prototype.int32 = function(e2) {
        return e2 < 0 ? this._push(g, 10, o.fromNumber(e2)) : this.uint32(e2);
      }, d.prototype.sint32 = function(e2) {
        return this.uint32((e2 << 1 ^ e2 >> 31) >>> 0);
      }, d.prototype.uint64 = function(e2) {
        var t2 = o.from(e2);
        return this._push(g, t2.length(), t2);
      }, d.prototype.int64 = d.prototype.uint64, d.prototype.sint64 = function(e2) {
        var t2 = o.from(e2).zzEncode();
        return this._push(g, t2.length(), t2);
      }, d.prototype.bool = function(e2) {
        return this._push(h, 1, e2 ? 1 : 0);
      }, d.prototype.fixed32 = function(e2) {
        return this._push(m, 4, e2 >>> 0);
      }, d.prototype.sfixed32 = d.prototype.fixed32, d.prototype.fixed64 = function(e2) {
        var t2 = o.from(e2);
        return this._push(m, 4, t2.lo)._push(m, 4, t2.hi);
      }, d.prototype.sfixed64 = d.prototype.fixed64, d.prototype.float = function(e2) {
        return this._push(i.float.writeFloatLE, 4, e2);
      }, d.prototype.double = function(e2) {
        return this._push(i.float.writeDoubleLE, 8, e2);
      };
      var y = i.Array.prototype.set ? function(e2, t2, r2) {
        t2.set(e2, r2);
      } : function(e2, t2, r2) {
        for (var n2 = 0; n2 < e2.length; ++n2) t2[r2 + n2] = e2[n2];
      };
      d.prototype.bytes = function(e2) {
        var t2 = e2.length >>> 0;
        if (!t2) return this._push(h, 1, 0);
        if (i.isString(e2)) {
          var r2 = d.alloc(t2 = s.length(e2));
          s.decode(e2, r2, 0), e2 = r2;
        }
        return this.uint32(t2)._push(y, t2, e2);
      }, d.prototype.string = function(e2) {
        var t2 = a.length(e2);
        return t2 ? this.uint32(t2)._push(a.write, t2, e2) : this._push(h, 1, 0);
      }, d.prototype.fork = function() {
        return this.states = new u(this), this.head = this.tail = new l(c, 0, 0), this.len = 0, this;
      }, d.prototype.reset = function() {
        return this.states ? (this.head = this.states.head, this.tail = this.states.tail, this.len = this.states.len, this.states = this.states.next) : (this.head = this.tail = new l(c, 0, 0), this.len = 0), this;
      }, d.prototype.ldelim = function() {
        var e2 = this.head, t2 = this.tail, r2 = this.len;
        return this.reset().uint32(r2), r2 && (this.tail.next = e2.next, this.tail = t2, this.len += r2), this;
      }, d.prototype.finish = function() {
        for (var e2 = this.head.next, t2 = this.constructor.alloc(this.len), r2 = 0; e2; ) e2.fn(e2.val, t2, r2), r2 += e2.len, e2 = e2.next;
        return t2;
      }, d._configure = function(e2) {
        n = e2, d.create = p(), n._configure();
      };
    }, 3120: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.CompressionFilterFactory = t.CompressionFilter = void 0;
      const n = r(3106), i = r(3388), o = r(6754), s = r(7665), a = r(4398);
      class l {
        async writeMessage(e2, t2) {
          let r2 = e2;
          t2 && (r2 = await this.compressMessage(r2));
          const n2 = Buffer.allocUnsafe(r2.length + 5);
          return n2.writeUInt8(t2 ? 1 : 0, 0), n2.writeUInt32BE(r2.length, 1), r2.copy(n2, 5), n2;
        }
        async readMessage(e2) {
          const t2 = 1 === e2.readUInt8(0);
          let r2 = e2.slice(5);
          return t2 && (r2 = await this.decompressMessage(r2)), r2;
        }
      }
      class c extends l {
        async compressMessage(e2) {
          return e2;
        }
        async writeMessage(e2, t2) {
          const r2 = Buffer.allocUnsafe(e2.length + 5);
          return r2.writeUInt8(0, 0), r2.writeUInt32BE(e2.length, 1), e2.copy(r2, 5), r2;
        }
        decompressMessage(e2) {
          return Promise.reject(new Error('Received compressed message but "grpc-encoding" header was identity'));
        }
      }
      class u extends l {
        constructor(e2) {
          super(), this.maxRecvMessageLength = e2;
        }
        compressMessage(e2) {
          return new Promise((t2, r2) => {
            n.deflate(e2, (e3, n2) => {
              e3 ? r2(e3) : t2(n2);
            });
          });
        }
        decompressMessage(e2) {
          return new Promise((t2, r2) => {
            let i2 = 0;
            const s2 = [], a2 = n.createInflate();
            a2.on("data", (e3) => {
              s2.push(e3), i2 += e3.byteLength, -1 !== this.maxRecvMessageLength && i2 > this.maxRecvMessageLength && (a2.destroy(), r2({ code: o.Status.RESOURCE_EXHAUSTED, details: `Received message that decompresses to a size larger than ${this.maxRecvMessageLength}` }));
            }), a2.on("end", () => {
              t2(Buffer.concat(s2));
            }), a2.write(e2), a2.end();
          });
        }
      }
      class d extends l {
        constructor(e2) {
          super(), this.maxRecvMessageLength = e2;
        }
        compressMessage(e2) {
          return new Promise((t2, r2) => {
            n.gzip(e2, (e3, n2) => {
              e3 ? r2(e3) : t2(n2);
            });
          });
        }
        decompressMessage(e2) {
          return new Promise((t2, r2) => {
            let i2 = 0;
            const s2 = [], a2 = n.createGunzip();
            a2.on("data", (e3) => {
              s2.push(e3), i2 += e3.byteLength, -1 !== this.maxRecvMessageLength && i2 > this.maxRecvMessageLength && (a2.destroy(), r2({ code: o.Status.RESOURCE_EXHAUSTED, details: `Received message that decompresses to a size larger than ${this.maxRecvMessageLength}` }));
            }), a2.on("end", () => {
              t2(Buffer.concat(s2));
            }), a2.write(e2), a2.end();
          });
        }
      }
      class p extends l {
        constructor(e2) {
          super(), this.compressionName = e2;
        }
        compressMessage(e2) {
          return Promise.reject(new Error(`Received message compressed with unsupported compression method ${this.compressionName}`));
        }
        decompressMessage(e2) {
          return Promise.reject(new Error(`Compression method not supported: ${this.compressionName}`));
        }
      }
      function h(e2, t2) {
        switch (e2) {
          case "identity":
            return new c();
          case "deflate":
            return new u(t2);
          case "gzip":
            return new d(t2);
          default:
            return new p(e2);
        }
      }
      class f extends s.BaseFilter {
        constructor(e2, t2) {
          var r2, n2, s2;
          super(), this.sharedFilterConfig = t2, this.sendCompression = new c(), this.receiveCompression = new c(), this.currentCompressionAlgorithm = "identity";
          const l2 = e2["grpc.default_compression_algorithm"];
          if (this.maxReceiveMessageLength = null !== (r2 = e2["grpc.max_receive_message_length"]) && void 0 !== r2 ? r2 : o.DEFAULT_MAX_RECEIVE_MESSAGE_LENGTH, this.maxSendMessageLength = null !== (n2 = e2["grpc.max_send_message_length"]) && void 0 !== n2 ? n2 : o.DEFAULT_MAX_SEND_MESSAGE_LENGTH, void 0 !== l2) if ("number" == typeof (u2 = l2) && "string" == typeof i.CompressionAlgorithms[u2]) {
            const e3 = i.CompressionAlgorithms[l2], r3 = null === (s2 = t2.serverSupportedEncodingHeader) || void 0 === s2 ? void 0 : s2.split(",");
            r3 && !r3.includes(e3) || (this.currentCompressionAlgorithm = e3, this.sendCompression = h(this.currentCompressionAlgorithm, -1));
          } else a.log(o.LogVerbosity.ERROR, `Invalid value provided for grpc.default_compression_algorithm option: ${l2}`);
          var u2;
        }
        async sendMetadata(e2) {
          const t2 = await e2;
          return t2.set("grpc-accept-encoding", "identity,deflate,gzip"), t2.set("accept-encoding", "identity"), "identity" === this.currentCompressionAlgorithm ? t2.remove("grpc-encoding") : t2.set("grpc-encoding", this.currentCompressionAlgorithm), t2;
        }
        receiveMetadata(e2) {
          const t2 = e2.get("grpc-encoding");
          if (t2.length > 0) {
            const e3 = t2[0];
            "string" == typeof e3 && (this.receiveCompression = h(e3, this.maxReceiveMessageLength));
          }
          e2.remove("grpc-encoding");
          const r2 = e2.get("grpc-accept-encoding")[0];
          return r2 && (this.sharedFilterConfig.serverSupportedEncodingHeader = r2, r2.split(",").includes(this.currentCompressionAlgorithm) || (this.sendCompression = new c(), this.currentCompressionAlgorithm = "identity")), e2.remove("grpc-accept-encoding"), e2;
        }
        async sendMessage(e2) {
          var t2;
          const r2 = await e2;
          if (-1 !== this.maxSendMessageLength && r2.message.length > this.maxSendMessageLength) throw { code: o.Status.RESOURCE_EXHAUSTED, details: `Attempted to send message with a size larger than ${this.maxSendMessageLength}` };
          let n2;
          return n2 = !(this.sendCompression instanceof c || 2 & (null !== (t2 = r2.flags) && void 0 !== t2 ? t2 : 0)), { message: await this.sendCompression.writeMessage(r2.message, n2), flags: r2.flags };
        }
        async receiveMessage(e2) {
          return this.receiveCompression.readMessage(await e2);
        }
      }
      t.CompressionFilter = f, t.CompressionFilterFactory = class {
        constructor(e2, t2) {
          this.options = t2, this.sharedFilterConfig = {};
        }
        createFilter() {
          return new f(this.options, this.sharedFilterConfig);
        }
      };
    }, 3190: (e, t) => {
      var r;
      Object.defineProperty(t, "__esModule", { value: true }), t.GRPC_NODE_USE_ALTERNATIVE_RESOLVER = void 0, t.GRPC_NODE_USE_ALTERNATIVE_RESOLVER = "true" === (null !== (r = define_process_env_default.GRPC_NODE_USE_ALTERNATIVE_RESOLVER) && void 0 !== r ? r : "false");
    }, 3191: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.createServerCredentialsWithInterceptors = t.createCertificateProviderServerCredentials = t.ServerCredentials = void 0;
      const n = r(50);
      class i {
        constructor() {
          this.watchers = /* @__PURE__ */ new Set(), this.latestContextOptions = null;
        }
        _addWatcher(e2) {
          this.watchers.add(e2);
        }
        _removeWatcher(e2) {
          this.watchers.delete(e2);
        }
        getWatcherCount() {
          return this.watchers.size;
        }
        updateSecureContextOptions(e2) {
          this.latestContextOptions = e2;
          for (const e3 of this.watchers) e3(this.latestContextOptions);
        }
        _getSettings() {
          return this.latestContextOptions;
        }
        _getInterceptors() {
          return [];
        }
        static createInsecure() {
          return new o();
        }
        static createSsl(e2, t2, r2 = false) {
          var i2;
          if (null !== e2 && !Buffer.isBuffer(e2)) throw new TypeError("rootCerts must be null or a Buffer");
          if (!Array.isArray(t2)) throw new TypeError("keyCertPairs must be an array");
          if ("boolean" != typeof r2) throw new TypeError("checkClientCertificate must be a boolean");
          const o2 = [], a2 = [];
          for (let e3 = 0; e3 < t2.length; e3++) {
            const r3 = t2[e3];
            if (null === r3 || "object" != typeof r3) throw new TypeError(`keyCertPair[${e3}] must be an object`);
            if (!Buffer.isBuffer(r3.private_key)) throw new TypeError(`keyCertPair[${e3}].private_key must be a Buffer`);
            if (!Buffer.isBuffer(r3.cert_chain)) throw new TypeError(`keyCertPair[${e3}].cert_chain must be a Buffer`);
            o2.push(r3.cert_chain), a2.push(r3.private_key);
          }
          return new s({ ca: null !== (i2 = null != e2 ? e2 : (0, n.getDefaultRootsData)()) && void 0 !== i2 ? i2 : void 0, cert: o2, key: a2, requestCert: r2, ciphers: n.CIPHER_SUITES });
        }
      }
      t.ServerCredentials = i;
      class o extends i {
        _isSecure() {
          return false;
        }
        _getSettings() {
          return null;
        }
        _equals(e2) {
          return e2 instanceof o;
        }
      }
      class s extends i {
        constructor(e2) {
          super(), this.options = e2;
        }
        _isSecure() {
          return true;
        }
        _getSettings() {
          return this.options;
        }
        _equals(e2) {
          if (this === e2) return true;
          if (!(e2 instanceof s)) return false;
          if (Buffer.isBuffer(this.options.ca) && Buffer.isBuffer(e2.options.ca)) {
            if (!this.options.ca.equals(e2.options.ca)) return false;
          } else if (this.options.ca !== e2.options.ca) return false;
          if (Array.isArray(this.options.cert) && Array.isArray(e2.options.cert)) {
            if (this.options.cert.length !== e2.options.cert.length) return false;
            for (let t2 = 0; t2 < this.options.cert.length; t2++) {
              const r2 = this.options.cert[t2], n2 = e2.options.cert[t2];
              if (Buffer.isBuffer(r2) && Buffer.isBuffer(n2)) {
                if (!r2.equals(n2)) return false;
              } else if (r2 !== n2) return false;
            }
          } else if (this.options.cert !== e2.options.cert) return false;
          if (Array.isArray(this.options.key) && Array.isArray(e2.options.key)) {
            if (this.options.key.length !== e2.options.key.length) return false;
            for (let t2 = 0; t2 < this.options.key.length; t2++) {
              const r2 = this.options.key[t2], n2 = e2.options.key[t2];
              if (Buffer.isBuffer(r2) && Buffer.isBuffer(n2)) {
                if (!r2.equals(n2)) return false;
              } else if (r2 !== n2) return false;
            }
          } else if (this.options.key !== e2.options.key) return false;
          return this.options.requestCert === e2.options.requestCert;
        }
      }
      class a extends i {
        constructor(e2, t2, r2) {
          super(), this.identityCertificateProvider = e2, this.caCertificateProvider = t2, this.requireClientCertificate = r2, this.latestCaUpdate = null, this.latestIdentityUpdate = null, this.caCertificateUpdateListener = this.handleCaCertificateUpdate.bind(this), this.identityCertificateUpdateListener = this.handleIdentityCertitificateUpdate.bind(this);
        }
        _addWatcher(e2) {
          var t2;
          0 === this.getWatcherCount() && (null === (t2 = this.caCertificateProvider) || void 0 === t2 || t2.addCaCertificateListener(this.caCertificateUpdateListener), this.identityCertificateProvider.addIdentityCertificateListener(this.identityCertificateUpdateListener)), super._addWatcher(e2);
        }
        _removeWatcher(e2) {
          var t2;
          super._removeWatcher(e2), 0 === this.getWatcherCount() && (null === (t2 = this.caCertificateProvider) || void 0 === t2 || t2.removeCaCertificateListener(this.caCertificateUpdateListener), this.identityCertificateProvider.removeIdentityCertificateListener(this.identityCertificateUpdateListener));
        }
        _isSecure() {
          return true;
        }
        _equals(e2) {
          return this === e2 || e2 instanceof a && this.caCertificateProvider === e2.caCertificateProvider && this.identityCertificateProvider === e2.identityCertificateProvider && this.requireClientCertificate === e2.requireClientCertificate;
        }
        calculateSecureContextOptions() {
          var e2;
          return null === this.latestIdentityUpdate || null !== this.caCertificateProvider && null === this.latestCaUpdate ? null : { ca: null === (e2 = this.latestCaUpdate) || void 0 === e2 ? void 0 : e2.caCertificate, cert: this.latestIdentityUpdate.certificate, key: this.latestIdentityUpdate.privateKey, requestCert: null !== this.latestIdentityUpdate, rejectUnauthorized: this.requireClientCertificate };
        }
        finalizeUpdate() {
          this.updateSecureContextOptions(this.calculateSecureContextOptions());
        }
        handleCaCertificateUpdate(e2) {
          this.latestCaUpdate = e2, this.finalizeUpdate();
        }
        handleIdentityCertitificateUpdate(e2) {
          this.latestIdentityUpdate = e2, this.finalizeUpdate();
        }
      }
      t.createCertificateProviderServerCredentials = function(e2, t2, r2) {
        return new a(e2, t2, r2);
      };
      class l extends i {
        constructor(e2, t2) {
          super(), this.childCredentials = e2, this.interceptors = t2;
        }
        _isSecure() {
          return this.childCredentials._isSecure();
        }
        _equals(e2) {
          if (!(e2 instanceof l)) return false;
          if (!this.childCredentials._equals(e2.childCredentials)) return false;
          if (this.interceptors.length !== e2.interceptors.length) return false;
          for (let t2 = 0; t2 < this.interceptors.length; t2++) if (this.interceptors[t2] !== e2.interceptors[t2]) return false;
          return true;
        }
        _getInterceptors() {
          return this.interceptors;
        }
        _addWatcher(e2) {
          this.childCredentials._addWatcher(e2);
        }
        _removeWatcher(e2) {
          this.childCredentials._removeWatcher(e2);
        }
      }
      t.createServerCredentialsWithInterceptors = function(e2, t2) {
        return new l(e2, t2);
      };
    }, 3197: function(e, t, r) {
      var n = this && this.__awaiter || function(e2, t2, r2, n2) {
        return new (r2 || (r2 = Promise))(function(i2, o2) {
          function s2(e3) {
            try {
              l(n2.next(e3));
            } catch (e4) {
              o2(e4);
            }
          }
          function a(e3) {
            try {
              l(n2.throw(e3));
            } catch (e4) {
              o2(e4);
            }
          }
          function l(e3) {
            var t3;
            e3.done ? i2(e3.value) : (t3 = e3.value, t3 instanceof r2 ? t3 : new r2(function(e4) {
              e4(t3);
            })).then(s2, a);
          }
          l((n2 = n2.apply(e2, t2 || [])).next());
        });
      };
      Object.defineProperty(t, "__esModule", { value: true }), t.createViewport = function(e2, t2, r2, a) {
        return n(this, arguments, void 0, function* (e3, t3, r3, n2, a2 = false) {
          const l = (0, o.getLogger)();
          let c = new i.CreateViewportRequest().setSessionId(t3).setOffset(r3).setCapacity(n2).setIsFloating(a2);
          void 0 !== e3 && e3.length > 0 && c.setViewportIdDesired(e3), l.debug({ fn: "createViewport", rqst: c.toObject() });
          const u = yield (0, s.getClient)();
          return new Promise((e4, t4) => {
            u.createViewport(c, (r4, n3) => r4 ? (l.error({ fn: "createViewport", rqst: c.toObject(), err: { msg: r4.message, details: r4.details, code: r4.code, stack: r4.stack } }), t4(`createViewport error: ${r4.message}`)) : (l.debug({ fn: "createViewport", resp: n3.toObject() }), e4(n3)));
          });
        });
      }, t.modifyViewport = function(e2, t2, r2) {
        return n(this, arguments, void 0, function* (e3, t3, r3, n2 = false) {
          const a = (0, o.getLogger)(), l = new i.ModifyViewportRequest().setViewportId(e3).setOffset(t3).setCapacity(r3).setIsFloating(n2);
          a.debug({ fn: "modifyViewport", rqst: l.toObject() });
          const c = yield (0, s.getClient)();
          return new Promise((e4, t4) => {
            c.modifyViewport(l, (r4, n3) => r4 ? (a.error({ fn: "modifyViewport", rqst: l.toObject(), err: { msg: r4.message, details: r4.details, code: r4.code, stack: r4.stack } }), t4(`modifyViewport error: ${r4.message}`)) : (a.debug({ fn: "modifyViewport", resp: n3.toObject() }), e4(n3)));
          });
        });
      }, t.destroyViewport = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, o.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "destroyViewport", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.destroyViewport(r2, (n3, o2) => n3 ? (t2.error({ fn: "destroyViewport", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(`destroyViewport error: ${n3.message}`)) : (t2.debug({ fn: "destroyViewport", resp: o2.toObject() }), e3(o2.getId())));
          });
        });
      }, t.getViewportCount = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, o.getLogger)(), r2 = new i.CountRequest().setSessionId(e2).setKindList([i.CountKind.COUNT_VIEWPORTS]);
          t2.debug({ fn: "getViewportCount", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.getCount(r2, (n3, o2) => n3 ? (t2.error({ fn: "getViewportCount", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(`getViewportCount error: ${n3.message}`)) : (t2.debug({ fn: "getViewportCount", resp: o2.toObject() }), e3(o2.getCountsList()[0].getCount())));
          });
        });
      }, t.getViewportData = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, o.getLogger)(), r2 = new i.ViewportDataRequest().setViewportId(e2);
          t2.debug({ fn: "getViewportData", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.getViewportData(r2, (n3, o2) => n3 ? (t2.error({ fn: "getViewportData", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(`getViewportData error: ${n3.message}`)) : (t2.debug({ fn: "getViewportData", resp: o2.toObject() }), e3(o2)));
          });
        });
      }, t.viewportHasChanges = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, o.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "viewportHasChanges", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.viewportHasChanges(r2, (n3, o2) => n3 ? (t2.error({ fn: "viewportHasChanges", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(`viewportHasChanges error: ${n3.message}`)) : (t2.debug({ fn: "viewportHasChanges", resp: o2.toObject() }), e3(o2.getResponse())));
          });
        });
      }, t.pauseViewportEvents = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, o.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "pauseViewportEvents", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.pauseViewportEvents(r2, (n3, o2) => n3 ? (t2.error({ fn: "pauseViewportEvents", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(`pauseViewportEvents error: ${n3.message}`)) : (t2.debug({ fn: "pauseViewportEvents", resp: o2.toObject() }), e3(o2.getId())));
          });
        });
      }, t.resumeViewportEvents = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, o.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "resumeViewportEvents", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.resumeViewportEvents(r2, (n3, o2) => n3 ? (t2.error({ fn: "resumeViewportEvents", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(`resumeViewportEvents error: ${n3.message}`)) : (t2.debug({ fn: "resumeViewportEvents", resp: o2.toObject() }), e3(o2.getId())));
          });
        });
      }, t.unsubscribeViewport = function(e2) {
        return n(this, void 0, void 0, function* () {
          const t2 = (0, o.getLogger)(), r2 = new i.ObjectId().setId(e2);
          t2.debug({ fn: "unsubscribeViewport", rqst: r2.toObject() });
          const n2 = yield (0, s.getClient)();
          return new Promise((e3, i2) => {
            n2.unsubscribeToViewportEvents(r2, (n3, o2) => n3 ? (t2.error({ fn: "unsubscribeViewport", rqst: r2.toObject(), err: { msg: n3.message, details: n3.details, code: n3.code, stack: n3.stack } }), i2(`unsubscribeViewport error: ${n3.message}`)) : (t2.debug({ fn: "unsubscribeViewport", resp: o2.toObject() }), e3(o2.getId()))).on("error", (e4) => {
              if (!e4.message.includes("Call cancelled")) throw t2.error("unsubscribeViewport critical error: " + e4.message), e4;
              t2.info("unsubscribeViewport error: " + e4.message);
            });
          });
        });
      };
      const i = r(8039), o = r(8943), s = r(7248);
    }, 3320: (e, t) => {
      var r = t;
      r.length = function(e2) {
        var t2 = e2.length;
        if (!t2) return 0;
        for (var r2 = 0; --t2 % 4 > 1 && "=" === e2.charAt(t2); ) ++r2;
        return Math.ceil(3 * e2.length) / 4 - r2;
      };
      for (var n = new Array(64), i = new Array(123), o = 0; o < 64; ) i[n[o] = o < 26 ? o + 65 : o < 52 ? o + 71 : o < 62 ? o - 4 : o - 59 | 43] = o++;
      r.encode = function(e2, t2, r2) {
        for (var i2, o2 = null, s2 = [], a = 0, l = 0; t2 < r2; ) {
          var c = e2[t2++];
          switch (l) {
            case 0:
              s2[a++] = n[c >> 2], i2 = (3 & c) << 4, l = 1;
              break;
            case 1:
              s2[a++] = n[i2 | c >> 4], i2 = (15 & c) << 2, l = 2;
              break;
            case 2:
              s2[a++] = n[i2 | c >> 6], s2[a++] = n[63 & c], l = 0;
          }
          a > 8191 && ((o2 || (o2 = [])).push(String.fromCharCode.apply(String, s2)), a = 0);
        }
        return l && (s2[a++] = n[i2], s2[a++] = 61, 1 === l && (s2[a++] = 61)), o2 ? (a && o2.push(String.fromCharCode.apply(String, s2.slice(0, a))), o2.join("")) : String.fromCharCode.apply(String, s2.slice(0, a));
      };
      var s = "invalid encoding";
      r.decode = function(e2, t2, r2) {
        for (var n2, o2 = r2, a = 0, l = 0; l < e2.length; ) {
          var c = e2.charCodeAt(l++);
          if (61 === c && a > 1) break;
          if (void 0 === (c = i[c])) throw Error(s);
          switch (a) {
            case 0:
              n2 = c, a = 1;
              break;
            case 1:
              t2[r2++] = n2 << 2 | (48 & c) >> 4, n2 = c, a = 2;
              break;
            case 2:
              t2[r2++] = (15 & n2) << 4 | (60 & c) >> 2, n2 = c, a = 3;
              break;
            case 3:
              t2[r2++] = (3 & n2) << 6 | c, a = 0;
          }
        }
        if (1 === a) throw Error(s);
        return r2 - o2;
      }, r.test = function(e2) {
        return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e2);
      };
    }, 3339: (e) => {
      e.exports = require$$10;
    }, 3388: (e, t) => {
      var r;
      Object.defineProperty(t, "__esModule", { value: true }), t.CompressionAlgorithms = void 0, (function(e2) {
        e2[e2.identity = 0] = "identity", e2[e2.deflate = 1] = "deflate", e2[e2.gzip = 2] = "gzip";
      })(r || (t.CompressionAlgorithms = r = {}));
    }, 3680: (e, t, r) => {
      "undefined" == typeof process || "renderer" === process.type || true === process.browser || process.__nwjs ? e.exports = r(124) : e.exports = r(5038);
    }, 3712: (e, t, r) => {
      e.exports = a;
      var n = r(4060);
      ((a.prototype = Object.create(n.prototype)).constructor = a).className = "Service";
      var i = r(7082), o = r(8723), s = r(7080);
      function a(e2, t2) {
        n.call(this, e2, t2), this.methods = {}, this._methodsArray = null;
      }
      function l(e2) {
        return e2._methodsArray = null, e2;
      }
      a.fromJSON = function(e2, t2) {
        var r2 = new a(e2, t2.options);
        if (t2.methods) for (var n2 = Object.keys(t2.methods), o2 = 0; o2 < n2.length; ++o2) r2.add(i.fromJSON(n2[o2], t2.methods[n2[o2]]));
        return t2.nested && r2.addJSON(t2.nested), t2.edition && (r2._edition = t2.edition), r2.comment = t2.comment, r2._defaultEdition = "proto3", r2;
      }, a.prototype.toJSON = function(e2) {
        var t2 = n.prototype.toJSON.call(this, e2), r2 = !!e2 && Boolean(e2.keepComments);
        return o.toObject(["edition", this._editionToJSON(), "options", t2 && t2.options || void 0, "methods", n.arrayToJSON(this.methodsArray, e2) || {}, "nested", t2 && t2.nested || void 0, "comment", r2 ? this.comment : void 0]);
      }, Object.defineProperty(a.prototype, "methodsArray", { get: function() {
        return this._methodsArray || (this._methodsArray = o.toArray(this.methods));
      } }), a.prototype.get = function(e2) {
        return this.methods[e2] || n.prototype.get.call(this, e2);
      }, a.prototype.resolveAll = function() {
        if (!this._needsRecursiveResolve) return this;
        n.prototype.resolve.call(this);
        for (var e2 = this.methodsArray, t2 = 0; t2 < e2.length; ++t2) e2[t2].resolve();
        return this;
      }, a.prototype._resolveFeaturesRecursive = function(e2) {
        return this._needsRecursiveFeatureResolution ? (e2 = this._edition || e2, n.prototype._resolveFeaturesRecursive.call(this, e2), this.methodsArray.forEach((t2) => {
          t2._resolveFeaturesRecursive(e2);
        }), this) : this;
      }, a.prototype.add = function(e2) {
        if (this.get(e2.name)) throw Error("duplicate name '" + e2.name + "' in " + this);
        return e2 instanceof i ? (this.methods[e2.name] = e2, e2.parent = this, l(this)) : n.prototype.add.call(this, e2);
      }, a.prototype.remove = function(e2) {
        if (e2 instanceof i) {
          if (this.methods[e2.name] !== e2) throw Error(e2 + " is not a member of " + this);
          return delete this.methods[e2.name], e2.parent = null, l(this);
        }
        return n.prototype.remove.call(this, e2);
      }, a.prototype.create = function(e2, t2, r2) {
        for (var n2, i2 = new s.Service(e2, t2, r2), a2 = 0; a2 < this.methodsArray.length; ++a2) {
          var l2 = o.lcFirst((n2 = this._methodsArray[a2]).resolve().name).replace(/[^$\w_]/g, "");
          i2[l2] = o.codegen(["r", "c"], o.isReserved(l2) ? l2 + "_" : l2)("return this.rpcCall(m,q,s,r,c)")({ m: n2, q: n2.resolvedRequestType.ctor, s: n2.resolvedResponseType.ctor });
        }
        return i2;
      };
    }, 3768: (module) => {
      function inquire(moduleName) {
        try {
          var mod = eval("quire".replace(/^/, "re"))(moduleName);
          if (mod && (mod.length || Object.keys(mod).length)) return mod;
        } catch (e) {
        }
        return null;
      }
      module.exports = inquire;
    }, 3777: (e, t, r) => {
      e.exports = function(e2) {
        var t2 = i.codegen(["m"], e2.name + "$verify")('if(typeof m!=="object"||m===null)')("return%j", "object expected"), r2 = {};
        e2.oneofsArray.length && t2("var p={}");
        for (var n2 = 0; n2 < e2.fieldsArray.length; ++n2) {
          var l = e2._fieldsArray[n2].resolve(), c = "m" + i.safeProp(l.name);
          if (l.optional && t2("if(%s!=null&&m.hasOwnProperty(%j)){", c, l.name), l.map) t2("if(!util.isObject(%s))", c)("return%j", o(l, "object"))("var k=Object.keys(%s)", c)("for(var i=0;i<k.length;++i){"), a(t2, l, "k[i]"), s(t2, l, n2, c + "[k[i]]")("}");
          else if (l.repeated) t2("if(!Array.isArray(%s))", c)("return%j", o(l, "array"))("for(var i=0;i<%s.length;++i){", c), s(t2, l, n2, c + "[i]")("}");
          else {
            if (l.partOf) {
              var u = i.safeProp(l.partOf.name);
              1 === r2[l.partOf.name] && t2("if(p%s===1)", u)("return%j", l.partOf.name + ": multiple values"), r2[l.partOf.name] = 1, t2("p%s=1", u);
            }
            s(t2, l, n2, c);
          }
          l.optional && t2("}");
        }
        return t2("return null");
      };
      var n = r(8118), i = r(8723);
      function o(e2, t2) {
        return e2.name + ": " + t2 + (e2.repeated && "array" !== t2 ? "[]" : e2.map && "object" !== t2 ? "{k:" + e2.keyType + "}" : "") + " expected";
      }
      function s(e2, t2, r2, i2) {
        if (t2.resolvedType) if (t2.resolvedType instanceof n) {
          e2("switch(%s){", i2)("default:")("return%j", o(t2, "enum value"));
          for (var s2 = Object.keys(t2.resolvedType.values), a2 = 0; a2 < s2.length; ++a2) e2("case %i:", t2.resolvedType.values[s2[a2]]);
          e2("break")("}");
        } else e2("{")("var e=types[%i].verify(%s);", r2, i2)("if(e)")("return%j+e", t2.name + ".")("}");
        else switch (t2.type) {
          case "int32":
          case "uint32":
          case "sint32":
          case "fixed32":
          case "sfixed32":
            e2("if(!util.isInteger(%s))", i2)("return%j", o(t2, "integer"));
            break;
          case "int64":
          case "uint64":
          case "sint64":
          case "fixed64":
          case "sfixed64":
            e2("if(!util.isInteger(%s)&&!(%s&&util.isInteger(%s.low)&&util.isInteger(%s.high)))", i2, i2, i2, i2)("return%j", o(t2, "integer|Long"));
            break;
          case "float":
          case "double":
            e2('if(typeof %s!=="number")', i2)("return%j", o(t2, "number"));
            break;
          case "bool":
            e2('if(typeof %s!=="boolean")', i2)("return%j", o(t2, "boolean"));
            break;
          case "string":
            e2("if(!util.isString(%s))", i2)("return%j", o(t2, "string"));
            break;
          case "bytes":
            e2('if(!(%s&&typeof %s.length==="number"||util.isString(%s)))', i2, i2, i2)("return%j", o(t2, "buffer"));
        }
        return e2;
      }
      function a(e2, t2, r2) {
        switch (t2.keyType) {
          case "int32":
          case "uint32":
          case "sint32":
          case "fixed32":
          case "sfixed32":
            e2("if(!util.key32Re.test(%s))", r2)("return%j", o(t2, "integer key"));
            break;
          case "int64":
          case "uint64":
          case "sint64":
          case "fixed64":
          case "sfixed64":
            e2("if(!util.key64Re.test(%s))", r2)("return%j", o(t2, "integer|Long key"));
            break;
          case "bool":
            e2("if(!util.key2Re.test(%s))", r2)("return%j", o(t2, "boolean key"));
        }
        return e2;
      }
    }, 3808: (e) => {
      e.exports = function(e2, t) {
        for (var r = new Array(arguments.length - 1), n = 0, i = 2, o = true; i < arguments.length; ) r[n++] = arguments[i++];
        return new Promise(function(i2, s) {
          r[n] = function(e3) {
            if (o) if (o = false, e3) s(e3);
            else {
              for (var t2 = new Array(arguments.length - 1), r2 = 0; r2 < t2.length; ) t2[r2++] = arguments[r2];
              i2.apply(null, t2);
            }
          };
          try {
            e2.apply(t || null, r);
          } catch (e3) {
            o && (o = false, s(e3));
          }
        });
      };
    }, 3930: (e) => {
      function t(e2) {
        try {
          return JSON.stringify(e2);
        } catch (e3) {
          return '"[Circular]"';
        }
      }
      e.exports = function(e2, r, n) {
        var i = n && n.stringify || t;
        if ("object" == typeof e2 && null !== e2) {
          var o = r.length + 1;
          if (1 === o) return e2;
          var s = new Array(o);
          s[0] = i(e2);
          for (var a = 1; a < o; a++) s[a] = i(r[a]);
          return s.join(" ");
        }
        if ("string" != typeof e2) return e2;
        var l = r.length;
        if (0 === l) return e2;
        for (var c = "", u = 0, d = -1, p = e2 && e2.length || 0, h = 0; h < p; ) {
          if (37 === e2.charCodeAt(h) && h + 1 < p) {
            switch (d = d > -1 ? d : 0, e2.charCodeAt(h + 1)) {
              case 100:
              case 102:
                if (u >= l) break;
                if (null == r[u]) break;
                d < h && (c += e2.slice(d, h)), c += Number(r[u]), d = h + 2, h++;
                break;
              case 105:
                if (u >= l) break;
                if (null == r[u]) break;
                d < h && (c += e2.slice(d, h)), c += Math.floor(Number(r[u])), d = h + 2, h++;
                break;
              case 79:
              case 111:
              case 106:
                if (u >= l) break;
                if (void 0 === r[u]) break;
                d < h && (c += e2.slice(d, h));
                var f = typeof r[u];
                if ("string" === f) {
                  c += "'" + r[u] + "'", d = h + 2, h++;
                  break;
                }
                if ("function" === f) {
                  c += r[u].name || "<anonymous>", d = h + 2, h++;
                  break;
                }
                c += i(r[u]), d = h + 2, h++;
                break;
              case 115:
                if (u >= l) break;
                d < h && (c += e2.slice(d, h)), c += String(r[u]), d = h + 2, h++;
                break;
              case 37:
                d < h && (c += e2.slice(d, h)), c += "%", d = h + 2, h++, u--;
            }
            ++u;
          }
          ++h;
        }
        return -1 === d ? e2 : (d < p && (c += e2.slice(d)), c);
      };
    }, 3946: (e) => {
      e.exports = JSON.parse('{"nested":{"google":{"nested":{"protobuf":{"nested":{"SourceContext":{"fields":{"fileName":{"type":"string","id":1}}}}}}}}}');
    }, 3963: (e, t, r) => {
      e.exports = l;
      var n, i = r(5099), o = i.LongBits, s = i.utf8;
      function a(e2, t2) {
        return RangeError("index out of range: " + e2.pos + " + " + (t2 || 1) + " > " + e2.len);
      }
      function l(e2) {
        this.buf = e2, this.pos = 0, this.len = e2.length;
      }
      var c, u = "undefined" != typeof Uint8Array ? function(e2) {
        if (e2 instanceof Uint8Array || Array.isArray(e2)) return new l(e2);
        throw Error("illegal buffer");
      } : function(e2) {
        if (Array.isArray(e2)) return new l(e2);
        throw Error("illegal buffer");
      }, d = function() {
        return i.Buffer ? function(e2) {
          return (l.create = function(e3) {
            return i.Buffer.isBuffer(e3) ? new n(e3) : u(e3);
          })(e2);
        } : u;
      };
      function p() {
        var e2 = new o(0, 0), t2 = 0;
        if (!(this.len - this.pos > 4)) {
          for (; t2 < 3; ++t2) {
            if (this.pos >= this.len) throw a(this);
            if (e2.lo = (e2.lo | (127 & this.buf[this.pos]) << 7 * t2) >>> 0, this.buf[this.pos++] < 128) return e2;
          }
          return e2.lo = (e2.lo | (127 & this.buf[this.pos++]) << 7 * t2) >>> 0, e2;
        }
        for (; t2 < 4; ++t2) if (e2.lo = (e2.lo | (127 & this.buf[this.pos]) << 7 * t2) >>> 0, this.buf[this.pos++] < 128) return e2;
        if (e2.lo = (e2.lo | (127 & this.buf[this.pos]) << 28) >>> 0, e2.hi = (e2.hi | (127 & this.buf[this.pos]) >> 4) >>> 0, this.buf[this.pos++] < 128) return e2;
        if (t2 = 0, this.len - this.pos > 4) {
          for (; t2 < 5; ++t2) if (e2.hi = (e2.hi | (127 & this.buf[this.pos]) << 7 * t2 + 3) >>> 0, this.buf[this.pos++] < 128) return e2;
        } else for (; t2 < 5; ++t2) {
          if (this.pos >= this.len) throw a(this);
          if (e2.hi = (e2.hi | (127 & this.buf[this.pos]) << 7 * t2 + 3) >>> 0, this.buf[this.pos++] < 128) return e2;
        }
        throw Error("invalid varint encoding");
      }
      function h(e2, t2) {
        return (e2[t2 - 4] | e2[t2 - 3] << 8 | e2[t2 - 2] << 16 | e2[t2 - 1] << 24) >>> 0;
      }
      function f() {
        if (this.pos + 8 > this.len) throw a(this, 8);
        return new o(h(this.buf, this.pos += 4), h(this.buf, this.pos += 4));
      }
      l.create = d(), l.prototype._slice = i.Array.prototype.subarray || i.Array.prototype.slice, l.prototype.uint32 = (c = 4294967295, function() {
        if (c = (127 & this.buf[this.pos]) >>> 0, this.buf[this.pos++] < 128) return c;
        if (c = (c | (127 & this.buf[this.pos]) << 7) >>> 0, this.buf[this.pos++] < 128) return c;
        if (c = (c | (127 & this.buf[this.pos]) << 14) >>> 0, this.buf[this.pos++] < 128) return c;
        if (c = (c | (127 & this.buf[this.pos]) << 21) >>> 0, this.buf[this.pos++] < 128) return c;
        if (c = (c | (15 & this.buf[this.pos]) << 28) >>> 0, this.buf[this.pos++] < 128) return c;
        if ((this.pos += 5) > this.len) throw this.pos = this.len, a(this, 10);
        return c;
      }), l.prototype.int32 = function() {
        return 0 | this.uint32();
      }, l.prototype.sint32 = function() {
        var e2 = this.uint32();
        return e2 >>> 1 ^ -(1 & e2);
      }, l.prototype.bool = function() {
        return 0 !== this.uint32();
      }, l.prototype.fixed32 = function() {
        if (this.pos + 4 > this.len) throw a(this, 4);
        return h(this.buf, this.pos += 4);
      }, l.prototype.sfixed32 = function() {
        if (this.pos + 4 > this.len) throw a(this, 4);
        return 0 | h(this.buf, this.pos += 4);
      }, l.prototype.float = function() {
        if (this.pos + 4 > this.len) throw a(this, 4);
        var e2 = i.float.readFloatLE(this.buf, this.pos);
        return this.pos += 4, e2;
      }, l.prototype.double = function() {
        if (this.pos + 8 > this.len) throw a(this, 4);
        var e2 = i.float.readDoubleLE(this.buf, this.pos);
        return this.pos += 8, e2;
      }, l.prototype.bytes = function() {
        var e2 = this.uint32(), t2 = this.pos, r2 = this.pos + e2;
        if (r2 > this.len) throw a(this, e2);
        if (this.pos += e2, Array.isArray(this.buf)) return this.buf.slice(t2, r2);
        if (t2 === r2) {
          var n2 = i.Buffer;
          return n2 ? n2.alloc(0) : new this.buf.constructor(0);
        }
        return this._slice.call(this.buf, t2, r2);
      }, l.prototype.string = function() {
        var e2 = this.bytes();
        return s.read(e2, 0, e2.length);
      }, l.prototype.skip = function(e2) {
        if ("number" == typeof e2) {
          if (this.pos + e2 > this.len) throw a(this, e2);
          this.pos += e2;
        } else do {
          if (this.pos >= this.len) throw a(this);
        } while (128 & this.buf[this.pos++]);
        return this;
      }, l.prototype.skipType = function(e2) {
        switch (e2) {
          case 0:
            this.skip();
            break;
          case 1:
            this.skip(8);
            break;
          case 2:
            this.skip(this.uint32());
            break;
          case 3:
            for (; 4 != (e2 = 7 & this.uint32()); ) this.skipType(e2);
            break;
          case 5:
            this.skip(4);
            break;
          default:
            throw Error("invalid wire type " + e2 + " at offset " + this.pos);
        }
        return this;
      }, l._configure = function(e2) {
        n = e2, l.create = d(), n._configure();
        var t2 = i.Long ? "toLong" : "toNumber";
        i.merge(l.prototype, { int64: function() {
          return p.call(this)[t2](false);
        }, uint64: function() {
          return p.call(this)[t2](true);
        }, sint64: function() {
          return p.call(this).zzDecode()[t2](false);
        }, fixed64: function() {
          return f.call(this)[t2](true);
        }, sfixed64: function() {
          return f.call(this)[t2](false);
        } });
      };
    }, 3964: (e, t, r) => {
      const { createRequire: n } = r(3339), i = r(626), { join: o, isAbsolute: s, sep: a } = r(6760), l = r(9817), c = r(1511), u = r(9421);
      function d(e2) {
        c.register(e2, p), c.registerBeforeExit(e2, h), e2.on("close", function() {
          c.unregister(e2);
        });
      }
      function p(e2) {
        e2.ref(), e2.flushSync(), e2.end(), e2.once("close", function() {
          e2.unref();
        });
      }
      function h(e2) {
        e2.flushSync();
      }
      e.exports = function(e2) {
        const { pipeline: t2, targets: r2, levels: c2, dedupe: p2, worker: h2 = {}, caller: f = i(), sync: g = false } = e2, m = { ...e2.options }, y = "string" == typeof f ? [f] : f, v = "__bundlerPathsOverrides" in globalThis ? globalThis.__bundlerPathsOverrides : {};
        let b = e2.target;
        if (b && r2) throw new Error("only one of target or targets can be specified");
        return r2 ? (b = v["pino-worker"] || o(__dirname, "worker.js"), m.targets = r2.filter((e3) => e3.target).map((e3) => ({ ...e3, target: S(e3.target) })), m.pipelines = r2.filter((e3) => e3.pipeline).map((e3) => e3.pipeline.map((t3) => ({ ...t3, level: e3.level, target: S(t3.target) })))) : t2 && (b = v["pino-worker"] || o(__dirname, "worker.js"), m.pipelines = [t2.map((e3) => ({ ...e3, target: S(e3.target) }))]), c2 && (m.levels = c2), p2 && (m.dedupe = p2), m.pinoWillSendConfig = true, (function(e3, t3, r3, n2) {
          const i2 = new u({ filename: e3, workerData: t3, workerOpts: r3, sync: n2 });
          function o2() {
            i2.closed || (i2.flushSync(), l(100), i2.end());
          }
          return i2.on("ready", function() {
            process.removeListener("exit", o2), i2.unref(), false !== r3.autoEnd && d(i2);
          }), i2.on("close", function() {
            process.removeListener("exit", o2);
          }), process.on("exit", o2), i2;
        })(S(b), m, h2, g);
        function S(e3) {
          if (e3 = v[e3] || e3, s(e3) || 0 === e3.indexOf("file://")) return e3;
          if ("pino/file" === e3) return o(__dirname, "..", "file.js");
          let t3;
          for (const r3 of y) try {
            const i2 = "node:repl" === r3 ? process.cwd() + a : r3;
            t3 = n(i2).resolve(e3);
            break;
          } catch (e4) {
            continue;
          }
          if (!t3) throw new Error(`unable to determine transport target for "${e3}"`);
          return t3;
        }
      };
    }, 3965: (e) => {
      e.exports = { WRITE_INDEX: 4, READ_INDEX: 8 };
    }, 3982: (e, t) => {
      var r;
      Object.defineProperty(t, "__esModule", { value: true }), t.StreamDecoder = void 0, (function(e2) {
        e2[e2.NO_DATA = 0] = "NO_DATA", e2[e2.READING_SIZE = 1] = "READING_SIZE", e2[e2.READING_MESSAGE = 2] = "READING_MESSAGE";
      })(r || (r = {})), t.StreamDecoder = class {
        constructor(e2) {
          this.maxReadMessageLength = e2, this.readState = r.NO_DATA, this.readCompressFlag = Buffer.alloc(1), this.readPartialSize = Buffer.alloc(4), this.readSizeRemaining = 4, this.readMessageSize = 0, this.readPartialMessage = [], this.readMessageRemaining = 0;
        }
        write(e2) {
          let t2, n = 0;
          const i = [];
          for (; n < e2.length; ) switch (this.readState) {
            case r.NO_DATA:
              this.readCompressFlag = e2.slice(n, n + 1), n += 1, this.readState = r.READING_SIZE, this.readPartialSize.fill(0), this.readSizeRemaining = 4, this.readMessageSize = 0, this.readMessageRemaining = 0, this.readPartialMessage = [];
              break;
            case r.READING_SIZE:
              if (t2 = Math.min(e2.length - n, this.readSizeRemaining), e2.copy(this.readPartialSize, 4 - this.readSizeRemaining, n, n + t2), this.readSizeRemaining -= t2, n += t2, 0 === this.readSizeRemaining) {
                if (this.readMessageSize = this.readPartialSize.readUInt32BE(0), -1 !== this.maxReadMessageLength && this.readMessageSize > this.maxReadMessageLength) throw new Error(`Received message larger than max (${this.readMessageSize} vs ${this.maxReadMessageLength})`);
                if (this.readMessageRemaining = this.readMessageSize, this.readMessageRemaining > 0) this.readState = r.READING_MESSAGE;
                else {
                  const e3 = Buffer.concat([this.readCompressFlag, this.readPartialSize], 5);
                  this.readState = r.NO_DATA, i.push(e3);
                }
              }
              break;
            case r.READING_MESSAGE:
              if (t2 = Math.min(e2.length - n, this.readMessageRemaining), this.readPartialMessage.push(e2.slice(n, n + t2)), this.readMessageRemaining -= t2, n += t2, 0 === this.readMessageRemaining) {
                const e3 = [this.readCompressFlag, this.readPartialSize].concat(this.readPartialMessage), t3 = Buffer.concat(e3, this.readMessageSize + 5);
                this.readState = r.NO_DATA, i.push(t3);
              }
              break;
            default:
              throw new Error("Unexpected read state");
          }
          return i;
        }
      };
    }, 4060: (e, t, r) => {
      e.exports = d;
      var n = r(7812);
      ((d.prototype = Object.create(n.prototype)).constructor = d).className = "Namespace";
      var i, o, s, a = r(4243), l = r(8723), c = r(7166);
      function u(e2, t2) {
        if (e2 && e2.length) {
          for (var r2 = {}, n2 = 0; n2 < e2.length; ++n2) r2[e2[n2].name] = e2[n2].toJSON(t2);
          return r2;
        }
      }
      function d(e2, t2) {
        n.call(this, e2, t2), this.nested = void 0, this._nestedArray = null, this._lookupCache = {}, this._needsRecursiveFeatureResolution = true, this._needsRecursiveResolve = true;
      }
      function p(e2) {
        e2._nestedArray = null, e2._lookupCache = {};
        for (var t2 = e2; t2 = t2.parent; ) t2._lookupCache = {};
        return e2;
      }
      d.fromJSON = function(e2, t2) {
        return new d(e2, t2.options).addJSON(t2.nested);
      }, d.arrayToJSON = u, d.isReservedId = function(e2, t2) {
        if (e2) {
          for (var r2 = 0; r2 < e2.length; ++r2) if ("string" != typeof e2[r2] && e2[r2][0] <= t2 && e2[r2][1] > t2) return true;
        }
        return false;
      }, d.isReservedName = function(e2, t2) {
        if (e2) {
          for (var r2 = 0; r2 < e2.length; ++r2) if (e2[r2] === t2) return true;
        }
        return false;
      }, Object.defineProperty(d.prototype, "nestedArray", { get: function() {
        return this._nestedArray || (this._nestedArray = l.toArray(this.nested));
      } }), d.prototype.toJSON = function(e2) {
        return l.toObject(["options", this.options, "nested", u(this.nestedArray, e2)]);
      }, d.prototype.addJSON = function(e2) {
        if (e2) for (var t2, r2 = Object.keys(e2), n2 = 0; n2 < r2.length; ++n2) t2 = e2[r2[n2]], this.add((void 0 !== t2.fields ? i.fromJSON : void 0 !== t2.values ? s.fromJSON : void 0 !== t2.methods ? o.fromJSON : void 0 !== t2.id ? a.fromJSON : d.fromJSON)(r2[n2], t2));
        return this;
      }, d.prototype.get = function(e2) {
        return this.nested && this.nested[e2] || null;
      }, d.prototype.getEnum = function(e2) {
        if (this.nested && this.nested[e2] instanceof s) return this.nested[e2].values;
        throw Error("no such enum: " + e2);
      }, d.prototype.add = function(e2) {
        if (!(e2 instanceof a && void 0 !== e2.extend || e2 instanceof i || e2 instanceof c || e2 instanceof s || e2 instanceof o || e2 instanceof d)) throw TypeError("object must be a valid nested object");
        if (this.nested) {
          var t2 = this.get(e2.name);
          if (t2) {
            if (!(t2 instanceof d && e2 instanceof d) || t2 instanceof i || t2 instanceof o) throw Error("duplicate name '" + e2.name + "' in " + this);
            for (var r2 = t2.nestedArray, n2 = 0; n2 < r2.length; ++n2) e2.add(r2[n2]);
            this.remove(t2), this.nested || (this.nested = {}), e2.setOptions(t2.options, true);
          }
        } else this.nested = {};
        this.nested[e2.name] = e2, this instanceof i || this instanceof o || this instanceof s || this instanceof a || e2._edition || (e2._edition = e2._defaultEdition), this._needsRecursiveFeatureResolution = true, this._needsRecursiveResolve = true;
        for (var l2 = this; l2 = l2.parent; ) l2._needsRecursiveFeatureResolution = true, l2._needsRecursiveResolve = true;
        return e2.onAdd(this), p(this);
      }, d.prototype.remove = function(e2) {
        if (!(e2 instanceof n)) throw TypeError("object must be a ReflectionObject");
        if (e2.parent !== this) throw Error(e2 + " is not a member of " + this);
        return delete this.nested[e2.name], Object.keys(this.nested).length || (this.nested = void 0), e2.onRemove(this), p(this);
      }, d.prototype.define = function(e2, t2) {
        if (l.isString(e2)) e2 = e2.split(".");
        else if (!Array.isArray(e2)) throw TypeError("illegal path");
        if (e2 && e2.length && "" === e2[0]) throw Error("path must be relative");
        for (var r2 = this; e2.length > 0; ) {
          var n2 = e2.shift();
          if (r2.nested && r2.nested[n2]) {
            if (!((r2 = r2.nested[n2]) instanceof d)) throw Error("path conflicts with non-namespace objects");
          } else r2.add(r2 = new d(n2));
        }
        return t2 && r2.addJSON(t2), r2;
      }, d.prototype.resolveAll = function() {
        if (!this._needsRecursiveResolve) return this;
        this._resolveFeaturesRecursive(this._edition);
        var e2 = this.nestedArray, t2 = 0;
        for (this.resolve(); t2 < e2.length; ) e2[t2] instanceof d ? e2[t2++].resolveAll() : e2[t2++].resolve();
        return this._needsRecursiveResolve = false, this;
      }, d.prototype._resolveFeaturesRecursive = function(e2) {
        return this._needsRecursiveFeatureResolution ? (this._needsRecursiveFeatureResolution = false, e2 = this._edition || e2, n.prototype._resolveFeaturesRecursive.call(this, e2), this.nestedArray.forEach((t2) => {
          t2._resolveFeaturesRecursive(e2);
        }), this) : this;
      }, d.prototype.lookup = function(e2, t2, r2) {
        if ("boolean" == typeof t2 ? (r2 = t2, t2 = void 0) : t2 && !Array.isArray(t2) && (t2 = [t2]), l.isString(e2) && e2.length) {
          if ("." === e2) return this.root;
          e2 = e2.split(".");
        } else if (!e2.length) return this;
        var n2 = e2.join(".");
        if ("" === e2[0]) return this.root.lookup(e2.slice(1), t2);
        var i2 = this.root._fullyQualifiedObjects && this.root._fullyQualifiedObjects["." + n2];
        if (i2 && (!t2 || t2.indexOf(i2.constructor) > -1)) return i2;
        if ((i2 = this._lookupImpl(e2, n2)) && (!t2 || t2.indexOf(i2.constructor) > -1)) return i2;
        if (r2) return null;
        for (var o2 = this; o2.parent; ) {
          if ((i2 = o2.parent._lookupImpl(e2, n2)) && (!t2 || t2.indexOf(i2.constructor) > -1)) return i2;
          o2 = o2.parent;
        }
        return null;
      }, d.prototype._lookupImpl = function(e2, t2) {
        if (Object.prototype.hasOwnProperty.call(this._lookupCache, t2)) return this._lookupCache[t2];
        var r2 = this.get(e2[0]), n2 = null;
        if (r2) 1 === e2.length ? n2 = r2 : r2 instanceof d && (e2 = e2.slice(1), n2 = r2._lookupImpl(e2, e2.join(".")));
        else for (var i2 = 0; i2 < this.nestedArray.length; ++i2) this._nestedArray[i2] instanceof d && (r2 = this._nestedArray[i2]._lookupImpl(e2, t2)) && (n2 = r2);
        return this._lookupCache[t2] = n2, n2;
      }, d.prototype.lookupType = function(e2) {
        var t2 = this.lookup(e2, [i]);
        if (!t2) throw Error("no such type: " + e2);
        return t2;
      }, d.prototype.lookupEnum = function(e2) {
        var t2 = this.lookup(e2, [s]);
        if (!t2) throw Error("no such Enum '" + e2 + "' in " + this);
        return t2;
      }, d.prototype.lookupTypeOrEnum = function(e2) {
        var t2 = this.lookup(e2, [i, s]);
        if (!t2) throw Error("no such Type or Enum '" + e2 + "' in " + this);
        return t2;
      }, d.prototype.lookupService = function(e2) {
        var t2 = this.lookup(e2, [o]);
        if (!t2) throw Error("no such Service '" + e2 + "' in " + this);
        return t2;
      }, d._configure = function(e2, t2, r2) {
        i = e2, o = t2, s = r2;
      };
    }, 4080: (e, t, r) => {
      const n = r(6928), i = r(4326), o = r(8139);
      function s(e2, t2) {
        const r2 = e2.options.env || define_process_env_default, s2 = process.cwd(), a = null != e2.options.cwd, l = a && void 0 !== process.chdir && !process.chdir.disabled;
        if (l) try {
          process.chdir(e2.options.cwd);
        } catch (e3) {
        }
        let c;
        try {
          c = i.sync(e2.command, { path: r2[o({ env: r2 })], pathExt: t2 ? n.delimiter : void 0 });
        } catch (e3) {
        } finally {
          l && process.chdir(s2);
        }
        return c && (c = n.resolve(a ? e2.options.cwd : "", c)), c;
      }
      e.exports = function(e2) {
        return s(e2) || s(e2, true);
      };
    }, 4129: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.QueuePicker = t.UnavailablePicker = t.PickResultType = void 0;
      const n = r(9074), i = r(6754);
      var o;
      !(function(e2) {
        e2[e2.COMPLETE = 0] = "COMPLETE", e2[e2.QUEUE = 1] = "QUEUE", e2[e2.TRANSIENT_FAILURE = 2] = "TRANSIENT_FAILURE", e2[e2.DROP = 3] = "DROP";
      })(o || (t.PickResultType = o = {})), t.UnavailablePicker = class {
        constructor(e2) {
          this.status = Object.assign({ code: i.Status.UNAVAILABLE, details: "No connection established", metadata: new n.Metadata() }, e2);
        }
        pick(e2) {
          return { pickResultType: o.TRANSIENT_FAILURE, subchannel: null, status: this.status, onCallStarted: null, onCallEnded: null };
        }
      }, t.QueuePicker = class {
        constructor(e2, t2) {
          this.loadBalancer = e2, this.childPicker = t2, this.calledExitIdle = false;
        }
        pick(e2) {
          return this.calledExitIdle || (process.nextTick(() => {
            this.loadBalancer.exitIdle();
          }), this.calledExitIdle = true), this.childPicker ? this.childPicker.pick(e2) : { pickResultType: o.QUEUE, subchannel: null, status: null, onCallStarted: null, onCallEnded: null };
        }
      };
    }, 4132: (e) => {
      function t(e2, r) {
        "string" == typeof e2 && (r = e2, e2 = void 0);
        var n = [];
        function i(e3) {
          if ("string" != typeof e3) {
            var r2 = o();
            if (t.verbose && console.log("codegen: " + r2), r2 = "return " + r2, e3) {
              for (var s = Object.keys(e3), a = new Array(s.length + 1), l = new Array(s.length), c = 0; c < s.length; ) a[c] = s[c], l[c] = e3[s[c++]];
              return a[c] = r2, Function.apply(null, a).apply(null, l);
            }
            return Function(r2)();
          }
          for (var u = new Array(arguments.length - 1), d = 0; d < u.length; ) u[d] = arguments[++d];
          if (d = 0, e3 = e3.replace(/%([%dfijs])/g, function(e4, t2) {
            var r3 = u[d++];
            switch (t2) {
              case "d":
              case "f":
                return String(Number(r3));
              case "i":
                return String(Math.floor(r3));
              case "j":
                return JSON.stringify(r3);
              case "s":
                return String(r3);
            }
            return "%";
          }), d !== u.length) throw Error("parameter count mismatch");
          return n.push(e3), i;
        }
        function o(t2) {
          return "function " + (t2 || r || "") + "(" + (e2 && e2.join(",") || "") + "){\n  " + n.join("\n  ") + "\n}";
        }
        return i.toString = o, i;
      }
      e.exports = t, t.verbose = false;
    }, 4155: (e, t, r) => {
      e.exports = i, i.sync = function(e2, t2) {
        return o(n.statSync(e2), t2);
      };
      var n = r(9896);
      function i(e2, t2, r2) {
        n.stat(e2, function(e3, n2) {
          r2(e3, !e3 && o(n2, t2));
        });
      }
      function o(e2, t2) {
        return e2.isFile() && (function(e3, t3) {
          var r2 = e3.mode, n2 = e3.uid, i2 = e3.gid, o2 = void 0 !== t3.uid ? t3.uid : process.getuid && process.getuid(), s = void 0 !== t3.gid ? t3.gid : process.getgid && process.getgid(), a = parseInt("100", 8), l = parseInt("010", 8);
          return r2 & parseInt("001", 8) || r2 & l && i2 === s || r2 & a && n2 === o2 || r2 & (a | l) && 0 === o2;
        })(e2, t2);
      }
    }, 4169: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.mapUriDefaultScheme = t.getDefaultAuthority = t.createResolver = t.registerDefaultScheme = t.registerResolver = void 0;
      const n = r(5129), i = {};
      let o = null;
      t.registerResolver = function(e2, t2) {
        i[e2] = t2;
      }, t.registerDefaultScheme = function(e2) {
        o = e2;
      }, t.createResolver = function(e2, t2, r2) {
        if (void 0 !== e2.scheme && e2.scheme in i) return new i[e2.scheme](e2, t2, r2);
        throw new Error(`No resolver could be created for target ${(0, n.uriToString)(e2)}`);
      }, t.getDefaultAuthority = function(e2) {
        if (void 0 !== e2.scheme && e2.scheme in i) return i[e2.scheme].getDefaultAuthority(e2);
        throw new Error(`Invalid target ${(0, n.uriToString)(e2)}`);
      }, t.mapUriDefaultScheme = function(e2) {
        return void 0 !== e2.scheme && e2.scheme in i ? e2 : null !== o ? { scheme: o, authority: void 0, path: (0, n.uriToString)(e2) } : null;
      };
    }, 4243: (e, t, r) => {
      e.exports = c;
      var n = r(7812);
      ((c.prototype = Object.create(n.prototype)).constructor = c).className = "Field";
      var i, o = r(8118), s = r(5594), a = r(8723), l = /^required|optional|repeated$/;
      function c(e2, t2, r2, i2, o2, c2, u) {
        if (a.isObject(i2) ? (u = o2, c2 = i2, i2 = o2 = void 0) : a.isObject(o2) && (u = c2, c2 = o2, o2 = void 0), n.call(this, e2, c2), !a.isInteger(t2) || t2 < 0) throw TypeError("id must be a non-negative integer");
        if (!a.isString(r2)) throw TypeError("type must be a string");
        if (void 0 !== i2 && !l.test(i2 = i2.toString().toLowerCase())) throw TypeError("rule must be a string rule");
        if (void 0 !== o2 && !a.isString(o2)) throw TypeError("extend must be a string");
        "proto3_optional" === i2 && (i2 = "optional"), this.rule = i2 && "optional" !== i2 ? i2 : void 0, this.type = r2, this.id = t2, this.extend = o2 || void 0, this.repeated = "repeated" === i2, this.map = false, this.message = null, this.partOf = null, this.typeDefault = null, this.defaultValue = null, this.long = !!a.Long && void 0 !== s.long[r2], this.bytes = "bytes" === r2, this.resolvedType = null, this.extensionField = null, this.declaringField = null, this.comment = u;
      }
      c.fromJSON = function(e2, t2) {
        var r2 = new c(e2, t2.id, t2.type, t2.rule, t2.extend, t2.options, t2.comment);
        return t2.edition && (r2._edition = t2.edition), r2._defaultEdition = "proto3", r2;
      }, Object.defineProperty(c.prototype, "required", { get: function() {
        return "LEGACY_REQUIRED" === this._features.field_presence;
      } }), Object.defineProperty(c.prototype, "optional", { get: function() {
        return !this.required;
      } }), Object.defineProperty(c.prototype, "delimited", { get: function() {
        return this.resolvedType instanceof i && "DELIMITED" === this._features.message_encoding;
      } }), Object.defineProperty(c.prototype, "packed", { get: function() {
        return "PACKED" === this._features.repeated_field_encoding;
      } }), Object.defineProperty(c.prototype, "hasPresence", { get: function() {
        return !this.repeated && !this.map && (this.partOf || this.declaringField || this.extensionField || "IMPLICIT" !== this._features.field_presence);
      } }), c.prototype.setOption = function(e2, t2, r2) {
        return n.prototype.setOption.call(this, e2, t2, r2);
      }, c.prototype.toJSON = function(e2) {
        var t2 = !!e2 && Boolean(e2.keepComments);
        return a.toObject(["edition", this._editionToJSON(), "rule", "optional" !== this.rule && this.rule || void 0, "type", this.type, "id", this.id, "extend", this.extend, "options", this.options, "comment", t2 ? this.comment : void 0]);
      }, c.prototype.resolve = function() {
        if (this.resolved) return this;
        if (void 0 === (this.typeDefault = s.defaults[this.type]) ? (this.resolvedType = (this.declaringField ? this.declaringField.parent : this.parent).lookupTypeOrEnum(this.type), this.resolvedType instanceof i ? this.typeDefault = null : this.typeDefault = this.resolvedType.values[Object.keys(this.resolvedType.values)[0]]) : this.options && this.options.proto3_optional && (this.typeDefault = null), this.options && null != this.options.default && (this.typeDefault = this.options.default, this.resolvedType instanceof o && "string" == typeof this.typeDefault && (this.typeDefault = this.resolvedType.values[this.typeDefault])), this.options && (void 0 === this.options.packed || !this.resolvedType || this.resolvedType instanceof o || delete this.options.packed, Object.keys(this.options).length || (this.options = void 0)), this.long) this.typeDefault = a.Long.fromNumber(this.typeDefault, "u" === this.type.charAt(0)), Object.freeze && Object.freeze(this.typeDefault);
        else if (this.bytes && "string" == typeof this.typeDefault) {
          var e2;
          a.base64.test(this.typeDefault) ? a.base64.decode(this.typeDefault, e2 = a.newBuffer(a.base64.length(this.typeDefault)), 0) : a.utf8.write(this.typeDefault, e2 = a.newBuffer(a.utf8.length(this.typeDefault)), 0), this.typeDefault = e2;
        }
        return this.map ? this.defaultValue = a.emptyObject : this.repeated ? this.defaultValue = a.emptyArray : this.defaultValue = this.typeDefault, this.parent instanceof i && (this.parent.ctor.prototype[this.name] = this.defaultValue), n.prototype.resolve.call(this);
      }, c.prototype._inferLegacyProtoFeatures = function(e2) {
        if ("proto2" !== e2 && "proto3" !== e2) return {};
        var t2 = {};
        if ("required" === this.rule && (t2.field_presence = "LEGACY_REQUIRED"), this.parent && void 0 === s.defaults[this.type]) {
          var r2 = this.parent.get(this.type.split(".").pop());
          r2 && r2 instanceof i && r2.group && (t2.message_encoding = "DELIMITED");
        }
        return true === this.getOption("packed") ? t2.repeated_field_encoding = "PACKED" : false === this.getOption("packed") && (t2.repeated_field_encoding = "EXPANDED"), t2;
      }, c.prototype._resolveFeatures = function(e2) {
        return n.prototype._resolveFeatures.call(this, this._edition || e2);
      }, c.d = function(e2, t2, r2, n2) {
        return "function" == typeof t2 ? t2 = a.decorateType(t2).name : t2 && "object" == typeof t2 && (t2 = a.decorateEnum(t2).name), function(i2, o2) {
          a.decorateType(i2.constructor).add(new c(o2, e2, t2, r2, { default: n2 }));
        };
      }, c._configure = function(e2) {
        i = e2;
      };
    }, 4326: (e, t, r) => {
      const n = "win32" === process.platform || "cygwin" === define_process_env_default.OSTYPE || "msys" === define_process_env_default.OSTYPE, i = r(6928), o = n ? ";" : ":", s = r(9882), a = (e2) => Object.assign(new Error(`not found: ${e2}`), { code: "ENOENT" }), l = (e2, t2) => {
        const r2 = t2.colon || o, i2 = e2.match(/\//) || n && e2.match(/\\/) ? [""] : [...n ? [process.cwd()] : [], ...(t2.path || define_process_env_default.PATH || "").split(r2)], s2 = n ? t2.pathExt || define_process_env_default.PATHEXT || ".EXE;.CMD;.BAT;.COM" : "", a2 = n ? s2.split(r2) : [""];
        return n && -1 !== e2.indexOf(".") && "" !== a2[0] && a2.unshift(""), { pathEnv: i2, pathExt: a2, pathExtExe: s2 };
      }, c = (e2, t2, r2) => {
        "function" == typeof t2 && (r2 = t2, t2 = {}), t2 || (t2 = {});
        const { pathEnv: n2, pathExt: o2, pathExtExe: c2 } = l(e2, t2), u = [], d = (r3) => new Promise((o3, s2) => {
          if (r3 === n2.length) return t2.all && u.length ? o3(u) : s2(a(e2));
          const l2 = n2[r3], c3 = /^".*"$/.test(l2) ? l2.slice(1, -1) : l2, d2 = i.join(c3, e2), h = !c3 && /^\.[\\\/]/.test(e2) ? e2.slice(0, 2) + d2 : d2;
          o3(p(h, r3, 0));
        }), p = (e3, r3, n3) => new Promise((i2, a2) => {
          if (n3 === o2.length) return i2(d(r3 + 1));
          const l2 = o2[n3];
          s(e3 + l2, { pathExt: c2 }, (o3, s2) => {
            if (!o3 && s2) {
              if (!t2.all) return i2(e3 + l2);
              u.push(e3 + l2);
            }
            return i2(p(e3, r3, n3 + 1));
          });
        });
        return r2 ? d(0).then((e3) => r2(null, e3), r2) : d(0);
      };
      e.exports = c, c.sync = (e2, t2) => {
        t2 = t2 || {};
        const { pathEnv: r2, pathExt: n2, pathExtExe: o2 } = l(e2, t2), c2 = [];
        for (let a2 = 0; a2 < r2.length; a2++) {
          const l2 = r2[a2], u = /^".*"$/.test(l2) ? l2.slice(1, -1) : l2, d = i.join(u, e2), p = !u && /^\.[\\\/]/.test(e2) ? e2.slice(0, 2) + d : d;
          for (let e3 = 0; e3 < n2.length; e3++) {
            const r3 = p + n2[e3];
            try {
              if (s.sync(r3, { pathExt: o2 })) {
                if (!t2.all) return r3;
                c2.push(r3);
              }
            } catch (e4) {
            }
          }
        }
        if (t2.all && c2.length) return c2;
        if (t2.nothrow) return null;
        throw a(e2);
      };
    }, 4340: (e, t, r) => {
      e.exports = E, E.filename = null, E.defaults = { keepCase: false };
      var n = r(350), i = r(7207), o = r(1311), s = r(4243), a = r(4341), l = r(7166), c = r(8118), u = r(3712), d = r(7082), p = r(7812), h = r(5594), f = r(8723), g = /^[1-9][0-9]*$/, m = /^-?[1-9][0-9]*$/, y = /^0[x][0-9a-fA-F]+$/, v = /^-?0[x][0-9a-fA-F]+$/, b = /^0[0-7]+$/, S = /^-?0[0-7]+$/, w = /^(?![eE])[0-9]*(?:\.[0-9]*)?(?:[eE][+-]?[0-9]+)?$/, C = /^[a-zA-Z_][a-zA-Z_0-9]*$/, _2 = /^(?:\.?[a-zA-Z_][a-zA-Z_0-9]*)(?:\.[a-zA-Z_][a-zA-Z_0-9]*)*$/;
      function E(e2, t2, r2) {
        t2 instanceof i || (r2 = t2, t2 = new i()), r2 || (r2 = E.defaults);
        var R, T, O, I, M = r2.preferTrailingComment || false, k = n(e2, r2.alternateCommentMode || false), D = k.next, P = k.push, F = k.peek, x = k.skip, A = k.cmnt, N = true, B = "proto2", j = t2, L = [], z = {}, q = r2.keepCase ? function(e3) {
          return e3;
        } : f.camelCase;
        function U(e3, t3, r3) {
          var n2 = E.filename;
          return r3 || (E.filename = null), Error("illegal " + (t3 || "token") + " '" + e3 + "' (" + (n2 ? n2 + ", " : "") + "line " + k.line + ")");
        }
        function W() {
          var e3, t3 = [];
          do {
            if ('"' !== (e3 = D()) && "'" !== e3) throw U(e3);
            t3.push(D()), x(e3), e3 = F();
          } while ('"' === e3 || "'" === e3);
          return t3.join("");
        }
        function $(e3) {
          var t3 = D();
          switch (t3) {
            case "'":
            case '"':
              return P(t3), W();
            case "true":
            case "TRUE":
              return true;
            case "false":
            case "FALSE":
              return false;
          }
          try {
            return (function(e4) {
              var t4 = 1;
              switch ("-" === e4.charAt(0) && (t4 = -1, e4 = e4.substring(1)), e4) {
                case "inf":
                case "INF":
                case "Inf":
                  return t4 * (1 / 0);
                case "nan":
                case "NAN":
                case "Nan":
                case "NaN":
                  return NaN;
                case "0":
                  return 0;
              }
              if (g.test(e4)) return t4 * parseInt(e4, 10);
              if (y.test(e4)) return t4 * parseInt(e4, 16);
              if (b.test(e4)) return t4 * parseInt(e4, 8);
              if (w.test(e4)) return t4 * parseFloat(e4);
              throw U(e4, "number", true);
            })(t3);
          } catch (r3) {
            if (_2.test(t3)) return t3;
            throw U(t3, "value");
          }
        }
        function V(e3, t3) {
          var r3, n2;
          do {
            if (!t3 || '"' !== (r3 = F()) && "'" !== r3) try {
              e3.push([n2 = H(D()), x("to", true) ? H(D()) : n2]);
            } catch (n3) {
              if (!(t3 && _2.test(r3) && B >= 2023)) throw n3;
              e3.push(r3);
            }
            else {
              var i2 = W();
              if (e3.push(i2), B >= 2023) throw U(i2, "id");
            }
          } while (x(",", true));
          var o2 = { options: void 0, setOption: function(e4, t4) {
            void 0 === this.options && (this.options = {}), this.options[e4] = t4;
          } };
          Z(o2, function(e4) {
            if ("option" !== e4) throw U(e4);
            re2(o2, e4), x(";");
          }, function() {
            oe(o2);
          });
        }
        function H(e3, t3) {
          switch (e3) {
            case "max":
            case "MAX":
            case "Max":
              return 536870911;
            case "0":
              return 0;
          }
          if (!t3 && "-" === e3.charAt(0)) throw U(e3, "id");
          if (m.test(e3)) return parseInt(e3, 10);
          if (v.test(e3)) return parseInt(e3, 16);
          if (S.test(e3)) return parseInt(e3, 8);
          throw U(e3, "id");
        }
        function G() {
          if (void 0 !== R) throw U("package");
          if (R = D(), !_2.test(R)) throw U(R, "name");
          j = j.define(R), x(";");
        }
        function K() {
          var e3, t3 = F();
          switch (t3) {
            case "weak":
              e3 = O || (O = []), D();
              break;
            case "public":
              D();
            default:
              e3 = T || (T = []);
          }
          t3 = W(), x(";"), e3.push(t3);
        }
        function Y() {
          if (x("="), (B = W()) < 2023) throw U(B, "syntax");
          x(";");
        }
        function J() {
          if (x("="), B = W(), !["2023"].includes(B)) throw U(B, "edition");
          x(";");
        }
        function X(e3, t3) {
          switch (t3) {
            case "option":
              return re2(e3, t3), x(";"), true;
            case "message":
              return Q(e3, t3), true;
            case "enum":
              return te(e3, t3), true;
            case "service":
              return (function(e4, t4) {
                if (!C.test(t4 = D())) throw U(t4, "service name");
                var r3 = new u(t4);
                Z(r3, function(e5) {
                  if (!X(r3, e5)) {
                    if ("rpc" !== e5) throw U(e5);
                    !(function(e6, t5) {
                      var r4 = A(), n2 = t5;
                      if (!C.test(t5 = D())) throw U(t5, "name");
                      var i2, o2, s2, a2, l2 = t5;
                      if (x("("), x("stream", true) && (o2 = true), !_2.test(t5 = D())) throw U(t5);
                      if (i2 = t5, x(")"), x("returns"), x("("), x("stream", true) && (a2 = true), !_2.test(t5 = D())) throw U(t5);
                      s2 = t5, x(")");
                      var c2 = new d(l2, n2, i2, s2, o2, a2);
                      c2.comment = r4, Z(c2, function(e7) {
                        if ("option" !== e7) throw U(e7);
                        re2(c2, e7), x(";");
                      }), e6.add(c2);
                    })(r3, e5);
                  }
                }), e4.add(r3), e4 === j && L.push(r3);
              })(e3, t3), true;
            case "extend":
              return (function(e4, t4) {
                if (!_2.test(t4 = D())) throw U(t4, "reference");
                var r3 = t4;
                Z(null, function(t5) {
                  switch (t5) {
                    case "required":
                    case "repeated":
                      ee(e4, t5, r3);
                      break;
                    case "optional":
                      ee(e4, "proto3" === B ? "proto3_optional" : "optional", r3);
                      break;
                    default:
                      if ("proto2" === B || !_2.test(t5)) throw U(t5);
                      P(t5), ee(e4, "optional", r3);
                  }
                });
              })(e3, t3), true;
          }
          return false;
        }
        function Z(e3, t3, r3) {
          var n2 = k.line;
          if (e3 && ("string" != typeof e3.comment && (e3.comment = A()), e3.filename = E.filename), x("{", true)) {
            for (var i2; "}" !== (i2 = D()); ) t3(i2);
            x(";", true);
          } else r3 && r3(), x(";"), e3 && ("string" != typeof e3.comment || M) && (e3.comment = A(n2) || e3.comment);
        }
        function Q(e3, t3) {
          if (!C.test(t3 = D())) throw U(t3, "type name");
          var r3 = new o(t3);
          Z(r3, function(e4) {
            if (!X(r3, e4)) switch (e4) {
              case "map":
                !(function(e5) {
                  x("<");
                  var t4 = D();
                  if (void 0 === h.mapKey[t4]) throw U(t4, "type");
                  x(",");
                  var r4 = D();
                  if (!_2.test(r4)) throw U(r4, "type");
                  x(">");
                  var n2 = D();
                  if (!C.test(n2)) throw U(n2, "name");
                  x("=");
                  var i2 = new a(q(n2), H(D()), t4, r4);
                  Z(i2, function(e6) {
                    if ("option" !== e6) throw U(e6);
                    re2(i2, e6), x(";");
                  }, function() {
                    oe(i2);
                  }), e5.add(i2);
                })(r3);
                break;
              case "required":
                if ("proto2" !== B) throw U(e4);
              case "repeated":
                ee(r3, e4);
                break;
              case "optional":
                if ("proto3" === B) ee(r3, "proto3_optional");
                else {
                  if ("proto2" !== B) throw U(e4);
                  ee(r3, "optional");
                }
                break;
              case "oneof":
                !(function(e5, t4) {
                  if (!C.test(t4 = D())) throw U(t4, "name");
                  var r4 = new l(q(t4));
                  Z(r4, function(e6) {
                    "option" === e6 ? (re2(r4, e6), x(";")) : (P(e6), ee(r4, "optional"));
                  }), e5.add(r4);
                })(r3, e4);
                break;
              case "extensions":
                V(r3.extensions || (r3.extensions = []));
                break;
              case "reserved":
                V(r3.reserved || (r3.reserved = []), true);
                break;
              default:
                if ("proto2" === B || !_2.test(e4)) throw U(e4);
                P(e4), ee(r3, "optional");
            }
          }), e3.add(r3), e3 === j && L.push(r3);
        }
        function ee(e3, t3, r3) {
          var n2 = D();
          if ("group" !== n2) {
            for (; n2.endsWith(".") || F().startsWith("."); ) n2 += D();
            if (!_2.test(n2)) throw U(n2, "type");
            var i2 = D();
            if (!C.test(i2)) throw U(i2, "name");
            i2 = q(i2), x("=");
            var a2 = new s(i2, H(D()), n2, t3, r3);
            if (Z(a2, function(e4) {
              if ("option" !== e4) throw U(e4);
              re2(a2, e4), x(";");
            }, function() {
              oe(a2);
            }), "proto3_optional" === t3) {
              var c2 = new l("_" + i2);
              a2.setOption("proto3_optional", true), c2.add(a2), e3.add(c2);
            } else e3.add(a2);
            e3 === j && L.push(a2);
          } else !(function(e4, t4) {
            if (B >= 2023) throw U("group");
            var r4 = D();
            if (!C.test(r4)) throw U(r4, "name");
            var n3 = f.lcFirst(r4);
            r4 === n3 && (r4 = f.ucFirst(r4)), x("=");
            var i3 = H(D()), a3 = new o(r4);
            a3.group = true;
            var l2 = new s(n3, i3, r4, t4);
            l2.filename = E.filename, Z(a3, function(e5) {
              switch (e5) {
                case "option":
                  re2(a3, e5), x(";");
                  break;
                case "required":
                case "repeated":
                  ee(a3, e5);
                  break;
                case "optional":
                  ee(a3, "proto3" === B ? "proto3_optional" : "optional");
                  break;
                case "message":
                  Q(a3, e5);
                  break;
                case "enum":
                  te(a3, e5);
                  break;
                case "reserved":
                  V(a3.reserved || (a3.reserved = []), true);
                  break;
                default:
                  throw U(e5);
              }
            }), e4.add(a3).add(l2);
          })(e3, t3);
        }
        function te(e3, t3) {
          if (!C.test(t3 = D())) throw U(t3, "name");
          var r3 = new c(t3);
          Z(r3, function(e4) {
            switch (e4) {
              case "option":
                re2(r3, e4), x(";");
                break;
              case "reserved":
                V(r3.reserved || (r3.reserved = []), true), void 0 === r3.reserved && (r3.reserved = []);
                break;
              default:
                !(function(e5, t4) {
                  if (!C.test(t4)) throw U(t4, "name");
                  x("=");
                  var r4 = H(D(), true), n2 = { options: void 0, getOption: function(e6) {
                    return this.options[e6];
                  }, setOption: function(e6, t5) {
                    p.prototype.setOption.call(n2, e6, t5);
                  }, setParsedOption: function() {
                  } };
                  Z(n2, function(e6) {
                    if ("option" !== e6) throw U(e6);
                    re2(n2, e6), x(";");
                  }, function() {
                    oe(n2);
                  }), e5.add(t4, r4, n2.comment, n2.parsedOptions || n2.options);
                })(r3, e4);
            }
          }), e3.add(r3), e3 === j && L.push(r3);
        }
        function re2(e3, t3) {
          var r3, n2, i2 = true;
          for ("option" === t3 && (t3 = D()); "=" !== t3; ) {
            if ("(" === t3) {
              var o2 = D();
              x(")"), t3 = "(" + o2 + ")";
            }
            if (i2) {
              if (i2 = false, t3.includes(".") && !t3.includes("(")) {
                var s2 = t3.split(".");
                r3 = s2[0] + ".", t3 = s2[1];
                continue;
              }
              r3 = t3;
            } else n2 = n2 ? n2 += t3 : t3;
            t3 = D();
          }
          var a2 = ne(e3, n2 ? r3.concat(n2) : r3);
          n2 = n2 && "." === n2[0] ? n2.slice(1) : n2, (function(e4, t4, r4, n3) {
            e4.setParsedOption && e4.setParsedOption(t4, r4, n3);
          })(e3, r3 = r3 && "." === r3[r3.length - 1] ? r3.slice(0, -1) : r3, a2, n2);
        }
        function ne(e3, t3) {
          if (x("{", true)) {
            for (var r3 = {}; !x("}", true); ) {
              if (!C.test(I = D())) throw U(I, "name");
              if (null === I) throw U(I, "end of input");
              var n2, i2 = I;
              if (x(":", true), "{" === F()) n2 = ne(e3, t3 + "." + I);
              else if ("[" === F()) {
                var o2;
                if (n2 = [], x("[", true)) {
                  do {
                    o2 = $(), n2.push(o2);
                  } while (x(",", true));
                  x("]"), void 0 !== o2 && ie(e3, t3 + "." + I, o2);
                }
              } else n2 = $(), ie(e3, t3 + "." + I, n2);
              var s2 = r3[i2];
              s2 && (n2 = [].concat(s2).concat(n2)), r3[i2] = n2, x(",", true), x(";", true);
            }
            return r3;
          }
          var a2 = $();
          return ie(e3, t3, a2), a2;
        }
        function ie(e3, t3, r3) {
          j === e3 && /^features\./.test(t3) ? z[t3] = r3 : e3.setOption && e3.setOption(t3, r3);
        }
        function oe(e3) {
          if (x("[", true)) {
            do {
              re2(e3, "option");
            } while (x(",", true));
            x("]");
          }
          return e3;
        }
        for (; null !== (I = D()); ) switch (I) {
          case "package":
            if (!N) throw U(I);
            G();
            break;
          case "import":
            if (!N) throw U(I);
            K();
            break;
          case "syntax":
            if (!N) throw U(I);
            Y();
            break;
          case "edition":
            if (!N) throw U(I);
            J();
            break;
          case "option":
            re2(j, I), x(";", true);
            break;
          default:
            if (X(j, I)) {
              N = false;
              continue;
            }
            throw U(I);
        }
        return L.forEach((e3) => {
          e3._edition = B, Object.keys(z).forEach((t3) => {
            void 0 === e3.getOption(t3) && e3.setOption(t3, z[t3], true);
          });
        }), E.filename = null, { package: R, imports: T, weakImports: O, root: t2 };
      }
    }, 4341: (e, t, r) => {
      e.exports = s;
      var n = r(4243);
      ((s.prototype = Object.create(n.prototype)).constructor = s).className = "MapField";
      var i = r(5594), o = r(8723);
      function s(e2, t2, r2, i2, s2, a) {
        if (n.call(this, e2, t2, i2, void 0, void 0, s2, a), !o.isString(r2)) throw TypeError("keyType must be a string");
        this.keyType = r2, this.resolvedKeyType = null, this.map = true;
      }
      s.fromJSON = function(e2, t2) {
        return new s(e2, t2.id, t2.keyType, t2.type, t2.options, t2.comment);
      }, s.prototype.toJSON = function(e2) {
        var t2 = !!e2 && Boolean(e2.keepComments);
        return o.toObject(["keyType", this.keyType, "type", this.type, "id", this.id, "extend", this.extend, "options", this.options, "comment", t2 ? this.comment : void 0]);
      }, s.prototype.resolve = function() {
        if (this.resolved) return this;
        if (void 0 === i.mapKey[this.keyType]) throw Error("invalid key type: " + this.keyType);
        return n.prototype.resolve.call(this);
      }, s.d = function(e2, t2, r2) {
        return "function" == typeof r2 ? r2 = o.decorateType(r2).name : r2 && "object" == typeof r2 && (r2 = o.decorateEnum(r2).name), function(n2, i2) {
          o.decorateType(n2.constructor).add(new s(i2, e2, t2, r2));
        };
      };
    }, 4398: (e, t, r) => {
      var n, i, o, s;
      Object.defineProperty(t, "__esModule", { value: true }), t.isTracerEnabled = t.trace = t.log = t.setLoggerVerbosity = t.setLogger = t.getLogger = void 0;
      const a = r(6754), l = r(932), c = r(7126).rE;
      let u = { error: (e2, ...t2) => {
        console.error("E " + e2, ...t2);
      }, info: (e2, ...t2) => {
        console.error("I " + e2, ...t2);
      }, debug: (e2, ...t2) => {
        console.error("D " + e2, ...t2);
      } }, d = a.LogVerbosity.ERROR;
      switch ((null !== (i = null !== (n = define_process_env_default.GRPC_NODE_VERBOSITY) && void 0 !== n ? n : define_process_env_default.GRPC_VERBOSITY) && void 0 !== i ? i : "").toUpperCase()) {
        case "DEBUG":
          d = a.LogVerbosity.DEBUG;
          break;
        case "INFO":
          d = a.LogVerbosity.INFO;
          break;
        case "ERROR":
          d = a.LogVerbosity.ERROR;
          break;
        case "NONE":
          d = a.LogVerbosity.NONE;
      }
      t.getLogger = () => u, t.setLogger = (e2) => {
        u = e2;
      }, t.setLoggerVerbosity = (e2) => {
        d = e2;
      }, t.log = (e2, ...t2) => {
        let r2;
        if (e2 >= d) {
          switch (e2) {
            case a.LogVerbosity.DEBUG:
              r2 = u.debug;
              break;
            case a.LogVerbosity.INFO:
              r2 = u.info;
              break;
            case a.LogVerbosity.ERROR:
              r2 = u.error;
          }
          r2 || (r2 = u.error), r2 && r2.bind(u)(...t2);
        }
      };
      const p = null !== (s = null !== (o = define_process_env_default.GRPC_NODE_TRACE) && void 0 !== o ? o : define_process_env_default.GRPC_TRACE) && void 0 !== s ? s : "", h = /* @__PURE__ */ new Set(), f = /* @__PURE__ */ new Set();
      for (const e2 of p.split(",")) e2.startsWith("-") ? f.add(e2.substring(1)) : h.add(e2);
      const g = h.has("all");
      function m(e2) {
        return !f.has(e2) && (g || h.has(e2));
      }
      t.trace = function(e2, r2, n2) {
        m(r2) && (0, t.log)(e2, (/* @__PURE__ */ new Date()).toISOString() + " | v" + c + " " + l.pid + " | " + r2 + " | " + n2);
      }, t.isTracerEnabled = m;
    }, 4434: (e) => {
      e.exports = require$$1;
    }, 4455: (e, t, r) => {
      e.exports = function(e2) {
        for (var t2 = o.codegen(["r", "l", "e"], e2.name + "$decode")("if(!(r instanceof Reader))")("r=Reader.create(r)")("var c=l===undefined?r.len:r.pos+l,m=new this.ctor" + (e2.fieldsArray.filter(function(e3) {
          return e3.map;
        }).length ? ",k,value" : ""))("while(r.pos<c){")("var t=r.uint32()")("if(t===e)")("break")("switch(t>>>3){"), r2 = 0; r2 < e2.fieldsArray.length; ++r2) {
          var a = e2._fieldsArray[r2].resolve(), l = a.resolvedType instanceof n ? "int32" : a.type, c = "m" + o.safeProp(a.name);
          t2("case %i: {", a.id), a.map ? (t2("if(%s===util.emptyObject)", c)("%s={}", c)("var c2 = r.uint32()+r.pos"), void 0 !== i.defaults[a.keyType] ? t2("k=%j", i.defaults[a.keyType]) : t2("k=null"), void 0 !== i.defaults[l] ? t2("value=%j", i.defaults[l]) : t2("value=null"), t2("while(r.pos<c2){")("var tag2=r.uint32()")("switch(tag2>>>3){")("case 1: k=r.%s(); break", a.keyType)("case 2:"), void 0 === i.basic[l] ? t2("value=types[%i].decode(r,r.uint32())", r2) : t2("value=r.%s()", l), t2("break")("default:")("r.skipType(tag2&7)")("break")("}")("}"), void 0 !== i.long[a.keyType] ? t2('%s[typeof k==="object"?util.longToHash(k):k]=value', c) : t2("%s[k]=value", c)) : a.repeated ? (t2("if(!(%s&&%s.length))", c, c)("%s=[]", c), void 0 !== i.packed[l] && t2("if((t&7)===2){")("var c2=r.uint32()+r.pos")("while(r.pos<c2)")("%s.push(r.%s())", c, l)("}else"), void 0 === i.basic[l] ? t2(a.delimited ? "%s.push(types[%i].decode(r,undefined,((t&~7)|4)))" : "%s.push(types[%i].decode(r,r.uint32()))", c, r2) : t2("%s.push(r.%s())", c, l)) : void 0 === i.basic[l] ? t2(a.delimited ? "%s=types[%i].decode(r,undefined,((t&~7)|4))" : "%s=types[%i].decode(r,r.uint32())", c, r2) : t2("%s=r.%s()", c, l), t2("break")("}");
        }
        for (t2("default:")("r.skipType(t&7)")("break")("}")("}"), r2 = 0; r2 < e2._fieldsArray.length; ++r2) {
          var u = e2._fieldsArray[r2];
          u.required && t2("if(!m.hasOwnProperty(%j))", u.name)("throw util.ProtocolError(%j,{instance:m})", s(u));
        }
        return t2("return m");
      };
      var n = r(8118), i = r(5594), o = r(8723);
      function s(e2) {
        return "missing required '" + e2.name + "'";
      }
    }, 4489: (e, t, r) => {
      const n = r(9896), i = r(230);
      e.exports = function(e2) {
        const t2 = Buffer.alloc(150);
        let r2;
        try {
          r2 = n.openSync(e2, "r"), n.readSync(r2, t2, 0, 150, 0), n.closeSync(r2);
        } catch (e3) {
        }
        return i(t2.toString());
      };
    }, 4644: (e, t, r) => {
      const n = r(2911), i = r(1173);
      e.exports = function(e2) {
        const t2 = e2.protocol || void 0;
        if (t2 && "http" !== t2) throw new i("'protocol' can be nothing or http");
        const r2 = e2.port;
        if (!r2) throw new i("'port' is required.");
        if (!Number.isInteger(r2)) throw new i("'port' must be a number.");
        if (r2 < 1) throw new i("'port' must be greater than 0.");
        if (r2 > 65535) throw new i("'port' must not be greater than 65535.");
        const o = e2.host || "localhost", s = e2.path || ("http" === t2 ? "/" : void 0), a = e2.interval || 1e3;
        if (!Number.isInteger(a)) throw new i("'interval' must be a number.");
        if (a < 0) throw new i("'interval' must be greater or equal to 0.");
        const l = e2.timeout || 0;
        if (!Number.isInteger(l)) throw new i("'timeout' must be a number.");
        if (l < 0) throw new i("'timeout' must be greater or equal to 0.");
        const c = e2.waitForDns || false;
        if ("boolean" != typeof c) throw new i("'wait-for-dns' must be a boolean.");
        const u = e2.output || "dots";
        if (!n[u]) {
          const e3 = Object.keys(n).join(", ");
          throw new i(`'output' must be in the set ${e3}`);
        }
        return { protocol: t2, port: r2, host: o, path: s, interval: a, timeout: l, output: u, waitForDns: c };
      };
    }, 4652: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.FileWatcherCertificateProvider = void 0;
      const n = r(9896), i = r(4398), o = r(6754);
      function s(e2) {
        i.trace(o.LogVerbosity.DEBUG, "certificate_provider", e2);
      }
      const a = (0, r(9023).promisify)(n.readFile);
      t.FileWatcherCertificateProvider = class {
        constructor(e2) {
          if (this.config = e2, this.refreshTimer = null, this.fileResultPromise = null, this.latestCaUpdate = null, this.caListeners = /* @__PURE__ */ new Set(), this.latestIdentityUpdate = null, this.identityListeners = /* @__PURE__ */ new Set(), this.lastUpdateTime = null, void 0 === e2.certificateFile != (void 0 === e2.privateKeyFile)) throw new Error("certificateFile and privateKeyFile must be set or unset together");
          if (void 0 === e2.certificateFile && void 0 === e2.caCertificateFile) throw new Error("At least one of certificateFile and caCertificateFile must be set");
          s("File watcher constructed with config " + JSON.stringify(e2));
        }
        updateCertificates() {
          this.fileResultPromise || (this.fileResultPromise = Promise.allSettled([this.config.certificateFile ? a(this.config.certificateFile) : Promise.reject(), this.config.privateKeyFile ? a(this.config.privateKeyFile) : Promise.reject(), this.config.caCertificateFile ? a(this.config.caCertificateFile) : Promise.reject()]), this.fileResultPromise.then(([e2, t2, r2]) => {
            if (this.refreshTimer) {
              s("File watcher read certificates certificate" + (e2 ? "!=" : "==") + "null, privateKey" + (t2 ? "!=" : "==") + "null, CA certificate" + (r2 ? "!=" : "==") + "null"), this.lastUpdateTime = /* @__PURE__ */ new Date(), this.fileResultPromise = null, "fulfilled" === e2.status && "fulfilled" === t2.status ? this.latestIdentityUpdate = { certificate: e2.value, privateKey: t2.value } : this.latestIdentityUpdate = null, "fulfilled" === r2.status && (this.latestCaUpdate = { caCertificate: r2.value });
              for (const e3 of this.identityListeners) e3(this.latestIdentityUpdate);
              for (const e3 of this.caListeners) e3(this.latestCaUpdate);
            }
          }), s("File watcher initiated certificate update"));
        }
        maybeStartWatchingFiles() {
          if (!this.refreshTimer) {
            const e2 = this.lastUpdateTime ? (/* @__PURE__ */ new Date()).getTime() - this.lastUpdateTime.getTime() : 1 / 0;
            e2 > this.config.refreshIntervalMs && this.updateCertificates(), e2 > 2 * this.config.refreshIntervalMs && (this.latestCaUpdate = null, this.latestIdentityUpdate = null), this.refreshTimer = setInterval(() => this.updateCertificates(), this.config.refreshIntervalMs), s("File watcher started watching");
          }
        }
        maybeStopWatchingFiles() {
          0 === this.caListeners.size && 0 === this.identityListeners.size && (this.fileResultPromise = null, this.refreshTimer && (clearInterval(this.refreshTimer), this.refreshTimer = null));
        }
        addCaCertificateListener(e2) {
          this.caListeners.add(e2), this.maybeStartWatchingFiles(), process.nextTick(e2, this.latestCaUpdate);
        }
        removeCaCertificateListener(e2) {
          this.caListeners.delete(e2), this.maybeStopWatchingFiles();
        }
        addIdentityCertificateListener(e2) {
          this.identityListeners.add(e2), this.maybeStartWatchingFiles(), process.nextTick(e2, this.latestIdentityUpdate);
        }
        removeIdentityCertificateListener(e2) {
          this.identityListeners.delete(e2), this.maybeStopWatchingFiles();
        }
      };
    }, 4714: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.setup = void 0;
      const n = r(4169);
      class i {
        constructor(e2, t2, r2) {
          let n2;
          this.listener = t2, this.hasReturnedResult = false, this.endpoints = [], n2 = "" === e2.authority ? "/" + e2.path : e2.path, this.endpoints = [{ addresses: [{ path: n2 }] }];
        }
        updateResolution() {
          this.hasReturnedResult || (this.hasReturnedResult = true, process.nextTick(this.listener.onSuccessfulResolution, this.endpoints, null, null, null, {}));
        }
        destroy() {
          this.hasReturnedResult = false;
        }
        static getDefaultAuthority(e2) {
          return "localhost";
        }
      }
      t.setup = function() {
        (0, n.registerResolver)("unix", i);
      };
    }, 4738: (e) => {
      e.exports = {};
    }, 4756: (e) => {
      e.exports = require$$12;
    }, 4808: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.restrictControlPlaneStatusCode = void 0;
      const n = r(6754), i = [n.Status.OK, n.Status.INVALID_ARGUMENT, n.Status.NOT_FOUND, n.Status.ALREADY_EXISTS, n.Status.FAILED_PRECONDITION, n.Status.ABORTED, n.Status.OUT_OF_RANGE, n.Status.DATA_LOSS];
      t.restrictControlPlaneStatusCode = function(e2, t2) {
        return i.includes(e2) ? { code: n.Status.INTERNAL, details: `Invalid status from control plane: ${e2} ${n.Status[e2]} ${t2}` } : { code: e2, details: t2 };
      };
    }, 4865: (e) => {
      e.exports = { mapHttpRequest: function(e2) {
        return { req: n(e2) };
      }, reqSerializer: n };
      const t = Symbol("pino-raw-req-ref"), r = Object.create({}, { id: { enumerable: true, writable: true, value: "" }, method: { enumerable: true, writable: true, value: "" }, url: { enumerable: true, writable: true, value: "" }, query: { enumerable: true, writable: true, value: "" }, params: { enumerable: true, writable: true, value: "" }, headers: { enumerable: true, writable: true, value: {} }, remoteAddress: { enumerable: true, writable: true, value: "" }, remotePort: { enumerable: true, writable: true, value: "" }, raw: { enumerable: false, get: function() {
        return this[t];
      }, set: function(e2) {
        this[t] = e2;
      } } });
      function n(e2) {
        const t2 = e2.info || e2.socket, n2 = Object.create(r);
        if (n2.id = "function" == typeof e2.id ? e2.id() : e2.id || (e2.info ? e2.info.id : void 0), n2.method = e2.method, e2.originalUrl) n2.url = e2.originalUrl;
        else {
          const t3 = e2.path;
          n2.url = "string" == typeof t3 ? t3 : e2.url ? e2.url.path || e2.url : void 0;
        }
        return e2.query && (n2.query = e2.query), e2.params && (n2.params = e2.params), n2.headers = e2.headers, n2.remoteAddress = t2 && t2.remoteAddress, n2.remotePort = t2 && t2.remotePort, n2.raw = e2.raw || e2, n2;
      }
      Object.defineProperty(r, t, { writable: true, value: {} });
    }, 5038: (e, t, r) => {
      const n = r(2018), i = r(9023);
      t.init = function(e2) {
        e2.inspectOpts = {};
        const r2 = Object.keys(t.inspectOpts);
        for (let n2 = 0; n2 < r2.length; n2++) e2.inspectOpts[r2[n2]] = t.inspectOpts[r2[n2]];
      }, t.log = function(...e2) {
        return process.stderr.write(i.formatWithOptions(t.inspectOpts, ...e2) + "\n");
      }, t.formatArgs = function(r2) {
        const { namespace: n2, useColors: i2 } = this;
        if (i2) {
          const t2 = this.color, i3 = "\x1B[3" + (t2 < 8 ? t2 : "8;5;" + t2), o2 = `  ${i3};1m${n2} \x1B[0m`;
          r2[0] = o2 + r2[0].split("\n").join("\n" + o2), r2.push(i3 + "m+" + e.exports.humanize(this.diff) + "\x1B[0m");
        } else r2[0] = (t.inspectOpts.hideDate ? "" : (/* @__PURE__ */ new Date()).toISOString() + " ") + n2 + " " + r2[0];
      }, t.save = function(e2) {
        e2 ? define_process_env_default.DEBUG = e2 : delete define_process_env_default.DEBUG;
      }, t.load = function() {
        return define_process_env_default.DEBUG;
      }, t.useColors = function() {
        return "colors" in t.inspectOpts ? Boolean(t.inspectOpts.colors) : n.isatty(process.stderr.fd);
      }, t.destroy = i.deprecate(() => {
      }, "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."), t.colors = [6, 2, 3, 4, 5, 1];
      try {
        const e2 = r(5600);
        e2 && (e2.stderr || e2).level >= 2 && (t.colors = [20, 21, 26, 27, 32, 33, 38, 39, 40, 41, 42, 43, 44, 45, 56, 57, 62, 63, 68, 69, 74, 75, 76, 77, 78, 79, 80, 81, 92, 93, 98, 99, 112, 113, 128, 129, 134, 135, 148, 149, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 178, 179, 184, 185, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 214, 215, 220, 221]);
      } catch (e2) {
      }
      t.inspectOpts = Object.keys(define_process_env_default).filter((e2) => /^debug_/i.test(e2)).reduce((e2, t2) => {
        const r2 = t2.substring(6).toLowerCase().replace(/_([a-z])/g, (e3, t3) => t3.toUpperCase());
        let n2 = define_process_env_default[t2];
        return n2 = !!/^(yes|on|true|enabled)$/i.test(n2) || !/^(no|off|false|disabled)$/i.test(n2) && ("null" === n2 ? null : Number(n2)), e2[r2] = n2, e2;
      }, {}), e.exports = r(7891)(t);
      const { formatters: o } = e.exports;
      o.o = function(e2) {
        return this.inspectOpts.colors = this.useColors, i.inspect(e2, this.inspectOpts).split("\n").map((e3) => e3.trim()).join(" ");
      }, o.O = function(e2) {
        return this.inspectOpts.colors = this.useColors, i.inspect(e2, this.inspectOpts);
      };
    }, 5085: (e, t, r) => {
      e.exports = function e2(t2) {
        if (!n(t2)) return t2;
        t2[s] = void 0;
        const r2 = Object.create(i);
        r2.type = "[object Function]" === a.call(t2.constructor) ? t2.constructor.name : t2.name, r2.message = t2.message, r2.stack = t2.stack, Array.isArray(t2.errors) && (r2.aggregateErrors = t2.errors.map((t3) => e2(t3))), n(t2.cause) && !Object.prototype.hasOwnProperty.call(t2.cause, s) && (r2.cause = e2(t2.cause));
        for (const i2 in t2) if (void 0 === r2[i2]) {
          const o2 = t2[i2];
          n(o2) ? Object.prototype.hasOwnProperty.call(o2, s) || (r2[i2] = e2(o2)) : r2[i2] = o2;
        }
        return delete t2[s], r2.raw = t2, r2;
      };
      const { isErrorLike: n } = r(6014), { pinoErrProto: i, pinoErrorSymbols: o } = r(9565), { seen: s } = o, { toString: a } = Object.prototype;
    }, 5099: function(e, t, r) {
      var n = t;
      function i(e2, t2, r2) {
        for (var n2 = Object.keys(t2), i2 = 0; i2 < n2.length; ++i2) void 0 !== e2[n2[i2]] && r2 || (e2[n2[i2]] = t2[n2[i2]]);
        return e2;
      }
      function o(e2) {
        function t2(e3, r2) {
          if (!(this instanceof t2)) return new t2(e3, r2);
          Object.defineProperty(this, "message", { get: function() {
            return e3;
          } }), Error.captureStackTrace ? Error.captureStackTrace(this, t2) : Object.defineProperty(this, "stack", { value: new Error().stack || "" }), r2 && i(this, r2);
        }
        return t2.prototype = Object.create(Error.prototype, { constructor: { value: t2, writable: true, enumerable: false, configurable: true }, name: { get: function() {
          return e2;
        }, set: void 0, enumerable: false, configurable: true }, toString: { value: function() {
          return this.name + ": " + this.message;
        }, writable: true, enumerable: false, configurable: true } }), t2;
      }
      n.asPromise = r(3808), n.base64 = r(3320), n.EventEmitter = r(2149), n.float = r(1727), n.inquire = r(3768), n.utf8 = r(5184), n.pool = r(2461), n.LongBits = r(5904), n.isNode = Boolean("undefined" != typeof commonjsGlobal && commonjsGlobal && commonjsGlobal.process && commonjsGlobal.process.versions && commonjsGlobal.process.versions.node), n.global = n.isNode && commonjsGlobal || "undefined" != typeof window && window || "undefined" != typeof self && self || this, n.emptyArray = Object.freeze ? Object.freeze([]) : [], n.emptyObject = Object.freeze ? Object.freeze({}) : {}, n.isInteger = Number.isInteger || function(e2) {
        return "number" == typeof e2 && isFinite(e2) && Math.floor(e2) === e2;
      }, n.isString = function(e2) {
        return "string" == typeof e2 || e2 instanceof String;
      }, n.isObject = function(e2) {
        return e2 && "object" == typeof e2;
      }, n.isset = n.isSet = function(e2, t2) {
        var r2 = e2[t2];
        return !(null == r2 || !e2.hasOwnProperty(t2)) && ("object" != typeof r2 || (Array.isArray(r2) ? r2.length : Object.keys(r2).length) > 0);
      }, n.Buffer = (function() {
        try {
          var e2 = n.inquire("buffer").Buffer;
          return e2.prototype.utf8Write ? e2 : null;
        } catch (e3) {
          return null;
        }
      })(), n._Buffer_from = null, n._Buffer_allocUnsafe = null, n.newBuffer = function(e2) {
        return "number" == typeof e2 ? n.Buffer ? n._Buffer_allocUnsafe(e2) : new n.Array(e2) : n.Buffer ? n._Buffer_from(e2) : "undefined" == typeof Uint8Array ? e2 : new Uint8Array(e2);
      }, n.Array = "undefined" != typeof Uint8Array ? Uint8Array : Array, n.Long = n.global.dcodeIO && n.global.dcodeIO.Long || n.global.Long || n.inquire("long"), n.key2Re = /^true|false|0|1$/, n.key32Re = /^-?(?:0|[1-9][0-9]*)$/, n.key64Re = /^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/, n.longToHash = function(e2) {
        return e2 ? n.LongBits.from(e2).toHash() : n.LongBits.zeroHash;
      }, n.longFromHash = function(e2, t2) {
        var r2 = n.LongBits.fromHash(e2);
        return n.Long ? n.Long.fromBits(r2.lo, r2.hi, t2) : r2.toNumber(Boolean(t2));
      }, n.merge = i, n.lcFirst = function(e2) {
        return e2.charAt(0).toLowerCase() + e2.substring(1);
      }, n.newError = o, n.ProtocolError = o("ProtocolError"), n.oneOfGetter = function(e2) {
        for (var t2 = {}, r2 = 0; r2 < e2.length; ++r2) t2[e2[r2]] = 1;
        return function() {
          for (var e3 = Object.keys(this), r3 = e3.length - 1; r3 > -1; --r3) if (1 === t2[e3[r3]] && void 0 !== this[e3[r3]] && null !== this[e3[r3]]) return e3[r3];
        };
      }, n.oneOfSetter = function(e2) {
        return function(t2) {
          for (var r2 = 0; r2 < e2.length; ++r2) e2[r2] !== t2 && delete this[e2[r2]];
        };
      }, n.toJSONOptions = { longs: String, enums: String, bytes: String, json: true }, n._configure = function() {
        var e2 = n.Buffer;
        e2 ? (n._Buffer_from = e2.from !== Uint8Array.from && e2.from || function(t2, r2) {
          return new e2(t2, r2);
        }, n._Buffer_allocUnsafe = e2.allocUnsafe || function(t2) {
          return new e2(t2);
        }) : n._Buffer_from = n._Buffer_allocUnsafe = null;
      };
    }, 5129: (e, t) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.uriToString = t.combineHostPort = t.splitHostPort = t.parseUri = void 0;
      const r = /^(?:([A-Za-z0-9+.-]+):)?(?:\/\/([^/]*)\/)?(.+)$/;
      t.parseUri = function(e2) {
        const t2 = r.exec(e2);
        return null === t2 ? null : { scheme: t2[1], authority: t2[2], path: t2[3] };
      };
      const n = /^\d+$/;
      t.splitHostPort = function(e2) {
        if (e2.startsWith("[")) {
          const t2 = e2.indexOf("]");
          if (-1 === t2) return null;
          const r2 = e2.substring(1, t2);
          if (-1 === r2.indexOf(":")) return null;
          if (e2.length > t2 + 1) {
            if (":" === e2[t2 + 1]) {
              const i = e2.substring(t2 + 2);
              return n.test(i) ? { host: r2, port: +i } : null;
            }
            return null;
          }
          return { host: r2 };
        }
        {
          const t2 = e2.split(":");
          return 2 === t2.length ? n.test(t2[1]) ? { host: t2[0], port: +t2[1] } : null : { host: e2 };
        }
      }, t.combineHostPort = function(e2) {
        return void 0 === e2.port ? e2.host : e2.host.includes(":") ? `[${e2.host}]:${e2.port}` : `${e2.host}:${e2.port}`;
      }, t.uriToString = function(e2) {
        let t2 = "";
        return void 0 !== e2.scheme && (t2 += e2.scheme + ":"), void 0 !== e2.authority && (t2 += "//" + e2.authority + "/"), t2 += e2.path, t2;
      };
    }, 5172: (e, t) => {
      var r;
      Object.defineProperty(t, "__esModule", { value: true }), t.ConnectivityState = void 0, (function(e2) {
        e2[e2.IDLE = 0] = "IDLE", e2[e2.CONNECTING = 1] = "CONNECTING", e2[e2.READY = 2] = "READY", e2[e2.TRANSIENT_FAILURE = 3] = "TRANSIENT_FAILURE", e2[e2.SHUTDOWN = 4] = "SHUTDOWN";
      })(r || (t.ConnectivityState = r = {}));
    }, 5179: (e) => {
      e.exports = { stringReplaceAll: (e2, t, r) => {
        let n = e2.indexOf(t);
        if (-1 === n) return e2;
        const i = t.length;
        let o = 0, s = "";
        do {
          s += e2.substr(o, n - o) + t + r, o = n + i, n = e2.indexOf(t, o);
        } while (-1 !== n);
        return s += e2.substr(o), s;
      }, stringEncaseCRLFWithFirstIndex: (e2, t, r, n) => {
        let i = 0, o = "";
        do {
          const s = "\r" === e2[n - 1];
          o += e2.substr(i, (s ? n - 1 : n) - i) + t + (s ? "\r\n" : "\n") + r, i = n + 1, n = e2.indexOf("\n", i);
        } while (-1 !== n);
        return o += e2.substr(i), o;
      } };
    }, 5184: (e, t) => {
      var r = t;
      r.length = function(e2) {
        for (var t2 = 0, r2 = 0, n = 0; n < e2.length; ++n) (r2 = e2.charCodeAt(n)) < 128 ? t2 += 1 : r2 < 2048 ? t2 += 2 : 55296 == (64512 & r2) && 56320 == (64512 & e2.charCodeAt(n + 1)) ? (++n, t2 += 4) : t2 += 3;
        return t2;
      }, r.read = function(e2, t2, r2) {
        if (r2 - t2 < 1) return "";
        for (var n, i = null, o = [], s = 0; t2 < r2; ) (n = e2[t2++]) < 128 ? o[s++] = n : n > 191 && n < 224 ? o[s++] = (31 & n) << 6 | 63 & e2[t2++] : n > 239 && n < 365 ? (n = ((7 & n) << 18 | (63 & e2[t2++]) << 12 | (63 & e2[t2++]) << 6 | 63 & e2[t2++]) - 65536, o[s++] = 55296 + (n >> 10), o[s++] = 56320 + (1023 & n)) : o[s++] = (15 & n) << 12 | (63 & e2[t2++]) << 6 | 63 & e2[t2++], s > 8191 && ((i || (i = [])).push(String.fromCharCode.apply(String, o)), s = 0);
        return i ? (s && i.push(String.fromCharCode.apply(String, o.slice(0, s))), i.join("")) : String.fromCharCode.apply(String, o.slice(0, s));
      }, r.write = function(e2, t2, r2) {
        for (var n, i, o = r2, s = 0; s < e2.length; ++s) (n = e2.charCodeAt(s)) < 128 ? t2[r2++] = n : n < 2048 ? (t2[r2++] = n >> 6 | 192, t2[r2++] = 63 & n | 128) : 55296 == (64512 & n) && 56320 == (64512 & (i = e2.charCodeAt(s + 1))) ? (n = 65536 + ((1023 & n) << 10) + (1023 & i), ++s, t2[r2++] = n >> 18 | 240, t2[r2++] = n >> 12 & 63 | 128, t2[r2++] = n >> 6 & 63 | 128, t2[r2++] = 63 & n | 128) : (t2[r2++] = n >> 12 | 224, t2[r2++] = n >> 6 & 63 | 128, t2[r2++] = 63 & n | 128);
        return r2 - o;
      };
    }, 5298: (e, t, r) => {
      e.exports = r(1672);
    }, 5317: (e) => {
      e.exports = child_process;
    }, 5350: function(e, t) {
      var r;
      r = function() {
        var e2 = {};
        return (function(e3) {
          Object.defineProperty(e3, "__esModule", { value: true }), e3.default = void 0;
          var t2 = null;
          try {
            t2 = new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0, 1, 13, 2, 96, 0, 1, 127, 96, 4, 127, 127, 127, 127, 1, 127, 3, 7, 6, 0, 1, 1, 1, 1, 1, 6, 6, 1, 127, 1, 65, 0, 11, 7, 50, 6, 3, 109, 117, 108, 0, 1, 5, 100, 105, 118, 95, 115, 0, 2, 5, 100, 105, 118, 95, 117, 0, 3, 5, 114, 101, 109, 95, 115, 0, 4, 5, 114, 101, 109, 95, 117, 0, 5, 8, 103, 101, 116, 95, 104, 105, 103, 104, 0, 0, 10, 191, 1, 6, 4, 0, 35, 0, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 126, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 127, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 128, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 129, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11, 36, 1, 1, 126, 32, 0, 173, 32, 1, 173, 66, 32, 134, 132, 32, 2, 173, 32, 3, 173, 66, 32, 134, 132, 130, 34, 4, 66, 32, 135, 167, 36, 0, 32, 4, 167, 11])), {}).exports;
          } catch {
          }
          function r2(e4, t3, r3) {
            this.low = 0 | e4, this.high = 0 | t3, this.unsigned = !!r3;
          }
          function n(e4) {
            return true === (e4 && e4.__isLong__);
          }
          function i(e4) {
            var t3 = Math.clz32(e4 & -e4);
            return e4 ? 31 - t3 : t3;
          }
          r2.prototype.__isLong__, Object.defineProperty(r2.prototype, "__isLong__", { value: true }), r2.isLong = n;
          var o = {}, s = {};
          function a(e4, t3) {
            var r3, n2, i2;
            return t3 ? (i2 = 0 <= (e4 >>>= 0) && e4 < 256) && (n2 = s[e4]) ? n2 : (r3 = c(e4, 0, true), i2 && (s[e4] = r3), r3) : (i2 = -128 <= (e4 |= 0) && e4 < 128) && (n2 = o[e4]) ? n2 : (r3 = c(e4, e4 < 0 ? -1 : 0, false), i2 && (o[e4] = r3), r3);
          }
          function l(e4, t3) {
            if (isNaN(e4)) return t3 ? v : y;
            if (t3) {
              if (e4 < 0) return v;
              if (e4 >= f) return _2;
            } else {
              if (e4 <= -g) return E;
              if (e4 + 1 >= g) return C;
            }
            return e4 < 0 ? l(-e4, t3).neg() : c(e4 % h | 0, e4 / h | 0, t3);
          }
          function c(e4, t3, n2) {
            return new r2(e4, t3, n2);
          }
          r2.fromInt = a, r2.fromNumber = l, r2.fromBits = c;
          var u = Math.pow;
          function d(e4, t3, r3) {
            if (0 === e4.length) throw Error("empty string");
            if ("number" == typeof t3 ? (r3 = t3, t3 = false) : t3 = !!t3, "NaN" === e4 || "Infinity" === e4 || "+Infinity" === e4 || "-Infinity" === e4) return t3 ? v : y;
            if ((r3 = r3 || 10) < 2 || 36 < r3) throw RangeError("radix");
            var n2;
            if ((n2 = e4.indexOf("-")) > 0) throw Error("interior hyphen");
            if (0 === n2) return d(e4.substring(1), t3, r3).neg();
            for (var i2 = l(u(r3, 8)), o2 = y, s2 = 0; s2 < e4.length; s2 += 8) {
              var a2 = Math.min(8, e4.length - s2), c2 = parseInt(e4.substring(s2, s2 + a2), r3);
              if (a2 < 8) {
                var p2 = l(u(r3, a2));
                o2 = o2.mul(p2).add(l(c2));
              } else o2 = (o2 = o2.mul(i2)).add(l(c2));
            }
            return o2.unsigned = t3, o2;
          }
          function p(e4, t3) {
            return "number" == typeof e4 ? l(e4, t3) : "string" == typeof e4 ? d(e4, t3) : c(e4.low, e4.high, "boolean" == typeof t3 ? t3 : e4.unsigned);
          }
          r2.fromString = d, r2.fromValue = p;
          var h = 4294967296, f = h * h, g = f / 2, m = a(1 << 24), y = a(0);
          r2.ZERO = y;
          var v = a(0, true);
          r2.UZERO = v;
          var b = a(1);
          r2.ONE = b;
          var S = a(1, true);
          r2.UONE = S;
          var w = a(-1);
          r2.NEG_ONE = w;
          var C = c(-1, 2147483647, false);
          r2.MAX_VALUE = C;
          var _2 = c(-1, -1, true);
          r2.MAX_UNSIGNED_VALUE = _2;
          var E = c(0, -2147483648, false);
          r2.MIN_VALUE = E;
          var R = r2.prototype;
          R.toInt = function() {
            return this.unsigned ? this.low >>> 0 : this.low;
          }, R.toNumber = function() {
            return this.unsigned ? (this.high >>> 0) * h + (this.low >>> 0) : this.high * h + (this.low >>> 0);
          }, R.toString = function(e4) {
            if ((e4 = e4 || 10) < 2 || 36 < e4) throw RangeError("radix");
            if (this.isZero()) return "0";
            if (this.isNegative()) {
              if (this.eq(E)) {
                var t3 = l(e4), r3 = this.div(t3), n2 = r3.mul(t3).sub(this);
                return r3.toString(e4) + n2.toInt().toString(e4);
              }
              return "-" + this.neg().toString(e4);
            }
            for (var i2 = l(u(e4, 6), this.unsigned), o2 = this, s2 = ""; ; ) {
              var a2 = o2.div(i2), c2 = (o2.sub(a2.mul(i2)).toInt() >>> 0).toString(e4);
              if ((o2 = a2).isZero()) return c2 + s2;
              for (; c2.length < 6; ) c2 = "0" + c2;
              s2 = "" + c2 + s2;
            }
          }, R.getHighBits = function() {
            return this.high;
          }, R.getHighBitsUnsigned = function() {
            return this.high >>> 0;
          }, R.getLowBits = function() {
            return this.low;
          }, R.getLowBitsUnsigned = function() {
            return this.low >>> 0;
          }, R.getNumBitsAbs = function() {
            if (this.isNegative()) return this.eq(E) ? 64 : this.neg().getNumBitsAbs();
            for (var e4 = 0 != this.high ? this.high : this.low, t3 = 31; t3 > 0 && !(e4 & 1 << t3); t3--) ;
            return 0 != this.high ? t3 + 33 : t3 + 1;
          }, R.isSafeInteger = function() {
            var e4 = this.high >> 21;
            return !e4 || !this.unsigned && -1 === e4 && !(0 === this.low && -2097152 === this.high);
          }, R.isZero = function() {
            return 0 === this.high && 0 === this.low;
          }, R.eqz = R.isZero, R.isNegative = function() {
            return !this.unsigned && this.high < 0;
          }, R.isPositive = function() {
            return this.unsigned || this.high >= 0;
          }, R.isOdd = function() {
            return !(1 & ~this.low);
          }, R.isEven = function() {
            return !(1 & this.low);
          }, R.equals = function(e4) {
            return n(e4) || (e4 = p(e4)), (this.unsigned === e4.unsigned || this.high >>> 31 != 1 || e4.high >>> 31 != 1) && this.high === e4.high && this.low === e4.low;
          }, R.eq = R.equals, R.notEquals = function(e4) {
            return !this.eq(e4);
          }, R.neq = R.notEquals, R.ne = R.notEquals, R.lessThan = function(e4) {
            return this.comp(e4) < 0;
          }, R.lt = R.lessThan, R.lessThanOrEqual = function(e4) {
            return this.comp(e4) <= 0;
          }, R.lte = R.lessThanOrEqual, R.le = R.lessThanOrEqual, R.greaterThan = function(e4) {
            return this.comp(e4) > 0;
          }, R.gt = R.greaterThan, R.greaterThanOrEqual = function(e4) {
            return this.comp(e4) >= 0;
          }, R.gte = R.greaterThanOrEqual, R.ge = R.greaterThanOrEqual, R.compare = function(e4) {
            if (n(e4) || (e4 = p(e4)), this.eq(e4)) return 0;
            var t3 = this.isNegative(), r3 = e4.isNegative();
            return t3 && !r3 ? -1 : !t3 && r3 ? 1 : this.unsigned ? e4.high >>> 0 > this.high >>> 0 || e4.high === this.high && e4.low >>> 0 > this.low >>> 0 ? -1 : 1 : this.sub(e4).isNegative() ? -1 : 1;
          }, R.comp = R.compare, R.negate = function() {
            return !this.unsigned && this.eq(E) ? E : this.not().add(b);
          }, R.neg = R.negate, R.add = function(e4) {
            n(e4) || (e4 = p(e4));
            var t3 = this.high >>> 16, r3 = 65535 & this.high, i2 = this.low >>> 16, o2 = 65535 & this.low, s2 = e4.high >>> 16, a2 = 65535 & e4.high, l2 = e4.low >>> 16, u2 = 0, d2 = 0, h2 = 0, f2 = 0;
            return h2 += (f2 += o2 + (65535 & e4.low)) >>> 16, d2 += (h2 += i2 + l2) >>> 16, u2 += (d2 += r3 + a2) >>> 16, u2 += t3 + s2, c((h2 &= 65535) << 16 | (f2 &= 65535), (u2 &= 65535) << 16 | (d2 &= 65535), this.unsigned);
          }, R.subtract = function(e4) {
            return n(e4) || (e4 = p(e4)), this.add(e4.neg());
          }, R.sub = R.subtract, R.multiply = function(e4) {
            if (this.isZero()) return this;
            if (n(e4) || (e4 = p(e4)), t2) return c(t2.mul(this.low, this.high, e4.low, e4.high), t2.get_high(), this.unsigned);
            if (e4.isZero()) return this.unsigned ? v : y;
            if (this.eq(E)) return e4.isOdd() ? E : y;
            if (e4.eq(E)) return this.isOdd() ? E : y;
            if (this.isNegative()) return e4.isNegative() ? this.neg().mul(e4.neg()) : this.neg().mul(e4).neg();
            if (e4.isNegative()) return this.mul(e4.neg()).neg();
            if (this.lt(m) && e4.lt(m)) return l(this.toNumber() * e4.toNumber(), this.unsigned);
            var r3 = this.high >>> 16, i2 = 65535 & this.high, o2 = this.low >>> 16, s2 = 65535 & this.low, a2 = e4.high >>> 16, u2 = 65535 & e4.high, d2 = e4.low >>> 16, h2 = 65535 & e4.low, f2 = 0, g2 = 0, b2 = 0, S2 = 0;
            return b2 += (S2 += s2 * h2) >>> 16, g2 += (b2 += o2 * h2) >>> 16, b2 &= 65535, g2 += (b2 += s2 * d2) >>> 16, f2 += (g2 += i2 * h2) >>> 16, g2 &= 65535, f2 += (g2 += o2 * d2) >>> 16, g2 &= 65535, f2 += (g2 += s2 * u2) >>> 16, f2 += r3 * h2 + i2 * d2 + o2 * u2 + s2 * a2, c((b2 &= 65535) << 16 | (S2 &= 65535), (f2 &= 65535) << 16 | (g2 &= 65535), this.unsigned);
          }, R.mul = R.multiply, R.divide = function(e4) {
            if (n(e4) || (e4 = p(e4)), e4.isZero()) throw Error("division by zero");
            var r3, i2, o2;
            if (t2) return this.unsigned || -2147483648 !== this.high || -1 !== e4.low || -1 !== e4.high ? c((this.unsigned ? t2.div_u : t2.div_s)(this.low, this.high, e4.low, e4.high), t2.get_high(), this.unsigned) : this;
            if (this.isZero()) return this.unsigned ? v : y;
            if (this.unsigned) {
              if (e4.unsigned || (e4 = e4.toUnsigned()), e4.gt(this)) return v;
              if (e4.gt(this.shru(1))) return S;
              o2 = v;
            } else {
              if (this.eq(E)) return e4.eq(b) || e4.eq(w) ? E : e4.eq(E) ? b : (r3 = this.shr(1).div(e4).shl(1)).eq(y) ? e4.isNegative() ? b : w : (i2 = this.sub(e4.mul(r3)), o2 = r3.add(i2.div(e4)));
              if (e4.eq(E)) return this.unsigned ? v : y;
              if (this.isNegative()) return e4.isNegative() ? this.neg().div(e4.neg()) : this.neg().div(e4).neg();
              if (e4.isNegative()) return this.div(e4.neg()).neg();
              o2 = y;
            }
            for (i2 = this; i2.gte(e4); ) {
              r3 = Math.max(1, Math.floor(i2.toNumber() / e4.toNumber()));
              for (var s2 = Math.ceil(Math.log(r3) / Math.LN2), a2 = s2 <= 48 ? 1 : u(2, s2 - 48), d2 = l(r3), h2 = d2.mul(e4); h2.isNegative() || h2.gt(i2); ) h2 = (d2 = l(r3 -= a2, this.unsigned)).mul(e4);
              d2.isZero() && (d2 = b), o2 = o2.add(d2), i2 = i2.sub(h2);
            }
            return o2;
          }, R.div = R.divide, R.modulo = function(e4) {
            return n(e4) || (e4 = p(e4)), t2 ? c((this.unsigned ? t2.rem_u : t2.rem_s)(this.low, this.high, e4.low, e4.high), t2.get_high(), this.unsigned) : this.sub(this.div(e4).mul(e4));
          }, R.mod = R.modulo, R.rem = R.modulo, R.not = function() {
            return c(~this.low, ~this.high, this.unsigned);
          }, R.countLeadingZeros = function() {
            return this.high ? Math.clz32(this.high) : Math.clz32(this.low) + 32;
          }, R.clz = R.countLeadingZeros, R.countTrailingZeros = function() {
            return this.low ? i(this.low) : i(this.high) + 32;
          }, R.ctz = R.countTrailingZeros, R.and = function(e4) {
            return n(e4) || (e4 = p(e4)), c(this.low & e4.low, this.high & e4.high, this.unsigned);
          }, R.or = function(e4) {
            return n(e4) || (e4 = p(e4)), c(this.low | e4.low, this.high | e4.high, this.unsigned);
          }, R.xor = function(e4) {
            return n(e4) || (e4 = p(e4)), c(this.low ^ e4.low, this.high ^ e4.high, this.unsigned);
          }, R.shiftLeft = function(e4) {
            return n(e4) && (e4 = e4.toInt()), 0 == (e4 &= 63) ? this : e4 < 32 ? c(this.low << e4, this.high << e4 | this.low >>> 32 - e4, this.unsigned) : c(0, this.low << e4 - 32, this.unsigned);
          }, R.shl = R.shiftLeft, R.shiftRight = function(e4) {
            return n(e4) && (e4 = e4.toInt()), 0 == (e4 &= 63) ? this : e4 < 32 ? c(this.low >>> e4 | this.high << 32 - e4, this.high >> e4, this.unsigned) : c(this.high >> e4 - 32, this.high >= 0 ? 0 : -1, this.unsigned);
          }, R.shr = R.shiftRight, R.shiftRightUnsigned = function(e4) {
            return n(e4) && (e4 = e4.toInt()), 0 == (e4 &= 63) ? this : e4 < 32 ? c(this.low >>> e4 | this.high << 32 - e4, this.high >>> e4, this.unsigned) : c(32 === e4 ? this.high : this.high >>> e4 - 32, 0, this.unsigned);
          }, R.shru = R.shiftRightUnsigned, R.shr_u = R.shiftRightUnsigned, R.rotateLeft = function(e4) {
            var t3;
            return n(e4) && (e4 = e4.toInt()), 0 == (e4 &= 63) ? this : 32 === e4 ? c(this.high, this.low, this.unsigned) : e4 < 32 ? (t3 = 32 - e4, c(this.low << e4 | this.high >>> t3, this.high << e4 | this.low >>> t3, this.unsigned)) : (t3 = 32 - (e4 -= 32), c(this.high << e4 | this.low >>> t3, this.low << e4 | this.high >>> t3, this.unsigned));
          }, R.rotl = R.rotateLeft, R.rotateRight = function(e4) {
            var t3;
            return n(e4) && (e4 = e4.toInt()), 0 == (e4 &= 63) ? this : 32 === e4 ? c(this.high, this.low, this.unsigned) : e4 < 32 ? (t3 = 32 - e4, c(this.high << t3 | this.low >>> e4, this.low << t3 | this.high >>> e4, this.unsigned)) : (t3 = 32 - (e4 -= 32), c(this.low << t3 | this.high >>> e4, this.high << t3 | this.low >>> e4, this.unsigned));
          }, R.rotr = R.rotateRight, R.toSigned = function() {
            return this.unsigned ? c(this.low, this.high, false) : this;
          }, R.toUnsigned = function() {
            return this.unsigned ? this : c(this.low, this.high, true);
          }, R.toBytes = function(e4) {
            return e4 ? this.toBytesLE() : this.toBytesBE();
          }, R.toBytesLE = function() {
            var e4 = this.high, t3 = this.low;
            return [255 & t3, t3 >>> 8 & 255, t3 >>> 16 & 255, t3 >>> 24, 255 & e4, e4 >>> 8 & 255, e4 >>> 16 & 255, e4 >>> 24];
          }, R.toBytesBE = function() {
            var e4 = this.high, t3 = this.low;
            return [e4 >>> 24, e4 >>> 16 & 255, e4 >>> 8 & 255, 255 & e4, t3 >>> 24, t3 >>> 16 & 255, t3 >>> 8 & 255, 255 & t3];
          }, r2.fromBytes = function(e4, t3, n2) {
            return n2 ? r2.fromBytesLE(e4, t3) : r2.fromBytesBE(e4, t3);
          }, r2.fromBytesLE = function(e4, t3) {
            return new r2(e4[0] | e4[1] << 8 | e4[2] << 16 | e4[3] << 24, e4[4] | e4[5] << 8 | e4[6] << 16 | e4[7] << 24, t3);
          }, r2.fromBytesBE = function(e4, t3) {
            return new r2(e4[4] << 24 | e4[5] << 16 | e4[6] << 8 | e4[7], e4[0] << 24 | e4[1] << 16 | e4[2] << 8 | e4[3], t3);
          }, "function" == typeof BigInt && (r2.fromBigInt = function(e4, t3) {
            return c(Number(BigInt.asIntN(32, e4)), Number(BigInt.asIntN(32, e4 >> BigInt(32))), t3);
          }, r2.fromValue = function(e4, t3) {
            return "bigint" == typeof e4 ? r2.fromBigInt(e4, t3) : p(e4, t3);
          }, R.toBigInt = function() {
            var e4 = BigInt(this.low >>> 0);
            return BigInt(this.unsigned ? this.high >>> 0 : this.high) << BigInt(32) | e4;
          }), e3.default = r2;
        })(e2), (function(e3) {
          return e3.default || e3;
        })(e2);
      }.apply(t, []), void 0 === r || (e.exports = r);
    }, 5431: (e, t) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.formatDateDifference = t.deadlineToString = t.getRelativeTimeout = t.getDeadlineTimeoutString = t.minDeadline = void 0, t.minDeadline = function(...e2) {
        let t2 = 1 / 0;
        for (const r2 of e2) {
          const e3 = r2 instanceof Date ? r2.getTime() : r2;
          e3 < t2 && (t2 = e3);
        }
        return t2;
      };
      const r = [["m", 1], ["S", 1e3], ["M", 6e4], ["H", 36e5]];
      t.getDeadlineTimeoutString = function(e2) {
        const t2 = (/* @__PURE__ */ new Date()).getTime();
        e2 instanceof Date && (e2 = e2.getTime());
        const n = Math.max(e2 - t2, 0);
        for (const [e3, t3] of r) {
          const r2 = n / t3;
          if (r2 < 1e8) return String(Math.ceil(r2)) + e3;
        }
        throw new Error("Deadline is too far in the future");
      }, t.getRelativeTimeout = function(e2) {
        const t2 = (e2 instanceof Date ? e2.getTime() : e2) - (/* @__PURE__ */ new Date()).getTime();
        return t2 < 0 ? 0 : t2 > 2147483647 ? 1 / 0 : t2;
      }, t.deadlineToString = function(e2) {
        if (e2 instanceof Date) return e2.toISOString();
        {
          const t2 = new Date(e2);
          return Number.isNaN(t2.getTime()) ? "" + e2 : t2.toISOString();
        }
      }, t.formatDateDifference = function(e2, t2) {
        return ((t2.getTime() - e2.getTime()) / 1e3).toFixed(3) + "s";
      };
    }, 5479: (e, t) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.OMEGA_EDIT_CLIENT_VERSION = void 0, t.OMEGA_EDIT_CLIENT_VERSION = "1.0.1";
    }, 5594: (e, t, r) => {
      var n = t, i = r(8723), o = ["double", "float", "int32", "uint32", "sint32", "fixed32", "sfixed32", "int64", "uint64", "sint64", "fixed64", "sfixed64", "bool", "string", "bytes"];
      function s(e2, t2) {
        var r2 = 0, n2 = {};
        for (t2 |= 0; r2 < e2.length; ) n2[o[r2 + t2]] = e2[r2++];
        return n2;
      }
      n.basic = s([1, 5, 0, 0, 0, 5, 5, 0, 0, 0, 1, 1, 0, 2, 2]), n.defaults = s([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, "", i.emptyArray, null]), n.long = s([0, 0, 0, 1, 1], 7), n.mapKey = s([0, 0, 0, 5, 5, 0, 0, 0, 1, 1, 0, 2], 2), n.packed = s([1, 5, 0, 0, 0, 5, 5, 0, 0, 0, 1, 1, 0]);
    }, 5600: (e, t, r) => {
      const n = r(857), i = r(2018), o = r(6071), { env: s } = process;
      let a;
      function l(e2, t2 = {}) {
        return 0 !== (r2 = (function(e3, { streamIsTTY: t3, sniffFlags: r3 = true } = {}) {
          const i2 = (function() {
            if ("FORCE_COLOR" in s) return "true" === s.FORCE_COLOR ? 1 : "false" === s.FORCE_COLOR ? 0 : 0 === s.FORCE_COLOR.length ? 1 : Math.min(Number.parseInt(s.FORCE_COLOR, 10), 3);
          })();
          void 0 !== i2 && (a = i2);
          const l2 = r3 ? a : i2;
          if (0 === l2) return 0;
          if (r3) {
            if (o("color=16m") || o("color=full") || o("color=truecolor")) return 3;
            if (o("color=256")) return 2;
          }
          if (e3 && !t3 && void 0 === l2) return 0;
          const c = l2 || 0;
          if ("dumb" === s.TERM) return c;
          if ("win32" === process.platform) {
            const e4 = n.release().split(".");
            return Number(e4[0]) >= 10 && Number(e4[2]) >= 10586 ? Number(e4[2]) >= 14931 ? 3 : 2 : 1;
          }
          if ("CI" in s) return ["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE", "DRONE"].some((e4) => e4 in s) || "codeship" === s.CI_NAME ? 1 : c;
          if ("TEAMCITY_VERSION" in s) return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(s.TEAMCITY_VERSION) ? 1 : 0;
          if ("truecolor" === s.COLORTERM) return 3;
          if ("TERM_PROGRAM" in s) {
            const e4 = Number.parseInt((s.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
            switch (s.TERM_PROGRAM) {
              case "iTerm.app":
                return e4 >= 3 ? 3 : 2;
              case "Apple_Terminal":
                return 2;
            }
          }
          return /-256(color)?$/i.test(s.TERM) ? 2 : /^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(s.TERM) || "COLORTERM" in s ? 1 : c;
        })(e2, { streamIsTTY: e2 && e2.isTTY, ...t2 })) && { level: r2, hasBasic: true, has256: r2 >= 2, has16m: r2 >= 3 };
        var r2;
      }
      o("no-color") || o("no-colors") || o("color=false") || o("color=never") ? a = 0 : (o("color") || o("colors") || o("color=true") || o("color=always")) && (a = 1), e.exports = { supportsColor: l, stdout: l({ isTTY: i.isatty(1) }), stderr: l({ isTTY: i.isatty(2) }) };
    }, 5603: (e, t, r) => {
      const n = r(6462), { stdout: i, stderr: o } = r(5915), { stringReplaceAll: s, stringEncaseCRLFWithFirstIndex: a } = r(5179), { isArray: l } = Array, c = ["ansi", "ansi", "ansi256", "ansi16m"], u = /* @__PURE__ */ Object.create(null);
      class d {
        constructor(e2) {
          return p(e2);
        }
      }
      const p = (e2) => {
        const t2 = {};
        return ((e3, t3 = {}) => {
          if (t3.level && !(Number.isInteger(t3.level) && t3.level >= 0 && t3.level <= 3)) throw new Error("The `level` option should be an integer from 0 to 3");
          const r2 = i ? i.level : 0;
          e3.level = void 0 === t3.level ? r2 : t3.level;
        })(t2, e2), t2.template = (...e3) => S(t2.template, ...e3), Object.setPrototypeOf(t2, h.prototype), Object.setPrototypeOf(t2.template, t2), t2.template.constructor = () => {
          throw new Error("`chalk.constructor()` is deprecated. Use `new chalk.Instance()` instead.");
        }, t2.template.Instance = d, t2.template;
      };
      function h(e2) {
        return p(e2);
      }
      for (const [e2, t2] of Object.entries(n)) u[e2] = { get() {
        const r2 = y(this, m(t2.open, t2.close, this._styler), this._isEmpty);
        return Object.defineProperty(this, e2, { value: r2 }), r2;
      } };
      u.visible = { get() {
        const e2 = y(this, this._styler, true);
        return Object.defineProperty(this, "visible", { value: e2 }), e2;
      } };
      const f = ["rgb", "hex", "keyword", "hsl", "hsv", "hwb", "ansi", "ansi256"];
      for (const e2 of f) u[e2] = { get() {
        const { level: t2 } = this;
        return function(...r2) {
          const i2 = m(n.color[c[t2]][e2](...r2), n.color.close, this._styler);
          return y(this, i2, this._isEmpty);
        };
      } };
      for (const e2 of f) u["bg" + e2[0].toUpperCase() + e2.slice(1)] = { get() {
        const { level: t2 } = this;
        return function(...r2) {
          const i2 = m(n.bgColor[c[t2]][e2](...r2), n.bgColor.close, this._styler);
          return y(this, i2, this._isEmpty);
        };
      } };
      const g = Object.defineProperties(() => {
      }, { ...u, level: { enumerable: true, get() {
        return this._generator.level;
      }, set(e2) {
        this._generator.level = e2;
      } } }), m = (e2, t2, r2) => {
        let n2, i2;
        return void 0 === r2 ? (n2 = e2, i2 = t2) : (n2 = r2.openAll + e2, i2 = t2 + r2.closeAll), { open: e2, close: t2, openAll: n2, closeAll: i2, parent: r2 };
      }, y = (e2, t2, r2) => {
        const n2 = (...e3) => l(e3[0]) && l(e3[0].raw) ? v(n2, S(n2, ...e3)) : v(n2, 1 === e3.length ? "" + e3[0] : e3.join(" "));
        return Object.setPrototypeOf(n2, g), n2._generator = e2, n2._styler = t2, n2._isEmpty = r2, n2;
      }, v = (e2, t2) => {
        if (e2.level <= 0 || !t2) return e2._isEmpty ? "" : t2;
        let r2 = e2._styler;
        if (void 0 === r2) return t2;
        const { openAll: n2, closeAll: i2 } = r2;
        if (-1 !== t2.indexOf("\x1B")) for (; void 0 !== r2; ) t2 = s(t2, r2.close, r2.open), r2 = r2.parent;
        const o2 = t2.indexOf("\n");
        return -1 !== o2 && (t2 = a(t2, i2, n2, o2)), n2 + t2 + i2;
      };
      let b;
      const S = (e2, ...t2) => {
        const [n2] = t2;
        if (!l(n2) || !l(n2.raw)) return t2.join(" ");
        const i2 = t2.slice(1), o2 = [n2.raw[0]];
        for (let e3 = 1; e3 < n2.length; e3++) o2.push(String(i2[e3 - 1]).replace(/[{}\\]/g, "\\$&"), String(n2.raw[e3]));
        return void 0 === b && (b = r(9912)), b(e2, o2.join(""));
      };
      Object.defineProperties(h.prototype, u);
      const w = h();
      w.supportsColor = i, w.stderr = h({ level: o ? o.level : 0 }), w.stderr.supportsColor = o, e.exports = w;
    }, 5630: (e) => {
      function t() {
      }
      e.exports = { starting: t, tryConnect: t, connected: t, timeout: t, error: t };
    }, 5672: (e) => {
      e.exports = /^#!(.*)/;
    }, 5675: (e) => {
      e.exports = require$$14;
    }, 5711: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.ClientVersion = void 0, t.getClientVersion = function() {
        return (0, n.getLogger)().debug({ fn: "getClientVersion", resp: t.ClientVersion }), t.ClientVersion;
      };
      const n = r(8943), i = r(5479);
      t.ClientVersion = i.OMEGA_EDIT_CLIENT_VERSION;
    }, 5768: (e) => {
      const t = 1e3;
      e.exports = { wait: function(e2, r, n, i, o) {
        const s = Date.now() + i;
        let a = Atomics.load(e2, r);
        if (a === n) return void o(null, "ok");
        let l = a;
        const c = (i2) => {
          Date.now() > s ? o(null, "timed-out") : setTimeout(() => {
            l = a, a = Atomics.load(e2, r), a === l ? c(i2 >= t ? t : 2 * i2) : o(null, a === n ? "ok" : "not-equal");
          }, i2);
        };
        c(1);
      }, waitDiff: function(e2, r, n, i, o) {
        const s = Date.now() + i;
        let a = Atomics.load(e2, r);
        if (a !== n) return void o(null, "ok");
        const l = (i2) => {
          Date.now() > s ? o(null, "timed-out") : setTimeout(() => {
            a = Atomics.load(e2, r), a !== n ? o(null, "ok") : l(i2 >= t ? t : 2 * i2);
          }, i2);
        };
        l(1);
      } };
    }, 5904: (e, t, r) => {
      e.exports = i;
      var n = r(5099);
      function i(e2, t2) {
        this.lo = e2 >>> 0, this.hi = t2 >>> 0;
      }
      var o = i.zero = new i(0, 0);
      o.toNumber = function() {
        return 0;
      }, o.zzEncode = o.zzDecode = function() {
        return this;
      }, o.length = function() {
        return 1;
      };
      var s = i.zeroHash = "\0\0\0\0\0\0\0\0";
      i.fromNumber = function(e2) {
        if (0 === e2) return o;
        var t2 = e2 < 0;
        t2 && (e2 = -e2);
        var r2 = e2 >>> 0, n2 = (e2 - r2) / 4294967296 >>> 0;
        return t2 && (n2 = ~n2 >>> 0, r2 = ~r2 >>> 0, ++r2 > 4294967295 && (r2 = 0, ++n2 > 4294967295 && (n2 = 0))), new i(r2, n2);
      }, i.from = function(e2) {
        if ("number" == typeof e2) return i.fromNumber(e2);
        if (n.isString(e2)) {
          if (!n.Long) return i.fromNumber(parseInt(e2, 10));
          e2 = n.Long.fromString(e2);
        }
        return e2.low || e2.high ? new i(e2.low >>> 0, e2.high >>> 0) : o;
      }, i.prototype.toNumber = function(e2) {
        if (!e2 && this.hi >>> 31) {
          var t2 = 1 + ~this.lo >>> 0, r2 = ~this.hi >>> 0;
          return t2 || (r2 = r2 + 1 >>> 0), -(t2 + 4294967296 * r2);
        }
        return this.lo + 4294967296 * this.hi;
      }, i.prototype.toLong = function(e2) {
        return n.Long ? new n.Long(0 | this.lo, 0 | this.hi, Boolean(e2)) : { low: 0 | this.lo, high: 0 | this.hi, unsigned: Boolean(e2) };
      };
      var a = String.prototype.charCodeAt;
      i.fromHash = function(e2) {
        return e2 === s ? o : new i((a.call(e2, 0) | a.call(e2, 1) << 8 | a.call(e2, 2) << 16 | a.call(e2, 3) << 24) >>> 0, (a.call(e2, 4) | a.call(e2, 5) << 8 | a.call(e2, 6) << 16 | a.call(e2, 7) << 24) >>> 0);
      }, i.prototype.toHash = function() {
        return String.fromCharCode(255 & this.lo, this.lo >>> 8 & 255, this.lo >>> 16 & 255, this.lo >>> 24, 255 & this.hi, this.hi >>> 8 & 255, this.hi >>> 16 & 255, this.hi >>> 24);
      }, i.prototype.zzEncode = function() {
        var e2 = this.hi >> 31;
        return this.hi = ((this.hi << 1 | this.lo >>> 31) ^ e2) >>> 0, this.lo = (this.lo << 1 ^ e2) >>> 0, this;
      }, i.prototype.zzDecode = function() {
        var e2 = -(1 & this.lo);
        return this.lo = ((this.lo >>> 1 | this.hi << 31) ^ e2) >>> 0, this.hi = (this.hi >>> 1 ^ e2) >>> 0, this;
      }, i.prototype.length = function() {
        var e2 = this.lo, t2 = (this.lo >>> 28 | this.hi << 4) >>> 0, r2 = this.hi >>> 24;
        return 0 === r2 ? 0 === t2 ? e2 < 16384 ? e2 < 128 ? 1 : 2 : e2 < 2097152 ? 3 : 4 : t2 < 16384 ? t2 < 128 ? 5 : 6 : t2 < 2097152 ? 7 : 8 : r2 < 128 ? 9 : 10;
      };
    }, 5915: (e, t, r) => {
      const n = r(857), i = r(2018), o = r(6071), { env: s } = process;
      let a;
      function l(e2) {
        return 0 !== e2 && { level: e2, hasBasic: true, has256: e2 >= 2, has16m: e2 >= 3 };
      }
      function c(e2, t2) {
        if (0 === a) return 0;
        if (o("color=16m") || o("color=full") || o("color=truecolor")) return 3;
        if (o("color=256")) return 2;
        if (e2 && !t2 && void 0 === a) return 0;
        const r2 = a || 0;
        if ("dumb" === s.TERM) return r2;
        if ("win32" === process.platform) {
          const e3 = n.release().split(".");
          return Number(e3[0]) >= 10 && Number(e3[2]) >= 10586 ? Number(e3[2]) >= 14931 ? 3 : 2 : 1;
        }
        if ("CI" in s) return ["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE"].some((e3) => e3 in s) || "codeship" === s.CI_NAME ? 1 : r2;
        if ("TEAMCITY_VERSION" in s) return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(s.TEAMCITY_VERSION) ? 1 : 0;
        if ("truecolor" === s.COLORTERM) return 3;
        if ("TERM_PROGRAM" in s) {
          const e3 = parseInt((s.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
          switch (s.TERM_PROGRAM) {
            case "iTerm.app":
              return e3 >= 3 ? 3 : 2;
            case "Apple_Terminal":
              return 2;
          }
        }
        return /-256(color)?$/i.test(s.TERM) ? 2 : /^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(s.TERM) || "COLORTERM" in s ? 1 : r2;
      }
      o("no-color") || o("no-colors") || o("color=false") || o("color=never") ? a = 0 : (o("color") || o("colors") || o("color=true") || o("color=always")) && (a = 1), "FORCE_COLOR" in s && (a = "true" === s.FORCE_COLOR ? 1 : "false" === s.FORCE_COLOR ? 0 : 0 === s.FORCE_COLOR.length ? 1 : Math.min(parseInt(s.FORCE_COLOR, 10), 3)), e.exports = { supportsColor: function(e2) {
        return l(c(e2, e2 && e2.isTTY));
      }, stdout: l(c(true, i.isatty(1))), stderr: l(c(true, i.isatty(2))) };
    }, 5931: (e, t, r) => {
      var n = t, i = r(8118), o = r(8723);
      function s(e2, t2, r2, n2) {
        var o2 = false;
        if (t2.resolvedType) if (t2.resolvedType instanceof i) {
          e2("switch(d%s){", n2);
          for (var s2 = t2.resolvedType.values, a2 = Object.keys(s2), l = 0; l < a2.length; ++l) s2[a2[l]] !== t2.typeDefault || o2 || (e2("default:")('if(typeof(d%s)==="number"){m%s=d%s;break}', n2, n2, n2), t2.repeated || e2("break"), o2 = true), e2("case%j:", a2[l])("case %i:", s2[a2[l]])("m%s=%j", n2, s2[a2[l]])("break");
          e2("}");
        } else e2('if(typeof d%s!=="object")', n2)("throw TypeError(%j)", t2.fullName + ": object expected")("m%s=types[%i].fromObject(d%s)", n2, r2, n2);
        else {
          var c = false;
          switch (t2.type) {
            case "double":
            case "float":
              e2("m%s=Number(d%s)", n2, n2);
              break;
            case "uint32":
            case "fixed32":
              e2("m%s=d%s>>>0", n2, n2);
              break;
            case "int32":
            case "sint32":
            case "sfixed32":
              e2("m%s=d%s|0", n2, n2);
              break;
            case "uint64":
              c = true;
            case "int64":
            case "sint64":
            case "fixed64":
            case "sfixed64":
              e2("if(util.Long)")("(m%s=util.Long.fromValue(d%s)).unsigned=%j", n2, n2, c)('else if(typeof d%s==="string")', n2)("m%s=parseInt(d%s,10)", n2, n2)('else if(typeof d%s==="number")', n2)("m%s=d%s", n2, n2)('else if(typeof d%s==="object")', n2)("m%s=new util.LongBits(d%s.low>>>0,d%s.high>>>0).toNumber(%s)", n2, n2, n2, c ? "true" : "");
              break;
            case "bytes":
              e2('if(typeof d%s==="string")', n2)("util.base64.decode(d%s,m%s=util.newBuffer(util.base64.length(d%s)),0)", n2, n2, n2)("else if(d%s.length >= 0)", n2)("m%s=d%s", n2, n2);
              break;
            case "string":
              e2("m%s=String(d%s)", n2, n2);
              break;
            case "bool":
              e2("m%s=Boolean(d%s)", n2, n2);
          }
        }
        return e2;
      }
      function a(e2, t2, r2, n2) {
        if (t2.resolvedType) t2.resolvedType instanceof i ? e2("d%s=o.enums===String?(types[%i].values[m%s]===undefined?m%s:types[%i].values[m%s]):m%s", n2, r2, n2, n2, r2, n2, n2) : e2("d%s=types[%i].toObject(m%s,o)", n2, r2, n2);
        else {
          var o2 = false;
          switch (t2.type) {
            case "double":
            case "float":
              e2("d%s=o.json&&!isFinite(m%s)?String(m%s):m%s", n2, n2, n2, n2);
              break;
            case "uint64":
              o2 = true;
            case "int64":
            case "sint64":
            case "fixed64":
            case "sfixed64":
              e2('if(typeof m%s==="number")', n2)("d%s=o.longs===String?String(m%s):m%s", n2, n2, n2)("else")("d%s=o.longs===String?util.Long.prototype.toString.call(m%s):o.longs===Number?new util.LongBits(m%s.low>>>0,m%s.high>>>0).toNumber(%s):m%s", n2, n2, n2, n2, o2 ? "true" : "", n2);
              break;
            case "bytes":
              e2("d%s=o.bytes===String?util.base64.encode(m%s,0,m%s.length):o.bytes===Array?Array.prototype.slice.call(m%s):m%s", n2, n2, n2, n2, n2);
              break;
            default:
              e2("d%s=m%s", n2, n2);
          }
        }
        return e2;
      }
      n.fromObject = function(e2) {
        var t2 = e2.fieldsArray, r2 = o.codegen(["d"], e2.name + "$fromObject")("if(d instanceof this.ctor)")("return d");
        if (!t2.length) return r2("return new this.ctor");
        r2("var m=new this.ctor");
        for (var n2 = 0; n2 < t2.length; ++n2) {
          var a2 = t2[n2].resolve(), l = o.safeProp(a2.name);
          a2.map ? (r2("if(d%s){", l)('if(typeof d%s!=="object")', l)("throw TypeError(%j)", a2.fullName + ": object expected")("m%s={}", l)("for(var ks=Object.keys(d%s),i=0;i<ks.length;++i){", l), s(r2, a2, n2, l + "[ks[i]]")("}")("}")) : a2.repeated ? (r2("if(d%s){", l)("if(!Array.isArray(d%s))", l)("throw TypeError(%j)", a2.fullName + ": array expected")("m%s=[]", l)("for(var i=0;i<d%s.length;++i){", l), s(r2, a2, n2, l + "[i]")("}")("}")) : (a2.resolvedType instanceof i || r2("if(d%s!=null){", l), s(r2, a2, n2, l), a2.resolvedType instanceof i || r2("}"));
        }
        return r2("return m");
      }, n.toObject = function(e2) {
        var t2 = e2.fieldsArray.slice().sort(o.compareFieldsById);
        if (!t2.length) return o.codegen()("return {}");
        for (var r2 = o.codegen(["m", "o"], e2.name + "$toObject")("if(!o)")("o={}")("var d={}"), n2 = [], s2 = [], l = [], c = 0; c < t2.length; ++c) t2[c].partOf || (t2[c].resolve().repeated ? n2 : t2[c].map ? s2 : l).push(t2[c]);
        if (n2.length) {
          for (r2("if(o.arrays||o.defaults){"), c = 0; c < n2.length; ++c) r2("d%s=[]", o.safeProp(n2[c].name));
          r2("}");
        }
        if (s2.length) {
          for (r2("if(o.objects||o.defaults){"), c = 0; c < s2.length; ++c) r2("d%s={}", o.safeProp(s2[c].name));
          r2("}");
        }
        if (l.length) {
          for (r2("if(o.defaults){"), c = 0; c < l.length; ++c) {
            var u = l[c], d = o.safeProp(u.name);
            if (u.resolvedType instanceof i) r2("d%s=o.enums===String?%j:%j", d, u.resolvedType.valuesById[u.typeDefault], u.typeDefault);
            else if (u.long) r2("if(util.Long){")("var n=new util.Long(%i,%i,%j)", u.typeDefault.low, u.typeDefault.high, u.typeDefault.unsigned)("d%s=o.longs===String?n.toString():o.longs===Number?n.toNumber():n", d)("}else")("d%s=o.longs===String?%j:%i", d, u.typeDefault.toString(), u.typeDefault.toNumber());
            else if (u.bytes) {
              var p = "[" + Array.prototype.slice.call(u.typeDefault).join(",") + "]";
              r2("if(o.bytes===String)d%s=%j", d, String.fromCharCode.apply(String, u.typeDefault))("else{")("d%s=%s", d, p)("if(o.bytes!==Array)d%s=util.newBuffer(d%s)", d, d)("}");
            } else r2("d%s=%j", d, u.typeDefault);
          }
          r2("}");
        }
        var h = false;
        for (c = 0; c < t2.length; ++c) {
          u = t2[c];
          var f = e2._fieldsArray.indexOf(u);
          d = o.safeProp(u.name), u.map ? (h || (h = true, r2("var ks2")), r2("if(m%s&&(ks2=Object.keys(m%s)).length){", d, d)("d%s={}", d)("for(var j=0;j<ks2.length;++j){"), a(r2, u, f, d + "[ks2[j]]")("}")) : u.repeated ? (r2("if(m%s&&m%s.length){", d, d)("d%s=[]", d)("for(var j=0;j<m%s.length;++j){", d), a(r2, u, f, d + "[j]")("}")) : (r2("if(m%s!=null&&m.hasOwnProperty(%j)){", d, u.name), a(r2, u, f, d), u.partOf && r2("if(o.oneofs)")("d%s=%j", o.safeProp(u.partOf.name), u.name)), r2("}");
        }
        return r2("return d");
      };
    }, 5953: (e, t, r) => {
      var n = t;
      function i() {
        n.util._configure(), n.Writer._configure(n.BufferWriter), n.Reader._configure(n.BufferReader);
      }
      n.build = "minimal", n.Writer = r(3108), n.BufferWriter = r(2533), n.Reader = r(3963), n.BufferReader = r(2777), n.util = r(5099), n.rpc = r(7080), n.roots = r(4738), n.configure = i, i();
    }, 5956: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.getProxiedConnection = t.mapProxyName = void 0;
      const n = r(4398), i = r(6754), o = r(4169), s = r(8611), a = r(4756), l = r(4398), c = r(9939), u = r(5129), d = r(7016), p = r(7439);
      function h(e2) {
        l.trace(i.LogVerbosity.DEBUG, "proxy", e2);
      }
      t.mapProxyName = function(e2, t2) {
        var r2;
        const o2 = { target: e2, extraOptions: {} };
        if (0 === (null !== (r2 = t2["grpc.enable_http_proxy"]) && void 0 !== r2 ? r2 : 1)) return o2;
        if ("unix" === e2.scheme) return o2;
        const s2 = (function() {
          let e3, t3 = "", r3 = "";
          if (define_process_env_default.grpc_proxy) r3 = "grpc_proxy", t3 = define_process_env_default.grpc_proxy;
          else if (define_process_env_default.https_proxy) r3 = "https_proxy", t3 = define_process_env_default.https_proxy;
          else {
            if (!define_process_env_default.http_proxy) return {};
            r3 = "http_proxy", t3 = define_process_env_default.http_proxy;
          }
          try {
            e3 = new d.URL(t3);
          } catch (e4) {
            return (0, n.log)(i.LogVerbosity.ERROR, `cannot parse value of "${r3}" env var`), {};
          }
          if ("http:" !== e3.protocol) return (0, n.log)(i.LogVerbosity.ERROR, `"${e3.protocol}" scheme not supported in proxy URI`), {};
          let o3 = null;
          e3.username && (e3.password ? ((0, n.log)(i.LogVerbosity.INFO, "userinfo found in proxy URI"), o3 = decodeURIComponent(`${e3.username}:${e3.password}`)) : o3 = e3.username);
          const s3 = e3.hostname;
          let a3 = e3.port;
          "" === a3 && (a3 = "80");
          const l3 = { address: `${s3}:${a3}` };
          return o3 && (l3.creds = o3), h("Proxy server " + l3.address + " set by environment variable " + r3), l3;
        })();
        if (!s2.address) return o2;
        const a2 = (0, u.splitHostPort)(e2.path);
        if (!a2) return o2;
        const l2 = a2.host;
        for (const t3 of (function() {
          let e3 = define_process_env_default.no_grpc_proxy, t4 = "no_grpc_proxy";
          return e3 || (e3 = define_process_env_default.no_proxy, t4 = "no_proxy"), e3 ? (h("No proxy server list set by environment variable " + t4), e3.split(",")) : [];
        })()) if (t3 === l2) return h("Not using proxy for target in no_proxy list: " + (0, u.uriToString)(e2)), o2;
        const c2 = { "grpc.http_connect_target": (0, u.uriToString)(e2) };
        return s2.creds && (c2["grpc.http_connect_creds"] = s2.creds), { target: { scheme: "dns", path: s2.address }, extraOptions: c2 };
      }, t.getProxiedConnection = function(e2, t2, r2) {
        var l2;
        if (!("grpc.http_connect_target" in t2)) return Promise.resolve({});
        const d2 = t2["grpc.http_connect_target"], f = (0, u.parseUri)(d2);
        if (null === f) return Promise.resolve({});
        const g = (0, u.splitHostPort)(f.path);
        if (null === g) return Promise.resolve({});
        const m = `${g.host}:${null !== (l2 = g.port) && void 0 !== l2 ? l2 : p.DEFAULT_PORT}`, y = { method: "CONNECT", path: m }, v = { Host: m };
        (0, c.isTcpSubchannelAddress)(e2) ? (y.host = e2.host, y.port = e2.port) : y.socketPath = e2.path, "grpc.http_connect_creds" in t2 && (v["Proxy-Authorization"] = "Basic " + Buffer.from(t2["grpc.http_connect_creds"]).toString("base64")), y.headers = v;
        const b = (0, c.subchannelAddressToString)(e2);
        return h("Using proxy " + b + " to connect to " + y.path), new Promise((e3, t3) => {
          const l3 = s.request(y);
          l3.once("connect", (s2, c2, d3) => {
            var p2;
            if (l3.removeAllListeners(), c2.removeAllListeners(), 200 === s2.statusCode) if (h("Successfully connected to " + y.path + " through proxy " + b), d3.length > 0 && c2.unshift(d3), "secureContext" in r2) {
              const n2 = (0, o.getDefaultAuthority)(f), i2 = (0, u.splitHostPort)(n2), s3 = null !== (p2 = null == i2 ? void 0 : i2.host) && void 0 !== p2 ? p2 : n2, l4 = a.connect(Object.assign({ host: s3, servername: s3, socket: c2 }, r2), () => {
                h("Successfully established a TLS connection to " + y.path + " through proxy " + b), e3({ socket: l4, realTarget: f });
              });
              l4.on("error", (e4) => {
                h("Failed to establish a TLS connection to " + y.path + " through proxy " + b + " with error " + e4.message), t3();
              });
            } else h("Successfully established a plaintext connection to " + y.path + " through proxy " + b), e3({ socket: c2, realTarget: f });
            else (0, n.log)(i.LogVerbosity.ERROR, "Failed to connect to " + y.path + " through proxy " + b + " with status " + s2.statusCode), t3();
          }), l3.once("error", (e4) => {
            l3.removeAllListeners(), (0, n.log)(i.LogVerbosity.ERROR, "Failed to connect to proxy " + b + " with error " + e4.message), t3();
          }), l3.end();
        });
      };
    }, 5989: (e, t, r) => {
      Object.defineProperty(t, "__esModule", { value: true }), t.getInterceptingCall = t.InterceptingCall = t.RequesterBuilder = t.ListenerBuilder = t.InterceptorConfigurationError = void 0;
      const n = r(9074), i = r(2173), o = r(6754), s = r(9869);
      class a extends Error {
        constructor(e2) {
          super(e2), this.name = "InterceptorConfigurationError", Error.captureStackTrace(this, a);
        }
      }
      t.InterceptorConfigurationError = a, t.ListenerBuilder = class {
        constructor() {
          this.metadata = void 0, this.message = void 0, this.status = void 0;
        }
        withOnReceiveMetadata(e2) {
          return this.metadata = e2, this;
        }
        withOnReceiveMessage(e2) {
          return this.message = e2, this;
        }
        withOnReceiveStatus(e2) {
          return this.status = e2, this;
        }
        build() {
          return { onReceiveMetadata: this.metadata, onReceiveMessage: this.message, onReceiveStatus: this.status };
        }
      }, t.RequesterBuilder = class {
        constructor() {
          this.start = void 0, this.message = void 0, this.halfClose = void 0, this.cancel = void 0;
        }
        withStart(e2) {
          return this.start = e2, this;
        }
        withSendMessage(e2) {
          return this.message = e2, this;
        }
        withHalfClose(e2) {
          return this.halfClose = e2, this;
        }
        withCancel(e2) {
          return this.cancel = e2, this;
        }
        build() {
          return { start: this.start, sendMessage: this.message, halfClose: this.halfClose, cancel: this.cancel };
        }
      };
      const l = { onReceiveMetadata: (e2, t2) => {
        t2(e2);
      }, onReceiveMessage: (e2, t2) => {
        t2(e2);
      }, onReceiveStatus: (e2, t2) => {
        t2(e2);
      } }, c = { start: (e2, t2, r2) => {
        r2(e2, t2);
      }, sendMessage: (e2, t2) => {
        t2(e2);
      }, halfClose: (e2) => {
        e2();
      }, cancel: (e2) => {
        e2();
      } };
      t.InterceptingCall = class {
        constructor(e2, t2) {
          var r2, n2, i2, o2;
          this.nextCall = e2, this.processingMetadata = false, this.pendingMessageContext = null, this.processingMessage = false, this.pendingHalfClose = false, this.requester = t2 ? { start: null !== (r2 = t2.start) && void 0 !== r2 ? r2 : c.start, sendMessage: null !== (n2 = t2.sendMessage) && void 0 !== n2 ? n2 : c.sendMessage, halfClose: null !== (i2 = t2.halfClose) && void 0 !== i2 ? i2 : c.halfClose, cancel: null !== (o2 = t2.cancel) && void 0 !== o2 ? o2 : c.cancel } : c;
        }
        cancelWithStatus(e2, t2) {
          this.requester.cancel(() => {
            this.nextCall.cancelWithStatus(e2, t2);
          });
        }
        getPeer() {
          return this.nextCall.getPeer();
        }
        processPendingMessage() {
          this.pendingMessageContext && (this.nextCall.sendMessageWithContext(this.pendingMessageContext, this.pendingMessage), this.pendingMessageContext = null, this.pendingMessage = null);
        }
        processPendingHalfClose() {
          this.pendingHalfClose && this.nextCall.halfClose();
        }
        start(e2, t2) {
          var r2, n2, o2, s2, a2, c2;
          const u2 = { onReceiveMetadata: null !== (n2 = null === (r2 = null == t2 ? void 0 : t2.onReceiveMetadata) || void 0 === r2 ? void 0 : r2.bind(t2)) && void 0 !== n2 ? n2 : (e3) => {
          }, onReceiveMessage: null !== (s2 = null === (o2 = null == t2 ? void 0 : t2.onReceiveMessage) || void 0 === o2 ? void 0 : o2.bind(t2)) && void 0 !== s2 ? s2 : (e3) => {
          }, onReceiveStatus: null !== (c2 = null === (a2 = null == t2 ? void 0 : t2.onReceiveStatus) || void 0 === a2 ? void 0 : a2.bind(t2)) && void 0 !== c2 ? c2 : (e3) => {
          } };
          this.processingMetadata = true, this.requester.start(e2, u2, (e3, t3) => {
            var r3, n3, o3;
            let s3;
            if (this.processingMetadata = false, (0, i.isInterceptingListener)(t3)) s3 = t3;
            else {
              const e4 = { onReceiveMetadata: null !== (r3 = t3.onReceiveMetadata) && void 0 !== r3 ? r3 : l.onReceiveMetadata, onReceiveMessage: null !== (n3 = t3.onReceiveMessage) && void 0 !== n3 ? n3 : l.onReceiveMessage, onReceiveStatus: null !== (o3 = t3.onReceiveStatus) && void 0 !== o3 ? o3 : l.onReceiveStatus };
              s3 = new i.InterceptingListenerImpl(e4, u2);
            }
            this.nextCall.start(e3, s3), this.processPendingMessage(), this.processPendingHalfClose();
          });
        }
        sendMessageWithContext(e2, t2) {
          this.processingMessage = true, this.requester.sendMessage(t2, (r2) => {
            this.processingMessage = false, this.processingMetadata ? (this.pendingMessageContext = e2, this.pendingMessage = t2) : (this.nextCall.sendMessageWithContext(e2, r2), this.processPendingHalfClose());
          });
        }
        sendMessage(e2) {
          this.sendMessageWithContext({}, e2);
        }
        startRead() {
          this.nextCall.startRead();
        }
        halfClose() {
          this.requester.halfClose(() => {
            this.processingMetadata || this.processingMessage ? this.pendingHalfClose = true : this.nextCall.halfClose();
          });
        }
      };
      class u {
        constructor(e2, t2) {
          this.call = e2, this.methodDefinition = t2;
        }
        cancelWithStatus(e2, t2) {
          this.call.cancelWithStatus(e2, t2);
        }
        getPeer() {
          return this.call.getPeer();
        }
        sendMessageWithContext(e2, t2) {
          let r2;
          try {
            r2 = this.methodDefinition.requestSerialize(t2);
          } catch (e3) {
            return void this.call.cancelWithStatus(o.Status.INTERNAL, `Request message serialization failure: ${(0, s.getErrorMessage)(e3)}`);
          }
          this.call.sendMessageWithContext(e2, r2);
        }
        sendMessage(e2) {
          this.sendMessageWithContext({}, e2);
        }
        start(e2, t2) {
          let r2 = null;
          this.call.start(e2, { onReceiveMetadata: (e3) => {
            var r3;
            null === (r3 = null == t2 ? void 0 : t2.onReceiveMetadata) || void 0 === r3 || r3.call(t2, e3);
          }, onReceiveMessage: (e3) => {
            var i2;
            let a2;
            try {
              a2 = this.methodDefinition.responseDeserialize(e3);
            } catch (e4) {
              return r2 = { code: o.Status.INTERNAL, details: `Response message parsing error: ${(0, s.getErrorMessage)(e4)}`, metadata: new n.Metadata() }, void this.call.cancelWithStatus(r2.code, r2.details);
            }
            null === (i2 = null == t2 ? void 0 : t2.onReceiveMessage) || void 0 === i2 || i2.call(t2, a2);
          }, onReceiveStatus: (e3) => {
            var n2, i2;
            r2 ? null === (n2 = null == t2 ? void 0 : t2.onReceiveStatus) || void 0 === n2 || n2.call(t2, r2) : null === (i2 = null == t2 ? void 0 : t2.onReceiveStatus) || void 0 === i2 || i2.call(t2, e3);
          } });
        }
        startRead() {
          this.call.startRead();
        }
        halfClose() {
          this.call.halfClose();
        }
      }
      class d extends u {