/*
 * Decompiled with CFR 0.152.
 */
package org.typelevel.log4cats.slf4j.internal;

import cats.effect.kernel.Sync;
import cats.effect.package$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.log4cats.slf4j.internal.Slf4jLoggerInternal$;
import org.typelevel.log4cats.slf4j.internal.Slf4jLoggerInternal$Slf4jLogger$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public final class Slf4jLoggerInternal {
    public static boolean singletonsByName() {
        return Slf4jLoggerInternal$.MODULE$.singletonsByName();
    }

    public static boolean trailingDollar() {
        return Slf4jLoggerInternal$.MODULE$.trailingDollar();
    }

    public static interface LevelLogger<F> {
        public F isEnabled();

        public F apply(Function0<String> var1);

        public F apply(Throwable var1, Function0<String> var2);
    }

    public static final class Slf4jLogger<F>
    implements SelfAwareStructuredLogger<F> {
        private final Logger logger;
        private final Sync.Type sync;
        private final Map<String, String> defaultCtx;
        private final Sync<F> F;
        private final Function0<Object> isTraceEnabledUnsafe;
        private final Function0<Object> isDebugEnabledUnsafe;
        private final Function0<Object> isInfoEnabledUnsafe;
        private final Function0<Object> isWarnEnabledUnsafe;
        private final Function0<Object> isErrorEnabledUnsafe;

        public static <F> Sync.Type $lessinit$greater$default$2() {
            return Slf4jLoggerInternal$Slf4jLogger$.MODULE$.$lessinit$greater$default$2();
        }

        public Slf4jLogger(Logger logger, Sync.Type sync, Map<String, String> defaultCtx, Sync<F> F) {
            this.logger = logger;
            this.sync = sync;
            this.defaultCtx = defaultCtx;
            this.F = F;
            this.isTraceEnabledUnsafe = (Function0 & Serializable)() -> logger.isTraceEnabled();
            this.isDebugEnabledUnsafe = (Function0 & Serializable)() -> logger.isDebugEnabled();
            this.isInfoEnabledUnsafe = (Function0 & Serializable)() -> logger.isInfoEnabled();
            this.isWarnEnabledUnsafe = (Function0 & Serializable)() -> logger.isWarnEnabled();
            this.isErrorEnabledUnsafe = (Function0 & Serializable)() -> logger.isErrorEnabled();
        }

        public Logger logger() {
            return this.logger;
        }

        public Slf4jLogger(Logger logger, Sync.Type sync, Sync<F> F) {
            this(logger, sync, (Map<String, String>)Predef$.MODULE$.Map().empty(), F);
        }

        public Slf4jLogger(Logger logger, Sync<F> F) {
            package$.MODULE$.Sync();
            this(logger, (Sync.Type)Sync.Type$.Delay$.MODULE$, F);
        }

        public SelfAwareStructuredLogger<F> addContext(Map<String, String> ctx) {
            return new Slf4jLogger<F>(this.logger(), this.sync, (Map<String, String>)((Map)this.defaultCtx.$plus$plus(ctx)), this.F);
        }

        public F isTraceEnabled() {
            return (F)this.F.delay(this::isTraceEnabled$$anonfun$1);
        }

        public F isDebugEnabled() {
            return (F)this.F.delay(this::isDebugEnabled$$anonfun$1);
        }

        public F isInfoEnabled() {
            return (F)this.F.delay(this::isInfoEnabled$$anonfun$1);
        }

        public F isWarnEnabled() {
            return (F)this.F.delay(this::isWarnEnabled$$anonfun$1);
        }

        public F isErrorEnabled() {
            return (F)this.F.delay(this::isErrorEnabled$$anonfun$1);
        }

        public F trace(Throwable t, Function0<String> msg) {
            return this.noContextLog(this.isTraceEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().trace((String)msg.apply(), t));
        }

        public F trace(Function0<String> msg) {
            return this.noContextLog(this.isTraceEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().trace((String)msg.apply()));
        }

        public F trace(Map<String, String> ctx, Function0<String> msg) {
            return this.contextLog(this.isTraceEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().trace((String)msg.apply()));
        }

        public F trace(Map<String, String> ctx, Throwable t, Function0<String> msg) {
            return this.contextLog(this.isTraceEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().trace((String)msg.apply(), t));
        }

        public F debug(Throwable t, Function0<String> msg) {
            return this.noContextLog(this.isDebugEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().debug((String)msg.apply(), t));
        }

        public F debug(Function0<String> msg) {
            return this.noContextLog(this.isDebugEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().debug((String)msg.apply()));
        }

        public F debug(Map<String, String> ctx, Function0<String> msg) {
            return this.contextLog(this.isDebugEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().debug((String)msg.apply()));
        }

        public F debug(Map<String, String> ctx, Throwable t, Function0<String> msg) {
            return this.contextLog(this.isDebugEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().debug((String)msg.apply(), t));
        }

        public F info(Throwable t, Function0<String> msg) {
            return this.noContextLog(this.isInfoEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().info((String)msg.apply(), t));
        }

        public F info(Function0<String> msg) {
            return this.noContextLog(this.isInfoEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().info((String)msg.apply()));
        }

        public F info(Map<String, String> ctx, Function0<String> msg) {
            return this.contextLog(this.isInfoEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().info((String)msg.apply()));
        }

        public F info(Map<String, String> ctx, Throwable t, Function0<String> msg) {
            return this.contextLog(this.isInfoEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().info((String)msg.apply(), t));
        }

        public F warn(Throwable t, Function0<String> msg) {
            return this.noContextLog(this.isWarnEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().warn((String)msg.apply(), t));
        }

        public F warn(Function0<String> msg) {
            return this.noContextLog(this.isWarnEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().warn((String)msg.apply()));
        }

        public F warn(Map<String, String> ctx, Function0<String> msg) {
            return this.contextLog(this.isWarnEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().warn((String)msg.apply()));
        }

        public F warn(Map<String, String> ctx, Throwable t, Function0<String> msg) {
            return this.contextLog(this.isWarnEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().warn((String)msg.apply(), t));
        }

        public F error(Throwable t, Function0<String> msg) {
            return this.noContextLog(this.isErrorEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().error((String)msg.apply(), t));
        }

        public F error(Function0<String> msg) {
            return this.noContextLog(this.isErrorEnabledUnsafe, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().error((String)msg.apply()));
        }

        public F error(Map<String, String> ctx, Function0<String> msg) {
            return this.contextLog(this.isErrorEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().error((String)msg.apply()));
        }

        public F error(Map<String, String> ctx, Throwable t, Function0<String> msg) {
            return this.contextLog(this.isErrorEnabledUnsafe, ctx, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.logger().error((String)msg.apply(), t));
        }

        private <A> A withPreparedMDCUnsafe(Map<String, String> extraCtx, Function0<A> body) {
            Object object;
            java.util.Map map;
            Map ctx = (Map)this.defaultCtx.$plus$plus(extraCtx);
            try {
                map = MDC.getCopyOfContextMap();
            }
            catch (IllegalStateException e) {
                body.apply();
                throw e;
            }
            java.util.Map backup = map;
            try {
                MDC.clear();
                ctx.foreach((Function1)((JProcedure1 & Serializable)Slf4jLoggerInternal$::org$typelevel$log4cats$slf4j$internal$Slf4jLoggerInternal$Slf4jLogger$$_$withPreparedMDCUnsafe$$anonfun$1));
                object = body.apply();
            }
            finally {
                if (backup == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((java.util.Map)backup);
                }
            }
            return (A)object;
        }

        private F noContextLog(Function0<Object> isEnabledUnsafe, Function0<BoxedUnit> logging) {
            return this.contextLog(isEnabledUnsafe, (Map<String, String>)Predef$.MODULE$.Map().empty(), logging);
        }

        private F contextLog(Function0<Object> isEnabledUnsafe, Map<String, String> ctx, Function0<BoxedUnit> logging) {
            return (F)this.F.delay((Function0 & Serializable)() -> {
                this.contextLog$$anonfun$1(ctx, isEnabledUnsafe, logging);
                return BoxedUnit.UNIT;
            });
        }

        private final boolean isTraceEnabled$$anonfun$1() {
            return BoxesRunTime.unboxToBoolean((Object)this.withPreparedMDCUnsafe((Map<String, String>)Predef$.MODULE$.Map().empty(), this.isTraceEnabledUnsafe));
        }

        private final boolean isDebugEnabled$$anonfun$1() {
            return BoxesRunTime.unboxToBoolean((Object)this.withPreparedMDCUnsafe((Map<String, String>)Predef$.MODULE$.Map().empty(), this.isDebugEnabledUnsafe));
        }

        private final boolean isInfoEnabled$$anonfun$1() {
            return BoxesRunTime.unboxToBoolean((Object)this.withPreparedMDCUnsafe((Map<String, String>)Predef$.MODULE$.Map().empty(), this.isInfoEnabledUnsafe));
        }

        private final boolean isWarnEnabled$$anonfun$1() {
            return BoxesRunTime.unboxToBoolean((Object)this.withPreparedMDCUnsafe((Map<String, String>)Predef$.MODULE$.Map().empty(), this.isWarnEnabledUnsafe));
        }

        private final boolean isErrorEnabled$$anonfun$1() {
            return BoxesRunTime.unboxToBoolean((Object)this.withPreparedMDCUnsafe((Map<String, String>)Predef$.MODULE$.Map().empty(), this.isErrorEnabledUnsafe));
        }

        private final void contextLog$$anonfun$1(Map ctx$1, Function0 isEnabledUnsafe$1, Function0 logging$1) {
            this.withPreparedMDCUnsafe((Map<String, String>)ctx$1, (Function0)((JFunction0.mcV.sp & Serializable)() -> Slf4jLoggerInternal$.org$typelevel$log4cats$slf4j$internal$Slf4jLoggerInternal$Slf4jLogger$$_$contextLog$$anonfun$1$$anonfun$1(isEnabledUnsafe$1, logging$1)));
        }
    }
}

