/*
 * Decompiled with CFR 0.152.
 */
package fs2.hashing;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.hashing.Hash;
import fs2.hashing.HashAlgorithm;
import fs2.hashing.HashAlgorithm$MD5$;
import fs2.hashing.HashAlgorithm$SHA1$;
import fs2.hashing.HashAlgorithm$SHA224$;
import fs2.hashing.HashAlgorithm$SHA256$;
import fs2.hashing.HashAlgorithm$SHA384$;
import fs2.hashing.HashAlgorithm$SHA3_224$;
import fs2.hashing.HashAlgorithm$SHA3_256$;
import fs2.hashing.HashAlgorithm$SHA3_384$;
import fs2.hashing.HashAlgorithm$SHA3_512$;
import fs2.hashing.HashAlgorithm$SHA512$;
import fs2.hashing.HashAlgorithm$SHA512_224$;
import fs2.hashing.HashAlgorithm$SHA512_256$;
import fs2.hashing.Hasher;
import fs2.hashing.SyncHasher;
import java.io.Serializable;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import scala.Function0;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0003\u0006\f!\u0003\r\taC\b\t\u000bY\u0001A\u0011\u0001\r\t\rq\u0001A\u0011A\u0006\u001e\u0011\u0019q\u0005\u0001\"\u0001\f\u001f\"1Q\r\u0001C\u0001\u0017\u0019DaA\u001d\u0001\u0005\u0002-\u0019\bBB?\u0001\t\u0003Ya\u0010\u0003\u0005\u0002\u0018\u0001!\taCA\r\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\u0013\u0001\t\u0003\tYEA\fICNDWM]\"p[B\fg.[8o!2\fGOZ8s[*\u0011A\"D\u0001\bQ\u0006\u001c\b.\u001b8h\u0015\u0005q\u0011a\u00014teM\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%\u0007\u0001!\u0012!\u0007\t\u0003#iI!a\u0007\n\u0003\tUs\u0017\u000e^\u0001\u0006CB\u0004H._\u000b\u0003=Q\"\"aH%\u0015\u0005\u0001\"\u0005\u0003B\u00110e\u0001s!A\t\u0017\u000f\u0005\rJcB\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0018\u0003\u0019a$o\\8u}%\t\u0001&\u0001\u0003dCR\u001c\u0018B\u0001\u0016,\u0003\u0019)gMZ3di*\t\u0001&\u0003\u0002.]\u00059\u0001/Y2lC\u001e,'B\u0001\u0016,\u0013\t\u0001\u0014G\u0001\u0005SKN|WO]2f\u0015\tic\u0006\u0005\u00024i1\u0001A!B\u001b\u0003\u0005\u00041$!\u0001$\u0016\u0005]r\u0014C\u0001\u001d<!\t\t\u0012(\u0003\u0002;%\t9aj\u001c;iS:<\u0007CA\t=\u0013\ti$CA\u0002B]f$Qa\u0010\u001bC\u0002]\u0012\u0011a\u0018\t\u0004\u0003\n\u0013T\"A\u0006\n\u0005\r[!A\u0002%bg\",'\u000fC\u0004F\u0005\u0005\u0005\t9\u0001$\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002\"\u000fJJ!\u0001S\u0019\u0003\tMKhn\u0019\u0005\u0006\u0015\n\u0001\raS\u0001\nC2<wN]5uQ6\u0004\"!\u0011'\n\u00055[!!\u0004%bg\"\fEnZ8sSRDW.\u0001\u0003i[\u0006\u001cWC\u0001)U)\r\t6\f\u0018\u000b\u0003%b\u0003B!I\u0018T/B\u00111\u0007\u0016\u0003\u0006k\r\u0011\r!V\u000b\u0003oY#Qa\u0010+C\u0002]\u00022!\u0011\"T\u0011\u001dI6!!AA\u0004i\u000b!\"\u001a<jI\u0016t7-\u001a\u00133!\r\tsi\u0015\u0005\u0006\u0015\u000e\u0001\ra\u0013\u0005\u0006;\u000e\u0001\rAX\u0001\u0004W\u0016L\bcA0aE6\tQ\"\u0003\u0002b\u001b\t)1\t[;oWB\u0011\u0011cY\u0005\u0003IJ\u0011AAQ=uK\u00061QO\\:bM\u0016,\"aZ6\u0015\u0005!\fHCA5o!\r\t%I\u001b\t\u0003g-$Q!\u000e\u0003C\u00021,\"aN7\u0005\u000b}Z'\u0019A\u001c\t\u000f=$\u0011\u0011!a\u0002a\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u0007\u0005:%\u000eC\u0003K\t\u0001\u00071*A\tu_\u0006cwm\u001c:ji\"l7\u000b\u001e:j]\u001e$\"\u0001\u001e?\u0011\u0005ULhB\u0001<x!\t!##\u0003\u0002y%\u00051\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tA(\u0003C\u0003K\u000b\u0001\u00071*\u0001\u0006v]N\fg-\u001a%nC\u000e,2a`A\u0004)\u0019\t\t!a\u0005\u0002\u0016Q!\u00111AA\u0007!\u0011\t%)!\u0002\u0011\u0007M\n9\u0001\u0002\u00046\r\t\u0007\u0011\u0011B\u000b\u0004o\u0005-AAB \u0002\b\t\u0007q\u0007C\u0005\u0002\u0010\u0019\t\t\u0011q\u0001\u0002\u0012\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\t\u0005:\u0015Q\u0001\u0005\u0006\u0015\u001a\u0001\ra\u0013\u0005\u0006;\u001a\u0001\rAX\u0001\u0015i>l\u0015mY!mO>\u0014\u0018\u000e\u001e5n'R\u0014\u0018N\\4\u0015\u0007Q\fY\u0002C\u0003K\u000f\u0001\u00071*A\fv]N\fg-\u001a$s_6lUm]:bO\u0016$\u0015nZ3tiV!\u0011\u0011EA\u0015)\u0011\t\u0019#!\u000e\u0015\t\u0005\u0015\u0012q\u0006\t\u0005\u0003\n\u000b9\u0003E\u00024\u0003S!a!\u000e\u0005C\u0002\u0005-RcA\u001c\u0002.\u00111q(!\u000bC\u0002]B\u0011\"!\r\t\u0003\u0003\u0005\u001d!a\r\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007\u0005\u0003\"\u000f\u0006\u001d\u0002bBA\u001c\u0011\u0001\u0007\u0011\u0011H\u0001\u0002IB!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u0005\r\u0013\u0001\u00026bm\u0006LA!a\u0012\u0002>\tiQ*Z:tC\u001e,G)[4fgR\fQ\"\u001e8tC\u001a,gI]8n\u001b\u0006\u001cW\u0003BA'\u0003+\"B!a\u0014\u0002bQ!\u0011\u0011KA.!\u0011\t%)a\u0015\u0011\u0007M\n)\u0006\u0002\u00046\u0013\t\u0007\u0011qK\u000b\u0004o\u0005eCAB \u0002V\t\u0007q\u0007C\u0005\u0002^%\t\t\u0011q\u0001\u0002`\u0005QQM^5eK:\u001cW\r\n\u001c\u0011\t\u0005:\u00151\u000b\u0005\b\u0003oI\u0001\u0019AA2!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\naa\u0019:zaR|'BAA7\u0003\u0015Q\u0017M^1y\u0013\u0011\t\t(a\u001a\u0003\u00075\u000b7\r")
public interface HasherCompanionPlatform {
    public static /* synthetic */ Resource apply$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Sync evidence$1) {
        return $this.apply(algorithm, evidence$1);
    }

    default public <F> Resource<F, Hasher<F>> apply(HashAlgorithm algorithm, Sync<F> evidence$1) {
        return package$.MODULE$.Resource().eval(package$.MODULE$.Sync().apply(evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> this.unsafe(algorithm, evidence$1)));
    }

    public static /* synthetic */ Resource hmac$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Chunk key, Sync evidence$2) {
        return $this.hmac(algorithm, key, evidence$2);
    }

    default public <F> Resource<F, Hasher<F>> hmac(HashAlgorithm algorithm, Chunk<Object> key, Sync<F> evidence$2) {
        return package$.MODULE$.Resource().eval(package$.MODULE$.Sync().apply(evidence$2).delay((Function0 & Serializable & scala.Serializable)() -> this.unsafeHmac(algorithm, key, evidence$2)));
    }

    public static /* synthetic */ Hasher unsafe$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Sync evidence$3) {
        return $this.unsafe(algorithm, evidence$3);
    }

    default public <F> Hasher<F> unsafe(HashAlgorithm algorithm, Sync<F> evidence$3) {
        return this.unsafeFromMessageDigest(MessageDigest.getInstance(this.toAlgorithmString(algorithm)), evidence$3);
    }

    public static /* synthetic */ String toAlgorithmString$(HasherCompanionPlatform $this, HashAlgorithm algorithm) {
        return $this.toAlgorithmString(algorithm);
    }

    default public String toAlgorithmString(HashAlgorithm algorithm) {
        HashAlgorithm hashAlgorithm = algorithm;
        if (HashAlgorithm$MD5$.MODULE$.equals(hashAlgorithm)) {
            return "MD5";
        }
        if (HashAlgorithm$SHA1$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-1";
        }
        if (HashAlgorithm$SHA224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-224";
        }
        if (HashAlgorithm$SHA256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-256";
        }
        if (HashAlgorithm$SHA384$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-384";
        }
        if (HashAlgorithm$SHA512$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512";
        }
        if (HashAlgorithm$SHA512_224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512/224";
        }
        if (HashAlgorithm$SHA512_256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA-512/256";
        }
        if (HashAlgorithm$SHA3_224$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-224";
        }
        if (HashAlgorithm$SHA3_256$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-256";
        }
        if (HashAlgorithm$SHA3_384$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-384";
        }
        if (HashAlgorithm$SHA3_512$.MODULE$.equals(hashAlgorithm)) {
            return "SHA3-512";
        }
        if (hashAlgorithm instanceof HashAlgorithm.Named) {
            HashAlgorithm.Named named = (HashAlgorithm.Named)hashAlgorithm;
            String name = named.name();
            return name;
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("unsupported algorithm ").append(hashAlgorithm).toString());
    }

    public static /* synthetic */ Hasher unsafeHmac$(HasherCompanionPlatform $this, HashAlgorithm algorithm, Chunk key, Sync evidence$4) {
        return $this.unsafeHmac(algorithm, key, evidence$4);
    }

    default public <F> Hasher<F> unsafeHmac(HashAlgorithm algorithm, Chunk<Object> key, Sync<F> evidence$4) {
        String name = this.toMacAlgorithmString(algorithm);
        Mac mac = Mac.getInstance(name);
        mac.init(new SecretKeySpec((byte[])key.toArray(ClassTag$.MODULE$.Byte()), name));
        return this.unsafeFromMac(mac, evidence$4);
    }

    public static /* synthetic */ String toMacAlgorithmString$(HasherCompanionPlatform $this, HashAlgorithm algorithm) {
        return $this.toMacAlgorithmString(algorithm);
    }

    default public String toMacAlgorithmString(HashAlgorithm algorithm) {
        HashAlgorithm hashAlgorithm = algorithm;
        if (HashAlgorithm$MD5$.MODULE$.equals(hashAlgorithm)) {
            return "HmacMD5";
        }
        if (HashAlgorithm$SHA1$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA1";
        }
        if (HashAlgorithm$SHA224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA224";
        }
        if (HashAlgorithm$SHA256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA256";
        }
        if (HashAlgorithm$SHA384$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA384";
        }
        if (HashAlgorithm$SHA512$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512";
        }
        if (HashAlgorithm$SHA512_224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512/224";
        }
        if (HashAlgorithm$SHA512_256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA512/256";
        }
        if (HashAlgorithm$SHA3_224$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-224";
        }
        if (HashAlgorithm$SHA3_256$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-256";
        }
        if (HashAlgorithm$SHA3_384$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-384";
        }
        if (HashAlgorithm$SHA3_512$.MODULE$.equals(hashAlgorithm)) {
            return "HmacSHA3-512";
        }
        if (hashAlgorithm instanceof HashAlgorithm.Named) {
            HashAlgorithm.Named named = (HashAlgorithm.Named)hashAlgorithm;
            String name = named.name();
            return name;
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("unsupported algorithm ").append(hashAlgorithm).toString());
    }

    public static /* synthetic */ Hasher unsafeFromMessageDigest$(HasherCompanionPlatform $this, MessageDigest d, Sync evidence$5) {
        return $this.unsafeFromMessageDigest(d, evidence$5);
    }

    default public <F> Hasher<F> unsafeFromMessageDigest(MessageDigest d, Sync<F> evidence$5) {
        return new SyncHasher<F>(null, evidence$5, d){
            private final MessageDigest d$1;

            public void unsafeUpdate(Chunk<Object> chunk) {
                Chunk.ArraySlice<O2> slice = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                this.d$1.update((byte[])slice.values(), slice.offset(), slice.size());
            }

            public Hash unsafeHash() {
                return new Hash(Chunk$.MODULE$.array(this.d$1.digest(), ClassTag$.MODULE$.Byte()));
            }
            {
                this.d$1 = d$1;
                super(evidence$5$1);
            }
        };
    }

    public static /* synthetic */ Hasher unsafeFromMac$(HasherCompanionPlatform $this, Mac d, Sync evidence$6) {
        return $this.unsafeFromMac(d, evidence$6);
    }

    default public <F> Hasher<F> unsafeFromMac(Mac d, Sync<F> evidence$6) {
        return new SyncHasher<F>(null, evidence$6, d){
            private final Mac d$2;

            public void unsafeUpdate(Chunk<Object> chunk) {
                Chunk.ArraySlice<O2> slice = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                this.d$2.update((byte[])slice.values(), slice.offset(), slice.size());
            }

            public Hash unsafeHash() {
                return new Hash(Chunk$.MODULE$.array(this.d$2.doFinal(), ClassTag$.MODULE$.Byte()));
            }
            {
                this.d$2 = d$2;
                super(evidence$6$1);
            }
        };
    }

    public static void $init$(HasherCompanionPlatform $this) {
    }
}

