/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import cats.Show;
import cats.Show$;
import cats.kernel.Order;
import cats.package$;
import com.comcast.ip4s.Cidr;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.Ipv6Address$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class Cidr$
implements scala.Serializable {
    public static Cidr$ MODULE$;
    private final Regex CidrPattern;

    static {
        new Cidr$();
    }

    public <A extends IpAddress> Cidr<A> apply(A address, int prefixBits) {
        int maxPrefixBits = BoxesRunTime.unboxToInt(address.fold((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)Cidr$.$anonfun$apply$1(x$9)), (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)Cidr$.$anonfun$apply$2(x$10))));
        int b = prefixBits < 0 ? 0 : (prefixBits > maxPrefixBits ? maxPrefixBits : prefixBits);
        return new Cidr<A>(address, b);
    }

    public <A extends IpAddress> Cidr<A> fromIpAndMask(A address, A mask) {
        return address.$div(mask.prefixBits());
    }

    public Option<Cidr<IpAddress>> fromString(String value2) {
        return this.fromStringGeneral(value2, (Function1 & Serializable & scala.Serializable)value -> IpAddress$.MODULE$.fromString((String)value));
    }

    public Option<Cidr<Ipv4Address>> fromString4(String value2) {
        return this.fromStringGeneral(value2, (Function1 & Serializable & scala.Serializable)value -> Ipv4Address$.MODULE$.fromString((String)value));
    }

    public Option<Cidr<Ipv6Address>> fromString6(String value2) {
        return this.fromStringGeneral(value2, (Function1 & Serializable & scala.Serializable)value -> Ipv6Address$.MODULE$.fromString((String)value));
    }

    private Regex CidrPattern() {
        return this.CidrPattern;
    }

    private <A extends IpAddress> Option<Cidr<A>> fromStringGeneral(String value, Function1<String, Option<A>> parseAddress) {
        String string = value;
        Option option = this.CidrPattern().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String addrStr = (String)((LinearSeqOptimized)option.get()).apply(0);
            String prefixBitsStr = (String)((LinearSeqOptimized)option.get()).apply(1);
            return ((Option)parseAddress.apply((Object)addrStr)).flatMap((Function1 & Serializable & scala.Serializable)addr -> {
                int maxPrefixBits = BoxesRunTime.unboxToInt(addr.fold((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)Cidr$.$anonfun$fromStringGeneral$2(x$11)), (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)Cidr$.$anonfun$fromStringGeneral$3(x$12))));
                return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(prefixBitsStr)).toInt()).toOption().withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)prefixBits -> prefixBits >= 0 && prefixBits <= maxPrefixBits).map((Function1 & Serializable & scala.Serializable)prefixBits -> Cidr$.MODULE$.apply(addr, BoxesRunTime.unboxToInt((Object)prefixBits)));
            });
        }
        return None$.MODULE$;
    }

    public <A extends IpAddress> Order<Cidr<A>> order() {
        return package$.MODULE$.Order().fromOrdering(this.ordering());
    }

    public <A extends IpAddress> Ordering<Cidr<A>> ordering() {
        return scala.package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x.address(), (Object)BoxesRunTime.boxToInteger((int)x.prefixBits())), Ordering$.MODULE$.Tuple2(IpAddress$.MODULE$.ordering(), (Ordering)Ordering.Int$.MODULE$));
    }

    public <A extends IpAddress> Show<Cidr<A>> show() {
        return Show$.MODULE$.fromToString();
    }

    public <A extends IpAddress> Option<Tuple2<A, Object>> unapply(Cidr<A> c) {
        return new Some((Object)new Tuple2(c.address(), (Object)BoxesRunTime.boxToInteger((int)c.prefixBits())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$apply$1(Ipv4Address x$9) {
        return 32;
    }

    public static final /* synthetic */ int $anonfun$apply$2(Ipv6Address x$10) {
        return 128;
    }

    public static final /* synthetic */ int $anonfun$fromStringGeneral$2(Ipv4Address x$11) {
        return 32;
    }

    public static final /* synthetic */ int $anonfun$fromStringGeneral$3(Ipv6Address x$12) {
        return 128;
    }

    private Cidr$() {
        MODULE$ = this;
        this.CidrPattern = new StringOps(Predef$.MODULE$.augmentString("([^/]+)/(\\d+)")).r();
    }
}

