/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.adapter.formatter.IFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ITypeFormatter;
import com.microsoft.java.debug.core.adapter.formatter.IValueFormatter;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VariableFormatter
implements IVariableFormatter {
    private Map<IValueFormatter, Integer> valueFormatterMap = new HashMap<IValueFormatter, Integer>();
    private Map<ITypeFormatter, Integer> typeFormatterMap = new HashMap<ITypeFormatter, Integer>();

    private static IFormatter getFormatter(Map<? extends IFormatter, Integer> formatterMap, Type type, Map<String, Object> options) {
        List formatterList = formatterMap.keySet().stream().filter(t -> t.acceptType(type, options)).sorted((a, b) -> -Integer.compare((Integer)formatterMap.get(a), (Integer)formatterMap.get(b))).collect(Collectors.toList());
        if (formatterList.isEmpty()) {
            throw new UnsupportedOperationException(String.format("There is no related formatter for type %s.", type == null ? "null" : type.name()));
        }
        return (IFormatter)formatterList.get(0);
    }

    @Override
    public String typeToString(Type type, Map<String, Object> options) {
        IFormatter formatter = VariableFormatter.getFormatter(this.typeFormatterMap, type, options);
        return formatter.toString(type, options);
    }

    @Override
    public Map<String, Object> getDefaultOptions() {
        int count2;
        HashMap<String, Object> defaultOptions = new HashMap<String, Object>();
        int count1 = this.valueFormatterMap.keySet().stream().mapToInt(formatter -> this.mergeDefaultOptions((IFormatter)formatter, (Map<String, Object>)defaultOptions)).sum();
        if (count1 + (count2 = this.typeFormatterMap.keySet().stream().mapToInt(formatter -> this.mergeDefaultOptions((IFormatter)formatter, (Map<String, Object>)defaultOptions)).sum()) != defaultOptions.size()) {
            throw new IllegalStateException("There is some configuration conflicts on type and value formatters.");
        }
        return defaultOptions;
    }

    @Override
    public String valueToString(Value value, Map<String, Object> options) {
        Type type = value == null ? null : value.type();
        IFormatter formatter = VariableFormatter.getFormatter(this.valueFormatterMap, type, options);
        return formatter.toString(value, options);
    }

    @Override
    public Value stringToValue(String stringValue, Type type, Map<String, Object> options) {
        IValueFormatter formatter = (IValueFormatter)VariableFormatter.getFormatter(this.valueFormatterMap, type, options);
        return formatter.valueOf(stringValue, type, options);
    }

    @Override
    public void registerValueFormatter(IValueFormatter formatter, int priority) {
        this.valueFormatterMap.put(formatter, priority);
    }

    @Override
    public void registerTypeFormatter(ITypeFormatter typeFormatter, int priority) {
        this.typeFormatterMap.put(typeFormatter, priority);
    }

    private int mergeDefaultOptions(IFormatter formatter, Map<String, Object> options) {
        int count = 0;
        for (Map.Entry<String, Object> entry : formatter.getDefaultOptions().entrySet()) {
            options.put(entry.getKey(), entry.getValue());
            ++count;
        }
        return count;
    }
}

