/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Variable {
    public Value value;
    public String name;
    public Field field;
    public LocalVariable local;
    public int argumentIndex;
    public String evaluateName;
    private boolean isUnboundedType = false;

    public Variable(String name, Value value) {
        this(name, value, name);
    }

    public Variable(String name, Value value, String evaluateName) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name is required for a java variable.");
        }
        this.name = name;
        this.value = value;
        this.argumentIndex = -1;
        this.evaluateName = evaluateName;
    }

    public Type getDeclaringType() {
        if (this.field != null) {
            return this.field.declaringType();
        }
        return null;
    }

    public void setUnboundedType(boolean isUnboundedType) {
        this.isUnboundedType = isUnboundedType;
    }

    public boolean isUnboundedType() {
        if (this.isUnboundedType) {
            return true;
        }
        return this.field != null && Objects.equals(this.field.signature(), "Ljava/lang/Object;");
    }
}

