/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class DataBreakpointInfoRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.DATABREAKPOINTINFO);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        ObjectReference containerObj;
        ReferenceType type;
        Field field;
        Object container;
        Requests.DataBreakpointInfoArguments dataBpArgs = (Requests.DataBreakpointInfoArguments)arguments;
        if (dataBpArgs.variablesReference > 0 && (container = context.getRecyclableIdPool().getObjectById(dataBpArgs.variablesReference)) instanceof VariableProxy && !(((VariableProxy)container).getProxiedVariable() instanceof StackFrameReference) && (field = (type = (containerObj = (ObjectReference)((VariableProxy)container).getProxiedVariable()).referenceType()).fieldByName(dataBpArgs.name)) != null) {
            String fullyQualifiedName = type.name();
            String dataId = String.format("%s#%s", fullyQualifiedName, dataBpArgs.name);
            String description = String.format("%s.%s : %s", this.getSimpleName(fullyQualifiedName), dataBpArgs.name, this.getSimpleName(field.typeName()));
            response.body = new Responses.DataBreakpointInfoResponseBody(dataId, description, Types.DataBreakpointAccessType.values(), true);
        }
        return CompletableFuture.completedFuture(response);
    }

    private String getSimpleName(String typeName) {
        if (StringUtils.isBlank((CharSequence)typeName)) {
            return "";
        }
        String[] names = typeName.split("\\.");
        return names[names.length - 1];
    }
}

