/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.formatter;

import com.microsoft.java.debug.core.adapter.formatter.ITypeFormatter;
import com.sun.jdi.Type;
import java.util.HashMap;
import java.util.Map;

public class SimpleTypeFormatter
implements ITypeFormatter {
    public static final String QUALIFIED_CLASS_NAME_OPTION = "qualified_class_name";
    private static final boolean DEFAULT_QUALIFIED_CLASS_NAME_OPTION = false;

    @Override
    public String toString(Object type, Map<String, Object> options) {
        if (type == null) {
            return "null";
        }
        String typeName = ((Type)type).name();
        return SimpleTypeFormatter.showQualifiedClassName(options) ? typeName : SimpleTypeFormatter.trimTypeName(typeName);
    }

    @Override
    public boolean acceptType(Type type, Map<String, Object> options) {
        return true;
    }

    @Override
    public Map<String, Object> getDefaultOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(QUALIFIED_CLASS_NAME_OPTION, false);
        return options;
    }

    public static String trimTypeName(String type) {
        if (type.indexOf(46) >= 0) {
            type = type.substring(type.lastIndexOf(46) + 1);
        }
        return type;
    }

    private static boolean showQualifiedClassName(Map<String, Object> options) {
        return options.containsKey(QUALIFIED_CLASS_NAME_OPTION) ? (Boolean)options.get(QUALIFIED_CLASS_NAME_OPTION) : false;
    }
}

