/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import cats.Show;
import cats.Show$;
import cats.kernel.Order;
import cats.package$;
import com.comcast.ip4s.Cidr;
import com.comcast.ip4s.Cidr$Strict$;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.Ipv6Address$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class Cidr$
implements Serializable {
    public static final Cidr$Strict$ Strict;
    private static final Regex CidrPattern;
    public static final Cidr$ MODULE$;

    private Cidr$() {
    }

    static {
        MODULE$ = new Cidr$();
        CidrPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^/]+)/(\\d+)"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Cidr$.class);
    }

    public <A extends IpAddress> Cidr<A> apply(A address, int prefixBits) {
        int maxPrefixBits = BoxesRunTime.unboxToInt(address.fold((Function1 & Serializable)_$9 -> 32, (Function1 & Serializable)_$10 -> 128));
        int b = prefixBits < 0 ? 0 : (prefixBits > maxPrefixBits ? maxPrefixBits : prefixBits);
        return new Cidr<A>(address, b);
    }

    public <A extends IpAddress> Cidr<A> fromIpAndMask(A address, A mask) {
        return address.$div(mask.prefixBits());
    }

    public Option<Cidr<IpAddress>> fromString(String value2) {
        return this.fromStringGeneral(value2, (Function1 & Serializable)value -> IpAddress$.MODULE$.fromString((String)value));
    }

    public Option<Cidr<Ipv4Address>> fromString4(String value2) {
        return this.fromStringGeneral(value2, (Function1 & Serializable)value -> Ipv4Address$.MODULE$.fromString((String)value));
    }

    public Option<Cidr<Ipv6Address>> fromString6(String value2) {
        return this.fromStringGeneral(value2, (Function1 & Serializable)value -> Ipv6Address$.MODULE$.fromString((String)value));
    }

    private <A extends IpAddress> Option<Cidr<A>> fromStringGeneral(String value, Function1<String, Option<A>> parseAddress) {
        List list;
        Option option;
        String string = value;
        if (string != null && !(option = CidrPattern.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
            String string2 = (String)list.apply(0);
            String string3 = (String)list.apply(1);
            String addrStr = string2;
            String prefixBitsStr = string3;
            return ((Option)parseAddress.apply((Object)addrStr)).map((Function1 & Serializable)addr -> {
                int maxPrefixBits = BoxesRunTime.unboxToInt(addr.fold((Function1 & Serializable)_$11 -> 32, (Function1 & Serializable)_$12 -> 128));
                return Tuple2$.MODULE$.apply(addr, (Object)BoxesRunTime.boxToInteger((int)maxPrefixBits));
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    IpAddress addr = (IpAddress)tuple2._1();
                    int maxPrefixBits = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return Try$.MODULE$.apply(() -> this.fromStringGeneral$$anonfun$2$$anonfun$1(prefixBitsStr)).toOption().withFilter((Function1)(JFunction1.mcZI.sp & Serializable)prefixBits -> prefixBits >= 0 && prefixBits <= maxPrefixBits).map((Function1 & Serializable)prefixBits -> this.fromStringGeneral$$anonfun$2$$anonfun$3(addr, BoxesRunTime.unboxToInt((Object)prefixBits)));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return None$.MODULE$;
    }

    public <A extends IpAddress> Order<Cidr<A>> order() {
        return package$.MODULE$.Order().fromOrdering(this.ordering());
    }

    public <A extends IpAddress> Ordering<Cidr<A>> ordering() {
        return scala.package$.MODULE$.Ordering().by((Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x.address(), (Object)BoxesRunTime.boxToInteger((int)x.prefixBits())), Ordering$.MODULE$.Tuple2(IpAddress$.MODULE$.ordering(), (Ordering)Ordering.Int$.MODULE$));
    }

    public <A extends IpAddress> Show<Cidr<A>> show() {
        return Show$.MODULE$.fromToString();
    }

    public <A extends IpAddress> Option<Tuple2<A, Object>> unapply(Cidr<A> c) {
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(c.address(), (Object)BoxesRunTime.boxToInteger((int)c.prefixBits())));
    }

    private final int fromStringGeneral$$anonfun$2$$anonfun$1(String prefixBitsStr$2) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(prefixBitsStr$2));
    }

    private final /* synthetic */ Cidr fromStringGeneral$$anonfun$2$$anonfun$3(IpAddress addr$1, int prefixBits) {
        return this.apply(addr$1, prefixBits);
    }
}

