/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.validation.schematron;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.daffodil.lib.api.ValidatorInitializationException;
import org.apache.daffodil.lib.xml.DFDLCatalogResolver$;
import org.apache.daffodil.validation.schematron.SchSource;
import org.apache.daffodil.validation.schematron.SchSource$;
import org.apache.daffodil.validation.schematron.Schematron$;
import org.apache.daffodil.validation.schematron.SchematronValidator;
import org.apache.daffodil.validation.schematron.SchematronValidator$;
import org.apache.daffodil.validation.schematron.SchematronValidator$ConfigKeys$;
import org.apache.daffodil.validation.schematron.Transforms$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;

public final class SchematronValidatorFactory$ {
    public static final SchematronValidatorFactory$ MODULE$ = new SchematronValidatorFactory$();

    public SchematronValidator makeValidator(Config config) {
        String string;
        if (!config.hasPath(SchematronValidator$.MODULE$.name())) {
            throw new ValidatorInitializationException("invalid configuration: missing schematron path");
        }
        ConfigValue schPathValue = config.getValue(SchematronValidator$.MODULE$.name());
        ConfigValueType configValueType = schPathValue.valueType();
        if (ConfigValueType.OBJECT.equals(configValueType)) {
            string = config.getString(SchematronValidator$ConfigKeys$.MODULE$.schPath());
        } else if (ConfigValueType.STRING.equals(configValueType)) {
            string = config.getString(SchematronValidator$.MODULE$.name());
        } else {
            throw new ValidatorInitializationException("invalid configuration: schematron path was not an object or string");
        }
        Path schPath = Paths.get(string, new String[0]);
        FileInputStream schStream = Files.exists(schPath, new LinkOption[0]) ? new FileInputStream(schPath.toFile()) : (InputStream)Option$.MODULE$.apply((Object)this.getClass().getClassLoader().getResourceAsStream(((Object)schPath).toString())).getOrElse((Function0 & Serializable)() -> {
            throw new ValidatorInitializationException(new StringBuilder(31).append("schematron resource not found: ").append(schPath).toString());
        });
        None$ svrlOutPath = config.hasPath(SchematronValidator$ConfigKeys$.MODULE$.svrlOutputFile()) ? new Some((Object)Paths.get(config.getString(SchematronValidator$ConfigKeys$.MODULE$.svrlOutputFile()), new String[0])) : None$.MODULE$;
        return this.makeValidator(schStream, ((Object)schPath).toString(), SchSource$.MODULE$.from(schPath), (Option<Path>)svrlOutPath);
    }

    public SchematronValidator makeValidator(InputStream schematron, String schematronId, SchSource srcfmt) {
        return this.makeValidator(schematron, schematronId, srcfmt, (Option<Path>)None$.MODULE$);
    }

    public SchematronValidator makeValidator(InputStream schematron, String schematronID, SchSource srcfmt, Option<Path> svrlPath) {
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        factory.setURIResolver((URIResolver)DFDLCatalogResolver$.MODULE$.get());
        Templates rules = Transforms$.MODULE$.from(schematron, schematronID, srcfmt, (TransformerFactory)factory);
        return new SchematronValidator(Schematron$.MODULE$.fromRules(rules), svrlPath);
    }

    private SchematronValidatorFactory$() {
    }
}

